"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const apg_lib_1 = require("apg-lib");
const grammar_js_1 = __importDefault(require("../grammar.js"));
const Yard_1 = require("./Yard");
const util_1 = require("./util");
const filter_1 = require("./filter");
const expression_1 = require("./expression");
const precedenceGroup_1 = require("./precedenceGroup");
const attributeGroup_1 = require("./attributeGroup");
const prefixLogicalExpression_1 = require("./prefixLogicalExpression");
const infixLogicalExpression_1 = require("./infixLogicalExpression");
const infixLogicalExpressionPredicate_1 = require("./infixLogicalExpressionPredicate");
const infixLogicalExpressionOperator_1 = require("./infixLogicalExpressionOperator");
const postfixAssertion_1 = require("./postfixAssertion");
const postfixAssertionOperator_1 = require("./postfixAssertionOperator");
const infixAssertion_1 = require("./infixAssertion");
const infixAssertionOperator_1 = require("./infixAssertionOperator");
const infixAssertionValue_1 = require("./infixAssertionValue");
const attributePath_1 = require("./attributePath");
const attributePathSegment_1 = require("./attributePathSegment");
const grammar = new grammar_js_1.default();
const parser = new apg_lib_1.parser();
parser.ast = new apg_lib_1.ast();
parser.ast.callbacks = {
    filter: filter_1.filter,
    expression: expression_1.expression,
    precedenceGroup: precedenceGroup_1.precedenceGroup,
    attributeGroup: attributeGroup_1.attributeGroup,
    prefixLogicalExpression: prefixLogicalExpression_1.prefixLogicalExpression,
    infixLogicalExpression: infixLogicalExpression_1.infixLogicalExpression,
    infixLogicalExpressionPredicate: infixLogicalExpressionPredicate_1.infixLogicalExpressionPredicate,
    infixLogicalExpressionOperator: infixLogicalExpressionOperator_1.infixLogicalExpressionOperator,
    postfixAssertion: postfixAssertion_1.postfixAssertion,
    postfixAssertionOperator: postfixAssertionOperator_1.postfixAssertionOperator,
    infixAssertion: infixAssertion_1.infixAssertion,
    infixAssertionOperator: infixAssertionOperator_1.infixAssertionOperator,
    infixAssertionValue: infixAssertionValue_1.infixAssertionValue,
    attributePath: attributePath_1.attributePath,
    attributePathSegment: attributePathSegment_1.attributePathSegment
};
function compileFilter(input) {
    // Parse the filter
    const parseResult = parser.parse(grammar, "filter", input);
    if (!parseResult.success) {
        throw new Error("Failed to parse!");
    }
    // Compile the filter
    const yard = new Yard_1.Yard();
    parser.ast.translate(yard);
    if (yard.tracks.filter.length !== 1) {
        throw new Error(`INVARIANT: Expected 1 filter, but got ${yard.tracks.filter.length};`);
    }
    return yard.tracks.filter[0];
}
exports.compileFilter = compileFilter;
function parseAttributePath(input) {
    // Parse the attributePath
    const parseResult = parser.parse(grammar, "attributePath", input);
    if (!parseResult.success) {
        throw new Error("Failed to parse!");
    }
    // Compile the attributePath
    const yard = new Yard_1.Yard();
    parser.ast.translate(yard);
    if (yard.tracks.attributePath.length !== 1) {
        throw new Error(`INVARIANT: Expected 1 attributePath, but got ${yard.tracks.attributePath.length};`);
    }
    return yard.tracks.attributePath[0];
}
exports.parseAttributePath = parseAttributePath;
function compileSorter(input) {
    const path = parseAttributePath(input);
    return (objectA, objectB) => {
        const a = util_1.extractSortValue(path, objectA);
        const b = util_1.extractSortValue(path, objectB);
        if (a === b) {
            return 0;
        }
        if (a === undefined || a === null) {
            return -1;
        }
        if (b === undefined || b === null) {
            return 1;
        }
        if (typeof a === typeof b) {
            return a > b ? 1 : a < b ? -1 : 0;
        }
        if (typeof a === "boolean") {
            return -1;
        }
        if (typeof b === "boolean") {
            return 1;
        }
        if (typeof a === "number") {
            return -1;
        }
        if (typeof b === "number") {
            return 1;
        }
        return 0;
    };
}
exports.compileSorter = compileSorter;
//# sourceMappingURL=index.js.map