export declare class LambdaQueryFilter {
    /** join multiple filters together with a logical NOT */
    static not(...filters: LambdaQueryFilter[]): LambdaQueryFilter;
    /** join multiple filters together with a logical OR */
    static or(...filters: LambdaQueryFilter[]): LambdaQueryFilter;
    /** join multiple filters together with a logical AND */
    static and(...filters: LambdaQueryFilter[]): LambdaQueryFilter;
    private static join;
    private expressions;
    private mode;
    /** append a new filter to this query using a logical AND */
    and(...filters: LambdaQueryFilter[]): this;
    /** append a new filter to this query using a logical OR */
    or(...filters: LambdaQueryFilter[]): this;
    /** append a new filter to this query using a logical NOT */
    not(...filters: LambdaQueryFilter[]): this;
    /** apply the equals operator */
    eq(value: string): this;
    /** apply the not-equal operator */
    ne(value: string): this;
    /** apply the greater-than operator */
    gt(value: string): this;
    /** apply the less-than operator */
    lt(value: string): this;
    /** apply the greater-than-or-equal-to operator */
    ge(value: string): this;
    /** apply the less-than-or-equal-to operator */
    le(value: string): this;
    /** apply the search.in filter */
    in(values: string[], separator?: string): this;
    /** return filter as a string */
    toString(variable: string): string;
    private compare;
    private prepValue;
    private append;
    private isUnary;
}
