"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Base class for search resources
 */
class SearchResource {
    /**
     * Create new instance of the search resource
     * @param requester http handler
     * @param type the type of resource (should match /{resource}/ in the REST url path)
     * @param name the name of the current resource (should match /{resource}/{name} in the REST url path)
     */
    constructor(requester, type, name) {
        this.requester = requester;
        this.type = type;
        this.name = name;
    }
    get(optionsOrCallback, callback) {
        return this.request({
            method: 'get',
            path: '/',
        }, optionsOrCallback, callback);
    }
    delete(optionsOrCallback, callback) {
        return this.request({
            method: 'delete',
            path: '/',
        }, optionsOrCallback, callback);
    }
    update(resource, optionsOrCallback, callback) {
        return this.request({
            method: 'put',
            path: '/',
            body: resource,
        }, optionsOrCallback, callback);
    }
    request(req, optionsOrCallback, callback) {
        req.path = `/${this.type}/${this.name}${req.path}`;
        return this.requester.request(req, optionsOrCallback, callback);
    }
}
exports.SearchResource = SearchResource;
//# sourceMappingURL=search-resource.js.map