import { CharFilterName, PatternFlags, TokenFilterName, TokenizerName } from "..";
import { OData } from "../../..";

export type Analyzer = PatternAnalyzer | StandardAnalyzer | StopAnalyzer | CustomAnalyzer;
export type AnalyzerName = PrebuiltAnalyzerName | MicrosoftLanguageAnalyzerName | LuceneLanguageAnalyzerName | string;

export enum AnalyzerType {
  pattern = '#Microsoft.Azure.Search.PatternAnalyzer',
  standard = '#Microsoft.Azure.Search.StandardAnalyzer',
  stop = '#Microsoft.Azure.Search.StopAnalyzer',
  custom = '#Microsoft.Azure.Search.CustomAnalyzer',
}

export enum PrebuiltAnalyzerName {
  keyword = 'keyword',
  pattern = 'pattern',
  simple = 'simple',
  standard = 'standard.lucene',
  standardAsciiFolding = 'standardasciifolding.lucene',
  stop = 'stop',
  whitespace = 'whitespace',
}

export enum MicrosoftLanguageAnalyzerName {
  arabic = 'ar.microsoft',
  bangla = 'bn.microsoft',
  bulgarian = 'bg.microsoft',
  catalan = 'ca.microsoft',
  chineseSimplified = 'zh-Hans.microsoft',
  chineseTraditional = 'zh-Hant.microsoft',
  croatian = 'hr.microsoft',
  czech = 'cs.microsoft',
  danish = 'da.microsoft',
  dutch = 'nl.microsoft',
  english = 'en.microsoft',
  estonian = 'et.microsoft',
  finnish = 'fi.microsoft',
  french = 'fr.microsoft',
  german = 'de.microsoft',
  greek = 'el.microsoft',
  gujarati = 'gu.microsoft',
  hebrew = 'he.microsoft',
  hindi = 'hi.microsoft',
  hungarian = 'hu.microsoft',
  icelandic = 'is.microsoft',
  indonesian = 'id.microsoft',
  italian = 'it.microsoft',
  japanese = 'ja.microsoft',
  kannada = 'ka.microsoft',
  korean = 'ko.microsoft',
  latvian = 'lv.microsoft',
  lithuanian = 'lt.microsoft',
  malayalam = 'ml.microsoft',
  malay = 'ms.microsoft',
  marathi = 'mr.microsoft',
  norwegian = 'nb.microsoft',
  polish = 'pl.microsoft',
  portugueseBrazil = 'pt-Br.microsoft',
  portuguesePortugal = 'pt-Pt.microsoft',
  punjabi = 'pa.microsoft',
  romanian = 'ro.microsoft',
  russian = 'ru.microsoft',
  serbianCyrillic = 'sr-cyrillic.microsoft',
  serbianLatin = 'sr-latin.microsoft',
  slovak = 'sk.microsoft',
  slovenian = 'sl.microsoft',
  spanish = 'es.microsoft',
  swedish = 'sv.microsoft',
  tamil = 'ta.microsoft',
  telugu = 'te.microsoft',
  thai = 'th.microsoft',
  turkish = 'tr.microsoft',
  ukrainian = 'uk.microsoft',
  urdu = 'ur.microsoft',
  vietnamese = 'vi.microsoft',
}

export enum LuceneLanguageAnalyzerName {
  arabic = 'ar.lucene',
  armenian = 'hy.lucene',
  basque = 'eu.lucene',
  bulgarian = 'bg.lucene',
  catalan = 'ca.lucene',
  chineseSimplified = 'zh-Hans.lucene',
  chineseTraditional = 'zh-Hant.lucene',
  czech = 'cs.lucene',
  danish = 'da.lucene',
  dutch = 'nl.lucene',
  english = 'en.lucene',
  finnish = 'fi.lucene',
  french = 'fr.lucene',
  galician = 'gl.lucene',
  german = 'de.lucene',
  greek = 'el.lucene',
  hindi = 'hi.lucene',
  hungarian = 'hu.lucene',
  indonesian = 'id.lucene',
  irish = 'ga.lucene',
  italian = 'it.lucene',
  japanese = 'ja.lucene',
  korean = 'ko.lucene',
  latvian = 'lv.lucene',
  norwegian = 'no.lucene',
  persian = 'fa.lucene',
  polish = 'pl.lucene',
  portugueseBrazil = 'pt-Br.lucene',
  portuguesePortugal = 'pt-Pt.lucene',
  romanian = 'ro.lucene',
  russian = 'ru.lucene',
  spanish = 'es.lucene',
  swedish = 'sv.lucene',
  thai = 'th.lucene',
  turkish = 'tr.lucene',
}

export interface PatternAnalyzer extends OData<AnalyzerType.pattern> {
  lowercase?: boolean;
  pattern?: string;
  flags?: PatternFlags;
  stopwords?: string[];
}

export interface StandardAnalyzer extends OData<AnalyzerType.standard> {
  maxTokenLength?: number;
  stopwords?: string[];
}

export interface StopAnalyzer extends OData<AnalyzerType.stop> {
  stopwords?: string[];
}

export interface CustomAnalyzer extends OData<AnalyzerType.custom> {
  charFilters: CharFilterName[];
  tokenizer: TokenizerName[];
  tokenFilters: TokenFilterName[];
}
