/* global Opal, Asciidoctor, ASCIIDOCTOR_JS_VERSION */
const Opal = require('asciidoctor-opal-runtime').Opal

// Node module
;(function (root, factory) {
  module.exports = factory
  // default export for ES6 module interop
  module.exports.default = factory
}(this, function (moduleConfig) {
/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/opal_ext/electron/io"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $send = Opal.send, $gvars = Opal.gvars, $writer = nil;
  if ($gvars.stdout == null) $gvars.stdout = nil;
  if ($gvars.stderr == null) $gvars.stderr = nil;

  Opal.add_stubs(['$write_proc=', '$-']);
  
  
  $writer = [function(s){console.log(s)}];
  $send($gvars.stdout, 'write_proc=', Opal.to_a($writer));
  $writer[$rb_minus($writer["length"], 1)];;
  
  $writer = [function(s){console.error(s)}];
  $send($gvars.stderr, 'write_proc=', Opal.to_a($writer));
  return $writer[$rb_minus($writer["length"], 1)];;
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/opal_ext/node"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice;

  Opal.add_stubs(['$==', '$require']);
  
  
  var isElectron = typeof navigator === 'object' && typeof navigator.userAgent === 'string' && typeof navigator.userAgent.indexOf('Electron') !== -1,
      platform,
      engine,
      framework,
      ioModule;

  if (typeof moduleConfig === 'object' && typeof moduleConfig.runtime === 'object') {
    var runtime = moduleConfig.runtime;
    platform = runtime.platform;
    engine = runtime.engine;
    framework = runtime.framework;
    ioModule = runtime.ioModule;
  }

  ioModule = ioModule || 'node';
  platform = platform || 'node';
  engine = engine || 'v8';
  if (isElectron) {
    framework = framework || 'electron';
  } else {
    framework = framework || '';
  }
;
  Opal.const_set($nesting[0], 'JAVASCRIPT_IO_MODULE', ioModule);
  Opal.const_set($nesting[0], 'JAVASCRIPT_PLATFORM', platform);
  Opal.const_set($nesting[0], 'JAVASCRIPT_ENGINE', engine);
  Opal.const_set($nesting[0], 'JAVASCRIPT_FRAMEWORK', framework);
  if ($$($nesting, 'JAVASCRIPT_FRAMEWORK')['$==']("electron")) {
    self.$require("asciidoctor/js/opal_ext/electron/io")};
  
// Load Opal modules
Opal.load("pathname");
Opal.load("nodejs");
;
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/asciidoctor_ext/node/abstract_node"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass;

  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'AbstractNode');

      var $nesting = [self].concat($parent_nesting), $AbstractNode_generate_data_uri_from_uri$1;
      if (self.__xmlhttprequest__ == null) self.__xmlhttprequest__ = nil;

      
      self.__xmlhttprequest__ = require('unxhr');
      var __XMLHttpRequest__ = self.__xmlhttprequest__.XMLHttpRequest;
      return (Opal.def(self, '$generate_data_uri_from_uri', $AbstractNode_generate_data_uri_from_uri$1 = function $$generate_data_uri_from_uri(image_uri, cache_uri) {
        var self = this;

        
        
        if (cache_uri == null) {
          cache_uri = false;
        };
        
      var contentType = ''
      var b64encoded = ''
      var status = -1

      try {
        var xhr = new __XMLHttpRequest__();
        xhr.open('GET', image_uri, false);
        xhr.responseType = 'arraybuffer';
        xhr.addEventListener('load', function() {
          status = this.status
          if (status === 200) {
            var arrayBuffer = this.response;
            b64encoded = Buffer.from(arrayBuffer).toString('base64');
            contentType = this.getResponseHeader('content-type')
          }
        })
        xhr.send(null)
      }
      catch (e) {
        // something bad happened!
        status = 0
      }
      if (status === 404 || (status === 0 && !b64encoded)) {
        self.$logger().$warn('could not retrieve image data from URI: ' + image_uri)
        return image_uri
      }
      return 'data:' + contentType + ';base64,' + b64encoded
    ;
      }, $AbstractNode_generate_data_uri_from_uri$1.$$arity = -2), nil) && 'generate_data_uri_from_uri';
    })($nesting[0], null, $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/asciidoctor_ext/node/open_uri"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module;

  Opal.add_stubs(['$require', '$new', '$<<', '$rewind']);
  
  self.$require("stringio");
  return (function($base, $parent_nesting) {
    var self = $module($base, 'OpenURI');

    var $nesting = [self].concat($parent_nesting), $OpenURI_open_uri$1;
    if (self.__xmlhttprequest__ == null) self.__xmlhttprequest__ = nil;

    
    self.__xmlhttprequest__ = require('unxhr');
    var __XMLHttpRequest__ = self.__xmlhttprequest__.XMLHttpRequest;
    Opal.defs($$($nesting, 'OpenURI'), '$open_uri', $OpenURI_open_uri$1 = function $$open_uri(uri, $a) {
      var $post_args, rest, $iter = $OpenURI_open_uri$1.$$p, $yield = $iter || nil, self = this, io = nil, data = nil;

      if ($iter) $OpenURI_open_uri$1.$$p = null;
      
      
      $post_args = Opal.slice.call(arguments, 1, arguments.length);
      
      rest = $post_args;;
      io = $$$('::', 'StringIO').$new();
      data = "";
      
      var contentType = ''
      var status = -1

      try {
        var xhr = new __XMLHttpRequest__()
        xhr.open('GET', uri, false)
        xhr.responseType = 'text'
        xhr.addEventListener('load', function() {
          status = this.status
          if (status === 200) {
            data = this.responseText
            contentType = this.getResponseHeader('content-type')
          }
        })
        xhr.send(null)
      }
      catch (e) {
        // something bad happened!
        status = 0
      }
      if (status === 404 || (status === 0 && !data)) {
        throw $$($nesting, 'IOError').$new('No such file or directory: ' + uri)
      }
    ;
      io['$<<'](data);
      io.$rewind();
      if (($yield !== nil)) {
        return Opal.yield1($yield, io);
      } else {
        return io
      };
    }, $OpenURI_open_uri$1.$$arity = -2);
  })($nesting[0], $nesting);
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/asciidoctor_ext/node/stylesheet"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $truthy = Opal.truthy;

  Opal.add_stubs(['$rstrip', '$read', '$join']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'Stylesheets');

      var $nesting = [self].concat($parent_nesting), $Stylesheets_primary_stylesheet_data$1;

      self.$$prototype.primary_stylesheet_data = nil;
      return (Opal.def(self, '$primary_stylesheet_data', $Stylesheets_primary_stylesheet_data$1 = function $$primary_stylesheet_data() {
        var $a, self = this, __path__ = nil, stylesheets_dir = nil;

        
        __path__ = require('path');
        if ($truthy(__path__.basename(__dirname) === 'node' && __path__.basename(__path__.dirname(__dirname)) === 'dist')) {
          stylesheets_dir = __path__.join(__path__.dirname(__dirname), 'css')
        } else {
          stylesheets_dir = __path__.join(__dirname, 'css')
        };
        return (self.primary_stylesheet_data = ($truthy($a = self.primary_stylesheet_data) ? $a : $$$('::', 'IO').$read($$$('::', 'File').$join(stylesheets_dir, "asciidoctor.css")).$rstrip()));
      }, $Stylesheets_primary_stylesheet_data$1.$$arity = 0), nil) && 'primary_stylesheet_data'
    })($nesting[0], null, $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/asciidoctor_ext/node/template"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $hash2 = Opal.hash2, $truthy = Opal.truthy, $send = Opal.send;

  Opal.add_stubs(['$[]', '$clear', '$===', '$caches', '$class', '$scan', '$node_name', '$raise', '$ctx', '$==', '$strip', '$rstrip', '$key?', '$merge', '$file', '$[]=', '$-', '$private', '$new', '$each', '$directory?', '$system_path', '$scan_dir', '$update', '$select', '$glob', '$file?', '$basename', '$<', '$size', '$split', '$start_with?', '$slice', '$length', '$to_sym', '$node_require']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'TemplateConverter');

      var $nesting = [self].concat($parent_nesting), $TemplateConverter_caches$1, $TemplateConverter_clear_caches$2, $TemplateConverter_initialize$3, $TemplateConverter_convert$4, $TemplateConverter_handles$ques$5, $TemplateConverter_templates$6, $TemplateConverter_register$7, $TemplateConverter_scan$8, $TemplateConverter_node_require$11, $TemplateConverter_scan_dir$12;

      self.$$prototype.templates = self.$$prototype.caches = self.$$prototype.backend = self.$$prototype.engine = self.$$prototype.template_dirs = nil;
      
      self.caches = $hash2(["scans", "templates"], {"scans": $hash2([], {}), "templates": $hash2([], {})});
      Opal.defs(self, '$caches', $TemplateConverter_caches$1 = function $$caches() {
        var self = this;
        if (self.caches == null) self.caches = nil;

        return self.caches
      }, $TemplateConverter_caches$1.$$arity = 0);
      Opal.defs(self, '$clear_caches', $TemplateConverter_clear_caches$2 = function $$clear_caches() {
        var self = this;
        if (self.caches == null) self.caches = nil;

        
        if ($truthy(self.caches['$[]']("scans"))) {
          self.caches['$[]']("scans").$clear()};
        if ($truthy(self.caches['$[]']("templates"))) {
          return self.caches['$[]']("templates").$clear()
        } else {
          return nil
        };
      }, $TemplateConverter_clear_caches$2.$$arity = 0);
      
      Opal.def(self, '$initialize', $TemplateConverter_initialize$3 = function $$initialize(backend, template_dirs, opts) {
        var $a, self = this, $case = nil;

        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        self.backend = backend;
        self.templates = $hash2([], {});
        self.template_dirs = template_dirs;
        self.engine = opts['$[]']("template_engine");
        self.engine_options = ($truthy($a = opts['$[]']("template_engine_options")) ? $a : $hash2([], {}));
        $case = opts['$[]']("template_cache");
        if (true['$===']($case)) {self.caches = self.$class().$caches()}
        else if ($$$('::', 'Hash')['$===']($case)) {self.caches = opts['$[]']("template_cache")}
        else {self.caches = $hash2([], {})};
        return self.$scan();
      }, $TemplateConverter_initialize$3.$$arity = -3);
      
      Opal.def(self, '$convert', $TemplateConverter_convert$4 = function $$convert(node, template_name, opts) {
        var $a, self = this, template = nil, helpers_ctx = nil;

        
        
        if (template_name == null) {
          template_name = nil;
        };
        
        if (opts == null) {
          opts = nil;
        };
        if ($truthy((template = self.templates['$[]']((template_name = ($truthy($a = template_name) ? $a : node.$node_name())))))) {
        } else {
          self.$raise("" + "Could not find a custom template to handle transform: " + (template_name))
        };
        helpers_ctx = ($truthy($a = self.templates['$[]']("helpers.js")) ? self.templates['$[]']("helpers.js").$ctx() : $a);
        if (template_name['$==']("document")) {
          return (template.render({node: node, opts: fromHash(opts), helpers: helpers_ctx})).$strip()
        } else {
          return (template.render({node: node, opts: fromHash(opts), helpers: helpers_ctx})).$rstrip()
        };
      }, $TemplateConverter_convert$4.$$arity = -2);
      
      Opal.def(self, '$handles?', $TemplateConverter_handles$ques$5 = function(name) {
        var self = this;

        return self.templates['$key?'](name)
      }, $TemplateConverter_handles$ques$5.$$arity = 1);
      
      Opal.def(self, '$templates', $TemplateConverter_templates$6 = function $$templates() {
        var self = this;

        return self.templates.$merge()
      }, $TemplateConverter_templates$6.$$arity = 0);
      
      Opal.def(self, '$register', $TemplateConverter_register$7 = function $$register(name, template) {
        var $a, self = this, $writer = nil, template_cache = nil;

        
        $writer = [name, (function() {if ($truthy((template_cache = ($truthy($a = self.caches['$[]']("templates")) ? template.$file : $a)))) {
          
          $writer = [template.$file(), template];
          $send(template_cache, '[]=', Opal.to_a($writer));
          return $writer[$rb_minus($writer["length"], 1)];
        } else {
          return template
        }; return nil; })()];
        $send(self.templates, '[]=', Opal.to_a($writer));
        return $writer[$rb_minus($writer["length"], 1)];
      }, $TemplateConverter_register$7.$$arity = 2);
      self.$private();
      
      Opal.def(self, '$scan', $TemplateConverter_scan$8 = function $$scan() {
        var $$9, self = this, path_resolver = nil, backend = nil, engine = nil;

        
        path_resolver = $$($nesting, 'PathResolver').$new();
        backend = self.backend;
        engine = self.engine;
        return $send(self.template_dirs, 'each', [], ($$9 = function(template_dir){var self = $$9.$$s || this, $$10, file_pattern = nil, engine_dir = nil, backend_dir = nil, pattern = nil, scan_cache = nil, template_cache = nil, templates = nil, $writer = nil;
          if (self.caches == null) self.caches = nil;
          if (self.templates == null) self.templates = nil;

        
          
          if (template_dir == null) {
            template_dir = nil;
          };
          if ($truthy($$$('::', 'File')['$directory?']((template_dir = path_resolver.$system_path(template_dir))))) {
          } else {
            return nil;
          };
          if ($truthy(engine)) {
            
            file_pattern = "" + "*." + (engine);
            if ($truthy($$$('::', 'File')['$directory?']((engine_dir = "" + (template_dir) + "/" + (engine))))) {
              template_dir = engine_dir};
          } else {
            file_pattern = "*"
          };
          if ($truthy($$$('::', 'File')['$directory?']((backend_dir = "" + (template_dir) + "/" + (backend))))) {
            template_dir = backend_dir};
          pattern = "" + (template_dir) + "/" + (file_pattern);
          if ($truthy((scan_cache = self.caches['$[]']("scans")))) {
            
            template_cache = self.caches['$[]']("templates");
            if ($truthy((templates = scan_cache['$[]'](pattern)))) {
            } else {
              templates = (($writer = [pattern, self.$scan_dir(template_dir, pattern, template_cache)]), $send(scan_cache, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])
            };
            $send(templates, 'each', [], ($$10 = function(name, template){var self = $$10.$$s || this;
              if (self.templates == null) self.templates = nil;

            
              
              if (name == null) {
                name = nil;
              };
              
              if (template == null) {
                template = nil;
              };
              $writer = [name, (($writer = [template.$file(), template]), $send(template_cache, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])];
              $send(self.templates, '[]=', Opal.to_a($writer));
              return $writer[$rb_minus($writer["length"], 1)];}, $$10.$$s = self, $$10.$$arity = 2, $$10));
          } else {
            self.templates.$update(self.$scan_dir(template_dir, pattern, self.caches['$[]']("templates")))
          };
          return nil;}, $$9.$$s = self, $$9.$$arity = 1, $$9));
      }, $TemplateConverter_scan$8.$$arity = 0);
      
      Opal.def(self, '$node_require', $TemplateConverter_node_require$11 = function $$node_require(module_name) {
        var self = this;

        
      try {
        return require(module_name)
      }
      catch (e) {
        throw $$($nesting, 'IOError').$new("" + "Unable to require the module '" + (module_name) + "', please make sure that the module is installed.")
      }
    
      }, $TemplateConverter_node_require$11.$$arity = 1);
      return (Opal.def(self, '$scan_dir', $TemplateConverter_scan_dir$12 = function $$scan_dir(template_dir, pattern, template_cache) {
        var $a, $$13, $$14, self = this, result = nil, helpers = nil, $writer = nil;

        
        
        if (template_cache == null) {
          template_cache = nil;
        };
        $a = [$hash2([], {}), nil], (result = $a[0]), (helpers = $a[1]), $a;
              var enginesContext = {};
        $send($send($$$('::', 'Dir').$glob(pattern), 'select', [], ($$13 = function(match){var self = $$13.$$s || this;

        
          
          if (match == null) {
            match = nil;
          };
          return $$$('::', 'File')['$file?'](match);}, $$13.$$s = self, $$13.$$arity = 1, $$13)), 'each', [], ($$14 = function(file){var self = $$14.$$s || this, $b, basename = nil, path_segments = nil, name = nil, template = nil, extsym = nil, $case = nil, nunjucks = nil, handlebars = nil, ejs = nil, pug = nil, $writer = nil;

        
          
          if (file == null) {
            file = nil;
          };
          if ((basename = $$$('::', 'File').$basename(file))['$==']("helpers.js")) {
            
            helpers = file;
            return nil;;
          } else if ($truthy($rb_lt((path_segments = basename.$split(".")).$size(), 2))) {
            return nil;};
          if ((name = path_segments['$[]'](0))['$==']("block_ruler")) {
            name = "thematic_break"
          } else if ($truthy(name['$start_with?']("block_"))) {
            name = name.$slice(6, name.$length())};
          if ($truthy(($truthy($b = template_cache) ? (template = template_cache['$[]'](file)) : $b))) {
          } else {
            
            extsym = path_segments['$[]'](-1).$to_sym();
            $case = extsym;
            if ("nunjucks"['$===']($case) || "njk"['$===']($case)) {
            nunjucks = self.$node_require("nunjucks");
            
            var fs = require('fs')
            var env
            if (enginesContext.nunjucks && enginesContext.nunjucks.environment) {
              env = enginesContext.nunjucks.environment
            } else {
              var opts = self.engine_options['nunjucks'] || {}
              delete opts.web // unsupported option
              env = nunjucks.configure(template_dir, opts)
              enginesContext.nunjucks = { environment: env }
            }
            template = Object.assign(nunjucks.compile(fs.readFileSync(file, 'utf8'), env), { '$file': function() { return file } })
          ;}
            else if ("handlebars"['$===']($case) || "hbs"['$===']($case)) {
            handlebars = self.$node_require("handlebars");
            
            var fs = require('fs')
            var env
            var opts = self.engine_options['handlebars'] || {}
            if (enginesContext.handlebars && enginesContext.handlebars.environment) {
              env = enginesContext.handlebars.environment
            } else {
              env = handlebars.create()
              enginesContext.handlebars = { environment: env }
            }
            template = { render: env.compile(fs.readFileSync(file, 'utf8'), opts), '$file': function() { return file } }
          ;}
            else if ("ejs"['$===']($case)) {
            ejs = self.$node_require("ejs");
            
            var fs = require('fs')
            var opts = self.engine_options['ejs'] || {}
            opts.filename = file
            // unsupported options
            delete opts.async
            delete opts.client
            template = { render: ejs.compile(fs.readFileSync(file, 'utf8'), opts), '$file': function() { return file } }
          ;}
            else if ("pug"['$===']($case)) {
            pug = self.$node_require("pug");
            
            var opts = self.engine_options['pug'] || {}
            opts.filename = file
            template = { render: pug.compileFile(file, opts), '$file': function() { return file } }
          ;}
            else if ("js"['$===']($case)) {template = { render: require(file), '$file': function() { return file } }}
            else {
            var registry = Opal.Asciidoctor.TemplateEngine.registry
            var templateEngine = registry[extsym]
            if (templateEngine && typeof templateEngine.compile === 'function') {
              template = Object.assign(templateEngine.compile(file, name), { '$file': function() { return file } })
            } else {
              template = undefined
            }
          };
          };
          if ($truthy(template)) {
            
            $writer = [name, template];
            $send(result, '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];
          } else {
            return nil
          };}, $$14.$$s = self, $$14.$$arity = 1, $$14));
        if ($truthy(($truthy($a = helpers) ? $a : $$$('::', 'File')['$file?']((helpers = "" + (template_dir) + "/helpers.js"))))) {
          
          
        var ctx = require(helpers)
        if (typeof ctx.configure === 'function') {
          ctx.configure(enginesContext)
        }
      ;
          
          $writer = ["helpers.js", { '$file': function() { return helpers }, $ctx: function() { return ctx } }];
          $send(result, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;};
        return result;
      }, $TemplateConverter_scan_dir$12.$$arity = -3), nil) && 'scan_dir';
    })($$($nesting, 'Converter'), $$$($$($nesting, 'Converter'), 'Base'), $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/asciidoctor_ext/node"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice;

  Opal.add_stubs(['$require']);
  
  self.$require("asciidoctor/js/asciidoctor_ext/node/abstract_node");
  self.$require("asciidoctor/js/asciidoctor_ext/node/open_uri");
  self.$require("asciidoctor/js/asciidoctor_ext/node/stylesheet");
  return self.$require("asciidoctor/js/asciidoctor_ext/node/template");
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["set"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  function $rb_le(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs <= rhs : lhs['$<='](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $klass = Opal.klass, $hash2 = Opal.hash2, $truthy = Opal.truthy, $send = Opal.send, $module = Opal.module;

  Opal.add_stubs(['$include', '$new', '$nil?', '$===', '$raise', '$each', '$add', '$merge', '$class', '$respond_to?', '$subtract', '$dup', '$join', '$to_a', '$equal?', '$instance_of?', '$==', '$instance_variable_get', '$is_a?', '$size', '$all?', '$include?', '$[]=', '$-', '$enum_for', '$[]', '$<<', '$replace', '$delete', '$select', '$each_key', '$to_proc', '$empty?', '$eql?', '$instance_eval', '$clear', '$<', '$<=', '$keys']);
  
  (function($base, $super, $parent_nesting) {
    var self = $klass($base, $super, 'Set');

    var $nesting = [self].concat($parent_nesting), $Set_$$$1, $Set_initialize$2, $Set_dup$4, $Set_$minus$5, $Set_inspect$6, $Set_$eq_eq$7, $Set_add$9, $Set_classify$10, $Set_collect$excl$13, $Set_delete$15, $Set_delete$ques$16, $Set_delete_if$17, $Set_add$ques$20, $Set_each$21, $Set_empty$ques$22, $Set_eql$ques$23, $Set_clear$25, $Set_include$ques$26, $Set_merge$27, $Set_replace$29, $Set_size$30, $Set_subtract$31, $Set_$$33, $Set_superset$ques$34, $Set_proper_superset$ques$36, $Set_subset$ques$38, $Set_proper_subset$ques$40, $Set_to_a$42;

    self.$$prototype.hash = nil;
    
    self.$include($$($nesting, 'Enumerable'));
    Opal.defs(self, '$[]', $Set_$$$1 = function($a) {
      var $post_args, ary, self = this;

      
      
      $post_args = Opal.slice.call(arguments, 0, arguments.length);
      
      ary = $post_args;;
      return self.$new(ary);
    }, $Set_$$$1.$$arity = -1);
    
    Opal.def(self, '$initialize', $Set_initialize$2 = function $$initialize(enum$) {
      var $iter = $Set_initialize$2.$$p, block = $iter || nil, $$3, self = this;

      if ($iter) $Set_initialize$2.$$p = null;
      
      
      if ($iter) $Set_initialize$2.$$p = null;;
      
      if (enum$ == null) {
        enum$ = nil;
      };
      self.hash = $hash2([], {});
      if ($truthy(enum$['$nil?']())) {
        return nil};
      if ($truthy($$($nesting, 'Enumerable')['$==='](enum$))) {
      } else {
        self.$raise($$($nesting, 'ArgumentError'), "value must be enumerable")
      };
      if ($truthy(block)) {
        return $send(enum$, 'each', [], ($$3 = function(item){var self = $$3.$$s || this;

        
          
          if (item == null) {
            item = nil;
          };
          return self.$add(Opal.yield1(block, item));}, $$3.$$s = self, $$3.$$arity = 1, $$3))
      } else {
        return self.$merge(enum$)
      };
    }, $Set_initialize$2.$$arity = -1);
    
    Opal.def(self, '$dup', $Set_dup$4 = function $$dup() {
      var self = this, result = nil;

      
      result = self.$class().$new();
      return result.$merge(self);
    }, $Set_dup$4.$$arity = 0);
    
    Opal.def(self, '$-', $Set_$minus$5 = function(enum$) {
      var self = this;

      
      if ($truthy(enum$['$respond_to?']("each"))) {
      } else {
        self.$raise($$($nesting, 'ArgumentError'), "value must be enumerable")
      };
      return self.$dup().$subtract(enum$);
    }, $Set_$minus$5.$$arity = 1);
    Opal.alias(self, "difference", "-");
    
    Opal.def(self, '$inspect', $Set_inspect$6 = function $$inspect() {
      var self = this;

      return "" + "#<Set: {" + (self.$to_a().$join(",")) + "}>"
    }, $Set_inspect$6.$$arity = 0);
    
    Opal.def(self, '$==', $Set_$eq_eq$7 = function(other) {
      var $a, $$8, self = this;

      if ($truthy(self['$equal?'](other))) {
        return true
      } else if ($truthy(other['$instance_of?'](self.$class()))) {
        return self.hash['$=='](other.$instance_variable_get("@hash"))
      } else if ($truthy(($truthy($a = other['$is_a?']($$($nesting, 'Set'))) ? self.$size()['$=='](other.$size()) : $a))) {
        return $send(other, 'all?', [], ($$8 = function(o){var self = $$8.$$s || this;
          if (self.hash == null) self.hash = nil;

        
          
          if (o == null) {
            o = nil;
          };
          return self.hash['$include?'](o);}, $$8.$$s = self, $$8.$$arity = 1, $$8))
      } else {
        return false
      }
    }, $Set_$eq_eq$7.$$arity = 1);
    
    Opal.def(self, '$add', $Set_add$9 = function $$add(o) {
      var self = this, $writer = nil;

      
      
      $writer = [o, true];
      $send(self.hash, '[]=', Opal.to_a($writer));
      $writer[$rb_minus($writer["length"], 1)];;
      return self;
    }, $Set_add$9.$$arity = 1);
    Opal.alias(self, "<<", "add");
    
    Opal.def(self, '$classify', $Set_classify$10 = function $$classify() {
      var $iter = $Set_classify$10.$$p, block = $iter || nil, $$11, $$12, self = this, result = nil;

      if ($iter) $Set_classify$10.$$p = null;
      
      
      if ($iter) $Set_classify$10.$$p = null;;
      if ((block !== nil)) {
      } else {
        return self.$enum_for("classify")
      };
      result = $send($$($nesting, 'Hash'), 'new', [], ($$11 = function(h, k){var self = $$11.$$s || this, $writer = nil;

      
        
        if (h == null) {
          h = nil;
        };
        
        if (k == null) {
          k = nil;
        };
        $writer = [k, self.$class().$new()];
        $send(h, '[]=', Opal.to_a($writer));
        return $writer[$rb_minus($writer["length"], 1)];}, $$11.$$s = self, $$11.$$arity = 2, $$11));
      $send(self, 'each', [], ($$12 = function(item){var self = $$12.$$s || this;

      
        
        if (item == null) {
          item = nil;
        };
        return result['$[]'](Opal.yield1(block, item)).$add(item);}, $$12.$$s = self, $$12.$$arity = 1, $$12));
      return result;
    }, $Set_classify$10.$$arity = 0);
    
    Opal.def(self, '$collect!', $Set_collect$excl$13 = function() {
      var $iter = $Set_collect$excl$13.$$p, block = $iter || nil, $$14, self = this, result = nil;

      if ($iter) $Set_collect$excl$13.$$p = null;
      
      
      if ($iter) $Set_collect$excl$13.$$p = null;;
      if ((block !== nil)) {
      } else {
        return self.$enum_for("collect!")
      };
      result = self.$class().$new();
      $send(self, 'each', [], ($$14 = function(item){var self = $$14.$$s || this;

      
        
        if (item == null) {
          item = nil;
        };
        return result['$<<'](Opal.yield1(block, item));}, $$14.$$s = self, $$14.$$arity = 1, $$14));
      return self.$replace(result);
    }, $Set_collect$excl$13.$$arity = 0);
    Opal.alias(self, "map!", "collect!");
    
    Opal.def(self, '$delete', $Set_delete$15 = function(o) {
      var self = this;

      
      self.hash.$delete(o);
      return self;
    }, $Set_delete$15.$$arity = 1);
    
    Opal.def(self, '$delete?', $Set_delete$ques$16 = function(o) {
      var self = this;

      if ($truthy(self['$include?'](o))) {
        
        self.$delete(o);
        return self;
      } else {
        return nil
      }
    }, $Set_delete$ques$16.$$arity = 1);
    
    Opal.def(self, '$delete_if', $Set_delete_if$17 = function $$delete_if() {
      var $$18, $$19, $iter = $Set_delete_if$17.$$p, $yield = $iter || nil, self = this;

      if ($iter) $Set_delete_if$17.$$p = null;
      
      if (($yield !== nil)) {
      } else {
        return self.$enum_for("delete_if")
      };
      $send($send(self, 'select', [], ($$18 = function(o){var self = $$18.$$s || this;

      
        
        if (o == null) {
          o = nil;
        };
        return Opal.yield1($yield, o);;}, $$18.$$s = self, $$18.$$arity = 1, $$18)), 'each', [], ($$19 = function(o){var self = $$19.$$s || this;
        if (self.hash == null) self.hash = nil;

      
        
        if (o == null) {
          o = nil;
        };
        return self.hash.$delete(o);}, $$19.$$s = self, $$19.$$arity = 1, $$19));
      return self;
    }, $Set_delete_if$17.$$arity = 0);
    
    Opal.def(self, '$add?', $Set_add$ques$20 = function(o) {
      var self = this;

      if ($truthy(self['$include?'](o))) {
        return nil
      } else {
        return self.$add(o)
      }
    }, $Set_add$ques$20.$$arity = 1);
    
    Opal.def(self, '$each', $Set_each$21 = function $$each() {
      var $iter = $Set_each$21.$$p, block = $iter || nil, self = this;

      if ($iter) $Set_each$21.$$p = null;
      
      
      if ($iter) $Set_each$21.$$p = null;;
      if ((block !== nil)) {
      } else {
        return self.$enum_for("each")
      };
      $send(self.hash, 'each_key', [], block.$to_proc());
      return self;
    }, $Set_each$21.$$arity = 0);
    
    Opal.def(self, '$empty?', $Set_empty$ques$22 = function() {
      var self = this;

      return self.hash['$empty?']()
    }, $Set_empty$ques$22.$$arity = 0);
    
    Opal.def(self, '$eql?', $Set_eql$ques$23 = function(other) {
      var $$24, self = this;

      return self.hash['$eql?']($send(other, 'instance_eval', [], ($$24 = function(){var self = $$24.$$s || this;
        if (self.hash == null) self.hash = nil;

      return self.hash}, $$24.$$s = self, $$24.$$arity = 0, $$24)))
    }, $Set_eql$ques$23.$$arity = 1);
    
    Opal.def(self, '$clear', $Set_clear$25 = function $$clear() {
      var self = this;

      
      self.hash.$clear();
      return self;
    }, $Set_clear$25.$$arity = 0);
    
    Opal.def(self, '$include?', $Set_include$ques$26 = function(o) {
      var self = this;

      return self.hash['$include?'](o)
    }, $Set_include$ques$26.$$arity = 1);
    Opal.alias(self, "member?", "include?");
    
    Opal.def(self, '$merge', $Set_merge$27 = function $$merge(enum$) {
      var $$28, self = this;

      
      $send(enum$, 'each', [], ($$28 = function(item){var self = $$28.$$s || this;

      
        
        if (item == null) {
          item = nil;
        };
        return self.$add(item);}, $$28.$$s = self, $$28.$$arity = 1, $$28));
      return self;
    }, $Set_merge$27.$$arity = 1);
    
    Opal.def(self, '$replace', $Set_replace$29 = function $$replace(enum$) {
      var self = this;

      
      self.$clear();
      self.$merge(enum$);
      return self;
    }, $Set_replace$29.$$arity = 1);
    
    Opal.def(self, '$size', $Set_size$30 = function $$size() {
      var self = this;

      return self.hash.$size()
    }, $Set_size$30.$$arity = 0);
    Opal.alias(self, "length", "size");
    
    Opal.def(self, '$subtract', $Set_subtract$31 = function $$subtract(enum$) {
      var $$32, self = this;

      
      $send(enum$, 'each', [], ($$32 = function(item){var self = $$32.$$s || this;

      
        
        if (item == null) {
          item = nil;
        };
        return self.$delete(item);}, $$32.$$s = self, $$32.$$arity = 1, $$32));
      return self;
    }, $Set_subtract$31.$$arity = 1);
    
    Opal.def(self, '$|', $Set_$$33 = function(enum$) {
      var self = this;

      
      if ($truthy(enum$['$respond_to?']("each"))) {
      } else {
        self.$raise($$($nesting, 'ArgumentError'), "value must be enumerable")
      };
      return self.$dup().$merge(enum$);
    }, $Set_$$33.$$arity = 1);
    
    Opal.def(self, '$superset?', $Set_superset$ques$34 = function(set) {
      var $a, $$35, self = this;

      
      ($truthy($a = set['$is_a?']($$($nesting, 'Set'))) ? $a : self.$raise($$($nesting, 'ArgumentError'), "value must be a set"));
      if ($truthy($rb_lt(self.$size(), set.$size()))) {
        return false};
      return $send(set, 'all?', [], ($$35 = function(o){var self = $$35.$$s || this;

      
        
        if (o == null) {
          o = nil;
        };
        return self['$include?'](o);}, $$35.$$s = self, $$35.$$arity = 1, $$35));
    }, $Set_superset$ques$34.$$arity = 1);
    Opal.alias(self, ">=", "superset?");
    
    Opal.def(self, '$proper_superset?', $Set_proper_superset$ques$36 = function(set) {
      var $a, $$37, self = this;

      
      ($truthy($a = set['$is_a?']($$($nesting, 'Set'))) ? $a : self.$raise($$($nesting, 'ArgumentError'), "value must be a set"));
      if ($truthy($rb_le(self.$size(), set.$size()))) {
        return false};
      return $send(set, 'all?', [], ($$37 = function(o){var self = $$37.$$s || this;

      
        
        if (o == null) {
          o = nil;
        };
        return self['$include?'](o);}, $$37.$$s = self, $$37.$$arity = 1, $$37));
    }, $Set_proper_superset$ques$36.$$arity = 1);
    Opal.alias(self, ">", "proper_superset?");
    
    Opal.def(self, '$subset?', $Set_subset$ques$38 = function(set) {
      var $a, $$39, self = this;

      
      ($truthy($a = set['$is_a?']($$($nesting, 'Set'))) ? $a : self.$raise($$($nesting, 'ArgumentError'), "value must be a set"));
      if ($truthy($rb_lt(set.$size(), self.$size()))) {
        return false};
      return $send(self, 'all?', [], ($$39 = function(o){var self = $$39.$$s || this;

      
        
        if (o == null) {
          o = nil;
        };
        return set['$include?'](o);}, $$39.$$s = self, $$39.$$arity = 1, $$39));
    }, $Set_subset$ques$38.$$arity = 1);
    Opal.alias(self, "<=", "subset?");
    
    Opal.def(self, '$proper_subset?', $Set_proper_subset$ques$40 = function(set) {
      var $a, $$41, self = this;

      
      ($truthy($a = set['$is_a?']($$($nesting, 'Set'))) ? $a : self.$raise($$($nesting, 'ArgumentError'), "value must be a set"));
      if ($truthy($rb_le(set.$size(), self.$size()))) {
        return false};
      return $send(self, 'all?', [], ($$41 = function(o){var self = $$41.$$s || this;

      
        
        if (o == null) {
          o = nil;
        };
        return set['$include?'](o);}, $$41.$$s = self, $$41.$$arity = 1, $$41));
    }, $Set_proper_subset$ques$40.$$arity = 1);
    Opal.alias(self, "<", "proper_subset?");
    Opal.alias(self, "+", "|");
    Opal.alias(self, "union", "|");
    return (Opal.def(self, '$to_a', $Set_to_a$42 = function $$to_a() {
      var self = this;

      return self.hash.$keys()
    }, $Set_to_a$42.$$arity = 0), nil) && 'to_a';
  })($nesting[0], null, $nesting);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Enumerable');

    var $nesting = [self].concat($parent_nesting), $Enumerable_to_set$43;

    
    Opal.def(self, '$to_set', $Enumerable_to_set$43 = function $$to_set($a, $b) {
      var $iter = $Enumerable_to_set$43.$$p, block = $iter || nil, $post_args, klass, args, self = this;

      if ($iter) $Enumerable_to_set$43.$$p = null;
      
      
      if ($iter) $Enumerable_to_set$43.$$p = null;;
      
      $post_args = Opal.slice.call(arguments, 0, arguments.length);
      
      if ($post_args.length > 0) {
        klass = $post_args[0];
        $post_args.splice(0, 1);
      }
      if (klass == null) {
        klass = $$($nesting, 'Set');
      };
      
      args = $post_args;;
      return $send(klass, 'new', [self].concat(Opal.to_a(args)), block.$to_proc());
    }, $Enumerable_to_set$43.$$arity = -1)
  })($nesting[0], $nesting);
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/opal_ext/kernel"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $send = Opal.send;

  Opal.add_stubs(['$new']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Kernel');

    var $nesting = [self].concat($parent_nesting), $Kernel_open$1, $Kernel___dir__$2;

    
    
    Opal.def(self, '$open', $Kernel_open$1 = function $$open(path, $a) {
      var $post_args, rest, $iter = $Kernel_open$1.$$p, $yield = $iter || nil, self = this, file = nil;

      if ($iter) $Kernel_open$1.$$p = null;
      
      
      $post_args = Opal.slice.call(arguments, 1, arguments.length);
      
      rest = $post_args;;
      file = $send($$($nesting, 'File'), 'new', [path].concat(Opal.to_a(rest)));
      if (($yield !== nil)) {
        return Opal.yield1($yield, file);
      } else {
        return file
      };
    }, $Kernel_open$1.$$arity = -2);
    
    Opal.def(self, '$__dir__', $Kernel___dir__$2 = function $$__dir__() {
      var self = this;

      return ""
    }, $Kernel___dir__$2.$$arity = 0);
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/opal_ext/file"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $klass = Opal.klass, $truthy = Opal.truthy, $gvars = Opal.gvars;

  Opal.add_stubs(['$attr_reader', '$delete', '$gsub', '$read', '$size', '$to_enum', '$chomp', '$each_line', '$readlines', '$split']);
  
  (function($base, $super, $parent_nesting) {
    var self = $klass($base, $super, 'File');

    var $nesting = [self].concat($parent_nesting), $File_initialize$1, $File_read$2, $File_each_line$3, $File_readlines$4;

    self.$$prototype.eof = self.$$prototype.path = nil;
    
    self.$attr_reader("eof");
    self.$attr_reader("lineno");
    self.$attr_reader("path");
    
    Opal.def(self, '$initialize', $File_initialize$1 = function $$initialize(path, flags) {
      var self = this, encoding_flag_regexp = nil;

      
      
      if (flags == null) {
        flags = "r";
      };
      self.path = path;
      self.contents = nil;
      self.eof = false;
      self.lineno = 0;
      flags = flags.$delete("b");
      encoding_flag_regexp = /:(.*)/;
      flags = flags.$gsub(encoding_flag_regexp, "");
      return (self.flags = flags);
    }, $File_initialize$1.$$arity = -2);
    
    Opal.def(self, '$read', $File_read$2 = function $$read() {
      var self = this, res = nil;

      if ($truthy(self.eof)) {
        return ""
      } else {
        
        res = $$($nesting, 'File').$read(self.path);
        self.eof = true;
        self.lineno = res.$size();
        return res;
      }
    }, $File_read$2.$$arity = 0);
    
    Opal.def(self, '$each_line', $File_each_line$3 = function $$each_line(separator) {
      var $iter = $File_each_line$3.$$p, block = $iter || nil, self = this, lines = nil;
      if ($gvars["/"] == null) $gvars["/"] = nil;

      if ($iter) $File_each_line$3.$$p = null;
      
      
      if ($iter) $File_each_line$3.$$p = null;;
      
      if (separator == null) {
        separator = $gvars["/"];
      };
      if ($truthy(self.eof)) {
        return (function() {if ((block !== nil)) {
          return self
        } else {
          return [].$to_enum()
        }; return nil; })()};
      if ((block !== nil)) {
        
        lines = $$($nesting, 'File').$read(self.path);
        
        self.eof = false;
        self.lineno = 0;
        var chomped  = lines.$chomp(),
            trailing = lines.length != chomped.length,
            splitted = chomped.split(separator);
        for (var i = 0, length = splitted.length; i < length; i++) {
          self.lineno += 1;
          if (i < length - 1 || trailing) {
            Opal.yield1(block, splitted[i] + separator);
          }
          else {
            Opal.yield1(block, splitted[i]);
          }
        }
        self.eof = true;
      ;
        return self;
      } else {
        return self.$read().$each_line()
      };
    }, $File_each_line$3.$$arity = -1);
    
    Opal.def(self, '$readlines', $File_readlines$4 = function $$readlines() {
      var self = this;

      return $$($nesting, 'File').$readlines(self.path)
    }, $File_readlines$4.$$arity = 0);
    return (function(self, $parent_nesting) {
      var $nesting = [self].concat($parent_nesting), $readlines$5, $file$ques$6, $readable$ques$7, $read$8;

      
      
      Opal.def(self, '$readlines', $readlines$5 = function $$readlines(path, separator) {
        var self = this, content = nil;
        if ($gvars["/"] == null) $gvars["/"] = nil;

        
        
        if (separator == null) {
          separator = $gvars["/"];
        };
        content = $$($nesting, 'File').$read(path);
        return content.$split(separator);
      }, $readlines$5.$$arity = -2);
      
      Opal.def(self, '$file?', $file$ques$6 = function(path) {
        var self = this;

        return true
      }, $file$ques$6.$$arity = 1);
      
      Opal.def(self, '$readable?', $readable$ques$7 = function(path) {
        var self = this;

        return true
      }, $readable$ques$7.$$arity = 1);
      return (Opal.def(self, '$read', $read$8 = function $$read(path) {
        var self = this;

        return ""
      }, $read$8.$$arity = 1), nil) && 'read';
    })(Opal.get_singleton_class(self), $nesting);
  })($nesting[0], null, $nesting);
  return (function($base, $super, $parent_nesting) {
    var self = $klass($base, $super, 'IO');

    var $nesting = [self].concat($parent_nesting), $IO_read$9;

    return (Opal.defs(self, '$read', $IO_read$9 = function $$read(path) {
      var self = this;

      return $$($nesting, 'File').$read(path)
    }, $IO_read$9.$$arity = 1), nil) && 'read'
  })($nesting[0], null, $nesting);
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/opal_ext/match_data"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $klass = Opal.klass, $send = Opal.send;

  Opal.add_stubs(['$[]=', '$-']);
  return (function($base, $super, $parent_nesting) {
    var self = $klass($base, $super, 'MatchData');

    var $nesting = [self].concat($parent_nesting), $MatchData_$$$eq$1;

    self.$$prototype.matches = nil;
    return (Opal.def(self, '$[]=', $MatchData_$$$eq$1 = function(idx, val) {
      var self = this, $writer = nil;

      
      $writer = [idx, val];
      $send(self.matches, '[]=', Opal.to_a($writer));
      return $writer[$rb_minus($writer["length"], 1)];
    }, $MatchData_$$$eq$1.$$arity = 2), nil) && '[]='
  })($nesting[0], null, $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/opal_ext/string"] = function(Opal) {
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  function $rb_ge(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs >= rhs : lhs['$>='](rhs);
  }
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $klass = Opal.klass, $truthy = Opal.truthy;

  Opal.add_stubs(['$method_defined?', '$<', '$length', '$bytes', '$to_s', '$byteslice', '$==', '$>=', '$-', '$_original_byteslice', '$_original_unpack']);
  return (function($base, $super, $parent_nesting) {
    var self = $klass($base, $super, 'String');

    var $nesting = [self].concat($parent_nesting), $String_limit_bytesize$1, $String_byteslice$2, $String_unpack$3;

    
    if ($truthy(self['$method_defined?']("limit_bytesize"))) {
    } else {
      
      Opal.def(self, '$limit_bytesize', $String_limit_bytesize$1 = function $$limit_bytesize(size) {
        var self = this, result = nil;

        
        if ($truthy($rb_lt(size, self.$bytes().$length()))) {
        } else {
          return self.$to_s()
        };
        result = self.$byteslice(0, size);
        return result.$to_s();
      }, $String_limit_bytesize$1.$$arity = 1)
    };
    if ($truthy(self['$method_defined?']("limit"))) {
    } else {
      Opal.alias(self, "limit", "limit_bytesize")
    };
    Opal.alias(self, "_original_byteslice", "byteslice");
    
    Opal.def(self, '$byteslice', $String_byteslice$2 = function $$byteslice(index, length) {
      var $a, $b, self = this;

      
      
      if (length == null) {
        length = 1;
      };
      if ($truthy(($truthy($a = (($b = index['$=='](3)) ? $rb_ge(length, index) : index['$=='](3))) ? self.charCodeAt() === 65279 : $a))) {
        return (self.substr(1)).$byteslice(0, $rb_minus(length, 3))
      } else {
        return self.$_original_byteslice(index, length)
      };
    }, $String_byteslice$2.$$arity = -2);
    Opal.alias(self, "_original_unpack", "unpack");
    return (Opal.def(self, '$unpack', $String_unpack$3 = function $$unpack(format) {
      var self = this;

      if (format['$==']("C3")) {
        if ($truthy(self.charCodeAt() === 65279)) {
          return [239, 187, 191]
        } else {
          
          var bytes = []
          for (var i=0; i < 3; i++) {
            if (i < self.length) {
              bytes.push(self.charCodeAt(i))
            } else {
              bytes.push(nil)
            }
          }
          return bytes
        
        }
      } else {
        return self.$_original_unpack(format)
      }
    }, $String_unpack$3.$$arity = 1), nil) && 'unpack';
  })($nesting[0], null, $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/opal_ext/uri"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module;

  Opal.add_stubs(['$extend']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'URI');

    var $nesting = [self].concat($parent_nesting), $URI_parse$1, $URI_path$2;

    
    Opal.defs(self, '$parse', $URI_parse$1 = function $$parse(str) {
      var self = this;

      return str.$extend($$($nesting, 'URI'))
    }, $URI_parse$1.$$arity = 1);
    
    Opal.def(self, '$path', $URI_path$2 = function $$path() {
      var self = this;

      return self
    }, $URI_path$2.$$arity = 0);
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/opal_ext/base64"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $hash2 = Opal.hash2, $truthy = Opal.truthy;

  Opal.add_stubs(['$delete']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Base64');

    var $nesting = [self].concat($parent_nesting), $Base64_decode64$1, $Base64_encode64$2, $Base64_strict_decode64$3, $Base64_strict_encode64$4, $Base64_urlsafe_decode64$5, $Base64_urlsafe_encode64$6;

    
    
    var encode, decode;
    encode = Opal.global.btoa || function (input) {
      var buffer;
      if (input instanceof Buffer) {
        buffer = input;
      } else {
        buffer = Buffer.from(input.toString(), 'binary');
      }
      return buffer.toString('base64');
    };
    decode = Opal.global.atob || function (input) {
      return Buffer.from(input, 'base64').toString('binary');
    };
  ;
    Opal.defs(self, '$decode64', $Base64_decode64$1 = function $$decode64(string) {
      var self = this;

      return decode(string.replace(/\r?\n/g, ''));
    }, $Base64_decode64$1.$$arity = 1);
    Opal.defs(self, '$encode64', $Base64_encode64$2 = function $$encode64(string) {
      var self = this;

      return encode(string).replace(/(.{60})/g, "$1\n").replace(/([^\n])$/g, "$1\n");
    }, $Base64_encode64$2.$$arity = 1);
    Opal.defs(self, '$strict_decode64', $Base64_strict_decode64$3 = function $$strict_decode64(string) {
      var self = this;

      return decode(string);
    }, $Base64_strict_decode64$3.$$arity = 1);
    Opal.defs(self, '$strict_encode64', $Base64_strict_encode64$4 = function $$strict_encode64(string) {
      var self = this;

      return encode(string);
    }, $Base64_strict_encode64$4.$$arity = 1);
    Opal.defs(self, '$urlsafe_decode64', $Base64_urlsafe_decode64$5 = function $$urlsafe_decode64(string) {
      var self = this;

      return decode(string.replace(/\-/g, '+').replace(/_/g, '/'));
    }, $Base64_urlsafe_decode64$5.$$arity = 1);
    Opal.defs(self, '$urlsafe_encode64', $Base64_urlsafe_encode64$6 = function $$urlsafe_encode64(string, $kwargs) {
      var padding, self = this, str = nil;

      
      
      if ($kwargs == null) {
        $kwargs = $hash2([], {});
      } else if (!$kwargs.$$is_hash) {
        throw Opal.ArgumentError.$new('expected kwargs');
      };
      
      padding = $kwargs.$$smap["padding"];
      if (padding == null) {
        padding = true
      };
      str = encode(string).replace(/\+/g, '-').replace(/\//g, '_');
      if ($truthy(padding)) {
      } else {
        str = str.$delete("=")
      };
      return str;
    }, $Base64_urlsafe_encode64$6.$$arity = -2);
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/opal_ext/number"] = function(Opal) {
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $klass = Opal.klass, $truthy = Opal.truthy;

  Opal.add_stubs(['$coerce_to!', '$>']);
  return (function($base, $super, $parent_nesting) {
    var self = $klass($base, $super, 'Number');

    var $nesting = [self].concat($parent_nesting), $Number_round$1;

    return (Opal.def(self, '$round', $Number_round$1 = function $$round(ndigits) {
      var self = this;

      
      ;
      ndigits = $$($nesting, 'Opal')['$coerce_to!'](ndigits, $$($nesting, 'Integer'), "to_int");
      if ($truthy($rb_gt(ndigits, 0))) {
        return Number(self.toFixed(ndigits));
      } else {
        return Math.round(self);
      };
    }, $Number_round$1.$$arity = -1), nil) && 'round'
  })($nesting[0], $$($nesting, 'Numeric'), $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/opal_ext"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice;

  Opal.add_stubs(['$require']);
  
  self.$require("asciidoctor/js/opal_ext/kernel");
  self.$require("asciidoctor/js/opal_ext/file");
  self.$require("asciidoctor/js/opal_ext/match_data");
  self.$require("asciidoctor/js/opal_ext/string");
  self.$require("asciidoctor/js/opal_ext/uri");
  self.$require("asciidoctor/js/opal_ext/base64");
  self.$require("asciidoctor/js/opal_ext/number");
  
// suppress "not supported" warning messages from Opal
Opal.config.unsupported_features_severity = 'ignore'

// Load specific runtime
self.$require("asciidoctor/js/opal_ext/node");
;
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/rx"] = function(Opal) {
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $send = Opal.send, $gvars = Opal.gvars, $truthy = Opal.truthy;

  Opal.add_stubs(['$gsub', '$+', '$unpack_hex_range']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting), $Asciidoctor_unpack_hex_range$1;

    
    Opal.const_set($nesting[0], 'HEX_RANGE_RX', /([A-F0-9]{4})(?:-([A-F0-9]{4}))?/);
    Opal.defs(self, '$unpack_hex_range', $Asciidoctor_unpack_hex_range$1 = function $$unpack_hex_range(str) {
      var $$2, self = this;

      return $send(str, 'gsub', [$$($nesting, 'HEX_RANGE_RX')], ($$2 = function(){var self = $$2.$$s || this, $a, $b;

      return "" + "\\u" + ((($a = $gvars['~']) === nil ? nil : $a['$[]'](1))) + (($truthy($a = (($b = $gvars['~']) === nil ? nil : $b['$[]'](2))) ? "" + "-\\u" + ((($b = $gvars['~']) === nil ? nil : $b['$[]'](2))) : $a))}, $$2.$$s = self, $$2.$$arity = 0, $$2))
    }, $Asciidoctor_unpack_hex_range$1.$$arity = 1);
    Opal.const_set($nesting[0], 'P_L', $rb_plus("A-Za-z", self.$unpack_hex_range("00AA00B500BA00C0-00D600D8-00F600F8-02C102C6-02D102E0-02E402EC02EE0370-037403760377037A-037D037F03860388-038A038C038E-03A103A3-03F503F7-0481048A-052F0531-055605590561-058705D0-05EA05F0-05F20620-064A066E066F0671-06D306D506E506E606EE06EF06FA-06FC06FF07100712-072F074D-07A507B107CA-07EA07F407F507FA0800-0815081A082408280840-085808A0-08B20904-0939093D09500958-09610971-09800985-098C098F09900993-09A809AA-09B009B209B6-09B909BD09CE09DC09DD09DF-09E109F009F10A05-0A0A0A0F0A100A13-0A280A2A-0A300A320A330A350A360A380A390A59-0A5C0A5E0A72-0A740A85-0A8D0A8F-0A910A93-0AA80AAA-0AB00AB20AB30AB5-0AB90ABD0AD00AE00AE10B05-0B0C0B0F0B100B13-0B280B2A-0B300B320B330B35-0B390B3D0B5C0B5D0B5F-0B610B710B830B85-0B8A0B8E-0B900B92-0B950B990B9A0B9C0B9E0B9F0BA30BA40BA8-0BAA0BAE-0BB90BD00C05-0C0C0C0E-0C100C12-0C280C2A-0C390C3D0C580C590C600C610C85-0C8C0C8E-0C900C92-0CA80CAA-0CB30CB5-0CB90CBD0CDE0CE00CE10CF10CF20D05-0D0C0D0E-0D100D12-0D3A0D3D0D4E0D600D610D7A-0D7F0D85-0D960D9A-0DB10DB3-0DBB0DBD0DC0-0DC60E01-0E300E320E330E40-0E460E810E820E840E870E880E8A0E8D0E94-0E970E99-0E9F0EA1-0EA30EA50EA70EAA0EAB0EAD-0EB00EB20EB30EBD0EC0-0EC40EC60EDC-0EDF0F000F40-0F470F49-0F6C0F88-0F8C1000-102A103F1050-1055105A-105D106110651066106E-10701075-1081108E10A0-10C510C710CD10D0-10FA10FC-1248124A-124D1250-12561258125A-125D1260-1288128A-128D1290-12B012B2-12B512B8-12BE12C012C2-12C512C8-12D612D8-13101312-13151318-135A1380-138F13A0-13F41401-166C166F-167F1681-169A16A0-16EA16F1-16F81700-170C170E-17111720-17311740-17511760-176C176E-17701780-17B317D717DC1820-18771880-18A818AA18B0-18F51900-191E1950-196D1970-19741980-19AB19C1-19C71A00-1A161A20-1A541AA71B05-1B331B45-1B4B1B83-1BA01BAE1BAF1BBA-1BE51C00-1C231C4D-1C4F1C5A-1C7D1CE9-1CEC1CEE-1CF11CF51CF61D00-1DBF1E00-1F151F18-1F1D1F20-1F451F48-1F4D1F50-1F571F591F5B1F5D1F5F-1F7D1F80-1FB41FB6-1FBC1FBE1FC2-1FC41FC6-1FCC1FD0-1FD31FD6-1FDB1FE0-1FEC1FF2-1FF41FF6-1FFC2071207F2090-209C21022107210A-211321152119-211D212421262128212A-212D212F-2139213C-213F2145-2149214E218321842C00-2C2E2C30-2C5E2C60-2CE42CEB-2CEE2CF22CF32D00-2D252D272D2D2D30-2D672D6F2D80-2D962DA0-2DA62DA8-2DAE2DB0-2DB62DB8-2DBE2DC0-2DC62DC8-2DCE2DD0-2DD62DD8-2DDE2E2F300530063031-3035303B303C3041-3096309D-309F30A1-30FA30FC-30FF3105-312D3131-318E31A0-31BA31F0-31FF3400-4DB54E00-9FCCA000-A48CA4D0-A4FDA500-A60CA610-A61FA62AA62BA640-A66EA67F-A69DA6A0-A6E5A717-A71FA722-A788A78B-A78EA790-A7ADA7B0A7B1A7F7-A801A803-A805A807-A80AA80C-A822A840-A873A882-A8B3A8F2-A8F7A8FBA90A-A925A930-A946A960-A97CA984-A9B2A9CFA9E0-A9E4A9E6-A9EFA9FA-A9FEAA00-AA28AA40-AA42AA44-AA4BAA60-AA76AA7AAA7E-AAAFAAB1AAB5AAB6AAB9-AABDAAC0AAC2AADB-AADDAAE0-AAEAAAF2-AAF4AB01-AB06AB09-AB0EAB11-AB16AB20-AB26AB28-AB2EAB30-AB5AAB5C-AB5FAB64AB65ABC0-ABE2AC00-D7A3D7B0-D7C6D7CB-D7FBF900-FA6DFA70-FAD9FB00-FB06FB13-FB17FB1DFB1F-FB28FB2A-FB36FB38-FB3CFB3EFB40FB41FB43FB44FB46-FBB1FBD3-FD3DFD50-FD8FFD92-FDC7FDF0-FDFBFE70-FE74FE76-FEFCFF21-FF3AFF41-FF5AFF66-FFBEFFC2-FFC7FFCA-FFCFFFD2-FFD7FFDA-FFDC")));
    Opal.const_set($nesting[0], 'P_Nl', self.$unpack_hex_range("16EE-16F02160-21822185-218830073021-30293038-303AA6E6-A6EF"));
    Opal.const_set($nesting[0], 'P_Nd', $rb_plus("0-9", self.$unpack_hex_range("0660-066906F0-06F907C0-07C90966-096F09E6-09EF0A66-0A6F0AE6-0AEF0B66-0B6F0BE6-0BEF0C66-0C6F0CE6-0CEF0D66-0D6F0DE6-0DEF0E50-0E590ED0-0ED90F20-0F291040-10491090-109917E0-17E91810-18191946-194F19D0-19D91A80-1A891A90-1A991B50-1B591BB0-1BB91C40-1C491C50-1C59A620-A629A8D0-A8D9A900-A909A9D0-A9D9A9F0-A9F9AA50-AA59ABF0-ABF9FF10-FF19")));
    Opal.const_set($nesting[0], 'P_Pc', self.$unpack_hex_range("005F203F20402054FE33FE34FE4D-FE4FFF3F"));
    Opal.const_set($nesting[0], 'CC_ALPHA', "" + ($$($nesting, 'P_L')) + ($$($nesting, 'P_Nl')));
    Opal.const_set($nesting[0], 'CG_ALPHA', "" + "[" + ($$($nesting, 'CC_ALPHA')) + "]");
    Opal.const_set($nesting[0], 'CC_ALNUM', "" + ($$($nesting, 'CC_ALPHA')) + ($$($nesting, 'P_Nd')));
    Opal.const_set($nesting[0], 'CG_ALNUM', "" + "[" + ($$($nesting, 'CC_ALNUM')) + "]");
    Opal.const_set($nesting[0], 'CC_WORD', "" + ($$($nesting, 'CC_ALNUM')) + ($$($nesting, 'P_Pc')));
    Opal.const_set($nesting[0], 'CG_WORD', "" + "[" + ($$($nesting, 'CC_WORD')) + "]");
    Opal.const_set($nesting[0], 'CG_BLANK', "[ \\t]");
    Opal.const_set($nesting[0], 'CC_EOL', "(?=\\n|$)");
    Opal.const_set($nesting[0], 'CG_GRAPH', "[^\\s\\x00-\\x1F\\x7F]");
    Opal.const_set($nesting[0], 'CC_ALL', "[\\s\\S]");
    Opal.const_set($nesting[0], 'CC_ANY', "[^\\n]");
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["strscan"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $klass = Opal.klass, $send = Opal.send;

  Opal.add_stubs(['$attr_reader', '$anchor', '$scan_until', '$length', '$size', '$rest', '$pos=', '$-', '$private']);
  return (function($base, $super, $parent_nesting) {
    var self = $klass($base, $super, 'StringScanner');

    var $nesting = [self].concat($parent_nesting), $StringScanner_initialize$1, $StringScanner_beginning_of_line$ques$2, $StringScanner_scan$3, $StringScanner_scan_until$4, $StringScanner_$$$5, $StringScanner_check$6, $StringScanner_check_until$7, $StringScanner_peek$8, $StringScanner_eos$ques$9, $StringScanner_exist$ques$10, $StringScanner_skip$11, $StringScanner_skip_until$12, $StringScanner_get_byte$13, $StringScanner_match$ques$14, $StringScanner_pos$eq$15, $StringScanner_matched_size$16, $StringScanner_post_match$17, $StringScanner_pre_match$18, $StringScanner_reset$19, $StringScanner_rest$20, $StringScanner_rest$ques$21, $StringScanner_rest_size$22, $StringScanner_terminate$23, $StringScanner_unscan$24, $StringScanner_anchor$25;

    self.$$prototype.pos = self.$$prototype.string = self.$$prototype.working = self.$$prototype.matched = self.$$prototype.prev_pos = self.$$prototype.match = nil;
    
    self.$attr_reader("pos");
    self.$attr_reader("matched");
    
    Opal.def(self, '$initialize', $StringScanner_initialize$1 = function $$initialize(string) {
      var self = this;

      
      self.string = string;
      self.pos = 0;
      self.matched = nil;
      self.working = string;
      return (self.match = []);
    }, $StringScanner_initialize$1.$$arity = 1);
    self.$attr_reader("string");
    
    Opal.def(self, '$beginning_of_line?', $StringScanner_beginning_of_line$ques$2 = function() {
      var self = this;

      return self.pos === 0 || self.string.charAt(self.pos - 1) === "\n"
    }, $StringScanner_beginning_of_line$ques$2.$$arity = 0);
    Opal.alias(self, "bol?", "beginning_of_line?");
    
    Opal.def(self, '$scan', $StringScanner_scan$3 = function $$scan(pattern) {
      var self = this;

      
      pattern = self.$anchor(pattern);
      
      var result = pattern.exec(self.working);

      if (result == null) {
        return self.matched = nil;
      }
      else if (typeof(result) === 'object') {
        self.prev_pos = self.pos;
        self.pos     += result[0].length;
        self.working  = self.working.substring(result[0].length);
        self.matched  = result[0];
        self.match    = result;

        return result[0];
      }
      else if (typeof(result) === 'string') {
        self.pos     += result.length;
        self.working  = self.working.substring(result.length);

        return result;
      }
      else {
        return nil;
      }
    ;
    }, $StringScanner_scan$3.$$arity = 1);
    
    Opal.def(self, '$scan_until', $StringScanner_scan_until$4 = function $$scan_until(pattern) {
      var self = this;

      
      pattern = self.$anchor(pattern);
      
      var pos     = self.pos,
          working = self.working,
          result;

      while (true) {
        result   = pattern.exec(working);
        pos     += 1;
        working  = working.substr(1);

        if (result == null) {
          if (working.length === 0) {
            return self.matched = nil;
          }

          continue;
        }

        self.matched  = self.string.substr(self.pos, pos - self.pos - 1 + result[0].length);
        self.prev_pos = pos - 1;
        self.pos      = pos;
        self.working  = working.substr(result[0].length);

        return self.matched;
      }
    ;
    }, $StringScanner_scan_until$4.$$arity = 1);
    
    Opal.def(self, '$[]', $StringScanner_$$$5 = function(idx) {
      var self = this;

      
      var match = self.match;

      if (idx < 0) {
        idx += match.length;
      }

      if (idx < 0 || idx >= match.length) {
        return nil;
      }

      if (match[idx] == null) {
        return nil;
      }

      return match[idx];
    
    }, $StringScanner_$$$5.$$arity = 1);
    
    Opal.def(self, '$check', $StringScanner_check$6 = function $$check(pattern) {
      var self = this;

      
      pattern = self.$anchor(pattern);
      
      var result = pattern.exec(self.working);

      if (result == null) {
        return self.matched = nil;
      }

      return self.matched = result[0];
    ;
    }, $StringScanner_check$6.$$arity = 1);
    
    Opal.def(self, '$check_until', $StringScanner_check_until$7 = function $$check_until(pattern) {
      var self = this;

      
      var prev_pos = self.prev_pos,
          pos      = self.pos;

      var result = self.$scan_until(pattern);

      if (result !== nil) {
        self.matched = result.substr(-1);
        self.working = self.string.substr(pos);
      }

      self.prev_pos = prev_pos;
      self.pos      = pos;

      return result;
    
    }, $StringScanner_check_until$7.$$arity = 1);
    
    Opal.def(self, '$peek', $StringScanner_peek$8 = function $$peek(length) {
      var self = this;

      return self.working.substring(0, length)
    }, $StringScanner_peek$8.$$arity = 1);
    
    Opal.def(self, '$eos?', $StringScanner_eos$ques$9 = function() {
      var self = this;

      return self.working.length === 0
    }, $StringScanner_eos$ques$9.$$arity = 0);
    
    Opal.def(self, '$exist?', $StringScanner_exist$ques$10 = function(pattern) {
      var self = this;

      
      var result = pattern.exec(self.working);

      if (result == null) {
        return nil;
      }
      else if (result.index == 0) {
        return 0;
      }
      else {
        return result.index + 1;
      }
    
    }, $StringScanner_exist$ques$10.$$arity = 1);
    
    Opal.def(self, '$skip', $StringScanner_skip$11 = function $$skip(pattern) {
      var self = this;

      
      pattern = self.$anchor(pattern);
      
      var result = pattern.exec(self.working);

      if (result == null) {
        return self.matched = nil;
      }
      else {
        var match_str = result[0];
        var match_len = match_str.length;

        self.matched   = match_str;
        self.prev_pos  = self.pos;
        self.pos      += match_len;
        self.working   = self.working.substring(match_len);

        return match_len;
      }
    ;
    }, $StringScanner_skip$11.$$arity = 1);
    
    Opal.def(self, '$skip_until', $StringScanner_skip_until$12 = function $$skip_until(pattern) {
      var self = this;

      
      var result = self.$scan_until(pattern);

      if (result === nil) {
        return nil;
      }
      else {
        self.matched = result.substr(-1);

        return result.length;
      }
    
    }, $StringScanner_skip_until$12.$$arity = 1);
    
    Opal.def(self, '$get_byte', $StringScanner_get_byte$13 = function $$get_byte() {
      var self = this;

      
      var result = nil;

      if (self.pos < self.string.length) {
        self.prev_pos  = self.pos;
        self.pos      += 1;
        result      = self.matched = self.working.substring(0, 1);
        self.working   = self.working.substring(1);
      }
      else {
        self.matched = nil;
      }

      return result;
    
    }, $StringScanner_get_byte$13.$$arity = 0);
    Opal.alias(self, "getch", "get_byte");
    
    Opal.def(self, '$match?', $StringScanner_match$ques$14 = function(pattern) {
      var self = this;

      
      pattern = self.$anchor(pattern);
      
      var result = pattern.exec(self.working);

      if (result == null) {
        return nil;
      }
      else {
        self.prev_pos = self.pos;

        return result[0].length;
      }
    ;
    }, $StringScanner_match$ques$14.$$arity = 1);
    
    Opal.def(self, '$pos=', $StringScanner_pos$eq$15 = function(pos) {
      var self = this;

      
      
      if (pos < 0) {
        pos += self.string.$length();
      }
    ;
      self.pos = pos;
      return (self.working = self.string.slice(pos));
    }, $StringScanner_pos$eq$15.$$arity = 1);
    
    Opal.def(self, '$matched_size', $StringScanner_matched_size$16 = function $$matched_size() {
      var self = this;

      
      if (self.matched === nil) {
        return nil;
      }

      return self.matched.length
    
    }, $StringScanner_matched_size$16.$$arity = 0);
    
    Opal.def(self, '$post_match', $StringScanner_post_match$17 = function $$post_match() {
      var self = this;

      
      if (self.matched === nil) {
        return nil;
      }

      return self.string.substr(self.pos);
    
    }, $StringScanner_post_match$17.$$arity = 0);
    
    Opal.def(self, '$pre_match', $StringScanner_pre_match$18 = function $$pre_match() {
      var self = this;

      
      if (self.matched === nil) {
        return nil;
      }

      return self.string.substr(0, self.prev_pos);
    
    }, $StringScanner_pre_match$18.$$arity = 0);
    
    Opal.def(self, '$reset', $StringScanner_reset$19 = function $$reset() {
      var self = this;

      
      self.working = self.string;
      self.matched = nil;
      return (self.pos = 0);
    }, $StringScanner_reset$19.$$arity = 0);
    
    Opal.def(self, '$rest', $StringScanner_rest$20 = function $$rest() {
      var self = this;

      return self.working
    }, $StringScanner_rest$20.$$arity = 0);
    
    Opal.def(self, '$rest?', $StringScanner_rest$ques$21 = function() {
      var self = this;

      return self.working.length !== 0
    }, $StringScanner_rest$ques$21.$$arity = 0);
    
    Opal.def(self, '$rest_size', $StringScanner_rest_size$22 = function $$rest_size() {
      var self = this;

      return self.$rest().$size()
    }, $StringScanner_rest_size$22.$$arity = 0);
    
    Opal.def(self, '$terminate', $StringScanner_terminate$23 = function $$terminate() {
      var self = this, $writer = nil;

      
      self.match = nil;
      
      $writer = [self.string.$length()];
      $send(self, 'pos=', Opal.to_a($writer));
      return $writer[$rb_minus($writer["length"], 1)];;
    }, $StringScanner_terminate$23.$$arity = 0);
    
    Opal.def(self, '$unscan', $StringScanner_unscan$24 = function $$unscan() {
      var self = this;

      
      self.pos = self.prev_pos;
      self.prev_pos = nil;
      self.match = nil;
      return self;
    }, $StringScanner_unscan$24.$$arity = 0);
    self.$private();
    return (Opal.def(self, '$anchor', $StringScanner_anchor$25 = function $$anchor(pattern) {
      var self = this;

      
      var flags = pattern.toString().match(/\/([^\/]+)$/);
      flags = flags ? flags[1] : undefined;
      return new RegExp('^(?:' + pattern.source + ')', flags);
    
    }, $StringScanner_anchor$25.$$arity = 1), nil) && 'anchor';
  })($nesting[0], null, $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice;

  Opal.add_stubs(['$require']);
  
  self.$require("asciidoctor/js/opal_ext");
  self.$require("asciidoctor/js/rx");
  return self.$require("strscan");
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/core_ext/nil_or_empty"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $klass = Opal.klass, $truthy = Opal.truthy;

  Opal.add_stubs(['$method_defined?']);
  
  (function($base, $super, $parent_nesting) {
    var self = $klass($base, $super, 'NilClass');

    var $nesting = [self].concat($parent_nesting);

    if ($truthy(self['$method_defined?']("nil_or_empty?"))) {
      return nil
    } else {
      return Opal.alias(self, "nil_or_empty?", "nil?")
    }
  })($nesting[0], null, $nesting);
  (function($base, $super, $parent_nesting) {
    var self = $klass($base, $super, 'String');

    var $nesting = [self].concat($parent_nesting);

    if ($truthy(self['$method_defined?']("nil_or_empty?"))) {
      return nil
    } else {
      return Opal.alias(self, "nil_or_empty?", "empty?")
    }
  })($nesting[0], null, $nesting);
  (function($base, $super, $parent_nesting) {
    var self = $klass($base, $super, 'Array');

    var $nesting = [self].concat($parent_nesting);

    if ($truthy(self['$method_defined?']("nil_or_empty?"))) {
      return nil
    } else {
      return Opal.alias(self, "nil_or_empty?", "empty?")
    }
  })($nesting[0], null, $nesting);
  (function($base, $super, $parent_nesting) {
    var self = $klass($base, $super, 'Hash');

    var $nesting = [self].concat($parent_nesting);

    if ($truthy(self['$method_defined?']("nil_or_empty?"))) {
      return nil
    } else {
      return Opal.alias(self, "nil_or_empty?", "empty?")
    }
  })($nesting[0], null, $nesting);
  return (function($base, $super, $parent_nesting) {
    var self = $klass($base, $super, 'Numeric');

    var $nesting = [self].concat($parent_nesting);

    if ($truthy(self['$method_defined?']("nil_or_empty?"))) {
      return nil
    } else {
      return Opal.alias(self, "nil_or_empty?", "nil?")
    }
  })($nesting[0], null, $nesting);
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/core_ext/hash/merge"] = function(Opal) {
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  var $$1, self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $send = Opal.send, $truthy = Opal.truthy;

  Opal.add_stubs(['$==', '$arity', '$instance_method', '$send', '$new', '$<', '$length', '$dup', '$>', '$inject', '$merge', '$[]']);
  if ($$($nesting, 'Hash').$instance_method("merge").$arity()['$=='](1)) {
    return $$($nesting, 'Hash').$send("prepend", $send($$($nesting, 'Module'), 'new', [], ($$1 = function(){var self = $$1.$$s || this, $merge$2;

    return (Opal.def(self, '$merge', $merge$2 = function $$merge($a) {
        var $post_args, args, $$3, $iter = $merge$2.$$p, $yield = $iter || nil, self = this, len = nil;

        if ($iter) $merge$2.$$p = null;
        
        
        $post_args = Opal.slice.call(arguments, 0, arguments.length);
        
        args = $post_args;;
        if ($truthy($rb_lt((len = args.$length()), 1))) {
          return self.$dup()
        } else {
          
          if ($truthy($rb_gt(len, 1))) {
            return $send(args, 'inject', [self], ($$3 = function(acc, arg){var self = $$3.$$s || this;

            
              
              if (acc == null) {
                acc = nil;
              };
              
              if (arg == null) {
                arg = nil;
              };
              return acc.$merge(arg);}, $$3.$$s = self, $$3.$$arity = 2, $$3))
          } else {
            
            return $send(self, Opal.find_super_dispatcher(self, 'merge', $merge$2, false), [args['$[]'](0)], null);
          };
        };
      }, $merge$2.$$arity = -1), nil) && 'merge'}, $$1.$$s = self, $$1.$$arity = 0, $$1)))
  } else {
    return nil
  }
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/core_ext/match_data/names"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $truthy = Opal.truthy, $klass = Opal.klass;

  Opal.add_stubs(['$method_defined?']);
  if ($truthy($$($nesting, 'MatchData')['$method_defined?']("names"))) {
    return nil
  } else {
    return (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'MatchData');

      var $nesting = [self].concat($parent_nesting), $MatchData_names$1;

      return (Opal.def(self, '$names', $MatchData_names$1 = function $$names() {
        var self = this;

        return []
      }, $MatchData_names$1.$$arity = 0), nil) && 'names'
    })($nesting[0], null, $nesting)
  }
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/core_ext"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice;

  Opal.add_stubs(['$==']);
  
  self.$require("asciidoctor/core_ext.rb"+ '/../' + "core_ext/nil_or_empty");
  self.$require("asciidoctor/core_ext.rb"+ '/../' + "core_ext/hash/merge");
  if ($$($nesting, 'RUBY_ENGINE')['$==']("opal")) {
    return self.$require("asciidoctor/core_ext.rb"+ '/../' + "core_ext/match_data/names")
  } else {
    return nil
  };
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/helpers"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_times(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs * rhs : lhs['$*'](rhs);
  }
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $truthy = Opal.truthy, $gvars = Opal.gvars, $send = Opal.send, $hash2 = Opal.hash2;

  Opal.add_stubs(['$module_function', '$require', '$include?', '$include', '$==', '$===', '$path', '$message', '$raise', '$warn', '$logger', '$chomp', '$empty?', '$slice', '$unpack', '$[]', '$byteslice', '$bytesize', '$[]=', '$-', '$map', '$rstrip', '$encode', '$encoding', '$nil_or_empty?', '$!=', '$tap', '$each_line', '$<<', '$match?', '$gsub', '$rindex', '$index', '$basename', '$extname', '$!', '$length', '$directory?', '$dirname', '$mkdir_p', '$mkdir', '$private_constant', '$join', '$divmod', '$*', '$+', '$to_s', '$to_i', '$succ', '$class_for_name', '$const_get']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function($base, $parent_nesting) {
      var self = $module($base, 'Helpers');

      var $nesting = [self].concat($parent_nesting), $Helpers_require_library$1, $Helpers_prepare_source_array$2, $Helpers_prepare_source_string$11, $Helpers_uriish$ques$16, $Helpers_encode_uri_component$17, $Helpers_encode_spaces_in_uri$18, $Helpers_rootname$19, $Helpers_basename$20, $Helpers_extname$ques$21, $Helpers_extname$22, $Helpers_extname$23, $Helpers_mkdir_p$24, $Helpers_int_to_roman$25, $Helpers_nextval$27, $Helpers_resolve_class$28, $Helpers_class_for_name$29;

      
      self.$module_function();
      
      Opal.def(self, '$require_library', $Helpers_require_library$1 = function $$require_library(name, gem_name, on_failure) {
        var self = this, $case = nil, details = nil;
        if ($gvars["!"] == null) $gvars["!"] = nil;

        
        
        if (gem_name == null) {
          gem_name = true;
        };
        
        if (on_failure == null) {
          on_failure = "abort";
        };
        try {
          return self.$require(name)
        } catch ($err) {
          if (Opal.rescue($err, [$$$('::', 'LoadError')])) {
            try {
              
              if ($truthy(self['$include?']($$($nesting, 'Logging')))) {
              } else {
                self.$include($$($nesting, 'Logging'))
              };
              if ($truthy(gem_name)) {
                
                if (gem_name['$=='](true)) {
                  gem_name = name};
                $case = on_failure;
                if ("abort"['$===']($case)) {
                details = (function() {if ($gvars["!"].$path()['$=='](gem_name)) {
                  return ""
                } else {
                  return "" + " (reason: " + ((function() {if ($truthy($gvars["!"].$path())) {
                    return "" + "cannot load '" + ($gvars["!"].$path()) + "'"
                  } else {
                    return $gvars["!"].$message()
                  }; return nil; })()) + ")"
                }; return nil; })();
                self.$raise($$$('::', 'LoadError'), "" + "asciidoctor: FAILED: required gem '" + (gem_name) + "' is not available" + (details) + ". Processing aborted.");}
                else if ("warn"['$===']($case)) {
                details = (function() {if ($gvars["!"].$path()['$=='](gem_name)) {
                  return ""
                } else {
                  return "" + " (reason: " + ((function() {if ($truthy($gvars["!"].$path())) {
                    return "" + "cannot load '" + ($gvars["!"].$path()) + "'"
                  } else {
                    return $gvars["!"].$message()
                  }; return nil; })()) + ")"
                }; return nil; })();
                self.$logger().$warn("" + "optional gem '" + (gem_name) + "' is not available" + (details) + ". Functionality disabled.");};
              } else {
                $case = on_failure;
                if ("abort"['$===']($case)) {self.$raise($$$('::', 'LoadError'), "" + "asciidoctor: FAILED: " + ($gvars["!"].$message().$chomp(".")) + ". Processing aborted.")}
                else if ("warn"['$===']($case)) {self.$logger().$warn("" + ($gvars["!"].$message().$chomp(".")) + ". Functionality disabled.")}
              };
              return nil;
            } finally { Opal.pop_exception() }
          } else { throw $err; }
        };
      }, $Helpers_require_library$1.$$arity = -2);
      
      Opal.def(self, '$prepare_source_array', $Helpers_prepare_source_array$2 = function $$prepare_source_array(data, trim_end) {
        var $$3, $$4, $$5, $$6, $$7, $$8, $$9, $$10, self = this, leading_2_bytes = nil, leading_bytes = nil, first = nil, $writer = nil;

        
        
        if (trim_end == null) {
          trim_end = true;
        };
        if ($truthy(data['$empty?']())) {
          return []};
        if ((leading_2_bytes = (leading_bytes = (first = data['$[]'](0)).$unpack("C3")).$slice(0, 2))['$==']($$($nesting, 'BOM_BYTES_UTF_16LE'))) {
          
          
          $writer = [0, first.$byteslice(2, first.$bytesize())];
          $send(data, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          return (function() {if ($truthy(trim_end)) {
            return $send(data, 'map', [], ($$3 = function(line){var self = $$3.$$s || this;

            
              
              if (line == null) {
                line = nil;
              };
              return line.$encode($$($nesting, 'UTF_8'), $$$($$$('::', 'Encoding'), 'UTF_16LE')).$rstrip();}, $$3.$$s = self, $$3.$$arity = 1, $$3))
          } else {
            return $send(data, 'map', [], ($$4 = function(line){var self = $$4.$$s || this;

            
              
              if (line == null) {
                line = nil;
              };
              return line.$encode($$($nesting, 'UTF_8'), $$$($$$('::', 'Encoding'), 'UTF_16LE')).$chomp();}, $$4.$$s = self, $$4.$$arity = 1, $$4))
          }; return nil; })();
        } else if (leading_2_bytes['$==']($$($nesting, 'BOM_BYTES_UTF_16BE'))) {
          
          
          $writer = [0, first.$byteslice(2, first.$bytesize())];
          $send(data, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          return (function() {if ($truthy(trim_end)) {
            return $send(data, 'map', [], ($$5 = function(line){var self = $$5.$$s || this;

            
              
              if (line == null) {
                line = nil;
              };
              return line.$encode($$($nesting, 'UTF_8'), $$$($$$('::', 'Encoding'), 'UTF_16BE')).$rstrip();}, $$5.$$s = self, $$5.$$arity = 1, $$5))
          } else {
            return $send(data, 'map', [], ($$6 = function(line){var self = $$6.$$s || this;

            
              
              if (line == null) {
                line = nil;
              };
              return line.$encode($$($nesting, 'UTF_8'), $$$($$$('::', 'Encoding'), 'UTF_16BE')).$chomp();}, $$6.$$s = self, $$6.$$arity = 1, $$6))
          }; return nil; })();
        } else if (leading_bytes['$==']($$($nesting, 'BOM_BYTES_UTF_8'))) {
          
          $writer = [0, first.$byteslice(3, first.$bytesize())];
          $send(data, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        if (first.$encoding()['$==']($$($nesting, 'UTF_8'))) {
          if ($truthy(trim_end)) {
            return $send(data, 'map', [], ($$7 = function(line){var self = $$7.$$s || this;

            
              
              if (line == null) {
                line = nil;
              };
              return line.$rstrip();}, $$7.$$s = self, $$7.$$arity = 1, $$7))
          } else {
            return $send(data, 'map', [], ($$8 = function(line){var self = $$8.$$s || this;

            
              
              if (line == null) {
                line = nil;
              };
              return line.$chomp();}, $$8.$$s = self, $$8.$$arity = 1, $$8))
          }
        } else if ($truthy(trim_end)) {
          return $send(data, 'map', [], ($$9 = function(line){var self = $$9.$$s || this;

          
            
            if (line == null) {
              line = nil;
            };
            return line.$encode($$($nesting, 'UTF_8')).$rstrip();}, $$9.$$s = self, $$9.$$arity = 1, $$9))
        } else {
          return $send(data, 'map', [], ($$10 = function(line){var self = $$10.$$s || this;

          
            
            if (line == null) {
              line = nil;
            };
            return line.$encode($$($nesting, 'UTF_8')).$chomp();}, $$10.$$s = self, $$10.$$arity = 1, $$10))
        };
      }, $Helpers_prepare_source_array$2.$$arity = -2);
      
      Opal.def(self, '$prepare_source_string', $Helpers_prepare_source_string$11 = function $$prepare_source_string(data, trim_end) {
        var $$12, $$14, self = this, leading_2_bytes = nil, leading_bytes = nil;

        
        
        if (trim_end == null) {
          trim_end = true;
        };
        if ($truthy(data['$nil_or_empty?']())) {
          return []};
        if ((leading_2_bytes = (leading_bytes = data.$unpack("C3")).$slice(0, 2))['$==']($$($nesting, 'BOM_BYTES_UTF_16LE'))) {
          data = data.$byteslice(2, data.$bytesize()).$encode($$($nesting, 'UTF_8'), $$$($$$('::', 'Encoding'), 'UTF_16LE'))
        } else if (leading_2_bytes['$==']($$($nesting, 'BOM_BYTES_UTF_16BE'))) {
          data = data.$byteslice(2, data.$bytesize()).$encode($$($nesting, 'UTF_8'), $$$($$$('::', 'Encoding'), 'UTF_16BE'))
        } else if (leading_bytes['$==']($$($nesting, 'BOM_BYTES_UTF_8'))) {
          
          data = data.$byteslice(3, data.$bytesize());
          if (data.$encoding()['$==']($$($nesting, 'UTF_8'))) {
          } else {
            data = data.$encode($$($nesting, 'UTF_8'))
          };
        } else if ($truthy(data.$encoding()['$!=']($$($nesting, 'UTF_8')))) {
          data = data.$encode($$($nesting, 'UTF_8'))};
        if ($truthy(trim_end)) {
          return $send([], 'tap', [], ($$12 = function(lines){var self = $$12.$$s || this, $$13;

          
            
            if (lines == null) {
              lines = nil;
            };
            return $send(data, 'each_line', [], ($$13 = function(line){var self = $$13.$$s || this;

            
              
              if (line == null) {
                line = nil;
              };
              return lines['$<<'](line.$rstrip());}, $$13.$$s = self, $$13.$$arity = 1, $$13));}, $$12.$$s = self, $$12.$$arity = 1, $$12))
        } else {
          return $send([], 'tap', [], ($$14 = function(lines){var self = $$14.$$s || this, $$15;

          
            
            if (lines == null) {
              lines = nil;
            };
            return $send(data, 'each_line', [], ($$15 = function(line){var self = $$15.$$s || this;

            
              
              if (line == null) {
                line = nil;
              };
              return lines['$<<'](line.$chomp());}, $$15.$$s = self, $$15.$$arity = 1, $$15));}, $$14.$$s = self, $$14.$$arity = 1, $$14))
        };
      }, $Helpers_prepare_source_string$11.$$arity = -2);
      
      Opal.def(self, '$uriish?', $Helpers_uriish$ques$16 = function(str) {
        var $a, self = this;

        return ($truthy($a = str['$include?'](":")) ? $$($nesting, 'UriSniffRx')['$match?'](str) : $a)
      }, $Helpers_uriish$ques$16.$$arity = 1);
      if ($$($nesting, 'RUBY_ENGINE')['$==']("opal")) {
        
        Opal.def(self, '$encode_uri_component', $Helpers_encode_uri_component$17 = function $$encode_uri_component(str) {
          var self = this;

          
        return encodeURIComponent(str).replace(/%20|[!'()*]/g, function (m) {
          return m === '%20' ? '+' : '%' + m.charCodeAt(0).toString(16)
        })
      
        }, $Helpers_encode_uri_component$17.$$arity = 1)
      } else {
        nil
      };
      
      Opal.def(self, '$encode_spaces_in_uri', $Helpers_encode_spaces_in_uri$18 = function $$encode_spaces_in_uri(str) {
        var self = this;

        if ($truthy(str['$include?'](" "))) {
          
          return str.$gsub(" ", "%20");
        } else {
          return str
        }
      }, $Helpers_encode_spaces_in_uri$18.$$arity = 1);
      
      Opal.def(self, '$rootname', $Helpers_rootname$19 = function $$rootname(filename) {
        var self = this, last_dot_idx = nil;

        if ($truthy((last_dot_idx = filename.$rindex(".")))) {
          if ($truthy(filename.$index("/", last_dot_idx))) {
            return filename
          } else {
            
            return filename.$slice(0, last_dot_idx);
          }
        } else {
          return filename
        }
      }, $Helpers_rootname$19.$$arity = 1);
      
      Opal.def(self, '$basename', $Helpers_basename$20 = function $$basename(filename, drop_ext) {
        var self = this;

        
        
        if (drop_ext == null) {
          drop_ext = nil;
        };
        if ($truthy(drop_ext)) {
          return $$$('::', 'File').$basename(filename, (function() {if (drop_ext['$=='](true)) {
            
            return self.$extname(filename);
          } else {
            return drop_ext
          }; return nil; })())
        } else {
          return $$$('::', 'File').$basename(filename)
        };
      }, $Helpers_basename$20.$$arity = -2);
      
      Opal.def(self, '$extname?', $Helpers_extname$ques$21 = function(path) {
        var $a, self = this, last_dot_idx = nil;

        return ($truthy($a = (last_dot_idx = path.$rindex("."))) ? path.$index("/", last_dot_idx)['$!']() : $a)
      }, $Helpers_extname$ques$21.$$arity = 1);
      if ($truthy($$$($$$('::', 'File'), 'ALT_SEPARATOR'))) {
        
        Opal.def(self, '$extname', $Helpers_extname$22 = function $$extname(path, fallback) {
          var $a, self = this, last_dot_idx = nil;

          
          
          if (fallback == null) {
            fallback = "";
          };
          if ($truthy((last_dot_idx = path.$rindex(".")))) {
            if ($truthy(($truthy($a = path.$index("/", last_dot_idx)) ? $a : path.$index($$$($$$('::', 'File'), 'ALT_SEPARATOR'), last_dot_idx)))) {
              return fallback
            } else {
              
              return path.$slice(last_dot_idx, path.$length());
            }
          } else {
            return fallback
          };
        }, $Helpers_extname$22.$$arity = -2)
      } else {
        
        Opal.def(self, '$extname', $Helpers_extname$23 = function $$extname(path, fallback) {
          var self = this, last_dot_idx = nil;

          
          
          if (fallback == null) {
            fallback = "";
          };
          if ($truthy((last_dot_idx = path.$rindex(".")))) {
            if ($truthy(path.$index("/", last_dot_idx))) {
              return fallback
            } else {
              
              return path.$slice(last_dot_idx, path.$length());
            }
          } else {
            return fallback
          };
        }, $Helpers_extname$23.$$arity = -2)
      };
      
      Opal.def(self, '$mkdir_p', $Helpers_mkdir_p$24 = function $$mkdir_p(dir) {
        var self = this, parent_dir = nil;

        if ($truthy($$$('::', 'File')['$directory?'](dir))) {
          return nil
        } else {
          
          if ((parent_dir = $$$('::', 'File').$dirname(dir))['$=='](".")) {
          } else {
            self.$mkdir_p(parent_dir)
          };
          
          try {
            return $$$('::', 'Dir').$mkdir(dir)
          } catch ($err) {
            if (Opal.rescue($err, [$$$('::', 'SystemCallError')])) {
              try {
                if ($truthy($$$('::', 'File')['$directory?'](dir))) {
                  return nil
                } else {
                  return self.$raise()
                }
              } finally { Opal.pop_exception() }
            } else { throw $err; }
          };;
        }
      }, $Helpers_mkdir_p$24.$$arity = 1);
      Opal.const_set($nesting[0], 'ROMAN_NUMERALS', $hash2(["M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"], {"M": 1000, "CM": 900, "D": 500, "CD": 400, "C": 100, "XC": 90, "L": 50, "XL": 40, "X": 10, "IX": 9, "V": 5, "IV": 4, "I": 1}));
      self.$private_constant("ROMAN_NUMERALS");
      
      Opal.def(self, '$int_to_roman', $Helpers_int_to_roman$25 = function $$int_to_roman(val) {
        var $$26, self = this;

        return $send($$($nesting, 'ROMAN_NUMERALS'), 'map', [], ($$26 = function(l, i){var self = $$26.$$s || this, $a, $b, repeat = nil;

        
          
          if (l == null) {
            l = nil;
          };
          
          if (i == null) {
            i = nil;
          };
          $b = val.$divmod(i), $a = Opal.to_ary($b), (repeat = ($a[0] == null ? nil : $a[0])), (val = ($a[1] == null ? nil : $a[1])), $b;
          return $rb_times(l, repeat);}, $$26.$$s = self, $$26.$$arity = 2, $$26)).$join()
      }, $Helpers_int_to_roman$25.$$arity = 1);
      
      Opal.def(self, '$nextval', $Helpers_nextval$27 = function $$nextval(current) {
        var self = this, intval = nil;

        if ($truthy($$$('::', 'Integer')['$==='](current))) {
          return $rb_plus(current, 1)
        } else if ((intval = current.$to_i()).$to_s()['$=='](current.$to_s())) {
          return $rb_plus(intval, 1)
        } else {
          return current.$succ()
        }
      }, $Helpers_nextval$27.$$arity = 1);
      
      Opal.def(self, '$resolve_class', $Helpers_resolve_class$28 = function $$resolve_class(object) {
        var self = this;

        if ($truthy($$$('::', 'Class')['$==='](object))) {
          return object
        } else {
          
          if ($truthy($$$('::', 'String')['$==='](object))) {
            
            return self.$class_for_name(object);
          } else {
            return nil
          };
        }
      }, $Helpers_resolve_class$28.$$arity = 1);
      
      Opal.def(self, '$class_for_name', $Helpers_class_for_name$29 = function $$class_for_name(qualified_name) {
        var self = this, resolved = nil;

        try {
          
          if ($truthy($$$('::', 'Class')['$===']((resolved = $$$('::', 'Object').$const_get(qualified_name, false))))) {
          } else {
            self.$raise()
          };
          return resolved;
        } catch ($err) {
          if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
            try {
              return self.$raise($$$('::', 'NameError'), "" + "Could not resolve class for name: " + (qualified_name))
            } finally { Opal.pop_exception() }
          } else { throw $err; }
        }
      }, $Helpers_class_for_name$29.$$arity = 1);
    })($nesting[0], $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["logger"] = function(Opal) {
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_le(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs <= rhs : lhs['$<='](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $klass = Opal.klass, $module = Opal.module, $send = Opal.send, $truthy = Opal.truthy;

  Opal.add_stubs(['$include', '$to_h', '$map', '$constants', '$const_get', '$to_s', '$format', '$chr', '$strftime', '$message_as_string', '$===', '$+', '$message', '$class', '$join', '$backtrace', '$inspect', '$attr_reader', '$attr_accessor', '$new', '$key', '$upcase', '$raise', '$add', '$to_proc', '$<=', '$<', '$write', '$call', '$[]', '$now']);
  return (function($base, $super, $parent_nesting) {
    var self = $klass($base, $super, 'Logger');

    var $nesting = [self].concat($parent_nesting), $Logger$1, $Logger_initialize$4, $Logger_level$eq$5, $Logger_info$6, $Logger_debug$7, $Logger_warn$8, $Logger_error$9, $Logger_fatal$10, $Logger_unknown$11, $Logger_info$ques$12, $Logger_debug$ques$13, $Logger_warn$ques$14, $Logger_error$ques$15, $Logger_fatal$ques$16, $Logger_add$17;

    self.$$prototype.level = self.$$prototype.progname = self.$$prototype.pipe = self.$$prototype.formatter = nil;
    
    (function($base, $parent_nesting) {
      var self = $module($base, 'Severity');

      var $nesting = [self].concat($parent_nesting);

      
      Opal.const_set($nesting[0], 'DEBUG', 0);
      Opal.const_set($nesting[0], 'INFO', 1);
      Opal.const_set($nesting[0], 'WARN', 2);
      Opal.const_set($nesting[0], 'ERROR', 3);
      Opal.const_set($nesting[0], 'FATAL', 4);
      Opal.const_set($nesting[0], 'UNKNOWN', 5);
    })($nesting[0], $nesting);
    self.$include($$($nesting, 'Severity'));
    Opal.const_set($nesting[0], 'SEVERITY_LABELS', $send($$($nesting, 'Severity').$constants(), 'map', [], ($Logger$1 = function(s){var self = $Logger$1.$$s || this;

    
      
      if (s == null) {
        s = nil;
      };
      return [$$($nesting, 'Severity').$const_get(s), s.$to_s()];}, $Logger$1.$$s = self, $Logger$1.$$arity = 1, $Logger$1)).$to_h());
    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'Formatter');

      var $nesting = [self].concat($parent_nesting), $Formatter_call$2, $Formatter_message_as_string$3;

      
      Opal.const_set($nesting[0], 'MESSAGE_FORMAT', "%s, [%s] %5s -- %s: %s\n");
      Opal.const_set($nesting[0], 'DATE_TIME_FORMAT', "%Y-%m-%dT%H:%M:%S.%6N");
      
      Opal.def(self, '$call', $Formatter_call$2 = function $$call(severity, time, progname, msg) {
        var self = this;

        return self.$format($$($nesting, 'MESSAGE_FORMAT'), severity.$chr(), time.$strftime($$($nesting, 'DATE_TIME_FORMAT')), severity, progname, self.$message_as_string(msg))
      }, $Formatter_call$2.$$arity = 4);
      return (Opal.def(self, '$message_as_string', $Formatter_message_as_string$3 = function $$message_as_string(msg) {
        var $a, self = this, $case = nil;

        return (function() {$case = msg;
        if ($$$('::', 'String')['$===']($case)) {return msg}
        else if ($$$('::', 'Exception')['$===']($case)) {return $rb_plus("" + (msg.$message()) + " (" + (msg.$class()) + ")\n", ($truthy($a = msg.$backtrace()) ? $a : []).$join("\n"))}
        else {return msg.$inspect()}})()
      }, $Formatter_message_as_string$3.$$arity = 1), nil) && 'message_as_string';
    })($nesting[0], null, $nesting);
    self.$attr_reader("level");
    self.$attr_accessor("progname");
    self.$attr_accessor("formatter");
    
    Opal.def(self, '$initialize', $Logger_initialize$4 = function $$initialize(pipe) {
      var self = this;

      
      self.pipe = pipe;
      self.level = $$($nesting, 'DEBUG');
      return (self.formatter = $$($nesting, 'Formatter').$new());
    }, $Logger_initialize$4.$$arity = 1);
    
    Opal.def(self, '$level=', $Logger_level$eq$5 = function(severity) {
      var self = this, level = nil;

      if ($truthy($$$('::', 'Integer')['$==='](severity))) {
        return (self.level = severity)
      } else if ($truthy((level = $$($nesting, 'SEVERITY_LABELS').$key(severity.$to_s().$upcase())))) {
        return (self.level = level)
      } else {
        return self.$raise($$($nesting, 'ArgumentError'), "" + "invalid log level: " + (severity))
      }
    }, $Logger_level$eq$5.$$arity = 1);
    
    Opal.def(self, '$info', $Logger_info$6 = function $$info(progname) {
      var $iter = $Logger_info$6.$$p, block = $iter || nil, self = this;

      if ($iter) $Logger_info$6.$$p = null;
      
      
      if ($iter) $Logger_info$6.$$p = null;;
      
      if (progname == null) {
        progname = nil;
      };
      return $send(self, 'add', [$$($nesting, 'INFO'), nil, progname], block.$to_proc());
    }, $Logger_info$6.$$arity = -1);
    
    Opal.def(self, '$debug', $Logger_debug$7 = function $$debug(progname) {
      var $iter = $Logger_debug$7.$$p, block = $iter || nil, self = this;

      if ($iter) $Logger_debug$7.$$p = null;
      
      
      if ($iter) $Logger_debug$7.$$p = null;;
      
      if (progname == null) {
        progname = nil;
      };
      return $send(self, 'add', [$$($nesting, 'DEBUG'), nil, progname], block.$to_proc());
    }, $Logger_debug$7.$$arity = -1);
    
    Opal.def(self, '$warn', $Logger_warn$8 = function $$warn(progname) {
      var $iter = $Logger_warn$8.$$p, block = $iter || nil, self = this;

      if ($iter) $Logger_warn$8.$$p = null;
      
      
      if ($iter) $Logger_warn$8.$$p = null;;
      
      if (progname == null) {
        progname = nil;
      };
      return $send(self, 'add', [$$($nesting, 'WARN'), nil, progname], block.$to_proc());
    }, $Logger_warn$8.$$arity = -1);
    
    Opal.def(self, '$error', $Logger_error$9 = function $$error(progname) {
      var $iter = $Logger_error$9.$$p, block = $iter || nil, self = this;

      if ($iter) $Logger_error$9.$$p = null;
      
      
      if ($iter) $Logger_error$9.$$p = null;;
      
      if (progname == null) {
        progname = nil;
      };
      return $send(self, 'add', [$$($nesting, 'ERROR'), nil, progname], block.$to_proc());
    }, $Logger_error$9.$$arity = -1);
    
    Opal.def(self, '$fatal', $Logger_fatal$10 = function $$fatal(progname) {
      var $iter = $Logger_fatal$10.$$p, block = $iter || nil, self = this;

      if ($iter) $Logger_fatal$10.$$p = null;
      
      
      if ($iter) $Logger_fatal$10.$$p = null;;
      
      if (progname == null) {
        progname = nil;
      };
      return $send(self, 'add', [$$($nesting, 'FATAL'), nil, progname], block.$to_proc());
    }, $Logger_fatal$10.$$arity = -1);
    
    Opal.def(self, '$unknown', $Logger_unknown$11 = function $$unknown(progname) {
      var $iter = $Logger_unknown$11.$$p, block = $iter || nil, self = this;

      if ($iter) $Logger_unknown$11.$$p = null;
      
      
      if ($iter) $Logger_unknown$11.$$p = null;;
      
      if (progname == null) {
        progname = nil;
      };
      return $send(self, 'add', [$$($nesting, 'UNKNOWN'), nil, progname], block.$to_proc());
    }, $Logger_unknown$11.$$arity = -1);
    
    Opal.def(self, '$info?', $Logger_info$ques$12 = function() {
      var self = this;

      return $rb_le(self.level, $$($nesting, 'INFO'))
    }, $Logger_info$ques$12.$$arity = 0);
    
    Opal.def(self, '$debug?', $Logger_debug$ques$13 = function() {
      var self = this;

      return $rb_le(self.level, $$($nesting, 'DEBUG'))
    }, $Logger_debug$ques$13.$$arity = 0);
    
    Opal.def(self, '$warn?', $Logger_warn$ques$14 = function() {
      var self = this;

      return $rb_le(self.level, $$($nesting, 'WARN'))
    }, $Logger_warn$ques$14.$$arity = 0);
    
    Opal.def(self, '$error?', $Logger_error$ques$15 = function() {
      var self = this;

      return $rb_le(self.level, $$($nesting, 'ERROR'))
    }, $Logger_error$ques$15.$$arity = 0);
    
    Opal.def(self, '$fatal?', $Logger_fatal$ques$16 = function() {
      var self = this;

      return $rb_le(self.level, $$($nesting, 'FATAL'))
    }, $Logger_fatal$ques$16.$$arity = 0);
    return (Opal.def(self, '$add', $Logger_add$17 = function $$add(severity, message, progname) {
      var $iter = $Logger_add$17.$$p, block = $iter || nil, $a, self = this;

      if ($iter) $Logger_add$17.$$p = null;
      
      
      if ($iter) $Logger_add$17.$$p = null;;
      
      if (message == null) {
        message = nil;
      };
      
      if (progname == null) {
        progname = nil;
      };
      if ($truthy($rb_lt((severity = ($truthy($a = severity) ? $a : $$($nesting, 'UNKNOWN'))), self.level))) {
        return true};
      progname = ($truthy($a = progname) ? $a : self.progname);
      if ($truthy(message)) {
      } else if ((block !== nil)) {
        message = Opal.yieldX(block, [])
      } else {
        
        message = progname;
        progname = self.progname;
      };
      self.pipe.$write(self.formatter.$call(($truthy($a = $$($nesting, 'SEVERITY_LABELS')['$[]'](severity)) ? $a : "ANY"), $$$('::', 'Time').$now(), progname, message));
      return true;
    }, $Logger_add$17.$$arity = -2), nil) && 'add';
  })($nesting[0], null, $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/logging"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $send = Opal.send, $truthy = Opal.truthy, $hash2 = Opal.hash2, $gvars = Opal.gvars;

  Opal.add_stubs(['$require', '$attr_reader', '$progname=', '$-', '$new', '$formatter=', '$level=', '$>', '$[]', '$===', '$inspect', '$to_h', '$map', '$constants', '$const_get', '$<<', '$clear', '$empty?', '$max', '$attr_accessor', '$memoize_logger', '$private', '$extend', '$private_class_method', '$logger', '$merge']);
  
  self.$require("logger");
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    
    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'Logger');

      var $nesting = [self].concat($parent_nesting), $Logger_initialize$1, $Logger_add$2;

      self.$$prototype.max_severity = nil;
      
      self.$attr_reader("max_severity");
      
      Opal.def(self, '$initialize', $Logger_initialize$1 = function $$initialize($a) {
        var $post_args, args, $iter = $Logger_initialize$1.$$p, $yield = $iter || nil, self = this, $writer = nil, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) $Logger_initialize$1.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        
        
        $post_args = Opal.slice.call(arguments, 0, arguments.length);
        
        args = $post_args;;
        $send(self, Opal.find_super_dispatcher(self, 'initialize', $Logger_initialize$1, false), $zuper, $iter);
        
        $writer = ["asciidoctor"];
        $send(self, 'progname=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = [$$($nesting, 'BasicFormatter').$new()];
        $send(self, 'formatter=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = [$$($nesting, 'WARN')];
        $send(self, 'level=', Opal.to_a($writer));
        return $writer[$rb_minus($writer["length"], 1)];;
      }, $Logger_initialize$1.$$arity = -1);
      
      Opal.def(self, '$add', $Logger_add$2 = function $$add(severity, message, progname) {
        var $a, $iter = $Logger_add$2.$$p, $yield = $iter || nil, self = this, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) $Logger_add$2.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        
        
        if (message == null) {
          message = nil;
        };
        
        if (progname == null) {
          progname = nil;
        };
        if ($truthy($rb_gt((severity = ($truthy($a = severity) ? $a : $$($nesting, 'UNKNOWN'))), (self.max_severity = ($truthy($a = self.max_severity) ? $a : severity))))) {
          self.max_severity = severity};
        return $send(self, Opal.find_super_dispatcher(self, 'add', $Logger_add$2, false), $zuper, $iter);
      }, $Logger_add$2.$$arity = -2);
      (function($base, $super, $parent_nesting) {
        var self = $klass($base, $super, 'BasicFormatter');

        var $nesting = [self].concat($parent_nesting), $BasicFormatter_call$3;

        
        Opal.const_set($nesting[0], 'SEVERITY_LABEL_SUBSTITUTES', $hash2(["WARN", "FATAL"], {"WARN": "WARNING", "FATAL": "FAILED"}));
        return (Opal.def(self, '$call', $BasicFormatter_call$3 = function $$call(severity, _, progname, msg) {
          var $a, self = this;

          return "" + (progname) + ": " + (($truthy($a = $$($nesting, 'SEVERITY_LABEL_SUBSTITUTES')['$[]'](severity)) ? $a : severity)) + ": " + ((function() {if ($truthy($$$('::', 'String')['$==='](msg))) {
            return msg
          } else {
            return msg.$inspect()
          }; return nil; })()) + ($$($nesting, 'LF'))
        }, $BasicFormatter_call$3.$$arity = 4), nil) && 'call';
      })($nesting[0], $$($nesting, 'Formatter'), $nesting);
      return (function($base, $parent_nesting) {
        var self = $module($base, 'AutoFormattingMessage');

        var $nesting = [self].concat($parent_nesting), $AutoFormattingMessage_inspect$4;

        
        Opal.def(self, '$inspect', $AutoFormattingMessage_inspect$4 = function $$inspect() {
          var self = this, sloc = nil;

          if ($truthy((sloc = self['$[]']("source_location")))) {
            return "" + (sloc) + ": " + (self['$[]']("text"))
          } else {
            return self['$[]']("text")
          }
        }, $AutoFormattingMessage_inspect$4.$$arity = 0)
      })($nesting[0], $nesting);
    })($nesting[0], $$$('::', 'Logger'), $nesting);
    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'MemoryLogger');

      var $nesting = [self].concat($parent_nesting), $MemoryLogger$5, $MemoryLogger_initialize$6, $MemoryLogger_add$7, $MemoryLogger_clear$8, $MemoryLogger_empty$ques$9, $MemoryLogger_max_severity$10;

      self.$$prototype.messages = nil;
      
      Opal.const_set($nesting[0], 'SEVERITY_SYMBOL_BY_VALUE', $send($$($nesting, 'Severity').$constants(false), 'map', [], ($MemoryLogger$5 = function(c){var self = $MemoryLogger$5.$$s || this;

      
        
        if (c == null) {
          c = nil;
        };
        return [$$($nesting, 'Severity').$const_get(c), c];}, $MemoryLogger$5.$$s = self, $MemoryLogger$5.$$arity = 1, $MemoryLogger$5)).$to_h());
      self.$attr_reader("messages");
      
      Opal.def(self, '$initialize', $MemoryLogger_initialize$6 = function $$initialize() {
        var self = this, $writer = nil;

        
        
        $writer = [$$($nesting, 'WARN')];
        $send(self, 'level=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        return (self.messages = []);
      }, $MemoryLogger_initialize$6.$$arity = 0);
      
      Opal.def(self, '$add', $MemoryLogger_add$7 = function $$add(severity, message, progname) {
        var $a, $iter = $MemoryLogger_add$7.$$p, $yield = $iter || nil, self = this;

        if ($iter) $MemoryLogger_add$7.$$p = null;
        
        
        if (message == null) {
          message = nil;
        };
        
        if (progname == null) {
          progname = nil;
        };
        message = ($truthy($a = message) ? $a : (function() {if (($yield !== nil)) {
          return Opal.yieldX($yield, []);
        } else {
          return progname
        }; return nil; })());
        self.messages['$<<']($hash2(["severity", "message"], {"severity": $$($nesting, 'SEVERITY_SYMBOL_BY_VALUE')['$[]'](($truthy($a = severity) ? $a : $$($nesting, 'UNKNOWN'))), "message": message}));
        return true;
      }, $MemoryLogger_add$7.$$arity = -2);
      
      Opal.def(self, '$clear', $MemoryLogger_clear$8 = function $$clear() {
        var self = this;

        return self.messages.$clear()
      }, $MemoryLogger_clear$8.$$arity = 0);
      
      Opal.def(self, '$empty?', $MemoryLogger_empty$ques$9 = function() {
        var self = this;

        return self.messages['$empty?']()
      }, $MemoryLogger_empty$ques$9.$$arity = 0);
      return (Opal.def(self, '$max_severity', $MemoryLogger_max_severity$10 = function $$max_severity() {
        var $$11, self = this;

        if ($truthy(self['$empty?']())) {
          return nil
        } else {
          return $send(self.messages, 'map', [], ($$11 = function(m){var self = $$11.$$s || this;

          
            
            if (m == null) {
              m = nil;
            };
            return $$($nesting, 'Severity').$const_get(m['$[]']("severity"));}, $$11.$$s = self, $$11.$$arity = 1, $$11)).$max()
        }
      }, $MemoryLogger_max_severity$10.$$arity = 0), nil) && 'max_severity';
    })($nesting[0], $$$('::', 'Logger'), $nesting);
    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'NullLogger');

      var $nesting = [self].concat($parent_nesting), $NullLogger_initialize$12, $NullLogger_add$13;

      self.$$prototype.max_severity = nil;
      
      self.$attr_reader("max_severity");
      
      Opal.def(self, '$initialize', $NullLogger_initialize$12 = function $$initialize() {
        var self = this, $writer = nil;

        
        $writer = [$$($nesting, 'WARN')];
        $send(self, 'level=', Opal.to_a($writer));
        return $writer[$rb_minus($writer["length"], 1)];
      }, $NullLogger_initialize$12.$$arity = 0);
      return (Opal.def(self, '$add', $NullLogger_add$13 = function $$add(severity, message, progname) {
        var $a, self = this;

        
        
        if (message == null) {
          message = nil;
        };
        
        if (progname == null) {
          progname = nil;
        };
        if ($truthy($rb_gt((severity = ($truthy($a = severity) ? $a : $$($nesting, 'UNKNOWN'))), (self.max_severity = ($truthy($a = self.max_severity) ? $a : severity))))) {
          self.max_severity = severity};
        return true;
      }, $NullLogger_add$13.$$arity = -2), nil) && 'add';
    })($nesting[0], $$$('::', 'Logger'), $nesting);
    (function($base, $parent_nesting) {
      var self = $module($base, 'LoggerManager');

      var $nesting = [self].concat($parent_nesting);

      
      self.logger_class = $$($nesting, 'Logger');
      (function(self, $parent_nesting) {
        var $nesting = [self].concat($parent_nesting), $logger$14, $logger$eq$15, $memoize_logger$16;

        
        self.$attr_accessor("logger_class");
        
        Opal.def(self, '$logger', $logger$14 = function $$logger(pipe) {
          var $a, self = this;
          if (self.logger == null) self.logger = nil;
          if (self.logger_class == null) self.logger_class = nil;
          if ($gvars.stderr == null) $gvars.stderr = nil;

          
          
          if (pipe == null) {
            pipe = $gvars.stderr;
          };
          self.$memoize_logger();
          return (self.logger = ($truthy($a = self.logger) ? $a : self.logger_class.$new(pipe)));
        }, $logger$14.$$arity = -1);
        
        Opal.def(self, '$logger=', $logger$eq$15 = function(new_logger) {
          var $a, self = this;
          if (self.logger_class == null) self.logger_class = nil;
          if ($gvars.stderr == null) $gvars.stderr = nil;

          return (self.logger = ($truthy($a = new_logger) ? $a : self.logger_class.$new($gvars.stderr)))
        }, $logger$eq$15.$$arity = 1);
        self.$private();
        return (Opal.def(self, '$memoize_logger', $memoize_logger$16 = function $$memoize_logger() {
          var self = this;

          return (function(self, $parent_nesting) {
            var $nesting = [self].concat($parent_nesting);

            
            Opal.alias(self, "logger", "logger");
            return self.$attr_reader("logger");
          })(Opal.get_singleton_class(self), $nesting)
        }, $memoize_logger$16.$$arity = 0), nil) && 'memoize_logger';
      })(Opal.get_singleton_class(self), $nesting);
    })($nesting[0], $nesting);
    (function($base, $parent_nesting) {
      var self = $module($base, 'Logging');

      var $nesting = [self].concat($parent_nesting), $Logging_included$17, $Logging_logger$18, $Logging_message_with_context$19;

      
      Opal.defs(self, '$included', $Logging_included$17 = function $$included(into) {
        var self = this;

        return into.$extend($$($nesting, 'Logging'))
      }, $Logging_included$17.$$arity = 1);
      self.$private_class_method("included");
      
      Opal.def(self, '$logger', $Logging_logger$18 = function $$logger() {
        var self = this;

        return $$($nesting, 'LoggerManager').$logger()
      }, $Logging_logger$18.$$arity = 0);
      
      Opal.def(self, '$message_with_context', $Logging_message_with_context$19 = function $$message_with_context(text, context) {
        var self = this;

        
        
        if (context == null) {
          context = $hash2([], {});
        };
        return $hash2(["text"], {"text": text}).$merge(context).$extend($$$($$($nesting, 'Logger'), 'AutoFormattingMessage'));
      }, $Logging_message_with_context$19.$$arity = -2);
    })($nesting[0], $nesting);
  })($nesting[0], $nesting);
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/rx"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $hash2 = Opal.hash2, $send = Opal.send, $truthy = Opal.truthy, $hash = Opal.hash;

  Opal.add_stubs(['$==', '$join', '$to_a', '$new', '$empty?', '$escape', '$[]=', '$-']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting), $Asciidoctor$1, $Asciidoctor$2;

    
    (function($base, $parent_nesting) {
      var self = $module($base, 'Rx');

      var $nesting = [self].concat($parent_nesting);

      nil
    })($nesting[0], $nesting);
    Opal.const_set($nesting[0], 'AuthorInfoLineRx', new RegExp("" + "^(" + ($$($nesting, 'CG_WORD')) + "[" + ($$($nesting, 'CC_WORD')) + "\\-'.]*)(?: +(" + ($$($nesting, 'CG_WORD')) + "[" + ($$($nesting, 'CC_WORD')) + "\\-'.]*))?(?: +(" + ($$($nesting, 'CG_WORD')) + "[" + ($$($nesting, 'CC_WORD')) + "\\-'.]*))?(?: +<([^>]+)>)?$"));
    Opal.const_set($nesting[0], 'AuthorDelimiterRx', /;(?: |$)/);
    Opal.const_set($nesting[0], 'RevisionInfoLineRx', new RegExp("" + "^(?:[^\\d{]*(" + ($$($nesting, 'CC_ANY')) + "*?),)? *(?!:)(" + ($$($nesting, 'CC_ANY')) + "*?)(?: *(?!^),?: *(" + ($$($nesting, 'CC_ANY')) + "*))?$"));
    Opal.const_set($nesting[0], 'ManpageTitleVolnumRx', new RegExp("" + "^(" + ($$($nesting, 'CC_ANY')) + "+?) *\\( *(" + ($$($nesting, 'CC_ANY')) + "+?) *\\)$"));
    Opal.const_set($nesting[0], 'ManpageNamePurposeRx', new RegExp("" + "^(" + ($$($nesting, 'CC_ANY')) + "+?) +- +(" + ($$($nesting, 'CC_ANY')) + "+)$"));
    Opal.const_set($nesting[0], 'ConditionalDirectiveRx', new RegExp("" + "^(\\\\)?(ifdef|ifndef|ifeval|endif)::(\\S*?(?:([,+])\\S*?)?)\\[(" + ($$($nesting, 'CC_ANY')) + "+)?\\]$"));
    Opal.const_set($nesting[0], 'EvalExpressionRx', new RegExp("" + "^(" + ($$($nesting, 'CC_ANY')) + "+?) *([=!><]=|[><]) *(" + ($$($nesting, 'CC_ANY')) + "+)$"));
    Opal.const_set($nesting[0], 'IncludeDirectiveRx', new RegExp("" + "^(\\\\)?include::([^\\[][^\\[]*)\\[(" + ($$($nesting, 'CC_ANY')) + "+)?\\]$"));
    Opal.const_set($nesting[0], 'TagDirectiveRx', /\b(?:tag|(e)nd)::(\S+?)\[\](?=$|[ \r])/m);
    Opal.const_set($nesting[0], 'AttributeEntryRx', new RegExp("" + "^:(!?" + ($$($nesting, 'CG_WORD')) + "[^:]*):(?:[ \\t]+(" + ($$($nesting, 'CC_ANY')) + "*))?$"));
    Opal.const_set($nesting[0], 'InvalidAttributeNameCharsRx', new RegExp("" + "[^" + ($$($nesting, 'CC_WORD')) + "-]"));
    if ($$($nesting, 'RUBY_ENGINE')['$==']("opal")) {
      Opal.const_set($nesting[0], 'AttributeEntryPassMacroRx', new RegExp("" + "^pass:([a-z]+(?:,[a-z-]+)*)?\\[(" + ($$($nesting, 'CC_ALL')) + "*)\\]$"))
    } else {
      nil
    };
    Opal.const_set($nesting[0], 'AttributeReferenceRx', new RegExp("" + "(\\\\)?\\{(" + ($$($nesting, 'CG_WORD')) + "[" + ($$($nesting, 'CC_WORD')) + "-]*|(set|counter2?):" + ($$($nesting, 'CC_ANY')) + "+?)(\\\\)?\\}"));
    Opal.const_set($nesting[0], 'BlockAnchorRx', new RegExp("" + "^\\[\\[(?:|([" + ($$($nesting, 'CC_ALPHA')) + "_:][" + ($$($nesting, 'CC_WORD')) + "\\-:.]*)(?:, *(" + ($$($nesting, 'CC_ANY')) + "+))?)\\]\\]$"));
    Opal.const_set($nesting[0], 'BlockAttributeListRx', new RegExp("" + "^\\[(|[" + ($$($nesting, 'CC_WORD')) + ".#%{,\"']" + ($$($nesting, 'CC_ANY')) + "*)\\]$"));
    Opal.const_set($nesting[0], 'BlockAttributeLineRx', new RegExp("" + "^\\[(?:|[" + ($$($nesting, 'CC_WORD')) + ".#%{,\"']" + ($$($nesting, 'CC_ANY')) + "*|\\[(?:|[" + ($$($nesting, 'CC_ALPHA')) + "_:][" + ($$($nesting, 'CC_WORD')) + "\\-:.]*(?:, *" + ($$($nesting, 'CC_ANY')) + "+)?)\\])\\]$"));
    Opal.const_set($nesting[0], 'BlockTitleRx', new RegExp("" + "^\\.(\\.?[^ \\t.]" + ($$($nesting, 'CC_ANY')) + "*)$"));
    Opal.const_set($nesting[0], 'AdmonitionParagraphRx', new RegExp("" + "^(" + ($$($nesting, 'ADMONITION_STYLES').$to_a().$join("|")) + "):[ \\t]+"));
    Opal.const_set($nesting[0], 'LiteralParagraphRx', new RegExp("" + "^([ \\t]+" + ($$($nesting, 'CC_ANY')) + "*)$"));
    Opal.const_set($nesting[0], 'AtxSectionTitleRx', new RegExp("" + "^(=={0,5})[ \\t]+(" + ($$($nesting, 'CC_ANY')) + "+?)(?:[ \\t]+\\1)?$"));
    Opal.const_set($nesting[0], 'ExtAtxSectionTitleRx', new RegExp("" + "^(=={0,5}|#\\\#{0,5})[ \\t]+(" + ($$($nesting, 'CC_ANY')) + "+?)(?:[ \\t]+\\1)?$"));
    Opal.const_set($nesting[0], 'SetextSectionTitleRx', new RegExp("" + "^((?!\\.)" + ($$($nesting, 'CC_ANY')) + "*?" + ($$($nesting, 'CG_ALNUM')) + ($$($nesting, 'CC_ANY')) + "*)$"));
    Opal.const_set($nesting[0], 'InlineSectionAnchorRx', new RegExp("" + " (\\\\)?\\[\\[([" + ($$($nesting, 'CC_ALPHA')) + "_:][" + ($$($nesting, 'CC_WORD')) + "\\-:.]*)(?:, *(" + ($$($nesting, 'CC_ANY')) + "+))?\\]\\]$"));
    Opal.const_set($nesting[0], 'InvalidSectionIdCharsRx', new RegExp("" + "<[^>]+>|&(?:[a-z][a-z]+\\d{0,2}|#\\d\\d\\d{0,4}|#x[\\da-f][\\da-f][\\da-f]{0,3});|[^ " + ($$($nesting, 'CC_WORD')) + "\\-.]+?"));
    Opal.const_set($nesting[0], 'SectionLevelStyleRx', /^sect\d$/);
    Opal.const_set($nesting[0], 'AnyListRx', new RegExp("" + "^(?:[ \\t]*(?:-|\\*\\**|\\.\\.*|\\u2022|\\d+\\.|[a-zA-Z]\\.|[IVXivx]+\\))[ \\t]|(?!//[^/])[ \\t]*[^ \\t]" + ($$($nesting, 'CC_ANY')) + "*?(?::::{0,2}|;;)(?:$|[ \\t])|<(?:\\d+|\\.)>[ \\t])"));
    Opal.const_set($nesting[0], 'UnorderedListRx', new RegExp("" + "^[ \\t]*(-|\\*\\**|\\u2022)[ \\t]+(" + ($$($nesting, 'CC_ANY')) + "*)$"));
    Opal.const_set($nesting[0], 'OrderedListRx', new RegExp("" + "^[ \\t]*(\\.\\.*|\\d+\\.|[a-zA-Z]\\.|[IVXivx]+\\))[ \\t]+(" + ($$($nesting, 'CC_ANY')) + "*)$"));
    Opal.const_set($nesting[0], 'OrderedListMarkerRxMap', $hash2(["arabic", "loweralpha", "lowerroman", "upperalpha", "upperroman"], {"arabic": /\d+\./, "loweralpha": /[a-z]\./, "lowerroman": /[ivx]+\)/, "upperalpha": /[A-Z]\./, "upperroman": /[IVX]+\)/}));
    Opal.const_set($nesting[0], 'DescriptionListRx', new RegExp("" + "^(?!//[^/])[ \\t]*([^ \\t]" + ($$($nesting, 'CC_ANY')) + "*?)(:::{0,2}|;;)(?:$|[ \\t]+(" + ($$($nesting, 'CC_ANY')) + "*)$)"));
    Opal.const_set($nesting[0], 'DescriptionListSiblingRx', $hash2(["::", ":::", "::::", ";;"], {"::": new RegExp("" + "^(?!//[^/])[ \\t]*([^ \\t]" + ($$($nesting, 'CC_ANY')) + "*?[^:]|[^ \\t:])(::)(?:$|[ \\t]+(" + ($$($nesting, 'CC_ANY')) + "*)$)"), ":::": new RegExp("" + "^(?!//[^/])[ \\t]*([^ \\t]" + ($$($nesting, 'CC_ANY')) + "*?[^:]|[^ \\t:])(:::)(?:$|[ \\t]+(" + ($$($nesting, 'CC_ANY')) + "*)$)"), "::::": new RegExp("" + "^(?!//[^/])[ \\t]*([^ \\t]" + ($$($nesting, 'CC_ANY')) + "*?[^:]|[^ \\t:])(::::)(?:$|[ \\t]+(" + ($$($nesting, 'CC_ANY')) + "*)$)"), ";;": new RegExp("" + "^(?!//[^/])[ \\t]*([^ \\t]" + ($$($nesting, 'CC_ANY')) + "*?)(;;)(?:$|[ \\t]+(" + ($$($nesting, 'CC_ANY')) + "*)$)")}));
    Opal.const_set($nesting[0], 'CalloutListRx', new RegExp("" + "^<(\\d+|\\.)>[ \\t]+(" + ($$($nesting, 'CC_ANY')) + "*)$"));
    Opal.const_set($nesting[0], 'CalloutExtractRx', /((?:\/\/|#|--|;;) ?)?(\\)?<!?(|--)(\d+|\.)\3>(?=(?: ?\\?<!?\3(?:\d+|\.)\3>)*$)/);
    Opal.const_set($nesting[0], 'CalloutExtractRxt', "(\\\\)?<()(\\d+|\\.)>(?=(?: ?\\\\?<(?:\\d+|\\.)>)*$)");
    Opal.const_set($nesting[0], 'CalloutExtractRxMap', $send($$$('::', 'Hash'), 'new', [], ($Asciidoctor$1 = function(h, k){var self = $Asciidoctor$1.$$s || this, $writer = nil;

    
      
      if (h == null) {
        h = nil;
      };
      
      if (k == null) {
        k = nil;
      };
      $writer = [k, new RegExp("" + "(" + ((function() {if ($truthy(k['$empty?']())) {
        return ""
      } else {
        return "" + ($$$('::', 'Regexp').$escape(k)) + " ?"
      }; return nil; })()) + ")?" + ($$($nesting, 'CalloutExtractRxt')))];
      $send(h, '[]=', Opal.to_a($writer));
      return $writer[$rb_minus($writer["length"], 1)];}, $Asciidoctor$1.$$s = self, $Asciidoctor$1.$$arity = 2, $Asciidoctor$1)));
    Opal.const_set($nesting[0], 'CalloutScanRx', new RegExp("" + "\\\\?<!?(|--)(\\d+|\\.)\\1>(?=(?: ?\\\\?<!?\\1(?:\\d+|\\.)\\1>)*" + ($$($nesting, 'CC_EOL')) + ")"));
    Opal.const_set($nesting[0], 'CalloutSourceRx', new RegExp("" + "((?://|#|--|;;) ?)?(\\\\)?&lt;!?(|--)(\\d+|\\.)\\3&gt;(?=(?: ?\\\\?&lt;!?\\3(?:\\d+|\\.)\\3&gt;)*" + ($$($nesting, 'CC_EOL')) + ")"));
    Opal.const_set($nesting[0], 'CalloutSourceRxt', "" + "(\\\\)?&lt;()(\\d+|\\.)&gt;(?=(?: ?\\\\?&lt;(?:\\d+|\\.)&gt;)*" + ($$($nesting, 'CC_EOL')) + ")");
    Opal.const_set($nesting[0], 'CalloutSourceRxMap', $send($$$('::', 'Hash'), 'new', [], ($Asciidoctor$2 = function(h, k){var self = $Asciidoctor$2.$$s || this, $writer = nil;

    
      
      if (h == null) {
        h = nil;
      };
      
      if (k == null) {
        k = nil;
      };
      $writer = [k, new RegExp("" + "(" + ((function() {if ($truthy(k['$empty?']())) {
        return ""
      } else {
        return "" + ($$$('::', 'Regexp').$escape(k)) + " ?"
      }; return nil; })()) + ")?" + ($$($nesting, 'CalloutSourceRxt')))];
      $send(h, '[]=', Opal.to_a($writer));
      return $writer[$rb_minus($writer["length"], 1)];}, $Asciidoctor$2.$$s = self, $Asciidoctor$2.$$arity = 2, $Asciidoctor$2)));
    Opal.const_set($nesting[0], 'ListRxMap', $hash2(["ulist", "olist", "dlist", "colist"], {"ulist": $$($nesting, 'UnorderedListRx'), "olist": $$($nesting, 'OrderedListRx'), "dlist": $$($nesting, 'DescriptionListRx'), "colist": $$($nesting, 'CalloutListRx')}));
    Opal.const_set($nesting[0], 'ColumnSpecRx', /^(?:(\d+)\*)?([<^>](?:\.[<^>]?)?|(?:[<^>]?\.)?[<^>])?(\d+%?|~)?([a-z])?$/);
    Opal.const_set($nesting[0], 'CellSpecStartRx', /^[ \t]*(?:(\d+(?:\.\d*)?|(?:\d*\.)?\d+)([*+]))?([<^>](?:\.[<^>]?)?|(?:[<^>]?\.)?[<^>])?([a-z])?$/);
    Opal.const_set($nesting[0], 'CellSpecEndRx', /[ \t]+(?:(\d+(?:\.\d*)?|(?:\d*\.)?\d+)([*+]))?([<^>](?:\.[<^>]?)?|(?:[<^>]?\.)?[<^>])?([a-z])?$/);
    Opal.const_set($nesting[0], 'CustomBlockMacroRx', new RegExp("" + "^(" + ($$($nesting, 'CG_WORD')) + "[" + ($$($nesting, 'CC_WORD')) + "-]*)::(|\\S|\\S" + ($$($nesting, 'CC_ANY')) + "*?\\S)\\[(" + ($$($nesting, 'CC_ANY')) + "+)?\\]$"));
    Opal.const_set($nesting[0], 'BlockMediaMacroRx', new RegExp("" + "^(image|video|audio)::(\\S|\\S" + ($$($nesting, 'CC_ANY')) + "*?\\S)\\[(" + ($$($nesting, 'CC_ANY')) + "+)?\\]$"));
    Opal.const_set($nesting[0], 'BlockTocMacroRx', new RegExp("" + "^toc::\\[(" + ($$($nesting, 'CC_ANY')) + "+)?\\]$"));
    Opal.const_set($nesting[0], 'InlineAnchorRx', new RegExp("" + "(\\\\)?(?:\\[\\[([" + ($$($nesting, 'CC_ALPHA')) + "_:][" + ($$($nesting, 'CC_WORD')) + "\\-:.]*)(?:, *(" + ($$($nesting, 'CC_ANY')) + "+?))?\\]\\]|anchor:([" + ($$($nesting, 'CC_ALPHA')) + "_:][" + ($$($nesting, 'CC_WORD')) + "\\-:.]*)\\[(?:\\]|(" + ($$($nesting, 'CC_ANY')) + "*?[^\\\\])\\]))"));
    Opal.const_set($nesting[0], 'InlineAnchorScanRx', new RegExp("" + "(?:^|[^\\\\\\[])\\[\\[([" + ($$($nesting, 'CC_ALPHA')) + "_:][" + ($$($nesting, 'CC_WORD')) + "\\-:.]*)(?:, *(" + ($$($nesting, 'CC_ANY')) + "+?))?\\]\\]|(?:^|[^\\\\])anchor:([" + ($$($nesting, 'CC_ALPHA')) + "_:][" + ($$($nesting, 'CC_WORD')) + "\\-:.]*)\\[(?:\\]|(" + ($$($nesting, 'CC_ANY')) + "*?[^\\\\])\\])"));
    Opal.const_set($nesting[0], 'LeadingInlineAnchorRx', new RegExp("" + "^\\[\\[([" + ($$($nesting, 'CC_ALPHA')) + "_:][" + ($$($nesting, 'CC_WORD')) + "\\-:.]*)(?:, *(" + ($$($nesting, 'CC_ANY')) + "+?))?\\]\\]"));
    Opal.const_set($nesting[0], 'InlineBiblioAnchorRx', new RegExp("" + "^\\[\\[\\[([" + ($$($nesting, 'CC_ALPHA')) + "_:][" + ($$($nesting, 'CC_WORD')) + "\\-:.]*)(?:, *(" + ($$($nesting, 'CC_ANY')) + "+?))?\\]\\]\\]"));
    Opal.const_set($nesting[0], 'InlineEmailRx', new RegExp("" + "([\\\\>:/])?" + ($$($nesting, 'CG_WORD')) + "(?:&amp;|[" + ($$($nesting, 'CC_WORD')) + "\\-.%+])*@" + ($$($nesting, 'CG_ALNUM')) + "[" + ($$($nesting, 'CC_ALNUM')) + "_\\-.]*\\.[a-zA-Z]{2,5}\\b"));
    Opal.const_set($nesting[0], 'InlineFootnoteMacroRx', new RegExp("" + "\\\\?footnote(?:(ref):|:([" + ($$($nesting, 'CC_WORD')) + "-]+)?)\\[(?:|(" + ($$($nesting, 'CC_ALL')) + "*?[^\\\\]))\\](?!</a>)", 'm'));
    Opal.const_set($nesting[0], 'InlineImageMacroRx', new RegExp("" + "\\\\?i(?:mage|con):([^:\\s\\[](?:[^\\n\\[]*[^\\s\\[])?)\\[(|" + ($$($nesting, 'CC_ALL')) + "*?[^\\\\])\\]", 'm'));
    Opal.const_set($nesting[0], 'InlineIndextermMacroRx', new RegExp("" + "\\\\?(?:(indexterm2?):\\[(" + ($$($nesting, 'CC_ALL')) + "*?[^\\\\])\\]|\\(\\((" + ($$($nesting, 'CC_ALL')) + "+?)\\)\\)(?!\\)))", 'm'));
    Opal.const_set($nesting[0], 'InlineKbdBtnMacroRx', new RegExp("" + "(\\\\)?(kbd|btn):\\[(" + ($$($nesting, 'CC_ALL')) + "*?[^\\\\])\\]", 'm'));
    Opal.const_set($nesting[0], 'InlineLinkRx', new RegExp("" + "(^|link:|" + ($$($nesting, 'CG_BLANK')) + "|&lt;|[>\\(\\)\\[\\];\"'])(\\\\?(?:https?|file|ftp|irc)://[^\\s\\[\\]<]*([^\\s.,\\[\\]<]))(?:\\[(|" + ($$($nesting, 'CC_ALL')) + "*?[^\\\\])\\])?", 'm'));
    Opal.const_set($nesting[0], 'InlineLinkMacroRx', new RegExp("" + "\\\\?(?:link|(mailto)):(|[^:\\s\\[][^\\s\\[]*)\\[(|" + ($$($nesting, 'CC_ALL')) + "*?[^\\\\])\\]", 'm'));
    Opal.const_set($nesting[0], 'MacroNameRx', new RegExp("" + "^" + ($$($nesting, 'CG_WORD')) + "[" + ($$($nesting, 'CC_WORD')) + "-]*$"));
    Opal.const_set($nesting[0], 'InlineStemMacroRx', new RegExp("" + "\\\\?(stem|(?:latex|ascii)math):([a-z]+(?:,[a-z-]+)*)?\\[(" + ($$($nesting, 'CC_ALL')) + "*?[^\\\\])\\]", 'm'));
    Opal.const_set($nesting[0], 'InlineMenuMacroRx', new RegExp("" + "\\\\?menu:(" + ($$($nesting, 'CG_WORD')) + "|[" + ($$($nesting, 'CC_WORD')) + "&][^\\n\\[]*[^\\s\\[])\\[ *(?:|(" + ($$($nesting, 'CC_ALL')) + "*?[^\\\\]))\\]", 'm'));
    Opal.const_set($nesting[0], 'InlineMenuRx', new RegExp("" + "\\\\?\"([" + ($$($nesting, 'CC_WORD')) + "&][^\"]*?[ \\n]+&gt;[ \\n]+[^\"]*)\""));
    Opal.const_set($nesting[0], 'InlinePassRx', $hash(false, ["+", "`", new RegExp("" + "(^|[^" + ($$($nesting, 'CC_WORD')) + ";:])(?:\\[([^\\]]+)\\])?(\\\\?(\\+|`)(\\S|\\S" + ($$($nesting, 'CC_ALL')) + "*?\\S)\\4)(?!" + ($$($nesting, 'CG_WORD')) + ")", 'm')], true, ["`", nil, new RegExp("" + "(^|[^`" + ($$($nesting, 'CC_WORD')) + "])(?:\\[([^\\]]+)\\])?(\\\\?(`)([^`\\s]|[^`\\s]" + ($$($nesting, 'CC_ALL')) + "*?\\S)\\4)(?![`" + ($$($nesting, 'CC_WORD')) + "])", 'm')]));
    Opal.const_set($nesting[0], 'SinglePlusInlinePassRx', new RegExp("" + "^(\\\\)?\\+(\\S|\\S" + ($$($nesting, 'CC_ALL')) + "*?\\S)\\+$", 'm'));
    Opal.const_set($nesting[0], 'InlinePassMacroRx', new RegExp("" + "(?:(?:(\\\\?)\\[([^\\]]+)\\])?(\\\\{0,2})(\\+\\+\\+?|\\$\\$)(" + ($$($nesting, 'CC_ALL')) + "*?)\\4|(\\\\?)pass:([a-z]+(?:,[a-z-]+)*)?\\[(|" + ($$($nesting, 'CC_ALL')) + "*?[^\\\\])\\])", 'm'));
    Opal.const_set($nesting[0], 'InlineXrefMacroRx', new RegExp("" + "\\\\?(?:&lt;&lt;([" + ($$($nesting, 'CC_WORD')) + "#/.:{]" + ($$($nesting, 'CC_ALL')) + "*?)&gt;&gt;|xref:([" + ($$($nesting, 'CC_WORD')) + "#/.:{]" + ($$($nesting, 'CC_ALL')) + "*?)\\[(?:\\]|(" + ($$($nesting, 'CC_ALL')) + "*?[^\\\\])\\]))", 'm'));
    if ($$($nesting, 'RUBY_ENGINE')['$==']("opal")) {
      Opal.const_set($nesting[0], 'HardLineBreakRx', new RegExp("" + "^(" + ($$($nesting, 'CC_ANY')) + "*) \\+$", 'm'))
    } else {
      nil
    };
    Opal.const_set($nesting[0], 'MarkdownThematicBreakRx', /^ {0,3}([-*_])( *)\1\2\1$/);
    Opal.const_set($nesting[0], 'ExtLayoutBreakRx', /^(?:'{3,}|<{3,}|([-*_])( *)\1\2\1)$/);
    Opal.const_set($nesting[0], 'BlankLineRx', /\n{2,}/);
    Opal.const_set($nesting[0], 'EscapedSpaceRx', /\\([ \t\n])/);
    Opal.const_set($nesting[0], 'ReplaceableTextRx', /[&']|--|\.\.\.|\([CRT]M?\)/);
    Opal.const_set($nesting[0], 'SpaceDelimiterRx', /([^\\])[ \t\n]+/);
    Opal.const_set($nesting[0], 'SubModifierSniffRx', /[+-]/);
    Opal.const_set($nesting[0], 'TrailingDigitsRx', /\d+$/);
    Opal.const_set($nesting[0], 'UriSniffRx', new RegExp("" + "^" + ($$($nesting, 'CG_ALPHA')) + "[" + ($$($nesting, 'CC_ALNUM')) + ".+-]+:/{0,2}"));
    Opal.const_set($nesting[0], 'XmlSanitizeRx', /<[^>]+>/);
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/substitutors"] = function(Opal) {
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  function $rb_times(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs * rhs : lhs['$*'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $hash2 = Opal.hash2, $hash = Opal.hash, $truthy = Opal.truthy, $send = Opal.send, $gvars = Opal.gvars;

  Opal.add_stubs(['$freeze', '$+', '$keys', '$empty?', '$!', '$===', '$[]', '$join', '$include?', '$extract_passthroughs', '$each', '$sub_specialchars', '$sub_quotes', '$sub_attributes', '$sub_replacements', '$sub_macros', '$highlight_source', '$sub_callouts', '$sub_post_replacements', '$warn', '$logger', '$restore_passthroughs', '$clear', '$split', '$apply_subs', '$==', '$gsub', '$match?', '$compat_mode', '$convert_quoted_text', '$attributes', '$shift', '$store_attribute', '$!=', '$attribute_undefined', '$counter', '$key?', '$downcase', '$attribute_missing', '$info', '$squeeze', '$delete', '$reject', '$start_with?', '$do_replacement', '$extensions', '$inline_macros?', '$inline_macros', '$regexp', '$instance', '$slice', '$length', '$names', '$config', '$merge', '$[]=', '$-', '$normalize_text', '$parse_attributes', '$process_method', '$expand_subs', '$text', '$text=', '$convert', '$class', '$strip', '$>', '$index', '$min', '$compact', '$end_with?', '$map', '$chop', '$new', '$pop', '$rstrip', '$register', '$tr', '$basename', '$parse', '$lstrip', '$split_simple_csv', '$partition', '$extract_attributes_from_text', '$sub', '$encode_uri_component', '$style', '$extname?', '$rindex', '$info?', '$catalog', '$fetch', '$outfilesuffix', '$natural_xrefs', '$resolve_id', '$find', '$footnotes', '$id', '$<', '$size', '$<<', '$attr?', '$attr', '$to_s', '$read_next_id', '$callouts', '$syntax_highlighter', '$highlight?', '$sub_source', '$extract_callouts', '$name', '$to_sym', '$to_i', '$resolve_lines_to_highlight', '$highlight', '$nil_or_empty?', '$restore_callouts', '$count', '$to_a', '$|', '$sort', '$*', '$parse_quoted_text_attributes', '$resolve_pass_subs', '$extract_inner_passthrough', '$basebackend?', '$error', '$chr', '$drop', '$&', '$resolve_subs', '$resolve_block_subs', '$parse_into', '$private', '$=~', '$shorthand_property_syntax', '$each_char']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function($base, $parent_nesting) {
      var self = $module($base, 'Substitutors');

      var $nesting = [self].concat($parent_nesting), $Substitutors_apply_subs$1, $Substitutors_apply_normal_subs$3, $Substitutors_apply_header_subs$4, $Substitutors_apply_reftext_subs$5, $Substitutors_sub_specialchars$6, $Substitutors_sub_quotes$7, $Substitutors_sub_attributes$10, $Substitutors_sub_replacements$16, $Substitutors_sub_macros$19, $Substitutors_sub_post_replacements$42, $Substitutors_sub_source$45, $Substitutors_sub_callouts$46, $Substitutors_highlight_source$48, $Substitutors_resolve_lines_to_highlight$49, $Substitutors_extract_passthroughs$52, $Substitutors_restore_passthroughs$56, $Substitutors_resolve_subs$58, $Substitutors_resolve_block_subs$60, $Substitutors_resolve_pass_subs$61, $Substitutors_expand_subs$62, $Substitutors_commit_subs$64, $Substitutors_parse_attributes$65, $Substitutors_extract_attributes_from_text$66, $Substitutors_extract_callouts$67, $Substitutors_restore_callouts$70, $Substitutors_extract_inner_passthrough$73, $Substitutors_convert_quoted_text$74, $Substitutors_do_replacement$75, $Substitutors_parse_quoted_text_attributes$76, $Substitutors_normalize_text$77, $Substitutors_split_simple_csv$78;

      
      Opal.const_set($nesting[0], 'SpecialCharsRx', /[<&>]/);
      Opal.const_set($nesting[0], 'SpecialCharsTr', $hash2([">", "<", "&"], {">": "&gt;", "<": "&lt;", "&": "&amp;"}));
      Opal.const_set($nesting[0], 'QuotedTextSniffRx', $hash(false, /[*_`#^~]/, true, /[*'_+#^~]/));
      Opal.const_set($nesting[0], 'BASIC_SUBS', ["specialcharacters"]).$freeze();
      Opal.const_set($nesting[0], 'HEADER_SUBS', ["specialcharacters", "attributes"]).$freeze();
      Opal.const_set($nesting[0], 'NO_SUBS', []).$freeze();
      Opal.const_set($nesting[0], 'NORMAL_SUBS', ["specialcharacters", "quotes", "attributes", "replacements", "macros", "post_replacements"]).$freeze();
      Opal.const_set($nesting[0], 'REFTEXT_SUBS', ["specialcharacters", "quotes", "replacements"]).$freeze();
      Opal.const_set($nesting[0], 'VERBATIM_SUBS', ["specialcharacters", "callouts"]).$freeze();
      Opal.const_set($nesting[0], 'SUB_GROUPS', $hash2(["none", "normal", "verbatim", "specialchars"], {"none": $$($nesting, 'NO_SUBS'), "normal": $$($nesting, 'NORMAL_SUBS'), "verbatim": $$($nesting, 'VERBATIM_SUBS'), "specialchars": $$($nesting, 'BASIC_SUBS')}));
      Opal.const_set($nesting[0], 'SUB_HINTS', $hash2(["a", "m", "n", "p", "q", "r", "c", "v"], {"a": "attributes", "m": "macros", "n": "normal", "p": "post_replacements", "q": "quotes", "r": "replacements", "c": "specialcharacters", "v": "verbatim"}));
      Opal.const_set($nesting[0], 'SUB_OPTIONS', $hash2(["block", "inline"], {"block": $rb_plus($rb_plus($$($nesting, 'SUB_GROUPS').$keys(), $$($nesting, 'NORMAL_SUBS')), ["callouts"]), "inline": $rb_plus($$($nesting, 'SUB_GROUPS').$keys(), $$($nesting, 'NORMAL_SUBS'))}));
      Opal.const_set($nesting[0], 'CAN', "\u0018");
      Opal.const_set($nesting[0], 'DEL', "\u007F");
      Opal.const_set($nesting[0], 'PASS_START', "\u0096");
      Opal.const_set($nesting[0], 'PASS_END', "\u0097");
      Opal.const_set($nesting[0], 'PassSlotRx', new RegExp("" + ($$($nesting, 'PASS_START')) + "(\\d+)" + ($$($nesting, 'PASS_END'))));
      Opal.const_set($nesting[0], 'HighlightedPassSlotRx', new RegExp("" + "<span\\b[^>]*>" + ($$($nesting, 'PASS_START')) + "</span>[^\\d]*(\\d+)[^\\d]*<span\\b[^>]*>" + ($$($nesting, 'PASS_END')) + "</span>"));
      Opal.const_set($nesting[0], 'RS', "\\");
      Opal.const_set($nesting[0], 'R_SB', "]");
      Opal.const_set($nesting[0], 'ESC_R_SB', "\\]");
      Opal.const_set($nesting[0], 'PLUS', "+");
      
      Opal.def(self, '$apply_subs', $Substitutors_apply_subs$1 = function $$apply_subs(text, subs) {
        var $a, $$2, self = this, is_multiline = nil, passthrus = nil, clear_passthrus = nil;
        if (self.passthroughs == null) self.passthroughs = nil;
        if (self.passthroughs_locked == null) self.passthroughs_locked = nil;

        
        
        if (subs == null) {
          subs = $$($nesting, 'NORMAL_SUBS');
        };
        if ($truthy(($truthy($a = text['$empty?']()) ? $a : subs['$!']()))) {
          return text};
        if ($truthy((is_multiline = $$$('::', 'Array')['$==='](text)))) {
          text = (function() {if ($truthy(text['$[]'](1))) {
            
            return text.$join($$($nesting, 'LF'));
          } else {
            return text['$[]'](0)
          }; return nil; })()};
        if ($truthy(subs['$include?']("macros"))) {
          
          text = self.$extract_passthroughs(text);
          if ($truthy(self.passthroughs['$empty?']())) {
          } else {
            
            passthrus = self.passthroughs;
            self.passthroughs_locked = ($truthy($a = self.passthroughs_locked) ? $a : (clear_passthrus = true));
          };};
        $send(subs, 'each', [], ($$2 = function(type){var self = $$2.$$s || this, $case = nil;

        
          
          if (type == null) {
            type = nil;
          };
          return (function() {$case = type;
          if ("specialcharacters"['$===']($case)) {return (text = self.$sub_specialchars(text))}
          else if ("quotes"['$===']($case)) {return (text = self.$sub_quotes(text))}
          else if ("attributes"['$===']($case)) {if ($truthy(text['$include?']($$($nesting, 'ATTR_REF_HEAD')))) {
            return (text = self.$sub_attributes(text))
          } else {
            return nil
          }}
          else if ("replacements"['$===']($case)) {return (text = self.$sub_replacements(text))}
          else if ("macros"['$===']($case)) {return (text = self.$sub_macros(text))}
          else if ("highlight"['$===']($case)) {return (text = self.$highlight_source(text, subs['$include?']("callouts")))}
          else if ("callouts"['$===']($case)) {if ($truthy(subs['$include?']("highlight"))) {
            return nil
          } else {
            return (text = self.$sub_callouts(text))
          }}
          else if ("post_replacements"['$===']($case)) {return (text = self.$sub_post_replacements(text))}
          else {return self.$logger().$warn("" + "unknown substitution type " + (type))}})();}, $$2.$$s = self, $$2.$$arity = 1, $$2));
        if ($truthy(passthrus)) {
          
          text = self.$restore_passthroughs(text);
          if ($truthy(clear_passthrus)) {
            
            passthrus.$clear();
            self.passthroughs_locked = nil;};};
        if ($truthy(is_multiline)) {
          
          return text.$split($$($nesting, 'LF'), -1);
        } else {
          return text
        };
      }, $Substitutors_apply_subs$1.$$arity = -2);
      
      Opal.def(self, '$apply_normal_subs', $Substitutors_apply_normal_subs$3 = function $$apply_normal_subs(text) {
        var self = this;

        return self.$apply_subs(text, $$($nesting, 'NORMAL_SUBS'))
      }, $Substitutors_apply_normal_subs$3.$$arity = 1);
      
      Opal.def(self, '$apply_header_subs', $Substitutors_apply_header_subs$4 = function $$apply_header_subs(text) {
        var self = this;

        return self.$apply_subs(text, $$($nesting, 'HEADER_SUBS'))
      }, $Substitutors_apply_header_subs$4.$$arity = 1);
      Opal.alias(self, "apply_title_subs", "apply_subs");
      
      Opal.def(self, '$apply_reftext_subs', $Substitutors_apply_reftext_subs$5 = function $$apply_reftext_subs(text) {
        var self = this;

        return self.$apply_subs(text, $$($nesting, 'REFTEXT_SUBS'))
      }, $Substitutors_apply_reftext_subs$5.$$arity = 1);
      if ($$($nesting, 'RUBY_ENGINE')['$==']("opal")) {
        
        Opal.def(self, '$sub_specialchars', $Substitutors_sub_specialchars$6 = function $$sub_specialchars(text) {
          var $a, $b, self = this;

          if ($truthy(($truthy($a = ($truthy($b = text['$include?'](">")) ? $b : text['$include?']("&"))) ? $a : text['$include?']("<")))) {
            
            return text.$gsub($$($nesting, 'SpecialCharsRx'), $$($nesting, 'SpecialCharsTr'));
          } else {
            return text
          }
        }, $Substitutors_sub_specialchars$6.$$arity = 1)
      } else {
        nil
      };
      Opal.alias(self, "sub_specialcharacters", "sub_specialchars");
      
      Opal.def(self, '$sub_quotes', $Substitutors_sub_quotes$7 = function $$sub_quotes(text) {
        var $$8, self = this, compat = nil;
        if (self.document == null) self.document = nil;

        
        if ($truthy($$($nesting, 'QuotedTextSniffRx')['$[]']((compat = self.document.$compat_mode()))['$match?'](text))) {
          $send($$($nesting, 'QUOTE_SUBS')['$[]'](compat), 'each', [], ($$8 = function(type, scope, pattern){var self = $$8.$$s || this, $$9;

          
            
            if (type == null) {
              type = nil;
            };
            
            if (scope == null) {
              scope = nil;
            };
            
            if (pattern == null) {
              pattern = nil;
            };
            return (text = $send(text, 'gsub', [pattern], ($$9 = function(){var self = $$9.$$s || this;
              if ($gvars["~"] == null) $gvars["~"] = nil;

            return self.$convert_quoted_text($gvars["~"], type, scope)}, $$9.$$s = self, $$9.$$arity = 0, $$9)));}, $$8.$$s = self, $$8.$$arity = 3, $$8))};
        return text;
      }, $Substitutors_sub_quotes$7.$$arity = 1);
      
      Opal.def(self, '$sub_attributes', $Substitutors_sub_attributes$10 = function $$sub_attributes(text, opts) {
        var $$11, $$13, $$14, $$15, self = this, doc_attrs = nil, drop = nil, drop_line = nil, drop_line_severity = nil, drop_empty_line = nil, attribute_undefined = nil, attribute_missing = nil, lines = nil;
        if (self.document == null) self.document = nil;

        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        doc_attrs = self.document.$attributes();
        drop = (drop_line = (drop_line_severity = (drop_empty_line = (attribute_undefined = (attribute_missing = nil)))));
        text = $send(text, 'gsub', [$$($nesting, 'AttributeReferenceRx')], ($$11 = function(){var self = $$11.$$s || this, $a, $b, $c, $$12, $case = nil, args = nil, _ = nil, value = nil, key = nil;
          if (self.document == null) self.document = nil;

        if ($truthy(($truthy($a = (($b = $gvars['~']) === nil ? nil : $b['$[]'](1))['$==']($$($nesting, 'RS'))) ? $a : (($b = $gvars['~']) === nil ? nil : $b['$[]'](4))['$==']($$($nesting, 'RS'))))) {
            return "" + "{" + ((($a = $gvars['~']) === nil ? nil : $a['$[]'](2))) + "}"
          } else if ($truthy((($a = $gvars['~']) === nil ? nil : $a['$[]'](3)))) {
            return (function() {$case = (args = (($a = $gvars['~']) === nil ? nil : $a['$[]'](2)).$split(":", 3)).$shift();
            if ("set"['$===']($case)) {
            $b = $$($nesting, 'Parser').$store_attribute(args['$[]'](0), ($truthy($c = args['$[]'](1)) ? $c : ""), self.document), $a = Opal.to_ary($b), (_ = ($a[0] == null ? nil : $a[0])), (value = ($a[1] == null ? nil : $a[1])), $b;
            if ($truthy(($truthy($a = value) ? $a : (attribute_undefined = ($truthy($b = attribute_undefined) ? $b : ($truthy($c = doc_attrs['$[]']("attribute-undefined")) ? $c : $$($nesting, 'Compliance').$attribute_undefined())))['$!=']("drop-line")))) {
              return (drop = (drop_empty_line = $$($nesting, 'DEL')))
            } else {
              return (drop = (drop_line = $$($nesting, 'CAN')))
            };}
            else if ("counter2"['$===']($case)) {
            $send(self.document, 'counter', Opal.to_a(args));
            return (drop = (drop_empty_line = $$($nesting, 'DEL')));}
            else {return $send(self.document, 'counter', Opal.to_a(args))}})()
          } else if ($truthy(doc_attrs['$key?']((key = (($a = $gvars['~']) === nil ? nil : $a['$[]'](2)).$downcase())))) {
            return doc_attrs['$[]'](key)
          } else if ($truthy((value = $$($nesting, 'INTRINSIC_ATTRIBUTES')['$[]'](key)))) {
            return value
          } else {
            return (function() {$case = (attribute_missing = ($truthy($a = attribute_missing) ? $a : ($truthy($b = ($truthy($c = opts['$[]']("attribute_missing")) ? $c : doc_attrs['$[]']("attribute-missing"))) ? $b : $$($nesting, 'Compliance').$attribute_missing())));
            if ("drop"['$===']($case)) {return (drop = (drop_empty_line = $$($nesting, 'DEL')))}
            else if ("drop-line"['$===']($case)) {
            if ((drop_line_severity = ($truthy($a = drop_line_severity) ? $a : ($truthy($b = opts['$[]']("drop_line_severity")) ? $b : "info")))['$==']("info")) {
              $send(self.$logger(), 'info', [], ($$12 = function(){var self = $$12.$$s || this;

              return "" + "dropping line containing reference to missing attribute: " + (key)}, $$12.$$s = self, $$12.$$arity = 0, $$12))};
            return (drop = (drop_line = $$($nesting, 'CAN')));}
            else if ("warn"['$===']($case)) {
            self.$logger().$warn("" + "skipping reference to missing attribute: " + (key));
            return (($a = $gvars['~']) === nil ? nil : $a['$[]'](0));}
            else {return (($a = $gvars['~']) === nil ? nil : $a['$[]'](0))}})()
          }}, $$11.$$s = self, $$11.$$arity = 0, $$11));
        if ($truthy(drop)) {
          if ($truthy(drop_empty_line)) {
            
            lines = text.$squeeze($$($nesting, 'DEL')).$split($$($nesting, 'LF'), -1);
            if ($truthy(drop_line)) {
              return $send(lines, 'reject', [], ($$13 = function(line){var self = $$13.$$s || this, $a, $b, $c;

              
                
                if (line == null) {
                  line = nil;
                };
                return ($truthy($a = ($truthy($b = ($truthy($c = line['$==']($$($nesting, 'DEL'))) ? $c : line['$==']($$($nesting, 'CAN')))) ? $b : line['$start_with?']($$($nesting, 'CAN')))) ? $a : line['$include?']($$($nesting, 'CAN')));}, $$13.$$s = self, $$13.$$arity = 1, $$13)).$join($$($nesting, 'LF')).$delete($$($nesting, 'DEL'))
            } else {
              return $send(lines, 'reject', [], ($$14 = function(line){var self = $$14.$$s || this;

              
                
                if (line == null) {
                  line = nil;
                };
                return line['$==']($$($nesting, 'DEL'));}, $$14.$$s = self, $$14.$$arity = 1, $$14)).$join($$($nesting, 'LF')).$delete($$($nesting, 'DEL'))
            };
          } else if ($truthy(text['$include?']($$($nesting, 'LF')))) {
            return $send(text.$split($$($nesting, 'LF'), -1), 'reject', [], ($$15 = function(line){var self = $$15.$$s || this, $a, $b;

            
              
              if (line == null) {
                line = nil;
              };
              return ($truthy($a = ($truthy($b = line['$==']($$($nesting, 'CAN'))) ? $b : line['$start_with?']($$($nesting, 'CAN')))) ? $a : line['$include?']($$($nesting, 'CAN')));}, $$15.$$s = self, $$15.$$arity = 1, $$15)).$join($$($nesting, 'LF'))
          } else {
            return ""
          }
        } else {
          return text
        };
      }, $Substitutors_sub_attributes$10.$$arity = -2);
      
      Opal.def(self, '$sub_replacements', $Substitutors_sub_replacements$16 = function $$sub_replacements(text) {
        var $$17, self = this;

        
        if ($truthy($$($nesting, 'ReplaceableTextRx')['$match?'](text))) {
          $send($$($nesting, 'REPLACEMENTS'), 'each', [], ($$17 = function(pattern, replacement, restore){var self = $$17.$$s || this, $$18;

          
            
            if (pattern == null) {
              pattern = nil;
            };
            
            if (replacement == null) {
              replacement = nil;
            };
            
            if (restore == null) {
              restore = nil;
            };
            return (text = $send(text, 'gsub', [pattern], ($$18 = function(){var self = $$18.$$s || this;
              if ($gvars["~"] == null) $gvars["~"] = nil;

            return self.$do_replacement($gvars["~"], replacement, restore)}, $$18.$$s = self, $$18.$$arity = 0, $$18)));}, $$17.$$s = self, $$17.$$arity = 3, $$17))};
        return text;
      }, $Substitutors_sub_replacements$16.$$arity = 1);
      
      Opal.def(self, '$sub_macros', $Substitutors_sub_macros$19 = function $$sub_macros(text) {
        var $a, $$20, $b, $$23, $$26, $$28, $$30, $$31, $$34, $$35, $$36, $$37, $$38, $$39, $$40, self = this, found_square_bracket = nil, found_colon = nil, found_macroish = nil, found_macroish_short = nil, doc_attrs = nil, doc = nil, extensions = nil;
        if (self.document == null) self.document = nil;
        if (self.context == null) self.context = nil;
        if (self.parent == null) self.parent = nil;

        
        found_square_bracket = text['$include?']("[");
        found_colon = text['$include?'](":");
        found_macroish = ($truthy($a = found_square_bracket) ? found_colon : $a);
        found_macroish_short = ($truthy($a = found_macroish) ? text['$include?'](":[") : $a);
        doc_attrs = (doc = self.document).$attributes();
        if ($truthy(($truthy($a = (extensions = doc.$extensions())) ? extensions['$inline_macros?']() : $a))) {
          $send(extensions.$inline_macros(), 'each', [], ($$20 = function(extension){var self = $$20.$$s || this, $$21;

          
            
            if (extension == null) {
              extension = nil;
            };
            return (text = $send(text, 'gsub', [extension.$instance().$regexp()], ($$21 = function(){var self = $$21.$$s || this, $b, $c, $$22, match = nil, target = nil, content = nil, attributes = nil, default_attrs = nil, ext_config = nil, $writer = nil, replacement = nil, inline_subs = nil;
              if ($gvars["~"] == null) $gvars["~"] = nil;

            
              if ($truthy((match = (($b = $gvars['~']) === nil ? nil : $b['$[]'](0)))['$start_with?']($$($nesting, 'RS')))) {
                return (($b = $gvars['~']) === nil ? nil : $b['$[]'](0)).$slice(1, (($b = $gvars['~']) === nil ? nil : $b['$[]'](0)).$length());};
              if ($truthy($gvars["~"].$names()['$empty?']())) {
                $b = [(($c = $gvars['~']) === nil ? nil : $c['$[]'](1)), (($c = $gvars['~']) === nil ? nil : $c['$[]'](2))], (target = $b[0]), (content = $b[1]), $b
              } else {
                $b = [(function() { try {
                  return $gvars["~"]['$[]']("target")
                } catch ($err) {
                  if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
                    try {
                      return nil
                    } finally { Opal.pop_exception() }
                  } else { throw $err; }
                }})(), (function() { try {
                  return $gvars["~"]['$[]']("content")
                } catch ($err) {
                  if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
                    try {
                      return nil
                    } finally { Opal.pop_exception() }
                  } else { throw $err; }
                }})()], (target = $b[0]), (content = $b[1]), $b
              };
              attributes = (function() {if ($truthy((default_attrs = (ext_config = extension.$config())['$[]']("default_attrs")))) {
                return default_attrs.$merge()
              } else {
                return $hash2([], {})
              }; return nil; })();
              if ($truthy(content)) {
                
                if ($truthy(content['$empty?']())) {
                  if (ext_config['$[]']("content_model")['$==']("attributes")) {
                  } else {
                    
                    $writer = ["text", content];
                    $send(attributes, '[]=', Opal.to_a($writer));
                    $writer[$rb_minus($writer["length"], 1)];
                  }
                } else {
                  
                  content = self.$normalize_text(content, true, true);
                  if (ext_config['$[]']("content_model")['$==']("attributes")) {
                    self.$parse_attributes(content, ($truthy($b = ($truthy($c = ext_config['$[]']("positional_attrs")) ? $c : ext_config['$[]']("pos_attrs"))) ? $b : []), $hash2(["into"], {"into": attributes}))
                  } else {
                    
                    $writer = ["text", content];
                    $send(attributes, '[]=', Opal.to_a($writer));
                    $writer[$rb_minus($writer["length"], 1)];
                  };
                };
                target = ($truthy($b = target) ? $b : (function() {if (ext_config['$[]']("format")['$==']("short")) {
                  return content
                } else {
                  return target
                }; return nil; })());};
              if ($truthy($$($nesting, 'Inline')['$===']((replacement = extension.$process_method()['$[]'](self, target, attributes))))) {
                
                if ($truthy(($truthy($b = (inline_subs = replacement.$attributes().$delete("subs"))) ? (inline_subs = self.$expand_subs(inline_subs, "custom inline macro")) : $b))) {
                  
                  $writer = [self.$apply_subs(replacement.$text(), inline_subs)];
                  $send(replacement, 'text=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];};
                return replacement.$convert();
              } else if ($truthy(replacement)) {
                
                $send(self.$logger(), 'info', [], ($$22 = function(){var self = $$22.$$s || this;

                return "" + "expected substitution value for custom inline macro to be of type Inline; got " + (replacement.$class()) + ": " + (match)}, $$22.$$s = self, $$22.$$arity = 0, $$22));
                return replacement;
              } else {
                return ""
              };}, $$21.$$s = self, $$21.$$arity = 0, $$21)));}, $$20.$$s = self, $$20.$$arity = 1, $$20))};
        if ($truthy(doc_attrs['$key?']("experimental"))) {
          
          if ($truthy(($truthy($a = found_macroish_short) ? ($truthy($b = text['$include?']("kbd:")) ? $b : text['$include?']("btn:")) : $a))) {
            text = $send(text, 'gsub', [$$($nesting, 'InlineKbdBtnMacroRx')], ($$23 = function(){var self = $$23.$$s || this, $c, $$24, $$25, keys = nil, delim_idx = nil, delim = nil, $writer = nil;

            if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](1)))) {
                return (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$slice(1, (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$length())
              } else if ((($c = $gvars['~']) === nil ? nil : $c['$[]'](2))['$==']("kbd")) {
                
                if ($truthy((keys = (($c = $gvars['~']) === nil ? nil : $c['$[]'](3)).$strip())['$include?']($$($nesting, 'R_SB')))) {
                  keys = keys.$gsub($$($nesting, 'ESC_R_SB'), $$($nesting, 'R_SB'))};
                if ($truthy(($truthy($c = $rb_gt(keys.$length(), 1)) ? (delim_idx = (function() {if ($truthy((delim_idx = keys.$index(",", 1)))) {
                  return [delim_idx, keys.$index("+", 1)].$compact().$min()
                } else {
                  
                  return keys.$index("+", 1);
                }; return nil; })()) : $c))) {
                  
                  delim = keys.$slice(delim_idx, 1);
                  if ($truthy(keys['$end_with?'](delim))) {
                    
                    keys = $send(keys.$chop().$split(delim, -1), 'map', [], ($$24 = function(key){var self = $$24.$$s || this;

                    
                      
                      if (key == null) {
                        key = nil;
                      };
                      return key.$strip();}, $$24.$$s = self, $$24.$$arity = 1, $$24));
                    
                    $writer = [-1, $rb_plus(keys['$[]'](-1), delim)];
                    $send(keys, '[]=', Opal.to_a($writer));
                    $writer[$rb_minus($writer["length"], 1)];;
                  } else {
                    keys = $send(keys.$split(delim), 'map', [], ($$25 = function(key){var self = $$25.$$s || this;

                    
                      
                      if (key == null) {
                        key = nil;
                      };
                      return key.$strip();}, $$25.$$s = self, $$25.$$arity = 1, $$25))
                  };
                } else {
                  keys = [keys]
                };
                return $$($nesting, 'Inline').$new(self, "kbd", nil, $hash2(["attributes"], {"attributes": $hash2(["keys"], {"keys": keys})})).$convert();
              } else {
                return $$($nesting, 'Inline').$new(self, "button", self.$normalize_text((($c = $gvars['~']) === nil ? nil : $c['$[]'](3)), true, true)).$convert()
              }}, $$23.$$s = self, $$23.$$arity = 0, $$23))};
          if ($truthy(($truthy($a = found_macroish) ? text['$include?']("menu:") : $a))) {
            text = $send(text, 'gsub', [$$($nesting, 'InlineMenuMacroRx')], ($$26 = function(){var self = $$26.$$s || this, $c, $$27, menu = nil, items = nil, delim = nil, submenus = nil, menuitem = nil;

            
              if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](0))['$start_with?']($$($nesting, 'RS')))) {
                return (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$slice(1, (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$length());};
              menu = (($c = $gvars['~']) === nil ? nil : $c['$[]'](1));
              if ($truthy((items = (($c = $gvars['~']) === nil ? nil : $c['$[]'](2))))) {
                
                if ($truthy(items['$include?']($$($nesting, 'R_SB')))) {
                  items = items.$gsub($$($nesting, 'ESC_R_SB'), $$($nesting, 'R_SB'))};
                if ($truthy((delim = (function() {if ($truthy(items['$include?']("&gt;"))) {
                  return "&gt;"
                } else {
                  
                  if ($truthy(items['$include?'](","))) {
                    return ","
                  } else {
                    return nil
                  };
                }; return nil; })()))) {
                  
                  submenus = $send(items.$split(delim), 'map', [], ($$27 = function(it){var self = $$27.$$s || this;

                  
                    
                    if (it == null) {
                      it = nil;
                    };
                    return it.$strip();}, $$27.$$s = self, $$27.$$arity = 1, $$27));
                  menuitem = submenus.$pop();
                } else {
                  $c = [[], items.$rstrip()], (submenus = $c[0]), (menuitem = $c[1]), $c
                };
              } else {
                $c = [[], nil], (submenus = $c[0]), (menuitem = $c[1]), $c
              };
              return $$($nesting, 'Inline').$new(self, "menu", nil, $hash2(["attributes"], {"attributes": $hash2(["menu", "submenus", "menuitem"], {"menu": menu, "submenus": submenus, "menuitem": menuitem})})).$convert();}, $$26.$$s = self, $$26.$$arity = 0, $$26))};
          if ($truthy(($truthy($a = text['$include?']("\"")) ? text['$include?']("&gt;") : $a))) {
            text = $send(text, 'gsub', [$$($nesting, 'InlineMenuRx')], ($$28 = function(){var self = $$28.$$s || this, $c, $d, $e, $$29, menu = nil, submenus = nil, menuitem = nil;

            
              if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](0))['$start_with?']($$($nesting, 'RS')))) {
                return (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$slice(1, (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$length());};
              $d = $send((($e = $gvars['~']) === nil ? nil : $e['$[]'](1)).$split("&gt;"), 'map', [], ($$29 = function(it){var self = $$29.$$s || this;

              
                
                if (it == null) {
                  it = nil;
                };
                return it.$strip();}, $$29.$$s = self, $$29.$$arity = 1, $$29)), $c = Opal.to_ary($d), (menu = ($c[0] == null ? nil : $c[0])), (submenus = $slice.call($c, 1)), $d;
              menuitem = submenus.$pop();
              return $$($nesting, 'Inline').$new(self, "menu", nil, $hash2(["attributes"], {"attributes": $hash2(["menu", "submenus", "menuitem"], {"menu": menu, "submenus": submenus, "menuitem": menuitem})})).$convert();}, $$28.$$s = self, $$28.$$arity = 0, $$28))};};
        if ($truthy(($truthy($a = found_macroish) ? ($truthy($b = text['$include?']("image:")) ? $b : text['$include?']("icon:")) : $a))) {
          text = $send(text, 'gsub', [$$($nesting, 'InlineImageMacroRx')], ($$30 = function(){var self = $$30.$$s || this, $c, type = nil, posattrs = nil, target = nil, attrs = nil, $writer = nil;

          
            if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](0))['$start_with?']($$($nesting, 'RS')))) {
              return (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$slice(1, (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$length());
            } else if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](0))['$start_with?']("icon:"))) {
              $c = ["icon", ["size"]], (type = $c[0]), (posattrs = $c[1]), $c
            } else {
              $c = ["image", ["alt", "width", "height"]], (type = $c[0]), (posattrs = $c[1]), $c
            };
            target = (($c = $gvars['~']) === nil ? nil : $c['$[]'](1));
            attrs = self.$parse_attributes((($c = $gvars['~']) === nil ? nil : $c['$[]'](2)), posattrs, $hash2(["unescape_input"], {"unescape_input": true}));
            if (type['$==']("icon")) {
            } else {
              
              doc.$register("images", target);
              
              $writer = ["imagesdir", doc_attrs['$[]']("imagesdir")];
              $send(attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
            };
            ($truthy($c = attrs['$[]']("alt")) ? $c : (($writer = ["alt", (($writer = ["default-alt", $$($nesting, 'Helpers').$basename(target, true).$tr("_-", " ")]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
            return $$($nesting, 'Inline').$new(self, "image", nil, $hash2(["type", "target", "attributes"], {"type": type, "target": target, "attributes": attrs})).$convert();}, $$30.$$s = self, $$30.$$arity = 0, $$30))};
        if ($truthy(($truthy($a = ($truthy($b = text['$include?']("((")) ? text['$include?']("))") : $b)) ? $a : ($truthy($b = found_macroish_short) ? text['$include?']("dexterm") : $b)))) {
          text = $send(text, 'gsub', [$$($nesting, 'InlineIndextermMacroRx')], ($$31 = function(){var self = $$31.$$s || this, $c, $$32, $d, $$33, $case = nil, attrlist = nil, primary = nil, attrs = nil, $writer = nil, see_also = nil, term = nil, encl_text = nil, visible = nil, before = nil, after = nil, _ = nil, see = nil, subbed_term = nil, terms = nil;

          return (function() {$case = (($c = $gvars['~']) === nil ? nil : $c['$[]'](1));
            if ("indexterm"['$===']($case)) {
            if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](0))['$start_with?']($$($nesting, 'RS')))) {
              return (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$slice(1, (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$length());};
            if ($truthy((attrlist = self.$normalize_text((($c = $gvars['~']) === nil ? nil : $c['$[]'](2)), true, true))['$include?']("="))) {
              if ($truthy((primary = (attrs = $$($nesting, 'AttributeList').$new(attrlist, self).$parse())['$[]'](1)))) {
                
                
                $writer = ["terms", [primary]];
                $send(attrs, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                if ($truthy((see_also = attrs['$[]']("see-also")))) {
                  
                  $writer = ["see-also", (function() {if ($truthy(see_also['$include?'](","))) {
                    return $send(see_also.$split(","), 'map', [], ($$32 = function(it){var self = $$32.$$s || this;

                    
                      
                      if (it == null) {
                        it = nil;
                      };
                      return it.$lstrip();}, $$32.$$s = self, $$32.$$arity = 1, $$32))
                  } else {
                    return [see_also]
                  }; return nil; })()];
                  $send(attrs, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];};
              } else {
                attrs = $hash2(["terms"], {"terms": attrlist})
              }
            } else {
              attrs = $hash2(["terms"], {"terms": self.$split_simple_csv(attrlist)})
            };
            return $$($nesting, 'Inline').$new(self, "indexterm", nil, $hash2(["attributes"], {"attributes": attrs})).$convert();}
            else if ("indexterm2"['$===']($case)) {
            if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](0))['$start_with?']($$($nesting, 'RS')))) {
              return (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$slice(1, (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$length());};
            if ($truthy((term = self.$normalize_text((($c = $gvars['~']) === nil ? nil : $c['$[]'](2)), true, true))['$include?']("="))) {
              
              term = ($truthy($c = ($truthy($d = (attrs = $$($nesting, 'AttributeList').$new(term, self).$parse())['$[]'](1)) ? $d : (attrs = nil))) ? $c : term);
              if ($truthy(($truthy($c = attrs) ? (see_also = attrs['$[]']("see-also")) : $c))) {
                
                $writer = ["see-also", (function() {if ($truthy(see_also['$include?'](","))) {
                  return $send(see_also.$split(","), 'map', [], ($$33 = function(it){var self = $$33.$$s || this;

                  
                    
                    if (it == null) {
                      it = nil;
                    };
                    return it.$lstrip();}, $$33.$$s = self, $$33.$$arity = 1, $$33))
                } else {
                  return [see_also]
                }; return nil; })()];
                $send(attrs, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];};};
            return $$($nesting, 'Inline').$new(self, "indexterm", term, $hash2(["attributes", "type"], {"attributes": attrs, "type": "visible"})).$convert();}
            else {
            encl_text = (($c = $gvars['~']) === nil ? nil : $c['$[]'](3));
            if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](0))['$start_with?']($$($nesting, 'RS')))) {
              if ($truthy(($truthy($c = encl_text['$start_with?']("(")) ? encl_text['$end_with?'](")") : $c))) {
                
                encl_text = encl_text.$slice(1, $rb_minus(encl_text.$length(), 2));
                $c = [true, "(", ")"], (visible = $c[0]), (before = $c[1]), (after = $c[2]), $c;
              } else {
                return (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$slice(1, (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$length());
              }
            } else {
              
              visible = true;
              if ($truthy(encl_text['$start_with?']("("))) {
                if ($truthy(encl_text['$end_with?'](")"))) {
                  $c = [encl_text.$slice(1, $rb_minus(encl_text.$length(), 2)), false], (encl_text = $c[0]), (visible = $c[1]), $c
                } else {
                  $c = [encl_text.$slice(1, encl_text.$length()), "(", ""], (encl_text = $c[0]), (before = $c[1]), (after = $c[2]), $c
                }
              } else if ($truthy(encl_text['$end_with?'](")"))) {
                $c = [encl_text.$chop(), "", ")"], (encl_text = $c[0]), (before = $c[1]), (after = $c[2]), $c};
            };
            if ($truthy(visible)) {
              
              if ($truthy((term = self.$normalize_text(encl_text, true))['$include?'](";&"))) {
                if ($truthy(term['$include?'](" &gt;&gt; "))) {
                  
                  $d = term.$partition(" &gt;&gt; "), $c = Opal.to_ary($d), (term = ($c[0] == null ? nil : $c[0])), (_ = ($c[1] == null ? nil : $c[1])), (see = ($c[2] == null ? nil : $c[2])), $d;
                  attrs = $hash2(["see"], {"see": see});
                } else if ($truthy(term['$include?'](" &amp;&gt; "))) {
                  
                  $d = term.$split(" &amp;&gt; "), $c = Opal.to_ary($d), (term = ($c[0] == null ? nil : $c[0])), (see_also = $slice.call($c, 1)), $d;
                  attrs = $hash2(["see-also"], {"see-also": see_also});}};
              subbed_term = $$($nesting, 'Inline').$new(self, "indexterm", term, $hash2(["attributes", "type"], {"attributes": attrs, "type": "visible"})).$convert();
            } else {
              
              attrs = $hash2([], {});
              if ($truthy((terms = self.$normalize_text(encl_text, true))['$include?'](";&"))) {
                if ($truthy(terms['$include?'](" &gt;&gt; "))) {
                  
                  $d = terms.$partition(" &gt;&gt; "), $c = Opal.to_ary($d), (terms = ($c[0] == null ? nil : $c[0])), (_ = ($c[1] == null ? nil : $c[1])), (see = ($c[2] == null ? nil : $c[2])), $d;
                  
                  $writer = ["see", see];
                  $send(attrs, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];;
                } else if ($truthy(terms['$include?'](" &amp;&gt; "))) {
                  
                  $d = terms.$split(" &amp;&gt; "), $c = Opal.to_ary($d), (terms = ($c[0] == null ? nil : $c[0])), (see_also = $slice.call($c, 1)), $d;
                  
                  $writer = ["see-also", see_also];
                  $send(attrs, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];;}};
              
              $writer = ["terms", self.$split_simple_csv(terms)];
              $send(attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              subbed_term = $$($nesting, 'Inline').$new(self, "indexterm", nil, $hash2(["attributes"], {"attributes": attrs})).$convert();
            };
            if ($truthy(before)) {
              return "" + (before) + (subbed_term) + (after)
            } else {
              return subbed_term
            };}})()}, $$31.$$s = self, $$31.$$arity = 0, $$31))};
        if ($truthy(($truthy($a = found_colon) ? text['$include?']("://") : $a))) {
          text = $send(text, 'gsub', [$$($nesting, 'InlineLinkRx')], ($$34 = function(){var self = $$34.$$s || this, $c, $d, target = nil, prefix = nil, suffix = nil, link_text = nil, $case = nil, attrs = nil, link_opts = nil, new_link_text = nil, $writer = nil, bare = nil;

          
            if ($truthy((target = (($c = $gvars['~']) === nil ? nil : $c['$[]'](2)))['$start_with?']($$($nesting, 'RS')))) {
              return "" + ((($c = $gvars['~']) === nil ? nil : $c['$[]'](1))) + (target.$slice(1, target.$length())) + ((($c = $gvars['~']) === nil ? nil : $c['$[]'](4)));};
            $c = [(($d = $gvars['~']) === nil ? nil : $d['$[]'](1)), ""], (prefix = $c[0]), (suffix = $c[1]), $c;
            if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](4)))) {
              
              if (prefix['$==']("link:")) {
                prefix = ""};
              if ($truthy((link_text = (($c = $gvars['~']) === nil ? nil : $c['$[]'](4)))['$empty?']())) {
                link_text = nil};
            } else {
              
              $case = prefix;
              if ("link:"['$===']($case) || "\""['$===']($case) || "'"['$===']($case)) {return (($c = $gvars['~']) === nil ? nil : $c['$[]'](0));};
              $case = (($c = $gvars['~']) === nil ? nil : $c['$[]'](3));
              if (")"['$===']($case) || "?"['$===']($case) || "!"['$===']($case)) {
              target = target.$chop();
              if ($truthy((($c = (suffix = (($d = $gvars['~']) === nil ? nil : $d['$[]'](3)))['$=='](")")) ? target['$end_with?'](".", "?", "!") : (suffix = (($d = $gvars['~']) === nil ? nil : $d['$[]'](3)))['$=='](")")))) {
                
                suffix = $rb_plus(target['$[]'](-1), suffix);
                target = target.$chop();};
              if ($truthy(target['$end_with?']("://"))) {
                return (($c = $gvars['~']) === nil ? nil : $c['$[]'](0));};}
              else if (";"['$===']($case)) {
              if ($truthy(($truthy($c = prefix['$start_with?']("&lt;")) ? target['$end_with?']("&gt;") : $c))) {
                
                prefix = prefix.$slice(4, prefix.$length());
                target = target.$slice(0, $rb_minus(target.$length(), 4));
              } else if ($truthy((target = target.$chop())['$end_with?'](")"))) {
                
                target = target.$chop();
                suffix = ");";
              } else {
                suffix = ";"
              };
              if ($truthy(target['$end_with?']("://"))) {
                return (($c = $gvars['~']) === nil ? nil : $c['$[]'](0));};}
              else if (":"['$===']($case)) {
              if ($truthy((target = target.$chop())['$end_with?'](")"))) {
                
                target = target.$chop();
                suffix = "):";
              } else {
                suffix = ":"
              };
              if ($truthy(target['$end_with?']("://"))) {
                return (($c = $gvars['~']) === nil ? nil : $c['$[]'](0));};};
            };
            $c = [nil, $hash2(["type"], {"type": "link"})], (attrs = $c[0]), (link_opts = $c[1]), $c;
            if ($truthy(link_text)) {
              
              if ($truthy(link_text['$include?']($$($nesting, 'R_SB')))) {
                new_link_text = (link_text = link_text.$gsub($$($nesting, 'ESC_R_SB'), $$($nesting, 'R_SB')))};
              if ($truthy(($truthy($c = doc.$compat_mode()['$!']()) ? link_text['$include?']("=") : $c))) {
                
                $d = self.$extract_attributes_from_text(link_text, ""), $c = Opal.to_ary($d), (link_text = ($c[0] == null ? nil : $c[0])), (attrs = ($c[1] == null ? nil : $c[1])), $d;
                new_link_text = link_text;
                
                $writer = ["id", attrs['$[]']("id")];
                $send(link_opts, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;};
              if ($truthy(link_text['$end_with?']("^"))) {
                
                new_link_text = (link_text = link_text.$chop());
                if ($truthy(attrs)) {
                  ($truthy($c = attrs['$[]']("window")) ? $c : (($writer = ["window", "_blank"]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))
                } else {
                  attrs = $hash2(["window"], {"window": "_blank"})
                };};
              if ($truthy(($truthy($c = new_link_text) ? new_link_text['$empty?']() : $c))) {
                
                link_text = (function() {if ($truthy(doc_attrs['$key?']("hide-uri-scheme"))) {
                  
                  return target.$sub($$($nesting, 'UriSniffRx'), "");
                } else {
                  return target
                }; return nil; })();
                bare = true;};
            } else {
              
              link_text = (function() {if ($truthy(doc_attrs['$key?']("hide-uri-scheme"))) {
                
                return target.$sub($$($nesting, 'UriSniffRx'), "");
              } else {
                return target
              }; return nil; })();
              bare = true;
            };
            if ($truthy(bare)) {
              if ($truthy(attrs)) {
                
                $writer = ["role", (function() {if ($truthy(attrs['$key?']("role"))) {
                  return "" + "bare " + (attrs['$[]']("role"))
                } else {
                  return "bare"
                }; return nil; })()];
                $send(attrs, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];
              } else {
                attrs = $hash2(["role"], {"role": "bare"})
              }};
            doc.$register("links", (($writer = ["target", target]), $send(link_opts, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
            if ($truthy(attrs)) {
              
              $writer = ["attributes", attrs];
              $send(link_opts, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
            return "" + (prefix) + ($$($nesting, 'Inline').$new(self, "anchor", link_text, link_opts).$convert()) + (suffix);}, $$34.$$s = self, $$34.$$arity = 0, $$34))};
        if ($truthy(($truthy($a = found_macroish) ? ($truthy($b = text['$include?']("link:")) ? $b : text['$include?']("ilto:")) : $a))) {
          text = $send(text, 'gsub', [$$($nesting, 'InlineLinkMacroRx')], ($$35 = function(){var self = $$35.$$s || this, $c, $d, mailto = nil, target = nil, mailto_text = nil, attrs = nil, link_opts = nil, link_text = nil, $writer = nil;

          
            if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](0))['$start_with?']($$($nesting, 'RS')))) {
              return (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$slice(1, (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$length());
            } else if ($truthy((mailto = (($c = $gvars['~']) === nil ? nil : $c['$[]'](1))))) {
              target = $rb_plus("mailto:", (mailto_text = (($c = $gvars['~']) === nil ? nil : $c['$[]'](2))))
            } else {
              target = (($c = $gvars['~']) === nil ? nil : $c['$[]'](2))
            };
            $c = [nil, $hash2(["type"], {"type": "link"})], (attrs = $c[0]), (link_opts = $c[1]), $c;
            if ($truthy((link_text = (($c = $gvars['~']) === nil ? nil : $c['$[]'](3)))['$empty?']())) {
            } else {
              
              if ($truthy(link_text['$include?']($$($nesting, 'R_SB')))) {
                link_text = link_text.$gsub($$($nesting, 'ESC_R_SB'), $$($nesting, 'R_SB'))};
              if ($truthy(mailto)) {
                if ($truthy(($truthy($c = doc.$compat_mode()['$!']()) ? link_text['$include?'](",") : $c))) {
                  
                  $d = self.$extract_attributes_from_text(link_text, ""), $c = Opal.to_ary($d), (link_text = ($c[0] == null ? nil : $c[0])), (attrs = ($c[1] == null ? nil : $c[1])), $d;
                  
                  $writer = ["id", attrs['$[]']("id")];
                  $send(link_opts, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];;
                  if ($truthy(attrs['$key?'](2))) {
                    if ($truthy(attrs['$key?'](3))) {
                      target = "" + (target) + "?subject=" + ($$($nesting, 'Helpers').$encode_uri_component(attrs['$[]'](2))) + "&amp;body=" + ($$($nesting, 'Helpers').$encode_uri_component(attrs['$[]'](3)))
                    } else {
                      target = "" + (target) + "?subject=" + ($$($nesting, 'Helpers').$encode_uri_component(attrs['$[]'](2)))
                    }};}
              } else if ($truthy(($truthy($c = doc.$compat_mode()['$!']()) ? link_text['$include?']("=") : $c))) {
                
                $d = self.$extract_attributes_from_text(link_text, ""), $c = Opal.to_ary($d), (link_text = ($c[0] == null ? nil : $c[0])), (attrs = ($c[1] == null ? nil : $c[1])), $d;
                
                $writer = ["id", attrs['$[]']("id")];
                $send(link_opts, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;};
              if ($truthy(link_text['$end_with?']("^"))) {
                
                link_text = link_text.$chop();
                if ($truthy(attrs)) {
                  ($truthy($c = attrs['$[]']("window")) ? $c : (($writer = ["window", "_blank"]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))
                } else {
                  attrs = $hash2(["window"], {"window": "_blank"})
                };};
            };
            if ($truthy(link_text['$empty?']())) {
              if ($truthy(mailto)) {
                link_text = mailto_text
              } else {
                
                if ($truthy(doc_attrs['$key?']("hide-uri-scheme"))) {
                  if ($truthy((link_text = target.$sub($$($nesting, 'UriSniffRx'), ""))['$empty?']())) {
                    link_text = target}
                } else {
                  link_text = target
                };
                if ($truthy(attrs)) {
                  
                  $writer = ["role", (function() {if ($truthy(attrs['$key?']("role"))) {
                    return "" + "bare " + (attrs['$[]']("role"))
                  } else {
                    return "bare"
                  }; return nil; })()];
                  $send(attrs, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];
                } else {
                  attrs = $hash2(["role"], {"role": "bare"})
                };
              }};
            doc.$register("links", (($writer = ["target", target]), $send(link_opts, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
            if ($truthy(attrs)) {
              
              $writer = ["attributes", attrs];
              $send(link_opts, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
            return $$($nesting, 'Inline').$new(self, "anchor", link_text, link_opts).$convert();}, $$35.$$s = self, $$35.$$arity = 0, $$35))};
        if ($truthy(text['$include?']("@"))) {
          text = $send(text, 'gsub', [$$($nesting, 'InlineEmailRx')], ($$36 = function(){var self = $$36.$$s || this, $c, target = nil, address = nil;

          
            if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](1)))) {
              return (function() {if ((($c = $gvars['~']) === nil ? nil : $c['$[]'](1))['$==']($$($nesting, 'RS'))) {
                
                return (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$slice(1, (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$length());
              } else {
                return (($c = $gvars['~']) === nil ? nil : $c['$[]'](0))
              }; return nil; })();};
            target = $rb_plus("mailto:", (address = (($c = $gvars['~']) === nil ? nil : $c['$[]'](0))));
            doc.$register("links", target);
            return $$($nesting, 'Inline').$new(self, "anchor", address, $hash2(["type", "target"], {"type": "link", "target": target})).$convert();}, $$36.$$s = self, $$36.$$arity = 0, $$36))};
        if ($truthy(($truthy($a = ($truthy($b = found_square_bracket) ? self.context['$==']("list_item") : $b)) ? self.parent.$style()['$==']("bibliography") : $a))) {
          text = $send(text, 'sub', [$$($nesting, 'InlineBiblioAnchorRx')], ($$37 = function(){var self = $$37.$$s || this, $c;

          return $$($nesting, 'Inline').$new(self, "anchor", (($c = $gvars['~']) === nil ? nil : $c['$[]'](2)), $hash2(["type", "id"], {"type": "bibref", "id": (($c = $gvars['~']) === nil ? nil : $c['$[]'](1))})).$convert()}, $$37.$$s = self, $$37.$$arity = 0, $$37))};
        if ($truthy(($truthy($a = ($truthy($b = found_square_bracket) ? text['$include?']("[[") : $b)) ? $a : ($truthy($b = found_macroish) ? text['$include?']("or:") : $b)))) {
          text = $send(text, 'gsub', [$$($nesting, 'InlineAnchorRx')], ($$38 = function(){var self = $$38.$$s || this, $c, $d, id = nil, reftext = nil;

          
            if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](1)))) {
              return (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$slice(1, (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$length());};
            if ($truthy((id = (($c = $gvars['~']) === nil ? nil : $c['$[]'](2))))) {
              reftext = (($c = $gvars['~']) === nil ? nil : $c['$[]'](3))
            } else {
              
              id = (($c = $gvars['~']) === nil ? nil : $c['$[]'](4));
              if ($truthy(($truthy($c = (reftext = (($d = $gvars['~']) === nil ? nil : $d['$[]'](5)))) ? reftext['$include?']($$($nesting, 'R_SB')) : $c))) {
                reftext = reftext.$gsub($$($nesting, 'ESC_R_SB'), $$($nesting, 'R_SB'))};
            };
            return $$($nesting, 'Inline').$new(self, "anchor", reftext, $hash2(["type", "id"], {"type": "ref", "id": id})).$convert();}, $$38.$$s = self, $$38.$$arity = 0, $$38))};
        if ($truthy(($truthy($a = ($truthy($b = text['$include?']("&")) ? text['$include?'](";&l") : $b)) ? $a : ($truthy($b = found_macroish) ? text['$include?']("xref:") : $b)))) {
          text = $send(text, 'gsub', [$$($nesting, 'InlineXrefMacroRx')], ($$39 = function(){var self = $$39.$$s || this, $c, $d, attrs = nil, refid = nil, _ = nil, link_text = nil, macro = nil, fragment = nil, hash_idx = nil, fragment_len = nil, path = nil, src2src = nil, target = nil, $writer = nil;

          
            if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](0))['$start_with?']($$($nesting, 'RS')))) {
              return (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$slice(1, (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$length());};
            attrs = $hash2([], {});
            if ($truthy((refid = (($c = $gvars['~']) === nil ? nil : $c['$[]'](1))))) {
              if ($truthy(refid['$include?'](","))) {
                
                $d = refid.$partition(","), $c = Opal.to_ary($d), (refid = ($c[0] == null ? nil : $c[0])), (_ = ($c[1] == null ? nil : $c[1])), (link_text = ($c[2] == null ? nil : $c[2])), $d;
                if ($truthy((link_text = link_text.$lstrip())['$empty?']())) {
                  link_text = nil};}
            } else {
              
              macro = true;
              refid = (($c = $gvars['~']) === nil ? nil : $c['$[]'](2));
              if ($truthy((link_text = (($c = $gvars['~']) === nil ? nil : $c['$[]'](3))))) {
                
                if ($truthy(link_text['$include?']($$($nesting, 'R_SB')))) {
                  link_text = link_text.$gsub($$($nesting, 'ESC_R_SB'), $$($nesting, 'R_SB'))};
                if ($truthy(($truthy($c = doc.$compat_mode()['$!']()) ? link_text['$include?']("=") : $c))) {
                  $d = self.$extract_attributes_from_text(link_text), $c = Opal.to_ary($d), (link_text = ($c[0] == null ? nil : $c[0])), (attrs = ($c[1] == null ? nil : $c[1])), $d};};
            };
            if ($truthy(doc.$compat_mode())) {
              fragment = refid
            } else if ($truthy((hash_idx = refid.$index("#")))) {
              if ($truthy($rb_gt(hash_idx, 0))) {
                
                if ($truthy($rb_gt((fragment_len = $rb_minus($rb_minus(refid.$length(), 1), hash_idx)), 0))) {
                  $c = [refid.$slice(0, hash_idx), refid.$slice($rb_plus(hash_idx, 1), fragment_len)], (path = $c[0]), (fragment = $c[1]), $c
                } else {
                  path = refid.$chop()
                };
                if ($truthy(macro)) {
                  if ($truthy(path['$end_with?'](".adoc"))) {
                    src2src = (path = path.$slice(0, $rb_minus(path.$length(), 5)))
                  } else if ($truthy($$($nesting, 'Helpers')['$extname?'](path)['$!']())) {
                    src2src = path}
                } else if ($truthy($send(path, 'end_with?', Opal.to_a($$($nesting, 'ASCIIDOC_EXTENSIONS').$keys())))) {
                  src2src = (path = path.$slice(0, path.$rindex(".")))
                } else {
                  src2src = path
                };
              } else {
                $c = [refid, refid.$slice(1, refid.$length())], (target = $c[0]), (fragment = $c[1]), $c
              }
            } else if ($truthy(macro)) {
              if ($truthy(refid['$end_with?'](".adoc"))) {
                src2src = (path = refid.$slice(0, $rb_minus(refid.$length(), 5)))
              } else if ($truthy($$($nesting, 'Helpers')['$extname?'](refid))) {
                path = refid
              } else {
                fragment = refid
              }
            } else {
              fragment = refid
            };
            if ($truthy(target)) {
              
              refid = fragment;
              if ($truthy(($truthy($c = self.$logger()['$info?']()) ? doc.$catalog()['$[]']("refs")['$[]'](refid)['$!']() : $c))) {
                self.$logger().$info("" + "possible invalid reference: " + (refid))};
            } else if ($truthy(path)) {
              if ($truthy(($truthy($c = src2src) ? ($truthy($d = doc.$attributes()['$[]']("docname")['$=='](path)) ? $d : doc.$catalog()['$[]']("includes")['$[]'](path)) : $c))) {
                if ($truthy(fragment)) {
                  
                  $c = [fragment, nil, "" + "#" + (fragment)], (refid = $c[0]), (path = $c[1]), (target = $c[2]), $c;
                  if ($truthy(($truthy($c = self.$logger()['$info?']()) ? doc.$catalog()['$[]']("refs")['$[]'](refid)['$!']() : $c))) {
                    self.$logger().$info("" + "possible invalid reference: " + (refid))};
                } else {
                  $c = [nil, nil, "#"], (refid = $c[0]), (path = $c[1]), (target = $c[2]), $c
                }
              } else {
                
                $c = [path, "" + (($truthy($d = doc.$attributes()['$[]']("relfileprefix")) ? $d : "")) + (path) + ((function() {if ($truthy(src2src)) {
                  
                  return doc.$attributes().$fetch("relfilesuffix", doc.$outfilesuffix());
                } else {
                  return ""
                }; return nil; })())], (refid = $c[0]), (path = $c[1]), $c;
                if ($truthy(fragment)) {
                  $c = ["" + (refid) + "#" + (fragment), "" + (path) + "#" + (fragment)], (refid = $c[0]), (target = $c[1]), $c
                } else {
                  target = path
                };
              }
            } else if ($truthy(($truthy($c = doc.$compat_mode()) ? $c : $$($nesting, 'Compliance').$natural_xrefs()['$!']()))) {
              
              $c = [fragment, "" + "#" + (fragment)], (refid = $c[0]), (target = $c[1]), $c;
              if ($truthy(($truthy($c = self.$logger()['$info?']()) ? doc.$catalog()['$[]']("refs")['$[]'](refid)['$!']() : $c))) {
                self.$logger().$info("" + "possible invalid reference: " + (refid))};
            } else if ($truthy(doc.$catalog()['$[]']("refs")['$[]'](fragment))) {
              $c = [fragment, "" + "#" + (fragment)], (refid = $c[0]), (target = $c[1]), $c
            } else if ($truthy(($truthy($c = ($truthy($d = fragment['$include?'](" ")) ? $d : fragment.$downcase()['$!='](fragment))) ? (refid = doc.$resolve_id(fragment)) : $c))) {
              $c = [refid, "" + "#" + (refid)], (fragment = $c[0]), (target = $c[1]), $c
            } else {
              
              $c = [fragment, "" + "#" + (fragment)], (refid = $c[0]), (target = $c[1]), $c;
              if ($truthy(self.$logger()['$info?']())) {
                self.$logger().$info("" + "possible invalid reference: " + (refid))};
            };
            
            $writer = ["path", path];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            
            $writer = ["fragment", fragment];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            
            $writer = ["refid", refid];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            return $$($nesting, 'Inline').$new(self, "anchor", link_text, $hash2(["type", "target", "attributes"], {"type": "xref", "target": target, "attributes": attrs})).$convert();}, $$39.$$s = self, $$39.$$arity = 0, $$39))};
        if ($truthy(($truthy($a = found_macroish) ? text['$include?']("tnote") : $a))) {
          text = $send(text, 'gsub', [$$($nesting, 'InlineFootnoteMacroRx')], ($$40 = function(){var self = $$40.$$s || this, $c, $d, $e, $$41, id = nil, content = nil, footnote = nil, index = nil, type = nil, target = nil;

          
            if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](0))['$start_with?']($$($nesting, 'RS')))) {
              return (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$slice(1, (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$length());};
            if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](1)))) {
              if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](3)))) {
                
                $d = (($e = $gvars['~']) === nil ? nil : $e['$[]'](3)).$split(",", 2), $c = Opal.to_ary($d), (id = ($c[0] == null ? nil : $c[0])), (content = ($c[1] == null ? nil : $c[1])), $d;
                if ($truthy(doc.$compat_mode())) {
                } else {
                  self.$logger().$warn("" + "found deprecated footnoteref macro: " + ((($c = $gvars['~']) === nil ? nil : $c['$[]'](0))) + "; use footnote macro with target instead")
                };
              } else {
                return (($c = $gvars['~']) === nil ? nil : $c['$[]'](0));
              }
            } else {
              
              id = (($c = $gvars['~']) === nil ? nil : $c['$[]'](2));
              content = (($c = $gvars['~']) === nil ? nil : $c['$[]'](3));
            };
            if ($truthy(id)) {
              if ($truthy((footnote = $send(doc.$footnotes(), 'find', [], ($$41 = function(candidate){var self = $$41.$$s || this;

              
                
                if (candidate == null) {
                  candidate = nil;
                };
                return candidate.$id()['$=='](id);}, $$41.$$s = self, $$41.$$arity = 1, $$41))))) {
                
                $c = [footnote.$index(), footnote.$text()], (index = $c[0]), (content = $c[1]), $c;
                $c = ["xref", id, nil], (type = $c[0]), (target = $c[1]), (id = $c[2]), $c;
              } else if ($truthy(content)) {
                
                content = self.$restore_passthroughs(self.$normalize_text(content, true, true));
                index = doc.$counter("footnote-number");
                doc.$register("footnotes", $$$($$($nesting, 'Document'), 'Footnote').$new(index, id, content));
                $c = ["ref", nil], (type = $c[0]), (target = $c[1]), $c;
              } else {
                
                self.$logger().$warn("" + "invalid footnote reference: " + (id));
                $c = ["xref", id, id, nil], (type = $c[0]), (target = $c[1]), (content = $c[2]), (id = $c[3]), $c;
              }
            } else if ($truthy(content)) {
              
              content = self.$restore_passthroughs(self.$normalize_text(content, true, true));
              index = doc.$counter("footnote-number");
              doc.$register("footnotes", $$$($$($nesting, 'Document'), 'Footnote').$new(index, id, content));
              type = (target = nil);
            } else {
              return (($c = $gvars['~']) === nil ? nil : $c['$[]'](0));
            };
            return $$($nesting, 'Inline').$new(self, "footnote", content, $hash2(["attributes", "id", "target", "type"], {"attributes": $hash2(["index"], {"index": index}), "id": id, "target": target, "type": type})).$convert();}, $$40.$$s = self, $$40.$$arity = 0, $$40))};
        return text;
      }, $Substitutors_sub_macros$19.$$arity = 1);
      
      Opal.def(self, '$sub_post_replacements', $Substitutors_sub_post_replacements$42 = function $$sub_post_replacements(text) {
        var $a, $$43, $$44, self = this, lines = nil, last = nil;
        if (self.attributes == null) self.attributes = nil;
        if (self.document == null) self.document = nil;

        if ($truthy(($truthy($a = self.attributes['$[]']("hardbreaks-option")) ? $a : self.document.$attributes()['$[]']("hardbreaks-option")))) {
          
          lines = text.$split($$($nesting, 'LF'), -1);
          if ($truthy($rb_lt(lines.$size(), 2))) {
            return text};
          last = lines.$pop();
          return $send(lines, 'map', [], ($$43 = function(line){var self = $$43.$$s || this;

          
            
            if (line == null) {
              line = nil;
            };
            return $$($nesting, 'Inline').$new(self, "break", (function() {if ($truthy(line['$end_with?']($$($nesting, 'HARD_LINE_BREAK')))) {
              
              return line.$slice(0, $rb_minus(line.$length(), 2));
            } else {
              return line
            }; return nil; })(), $hash2(["type"], {"type": "line"})).$convert();}, $$43.$$s = self, $$43.$$arity = 1, $$43))['$<<'](last).$join($$($nesting, 'LF'));
        } else if ($truthy(($truthy($a = text['$include?']($$($nesting, 'PLUS'))) ? text['$include?']($$($nesting, 'HARD_LINE_BREAK')) : $a))) {
          return $send(text, 'gsub', [$$($nesting, 'HardLineBreakRx')], ($$44 = function(){var self = $$44.$$s || this, $b;

          return $$($nesting, 'Inline').$new(self, "break", (($b = $gvars['~']) === nil ? nil : $b['$[]'](1)), $hash2(["type"], {"type": "line"})).$convert()}, $$44.$$s = self, $$44.$$arity = 0, $$44))
        } else {
          return text
        }
      }, $Substitutors_sub_post_replacements$42.$$arity = 1);
      
      Opal.def(self, '$sub_source', $Substitutors_sub_source$45 = function $$sub_source(source, process_callouts) {
        var self = this;

        if ($truthy(process_callouts)) {
          return self.$sub_callouts(self.$sub_specialchars(source))
        } else {
          
          return self.$sub_specialchars(source);
        }
      }, $Substitutors_sub_source$45.$$arity = 2);
      
      Opal.def(self, '$sub_callouts', $Substitutors_sub_callouts$46 = function $$sub_callouts(text) {
        var $$47, self = this, callout_rx = nil, autonum = nil;

        
        callout_rx = (function() {if ($truthy(self['$attr?']("line-comment"))) {
          return $$($nesting, 'CalloutSourceRxMap')['$[]'](self.$attr("line-comment"))
        } else {
          return $$($nesting, 'CalloutSourceRx')
        }; return nil; })();
        autonum = 0;
        return $send(text, 'gsub', [callout_rx], ($$47 = function(){var self = $$47.$$s || this, $a, $b;
          if (self.document == null) self.document = nil;

        if ($truthy((($a = $gvars['~']) === nil ? nil : $a['$[]'](2)))) {
            return (($a = $gvars['~']) === nil ? nil : $a['$[]'](0)).$sub($$($nesting, 'RS'), "")
          } else {
            return $$($nesting, 'Inline').$new(self, "callout", (function() {if ((($a = $gvars['~']) === nil ? nil : $a['$[]'](4))['$=='](".")) {
              return (autonum = $rb_plus(autonum, 1)).$to_s()
            } else {
              return (($a = $gvars['~']) === nil ? nil : $a['$[]'](4))
            }; return nil; })(), $hash2(["id", "attributes"], {"id": self.document.$callouts().$read_next_id(), "attributes": $hash2(["guard"], {"guard": ($truthy($a = (($b = $gvars['~']) === nil ? nil : $b['$[]'](1))) ? $a : (function() {if ((($b = $gvars['~']) === nil ? nil : $b['$[]'](3))['$==']("--")) {
              return ["<!--", "-->"]
            } else {
              return nil
            }; return nil; })())})})).$convert()
          }}, $$47.$$s = self, $$47.$$arity = 0, $$47));
      }, $Substitutors_sub_callouts$46.$$arity = 1);
      
      Opal.def(self, '$highlight_source', $Substitutors_highlight_source$48 = function $$highlight_source(source, process_callouts) {
        var $a, $b, $c, self = this, syntax_hl = nil, callout_marks = nil, doc_attrs = nil, syntax_hl_name = nil, linenums_mode = nil, start_line_number = nil, highlight_lines = nil, highlighted = nil, source_offset = nil;
        if (self.document == null) self.document = nil;
        if (self.passthroughs == null) self.passthroughs = nil;

        
        if ($truthy(($truthy($a = (syntax_hl = self.document.$syntax_highlighter())) ? syntax_hl['$highlight?']() : $a))) {
        } else {
          return self.$sub_source(source, process_callouts)
        };
        if ($truthy(process_callouts)) {
          $b = self.$extract_callouts(source), $a = Opal.to_ary($b), (source = ($a[0] == null ? nil : $a[0])), (callout_marks = ($a[1] == null ? nil : $a[1])), $b};
        doc_attrs = self.document.$attributes();
        syntax_hl_name = syntax_hl.$name();
        if ($truthy(($truthy($a = (linenums_mode = (function() {if ($truthy(self['$attr?']("linenums"))) {
          return ($truthy($b = doc_attrs['$[]']("" + (syntax_hl_name) + "-linenums-mode")) ? $b : "table").$to_sym()
        } else {
          return nil
        }; return nil; })())) ? $rb_lt((start_line_number = self.$attr("start", 1).$to_i()), 1) : $a))) {
          start_line_number = 1};
        if ($truthy(self['$attr?']("highlight"))) {
          highlight_lines = self.$resolve_lines_to_highlight(source, self.$attr("highlight"), start_line_number)};
        $b = syntax_hl.$highlight(self, source, self.$attr("language"), $hash2(["callouts", "css_mode", "highlight_lines", "number_lines", "start_line_number", "style"], {"callouts": callout_marks, "css_mode": ($truthy($c = doc_attrs['$[]']("" + (syntax_hl_name) + "-css")) ? $c : "class").$to_sym(), "highlight_lines": highlight_lines, "number_lines": linenums_mode, "start_line_number": start_line_number, "style": doc_attrs['$[]']("" + (syntax_hl_name) + "-style")})), $a = Opal.to_ary($b), (highlighted = ($a[0] == null ? nil : $a[0])), (source_offset = ($a[1] == null ? nil : $a[1])), $b;
        if ($truthy(self.passthroughs['$empty?']())) {
        } else {
          highlighted = highlighted.$gsub($$($nesting, 'HighlightedPassSlotRx'), "" + ($$($nesting, 'PASS_START')) + "\\1" + ($$($nesting, 'PASS_END')))
        };
        if ($truthy(callout_marks['$nil_or_empty?']())) {
          return highlighted
        } else {
          
          return self.$restore_callouts(highlighted, callout_marks, source_offset);
        };
      }, $Substitutors_highlight_source$48.$$arity = 2);
      
      Opal.def(self, '$resolve_lines_to_highlight', $Substitutors_resolve_lines_to_highlight$49 = function $$resolve_lines_to_highlight(source, spec, start) {
        var $$50, $$51, self = this, lines = nil, shift = nil;

        
        
        if (start == null) {
          start = nil;
        };
        lines = [];
        if ($truthy(spec['$include?'](" "))) {
          spec = spec.$delete(" ")};
        $send((function() {if ($truthy(spec['$include?'](","))) {
          
          return spec.$split(",");
        } else {
          
          return spec.$split(";");
        }; return nil; })(), 'map', [], ($$50 = function(entry){var self = $$50.$$s || this, $a, $b, negate = nil, delim = nil, from = nil, _ = nil, to = nil, line = nil;

        
          
          if (entry == null) {
            entry = nil;
          };
          if ($truthy(entry['$start_with?']("!"))) {
            
            entry = entry.$slice(1, entry.$length());
            negate = true;};
          if ($truthy((delim = (function() {if ($truthy(entry['$include?'](".."))) {
            return ".."
          } else {
            
            if ($truthy(entry['$include?']("-"))) {
              return "-"
            } else {
              return nil
            };
          }; return nil; })()))) {
            
            $b = entry.$partition(delim), $a = Opal.to_ary($b), (from = ($a[0] == null ? nil : $a[0])), (_ = ($a[1] == null ? nil : $a[1])), (to = ($a[2] == null ? nil : $a[2])), $b;
            if ($truthy(($truthy($a = to['$empty?']()) ? $a : $rb_lt((to = to.$to_i()), 0)))) {
              to = $rb_plus(source.$count($$($nesting, 'LF')), 1)};
            if ($truthy(negate)) {
              return (lines = $rb_minus(lines, Opal.Range.$new(from.$to_i(), to, false).$to_a()))
            } else {
              return (lines = lines['$|'](Opal.Range.$new(from.$to_i(), to, false).$to_a()))
            };
          } else if ($truthy(negate)) {
            return lines.$delete(entry.$to_i())
          } else if ($truthy(lines['$include?']((line = entry.$to_i()))['$!']())) {
            return lines['$<<'](line)
          } else {
            return nil
          };}, $$50.$$s = self, $$50.$$arity = 1, $$50));
        if ((shift = (function() {if ($truthy(start)) {
          return $rb_minus(start, 1)
        } else {
          return 0
        }; return nil; })())['$=='](0)) {
        } else {
          lines = $send(lines, 'map', [], ($$51 = function(it){var self = $$51.$$s || this;

          
            
            if (it == null) {
              it = nil;
            };
            return $rb_minus(it, shift);}, $$51.$$s = self, $$51.$$arity = 1, $$51))
        };
        return lines.$sort();
      }, $Substitutors_resolve_lines_to_highlight$49.$$arity = -3);
      
      Opal.def(self, '$extract_passthroughs', $Substitutors_extract_passthroughs$52 = function $$extract_passthroughs(text) {
        var $a, $b, $$53, $$54, $$55, self = this, compat_mode = nil, passthrus = nil, pass_inline_char1 = nil, pass_inline_char2 = nil, pass_inline_rx = nil;
        if (self.document == null) self.document = nil;
        if (self.passthroughs == null) self.passthroughs = nil;

        
        compat_mode = self.document.$compat_mode();
        passthrus = self.passthroughs;
        if ($truthy(($truthy($a = ($truthy($b = text['$include?']("++")) ? $b : text['$include?']("$$"))) ? $a : text['$include?']("ss:")))) {
          text = $send(text, 'gsub', [$$($nesting, 'InlinePassMacroRx')], ($$53 = function(){var self = $$53.$$s || this, $c, boundary = nil, attrlist = nil, escape_count = nil, preceding = nil, old_behavior = nil, attributes = nil, subs = nil, $writer = nil, passthru_key = nil;

          
            if ($truthy((boundary = (($c = $gvars['~']) === nil ? nil : $c['$[]'](4))))) {
              
              if ($truthy(($truthy($c = compat_mode) ? boundary['$==']("++") : $c))) {
                return "" + ((function() {if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](2)))) {
                  return "" + ((($c = $gvars['~']) === nil ? nil : $c['$[]'](1))) + "[" + ((($c = $gvars['~']) === nil ? nil : $c['$[]'](2))) + "]" + ((($c = $gvars['~']) === nil ? nil : $c['$[]'](3)))
                } else {
                  return "" + ((($c = $gvars['~']) === nil ? nil : $c['$[]'](1))) + ((($c = $gvars['~']) === nil ? nil : $c['$[]'](3)))
                }; return nil; })()) + "++" + (self.$extract_passthroughs((($c = $gvars['~']) === nil ? nil : $c['$[]'](5)))) + "++";};
              if ($truthy((attrlist = (($c = $gvars['~']) === nil ? nil : $c['$[]'](2))))) {
                if ($truthy($rb_gt((escape_count = (($c = $gvars['~']) === nil ? nil : $c['$[]'](3)).$length()), 0))) {
                  return "" + ((($c = $gvars['~']) === nil ? nil : $c['$[]'](1))) + "[" + (attrlist) + "]" + ($rb_times($$($nesting, 'RS'), $rb_minus(escape_count, 1))) + (boundary) + ((($c = $gvars['~']) === nil ? nil : $c['$[]'](5))) + (boundary);
                } else if ((($c = $gvars['~']) === nil ? nil : $c['$[]'](1))['$==']($$($nesting, 'RS'))) {
                  preceding = "" + "[" + (attrlist) + "]"
                } else {
                  
                  if ($truthy((($c = boundary['$==']("++")) ? attrlist['$end_with?']("x-") : boundary['$==']("++")))) {
                    
                    old_behavior = true;
                    attrlist = attrlist.$slice(0, $rb_minus(attrlist.$length(), 2));};
                  attributes = self.$parse_quoted_text_attributes(attrlist);
                }
              } else if ($truthy($rb_gt((escape_count = (($c = $gvars['~']) === nil ? nil : $c['$[]'](3)).$length()), 0))) {
                return "" + ($rb_times($$($nesting, 'RS'), $rb_minus(escape_count, 1))) + (boundary) + ((($c = $gvars['~']) === nil ? nil : $c['$[]'](5))) + (boundary);};
              subs = (function() {if (boundary['$==']("+++")) {
                return []
              } else {
                return $$($nesting, 'BASIC_SUBS')
              }; return nil; })();
              if ($truthy(attributes)) {
                if ($truthy(old_behavior)) {
                  
                  $writer = [(passthru_key = passthrus.$size()), $hash2(["text", "subs", "type", "attributes"], {"text": (($c = $gvars['~']) === nil ? nil : $c['$[]'](5)), "subs": $$($nesting, 'NORMAL_SUBS'), "type": "monospaced", "attributes": attributes})];
                  $send(passthrus, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];
                } else {
                  
                  $writer = [(passthru_key = passthrus.$size()), $hash2(["text", "subs", "type", "attributes"], {"text": (($c = $gvars['~']) === nil ? nil : $c['$[]'](5)), "subs": subs, "type": "unquoted", "attributes": attributes})];
                  $send(passthrus, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];
                }
              } else {
                
                $writer = [(passthru_key = passthrus.$size()), $hash2(["text", "subs"], {"text": (($c = $gvars['~']) === nil ? nil : $c['$[]'](5)), "subs": subs})];
                $send(passthrus, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];
              };
            } else {
              
              if ((($c = $gvars['~']) === nil ? nil : $c['$[]'](6))['$==']($$($nesting, 'RS'))) {
                return (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$slice(1, (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$length());};
              if ($truthy((subs = (($c = $gvars['~']) === nil ? nil : $c['$[]'](7))))) {
                
                $writer = [(passthru_key = passthrus.$size()), $hash2(["text", "subs"], {"text": self.$normalize_text((($c = $gvars['~']) === nil ? nil : $c['$[]'](8)), nil, true), "subs": self.$resolve_pass_subs(subs)})];
                $send(passthrus, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];
              } else {
                
                $writer = [(passthru_key = passthrus.$size()), $hash2(["text"], {"text": self.$normalize_text((($c = $gvars['~']) === nil ? nil : $c['$[]'](8)), nil, true)})];
                $send(passthrus, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];
              };
            };
            return "" + (($truthy($c = preceding) ? $c : "")) + ($$($nesting, 'PASS_START')) + (passthru_key) + ($$($nesting, 'PASS_END'));}, $$53.$$s = self, $$53.$$arity = 0, $$53))};
        $b = $$($nesting, 'InlinePassRx')['$[]'](compat_mode), $a = Opal.to_ary($b), (pass_inline_char1 = ($a[0] == null ? nil : $a[0])), (pass_inline_char2 = ($a[1] == null ? nil : $a[1])), (pass_inline_rx = ($a[2] == null ? nil : $a[2])), $b;
        if ($truthy(($truthy($a = text['$include?'](pass_inline_char1)) ? $a : ($truthy($b = pass_inline_char2) ? text['$include?'](pass_inline_char2) : $b)))) {
          text = $send(text, 'gsub', [pass_inline_rx], ($$54 = function(){var self = $$54.$$s || this, $c, preceding = nil, attrlist = nil, quoted_text = nil, escape_mark = nil, format_mark = nil, content = nil, old_behavior = nil, attributes = nil, $writer = nil, passthru_key = nil, subs = nil;

          
            preceding = (($c = $gvars['~']) === nil ? nil : $c['$[]'](1));
            attrlist = (($c = $gvars['~']) === nil ? nil : $c['$[]'](2));
            if ($truthy((quoted_text = (($c = $gvars['~']) === nil ? nil : $c['$[]'](3)))['$start_with?']($$($nesting, 'RS')))) {
              escape_mark = $$($nesting, 'RS')};
            format_mark = (($c = $gvars['~']) === nil ? nil : $c['$[]'](4));
            content = (($c = $gvars['~']) === nil ? nil : $c['$[]'](5));
            if ($truthy(compat_mode)) {
              old_behavior = true
            } else if ($truthy((old_behavior = ($truthy($c = attrlist) ? attrlist['$end_with?']("x-") : $c)))) {
              attrlist = attrlist.$slice(0, $rb_minus(attrlist.$length(), 2))};
            if ($truthy(attrlist)) {
              if ($truthy((($c = format_mark['$==']("`")) ? old_behavior['$!']() : format_mark['$==']("`")))) {
                return self.$extract_inner_passthrough(content, "" + (preceding) + "[" + (attrlist) + "]" + (escape_mark));
              } else if ($truthy(escape_mark)) {
                return "" + (preceding) + "[" + (attrlist) + "]" + (quoted_text.$slice(1, quoted_text.$length()));
              } else if (preceding['$==']($$($nesting, 'RS'))) {
                preceding = "" + "[" + (attrlist) + "]"
              } else {
                attributes = self.$parse_quoted_text_attributes(attrlist)
              }
            } else if ($truthy((($c = format_mark['$==']("`")) ? old_behavior['$!']() : format_mark['$==']("`")))) {
              return self.$extract_inner_passthrough(content, "" + (preceding) + (escape_mark));
            } else if ($truthy(escape_mark)) {
              return "" + (preceding) + (quoted_text.$slice(1, quoted_text.$length()));};
            if ($truthy(compat_mode)) {
              
              $writer = [(passthru_key = passthrus.$size()), $hash2(["text", "subs", "attributes", "type"], {"text": content, "subs": $$($nesting, 'BASIC_SUBS'), "attributes": attributes, "type": "monospaced"})];
              $send(passthrus, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            } else if ($truthy(attributes)) {
              if ($truthy(old_behavior)) {
                
                subs = (function() {if (format_mark['$==']("`")) {
                  return $$($nesting, 'BASIC_SUBS')
                } else {
                  return $$($nesting, 'NORMAL_SUBS')
                }; return nil; })();
                
                $writer = [(passthru_key = passthrus.$size()), $hash2(["text", "subs", "attributes", "type"], {"text": content, "subs": subs, "attributes": attributes, "type": "monospaced"})];
                $send(passthrus, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
              } else {
                
                $writer = [(passthru_key = passthrus.$size()), $hash2(["text", "subs", "attributes", "type"], {"text": content, "subs": $$($nesting, 'BASIC_SUBS'), "attributes": attributes, "type": "unquoted"})];
                $send(passthrus, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];
              }
            } else {
              
              $writer = [(passthru_key = passthrus.$size()), $hash2(["text", "subs"], {"text": content, "subs": $$($nesting, 'BASIC_SUBS')})];
              $send(passthrus, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            };
            return "" + (preceding) + ($$($nesting, 'PASS_START')) + (passthru_key) + ($$($nesting, 'PASS_END'));}, $$54.$$s = self, $$54.$$arity = 0, $$54))};
        if ($truthy(($truthy($a = text['$include?'](":")) ? ($truthy($b = text['$include?']("stem:")) ? $b : text['$include?']("math:")) : $a))) {
          text = $send(text, 'gsub', [$$($nesting, 'InlineStemMacroRx')], ($$55 = function(){var self = $$55.$$s || this, $c, $d, type = nil, subs = nil, content = nil, $writer = nil, passthru_key = nil;
            if (self.document == null) self.document = nil;

          
            if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](0))['$start_with?']($$($nesting, 'RS')))) {
              return (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$slice(1, (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$length());};
            if ((type = (($c = $gvars['~']) === nil ? nil : $c['$[]'](1)).$to_sym())['$==']("stem")) {
              type = $$($nesting, 'STEM_TYPE_ALIASES')['$[]'](self.document.$attributes()['$[]']("stem")).$to_sym()};
            subs = (($c = $gvars['~']) === nil ? nil : $c['$[]'](2));
            content = self.$normalize_text((($c = $gvars['~']) === nil ? nil : $c['$[]'](3)), nil, true);
            if ($truthy(($truthy($c = (($d = type['$==']("latexmath")) ? content['$start_with?']("$") : type['$==']("latexmath"))) ? content['$end_with?']("$") : $c))) {
              content = content.$slice(1, $rb_minus(content.$length(), 2))};
            subs = (function() {if ($truthy(subs)) {
              
              return self.$resolve_pass_subs(subs);
            } else {
              
              if ($truthy(self.document['$basebackend?']("html"))) {
                return $$($nesting, 'BASIC_SUBS')
              } else {
                return nil
              };
            }; return nil; })();
            
            $writer = [(passthru_key = passthrus.$size()), $hash2(["text", "subs", "type"], {"text": content, "subs": subs, "type": type})];
            $send(passthrus, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            return "" + ($$($nesting, 'PASS_START')) + (passthru_key) + ($$($nesting, 'PASS_END'));}, $$55.$$s = self, $$55.$$arity = 0, $$55))};
        return text;
      }, $Substitutors_extract_passthroughs$52.$$arity = 1);
      
      Opal.def(self, '$restore_passthroughs', $Substitutors_restore_passthroughs$56 = function $$restore_passthroughs(text) {
        var $$57, self = this, passthrus = nil;
        if (self.passthroughs == null) self.passthroughs = nil;

        
        passthrus = self.passthroughs;
        return $send(text, 'gsub', [$$($nesting, 'PassSlotRx')], ($$57 = function(){var self = $$57.$$s || this, $a, pass = nil, subbed_text = nil, type = nil, attributes = nil, id = nil;

        if ($truthy((pass = passthrus['$[]']((($a = $gvars['~']) === nil ? nil : $a['$[]'](1)).$to_i())))) {
            
            subbed_text = self.$apply_subs(pass['$[]']("text"), pass['$[]']("subs"));
            if ($truthy((type = pass['$[]']("type")))) {
              
              if ($truthy((attributes = pass['$[]']("attributes")))) {
                id = attributes['$[]']("id")};
              subbed_text = $$($nesting, 'Inline').$new(self, "quoted", subbed_text, $hash2(["type", "id", "attributes"], {"type": type, "id": id, "attributes": attributes})).$convert();};
            if ($truthy(subbed_text['$include?']($$($nesting, 'PASS_START')))) {
              return self.$restore_passthroughs(subbed_text)
            } else {
              return subbed_text
            };
          } else {
            
            self.$logger().$error("" + "unresolved passthrough detected: " + (text));
            return "??pass??";
          }}, $$57.$$s = self, $$57.$$arity = 0, $$57));
      }, $Substitutors_restore_passthroughs$56.$$arity = 1);
      
      Opal.def(self, '$resolve_subs', $Substitutors_resolve_subs$58 = function $$resolve_subs(subs, type, defaults, subject) {
        var $$59, self = this, candidates = nil, modifiers_present = nil, resolved = nil, invalid = nil;

        
        
        if (type == null) {
          type = "block";
        };
        
        if (defaults == null) {
          defaults = nil;
        };
        
        if (subject == null) {
          subject = nil;
        };
        if ($truthy(subs['$nil_or_empty?']())) {
          return nil};
        candidates = nil;
        if ($truthy(subs['$include?'](" "))) {
          subs = subs.$delete(" ")};
        modifiers_present = $$($nesting, 'SubModifierSniffRx')['$match?'](subs);
        $send(subs.$split(","), 'each', [], ($$59 = function(key){var self = $$59.$$s || this, $a, $b, modifier_operation = nil, first = nil, resolved_keys = nil, resolved_key = nil, candidate = nil, $case = nil;

        
          
          if (key == null) {
            key = nil;
          };
          modifier_operation = nil;
          if ($truthy(modifiers_present)) {
            if ((first = key.$chr())['$==']("+")) {
              
              modifier_operation = "append";
              key = key.$slice(1, key.$length());
            } else if (first['$==']("-")) {
              
              modifier_operation = "remove";
              key = key.$slice(1, key.$length());
            } else if ($truthy(key['$end_with?']("+"))) {
              
              modifier_operation = "prepend";
              key = key.$chop();}};
          key = key.$to_sym();
          if ($truthy((($a = type['$==']("inline")) ? ($truthy($b = key['$==']("verbatim")) ? $b : key['$==']("v")) : type['$==']("inline")))) {
            resolved_keys = $$($nesting, 'BASIC_SUBS')
          } else if ($truthy($$($nesting, 'SUB_GROUPS')['$key?'](key))) {
            resolved_keys = $$($nesting, 'SUB_GROUPS')['$[]'](key)
          } else if ($truthy(($truthy($a = (($b = type['$==']("inline")) ? key.$length()['$=='](1) : type['$==']("inline"))) ? $$($nesting, 'SUB_HINTS')['$key?'](key) : $a))) {
            
            resolved_key = $$($nesting, 'SUB_HINTS')['$[]'](key);
            if ($truthy((candidate = $$($nesting, 'SUB_GROUPS')['$[]'](resolved_key)))) {
              resolved_keys = candidate
            } else {
              resolved_keys = [resolved_key]
            };
          } else {
            resolved_keys = [key]
          };
          if ($truthy(modifier_operation)) {
            
            candidates = ($truthy($a = candidates) ? $a : (function() {if ($truthy(defaults)) {
              
              return defaults.$drop(0);
            } else {
              return []
            }; return nil; })());
            return (function() {$case = modifier_operation;
            if ("append"['$===']($case)) {return (candidates = $rb_plus(candidates, resolved_keys))}
            else if ("prepend"['$===']($case)) {return (candidates = $rb_plus(resolved_keys, candidates))}
            else if ("remove"['$===']($case)) {return (candidates = $rb_minus(candidates, resolved_keys))}
            else { return nil }})();
          } else {
            
            candidates = ($truthy($a = candidates) ? $a : []);
            return (candidates = $rb_plus(candidates, resolved_keys));
          };}, $$59.$$s = self, $$59.$$arity = 1, $$59));
        if ($truthy(candidates)) {
        } else {
          return nil
        };
        resolved = candidates['$&']($$($nesting, 'SUB_OPTIONS')['$[]'](type));
        if ($truthy($rb_minus(candidates, resolved)['$empty?']())) {
        } else {
          
          invalid = $rb_minus(candidates, resolved);
          self.$logger().$warn("" + "invalid substitution type" + ((function() {if ($truthy($rb_gt(invalid.$size(), 1))) {
            return "s"
          } else {
            return ""
          }; return nil; })()) + ((function() {if ($truthy(subject)) {
            return " for "
          } else {
            return ""
          }; return nil; })()) + (subject) + ": " + (invalid.$join(", ")));
        };
        return resolved;
      }, $Substitutors_resolve_subs$58.$$arity = -2);
      
      Opal.def(self, '$resolve_block_subs', $Substitutors_resolve_block_subs$60 = function $$resolve_block_subs(subs, defaults, subject) {
        var self = this;

        return self.$resolve_subs(subs, "block", defaults, subject)
      }, $Substitutors_resolve_block_subs$60.$$arity = 3);
      
      Opal.def(self, '$resolve_pass_subs', $Substitutors_resolve_pass_subs$61 = function $$resolve_pass_subs(subs) {
        var self = this;

        return self.$resolve_subs(subs, "inline", nil, "passthrough macro")
      }, $Substitutors_resolve_pass_subs$61.$$arity = 1);
      
      Opal.def(self, '$expand_subs', $Substitutors_expand_subs$62 = function $$expand_subs(subs, subject) {
        var $a, $$63, self = this, $case = nil, expanded_subs = nil;

        
        
        if (subject == null) {
          subject = nil;
        };
        return (function() {$case = subs;
        if ($$$('::', 'Symbol')['$===']($case)) {if (subs['$==']("none")) {
          return nil
        } else {
          return ($truthy($a = $$($nesting, 'SUB_GROUPS')['$[]'](subs)) ? $a : [subs])
        }}
        else if ($$$('::', 'Array')['$===']($case)) {
        expanded_subs = [];
        $send(subs, 'each', [], ($$63 = function(key){var self = $$63.$$s || this, sub_group = nil;

        
          
          if (key == null) {
            key = nil;
          };
          if (key['$==']("none")) {
            return nil
          } else if ($truthy((sub_group = $$($nesting, 'SUB_GROUPS')['$[]'](key)))) {
            return (expanded_subs = $rb_plus(expanded_subs, sub_group))
          } else {
            return expanded_subs['$<<'](key)
          };}, $$63.$$s = self, $$63.$$arity = 1, $$63));
        if ($truthy(expanded_subs['$empty?']())) {
          return nil
        } else {
          return expanded_subs
        };}
        else {return self.$resolve_subs(subs, "inline", nil, subject)}})();
      }, $Substitutors_expand_subs$62.$$arity = -2);
      
      Opal.def(self, '$commit_subs', $Substitutors_commit_subs$64 = function $$commit_subs() {
        var $a, $b, $c, $d, self = this, default_subs = nil, $case = nil, custom_subs = nil, syntax_hl = nil, idx = nil, $writer = nil;
        if (self.default_subs == null) self.default_subs = nil;
        if (self.content_model == null) self.content_model = nil;
        if (self.context == null) self.context = nil;
        if (self.subs == null) self.subs = nil;
        if (self.attributes == null) self.attributes = nil;
        if (self.style == null) self.style = nil;
        if (self.document == null) self.document = nil;

        
        if ($truthy((default_subs = self.default_subs))) {
        } else {
          $case = self.content_model;
          if ("simple"['$===']($case)) {default_subs = $$($nesting, 'NORMAL_SUBS')}
          else if ("verbatim"['$===']($case)) {default_subs = (function() {if (self.context['$==']("verse")) {
            return $$($nesting, 'NORMAL_SUBS')
          } else {
            return $$($nesting, 'VERBATIM_SUBS')
          }; return nil; })()}
          else if ("raw"['$===']($case)) {default_subs = (function() {if (self.context['$==']("stem")) {
            return $$($nesting, 'BASIC_SUBS')
          } else {
            return $$($nesting, 'NO_SUBS')
          }; return nil; })()}
          else {return self.subs}
        };
        if ($truthy((custom_subs = self.attributes['$[]']("subs")))) {
          self.subs = ($truthy($a = self.$resolve_block_subs(custom_subs, default_subs, self.context)) ? $a : [])
        } else {
          self.subs = default_subs.$drop(0)
        };
        if ($truthy(($truthy($a = ($truthy($b = ($truthy($c = (($d = self.context['$==']("listing")) ? self.style['$==']("source") : self.context['$==']("listing"))) ? (syntax_hl = self.document.$syntax_highlighter()) : $c)) ? syntax_hl['$highlight?']() : $b)) ? (idx = self.subs.$index("specialcharacters")) : $a))) {
          
          $writer = [idx, "highlight"];
          $send(self.subs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        return nil;
      }, $Substitutors_commit_subs$64.$$arity = 0);
      
      Opal.def(self, '$parse_attributes', $Substitutors_parse_attributes$65 = function $$parse_attributes(attrlist, posattrs, opts) {
        var $a, self = this, block = nil, into = nil;
        if (self.document == null) self.document = nil;

        
        
        if (posattrs == null) {
          posattrs = [];
        };
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        if ($truthy((function() {if ($truthy(attrlist)) {
          return attrlist['$empty?']()
        } else {
          return true
        }; return nil; })())) {
          return $hash2([], {})};
        if ($truthy(opts['$[]']("unescape_input"))) {
          attrlist = self.$normalize_text(attrlist, true, true)};
        if ($truthy(($truthy($a = opts['$[]']("sub_input")) ? attrlist['$include?']($$($nesting, 'ATTR_REF_HEAD')) : $a))) {
          attrlist = self.document.$sub_attributes(attrlist)};
        if ($truthy(opts['$[]']("sub_result"))) {
          block = self};
        if ($truthy((into = opts['$[]']("into")))) {
          return $$($nesting, 'AttributeList').$new(attrlist, block).$parse_into(into, posattrs)
        } else {
          return $$($nesting, 'AttributeList').$new(attrlist, block).$parse(posattrs)
        };
      }, $Substitutors_parse_attributes$65.$$arity = -2);
      self.$private();
      
      Opal.def(self, '$extract_attributes_from_text', $Substitutors_extract_attributes_from_text$66 = function $$extract_attributes_from_text(text, default_text) {
        var self = this, attrlist = nil, resolved_text = nil, attrs = nil;

        
        
        if (default_text == null) {
          default_text = nil;
        };
        attrlist = (function() {if ($truthy(text['$include?']($$($nesting, 'LF')))) {
          
          return text.$tr($$($nesting, 'LF'), " ");
        } else {
          return text
        }; return nil; })();
        if ($truthy((resolved_text = (attrs = $$($nesting, 'AttributeList').$new(attrlist, self).$parse())['$[]'](1)))) {
          if (resolved_text['$=='](attrlist)) {
            return [text, attrs.$clear()]
          } else {
            return [resolved_text, attrs]
          }
        } else {
          return [default_text, attrs]
        };
      }, $Substitutors_extract_attributes_from_text$66.$$arity = -2);
      
      Opal.def(self, '$extract_callouts', $Substitutors_extract_callouts$67 = function $$extract_callouts(source) {
        var $$68, self = this, callout_marks = nil, autonum = nil, lineno = nil, last_lineno = nil, callout_rx = nil;

        
        callout_marks = $hash2([], {});
        autonum = (lineno = 0);
        last_lineno = nil;
        callout_rx = (function() {if ($truthy(self['$attr?']("line-comment"))) {
          return $$($nesting, 'CalloutExtractRxMap')['$[]'](self.$attr("line-comment"))
        } else {
          return $$($nesting, 'CalloutExtractRx')
        }; return nil; })();
        source = $send(source.$split($$($nesting, 'LF'), -1), 'map', [], ($$68 = function(line){var self = $$68.$$s || this, $$69;

        
          
          if (line == null) {
            line = nil;
          };
          lineno = $rb_plus(lineno, 1);
          return $send(line, 'gsub', [callout_rx], ($$69 = function(){var self = $$69.$$s || this, $a, $b, $writer = nil;

          if ($truthy((($a = $gvars['~']) === nil ? nil : $a['$[]'](2)))) {
              return (($a = $gvars['~']) === nil ? nil : $a['$[]'](0)).$sub($$($nesting, 'RS'), "")
            } else {
              
              ($truthy($a = callout_marks['$[]'](lineno)) ? $a : (($writer = [lineno, []]), $send(callout_marks, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))['$<<']([($truthy($a = (($b = $gvars['~']) === nil ? nil : $b['$[]'](1))) ? $a : (function() {if ((($b = $gvars['~']) === nil ? nil : $b['$[]'](3))['$==']("--")) {
                return ["<!--", "-->"]
              } else {
                return nil
              }; return nil; })()), (function() {if ((($a = $gvars['~']) === nil ? nil : $a['$[]'](4))['$=='](".")) {
                return (autonum = $rb_plus(autonum, 1)).$to_s()
              } else {
                return (($a = $gvars['~']) === nil ? nil : $a['$[]'](4))
              }; return nil; })()]);
              last_lineno = lineno;
              return "";
            }}, $$69.$$s = self, $$69.$$arity = 0, $$69));}, $$68.$$s = self, $$68.$$arity = 1, $$68)).$join($$($nesting, 'LF'));
        if ($truthy(last_lineno)) {
          if (last_lineno['$=='](lineno)) {
            source = "" + (source) + ($$($nesting, 'LF'))}
        } else {
          callout_marks = nil
        };
        return [source, callout_marks];
      }, $Substitutors_extract_callouts$67.$$arity = 1);
      
      Opal.def(self, '$restore_callouts', $Substitutors_restore_callouts$70 = function $$restore_callouts(source, callout_marks, source_offset) {
        var $$71, self = this, preamble = nil, lineno = nil;

        
        
        if (source_offset == null) {
          source_offset = nil;
        };
        if ($truthy(source_offset)) {
          
          preamble = source.$slice(0, source_offset);
          source = source.$slice(source_offset, source.$length());
        } else {
          preamble = ""
        };
        lineno = 0;
        return $rb_plus(preamble, $send(source.$split($$($nesting, 'LF'), -1), 'map', [], ($$71 = function(line){var self = $$71.$$s || this, $a, $b, $$72, conums = nil, guard = nil, numeral = nil;
          if (self.document == null) self.document = nil;

        
          
          if (line == null) {
            line = nil;
          };
          if ($truthy((conums = callout_marks.$delete((lineno = $rb_plus(lineno, 1)))))) {
            if (conums.$size()['$=='](1)) {
              
              $b = conums['$[]'](0), $a = Opal.to_ary($b), (guard = ($a[0] == null ? nil : $a[0])), (numeral = ($a[1] == null ? nil : $a[1])), $b;
              return "" + (line) + ($$($nesting, 'Inline').$new(self, "callout", numeral, $hash2(["id", "attributes"], {"id": self.document.$callouts().$read_next_id(), "attributes": $hash2(["guard"], {"guard": guard})})).$convert());
            } else {
              return "" + (line) + ($send(conums, 'map', [], ($$72 = function(guard_it, numeral_it){var self = $$72.$$s || this;
                if (self.document == null) self.document = nil;

              
                
                if (guard_it == null) {
                  guard_it = nil;
                };
                
                if (numeral_it == null) {
                  numeral_it = nil;
                };
                return $$($nesting, 'Inline').$new(self, "callout", numeral_it, $hash2(["id", "attributes"], {"id": self.document.$callouts().$read_next_id(), "attributes": $hash2(["guard"], {"guard": guard_it})})).$convert();}, $$72.$$s = self, $$72.$$arity = 2, $$72)).$join(" "))
            }
          } else {
            return line
          };}, $$71.$$s = self, $$71.$$arity = 1, $$71)).$join($$($nesting, 'LF')));
      }, $Substitutors_restore_callouts$70.$$arity = -3);
      
      Opal.def(self, '$extract_inner_passthrough', $Substitutors_extract_inner_passthrough$73 = function $$extract_inner_passthrough(text, pre) {
        var $a, $b, self = this, $writer = nil, passthru_key = nil;
        if (self.passthroughs == null) self.passthroughs = nil;

        if ($truthy(($truthy($a = ($truthy($b = text['$end_with?']("+")) ? text['$start_with?']("+", "\\+") : $b)) ? $$($nesting, 'SinglePlusInlinePassRx')['$=~'](text) : $a))) {
          if ($truthy((($a = $gvars['~']) === nil ? nil : $a['$[]'](1)))) {
            return "" + (pre) + "`+" + ((($a = $gvars['~']) === nil ? nil : $a['$[]'](2))) + "+`"
          } else {
            
            
            $writer = [(passthru_key = self.passthroughs.$size()), $hash2(["text", "subs"], {"text": (($a = $gvars['~']) === nil ? nil : $a['$[]'](2)), "subs": $$($nesting, 'BASIC_SUBS')})];
            $send(self.passthroughs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            return "" + (pre) + "`" + ($$($nesting, 'PASS_START')) + (passthru_key) + ($$($nesting, 'PASS_END')) + "`";
          }
        } else {
          return "" + (pre) + "`" + (text) + "`"
        }
      }, $Substitutors_extract_inner_passthrough$73.$$arity = 2);
      
      Opal.def(self, '$convert_quoted_text', $Substitutors_convert_quoted_text$74 = function $$convert_quoted_text(match, type, scope) {
        var $a, self = this, attrs = nil, unescaped_attrs = nil, attrlist = nil, id = nil, attributes = nil;

        
        if ($truthy(match['$[]'](0)['$start_with?']($$($nesting, 'RS')))) {
          if ($truthy((($a = scope['$==']("constrained")) ? (attrs = match['$[]'](2)) : scope['$==']("constrained")))) {
            unescaped_attrs = "" + "[" + (attrs) + "]"
          } else {
            return match['$[]'](0).$slice(1, match['$[]'](0).$length())
          }};
        if (scope['$==']("constrained")) {
          if ($truthy(unescaped_attrs)) {
            return "" + (unescaped_attrs) + ($$($nesting, 'Inline').$new(self, "quoted", match['$[]'](3), $hash2(["type"], {"type": type})).$convert())
          } else {
            
            if ($truthy((attrlist = match['$[]'](2)))) {
              
              id = (attributes = self.$parse_quoted_text_attributes(attrlist))['$[]']("id");
              if (type['$==']("mark")) {
                type = "unquoted"};};
            return "" + (match['$[]'](1)) + ($$($nesting, 'Inline').$new(self, "quoted", match['$[]'](3), $hash2(["type", "id", "attributes"], {"type": type, "id": id, "attributes": attributes})).$convert());
          }
        } else {
          
          if ($truthy((attrlist = match['$[]'](1)))) {
            
            id = (attributes = self.$parse_quoted_text_attributes(attrlist))['$[]']("id");
            if (type['$==']("mark")) {
              type = "unquoted"};};
          return $$($nesting, 'Inline').$new(self, "quoted", match['$[]'](2), $hash2(["type", "id", "attributes"], {"type": type, "id": id, "attributes": attributes})).$convert();
        };
      }, $Substitutors_convert_quoted_text$74.$$arity = 3);
      
      Opal.def(self, '$do_replacement', $Substitutors_do_replacement$75 = function $$do_replacement(m, replacement, restore) {
        var self = this, captured = nil, $case = nil;

        if ($truthy((captured = m['$[]'](0))['$include?']($$($nesting, 'RS')))) {
          return captured.$sub($$($nesting, 'RS'), "")
        } else {
          return (function() {$case = restore;
          if ("none"['$===']($case)) {return replacement}
          else if ("bounding"['$===']($case)) {return $rb_plus($rb_plus(m['$[]'](1), replacement), m['$[]'](2))}
          else {return $rb_plus(m['$[]'](1), replacement)}})()
        }
      }, $Substitutors_do_replacement$75.$$arity = 3);
      if ($$($nesting, 'RUBY_ENGINE')['$==']("opal")) {
      } else {
        nil
      };
      
      Opal.def(self, '$parse_quoted_text_attributes', $Substitutors_parse_quoted_text_attributes$76 = function $$parse_quoted_text_attributes(str) {
        var $a, $b, self = this, before = nil, _ = nil, after = nil, attrs = nil, $writer = nil, id = nil, roles = nil;

        
        if ($truthy(str['$include?']($$($nesting, 'ATTR_REF_HEAD')))) {
          str = self.$sub_attributes(str)};
        if ($truthy(str['$include?'](","))) {
          str = str.$slice(0, str.$index(","))};
        if ($truthy((str = str.$strip())['$empty?']())) {
          return $hash2([], {})
        } else if ($truthy(($truthy($a = str['$start_with?'](".", "#")) ? $$($nesting, 'Compliance').$shorthand_property_syntax() : $a))) {
          
          $b = str.$partition("#"), $a = Opal.to_ary($b), (before = ($a[0] == null ? nil : $a[0])), (_ = ($a[1] == null ? nil : $a[1])), (after = ($a[2] == null ? nil : $a[2])), $b;
          attrs = $hash2([], {});
          if ($truthy(after['$empty?']())) {
            if ($truthy($rb_gt(before.$length(), 1))) {
              
              $writer = ["role", before.$tr(".", " ").$lstrip()];
              $send(attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];}
          } else {
            
            $b = after.$partition("."), $a = Opal.to_ary($b), (id = ($a[0] == null ? nil : $a[0])), (_ = ($a[1] == null ? nil : $a[1])), (roles = ($a[2] == null ? nil : $a[2])), $b;
            if ($truthy(id['$empty?']())) {
            } else {
              
              $writer = ["id", id];
              $send(attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            };
            if ($truthy(roles['$empty?']())) {
              if ($truthy($rb_gt(before.$length(), 1))) {
                
                $writer = ["role", before.$tr(".", " ").$lstrip()];
                $send(attrs, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];}
            } else if ($truthy($rb_gt(before.$length(), 1))) {
              
              $writer = ["role", $rb_plus($rb_plus(before, "."), roles).$tr(".", " ").$lstrip()];
              $send(attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            } else {
              
              $writer = ["role", roles.$tr(".", " ")];
              $send(attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            };
          };
          return attrs;
        } else {
          return $hash2(["role"], {"role": str})
        };
      }, $Substitutors_parse_quoted_text_attributes$76.$$arity = 1);
      
      Opal.def(self, '$normalize_text', $Substitutors_normalize_text$77 = function $$normalize_text(text, normalize_whitespace, unescape_closing_square_brackets) {
        var $a, self = this;

        
        
        if (normalize_whitespace == null) {
          normalize_whitespace = nil;
        };
        
        if (unescape_closing_square_brackets == null) {
          unescape_closing_square_brackets = nil;
        };
        if ($truthy(text['$empty?']())) {
        } else {
          
          if ($truthy(normalize_whitespace)) {
            text = text.$strip().$tr($$($nesting, 'LF'), " ")};
          if ($truthy(($truthy($a = unescape_closing_square_brackets) ? text['$include?']($$($nesting, 'R_SB')) : $a))) {
            text = text.$gsub($$($nesting, 'ESC_R_SB'), $$($nesting, 'R_SB'))};
        };
        return text;
      }, $Substitutors_normalize_text$77.$$arity = -2);
      
      Opal.def(self, '$split_simple_csv', $Substitutors_split_simple_csv$78 = function $$split_simple_csv(str) {
        var $$79, $$80, self = this, values = nil, accum = nil, quote_open = nil;

        if ($truthy(str['$empty?']())) {
          return []
        } else if ($truthy(str['$include?']("\""))) {
          
          values = [];
          accum = "";
          quote_open = nil;
          $send(str, 'each_char', [], ($$79 = function(c){var self = $$79.$$s || this, $case = nil;

          
            
            if (c == null) {
              c = nil;
            };
            return (function() {$case = c;
            if (","['$===']($case)) {if ($truthy(quote_open)) {
              return (accum = $rb_plus(accum, c))
            } else {
              
              values['$<<'](accum.$strip());
              return (accum = "");
            }}
            else if ("\""['$===']($case)) {return (quote_open = quote_open['$!']())}
            else {return (accum = $rb_plus(accum, c))}})();}, $$79.$$s = self, $$79.$$arity = 1, $$79));
          return values['$<<'](accum.$strip());
        } else {
          return $send(str.$split(","), 'map', [], ($$80 = function(it){var self = $$80.$$s || this;

          
            
            if (it == null) {
              it = nil;
            };
            return it.$strip();}, $$80.$$s = self, $$80.$$arity = 1, $$80))
        }
      }, $Substitutors_split_simple_csv$78.$$arity = 1);
    })($nesting[0], $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/version"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module;

  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    Opal.const_set($nesting[0], 'VERSION', "2.0.17")
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/abstract_node"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $hash2 = Opal.hash2, $truthy = Opal.truthy, $send = Opal.send;

  Opal.add_stubs(['$include', '$attr_reader', '$attr_accessor', '$==', '$document', '$to_s', '$[]', '$merge', '$raise', '$converter', '$attributes', '$key?', '$[]=', '$-', '$delete', '$tap', '$new', '$each_key', '$end_with?', '$<<', '$slice', '$length', '$update', '$split', '$include?', '$===', '$join', '$empty?', '$apply_reftext_subs', '$attr?', '$attr', '$extname?', '$image_uri', '$<', '$safe', '$uriish?', '$encode_spaces_in_uri', '$normalize_web_path', '$generate_data_uri_from_uri', '$generate_data_uri', '$extname', '$normalize_system_path', '$readable?', '$strict_encode64', '$binread', '$warn', '$logger', '$require_library', '$!', '$open_uri', '$content_type', '$read', '$base_dir', '$root?', '$path_resolver', '$system_path', '$web_path', '$!=', '$prepare_source_string', '$fetch', '$read_asset']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'AbstractNode');

      var $nesting = [self].concat($parent_nesting), $AbstractNode_initialize$1, $AbstractNode_block$ques$2, $AbstractNode_inline$ques$3, $AbstractNode_converter$4, $AbstractNode_parent$eq$5, $AbstractNode_attr$6, $AbstractNode_attr$ques$7, $AbstractNode_set_attr$8, $AbstractNode_remove_attr$9, $AbstractNode_option$ques$10, $AbstractNode_set_option$11, $AbstractNode_enabled_options$12, $AbstractNode_update_attributes$15, $AbstractNode_role$16, $AbstractNode_roles$17, $AbstractNode_role$ques$18, $AbstractNode_has_role$ques$19, $AbstractNode_role$eq$20, $AbstractNode_add_role$21, $AbstractNode_remove_role$22, $AbstractNode_reftext$23, $AbstractNode_reftext$ques$24, $AbstractNode_icon_uri$25, $AbstractNode_image_uri$26, $AbstractNode_media_uri$27, $AbstractNode_generate_data_uri$28, $AbstractNode_generate_data_uri_from_uri$29, $AbstractNode_normalize_asset_path$31, $AbstractNode_normalize_system_path$32, $AbstractNode_normalize_web_path$33, $AbstractNode_read_asset$34, $AbstractNode_read_contents$35, $AbstractNode_is_uri$ques$38;

      self.$$prototype.document = self.$$prototype.attributes = self.$$prototype.parent = nil;
      
      self.$include($$($nesting, 'Logging'));
      self.$include($$($nesting, 'Substitutors'));
      self.$attr_reader("attributes");
      self.$attr_reader("context");
      self.$attr_reader("document");
      self.$attr_accessor("id");
      self.$attr_reader("node_name");
      self.$attr_reader("parent");
      
      Opal.def(self, '$initialize', $AbstractNode_initialize$1 = function $$initialize(parent, context, opts) {
        var self = this, attrs = nil;

        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        if (context['$==']("document")) {
          self.document = self
        } else if ($truthy(parent)) {
          self.document = (self.parent = parent).$document()};
        self.node_name = (self.context = context).$to_s();
        self.attributes = (function() {if ($truthy((attrs = opts['$[]']("attributes")))) {
          return attrs.$merge()
        } else {
          return $hash2([], {})
        }; return nil; })();
        return (self.passthroughs = []);
      }, $AbstractNode_initialize$1.$$arity = -3);
      
      Opal.def(self, '$block?', $AbstractNode_block$ques$2 = function() {
        var self = this;

        return self.$raise($$$('::', 'NotImplementedError'))
      }, $AbstractNode_block$ques$2.$$arity = 0);
      
      Opal.def(self, '$inline?', $AbstractNode_inline$ques$3 = function() {
        var self = this;

        return self.$raise($$$('::', 'NotImplementedError'))
      }, $AbstractNode_inline$ques$3.$$arity = 0);
      
      Opal.def(self, '$converter', $AbstractNode_converter$4 = function $$converter() {
        var self = this;

        return self.document.$converter()
      }, $AbstractNode_converter$4.$$arity = 0);
      
      Opal.def(self, '$parent=', $AbstractNode_parent$eq$5 = function(parent) {
        var $a, self = this;

        return $a = [parent, parent.$document()], (self.parent = $a[0]), (self.document = $a[1]), $a
      }, $AbstractNode_parent$eq$5.$$arity = 1);
      
      Opal.def(self, '$attr', $AbstractNode_attr$6 = function $$attr(name, default_value, fallback_name) {
        var $a, $b, $c, $d, self = this;

        
        
        if (default_value == null) {
          default_value = nil;
        };
        
        if (fallback_name == null) {
          fallback_name = nil;
        };
        return ($truthy($a = self.attributes['$[]'](name.$to_s())) ? $a : ($truthy($b = ($truthy($c = ($truthy($d = fallback_name) ? self.parent : $d)) ? self.document.$attributes()['$[]']((function() {if (fallback_name['$=='](true)) {
          return name
        } else {
          return fallback_name
        }; return nil; })().$to_s()) : $c)) ? $b : default_value));
      }, $AbstractNode_attr$6.$$arity = -2);
      
      Opal.def(self, '$attr?', $AbstractNode_attr$ques$7 = function(name, expected_value, fallback_name) {
        var $a, $b, self = this;

        
        
        if (expected_value == null) {
          expected_value = nil;
        };
        
        if (fallback_name == null) {
          fallback_name = nil;
        };
        if ($truthy(expected_value)) {
          return expected_value['$=='](($truthy($a = self.attributes['$[]'](name.$to_s())) ? $a : (function() {if ($truthy(($truthy($b = fallback_name) ? self.parent : $b))) {
            return self.document.$attributes()['$[]']((function() {if (fallback_name['$=='](true)) {
              return name
            } else {
              return fallback_name
            }; return nil; })().$to_s())
          } else {
            return nil
          }; return nil; })()))
        } else {
          return ($truthy($a = self.attributes['$key?'](name.$to_s())) ? $a : (function() {if ($truthy(($truthy($b = fallback_name) ? self.parent : $b))) {
            
            return self.document.$attributes()['$key?']((function() {if (fallback_name['$=='](true)) {
              return name
            } else {
              return fallback_name
            }; return nil; })().$to_s());
          } else {
            return false
          }; return nil; })())
        };
      }, $AbstractNode_attr$ques$7.$$arity = -2);
      
      Opal.def(self, '$set_attr', $AbstractNode_set_attr$8 = function $$set_attr(name, value, overwrite) {
        var $a, self = this, $writer = nil;

        
        
        if (value == null) {
          value = "";
        };
        
        if (overwrite == null) {
          overwrite = true;
        };
        if ($truthy((($a = overwrite['$=='](false)) ? self.attributes['$key?'](name) : overwrite['$=='](false)))) {
          return false
        } else {
          
          
          $writer = [name, value];
          $send(self.attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          return true;
        };
      }, $AbstractNode_set_attr$8.$$arity = -2);
      
      Opal.def(self, '$remove_attr', $AbstractNode_remove_attr$9 = function $$remove_attr(name) {
        var self = this;

        return self.attributes.$delete(name)
      }, $AbstractNode_remove_attr$9.$$arity = 1);
      
      Opal.def(self, '$option?', $AbstractNode_option$ques$10 = function(name) {
        var self = this;

        if ($truthy(self.attributes['$[]']("" + (name) + "-option"))) {
          return true
        } else {
          return false
        }
      }, $AbstractNode_option$ques$10.$$arity = 1);
      
      Opal.def(self, '$set_option', $AbstractNode_set_option$11 = function $$set_option(name) {
        var self = this, $writer = nil;

        
        
        $writer = ["" + (name) + "-option", ""];
        $send(self.attributes, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        return nil;
      }, $AbstractNode_set_option$11.$$arity = 1);
      
      Opal.def(self, '$enabled_options', $AbstractNode_enabled_options$12 = function $$enabled_options() {
        var $$13, self = this;

        return $send($$$('::', 'Set').$new(), 'tap', [], ($$13 = function(accum){var self = $$13.$$s || this, $$14;
          if (self.attributes == null) self.attributes = nil;

        
          
          if (accum == null) {
            accum = nil;
          };
          return $send(self.attributes, 'each_key', [], ($$14 = function(k){var self = $$14.$$s || this;

          
            
            if (k == null) {
              k = nil;
            };
            if ($truthy(k.$to_s()['$end_with?']("-option"))) {
              return accum['$<<'](k.$slice(0, $rb_minus(k.$length(), 7)))
            } else {
              return nil
            };}, $$14.$$s = self, $$14.$$arity = 1, $$14));}, $$13.$$s = self, $$13.$$arity = 1, $$13))
      }, $AbstractNode_enabled_options$12.$$arity = 0);
      
      Opal.def(self, '$update_attributes', $AbstractNode_update_attributes$15 = function $$update_attributes(new_attributes) {
        var self = this;

        return self.attributes.$update(new_attributes)
      }, $AbstractNode_update_attributes$15.$$arity = 1);
      
      Opal.def(self, '$role', $AbstractNode_role$16 = function $$role() {
        var self = this;

        return self.attributes['$[]']("role")
      }, $AbstractNode_role$16.$$arity = 0);
      
      Opal.def(self, '$roles', $AbstractNode_roles$17 = function $$roles() {
        var self = this, val = nil;

        if ($truthy((val = self.attributes['$[]']("role")))) {
          return val.$split()
        } else {
          return []
        }
      }, $AbstractNode_roles$17.$$arity = 0);
      
      Opal.def(self, '$role?', $AbstractNode_role$ques$18 = function(expected_value) {
        var self = this;

        
        
        if (expected_value == null) {
          expected_value = nil;
        };
        if ($truthy(expected_value)) {
          return expected_value['$=='](self.attributes['$[]']("role"))
        } else {
          
          return self.attributes['$key?']("role");
        };
      }, $AbstractNode_role$ques$18.$$arity = -1);
      
      Opal.def(self, '$has_role?', $AbstractNode_has_role$ques$19 = function(name) {
        var self = this, val = nil;

        if ($truthy((val = self.attributes['$[]']("role")))) {
          
          return ((("" + " ") + (val)) + " ")['$include?']("" + " " + (name) + " ");
        } else {
          return false
        }
      }, $AbstractNode_has_role$ques$19.$$arity = 1);
      
      Opal.def(self, '$role=', $AbstractNode_role$eq$20 = function(names) {
        var self = this, $writer = nil;

        
        $writer = ["role", (function() {if ($truthy($$$('::', 'Array')['$==='](names))) {
          
          return names.$join(" ");
        } else {
          return names
        }; return nil; })()];
        $send(self.attributes, '[]=', Opal.to_a($writer));
        return $writer[$rb_minus($writer["length"], 1)];
      }, $AbstractNode_role$eq$20.$$arity = 1);
      
      Opal.def(self, '$add_role', $AbstractNode_add_role$21 = function $$add_role(name) {
        var self = this, val = nil, $writer = nil;

        if ($truthy((val = self.attributes['$[]']("role")))) {
          if ($truthy(((("" + " ") + (val)) + " ")['$include?']("" + " " + (name) + " "))) {
            return false
          } else {
            
            
            $writer = ["role", "" + (val) + " " + (name)];
            $send(self.attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            return true;
          }
        } else {
          
          
          $writer = ["role", name];
          $send(self.attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          return true;
        }
      }, $AbstractNode_add_role$21.$$arity = 1);
      
      Opal.def(self, '$remove_role', $AbstractNode_remove_role$22 = function $$remove_role(name) {
        var $a, self = this, val = nil, $writer = nil;

        if ($truthy(($truthy($a = (val = self.attributes['$[]']("role"))) ? (val = val.$split()).$delete(name) : $a))) {
          
          if ($truthy(val['$empty?']())) {
            self.attributes.$delete("role")
          } else {
            
            $writer = ["role", val.$join(" ")];
            $send(self.attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          };
          return true;
        } else {
          return false
        }
      }, $AbstractNode_remove_role$22.$$arity = 1);
      
      Opal.def(self, '$reftext', $AbstractNode_reftext$23 = function $$reftext() {
        var self = this, val = nil;

        if ($truthy((val = self.attributes['$[]']("reftext")))) {
          
          return self.$apply_reftext_subs(val);
        } else {
          return nil
        }
      }, $AbstractNode_reftext$23.$$arity = 0);
      
      Opal.def(self, '$reftext?', $AbstractNode_reftext$ques$24 = function() {
        var self = this;

        return self.attributes['$key?']("reftext")
      }, $AbstractNode_reftext$ques$24.$$arity = 0);
      
      Opal.def(self, '$icon_uri', $AbstractNode_icon_uri$25 = function $$icon_uri(name) {
        var self = this, icon = nil;

        
        if ($truthy(self['$attr?']("icon"))) {
          
          icon = self.$attr("icon");
          if ($truthy($$($nesting, 'Helpers')['$extname?'](icon))) {
          } else {
            icon = "" + (icon) + "." + (self.document.$attr("icontype", "png"))
          };
        } else {
          icon = "" + (name) + "." + (self.document.$attr("icontype", "png"))
        };
        return self.$image_uri(icon, "iconsdir");
      }, $AbstractNode_icon_uri$25.$$arity = 1);
      
      Opal.def(self, '$image_uri', $AbstractNode_image_uri$26 = function $$image_uri(target_image, asset_dir_key) {
        var $a, $b, $c, $d, self = this, doc = nil, images_base = nil;

        
        
        if (asset_dir_key == null) {
          asset_dir_key = "imagesdir";
        };
        if ($truthy(($truthy($a = $rb_lt((doc = self.document).$safe(), $$$($$($nesting, 'SafeMode'), 'SECURE'))) ? doc['$attr?']("data-uri") : $a))) {
          if ($truthy(($truthy($a = ($truthy($b = $$($nesting, 'Helpers')['$uriish?'](target_image)) ? (target_image = $$($nesting, 'Helpers').$encode_spaces_in_uri(target_image)) : $b)) ? $a : ($truthy($b = ($truthy($c = ($truthy($d = asset_dir_key) ? (images_base = doc.$attr(asset_dir_key)) : $d)) ? $$($nesting, 'Helpers')['$uriish?'](images_base) : $c)) ? (target_image = self.$normalize_web_path(target_image, images_base, false)) : $b)))) {
            if ($truthy(doc['$attr?']("allow-uri-read"))) {
              
              return self.$generate_data_uri_from_uri(target_image, doc['$attr?']("cache-uri"));
            } else {
              return target_image
            }
          } else {
            return self.$generate_data_uri(target_image, asset_dir_key)
          }
        } else {
          return self.$normalize_web_path(target_image, (function() {if ($truthy(asset_dir_key)) {
            
            return doc.$attr(asset_dir_key);
          } else {
            return nil
          }; return nil; })())
        };
      }, $AbstractNode_image_uri$26.$$arity = -2);
      
      Opal.def(self, '$media_uri', $AbstractNode_media_uri$27 = function $$media_uri(target, asset_dir_key) {
        var self = this;

        
        
        if (asset_dir_key == null) {
          asset_dir_key = "imagesdir";
        };
        return self.$normalize_web_path(target, (function() {if ($truthy(asset_dir_key)) {
          return self.document.$attr(asset_dir_key)
        } else {
          return nil
        }; return nil; })());
      }, $AbstractNode_media_uri$27.$$arity = -2);
      
      Opal.def(self, '$generate_data_uri', $AbstractNode_generate_data_uri$28 = function $$generate_data_uri(target_image, asset_dir_key) {
        var self = this, ext = nil, mimetype = nil, image_path = nil;

        
        
        if (asset_dir_key == null) {
          asset_dir_key = nil;
        };
        if ($truthy((ext = $$($nesting, 'Helpers').$extname(target_image, nil)))) {
          mimetype = (function() {if (ext['$=='](".svg")) {
            return "image/svg+xml"
          } else {
            return "" + "image/" + (ext.$slice(1, ext.$length()))
          }; return nil; })()
        } else {
          mimetype = "application/octet-stream"
        };
        if ($truthy(asset_dir_key)) {
          image_path = self.$normalize_system_path(target_image, self.document.$attr(asset_dir_key), nil, $hash2(["target_name"], {"target_name": "image"}))
        } else {
          image_path = self.$normalize_system_path(target_image)
        };
        if ($truthy($$$('::', 'File')['$readable?'](image_path))) {
          return "" + "data:" + (mimetype) + ";base64," + ($$$('::', 'Base64').$strict_encode64($$$('::', 'File').$binread(image_path)))
        } else {
          
          self.$logger().$warn("" + "image to embed not found or not readable: " + (image_path));
          return "" + "data:" + (mimetype) + ";base64,";
        };
      }, $AbstractNode_generate_data_uri$28.$$arity = -2);
      
      Opal.def(self, '$generate_data_uri_from_uri', $AbstractNode_generate_data_uri_from_uri$29 = function $$generate_data_uri_from_uri(image_uri, cache_uri) {
        var $a, $b, $$30, self = this, mimetype = nil, bindata = nil;

        
        
        if (cache_uri == null) {
          cache_uri = false;
        };
        if ($truthy(cache_uri)) {
          $$($nesting, 'Helpers').$require_library("open-uri/cached", "open-uri-cached")
        } else if ($truthy($$($nesting, 'RUBY_ENGINE_OPAL')['$!']())) {
          $$$('::', 'OpenURI')};
        
        try {
          
          $b = $send($$$('::', 'OpenURI'), 'open_uri', [image_uri, $$($nesting, 'URI_READ_MODE')], ($$30 = function(f){var self = $$30.$$s || this;

          
            
            if (f == null) {
              f = nil;
            };
            return [f.$content_type(), f.$read()];}, $$30.$$s = self, $$30.$$arity = 1, $$30)), $a = Opal.to_ary($b), (mimetype = ($a[0] == null ? nil : $a[0])), (bindata = ($a[1] == null ? nil : $a[1])), $b;
          return "" + "data:" + (mimetype) + ";base64," + ($$$('::', 'Base64').$strict_encode64(bindata));
        } catch ($err) {
          if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
            try {
              
              self.$logger().$warn("" + "could not retrieve image data from URI: " + (image_uri));
              return image_uri;
            } finally { Opal.pop_exception() }
          } else { throw $err; }
        };;
      }, $AbstractNode_generate_data_uri_from_uri$29.$$arity = -2);
      
      Opal.def(self, '$normalize_asset_path', $AbstractNode_normalize_asset_path$31 = function $$normalize_asset_path(asset_ref, asset_name, autocorrect) {
        var self = this;

        
        
        if (asset_name == null) {
          asset_name = "path";
        };
        
        if (autocorrect == null) {
          autocorrect = true;
        };
        return self.$normalize_system_path(asset_ref, self.document.$base_dir(), nil, $hash2(["target_name", "recover"], {"target_name": asset_name, "recover": autocorrect}));
      }, $AbstractNode_normalize_asset_path$31.$$arity = -2);
      
      Opal.def(self, '$normalize_system_path', $AbstractNode_normalize_system_path$32 = function $$normalize_system_path(target, start, jail, opts) {
        var $a, self = this, doc = nil;

        
        
        if (start == null) {
          start = nil;
        };
        
        if (jail == null) {
          jail = nil;
        };
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        if ($truthy($rb_lt((doc = self.document).$safe(), $$$($$($nesting, 'SafeMode'), 'SAFE')))) {
          if ($truthy(start)) {
            if ($truthy(doc.$path_resolver()['$root?'](start))) {
            } else {
              start = $$$('::', 'File').$join(doc.$base_dir(), start)
            }
          } else {
            start = doc.$base_dir()
          }
        } else {
          
          start = ($truthy($a = start) ? $a : doc.$base_dir());
          jail = ($truthy($a = jail) ? $a : doc.$base_dir());
        };
        return doc.$path_resolver().$system_path(target, start, jail, opts);
      }, $AbstractNode_normalize_system_path$32.$$arity = -2);
      
      Opal.def(self, '$normalize_web_path', $AbstractNode_normalize_web_path$33 = function $$normalize_web_path(target, start, preserve_uri_target) {
        var $a, self = this;

        
        
        if (start == null) {
          start = nil;
        };
        
        if (preserve_uri_target == null) {
          preserve_uri_target = true;
        };
        if ($truthy(($truthy($a = preserve_uri_target) ? $$($nesting, 'Helpers')['$uriish?'](target) : $a))) {
          return $$($nesting, 'Helpers').$encode_spaces_in_uri(target)
        } else {
          return self.document.$path_resolver().$web_path(target, start)
        };
      }, $AbstractNode_normalize_web_path$33.$$arity = -2);
      
      Opal.def(self, '$read_asset', $AbstractNode_read_asset$34 = function $$read_asset(path, opts) {
        var $a, self = this;

        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        if ($truthy($$$('::', 'Hash')['$==='](opts))) {
        } else {
          opts = $hash2(["warn_on_failure"], {"warn_on_failure": opts['$!='](false)})
        };
        if ($truthy($$$('::', 'File')['$readable?'](path))) {
          if ($truthy(opts['$[]']("normalize"))) {
            
            return $$($nesting, 'Helpers').$prepare_source_string($$$('::', 'File').$read(path, $hash2(["mode"], {"mode": $$($nesting, 'FILE_READ_MODE')}))).$join($$($nesting, 'LF'));
          } else {
            
            return $$$('::', 'File').$read(path, $hash2(["mode"], {"mode": $$($nesting, 'FILE_READ_MODE')}));
          }
        } else if ($truthy(opts['$[]']("warn_on_failure"))) {
          
          self.$logger().$warn("" + (($truthy($a = self.$attr("docfile")) ? $a : "<stdin>")) + ": " + (($truthy($a = opts['$[]']("label")) ? $a : "file")) + " does not exist or cannot be read: " + (path));
          return nil;
        } else {
          return nil
        };
      }, $AbstractNode_read_asset$34.$$arity = -2);
      
      Opal.def(self, '$read_contents', $AbstractNode_read_contents$35 = function $$read_contents(target, opts) {
        var $a, $b, $c, $$36, $$37, self = this, doc = nil, start = nil, contents = nil;

        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        doc = self.document;
        if ($truthy(($truthy($a = $$($nesting, 'Helpers')['$uriish?'](target)) ? $a : ($truthy($b = ($truthy($c = (start = opts['$[]']("start"))) ? $$($nesting, 'Helpers')['$uriish?'](start) : $c)) ? (target = doc.$path_resolver().$web_path(target, start)) : $b)))) {
          if ($truthy(doc['$attr?']("allow-uri-read"))) {
            
            if ($truthy(doc['$attr?']("cache-uri"))) {
              $$($nesting, 'Helpers').$require_library("open-uri/cached", "open-uri-cached")};
            
            try {
              if ($truthy(opts['$[]']("normalize"))) {
                contents = $$($nesting, 'Helpers').$prepare_source_string($send($$$('::', 'OpenURI'), 'open_uri', [target, $$($nesting, 'URI_READ_MODE')], ($$36 = function(f){var self = $$36.$$s || this;

                
                  
                  if (f == null) {
                    f = nil;
                  };
                  return f.$read();}, $$36.$$s = self, $$36.$$arity = 1, $$36))).$join($$($nesting, 'LF'))
              } else {
                contents = $send($$$('::', 'OpenURI'), 'open_uri', [target, $$($nesting, 'URI_READ_MODE')], ($$37 = function(f){var self = $$37.$$s || this;

                
                  
                  if (f == null) {
                    f = nil;
                  };
                  return f.$read();}, $$37.$$s = self, $$37.$$arity = 1, $$37))
              }
            } catch ($err) {
              if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
                try {
                  if ($truthy(opts.$fetch("warn_on_failure", true))) {
                    self.$logger().$warn("" + "could not retrieve contents of " + (($truthy($a = opts['$[]']("label")) ? $a : "asset")) + " at URI: " + (target))}
                } finally { Opal.pop_exception() }
              } else { throw $err; }
            };;
          } else if ($truthy(opts.$fetch("warn_on_failure", true))) {
            self.$logger().$warn("" + "cannot retrieve contents of " + (($truthy($a = opts['$[]']("label")) ? $a : "asset")) + " at URI: " + (target) + " (allow-uri-read attribute not enabled)")}
        } else {
          
          target = self.$normalize_system_path(target, opts['$[]']("start"), nil, $hash2(["target_name"], {"target_name": ($truthy($a = opts['$[]']("label")) ? $a : "asset")}));
          contents = self.$read_asset(target, $hash2(["normalize", "warn_on_failure", "label"], {"normalize": opts['$[]']("normalize"), "warn_on_failure": opts.$fetch("warn_on_failure", true), "label": opts['$[]']("label")}));
        };
        if ($truthy(($truthy($a = ($truthy($b = contents) ? opts['$[]']("warn_if_empty") : $b)) ? contents['$empty?']() : $a))) {
          self.$logger().$warn("" + "contents of " + (($truthy($a = opts['$[]']("label")) ? $a : "asset")) + " is empty: " + (target))};
        return contents;
      }, $AbstractNode_read_contents$35.$$arity = -2);
      return (Opal.def(self, '$is_uri?', $AbstractNode_is_uri$ques$38 = function(str) {
        var self = this;

        return $$($nesting, 'Helpers')['$uriish?'](str)
      }, $AbstractNode_is_uri$ques$38.$$arity = 1), nil) && 'is_uri?';
    })($nesting[0], null, $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/abstract_block"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $hash2 = Opal.hash2, $send = Opal.send, $truthy = Opal.truthy;

  Opal.add_stubs(['$attr_reader', '$attr_writer', '$attr_accessor', '$==', '$===', '$level', '$file', '$lineno', '$playback_attributes', '$convert', '$converter', '$join', '$map', '$to_s', '$parent', '$parent=', '$-', '$<<', '$empty?', '$Integer', '$find_by_internal', '$to_proc', '$context', '$[]', '$items', '$+', '$find_index', '$include?', '$next_adjacent_block', '$blocks', '$select', '$sub_specialchars', '$match?', '$sub_replacements', '$title', '$apply_title_subs', '$delete', '$reftext', '$!', '$nil_or_empty?', '$sub_placeholder', '$sub_quotes', '$compat_mode', '$attributes', '$chomp', '$increment_and_store_counter', '$index=', '$numbered', '$sectname', '$counter', '$numeral=', '$numeral', '$caption=', '$int_to_roman', '$each', '$assign_numeral', '$reindex_sections', '$protected', '$has_role?', '$raise', '$header?', '$!=', '$flatten', '$head', '$rows', '$merge', '$body', '$foot', '$style', '$inner_document']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'AbstractBlock');

      var $nesting = [self].concat($parent_nesting), $AbstractBlock_initialize$1, $AbstractBlock_block$ques$2, $AbstractBlock_inline$ques$3, $AbstractBlock_file$4, $AbstractBlock_lineno$5, $AbstractBlock_convert$6, $AbstractBlock_content$7, $AbstractBlock_context$eq$9, $AbstractBlock_$lt$lt$10, $AbstractBlock_blocks$ques$11, $AbstractBlock_sections$ques$12, $AbstractBlock_number$13, $AbstractBlock_number$eq$14, $AbstractBlock_find_by$15, $AbstractBlock_next_adjacent_block$16, $AbstractBlock_sections$18, $AbstractBlock_alt$20, $AbstractBlock_caption$21, $AbstractBlock_captioned_title$22, $AbstractBlock_list_marker_keyword$23, $AbstractBlock_title$24, $AbstractBlock_title$ques$25, $AbstractBlock_title$eq$26, $AbstractBlock_sub$ques$27, $AbstractBlock_remove_sub$28, $AbstractBlock_xreftext$29, $AbstractBlock_assign_caption$30, $AbstractBlock_assign_numeral$31, $AbstractBlock_reindex_sections$32, $AbstractBlock_find_by_internal$34;

      self.$$prototype.source_location = self.$$prototype.document = self.$$prototype.attributes = self.$$prototype.blocks = self.$$prototype.numeral = self.$$prototype.context = self.$$prototype.parent = self.$$prototype.caption = self.$$prototype.style = self.$$prototype.converted_title = self.$$prototype.title = self.$$prototype.subs = self.$$prototype.next_section_index = self.$$prototype.next_section_ordinal = self.$$prototype.id = self.$$prototype.header = nil;
      
      self.$attr_reader("blocks");
      self.$attr_writer("caption");
      self.$attr_accessor("content_model");
      self.$attr_accessor("level");
      self.$attr_accessor("numeral");
      self.$attr_accessor("source_location");
      self.$attr_accessor("style");
      self.$attr_reader("subs");
      
      Opal.def(self, '$initialize', $AbstractBlock_initialize$1 = function $$initialize(parent, context, opts) {
        var $a, $iter = $AbstractBlock_initialize$1.$$p, $yield = $iter || nil, self = this, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) $AbstractBlock_initialize$1.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        $send(self, Opal.find_super_dispatcher(self, 'initialize', $AbstractBlock_initialize$1, false), $zuper, $iter);
        self.content_model = "compound";
        self.blocks = [];
        self.subs = [];
        self.id = (self.title = (self.caption = (self.numeral = (self.style = (self.default_subs = (self.source_location = nil))))));
        if ($truthy(($truthy($a = context['$==']("document")) ? $a : context['$==']("section")))) {
          
          self.level = (self.next_section_index = 0);
          return (self.next_section_ordinal = 1);
        } else if ($truthy($$($nesting, 'AbstractBlock')['$==='](parent))) {
          return (self.level = parent.$level())
        } else {
          return (self.level = nil)
        };
      }, $AbstractBlock_initialize$1.$$arity = -3);
      
      Opal.def(self, '$block?', $AbstractBlock_block$ques$2 = function() {
        var self = this;

        return true
      }, $AbstractBlock_block$ques$2.$$arity = 0);
      
      Opal.def(self, '$inline?', $AbstractBlock_inline$ques$3 = function() {
        var self = this;

        return false
      }, $AbstractBlock_inline$ques$3.$$arity = 0);
      
      Opal.def(self, '$file', $AbstractBlock_file$4 = function $$file() {
        var $a, self = this;

        return ($truthy($a = self.source_location) ? self.source_location.$file() : $a)
      }, $AbstractBlock_file$4.$$arity = 0);
      
      Opal.def(self, '$lineno', $AbstractBlock_lineno$5 = function $$lineno() {
        var $a, self = this;

        return ($truthy($a = self.source_location) ? self.source_location.$lineno() : $a)
      }, $AbstractBlock_lineno$5.$$arity = 0);
      
      Opal.def(self, '$convert', $AbstractBlock_convert$6 = function $$convert() {
        var self = this;

        
        self.document.$playback_attributes(self.attributes);
        return self.$converter().$convert(self);
      }, $AbstractBlock_convert$6.$$arity = 0);
      Opal.alias(self, "render", "convert");
      
      Opal.def(self, '$content', $AbstractBlock_content$7 = function $$content() {
        var $$8, self = this;

        return $send(self.blocks, 'map', [], ($$8 = function(b){var self = $$8.$$s || this;

        
          
          if (b == null) {
            b = nil;
          };
          return b.$convert();}, $$8.$$s = self, $$8.$$arity = 1, $$8)).$join($$($nesting, 'LF'))
      }, $AbstractBlock_content$7.$$arity = 0);
      
      Opal.def(self, '$context=', $AbstractBlock_context$eq$9 = function(context) {
        var self = this;

        return (self.node_name = (self.context = context).$to_s())
      }, $AbstractBlock_context$eq$9.$$arity = 1);
      
      Opal.def(self, '$<<', $AbstractBlock_$lt$lt$10 = function(block) {
        var self = this, $writer = nil;

        
        if (block.$parent()['$=='](self)) {
        } else {
          
          $writer = [self];
          $send(block, 'parent=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];
        };
        self.blocks['$<<'](block);
        return self;
      }, $AbstractBlock_$lt$lt$10.$$arity = 1);
      Opal.alias(self, "append", "<<");
      
      Opal.def(self, '$blocks?', $AbstractBlock_blocks$ques$11 = function() {
        var self = this;

        if ($truthy(self.blocks['$empty?']())) {
          return false
        } else {
          return true
        }
      }, $AbstractBlock_blocks$ques$11.$$arity = 0);
      
      Opal.def(self, '$sections?', $AbstractBlock_sections$ques$12 = function() {
        var self = this;

        return false
      }, $AbstractBlock_sections$ques$12.$$arity = 0);
      
      Opal.def(self, '$number', $AbstractBlock_number$13 = function $$number() {
        var self = this;

        try {
          
          return self.$Integer(self.numeral);
        } catch ($err) {
          if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
            try {
              return self.numeral
            } finally { Opal.pop_exception() }
          } else { throw $err; }
        }
      }, $AbstractBlock_number$13.$$arity = 0);
      
      Opal.def(self, '$number=', $AbstractBlock_number$eq$14 = function(val) {
        var self = this;

        return (self.numeral = val.$to_s())
      }, $AbstractBlock_number$eq$14.$$arity = 1);
      
      Opal.def(self, '$find_by', $AbstractBlock_find_by$15 = function $$find_by(selector) {
        var $iter = $AbstractBlock_find_by$15.$$p, block = $iter || nil, self = this, result = nil;

        if ($iter) $AbstractBlock_find_by$15.$$p = null;
        
        
        if ($iter) $AbstractBlock_find_by$15.$$p = null;;
        
        if (selector == null) {
          selector = $hash2([], {});
        };
        try {
          return $send(self, 'find_by_internal', [selector, (result = [])], block.$to_proc())
        } catch ($err) {
          if (Opal.rescue($err, [$$$('::', 'StopIteration')])) {
            try {
              return result
            } finally { Opal.pop_exception() }
          } else { throw $err; }
        };
      }, $AbstractBlock_find_by$15.$$arity = -1);
      Opal.alias(self, "query", "find_by");
      
      Opal.def(self, '$next_adjacent_block', $AbstractBlock_next_adjacent_block$16 = function $$next_adjacent_block() {
        var $a, $$17, self = this, p = nil, sib = nil;

        if (self.context['$==']("document")) {
          return nil
        } else if ($truthy((($a = (p = self.parent).$context()['$==']("dlist")) ? self.context['$==']("list_item") : (p = self.parent).$context()['$==']("dlist")))) {
          if ($truthy((sib = p.$items()['$[]']($rb_plus($send(p.$items(), 'find_index', [], ($$17 = function(terms, desc){var self = $$17.$$s || this, $b;

          
            
            if (terms == null) {
              terms = nil;
            };
            
            if (desc == null) {
              desc = nil;
            };
            return ($truthy($b = terms['$include?'](self)) ? $b : desc['$=='](self));}, $$17.$$s = self, $$17.$$arity = 2, $$17)), 1))))) {
            return sib
          } else {
            return p.$next_adjacent_block()
          }
        } else if ($truthy((sib = p.$blocks()['$[]']($rb_plus(p.$blocks().$find_index(self), 1))))) {
          return sib
        } else {
          return p.$next_adjacent_block()
        }
      }, $AbstractBlock_next_adjacent_block$16.$$arity = 0);
      
      Opal.def(self, '$sections', $AbstractBlock_sections$18 = function $$sections() {
        var $$19, self = this;

        return $send(self.blocks, 'select', [], ($$19 = function(block){var self = $$19.$$s || this;

        
          
          if (block == null) {
            block = nil;
          };
          return block.$context()['$==']("section");}, $$19.$$s = self, $$19.$$arity = 1, $$19))
      }, $AbstractBlock_sections$18.$$arity = 0);
      
      Opal.def(self, '$alt', $AbstractBlock_alt$20 = function $$alt() {
        var self = this, text = nil;

        if ($truthy((text = self.attributes['$[]']("alt")))) {
          if (text['$=='](self.attributes['$[]']("default-alt"))) {
            return self.$sub_specialchars(text)
          } else {
            
            text = self.$sub_specialchars(text);
            if ($truthy($$($nesting, 'ReplaceableTextRx')['$match?'](text))) {
              
              return self.$sub_replacements(text);
            } else {
              return text
            };
          }
        } else {
          return ""
        }
      }, $AbstractBlock_alt$20.$$arity = 0);
      
      Opal.def(self, '$caption', $AbstractBlock_caption$21 = function $$caption() {
        var self = this;

        if (self.context['$==']("admonition")) {
          return self.attributes['$[]']("textlabel")
        } else {
          return self.caption
        }
      }, $AbstractBlock_caption$21.$$arity = 0);
      
      Opal.def(self, '$captioned_title', $AbstractBlock_captioned_title$22 = function $$captioned_title() {
        var self = this;

        return "" + (self.caption) + (self.$title())
      }, $AbstractBlock_captioned_title$22.$$arity = 0);
      
      Opal.def(self, '$list_marker_keyword', $AbstractBlock_list_marker_keyword$23 = function $$list_marker_keyword(list_type) {
        var $a, self = this;

        
        
        if (list_type == null) {
          list_type = nil;
        };
        return $$($nesting, 'ORDERED_LIST_KEYWORDS')['$[]'](($truthy($a = list_type) ? $a : self.style));
      }, $AbstractBlock_list_marker_keyword$23.$$arity = -1);
      
      Opal.def(self, '$title', $AbstractBlock_title$24 = function $$title() {
        var $a, $b, self = this;

        return (self.converted_title = ($truthy($a = self.converted_title) ? $a : ($truthy($b = self.title) ? self.$apply_title_subs(self.title) : $b)))
      }, $AbstractBlock_title$24.$$arity = 0);
      
      Opal.def(self, '$title?', $AbstractBlock_title$ques$25 = function() {
        var self = this;

        if ($truthy(self.title)) {
          return true
        } else {
          return false
        }
      }, $AbstractBlock_title$ques$25.$$arity = 0);
      
      Opal.def(self, '$title=', $AbstractBlock_title$eq$26 = function(val) {
        var self = this;

        
        self.converted_title = nil;
        return (self.title = val);
      }, $AbstractBlock_title$eq$26.$$arity = 1);
      
      Opal.def(self, '$sub?', $AbstractBlock_sub$ques$27 = function(name) {
        var self = this;

        return self.subs['$include?'](name)
      }, $AbstractBlock_sub$ques$27.$$arity = 1);
      
      Opal.def(self, '$remove_sub', $AbstractBlock_remove_sub$28 = function $$remove_sub(sub) {
        var self = this;

        
        self.subs.$delete(sub);
        return nil;
      }, $AbstractBlock_remove_sub$28.$$arity = 1);
      
      Opal.def(self, '$xreftext', $AbstractBlock_xreftext$29 = function $$xreftext(xrefstyle) {
        var $a, $b, self = this, val = nil, $case = nil, quoted_title = nil, caption_attr_name = nil, prefix = nil;

        
        
        if (xrefstyle == null) {
          xrefstyle = nil;
        };
        if ($truthy(($truthy($a = (val = self.$reftext())) ? val['$empty?']()['$!']() : $a))) {
          return val
        } else if ($truthy(($truthy($a = ($truthy($b = xrefstyle) ? self.title : $b)) ? self.caption['$nil_or_empty?']()['$!']() : $a))) {
          return (function() {$case = xrefstyle;
          if ("full"['$===']($case)) {
          quoted_title = self.$sub_placeholder(self.$sub_quotes((function() {if ($truthy(self.document.$compat_mode())) {
            return "``%s''"
          } else {
            return "\"`%s`\""
          }; return nil; })()), self.$title());
          if ($truthy(($truthy($a = ($truthy($b = self.numeral) ? (caption_attr_name = $$($nesting, 'CAPTION_ATTRIBUTE_NAMES')['$[]'](self.context)) : $b)) ? (prefix = self.document.$attributes()['$[]'](caption_attr_name)) : $a))) {
            return "" + (prefix) + " " + (self.numeral) + ", " + (quoted_title)
          } else {
            return "" + (self.caption.$chomp(". ")) + ", " + (quoted_title)
          };}
          else if ("short"['$===']($case)) {if ($truthy(($truthy($a = ($truthy($b = self.numeral) ? (caption_attr_name = $$($nesting, 'CAPTION_ATTRIBUTE_NAMES')['$[]'](self.context)) : $b)) ? (prefix = self.document.$attributes()['$[]'](caption_attr_name)) : $a))) {
            return "" + (prefix) + " " + (self.numeral)
          } else {
            return self.caption.$chomp(". ")
          }}
          else {return self.$title()}})()
        } else {
          return self.$title()
        };
      }, $AbstractBlock_xreftext$29.$$arity = -1);
      
      Opal.def(self, '$assign_caption', $AbstractBlock_assign_caption$30 = function $$assign_caption(value, caption_context) {
        var $a, $b, self = this, attr_name = nil, prefix = nil;

        
        
        if (caption_context == null) {
          caption_context = self.context;
        };
        if ($truthy(($truthy($a = ($truthy($b = self.caption) ? $b : self.title['$!']())) ? $a : (self.caption = ($truthy($b = value) ? $b : self.document.$attributes()['$[]']("caption")))))) {
          return nil
        } else if ($truthy(($truthy($a = (attr_name = $$($nesting, 'CAPTION_ATTRIBUTE_NAMES')['$[]'](caption_context))) ? (prefix = self.document.$attributes()['$[]'](attr_name)) : $a))) {
          
          self.caption = "" + (prefix) + " " + ((self.numeral = self.document.$increment_and_store_counter("" + (caption_context) + "-number", self))) + ". ";
          return nil;
        } else {
          return nil
        };
      }, $AbstractBlock_assign_caption$30.$$arity = -2);
      
      Opal.def(self, '$assign_numeral', $AbstractBlock_assign_numeral$31 = function $$assign_numeral(section) {
        var $a, self = this, $writer = nil, like = nil, sectname = nil, caption = nil;

        
        self.next_section_index = $rb_plus((($writer = [self.next_section_index]), $send(section, 'index=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]), 1);
        if ($truthy((like = section.$numbered()))) {
          if ((sectname = section.$sectname())['$==']("appendix")) {
            
            
            $writer = [self.document.$counter("appendix-number", "A")];
            $send(section, 'numeral=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            
            $writer = [(function() {if ($truthy((caption = self.document.$attributes()['$[]']("appendix-caption")))) {
              return "" + (caption) + " " + (section.$numeral()) + ": "
            } else {
              return "" + (section.$numeral()) + ". "
            }; return nil; })()];
            $send(section, 'caption=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
          } else if ($truthy(($truthy($a = sectname['$==']("chapter")) ? $a : like['$==']("chapter")))) {
            
            $writer = [self.document.$counter("chapter-number", 1).$to_s()];
            $send(section, 'numeral=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          } else {
            
            
            $writer = [(function() {if (sectname['$==']("part")) {
              
              return $$($nesting, 'Helpers').$int_to_roman(self.next_section_ordinal);
            } else {
              return self.next_section_ordinal.$to_s()
            }; return nil; })()];
            $send(section, 'numeral=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            self.next_section_ordinal = $rb_plus(self.next_section_ordinal, 1);
          }};
        return nil;
      }, $AbstractBlock_assign_numeral$31.$$arity = 1);
      
      Opal.def(self, '$reindex_sections', $AbstractBlock_reindex_sections$32 = function $$reindex_sections() {
        var $$33, self = this;

        
        self.next_section_index = 0;
        self.next_section_ordinal = 1;
        return $send(self.blocks, 'each', [], ($$33 = function(block){var self = $$33.$$s || this;

        
          
          if (block == null) {
            block = nil;
          };
          if (block.$context()['$==']("section")) {
            
            self.$assign_numeral(block);
            return block.$reindex_sections();
          } else {
            return nil
          };}, $$33.$$s = self, $$33.$$arity = 1, $$33));
      }, $AbstractBlock_reindex_sections$32.$$arity = 0);
      self.$protected();
      return (Opal.def(self, '$find_by_internal', $AbstractBlock_find_by_internal$34 = function $$find_by_internal(selector, result) {
        var $iter = $AbstractBlock_find_by_internal$34.$$p, block = $iter || nil, $a, $b, $c, $d, $$35, $$36, $$37, $$39, $$41, $$43, self = this, any_context = nil, context_selector = nil, style_selector = nil, role_selector = nil, id_selector = nil, verdict = nil, $case = nil;

        if ($iter) $AbstractBlock_find_by_internal$34.$$p = null;
        
        
        if ($iter) $AbstractBlock_find_by_internal$34.$$p = null;;
        
        if (selector == null) {
          selector = $hash2([], {});
        };
        
        if (result == null) {
          result = [];
        };
        if ($truthy(($truthy($a = ($truthy($b = ($truthy($c = ($truthy($d = (any_context = (function() {if ($truthy((context_selector = selector['$[]']("context")))) {
          return nil
        } else {
          return true
        }; return nil; })())) ? $d : context_selector['$=='](self.context))) ? ($truthy($d = (style_selector = selector['$[]']("style"))['$!']()) ? $d : style_selector['$=='](self.style)) : $c)) ? ($truthy($c = (role_selector = selector['$[]']("role"))['$!']()) ? $c : self['$has_role?'](role_selector)) : $b)) ? ($truthy($b = (id_selector = selector['$[]']("id"))['$!']()) ? $b : id_selector['$=='](self.id)) : $a))) {
          if ((block !== nil)) {
            if ($truthy((verdict = Opal.yield1(block, self)))) {
              $case = verdict;
              if ("prune"['$===']($case)) {
              result['$<<'](self);
              if ($truthy(id_selector)) {
                self.$raise($$$('::', 'StopIteration'))};
              return result;}
              else if ("reject"['$===']($case)) {
              if ($truthy(id_selector)) {
                self.$raise($$$('::', 'StopIteration'))};
              return result;}
              else if ("stop"['$===']($case)) {self.$raise($$$('::', 'StopIteration'))}
              else {
              result['$<<'](self);
              if ($truthy(id_selector)) {
                self.$raise($$$('::', 'StopIteration'))};}
            } else if ($truthy(id_selector)) {
              self.$raise($$$('::', 'StopIteration'))}
          } else {
            
            result['$<<'](self);
            if ($truthy(id_selector)) {
              self.$raise($$$('::', 'StopIteration'))};
          }};
        $case = self.context;
        if ("document"['$===']($case)) {if (context_selector['$==']("document")) {
        } else {
          
          if ($truthy(($truthy($a = self['$header?']()) ? ($truthy($b = any_context) ? $b : context_selector['$==']("section")) : $a))) {
            $send(self.header, 'find_by_internal', [selector, result], block.$to_proc())};
          $send(self.blocks, 'each', [], ($$35 = function(b){var self = $$35.$$s || this, $e;

          
            
            if (b == null) {
              b = nil;
            };
            if ($truthy((($e = context_selector['$==']("section")) ? b.$context()['$!=']("section") : context_selector['$==']("section")))) {
              return nil;};
            return $send(b, 'find_by_internal', [selector, result], block.$to_proc());}, $$35.$$s = self, $$35.$$arity = 1, $$35));
        }}
        else if ("dlist"['$===']($case)) {if ($truthy(($truthy($a = any_context) ? $a : context_selector['$!=']("section")))) {
          $send(self.blocks.$flatten(), 'each', [], ($$36 = function(b){var self = $$36.$$s || this;

          
            
            if (b == null) {
              b = nil;
            };
            if ($truthy(b)) {
              return $send(b, 'find_by_internal', [selector, result], block.$to_proc())
            } else {
              return nil
            };}, $$36.$$s = self, $$36.$$arity = 1, $$36))}}
        else if ("table"['$===']($case)) {if ($truthy(selector['$[]']("traverse_documents"))) {
          
          $send(self.$rows().$head(), 'each', [], ($$37 = function(r){var self = $$37.$$s || this, $$38;

          
            
            if (r == null) {
              r = nil;
            };
            return $send(r, 'each', [], ($$38 = function(c){var self = $$38.$$s || this;

            
              
              if (c == null) {
                c = nil;
              };
              return $send(c, 'find_by_internal', [selector, result], block.$to_proc());}, $$38.$$s = self, $$38.$$arity = 1, $$38));}, $$37.$$s = self, $$37.$$arity = 1, $$37));
          if (context_selector['$==']("inner_document")) {
            selector = selector.$merge($hash2(["context"], {"context": "document"}))};
          $send($rb_plus(self.$rows().$body(), self.$rows().$foot()), 'each', [], ($$39 = function(r){var self = $$39.$$s || this, $$40;

          
            
            if (r == null) {
              r = nil;
            };
            return $send(r, 'each', [], ($$40 = function(c){var self = $$40.$$s || this;

            
              
              if (c == null) {
                c = nil;
              };
              $send(c, 'find_by_internal', [selector, result], block.$to_proc());
              if (c.$style()['$==']("asciidoc")) {
                return $send(c.$inner_document(), 'find_by_internal', [selector, result], block.$to_proc())
              } else {
                return nil
              };}, $$40.$$s = self, $$40.$$arity = 1, $$40));}, $$39.$$s = self, $$39.$$arity = 1, $$39));
        } else {
          $send($rb_plus($rb_plus(self.$rows().$head(), self.$rows().$body()), self.$rows().$foot()), 'each', [], ($$41 = function(r){var self = $$41.$$s || this, $$42;

          
            
            if (r == null) {
              r = nil;
            };
            return $send(r, 'each', [], ($$42 = function(c){var self = $$42.$$s || this;

            
              
              if (c == null) {
                c = nil;
              };
              return $send(c, 'find_by_internal', [selector, result], block.$to_proc());}, $$42.$$s = self, $$42.$$arity = 1, $$42));}, $$41.$$s = self, $$41.$$arity = 1, $$41))
        }}
        else {$send(self.blocks, 'each', [], ($$43 = function(b){var self = $$43.$$s || this, $e;

        
          
          if (b == null) {
            b = nil;
          };
          if ($truthy((($e = context_selector['$==']("section")) ? b.$context()['$!=']("section") : context_selector['$==']("section")))) {
            return nil;};
          return $send(b, 'find_by_internal', [selector, result], block.$to_proc());}, $$43.$$s = self, $$43.$$arity = 1, $$43))};
        return result;
      }, $AbstractBlock_find_by_internal$34.$$arity = -1), nil) && 'find_by_internal';
    })($nesting[0], $$($nesting, 'AbstractNode'), $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/attribute_list"] = function(Opal) {
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_times(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs * rhs : lhs['$*'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $hash = Opal.hash, $hash2 = Opal.hash2, $truthy = Opal.truthy, $send = Opal.send;

  Opal.add_stubs(['$new', '$[]', '$update', '$parse', '$parse_attribute', '$eos?', '$skip_delimiter', '$+', '$rekey', '$each_with_index', '$[]=', '$-', '$private', '$skip_blank', '$peek', '$===', '$parse_attribute_value', '$get_byte', '$start_with?', '$scan_name', '$end_with?', '$rstrip', '$string', '$==', '$unscan', '$scan_to_delimiter', '$*', '$include?', '$delete', '$each', '$split', '$empty?', '$apply_subs', '$scan_to_quote', '$gsub', '$skip', '$scan']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'AttributeList');

      var $nesting = [self].concat($parent_nesting), $AttributeList_initialize$1, $AttributeList_parse_into$2, $AttributeList_parse$3, $AttributeList_rekey$4, $AttributeList_rekey$5, $AttributeList_parse_attribute$7, $AttributeList_parse_attribute_value$9, $AttributeList_skip_blank$10, $AttributeList_skip_delimiter$11, $AttributeList_scan_name$12, $AttributeList_scan_to_delimiter$13, $AttributeList_scan_to_quote$14;

      self.$$prototype.attributes = self.$$prototype.scanner = self.$$prototype.delimiter = self.$$prototype.block = self.$$prototype.delimiter_skip_pattern = self.$$prototype.delimiter_boundary_pattern = nil;
      
      Opal.const_set($nesting[0], 'APOS', "'");
      Opal.const_set($nesting[0], 'BACKSLASH', "\\");
      Opal.const_set($nesting[0], 'QUOT', "\"");
      Opal.const_set($nesting[0], 'BoundaryRx', $hash($$($nesting, 'QUOT'), /.*?[^\\](?=")/, $$($nesting, 'APOS'), /.*?[^\\](?=')/, ",", /.*?(?=[ \t]*(,|$))/));
      Opal.const_set($nesting[0], 'EscapedQuotes', $hash($$($nesting, 'QUOT'), "\\\"", $$($nesting, 'APOS'), "\\'"));
      Opal.const_set($nesting[0], 'NameRx', new RegExp("" + ($$($nesting, 'CG_WORD')) + "[" + ($$($nesting, 'CC_WORD')) + "\\-.]*"));
      Opal.const_set($nesting[0], 'BlankRx', /[ \t]+/);
      Opal.const_set($nesting[0], 'SkipRx', $hash2([","], {",": /[ \t]*(,|$)/}));
      
      Opal.def(self, '$initialize', $AttributeList_initialize$1 = function $$initialize(source, block, delimiter) {
        var self = this;

        
        
        if (block == null) {
          block = nil;
        };
        
        if (delimiter == null) {
          delimiter = ",";
        };
        self.scanner = $$$('::', 'StringScanner').$new(source);
        self.block = block;
        self.delimiter = delimiter;
        self.delimiter_skip_pattern = $$($nesting, 'SkipRx')['$[]'](delimiter);
        self.delimiter_boundary_pattern = $$($nesting, 'BoundaryRx')['$[]'](delimiter);
        return (self.attributes = nil);
      }, $AttributeList_initialize$1.$$arity = -2);
      
      Opal.def(self, '$parse_into', $AttributeList_parse_into$2 = function $$parse_into(attributes, positional_attrs) {
        var self = this;

        
        
        if (positional_attrs == null) {
          positional_attrs = [];
        };
        return attributes.$update(self.$parse(positional_attrs));
      }, $AttributeList_parse_into$2.$$arity = -2);
      
      Opal.def(self, '$parse', $AttributeList_parse$3 = function $$parse(positional_attrs) {
        var $a, self = this, index = nil;

        
        
        if (positional_attrs == null) {
          positional_attrs = [];
        };
        if ($truthy(self.attributes)) {
          return self.attributes};
        self.attributes = $hash2([], {});
        index = 0;
        while ($truthy(self.$parse_attribute(index, positional_attrs))) {
          
          if ($truthy(self.scanner['$eos?']())) {
            break;};
          self.$skip_delimiter();
          index = $rb_plus(index, 1);
        };
        return self.attributes;
      }, $AttributeList_parse$3.$$arity = -1);
      
      Opal.def(self, '$rekey', $AttributeList_rekey$4 = function $$rekey(positional_attrs) {
        var self = this;

        return $$($nesting, 'AttributeList').$rekey(self.attributes, positional_attrs)
      }, $AttributeList_rekey$4.$$arity = 1);
      Opal.defs(self, '$rekey', $AttributeList_rekey$5 = function $$rekey(attributes, positional_attrs) {
        var $$6, self = this;

        
        $send(positional_attrs, 'each_with_index', [], ($$6 = function(key, index){var self = $$6.$$s || this, $a, val = nil, $writer = nil;

        
          
          if (key == null) {
            key = nil;
          };
          
          if (index == null) {
            index = nil;
          };
          if ($truthy(($truthy($a = key) ? (val = attributes['$[]']($rb_plus(index, 1))) : $a))) {
            
            $writer = [key, val];
            $send(attributes, '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];
          } else {
            return nil
          };}, $$6.$$s = self, $$6.$$arity = 2, $$6));
        return attributes;
      }, $AttributeList_rekey$5.$$arity = 2);
      self.$private();
      
      Opal.def(self, '$parse_attribute', $AttributeList_parse_attribute$7 = function $$parse_attribute(index, positional_attrs) {
        var $a, $b, $$8, self = this, continue$ = nil, $case = nil, name = nil, single_quoted = nil, skipped = nil, c = nil, value = nil, $writer = nil, positional_attr_name = nil;

        
        continue$ = true;
        self.$skip_blank();
        $case = self.scanner.$peek(1);
        if ($$($nesting, 'QUOT')['$===']($case)) {name = self.$parse_attribute_value(self.scanner.$get_byte())}
        else if ($$($nesting, 'APOS')['$===']($case)) {
        name = self.$parse_attribute_value(self.scanner.$get_byte());
        if ($truthy(name['$start_with?']($$($nesting, 'APOS')))) {
        } else {
          single_quoted = true
        };}
        else {
        skipped = ($truthy($a = ($truthy($b = (name = self.$scan_name())) ? self.$skip_blank() : $b)) ? $a : 0);
        if ($truthy(self.scanner['$eos?']())) {
          
          if ($truthy(($truthy($a = name) ? $a : self.scanner.$string().$rstrip()['$end_with?'](self.delimiter)))) {
          } else {
            return nil
          };
          continue$ = nil;
        } else if ((c = self.scanner.$get_byte())['$=='](self.delimiter)) {
          self.scanner.$unscan()
        } else if ($truthy(name)) {
          if (c['$==']("=")) {
            
            self.$skip_blank();
            $case = (c = self.scanner.$get_byte());
            if ($$($nesting, 'QUOT')['$===']($case)) {value = self.$parse_attribute_value(c)}
            else if ($$($nesting, 'APOS')['$===']($case)) {
            value = self.$parse_attribute_value(c);
            if ($truthy(value['$start_with?']($$($nesting, 'APOS')))) {
            } else {
              single_quoted = true
            };}
            else if (self.delimiter['$===']($case)) {
            value = "";
            self.scanner.$unscan();}
            else if (nil['$===']($case)) {value = ""}
            else {
            value = "" + (c) + (self.$scan_to_delimiter());
            if (value['$==']("None")) {
              return true};};
          } else {
            name = "" + (name) + ($rb_times(" ", skipped)) + (c) + (self.$scan_to_delimiter())
          }
        } else {
          name = "" + (c) + (self.$scan_to_delimiter())
        };};
        if ($truthy(value)) {
          $case = name;
          if ("options"['$===']($case) || "opts"['$===']($case)) {if ($truthy(value['$include?'](","))) {
            
            if ($truthy(value['$include?'](" "))) {
              value = value.$delete(" ")};
            $send(value.$split(","), 'each', [], ($$8 = function(opt){var self = $$8.$$s || this, $writer = nil;
              if (self.attributes == null) self.attributes = nil;

            
              
              if (opt == null) {
                opt = nil;
              };
              if ($truthy(opt['$empty?']())) {
                return nil
              } else {
                
                $writer = ["" + (opt) + "-option", ""];
                $send(self.attributes, '[]=', Opal.to_a($writer));
                return $writer[$rb_minus($writer["length"], 1)];
              };}, $$8.$$s = self, $$8.$$arity = 1, $$8));
          } else if ($truthy(value['$empty?']())) {
          } else {
            
            $writer = ["" + (value) + "-option", ""];
            $send(self.attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          }}
          else {if ($truthy(($truthy($a = single_quoted) ? self.block : $a))) {
            $case = name;
            if ("title"['$===']($case) || "reftext"['$===']($case)) {
            $writer = [name, value];
            $send(self.attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];}
            else {
            $writer = [name, self.block.$apply_subs(value)];
            $send(self.attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];}
          } else {
            
            $writer = [name, value];
            $send(self.attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          }}
        } else {
          
          if ($truthy(($truthy($a = single_quoted) ? self.block : $a))) {
            name = self.block.$apply_subs(name)};
          if ($truthy(($truthy($a = (positional_attr_name = positional_attrs['$[]'](index))) ? name : $a))) {
            
            $writer = [positional_attr_name, name];
            $send(self.attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          
          $writer = [$rb_plus(index, 1), name];
          $send(self.attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
        };
        return continue$;
      }, $AttributeList_parse_attribute$7.$$arity = 2);
      
      Opal.def(self, '$parse_attribute_value', $AttributeList_parse_attribute_value$9 = function $$parse_attribute_value(quote) {
        var self = this, value = nil;

        if (self.scanner.$peek(1)['$=='](quote)) {
          
          self.scanner.$get_byte();
          return "";
        } else if ($truthy((value = self.$scan_to_quote(quote)))) {
          
          self.scanner.$get_byte();
          if ($truthy(value['$include?']($$($nesting, 'BACKSLASH')))) {
            
            return value.$gsub($$($nesting, 'EscapedQuotes')['$[]'](quote), quote);
          } else {
            return value
          };
        } else {
          return "" + (quote) + (self.$scan_to_delimiter())
        }
      }, $AttributeList_parse_attribute_value$9.$$arity = 1);
      
      Opal.def(self, '$skip_blank', $AttributeList_skip_blank$10 = function $$skip_blank() {
        var self = this;

        return self.scanner.$skip($$($nesting, 'BlankRx'))
      }, $AttributeList_skip_blank$10.$$arity = 0);
      
      Opal.def(self, '$skip_delimiter', $AttributeList_skip_delimiter$11 = function $$skip_delimiter() {
        var self = this;

        return self.scanner.$skip(self.delimiter_skip_pattern)
      }, $AttributeList_skip_delimiter$11.$$arity = 0);
      
      Opal.def(self, '$scan_name', $AttributeList_scan_name$12 = function $$scan_name() {
        var self = this;

        return self.scanner.$scan($$($nesting, 'NameRx'))
      }, $AttributeList_scan_name$12.$$arity = 0);
      
      Opal.def(self, '$scan_to_delimiter', $AttributeList_scan_to_delimiter$13 = function $$scan_to_delimiter() {
        var self = this;

        return self.scanner.$scan(self.delimiter_boundary_pattern)
      }, $AttributeList_scan_to_delimiter$13.$$arity = 0);
      return (Opal.def(self, '$scan_to_quote', $AttributeList_scan_to_quote$14 = function $$scan_to_quote(quote) {
        var self = this;

        return self.scanner.$scan($$($nesting, 'BoundaryRx')['$[]'](quote))
      }, $AttributeList_scan_to_quote$14.$$arity = 1), nil) && 'scan_to_quote';
    })($nesting[0], null, $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/block"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $send = Opal.send, $hash2 = Opal.hash2, $truthy = Opal.truthy;

  Opal.add_stubs(['$default=', '$-', '$attr_accessor', '$[]', '$key?', '$===', '$drop', '$delete', '$to_s', '$[]=', '$commit_subs', '$nil_or_empty?', '$prepare_source_string', '$apply_subs', '$join', '$<', '$size', '$empty?', '$rstrip', '$shift', '$pop', '$==', '$warn', '$logger', '$class', '$object_id', '$inspect']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'Block');

      var $nesting = [self].concat($parent_nesting), $Block_initialize$1, $Block_content$2, $Block_source$3, $Block_to_s$4, $writer = nil;

      self.$$prototype.attributes = self.$$prototype.content_model = self.$$prototype.lines = self.$$prototype.subs = self.$$prototype.blocks = self.$$prototype.context = self.$$prototype.style = nil;
      
      
      $writer = ["simple"];
      $send(Opal.const_set($nesting[0], 'DEFAULT_CONTENT_MODEL', $hash2(["audio", "image", "listing", "literal", "stem", "open", "page_break", "pass", "thematic_break", "video"], {"audio": "empty", "image": "empty", "listing": "verbatim", "literal": "verbatim", "stem": "raw", "open": "compound", "page_break": "empty", "pass": "raw", "thematic_break": "empty", "video": "empty"})), 'default=', Opal.to_a($writer));
      $writer[$rb_minus($writer["length"], 1)];;
      Opal.alias(self, "blockname", "context");
      self.$attr_accessor("lines");
      
      Opal.def(self, '$initialize', $Block_initialize$1 = function $$initialize(parent, context, opts) {
        var $a, $iter = $Block_initialize$1.$$p, $yield = $iter || nil, self = this, subs = nil, $case = nil, $writer = nil, raw_source = nil, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) $Block_initialize$1.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        $send(self, Opal.find_super_dispatcher(self, 'initialize', $Block_initialize$1, false), $zuper, $iter);
        self.content_model = ($truthy($a = opts['$[]']("content_model")) ? $a : $$($nesting, 'DEFAULT_CONTENT_MODEL')['$[]'](context));
        if ($truthy(opts['$key?']("subs"))) {
          if ($truthy((subs = opts['$[]']("subs")))) {
            
            $case = subs;
            if ("default"['$===']($case)) {self.default_subs = opts['$[]']("default_subs")}
            else if ($$$('::', 'Array')['$===']($case)) {
            self.default_subs = subs.$drop(0);
            self.attributes.$delete("subs");}
            else {
            self.default_subs = nil;
            
            $writer = ["subs", subs.$to_s()];
            $send(self.attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;};
            self.$commit_subs();
          } else {
            
            self.default_subs = [];
            self.attributes.$delete("subs");
          }
        } else {
          self.default_subs = nil
        };
        if ($truthy((raw_source = opts['$[]']("source"))['$nil_or_empty?']())) {
          return (self.lines = [])
        } else if ($truthy($$$('::', 'String')['$==='](raw_source))) {
          return (self.lines = $$($nesting, 'Helpers').$prepare_source_string(raw_source))
        } else {
          return (self.lines = raw_source.$drop(0))
        };
      }, $Block_initialize$1.$$arity = -3);
      
      Opal.def(self, '$content', $Block_content$2 = function $$content() {
        var $a, $b, $iter = $Block_content$2.$$p, $yield = $iter || nil, self = this, $case = nil, result = nil, first = nil, last = nil, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) $Block_content$2.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        return (function() {$case = self.content_model;
        if ("compound"['$===']($case)) {return $send(self, Opal.find_super_dispatcher(self, 'content', $Block_content$2, false), $zuper, $iter)}
        else if ("simple"['$===']($case)) {return self.$apply_subs(self.lines.$join($$($nesting, 'LF')), self.subs)}
        else if ("verbatim"['$===']($case) || "raw"['$===']($case)) {
        result = self.$apply_subs(self.lines, self.subs);
        if ($truthy($rb_lt(result.$size(), 2))) {
          return result['$[]'](0)
        } else {
          
          while ($truthy(($truthy($b = (first = result['$[]'](0))) ? first.$rstrip()['$empty?']() : $b))) {
            result.$shift()
          };
          while ($truthy(($truthy($b = (last = result['$[]'](-1))) ? last.$rstrip()['$empty?']() : $b))) {
            result.$pop()
          };
          return result.$join($$($nesting, 'LF'));
        };}
        else {
        if (self.content_model['$==']("empty")) {
        } else {
          self.$logger().$warn("" + "Unknown content model '" + (self.content_model) + "' for block: " + (self))
        };
        return nil;}})()
      }, $Block_content$2.$$arity = 0);
      
      Opal.def(self, '$source', $Block_source$3 = function $$source() {
        var self = this;

        return self.lines.$join($$($nesting, 'LF'))
      }, $Block_source$3.$$arity = 0);
      return (Opal.def(self, '$to_s', $Block_to_s$4 = function $$to_s() {
        var self = this, content_summary = nil;

        
        content_summary = (function() {if (self.content_model['$==']("compound")) {
          return "" + "blocks: " + (self.blocks.$size())
        } else {
          return "" + "lines: " + (self.lines.$size())
        }; return nil; })();
        return "" + "#<" + (self.$class()) + "@" + (self.$object_id()) + " {context: " + (self.context.$inspect()) + ", content_model: " + (self.content_model.$inspect()) + ", style: " + (self.style.$inspect()) + ", " + (content_summary) + "}>";
      }, $Block_to_s$4.$$arity = 0), nil) && 'to_s';
    })($nesting[0], $$($nesting, 'AbstractBlock'), $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/callouts"] = function(Opal) {
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_le(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs <= rhs : lhs['$<='](rhs);
  }
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $hash2 = Opal.hash2, $truthy = Opal.truthy, $send = Opal.send;

  Opal.add_stubs(['$next_list', '$<<', '$current_list', '$to_i', '$generate_next_callout_id', '$+', '$<=', '$size', '$[]', '$-', '$chop', '$join', '$map', '$==', '$<', '$private', '$generate_callout_id']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'Callouts');

      var $nesting = [self].concat($parent_nesting), $Callouts_initialize$1, $Callouts_register$2, $Callouts_read_next_id$3, $Callouts_callout_ids$4, $Callouts_current_list$6, $Callouts_next_list$7, $Callouts_rewind$8, $Callouts_generate_next_callout_id$9, $Callouts_generate_callout_id$10;

      self.$$prototype.co_index = self.$$prototype.lists = self.$$prototype.list_index = nil;
      
      
      Opal.def(self, '$initialize', $Callouts_initialize$1 = function $$initialize() {
        var self = this;

        
        self.lists = [];
        self.list_index = 0;
        return self.$next_list();
      }, $Callouts_initialize$1.$$arity = 0);
      
      Opal.def(self, '$register', $Callouts_register$2 = function $$register(li_ordinal) {
        var self = this, id = nil;

        
        self.$current_list()['$<<']($hash2(["ordinal", "id"], {"ordinal": li_ordinal.$to_i(), "id": (id = self.$generate_next_callout_id())}));
        self.co_index = $rb_plus(self.co_index, 1);
        return id;
      }, $Callouts_register$2.$$arity = 1);
      
      Opal.def(self, '$read_next_id', $Callouts_read_next_id$3 = function $$read_next_id() {
        var self = this, id = nil, list = nil;

        
        id = nil;
        list = self.$current_list();
        if ($truthy($rb_le(self.co_index, list.$size()))) {
          id = list['$[]']($rb_minus(self.co_index, 1))['$[]']("id")};
        self.co_index = $rb_plus(self.co_index, 1);
        return id;
      }, $Callouts_read_next_id$3.$$arity = 0);
      
      Opal.def(self, '$callout_ids', $Callouts_callout_ids$4 = function $$callout_ids(li_ordinal) {
        var $$5, self = this;

        return $send(self.$current_list(), 'map', [], ($$5 = function(it){var self = $$5.$$s || this;

        
          
          if (it == null) {
            it = nil;
          };
          if (it['$[]']("ordinal")['$=='](li_ordinal)) {
            return "" + (it['$[]']("id")) + " "
          } else {
            return ""
          };}, $$5.$$s = self, $$5.$$arity = 1, $$5)).$join().$chop()
      }, $Callouts_callout_ids$4.$$arity = 1);
      
      Opal.def(self, '$current_list', $Callouts_current_list$6 = function $$current_list() {
        var self = this;

        return self.lists['$[]']($rb_minus(self.list_index, 1))
      }, $Callouts_current_list$6.$$arity = 0);
      
      Opal.def(self, '$next_list', $Callouts_next_list$7 = function $$next_list() {
        var self = this;

        
        self.list_index = $rb_plus(self.list_index, 1);
        if ($truthy($rb_lt(self.lists.$size(), self.list_index))) {
          self.lists['$<<']([])};
        self.co_index = 1;
        return nil;
      }, $Callouts_next_list$7.$$arity = 0);
      
      Opal.def(self, '$rewind', $Callouts_rewind$8 = function $$rewind() {
        var self = this;

        
        self.list_index = 1;
        self.co_index = 1;
        return nil;
      }, $Callouts_rewind$8.$$arity = 0);
      self.$private();
      
      Opal.def(self, '$generate_next_callout_id', $Callouts_generate_next_callout_id$9 = function $$generate_next_callout_id() {
        var self = this;

        return self.$generate_callout_id(self.list_index, self.co_index)
      }, $Callouts_generate_next_callout_id$9.$$arity = 0);
      return (Opal.def(self, '$generate_callout_id', $Callouts_generate_callout_id$10 = function $$generate_callout_id(list_index, co_index) {
        var self = this;

        return "" + "CO" + (list_index) + "-" + (co_index)
      }, $Callouts_generate_callout_id$10.$$arity = 2), nil) && 'generate_callout_id';
    })($nesting[0], null, $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/converter"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $hash2 = Opal.hash2, $truthy = Opal.truthy, $send = Opal.send, $klass = Opal.klass, $gvars = Opal.gvars;

  Opal.add_stubs(['$autoload', '$__dir__', '$==', '$attr_reader', '$raise', '$class', '$[]', '$sub', '$slice', '$length', '$[]=', '$backend_traits', '$-', '$derive_backend_traits', '$register', '$map', '$to_s', '$new', '$create', '$default', '$each', '$default=', '$registry', '$for', '$===', '$supports_templates?', '$merge', '$private', '$include', '$delete', '$clear', '$send', '$extend', '$private_class_method', '$node_name', '$+', '$receiver', '$name', '$warn', '$logger', '$respond_to?', '$content']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function($base, $parent_nesting) {
      var self = $module($base, 'Converter');

      var $nesting = [self].concat($parent_nesting), $Converter_initialize$1, $Converter_convert$2, $Converter_handles$ques$3, $Converter_derive_backend_traits$4, $Converter_included$28;

      
      self.$autoload("CompositeConverter", "" + (self.$__dir__()) + "/converter/composite");
      if ($$($nesting, 'RUBY_ENGINE')['$==']("opal")) {
      } else {
        nil
      };
      self.$attr_reader("backend");
      
      Opal.def(self, '$initialize', $Converter_initialize$1 = function $$initialize(backend, opts) {
        var self = this;

        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        return (self.backend = backend);
      }, $Converter_initialize$1.$$arity = -2);
      
      Opal.def(self, '$convert', $Converter_convert$2 = function $$convert(node, transform, opts) {
        var self = this;
        if (self.backend == null) self.backend = nil;

        
        
        if (transform == null) {
          transform = nil;
        };
        
        if (opts == null) {
          opts = nil;
        };
        return self.$raise($$$('::', 'NotImplementedError'), "" + (self.$class()) + " (backend: " + (self.backend) + ") must implement the #" + ("convert") + " method");
      }, $Converter_convert$2.$$arity = -2);
      
      Opal.def(self, '$handles?', $Converter_handles$ques$3 = function(transform) {
        var self = this;

        return true
      }, $Converter_handles$ques$3.$$arity = 1);
      Opal.defs(self, '$derive_backend_traits', $Converter_derive_backend_traits$4 = function $$derive_backend_traits(backend, basebackend) {
        var $a, self = this, outfilesuffix = nil, filetype = nil;

        
        
        if (basebackend == null) {
          basebackend = nil;
        };
        if ($truthy(backend)) {
        } else {
          return $hash2([], {})
        };
        if ($truthy((outfilesuffix = $$($nesting, 'DEFAULT_EXTENSIONS')['$[]']((basebackend = ($truthy($a = basebackend) ? $a : backend.$sub($$($nesting, 'TrailingDigitsRx'), ""))))))) {
          filetype = outfilesuffix.$slice(1, outfilesuffix.$length())
        } else {
          outfilesuffix = "" + "." + ((filetype = basebackend))
        };
        if (filetype['$==']("html")) {
          return $hash2(["basebackend", "filetype", "htmlsyntax", "outfilesuffix"], {"basebackend": basebackend, "filetype": filetype, "htmlsyntax": "html", "outfilesuffix": outfilesuffix})
        } else {
          return $hash2(["basebackend", "filetype", "outfilesuffix"], {"basebackend": basebackend, "filetype": filetype, "outfilesuffix": outfilesuffix})
        };
      }, $Converter_derive_backend_traits$4.$$arity = -2);
      (function($base, $parent_nesting) {
        var self = $module($base, 'BackendTraits');

        var $nesting = [self].concat($parent_nesting), $BackendTraits_basebackend$5, $BackendTraits_filetype$6, $BackendTraits_htmlsyntax$7, $BackendTraits_outfilesuffix$8, $BackendTraits_supports_templates$9, $BackendTraits_supports_templates$ques$10, $BackendTraits_init_backend_traits$11, $BackendTraits_backend_traits$12, $BackendTraits_derive_backend_traits$13;

        
        
        Opal.def(self, '$basebackend', $BackendTraits_basebackend$5 = function $$basebackend(value) {
          var self = this, $writer = nil;

          
          
          if (value == null) {
            value = nil;
          };
          if ($truthy(value)) {
            
            
            $writer = ["basebackend", value];
            $send(self.$backend_traits(value), '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];;
          } else {
            return self.$backend_traits()['$[]']("basebackend")
          };
        }, $BackendTraits_basebackend$5.$$arity = -1);
        
        Opal.def(self, '$filetype', $BackendTraits_filetype$6 = function $$filetype(value) {
          var self = this, $writer = nil;

          
          
          if (value == null) {
            value = nil;
          };
          if ($truthy(value)) {
            
            
            $writer = ["filetype", value];
            $send(self.$backend_traits(), '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];;
          } else {
            return self.$backend_traits()['$[]']("filetype")
          };
        }, $BackendTraits_filetype$6.$$arity = -1);
        
        Opal.def(self, '$htmlsyntax', $BackendTraits_htmlsyntax$7 = function $$htmlsyntax(value) {
          var self = this, $writer = nil;

          
          
          if (value == null) {
            value = nil;
          };
          if ($truthy(value)) {
            
            
            $writer = ["htmlsyntax", value];
            $send(self.$backend_traits(), '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];;
          } else {
            return self.$backend_traits()['$[]']("htmlsyntax")
          };
        }, $BackendTraits_htmlsyntax$7.$$arity = -1);
        
        Opal.def(self, '$outfilesuffix', $BackendTraits_outfilesuffix$8 = function $$outfilesuffix(value) {
          var self = this, $writer = nil;

          
          
          if (value == null) {
            value = nil;
          };
          if ($truthy(value)) {
            
            
            $writer = ["outfilesuffix", value];
            $send(self.$backend_traits(), '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];;
          } else {
            return self.$backend_traits()['$[]']("outfilesuffix")
          };
        }, $BackendTraits_outfilesuffix$8.$$arity = -1);
        
        Opal.def(self, '$supports_templates', $BackendTraits_supports_templates$9 = function $$supports_templates(value) {
          var self = this, $writer = nil;

          
          
          if (value == null) {
            value = true;
          };
          $writer = ["supports_templates", value];
          $send(self.$backend_traits(), '[]=', Opal.to_a($writer));
          return $writer[$rb_minus($writer["length"], 1)];
        }, $BackendTraits_supports_templates$9.$$arity = -1);
        
        Opal.def(self, '$supports_templates?', $BackendTraits_supports_templates$ques$10 = function() {
          var self = this;

          return self.$backend_traits()['$[]']("supports_templates")
        }, $BackendTraits_supports_templates$ques$10.$$arity = 0);
        
        Opal.def(self, '$init_backend_traits', $BackendTraits_init_backend_traits$11 = function $$init_backend_traits(value) {
          var $a, self = this;

          
          
          if (value == null) {
            value = nil;
          };
          return (self.backend_traits = ($truthy($a = value) ? $a : $hash2([], {})));
        }, $BackendTraits_init_backend_traits$11.$$arity = -1);
        
        Opal.def(self, '$backend_traits', $BackendTraits_backend_traits$12 = function $$backend_traits(basebackend) {
          var $a, self = this;
          if (self.backend_traits == null) self.backend_traits = nil;
          if (self.backend == null) self.backend = nil;

          
          
          if (basebackend == null) {
            basebackend = nil;
          };
          return (self.backend_traits = ($truthy($a = self.backend_traits) ? $a : $$($nesting, 'Converter').$derive_backend_traits(self.backend, basebackend)));
        }, $BackendTraits_backend_traits$12.$$arity = -1);
        Opal.alias(self, "backend_info", "backend_traits");
        Opal.defs(self, '$derive_backend_traits', $BackendTraits_derive_backend_traits$13 = function $$derive_backend_traits(backend, basebackend) {
          var self = this;

          
          
          if (basebackend == null) {
            basebackend = nil;
          };
          return $$($nesting, 'Converter').$derive_backend_traits(backend, basebackend);
        }, $BackendTraits_derive_backend_traits$13.$$arity = -2);
      })($nesting[0], $nesting);
      (function($base, $parent_nesting) {
        var self = $module($base, 'Config');

        var $nesting = [self].concat($parent_nesting), $Config_register_for$14;

        
        Opal.def(self, '$register_for', $Config_register_for$14 = function $$register_for($a) {
          var $post_args, backends, $$15, self = this;

          
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          backends = $post_args;;
          return $send($$($nesting, 'Converter'), 'register', [self].concat(Opal.to_a($send(backends, 'map', [], ($$15 = function(backend){var self = $$15.$$s || this;

          
            
            if (backend == null) {
              backend = nil;
            };
            return backend.$to_s();}, $$15.$$s = self, $$15.$$arity = 1, $$15)))));
        }, $Config_register_for$14.$$arity = -1)
      })($nesting[0], $nesting);
      (function($base, $parent_nesting) {
        var self = $module($base, 'Factory');

        var $nesting = [self].concat($parent_nesting), $Factory_new$16, $Factory_default$17, $Factory_create$18, $Factory_register$19, $Factory_for$21, $Factory_create$22, $Factory_converters$23, $Factory_registry$24;

        
        Opal.defs(self, '$new', $Factory_new$16 = function($a, $b) {
          var $post_args, $kwargs, converters, proxy_default, self = this;

          
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          $kwargs = Opal.extract_kwargs($post_args);
          
          if ($kwargs == null) {
            $kwargs = $hash2([], {});
          } else if (!$kwargs.$$is_hash) {
            throw Opal.ArgumentError.$new('expected kwargs');
          };
          
          if ($post_args.length > 0) {
            converters = $post_args[0];
            $post_args.splice(0, 1);
          }
          if (converters == null) {
            converters = nil;
          };
          
          proxy_default = $kwargs.$$smap["proxy_default"];
          if (proxy_default == null) {
            proxy_default = true
          };
          if ($truthy(proxy_default)) {
            
            return $$($nesting, 'DefaultFactoryProxy').$new(converters);
          } else {
            
            return $$($nesting, 'CustomFactory').$new(converters);
          };
        }, $Factory_new$16.$$arity = -1);
        Opal.defs(self, '$default', $Factory_default$17 = function($a) {
          var $post_args, args, self = this;

          
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          args = $post_args;;
          return $$($nesting, 'Converter');
        }, $Factory_default$17.$$arity = -1);
        Opal.defs(self, '$create', $Factory_create$18 = function $$create(backend, opts) {
          var self = this;

          
          
          if (opts == null) {
            opts = $hash2([], {});
          };
          return self.$default().$create(backend, opts);
        }, $Factory_create$18.$$arity = -2);
        
        Opal.def(self, '$register', $Factory_register$19 = function $$register(converter, $a) {
          var $post_args, backends, $$20, self = this;

          
          
          $post_args = Opal.slice.call(arguments, 1, arguments.length);
          
          backends = $post_args;;
          return $send(backends, 'each', [], ($$20 = function(backend){var self = $$20.$$s || this, $writer = nil;

          
            
            if (backend == null) {
              backend = nil;
            };
            if (backend['$==']("*")) {
              
              
              $writer = [converter];
              $send(self.$registry(), 'default=', Opal.to_a($writer));
              return $writer[$rb_minus($writer["length"], 1)];;
            } else {
              
              
              $writer = [backend, converter];
              $send(self.$registry(), '[]=', Opal.to_a($writer));
              return $writer[$rb_minus($writer["length"], 1)];;
            };}, $$20.$$s = self, $$20.$$arity = 1, $$20));
        }, $Factory_register$19.$$arity = -2);
        
        Opal.def(self, '$for', $Factory_for$21 = function(backend) {
          var self = this;

          return self.$registry()['$[]'](backend)
        }, $Factory_for$21.$$arity = 1);
        
        Opal.def(self, '$create', $Factory_create$22 = function $$create(backend, opts) {
          var $a, $b, self = this, converter = nil, template_dirs = nil, delegate_backend = nil;

          
          
          if (opts == null) {
            opts = $hash2([], {});
          };
          if ($truthy((converter = self.$for(backend)))) {
            
            if ($truthy($$$('::', 'Class')['$==='](converter))) {
              converter = converter.$new(backend, opts)};
            if ($truthy(($truthy($a = ($truthy($b = (template_dirs = opts['$[]']("template_dirs"))) ? $$($nesting, 'BackendTraits')['$==='](converter) : $b)) ? converter['$supports_templates?']() : $a))) {
              return $$($nesting, 'CompositeConverter').$new(backend, $$($nesting, 'TemplateConverter').$new(backend, template_dirs, opts), converter, $hash2(["backend_traits_source"], {"backend_traits_source": converter}))
            } else {
              return converter
            };
          } else if ($truthy((template_dirs = opts['$[]']("template_dirs")))) {
            if ($truthy(($truthy($a = (delegate_backend = opts['$[]']("delegate_backend"))) ? (converter = self.$for(delegate_backend)) : $a))) {
              
              if ($truthy($$$('::', 'Class')['$==='](converter))) {
                converter = converter.$new(delegate_backend, opts)};
              return $$($nesting, 'CompositeConverter').$new(backend, $$($nesting, 'TemplateConverter').$new(backend, template_dirs, opts), converter, $hash2(["backend_traits_source"], {"backend_traits_source": converter}));
            } else {
              return $$($nesting, 'TemplateConverter').$new(backend, template_dirs, opts)
            }
          } else {
            return nil
          };
        }, $Factory_create$22.$$arity = -2);
        
        Opal.def(self, '$converters', $Factory_converters$23 = function $$converters() {
          var self = this;

          return self.$registry().$merge()
        }, $Factory_converters$23.$$arity = 0);
        self.$private();
        
        Opal.def(self, '$registry', $Factory_registry$24 = function $$registry() {
          var self = this;

          return self.$raise($$$('::', 'NotImplementedError'), "" + ($$($nesting, 'Factory')) + " subclass " + (self.$class()) + " must implement the #" + ("registry") + " method")
        }, $Factory_registry$24.$$arity = 0);
      })($nesting[0], $nesting);
      (function($base, $super, $parent_nesting) {
        var self = $klass($base, $super, 'CustomFactory');

        var $nesting = [self].concat($parent_nesting), $CustomFactory_initialize$25, $CustomFactory_unregister_all$26;

        
        self.$include($$($nesting, 'Factory'));
        
        Opal.def(self, '$initialize', $CustomFactory_initialize$25 = function $$initialize(seed_registry) {
          var self = this, $writer = nil;

          
          
          if (seed_registry == null) {
            seed_registry = nil;
          };
          if ($truthy(seed_registry)) {
            
            
            $writer = [seed_registry.$delete("*")];
            $send(seed_registry, 'default=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            return (self.registry = seed_registry);
          } else {
            return (self.registry = $hash2([], {}))
          };
        }, $CustomFactory_initialize$25.$$arity = -1);
        
        Opal.def(self, '$unregister_all', $CustomFactory_unregister_all$26 = function $$unregister_all() {
          var self = this, $writer = nil;

          
          $writer = [nil];
          $send(self.$registry().$clear(), 'default=', Opal.to_a($writer));
          return $writer[$rb_minus($writer["length"], 1)];
        }, $CustomFactory_unregister_all$26.$$arity = 0);
        self.$private();
        return self.$attr_reader("registry");
      })($nesting[0], null, $nesting);
      (function($base, $parent_nesting) {
        var self = $module($base, 'DefaultFactory');

        var $nesting = [self].concat($parent_nesting), $DefaultFactory_registry$27;

        
        self.$include($$($nesting, 'Factory'));
        self.$private();
        (Opal.class_variable_set($nesting[0], '@@registry', $hash2([], {})));
        
        Opal.def(self, '$registry', $DefaultFactory_registry$27 = function $$registry() {
          var $a, self = this;

          return (($a = $nesting[0].$$cvars['@@registry']) == null ? nil : $a)
        }, $DefaultFactory_registry$27.$$arity = 0);
        if ($$($nesting, 'RUBY_ENGINE')['$==']("opal")) {
        } else {
          nil
        };
      })($nesting[0], $nesting);
      (function($base, $super, $parent_nesting) {
        var self = $klass($base, $super, 'DefaultFactoryProxy');

        var $nesting = [self].concat($parent_nesting);

        
        self.$include($$($nesting, 'DefaultFactory'));
        if ($$($nesting, 'RUBY_ENGINE')['$==']("opal")) {
          return nil
        } else {
          return nil
        };
      })($nesting[0], $$($nesting, 'CustomFactory'), $nesting);
      Opal.defs(self, '$included', $Converter_included$28 = function $$included(into) {
        var self = this;

        
        into.$send("include", $$($nesting, 'BackendTraits'));
        return into.$extend($$($nesting, 'Config'));
      }, $Converter_included$28.$$arity = 1);
      self.$private_class_method("included");
      (function($base, $super, $parent_nesting) {
        var self = $klass($base, $super, 'Base');

        var $nesting = [self].concat($parent_nesting), $Base_convert$29, $Base_handles$ques$30, $Base_content_only$31, $Base_skip$32;

        self.$$prototype.backend = nil;
        
        self.$include($$($nesting, 'Logging'));
        self.$include($$($nesting, 'Converter'));
        
        Opal.def(self, '$convert', $Base_convert$29 = function $$convert(node, transform, opts) {
          var $a, $b, self = this, ex = nil;
          if ($gvars["!"] == null) $gvars["!"] = nil;

          
          
          if (transform == null) {
            transform = node.$node_name();
          };
          
          if (opts == null) {
            opts = nil;
          };
          try {
            if ($truthy(opts)) {
              
              return self.$send($rb_plus("convert_", transform), node, opts);
            } else {
              
              return self.$send($rb_plus("convert_", transform), node);
            }
          } catch ($err) {
            if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
              try {
                
                if ($truthy(($truthy($a = ($truthy($b = $$$('::', 'NoMethodError')['$===']((ex = $gvars["!"]))) ? ex.$receiver()['$=='](self) : $b)) ? ex.$name().$to_s()['$=='](transform) : $a))) {
                } else {
                  self.$raise()
                };
                self.$logger().$warn("" + "missing convert handler for " + (ex.$name()) + " node in " + (self.backend) + " backend (" + (self.$class()) + ")");
                return nil;
              } finally { Opal.pop_exception() }
            } else { throw $err; }
          };
        }, $Base_convert$29.$$arity = -2);
        
        Opal.def(self, '$handles?', $Base_handles$ques$30 = function(transform) {
          var self = this;

          return self['$respond_to?']("" + "convert_" + (transform))
        }, $Base_handles$ques$30.$$arity = 1);
        
        Opal.def(self, '$content_only', $Base_content_only$31 = function $$content_only(node) {
          var self = this;

          return node.$content()
        }, $Base_content_only$31.$$arity = 1);
        return (Opal.def(self, '$skip', $Base_skip$32 = function $$skip(node) {
          var self = this;

          return nil
        }, $Base_skip$32.$$arity = 1), nil) && 'skip';
      })($nesting[0], null, $nesting);
      self.$extend($$($nesting, 'DefaultFactory'));
    })($nesting[0], $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/document"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_ge(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs >= rhs : lhs['$>='](rhs);
  }
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $send = Opal.send, $truthy = Opal.truthy, $hash2 = Opal.hash2, $hash = Opal.hash, $gvars = Opal.gvars;

  Opal.add_stubs(['$new', '$attr_reader', '$nil?', '$<<', '$[]', '$[]=', '$-', '$include?', '$strip', '$squeeze', '$gsub', '$empty?', '$!', '$rpartition', '$attr_accessor', '$delete', '$base_dir', '$options', '$merge', '$catalog', '$instance_variable_get', '$attributes', '$safe', '$compat_mode', '$outfilesuffix', '$sourcemap', '$path_resolver', '$converter', '$extensions', '$syntax_highlighter', '$each', '$end_with?', '$start_with?', '$slice', '$length', '$chop', '$==', '$downcase', '$===', '$extname', '$value_for_name', '$key?', '$freeze', '$attribute_undefined', '$attribute_missing', '$update', '$&', '$keys', '$name_for_value', '$expand_path', '$pwd', '$to_s', '$>=', '$+', '$abs', '$to_i', '$delete_if', '$update_doctype_attributes', '$cursor', '$parse', '$restore_attributes', '$update_backend_attributes', '$fetch', '$fill_datetime_attributes', '$activate', '$groups', '$create', '$to_proc', '$preprocessors?', '$preprocessors', '$process_method', '$tree_processors?', '$tree_processors', '$!=', '$counter', '$attribute_locked?', '$nil_or_empty?', '$nextval', '$value', '$save_to', '$register', '$tap', '$xreftext', '$>', '$source', '$source_lines', '$doctitle', '$sectname=', '$title=', '$first_section', '$title', '$reftext', '$<', '$find', '$context', '$assign_numeral', '$clear_playback_attributes', '$save_attributes', '$name', '$negate', '$rewind', '$replace', '$apply_attribute_value_subs', '$delete?', '$start', '$doctype', '$content_model', '$warn', '$logger', '$content', '$convert', '$postprocessors?', '$postprocessors', '$record', '$write', '$respond_to?', '$chomp', '$class', '$write_alternate_pages', '$map', '$split', '$resolve_docinfo_subs', '$normalize_system_path', '$read_asset', '$apply_subs', '$docinfo_processors?', '$join', '$concat', '$compact', '$docinfo_processors', '$object_id', '$inspect', '$size', '$private', '$=~', '$resolve_pass_subs', '$apply_header_subs', '$limit_bytesize', '$bytesize', '$valid_encoding?', '$byteslice', '$resolve_subs', '$utc', '$at', '$Integer', '$now', '$index', '$strftime', '$year', '$utc_offset', '$partition', '$create_converter', '$basebackend', '$filetype', '$htmlsyntax', '$derive_backend_traits', '$raise']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'Document');

      var $nesting = [self].concat($parent_nesting), $Document$1, $Document_initialize$8, $Document_parse$11, $Document_parsed$ques$14, $Document_counter$15, $Document_increment_and_store_counter$16, $Document_register$17, $Document_resolve_id$18, $Document_sections$ques$22, $Document_footnotes$ques$23, $Document_footnotes$24, $Document_callouts$25, $Document_nested$ques$26, $Document_embedded$ques$27, $Document_extensions$ques$28, $Document_source$29, $Document_source_lines$30, $Document_basebackend$ques$31, $Document_title$32, $Document_title$eq$33, $Document_doctitle$34, $Document_xreftext$35, $Document_author$36, $Document_authors$37, $Document_revdate$38, $Document_notitle$39, $Document_noheader$40, $Document_nofooter$41, $Document_first_section$42, $Document_header$ques$44, $Document_$lt$lt$45, $Document_finalize_header$46, $Document_playback_attributes$47, $Document_restore_attributes$49, $Document_set_attribute$50, $Document_delete_attribute$51, $Document_attribute_locked$ques$52, $Document_set_header_attribute$53, $Document_convert$54, $Document_write$56, $Document_content$57, $Document_docinfo$58, $Document_docinfo_processors$ques$61, $Document_to_s$62, $Document_apply_attribute_value_subs$63, $Document_limit_bytesize$64, $Document_resolve_docinfo_subs$65, $Document_create_converter$66, $Document_clear_playback_attributes$67, $Document_save_attributes$68, $Document_fill_datetime_attributes$70, $Document_update_backend_attributes$71, $Document_update_doctype_attributes$72;

      self.$$prototype.attributes = self.$$prototype.safe = self.$$prototype.sourcemap = self.$$prototype.reader = self.$$prototype.base_dir = self.$$prototype.parsed = self.$$prototype.parent_document = self.$$prototype.extensions = self.$$prototype.options = self.$$prototype.counters = self.$$prototype.catalog = self.$$prototype.reftexts = self.$$prototype.next_section_index = self.$$prototype.header = self.$$prototype.blocks = self.$$prototype.header_attributes = self.$$prototype.attributes_modified = self.$$prototype.backend = self.$$prototype.attribute_overrides = self.$$prototype.timings = self.$$prototype.converter = self.$$prototype.outfilesuffix = self.$$prototype.docinfo_processor_extensions = self.$$prototype.document = self.$$prototype.max_attribute_value_size = self.$$prototype.id = self.$$prototype.doctype = nil;
      
      Opal.const_set($nesting[0], 'ImageReference', $send($$$('::', 'Struct'), 'new', ["target", "imagesdir"], ($Document$1 = function(){var self = $Document$1.$$s || this;

      return Opal.alias(self, "to_s", "target")}, $Document$1.$$s = self, $Document$1.$$arity = 0, $Document$1)));
      Opal.const_set($nesting[0], 'Footnote', $$$('::', 'Struct').$new("index", "id", "text"));
      (function($base, $super, $parent_nesting) {
        var self = $klass($base, $super, 'AttributeEntry');

        var $nesting = [self].concat($parent_nesting), $AttributeEntry_initialize$2, $AttributeEntry_save_to$3;

        
        self.$attr_reader("name", "value", "negate");
        
        Opal.def(self, '$initialize', $AttributeEntry_initialize$2 = function $$initialize(name, value, negate) {
          var self = this;

          
          
          if (negate == null) {
            negate = nil;
          };
          self.name = name;
          self.value = value;
          return (self.negate = (function() {if ($truthy(negate['$nil?']())) {
            return value['$nil?']()
          } else {
            return negate
          }; return nil; })());
        }, $AttributeEntry_initialize$2.$$arity = -3);
        return (Opal.def(self, '$save_to', $AttributeEntry_save_to$3 = function $$save_to(block_attributes) {
          var $a, self = this, $writer = nil;

          
          ($truthy($a = block_attributes['$[]']("attribute_entries")) ? $a : (($writer = ["attribute_entries", []]), $send(block_attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))['$<<'](self);
          return self;
        }, $AttributeEntry_save_to$3.$$arity = 1), nil) && 'save_to';
      })($nesting[0], null, $nesting);
      (function($base, $super, $parent_nesting) {
        var self = $klass($base, $super, 'Title');

        var $nesting = [self].concat($parent_nesting), $Title_initialize$4, $Title_sanitized$ques$5, $Title_subtitle$ques$6, $Title_to_s$7;

        self.$$prototype.sanitized = self.$$prototype.subtitle = self.$$prototype.combined = nil;
        
        self.$attr_reader("main");
        Opal.alias(self, "title", "main");
        self.$attr_reader("subtitle");
        self.$attr_reader("combined");
        
        Opal.def(self, '$initialize', $Title_initialize$4 = function $$initialize(val, opts) {
          var $a, $b, self = this, sep = nil, _ = nil;

          
          
          if (opts == null) {
            opts = $hash2([], {});
          };
          if ($truthy(($truthy($a = (self.sanitized = opts['$[]']("sanitize"))) ? val['$include?']("<") : $a))) {
            val = val.$gsub($$($nesting, 'XmlSanitizeRx'), "").$squeeze(" ").$strip()};
          if ($truthy(($truthy($a = (sep = ($truthy($b = opts['$[]']("separator")) ? $b : ":"))['$empty?']()) ? $a : val['$include?']((sep = "" + (sep) + " "))['$!']()))) {
            
            self.main = val;
            self.subtitle = nil;
          } else {
            $b = val.$rpartition(sep), $a = Opal.to_ary($b), (self.main = ($a[0] == null ? nil : $a[0])), (_ = ($a[1] == null ? nil : $a[1])), (self.subtitle = ($a[2] == null ? nil : $a[2])), $b
          };
          return (self.combined = val);
        }, $Title_initialize$4.$$arity = -2);
        
        Opal.def(self, '$sanitized?', $Title_sanitized$ques$5 = function() {
          var self = this;

          return self.sanitized
        }, $Title_sanitized$ques$5.$$arity = 0);
        
        Opal.def(self, '$subtitle?', $Title_subtitle$ques$6 = function() {
          var self = this;

          if ($truthy(self.subtitle)) {
            return true
          } else {
            return false
          }
        }, $Title_subtitle$ques$6.$$arity = 0);
        return (Opal.def(self, '$to_s', $Title_to_s$7 = function $$to_s() {
          var self = this;

          return self.combined
        }, $Title_to_s$7.$$arity = 0), nil) && 'to_s';
      })($nesting[0], null, $nesting);
      Opal.const_set($nesting[0], 'Author', $$$('::', 'Struct').$new("name", "firstname", "middlename", "lastname", "initials", "email"));
      self.$attr_reader("safe");
      self.$attr_reader("compat_mode");
      self.$attr_reader("backend");
      self.$attr_reader("doctype");
      self.$attr_accessor("sourcemap");
      self.$attr_reader("catalog");
      Opal.alias(self, "references", "catalog");
      self.$attr_reader("counters");
      self.$attr_reader("header");
      self.$attr_reader("base_dir");
      self.$attr_reader("options");
      self.$attr_reader("outfilesuffix");
      self.$attr_reader("parent_document");
      self.$attr_reader("reader");
      self.$attr_reader("path_resolver");
      self.$attr_reader("converter");
      self.$attr_reader("syntax_highlighter");
      self.$attr_reader("extensions");
      
      Opal.def(self, '$initialize', $Document_initialize$8 = function $$initialize(data, options) {
        var $a, $$9, $b, $c, $$10, $d, $e, $f, $g, $iter = $Document_initialize$8.$$p, $yield = $iter || nil, self = this, parent_doc = nil, $writer = nil, attr_overrides = nil, parent_doctype = nil, initialize_extensions = nil, to_file = nil, safe_mode = nil, input_mtime = nil, standalone = nil, attrs = nil, safe_mode_name = nil, base_dir_val = nil, backend_val = nil, doctype_val = nil, size = nil, initial_backend = nil, ext_registry = nil, ext_block = nil;

        if ($iter) $Document_initialize$8.$$p = null;
        
        
        if (data == null) {
          data = nil;
        };
        
        if (options == null) {
          options = $hash2([], {});
        };
        $send(self, Opal.find_super_dispatcher(self, 'initialize', $Document_initialize$8, false), [self, "document"], null);
        if ($truthy((parent_doc = options.$delete("parent")))) {
          
          self.parent_document = parent_doc;
          ($truthy($a = options['$[]']("base_dir")) ? $a : (($writer = ["base_dir", parent_doc.$base_dir()]), $send(options, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
          if ($truthy(parent_doc.$options()['$[]']("catalog_assets"))) {
            
            $writer = ["catalog_assets", true];
            $send(options, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          self.catalog = parent_doc.$catalog().$merge($hash2(["footnotes"], {"footnotes": []}));
          self.attribute_overrides = (attr_overrides = parent_doc.$instance_variable_get("@attribute_overrides").$merge(parent_doc.$attributes()));
          attr_overrides.$delete("compat-mode");
          parent_doctype = attr_overrides.$delete("doctype");
          attr_overrides.$delete("notitle");
          attr_overrides.$delete("showtitle");
          attr_overrides.$delete("toc");
          
          $writer = ["toc-placement", ($truthy($a = attr_overrides.$delete("toc-placement")) ? $a : "auto")];
          $send(self.attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          attr_overrides.$delete("toc-position");
          self.safe = parent_doc.$safe();
          if ($truthy((self.compat_mode = parent_doc.$compat_mode()))) {
            
            $writer = ["compat-mode", ""];
            $send(self.attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          self.outfilesuffix = parent_doc.$outfilesuffix();
          self.sourcemap = parent_doc.$sourcemap();
          self.timings = nil;
          self.path_resolver = parent_doc.$path_resolver();
          self.converter = parent_doc.$converter();
          initialize_extensions = nil;
          self.extensions = parent_doc.$extensions();
          self.syntax_highlighter = parent_doc.$syntax_highlighter();
        } else {
          
          self.parent_document = nil;
          self.catalog = $hash2(["ids", "refs", "footnotes", "links", "images", "callouts", "includes"], {"ids": $hash2([], {}), "refs": $hash2([], {}), "footnotes": [], "links": [], "images": [], "callouts": $$($nesting, 'Callouts').$new(), "includes": $hash2([], {})});
          self.attribute_overrides = (attr_overrides = $hash2([], {}));
          $send(($truthy($a = options['$[]']("attributes")) ? $a : $hash2([], {})), 'each', [], ($$9 = function(key, val){var self = $$9.$$s || this, $b;

          
            
            if (key == null) {
              key = nil;
            };
            
            if (val == null) {
              val = nil;
            };
            if ($truthy(key['$end_with?']("@"))) {
              if ($truthy(key['$start_with?']("!"))) {
                $b = [key.$slice(1, $rb_minus(key.$length(), 2)), false], (key = $b[0]), (val = $b[1]), $b
              } else if ($truthy(key['$end_with?']("!@"))) {
                $b = [key.$slice(0, $rb_minus(key.$length(), 2)), false], (key = $b[0]), (val = $b[1]), $b
              } else {
                $b = [key.$chop(), "" + (val) + "@"], (key = $b[0]), (val = $b[1]), $b
              }
            } else if ($truthy(key['$start_with?']("!"))) {
              $b = [key.$slice(1, key.$length()), (function() {if (val['$==']("@")) {
                return false
              } else {
                return nil
              }; return nil; })()], (key = $b[0]), (val = $b[1]), $b
            } else if ($truthy(key['$end_with?']("!"))) {
              $b = [key.$chop(), (function() {if (val['$==']("@")) {
                return false
              } else {
                return nil
              }; return nil; })()], (key = $b[0]), (val = $b[1]), $b};
            
            $writer = [key.$downcase(), val];
            $send(attr_overrides, '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];;}, $$9.$$s = self, $$9.$$arity = 2, $$9));
          if ($truthy($$$('::', 'String')['$===']((to_file = options['$[]']("to_file"))))) {
            
            $writer = ["outfilesuffix", $$($nesting, 'Helpers').$extname(to_file)];
            $send(attr_overrides, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          if ($truthy((safe_mode = options['$[]']("safe"))['$!']())) {
            self.safe = $$$($$($nesting, 'SafeMode'), 'SECURE')
          } else if ($truthy($$$('::', 'Integer')['$==='](safe_mode))) {
            self.safe = safe_mode
          } else {
            self.safe = (function() { try {
              
              return $$($nesting, 'SafeMode').$value_for_name(safe_mode);
            } catch ($err) {
              if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
                try {
                  return $$$($$($nesting, 'SafeMode'), 'SECURE')
                } finally { Opal.pop_exception() }
              } else { throw $err; }
            }})()
          };
          input_mtime = options.$delete("input_mtime");
          self.compat_mode = attr_overrides['$key?']("compat-mode");
          self.sourcemap = options['$[]']("sourcemap");
          self.timings = options.$delete("timings");
          self.path_resolver = $$($nesting, 'PathResolver').$new();
          initialize_extensions = (function() {if ($truthy(($truthy($a = (($c = $$$('::', 'Asciidoctor', 'skip_raise')) && ($b = $$$($c, 'Extensions', 'skip_raise')) ? 'constant' : nil)) ? $a : options['$key?']("extensions")))) {
            return $$$($$$('::', 'Asciidoctor'), 'Extensions')
          } else {
            return nil
          }; return nil; })();
          self.extensions = nil;
          if ($truthy(($truthy($a = options['$key?']("header_footer")) ? options['$key?']("standalone")['$!']() : $a))) {
            
            $writer = ["standalone", options['$[]']("header_footer")];
            $send(options, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
        };
        self.parsed = (self.reftexts = (self.header = (self.header_attributes = nil)));
        self.counters = $hash2([], {});
        self.attributes_modified = $$$('::', 'Set').$new();
        self.docinfo_processor_extensions = $hash2([], {});
        standalone = options['$[]']("standalone");
        (self.options = options).$freeze();
        attrs = self.attributes;
        if ($truthy(parent_doc)) {
        } else {
          
          
          $writer = ["attribute-undefined", $$($nesting, 'Compliance').$attribute_undefined()];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["attribute-missing", $$($nesting, 'Compliance').$attribute_missing()];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          attrs.$update($$($nesting, 'DEFAULT_ATTRIBUTES'));
        };
        if ($truthy(standalone)) {
          
          
          $writer = ["embedded", nil];
          $send(attr_overrides, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["copycss", ""];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["iconfont-remote", ""];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["stylesheet", ""];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["webfonts", ""];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
        } else {
          
          
          $writer = ["embedded", ""];
          $send(attr_overrides, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          if ($truthy(($truthy($a = attr_overrides['$key?']("showtitle")) ? attr_overrides.$keys()['$&'](["notitle", "showtitle"])['$[]'](-1)['$==']("showtitle") : $a))) {
            
            $writer = ["notitle", $hash(nil, "", false, "@", "@", false)['$[]'](attr_overrides['$[]']("showtitle"))];
            $send(attr_overrides, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          } else if ($truthy(attr_overrides['$key?']("notitle"))) {
            
            $writer = ["showtitle", $hash(nil, "", false, "@", "@", false)['$[]'](attr_overrides['$[]']("notitle"))];
            $send(attr_overrides, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          } else {
            
            $writer = ["notitle", ""];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          };
        };
        
        $writer = ["asciidoctor", ""];
        $send(attr_overrides, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["asciidoctor-version", $$$($$$('::', 'Asciidoctor'), 'VERSION')];
        $send(attr_overrides, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["safe-mode-name", (safe_mode_name = $$($nesting, 'SafeMode').$name_for_value(self.safe))];
        $send(attr_overrides, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["" + "safe-mode-" + (safe_mode_name), ""];
        $send(attr_overrides, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["safe-mode-level", self.safe];
        $send(attr_overrides, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        ($truthy($a = attr_overrides['$[]']("max-include-depth")) ? $a : (($writer = ["max-include-depth", 64]), $send(attr_overrides, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        ($truthy($a = attr_overrides['$[]']("allow-uri-read")) ? $a : (($writer = ["allow-uri-read", nil]), $send(attr_overrides, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        if ($truthy(attr_overrides['$key?']("numbered"))) {
          
          $writer = ["sectnums", attr_overrides.$delete("numbered")];
          $send(attr_overrides, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        if ($truthy(attr_overrides['$key?']("hardbreaks"))) {
          
          $writer = ["hardbreaks-option", attr_overrides.$delete("hardbreaks")];
          $send(attr_overrides, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        if ($truthy((base_dir_val = options['$[]']("base_dir")))) {
          self.base_dir = (($writer = ["docdir", $$$('::', 'File').$expand_path(base_dir_val)]), $send(attr_overrides, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])
        } else if ($truthy(attr_overrides['$[]']("docdir"))) {
          self.base_dir = attr_overrides['$[]']("docdir")
        } else {
          self.base_dir = (($writer = ["docdir", $$$('::', 'Dir').$pwd()]), $send(attr_overrides, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])
        };
        if ($truthy((backend_val = options['$[]']("backend")))) {
          
          $writer = ["backend", backend_val.$to_s()];
          $send(attr_overrides, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        if ($truthy((doctype_val = options['$[]']("doctype")))) {
          
          $writer = ["doctype", doctype_val.$to_s()];
          $send(attr_overrides, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        if ($truthy($rb_ge(self.safe, $$$($$($nesting, 'SafeMode'), 'SERVER')))) {
          
          ($truthy($a = attr_overrides['$[]']("copycss")) ? $a : (($writer = ["copycss", nil]), $send(attr_overrides, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
          ($truthy($a = attr_overrides['$[]']("source-highlighter")) ? $a : (($writer = ["source-highlighter", nil]), $send(attr_overrides, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
          ($truthy($a = attr_overrides['$[]']("backend")) ? $a : (($writer = ["backend", $$($nesting, 'DEFAULT_BACKEND')]), $send(attr_overrides, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
          if ($truthy(($truthy($a = parent_doc['$!']()) ? attr_overrides['$key?']("docfile") : $a))) {
            
            $writer = ["docfile", attr_overrides['$[]']("docfile")['$[]'](Opal.Range.$new($rb_plus(attr_overrides['$[]']("docdir").$length(), 1), -1, false))];
            $send(attr_overrides, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          
          $writer = ["docdir", ""];
          $send(attr_overrides, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          ($truthy($a = attr_overrides['$[]']("user-home")) ? $a : (($writer = ["user-home", "."]), $send(attr_overrides, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
          if ($truthy($rb_ge(self.safe, $$$($$($nesting, 'SafeMode'), 'SECURE')))) {
            
            if ($truthy(attr_overrides['$key?']("max-attribute-value-size"))) {
            } else {
              
              $writer = ["max-attribute-value-size", 4096];
              $send(attr_overrides, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            };
            if ($truthy(attr_overrides['$key?']("linkcss"))) {
            } else {
              
              $writer = ["linkcss", ""];
              $send(attr_overrides, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            };
            ($truthy($a = attr_overrides['$[]']("icons")) ? $a : (($writer = ["icons", nil]), $send(attr_overrides, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));};
        } else {
          ($truthy($a = attr_overrides['$[]']("user-home")) ? $a : (($writer = ["user-home", $$($nesting, 'USER_HOME')]), $send(attr_overrides, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))
        };
        self.max_attribute_value_size = (function() {if ($truthy((size = ($truthy($a = attr_overrides['$[]']("max-attribute-value-size")) ? $a : (($writer = ["max-attribute-value-size", nil]), $send(attr_overrides, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))))) {
          return size.$to_i().$abs()
        } else {
          return nil
        }; return nil; })();
        $send(attr_overrides, 'delete_if', [], ($$10 = function(key, val){var self = $$10.$$s || this, $d, verdict = nil;

        
          
          if (key == null) {
            key = nil;
          };
          
          if (val == null) {
            val = nil;
          };
          if ($truthy(val)) {
            
            if ($truthy(($truthy($d = $$$('::', 'String')['$==='](val)) ? val['$end_with?']("@") : $d))) {
              $d = [val.$chop(), true], (val = $d[0]), (verdict = $d[1]), $d};
            
            $writer = [key, val];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
          } else {
            
            attrs.$delete(key);
            verdict = val['$=='](false);
          };
          return verdict;}, $$10.$$s = self, $$10.$$arity = 2, $$10));
        if ($truthy(parent_doc)) {
          
          self.backend = attrs['$[]']("backend");
          if ((self.doctype = (($writer = ["doctype", parent_doctype]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))['$==']($$($nesting, 'DEFAULT_DOCTYPE'))) {
          } else {
            self.$update_doctype_attributes($$($nesting, 'DEFAULT_DOCTYPE'))
          };
          self.reader = $$($nesting, 'Reader').$new(data, options['$[]']("cursor"));
          if ($truthy(self.sourcemap)) {
            self.source_location = self.reader.$cursor()};
          $$($nesting, 'Parser').$parse(self.reader, self);
          self.$restore_attributes();
          return (self.parsed = true);
        } else {
          
          self.backend = nil;
          if ((initial_backend = ($truthy($a = attrs['$[]']("backend")) ? $a : $$($nesting, 'DEFAULT_BACKEND')))['$==']("manpage")) {
            self.doctype = (($writer = ["doctype", (($writer = ["doctype", "manpage"]), $send(attr_overrides, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])
          } else {
            self.doctype = ($truthy($a = attrs['$[]']("doctype")) ? $a : (($writer = ["doctype", $$($nesting, 'DEFAULT_DOCTYPE')]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))
          };
          self.$update_backend_attributes(initial_backend, true);
          ($truthy($a = attrs['$[]']("stylesdir")) ? $a : (($writer = ["stylesdir", "."]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
          ($truthy($a = attrs['$[]']("iconsdir")) ? $a : (($writer = ["iconsdir", "" + (attrs.$fetch("imagesdir", "./images")) + "/icons"]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
          self.$fill_datetime_attributes(attrs, input_mtime);
          if ($truthy(initialize_extensions)) {
            if ($truthy((ext_registry = options['$[]']("extension_registry")))) {
              if ($truthy(($truthy($a = $$$($$($nesting, 'Extensions'), 'Registry')['$==='](ext_registry)) ? $a : ($truthy($d = (($g = $$$('::', 'AsciidoctorJ', 'skip_raise')) && ($f = $$$($g, 'Extensions', 'skip_raise')) && ($e = $$$($f, 'ExtensionRegistry', 'skip_raise')) ? 'constant' : nil)) ? $$$($$$($$$('::', 'AsciidoctorJ'), 'Extensions'), 'ExtensionRegistry')['$==='](ext_registry) : $d)))) {
                self.extensions = ext_registry.$activate(self)}
            } else if ($truthy((ext_block = options['$[]']("extensions"))['$nil?']())) {
              if ($truthy($$($nesting, 'Extensions').$groups()['$empty?']())) {
              } else {
                self.extensions = $$$($$($nesting, 'Extensions'), 'Registry').$new().$activate(self)
              }
            } else if ($truthy($$$('::', 'Proc')['$==='](ext_block))) {
              self.extensions = $send($$($nesting, 'Extensions'), 'create', [], ext_block.$to_proc()).$activate(self)}};
          self.reader = $$($nesting, 'PreprocessorReader').$new(self, data, $$$($$($nesting, 'Reader'), 'Cursor').$new(attrs['$[]']("docfile"), self.base_dir), $hash2(["normalize"], {"normalize": true}));
          if ($truthy(self.sourcemap)) {
            return (self.source_location = self.reader.$cursor())
          } else {
            return nil
          };
        };
      }, $Document_initialize$8.$$arity = -1);
      
      Opal.def(self, '$parse', $Document_parse$11 = function $$parse(data) {
        var $a, $$12, $$13, self = this, doc = nil, exts = nil;

        
        
        if (data == null) {
          data = nil;
        };
        if ($truthy(self.parsed)) {
          return self
        } else {
          
          doc = self;
          if ($truthy(data)) {
            
            self.reader = $$($nesting, 'PreprocessorReader').$new(doc, data, $$$($$($nesting, 'Reader'), 'Cursor').$new(self.attributes['$[]']("docfile"), self.base_dir), $hash2(["normalize"], {"normalize": true}));
            if ($truthy(self.sourcemap)) {
              self.source_location = self.reader.$cursor()};};
          if ($truthy(($truthy($a = (exts = (function() {if ($truthy(self.parent_document)) {
            return nil
          } else {
            return self.extensions
          }; return nil; })())) ? exts['$preprocessors?']() : $a))) {
            $send(exts.$preprocessors(), 'each', [], ($$12 = function(ext){var self = $$12.$$s || this, $b;
              if (self.reader == null) self.reader = nil;

            
              
              if (ext == null) {
                ext = nil;
              };
              return (self.reader = ($truthy($b = ext.$process_method()['$[]'](doc, self.reader)) ? $b : self.reader));}, $$12.$$s = self, $$12.$$arity = 1, $$12))};
          $$($nesting, 'Parser').$parse(self.reader, doc, $hash2(["header_only"], {"header_only": self.options['$[]']("parse_header_only")}));
          self.$restore_attributes();
          if ($truthy(($truthy($a = exts) ? exts['$tree_processors?']() : $a))) {
            $send(exts.$tree_processors(), 'each', [], ($$13 = function(ext){var self = $$13.$$s || this, $b, $c, result = nil;

            
              
              if (ext == null) {
                ext = nil;
              };
              if ($truthy(($truthy($b = ($truthy($c = (result = ext.$process_method()['$[]'](doc))) ? $$($nesting, 'Document')['$==='](result) : $c)) ? result['$!='](doc) : $b))) {
                return (doc = result)
              } else {
                return nil
              };}, $$13.$$s = self, $$13.$$arity = 1, $$13))};
          self.parsed = true;
          return doc;
        };
      }, $Document_parse$11.$$arity = -1);
      
      Opal.def(self, '$parsed?', $Document_parsed$ques$14 = function() {
        var self = this;

        return self.parsed
      }, $Document_parsed$ques$14.$$arity = 0);
      
      Opal.def(self, '$counter', $Document_counter$15 = function $$counter(name, seed) {
        var $a, $b, self = this, locked = nil, curr_val = nil, next_val = nil, $writer = nil;

        
        
        if (seed == null) {
          seed = nil;
        };
        if ($truthy(self.parent_document)) {
          return self.parent_document.$counter(name, seed)};
        if ($truthy(($truthy($a = ($truthy($b = (locked = self['$attribute_locked?'](name))) ? (curr_val = self.counters['$[]'](name)) : $b)) ? $a : (curr_val = self.attributes['$[]'](name))['$nil_or_empty?']()['$!']()))) {
          next_val = (($writer = [name, $$($nesting, 'Helpers').$nextval(curr_val)]), $send(self.counters, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])
        } else if ($truthy(seed)) {
          next_val = (($writer = [name, (function() {if (seed['$=='](seed.$to_i().$to_s())) {
            return seed.$to_i()
          } else {
            return seed
          }; return nil; })()]), $send(self.counters, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])
        } else {
          next_val = (($writer = [name, 1]), $send(self.counters, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])
        };
        if ($truthy(locked)) {
        } else {
          
          $writer = [name, next_val];
          $send(self.attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];
        };
        return next_val;
      }, $Document_counter$15.$$arity = -2);
      
      Opal.def(self, '$increment_and_store_counter', $Document_increment_and_store_counter$16 = function $$increment_and_store_counter(counter_name, block) {
        var self = this;

        return $$($nesting, 'AttributeEntry').$new(counter_name, self.$counter(counter_name)).$save_to(block.$attributes()).$value()
      }, $Document_increment_and_store_counter$16.$$arity = 2);
      Opal.alias(self, "counter_increment", "increment_and_store_counter");
      
      Opal.def(self, '$register', $Document_register$17 = function $$register(type, value) {
        var $a, self = this, $case = nil, id = nil, $logical_op_recvr_tmp_1 = nil, $writer = nil, ref = nil;

        return (function() {$case = type;
        if ("ids"['$===']($case)) {return self.$register("refs", [(id = value['$[]'](0)), $$($nesting, 'Inline').$new(self, "anchor", value['$[]'](1), $hash2(["type", "id"], {"type": "ref", "id": id}))])}
        else if ("refs"['$===']($case)) {
        
        $logical_op_recvr_tmp_1 = self.catalog['$[]']("refs");
        ($truthy($a = $logical_op_recvr_tmp_1['$[]'](value['$[]'](0))) ? $a : (($writer = [value['$[]'](0), (ref = value['$[]'](1))]), $send($logical_op_recvr_tmp_1, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));;
        return ref;}
        else if ("footnotes"['$===']($case)) {return self.catalog['$[]'](type)['$<<'](value)}
        else {if ($truthy(self.options['$[]']("catalog_assets"))) {
          return self.catalog['$[]'](type)['$<<']((function() {if (type['$==']("images")) {
            
            return $$($nesting, 'ImageReference').$new(value, self.attributes['$[]']("imagesdir"));
          } else {
            return value
          }; return nil; })())
        } else {
          return nil
        }}})()
      }, $Document_register$17.$$arity = 2);
      
      Opal.def(self, '$resolve_id', $Document_resolve_id$18 = function $$resolve_id(text) {
        var $$19, $$21, self = this, resolved_id = nil, accum = nil;

        if ($truthy(self.reftexts)) {
          return self.reftexts['$[]'](text)
        } else if ($truthy(self.parsed)) {
          return $send((self.reftexts = $hash2([], {})), 'tap', [], ($$19 = function(accum){var self = $$19.$$s || this, $$20;
            if (self.catalog == null) self.catalog = nil;

          
            
            if (accum == null) {
              accum = nil;
            };
            return $send(self.catalog['$[]']("refs"), 'each', [], ($$20 = function(id, ref){var self = $$20.$$s || this, $a, $writer = nil;

            
              
              if (id == null) {
                id = nil;
              };
              
              if (ref == null) {
                ref = nil;
              };
              return ($truthy($a = accum['$[]'](ref.$xreftext())) ? $a : (($writer = [ref.$xreftext(), id]), $send(accum, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));}, $$20.$$s = self, $$20.$$arity = 2, $$20));}, $$19.$$s = self, $$19.$$arity = 1, $$19))['$[]'](text)
        } else {
          
          resolved_id = nil;
          self.reftexts = (accum = $hash2([], {}));
          (function(){var $brk = Opal.new_brk(); try {return $send(self.catalog['$[]']("refs"), 'each', [], ($$21 = function(id, ref){var self = $$21.$$s || this, $a, xreftext = nil, $writer = nil;

          
            
            if (id == null) {
              id = nil;
            };
            
            if (ref == null) {
              ref = nil;
            };
            if ((xreftext = ref.$xreftext())['$=='](text)) {
              
              resolved_id = id;
              
              Opal.brk(nil, $brk);};
            return ($truthy($a = accum['$[]'](xreftext)) ? $a : (($writer = [xreftext, id]), $send(accum, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));}, $$21.$$s = self, $$21.$$brk = $brk, $$21.$$arity = 2, $$21))
          } catch (err) { if (err === $brk) { return err.$v } else { throw err } }})();
          self.reftexts = nil;
          return resolved_id;
        }
      }, $Document_resolve_id$18.$$arity = 1);
      
      Opal.def(self, '$sections?', $Document_sections$ques$22 = function() {
        var self = this;

        return $rb_gt(self.next_section_index, 0)
      }, $Document_sections$ques$22.$$arity = 0);
      
      Opal.def(self, '$footnotes?', $Document_footnotes$ques$23 = function() {
        var self = this;

        if ($truthy(self.catalog['$[]']("footnotes")['$empty?']())) {
          return false
        } else {
          return true
        }
      }, $Document_footnotes$ques$23.$$arity = 0);
      
      Opal.def(self, '$footnotes', $Document_footnotes$24 = function $$footnotes() {
        var self = this;

        return self.catalog['$[]']("footnotes")
      }, $Document_footnotes$24.$$arity = 0);
      
      Opal.def(self, '$callouts', $Document_callouts$25 = function $$callouts() {
        var self = this;

        return self.catalog['$[]']("callouts")
      }, $Document_callouts$25.$$arity = 0);
      
      Opal.def(self, '$nested?', $Document_nested$ques$26 = function() {
        var self = this;

        if ($truthy(self.parent_document)) {
          return true
        } else {
          return false
        }
      }, $Document_nested$ques$26.$$arity = 0);
      
      Opal.def(self, '$embedded?', $Document_embedded$ques$27 = function() {
        var self = this;

        return self.attributes['$key?']("embedded")
      }, $Document_embedded$ques$27.$$arity = 0);
      
      Opal.def(self, '$extensions?', $Document_extensions$ques$28 = function() {
        var self = this;

        if ($truthy(self.extensions)) {
          return true
        } else {
          return false
        }
      }, $Document_extensions$ques$28.$$arity = 0);
      
      Opal.def(self, '$source', $Document_source$29 = function $$source() {
        var self = this;

        if ($truthy(self.reader)) {
          return self.reader.$source()
        } else {
          return nil
        }
      }, $Document_source$29.$$arity = 0);
      
      Opal.def(self, '$source_lines', $Document_source_lines$30 = function $$source_lines() {
        var self = this;

        if ($truthy(self.reader)) {
          return self.reader.$source_lines()
        } else {
          return nil
        }
      }, $Document_source_lines$30.$$arity = 0);
      
      Opal.def(self, '$basebackend?', $Document_basebackend$ques$31 = function(base) {
        var self = this;

        return self.attributes['$[]']("basebackend")['$=='](base)
      }, $Document_basebackend$ques$31.$$arity = 1);
      
      Opal.def(self, '$title', $Document_title$32 = function $$title() {
        var self = this;

        return self.$doctitle()
      }, $Document_title$32.$$arity = 0);
      
      Opal.def(self, '$title=', $Document_title$eq$33 = function(title) {
        var self = this, sect = nil, $writer = nil;

        
        if ($truthy((sect = self.header))) {
        } else {
          
          $writer = ["header"];
          $send((sect = (self.header = $$($nesting, 'Section').$new(self, 0))), 'sectname=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];
        };
        
        $writer = [title];
        $send(sect, 'title=', Opal.to_a($writer));
        return $writer[$rb_minus($writer["length"], 1)];;
      }, $Document_title$eq$33.$$arity = 1);
      
      Opal.def(self, '$doctitle', $Document_doctitle$34 = function $$doctitle(opts) {
        var $a, self = this, val = nil, sect = nil, separator = nil;

        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        if ($truthy((val = self.attributes['$[]']("title")))) {
        } else if ($truthy((sect = self.$first_section()))) {
          val = sect.$title()
        } else if ($truthy(($truthy($a = opts['$[]']("use_fallback")) ? (val = self.attributes['$[]']("untitled-label")) : $a)['$!']())) {
          return nil};
        if ($truthy((separator = opts['$[]']("partition")))) {
          return $$($nesting, 'Title').$new(val, opts.$merge($hash2(["separator"], {"separator": (function() {if (separator['$=='](true)) {
            return self.attributes['$[]']("title-separator")
          } else {
            return separator
          }; return nil; })()})))
        } else if ($truthy(($truthy($a = opts['$[]']("sanitize")) ? val['$include?']("<") : $a))) {
          return val.$gsub($$($nesting, 'XmlSanitizeRx'), "").$squeeze(" ").$strip()
        } else {
          return val
        };
      }, $Document_doctitle$34.$$arity = -1);
      Opal.alias(self, "name", "doctitle");
      
      Opal.def(self, '$xreftext', $Document_xreftext$35 = function $$xreftext(xrefstyle) {
        var $a, self = this, val = nil;

        
        
        if (xrefstyle == null) {
          xrefstyle = nil;
        };
        if ($truthy(($truthy($a = (val = self.$reftext())) ? val['$empty?']()['$!']() : $a))) {
          return val
        } else {
          return self.$title()
        };
      }, $Document_xreftext$35.$$arity = -1);
      
      Opal.def(self, '$author', $Document_author$36 = function $$author() {
        var self = this;

        return self.attributes['$[]']("author")
      }, $Document_author$36.$$arity = 0);
      
      Opal.def(self, '$authors', $Document_authors$37 = function $$authors() {
        var $a, self = this, attrs = nil, authors = nil, num_authors = nil, idx = nil;

        if ($truthy((attrs = self.attributes)['$key?']("author"))) {
          
          authors = [$$($nesting, 'Author').$new(attrs['$[]']("author"), attrs['$[]']("firstname"), attrs['$[]']("middlename"), attrs['$[]']("lastname"), attrs['$[]']("authorinitials"), attrs['$[]']("email"))];
          if ($truthy($rb_gt((num_authors = ($truthy($a = attrs['$[]']("authorcount")) ? $a : 0)), 1))) {
            
            idx = 1;
            while ($truthy($rb_lt(idx, num_authors))) {
              
              idx = $rb_plus(idx, 1);
              authors['$<<']($$($nesting, 'Author').$new(attrs['$[]']("" + "author_" + (idx)), attrs['$[]']("" + "firstname_" + (idx)), attrs['$[]']("" + "middlename_" + (idx)), attrs['$[]']("" + "lastname_" + (idx)), attrs['$[]']("" + "authorinitials_" + (idx)), attrs['$[]']("" + "email_" + (idx))));
            };};
          return authors;
        } else {
          return []
        }
      }, $Document_authors$37.$$arity = 0);
      
      Opal.def(self, '$revdate', $Document_revdate$38 = function $$revdate() {
        var self = this;

        return self.attributes['$[]']("revdate")
      }, $Document_revdate$38.$$arity = 0);
      
      Opal.def(self, '$notitle', $Document_notitle$39 = function $$notitle() {
        var self = this;

        return self.attributes['$key?']("notitle")
      }, $Document_notitle$39.$$arity = 0);
      
      Opal.def(self, '$noheader', $Document_noheader$40 = function $$noheader() {
        var self = this;

        return self.attributes['$key?']("noheader")
      }, $Document_noheader$40.$$arity = 0);
      
      Opal.def(self, '$nofooter', $Document_nofooter$41 = function $$nofooter() {
        var self = this;

        return self.attributes['$key?']("nofooter")
      }, $Document_nofooter$41.$$arity = 0);
      
      Opal.def(self, '$first_section', $Document_first_section$42 = function $$first_section() {
        var $a, $$43, self = this;

        return ($truthy($a = self.header) ? $a : $send(self.blocks, 'find', [], ($$43 = function(e){var self = $$43.$$s || this;

        
          
          if (e == null) {
            e = nil;
          };
          return e.$context()['$==']("section");}, $$43.$$s = self, $$43.$$arity = 1, $$43)))
      }, $Document_first_section$42.$$arity = 0);
      
      Opal.def(self, '$header?', $Document_header$ques$44 = function() {
        var self = this;

        if ($truthy(self.header)) {
          return true
        } else {
          return false
        }
      }, $Document_header$ques$44.$$arity = 0);
      Opal.alias(self, "has_header?", "header?");
      
      Opal.def(self, '$<<', $Document_$lt$lt$45 = function(block) {
        var $iter = $Document_$lt$lt$45.$$p, $yield = $iter || nil, self = this, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) $Document_$lt$lt$45.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        
        if (block.$context()['$==']("section")) {
          self.$assign_numeral(block)};
        return $send(self, Opal.find_super_dispatcher(self, '<<', $Document_$lt$lt$45, false), $zuper, $iter);
      }, $Document_$lt$lt$45.$$arity = 1);
      
      Opal.def(self, '$finalize_header', $Document_finalize_header$46 = function $$finalize_header(unrooted_attributes, header_valid) {
        var self = this, $writer = nil;

        
        
        if (header_valid == null) {
          header_valid = true;
        };
        self.$clear_playback_attributes(unrooted_attributes);
        self.$save_attributes();
        if ($truthy(header_valid)) {
        } else {
          
          $writer = ["invalid-header", true];
          $send(unrooted_attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];
        };
        return unrooted_attributes;
      }, $Document_finalize_header$46.$$arity = -2);
      
      Opal.def(self, '$playback_attributes', $Document_playback_attributes$47 = function $$playback_attributes(block_attributes) {
        var $$48, self = this;

        if ($truthy(block_attributes['$key?']("attribute_entries"))) {
          return $send(block_attributes['$[]']("attribute_entries"), 'each', [], ($$48 = function(entry){var self = $$48.$$s || this, name = nil, $writer = nil;
            if (self.attributes == null) self.attributes = nil;

          
            
            if (entry == null) {
              entry = nil;
            };
            name = entry.$name();
            if ($truthy(entry.$negate())) {
              
              self.attributes.$delete(name);
              if (name['$==']("compat-mode")) {
                return (self.compat_mode = false)
              } else {
                return nil
              };
            } else {
              
              
              $writer = [name, entry.$value()];
              $send(self.attributes, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              if (name['$==']("compat-mode")) {
                return (self.compat_mode = true)
              } else {
                return nil
              };
            };}, $$48.$$s = self, $$48.$$arity = 1, $$48))
        } else {
          return nil
        }
      }, $Document_playback_attributes$47.$$arity = 1);
      
      Opal.def(self, '$restore_attributes', $Document_restore_attributes$49 = function $$restore_attributes() {
        var self = this;

        
        if ($truthy(self.parent_document)) {
        } else {
          self.catalog['$[]']("callouts").$rewind()
        };
        return self.attributes.$replace(self.header_attributes);
      }, $Document_restore_attributes$49.$$arity = 0);
      
      Opal.def(self, '$set_attribute', $Document_set_attribute$50 = function $$set_attribute(name, value) {
        var $a, self = this, $writer = nil, $case = nil;

        
        
        if (value == null) {
          value = "";
        };
        if ($truthy(self['$attribute_locked?'](name))) {
          return nil
        } else {
          
          if ($truthy(value['$empty?']())) {
          } else {
            value = self.$apply_attribute_value_subs(value)
          };
          if ($truthy(self.header_attributes)) {
            
            $writer = [name, value];
            $send(self.attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          } else {
            
            $case = name;
            if ("backend"['$===']($case)) {self.$update_backend_attributes(value, ($truthy($a = self.attributes_modified['$delete?']("htmlsyntax")) ? value['$=='](self.backend) : $a))}
            else if ("doctype"['$===']($case)) {self.$update_doctype_attributes(value)}
            else {
            $writer = [name, value];
            $send(self.attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
            self.attributes_modified['$<<'](name);
          };
          return value;
        };
      }, $Document_set_attribute$50.$$arity = -2);
      
      Opal.def(self, '$delete_attribute', $Document_delete_attribute$51 = function $$delete_attribute(name) {
        var self = this;

        if ($truthy(self['$attribute_locked?'](name))) {
          return false
        } else {
          
          self.attributes.$delete(name);
          self.attributes_modified['$<<'](name);
          return true;
        }
      }, $Document_delete_attribute$51.$$arity = 1);
      
      Opal.def(self, '$attribute_locked?', $Document_attribute_locked$ques$52 = function(name) {
        var self = this;

        return self.attribute_overrides['$key?'](name)
      }, $Document_attribute_locked$ques$52.$$arity = 1);
      
      Opal.def(self, '$set_header_attribute', $Document_set_header_attribute$53 = function $$set_header_attribute(name, value, overwrite) {
        var $a, self = this, attrs = nil, $writer = nil;

        
        
        if (value == null) {
          value = "";
        };
        
        if (overwrite == null) {
          overwrite = true;
        };
        attrs = ($truthy($a = self.header_attributes) ? $a : self.attributes);
        if ($truthy((($a = overwrite['$=='](false)) ? attrs['$key?'](name) : overwrite['$=='](false)))) {
          return false
        } else {
          
          
          $writer = [name, value];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          return true;
        };
      }, $Document_set_header_attribute$53.$$arity = -2);
      
      Opal.def(self, '$convert', $Document_convert$54 = function $$convert(opts) {
        var $a, $$55, self = this, $writer = nil, block = nil, output = nil, transform = nil, exts = nil;

        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        if ($truthy(self.timings)) {
          self.timings.$start("convert")};
        if ($truthy(self.parsed)) {
        } else {
          self.$parse()
        };
        if ($truthy(($truthy($a = $rb_ge(self.safe, $$$($$($nesting, 'SafeMode'), 'SERVER'))) ? $a : opts['$empty?']()))) {
        } else {
          
          if ($truthy((($writer = ["outfile", opts['$[]']("outfile")]), $send(self.attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))) {
          } else {
            self.attributes.$delete("outfile")
          };
          if ($truthy((($writer = ["outdir", opts['$[]']("outdir")]), $send(self.attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))) {
          } else {
            self.attributes.$delete("outdir")
          };
        };
        if (self.$doctype()['$==']("inline")) {
          if ($truthy((block = ($truthy($a = self.blocks['$[]'](0)) ? $a : self.header)))) {
            if ($truthy(($truthy($a = block.$content_model()['$==']("compound")) ? $a : block.$content_model()['$==']("empty")))) {
              self.$logger().$warn("no inline candidate; use the inline doctype to convert a single paragragh, verbatim, or raw block")
            } else {
              output = block.$content()
            }}
        } else {
          
          if ($truthy(opts['$key?']("standalone"))) {
            transform = (function() {if ($truthy(opts['$[]']("standalone"))) {
              return "document"
            } else {
              return "embedded"
            }; return nil; })()
          } else if ($truthy(opts['$key?']("header_footer"))) {
            transform = (function() {if ($truthy(opts['$[]']("header_footer"))) {
              return "document"
            } else {
              return "embedded"
            }; return nil; })()
          } else {
            transform = (function() {if ($truthy(self.options['$[]']("standalone"))) {
              return "document"
            } else {
              return "embedded"
            }; return nil; })()
          };
          output = self.converter.$convert(self, transform);
        };
        if ($truthy(self.parent_document)) {
        } else if ($truthy(($truthy($a = (exts = self.extensions)) ? exts['$postprocessors?']() : $a))) {
          $send(exts.$postprocessors(), 'each', [], ($$55 = function(ext){var self = $$55.$$s || this;

          
            
            if (ext == null) {
              ext = nil;
            };
            return (output = ext.$process_method()['$[]'](self, output));}, $$55.$$s = self, $$55.$$arity = 1, $$55))};
        if ($truthy(self.timings)) {
          self.timings.$record("convert")};
        return output;
      }, $Document_convert$54.$$arity = -1);
      Opal.alias(self, "render", "convert");
      
      Opal.def(self, '$write', $Document_write$56 = function $$write(output, target) {
        var $a, $b, self = this;

        
        if ($truthy(self.timings)) {
          self.timings.$start("write")};
        if ($truthy($$($nesting, 'Writer')['$==='](self.converter))) {
          self.converter.$write(output, target)
        } else {
          
          if ($truthy(target['$respond_to?']("write"))) {
            if ($truthy(output['$nil_or_empty?']())) {
            } else {
              
              target.$write(output.$chomp());
              target.$write($$($nesting, 'LF'));
            }
          } else {
            $$$('::', 'File').$write(target, output, $hash2(["mode"], {"mode": $$($nesting, 'FILE_WRITE_MODE')}))
          };
          if ($truthy(($truthy($a = (($b = self.backend['$==']("manpage")) ? $$$('::', 'String')['$==='](target) : self.backend['$==']("manpage"))) ? self.converter.$class()['$respond_to?']("write_alternate_pages") : $a))) {
            self.converter.$class().$write_alternate_pages(self.attributes['$[]']("mannames"), self.attributes['$[]']("manvolnum"), target)};
        };
        if ($truthy(self.timings)) {
          self.timings.$record("write")};
        return nil;
      }, $Document_write$56.$$arity = 2);
      
      Opal.def(self, '$content', $Document_content$57 = function $$content() {
        var $iter = $Document_content$57.$$p, $yield = $iter || nil, self = this, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) $Document_content$57.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        
        self.attributes.$delete("title");
        return $send(self, Opal.find_super_dispatcher(self, 'content', $Document_content$57, false), $zuper, $iter);
      }, $Document_content$57.$$arity = 0);
      
      Opal.def(self, '$docinfo', $Document_docinfo$58 = function $$docinfo(location, suffix) {
        var $a, $$59, $$60, self = this, qualifier = nil, docinfo = nil, content = nil, docinfo_file = nil, docinfo_dir = nil, docinfo_subs = nil, docinfo_path = nil, shared_docinfo = nil, private_docinfo = nil;

        
        
        if (location == null) {
          location = "head";
        };
        
        if (suffix == null) {
          suffix = nil;
        };
        if ($truthy($rb_lt(self.$safe(), $$$($$($nesting, 'SafeMode'), 'SECURE')))) {
          
          if (location['$==']("head")) {
          } else {
            qualifier = "" + "-" + (location)
          };
          suffix = ($truthy($a = suffix) ? $a : self.outfilesuffix);
          if ($truthy((docinfo = self.attributes['$[]']("docinfo"))['$nil_or_empty?']())) {
            if ($truthy(self.attributes['$key?']("docinfo2"))) {
              docinfo = ["private", "shared"]
            } else if ($truthy(self.attributes['$key?']("docinfo1"))) {
              docinfo = ["shared"]
            } else {
              docinfo = (function() {if ($truthy(docinfo)) {
                return ["private"]
              } else {
                return nil
              }; return nil; })()
            }
          } else {
            docinfo = $send(docinfo.$split(","), 'map', [], ($$59 = function(it){var self = $$59.$$s || this;

            
              
              if (it == null) {
                it = nil;
              };
              return it.$strip();}, $$59.$$s = self, $$59.$$arity = 1, $$59))
          };
          if ($truthy(docinfo)) {
            
            content = [];
            $a = ["" + "docinfo" + (qualifier) + (suffix), self.attributes['$[]']("docinfodir"), self.$resolve_docinfo_subs()], (docinfo_file = $a[0]), (docinfo_dir = $a[1]), (docinfo_subs = $a[2]), $a;
            if ($truthy(docinfo['$&'](["shared", "" + "shared-" + (location)])['$empty?']())) {
            } else {
              
              docinfo_path = self.$normalize_system_path(docinfo_file, docinfo_dir);
              if ($truthy((shared_docinfo = self.$read_asset(docinfo_path, $hash2(["normalize"], {"normalize": true}))))) {
                content['$<<'](self.$apply_subs(shared_docinfo, docinfo_subs))};
            };
            if ($truthy(($truthy($a = self.attributes['$[]']("docname")['$nil_or_empty?']()) ? $a : docinfo['$&'](["private", "" + "private-" + (location)])['$empty?']()))) {
            } else {
              
              docinfo_path = self.$normalize_system_path("" + (self.attributes['$[]']("docname")) + "-" + (docinfo_file), docinfo_dir);
              if ($truthy((private_docinfo = self.$read_asset(docinfo_path, $hash2(["normalize"], {"normalize": true}))))) {
                content['$<<'](self.$apply_subs(private_docinfo, docinfo_subs))};
            };};};
        if ($truthy(($truthy($a = self.extensions) ? self['$docinfo_processors?'](location) : $a))) {
          return ($truthy($a = content) ? $a : []).$concat($send(self.docinfo_processor_extensions['$[]'](location), 'map', [], ($$60 = function(ext){var self = $$60.$$s || this;

          
            
            if (ext == null) {
              ext = nil;
            };
            return ext.$process_method()['$[]'](self);}, $$60.$$s = self, $$60.$$arity = 1, $$60)).$compact()).$join($$($nesting, 'LF'))
        } else if ($truthy(content)) {
          return content.$join($$($nesting, 'LF'))
        } else {
          return ""
        };
      }, $Document_docinfo$58.$$arity = -1);
      
      Opal.def(self, '$docinfo_processors?', $Document_docinfo_processors$ques$61 = function(location) {
        var $a, self = this, $writer = nil;

        
        
        if (location == null) {
          location = "head";
        };
        if ($truthy(self.docinfo_processor_extensions['$key?'](location))) {
          return self.docinfo_processor_extensions['$[]'](location)['$!='](false)
        } else if ($truthy(($truthy($a = self.extensions) ? self.document.$extensions()['$docinfo_processors?'](location) : $a))) {
          return (($writer = [location, self.document.$extensions().$docinfo_processors(location)]), $send(self.docinfo_processor_extensions, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])['$!']()['$!']()
        } else {
          
          $writer = [location, false];
          $send(self.docinfo_processor_extensions, '[]=', Opal.to_a($writer));
          return $writer[$rb_minus($writer["length"], 1)];
        };
      }, $Document_docinfo_processors$ques$61.$$arity = -1);
      
      Opal.def(self, '$to_s', $Document_to_s$62 = function $$to_s() {
        var $a, self = this;

        return "" + "#<" + (self.$class()) + "@" + (self.$object_id()) + " {doctype: " + (self.$doctype().$inspect()) + ", doctitle: " + (($truthy($a = self.header) ? self.header.$title() : $a).$inspect()) + ", blocks: " + (self.blocks.$size()) + "}>"
      }, $Document_to_s$62.$$arity = 0);
      self.$private();
      
      Opal.def(self, '$apply_attribute_value_subs', $Document_apply_attribute_value_subs$63 = function $$apply_attribute_value_subs(value) {
        var $a, self = this;

        
        if ($truthy($$($nesting, 'AttributeEntryPassMacroRx')['$=~'](value))) {
          
          value = (($a = $gvars['~']) === nil ? nil : $a['$[]'](2));
          if ($truthy((($a = $gvars['~']) === nil ? nil : $a['$[]'](1)))) {
            value = self.$apply_subs(value, self.$resolve_pass_subs((($a = $gvars['~']) === nil ? nil : $a['$[]'](1))))};
        } else {
          value = self.$apply_header_subs(value)
        };
        if ($truthy(self.max_attribute_value_size)) {
          
          return self.$limit_bytesize(value, self.max_attribute_value_size);
        } else {
          return value
        };
      }, $Document_apply_attribute_value_subs$63.$$arity = 1);
      
      Opal.def(self, '$limit_bytesize', $Document_limit_bytesize$64 = function $$limit_bytesize(str, max) {
        var $a, self = this;

        
        if ($truthy($rb_gt(str.$bytesize(), max))) {
          while (!($truthy((str = str.$byteslice(0, max))['$valid_encoding?']()))) {
            max = $rb_minus(max, 1)
          }};
        return str;
      }, $Document_limit_bytesize$64.$$arity = 2);
      
      Opal.def(self, '$resolve_docinfo_subs', $Document_resolve_docinfo_subs$65 = function $$resolve_docinfo_subs() {
        var self = this;

        if ($truthy(self.attributes['$key?']("docinfosubs"))) {
          
          return self.$resolve_subs(self.attributes['$[]']("docinfosubs"), "block", nil, "docinfo");
        } else {
          return ["attributes"]
        }
      }, $Document_resolve_docinfo_subs$65.$$arity = 0);
      
      Opal.def(self, '$create_converter', $Document_create_converter$66 = function $$create_converter(backend, delegate_backend) {
        var $a, self = this, converter_opts = nil, template_dirs = nil, opts = nil, $writer = nil, converter = nil;

        
        converter_opts = $hash2(["document", "htmlsyntax"], {"document": self, "htmlsyntax": self.attributes['$[]']("htmlsyntax")});
        if ($truthy((template_dirs = ($truthy($a = (opts = self.options)['$[]']("template_dirs")) ? $a : opts['$[]']("template_dir"))))) {
          
          
          $writer = ["template_dirs", [].concat(Opal.to_a(template_dirs))];
          $send(converter_opts, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["template_cache", opts.$fetch("template_cache", true)];
          $send(converter_opts, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["template_engine", opts['$[]']("template_engine")];
          $send(converter_opts, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["template_engine_options", opts['$[]']("template_engine_options")];
          $send(converter_opts, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["eruby", opts['$[]']("eruby")];
          $send(converter_opts, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["safe", self.safe];
          $send(converter_opts, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          if ($truthy(delegate_backend)) {
            
            $writer = ["delegate_backend", delegate_backend];
            $send(converter_opts, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};};
        if ($truthy((converter = opts['$[]']("converter")))) {
          return $$$($$($nesting, 'Converter'), 'CustomFactory').$new($hash(backend, converter)).$create(backend, converter_opts)
        } else {
          return opts.$fetch("converter_factory", $$($nesting, 'Converter')).$create(backend, converter_opts)
        };
      }, $Document_create_converter$66.$$arity = 2);
      
      Opal.def(self, '$clear_playback_attributes', $Document_clear_playback_attributes$67 = function $$clear_playback_attributes(attributes) {
        var self = this;

        return attributes.$delete("attribute_entries")
      }, $Document_clear_playback_attributes$67.$$arity = 1);
      
      Opal.def(self, '$save_attributes', $Document_save_attributes$68 = function $$save_attributes() {
        var $a, $$69, self = this, attrs = nil, doctitle_val = nil, $writer = nil, toc_val = nil, toc_position_val = nil, toc_placement_val = nil, default_toc_position = nil, default_toc_class = nil, position = nil, $case = nil, icons_val = nil, basebackend = nil, syntax_hl_name = nil, syntax_hl_factory = nil, syntax_hls = nil;

        
        if ($truthy(($truthy($a = (attrs = self.attributes)['$key?']("doctitle")) ? $a : (doctitle_val = self.$doctitle())['$!']()))) {
        } else {
          
          $writer = ["doctitle", doctitle_val];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];
        };
        self.id = ($truthy($a = self.id) ? $a : attrs['$[]']("css-signature"));
        if ($truthy((toc_val = (function() {if ($truthy(attrs.$delete("toc2"))) {
          return "left"
        } else {
          return attrs['$[]']("toc")
        }; return nil; })()))) {
          
          toc_position_val = (function() {if ($truthy(($truthy($a = (toc_placement_val = attrs.$fetch("toc-placement", "macro"))) ? toc_placement_val['$!=']("auto") : $a))) {
            return toc_placement_val
          } else {
            return attrs['$[]']("toc-position")
          }; return nil; })();
          if ($truthy(($truthy($a = toc_val['$empty?']()) ? toc_position_val['$nil_or_empty?']() : $a))) {
          } else {
            
            default_toc_position = "left";
            default_toc_class = "toc2";
            position = (function() {if ($truthy(toc_position_val['$nil_or_empty?']())) {
              
              if ($truthy(toc_val['$empty?']())) {
                return default_toc_position
              } else {
                return toc_val
              };
            } else {
              return toc_position_val
            }; return nil; })();
            
            $writer = ["toc", ""];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            
            $writer = ["toc-placement", "auto"];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            $case = position;
            if ("left"['$===']($case) || "<"['$===']($case) || "&lt;"['$===']($case)) {
            $writer = ["toc-position", "left"];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];}
            else if ("right"['$===']($case) || ">"['$===']($case) || "&gt;"['$===']($case)) {
            $writer = ["toc-position", "right"];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];}
            else if ("top"['$===']($case) || "^"['$===']($case)) {
            $writer = ["toc-position", "top"];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];}
            else if ("bottom"['$===']($case) || "v"['$===']($case)) {
            $writer = ["toc-position", "bottom"];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];}
            else if ("preamble"['$===']($case) || "macro"['$===']($case)) {
            
            $writer = ["toc-position", "content"];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            
            $writer = ["toc-placement", position];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            default_toc_class = nil;}
            else {
            attrs.$delete("toc-position");
            default_toc_class = nil;};
            if ($truthy(default_toc_class)) {
              ($truthy($a = attrs['$[]']("toc-class")) ? $a : (($writer = ["toc-class", default_toc_class]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))};
          };};
        if ($truthy(($truthy($a = (icons_val = attrs['$[]']("icons"))) ? attrs['$key?']("icontype")['$!']() : $a))) {
          $case = icons_val;
          if (""['$===']($case) || "font"['$===']($case)) {nil}
          else {
          
          $writer = ["icons", ""];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          if (icons_val['$==']("image")) {
          } else {
            
            $writer = ["icontype", icons_val];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          };}};
        if ($truthy(($truthy($a = (self.compat_mode = attrs['$key?']("compat-mode"))) ? attrs['$key?']("language") : $a))) {
          
          $writer = ["source-language", attrs['$[]']("language")];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        if ($truthy(self.parent_document)) {
        } else {
          
          if ((basebackend = attrs['$[]']("basebackend"))['$==']("html")) {
            if ($truthy(($truthy($a = (syntax_hl_name = attrs['$[]']("source-highlighter"))) ? attrs['$[]']("" + (syntax_hl_name) + "-unavailable")['$!']() : $a))) {
              if ($truthy((syntax_hl_factory = self.options['$[]']("syntax_highlighter_factory")))) {
                self.syntax_highlighter = syntax_hl_factory.$create(syntax_hl_name, self.backend, $hash2(["document"], {"document": self}))
              } else if ($truthy((syntax_hls = self.options['$[]']("syntax_highlighters")))) {
                self.syntax_highlighter = $$$($$($nesting, 'SyntaxHighlighter'), 'DefaultFactoryProxy').$new(syntax_hls).$create(syntax_hl_name, self.backend, $hash2(["document"], {"document": self}))
              } else {
                self.syntax_highlighter = $$($nesting, 'SyntaxHighlighter').$create(syntax_hl_name, self.backend, $hash2(["document"], {"document": self}))
              }}
          } else if (basebackend['$==']("docbook")) {
            
            if ($truthy(($truthy($a = self['$attribute_locked?']("toc")) ? $a : self.attributes_modified['$include?']("toc")))) {
            } else {
              
              $writer = ["toc", ""];
              $send(attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            };
            if ($truthy(($truthy($a = self['$attribute_locked?']("sectnums")) ? $a : self.attributes_modified['$include?']("sectnums")))) {
            } else {
              
              $writer = ["sectnums", ""];
              $send(attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            };};
          self.outfilesuffix = attrs['$[]']("outfilesuffix");
          $send($$($nesting, 'FLEXIBLE_ATTRIBUTES'), 'each', [], ($$69 = function(name){var self = $$69.$$s || this, $b;
            if (self.attribute_overrides == null) self.attribute_overrides = nil;

          
            
            if (name == null) {
              name = nil;
            };
            if ($truthy(($truthy($b = self.attribute_overrides['$key?'](name)) ? self.attribute_overrides['$[]'](name) : $b))) {
              return self.attribute_overrides.$delete(name)
            } else {
              return nil
            };}, $$69.$$s = self, $$69.$$arity = 1, $$69));
        };
        return (self.header_attributes = attrs.$merge());
      }, $Document_save_attributes$68.$$arity = 0);
      
      Opal.def(self, '$fill_datetime_attributes', $Document_fill_datetime_attributes$70 = function $$fill_datetime_attributes(attrs, input_mtime) {
        var $a, $b, self = this, now = nil, source_date_epoch = nil, localdate = nil, $writer = nil, localtime = nil, docdate = nil, doctime = nil;

        
        now = (function() {if ($truthy($$$('::', 'ENV')['$key?']("SOURCE_DATE_EPOCH"))) {
          
          return (source_date_epoch = $$$('::', 'Time').$at(self.$Integer($$$('::', 'ENV')['$[]']("SOURCE_DATE_EPOCH"))).$utc());
        } else {
          return $$$('::', 'Time').$now()
        }; return nil; })();
        if ($truthy((localdate = attrs['$[]']("localdate")))) {
          ($truthy($a = attrs['$[]']("localyear")) ? $a : (($writer = ["localyear", (function() {if (localdate.$index("-")['$=='](4)) {
            
            return localdate.$slice(0, 4);
          } else {
            return nil
          }; return nil; })()]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))
        } else {
          
          localdate = (($writer = ["localdate", now.$strftime("%F")]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]);
          ($truthy($a = attrs['$[]']("localyear")) ? $a : (($writer = ["localyear", now.$year().$to_s()]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        };
        localtime = ($truthy($a = attrs['$[]']("localtime")) ? $a : (($writer = ["localtime", now.$strftime("" + "%T " + ((function() {if (now.$utc_offset()['$=='](0)) {
          return "UTC"
        } else {
          return "%z"
        }; return nil; })()))]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        ($truthy($a = attrs['$[]']("localdatetime")) ? $a : (($writer = ["localdatetime", "" + (localdate) + " " + (localtime)]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        input_mtime = ($truthy($a = ($truthy($b = source_date_epoch) ? $b : input_mtime)) ? $a : now);
        if ($truthy((docdate = attrs['$[]']("docdate")))) {
          ($truthy($a = attrs['$[]']("docyear")) ? $a : (($writer = ["docyear", (function() {if (docdate.$index("-")['$=='](4)) {
            
            return docdate.$slice(0, 4);
          } else {
            return nil
          }; return nil; })()]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))
        } else {
          
          docdate = (($writer = ["docdate", input_mtime.$strftime("%F")]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]);
          ($truthy($a = attrs['$[]']("docyear")) ? $a : (($writer = ["docyear", input_mtime.$year().$to_s()]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        };
        doctime = ($truthy($a = attrs['$[]']("doctime")) ? $a : (($writer = ["doctime", input_mtime.$strftime("" + "%T " + ((function() {if (input_mtime.$utc_offset()['$=='](0)) {
          return "UTC"
        } else {
          return "%z"
        }; return nil; })()))]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        ($truthy($a = attrs['$[]']("docdatetime")) ? $a : (($writer = ["docdatetime", "" + (docdate) + " " + (doctime)]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        return nil;
      }, $Document_fill_datetime_attributes$70.$$arity = 2);
      
      Opal.def(self, '$update_backend_attributes', $Document_update_backend_attributes$71 = function $$update_backend_attributes(new_backend, init) {
        var $a, $b, self = this, current_backend = nil, current_basebackend = nil, attrs = nil, current_doctype = nil, actual_backend = nil, _ = nil, $writer = nil, delegate_backend = nil, converter = nil, new_basebackend = nil, new_filetype = nil, htmlsyntax = nil, backend_traits = nil, current_filetype = nil, page_width = nil;

        
        
        if (init == null) {
          init = nil;
        };
        if ($truthy(($truthy($a = init) ? $a : new_backend['$!='](self.backend)))) {
          
          current_backend = self.backend;
          current_basebackend = (attrs = self.attributes)['$[]']("basebackend");
          current_doctype = self.doctype;
          if ($truthy(new_backend['$include?'](":"))) {
            $b = new_backend.$partition(":"), $a = Opal.to_ary($b), (actual_backend = ($a[0] == null ? nil : $a[0])), (_ = ($a[1] == null ? nil : $a[1])), (new_backend = ($a[2] == null ? nil : $a[2])), $b};
          if ($truthy(new_backend['$start_with?']("xhtml"))) {
            
            
            $writer = ["htmlsyntax", "xml"];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            new_backend = new_backend.$slice(1, new_backend.$length());
          } else if ($truthy(new_backend['$start_with?']("html"))) {
            ($truthy($a = attrs['$[]']("htmlsyntax")) ? $a : (($writer = ["htmlsyntax", "html"]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))};
          new_backend = ($truthy($a = $$($nesting, 'BACKEND_ALIASES')['$[]'](new_backend)) ? $a : new_backend);
          if ($truthy(actual_backend)) {
            $a = [actual_backend, new_backend], (new_backend = $a[0]), (delegate_backend = $a[1]), $a};
          if ($truthy(current_doctype)) {
            
            if ($truthy(current_backend)) {
              
              attrs.$delete("" + "backend-" + (current_backend));
              attrs.$delete("" + "backend-" + (current_backend) + "-doctype-" + (current_doctype));};
            
            $writer = ["" + "backend-" + (new_backend) + "-doctype-" + (current_doctype), ""];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            
            $writer = ["" + "doctype-" + (current_doctype), ""];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
          } else if ($truthy(current_backend)) {
            attrs.$delete("" + "backend-" + (current_backend))};
          
          $writer = ["" + "backend-" + (new_backend), ""];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          self.backend = (($writer = ["backend", new_backend]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]);
          if ($truthy($$$($$($nesting, 'Converter'), 'BackendTraits')['$===']((converter = self.$create_converter(new_backend, delegate_backend))))) {
            
            new_basebackend = converter.$basebackend();
            new_filetype = converter.$filetype();
            if ($truthy((htmlsyntax = converter.$htmlsyntax()))) {
              
              $writer = ["htmlsyntax", htmlsyntax];
              $send(attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
            if ($truthy(init)) {
              ($truthy($a = attrs['$[]']("outfilesuffix")) ? $a : (($writer = ["outfilesuffix", converter.$outfilesuffix()]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))
            } else if ($truthy(self['$attribute_locked?']("outfilesuffix"))) {
            } else {
              
              $writer = ["outfilesuffix", converter.$outfilesuffix()];
              $send(attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            };
          } else if ($truthy(converter)) {
            
            backend_traits = $$($nesting, 'Converter').$derive_backend_traits(new_backend);
            new_basebackend = backend_traits['$[]']("basebackend");
            new_filetype = backend_traits['$[]']("filetype");
            if ($truthy(init)) {
              ($truthy($a = attrs['$[]']("outfilesuffix")) ? $a : (($writer = ["outfilesuffix", backend_traits['$[]']("outfilesuffix")]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))
            } else if ($truthy(self['$attribute_locked?']("outfilesuffix"))) {
            } else {
              
              $writer = ["outfilesuffix", backend_traits['$[]']("outfilesuffix")];
              $send(attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            };
          } else {
            self.$raise($$$('::', 'NotImplementedError'), "" + "asciidoctor: FAILED: missing converter for backend '" + (new_backend) + "'. Processing aborted.")
          };
          self.converter = converter;
          if ($truthy((current_filetype = attrs['$[]']("filetype")))) {
            attrs.$delete("" + "filetype-" + (current_filetype))};
          
          $writer = ["filetype", new_filetype];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["" + "filetype-" + (new_filetype), ""];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          if ($truthy((page_width = $$($nesting, 'DEFAULT_PAGE_WIDTHS')['$[]'](new_basebackend)))) {
            
            $writer = ["pagewidth", page_width];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          } else {
            attrs.$delete("pagewidth")
          };
          if ($truthy(new_basebackend['$!='](current_basebackend))) {
            
            if ($truthy(current_doctype)) {
              
              if ($truthy(current_basebackend)) {
                
                attrs.$delete("" + "basebackend-" + (current_basebackend));
                attrs.$delete("" + "basebackend-" + (current_basebackend) + "-doctype-" + (current_doctype));};
              
              $writer = ["" + "basebackend-" + (new_basebackend) + "-doctype-" + (current_doctype), ""];
              $send(attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
            } else if ($truthy(current_basebackend)) {
              attrs.$delete("" + "basebackend-" + (current_basebackend))};
            
            $writer = ["" + "basebackend-" + (new_basebackend), ""];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            
            $writer = ["basebackend", new_basebackend];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;};
          return new_backend;
        } else {
          return nil
        };
      }, $Document_update_backend_attributes$71.$$arity = -2);
      return (Opal.def(self, '$update_doctype_attributes', $Document_update_doctype_attributes$72 = function $$update_doctype_attributes(new_doctype) {
        var $a, self = this, attrs = nil, current_backend = nil, current_basebackend = nil, current_doctype = nil, $writer = nil;

        if ($truthy(($truthy($a = new_doctype) ? new_doctype['$!='](self.doctype) : $a))) {
          
          $a = [self.backend, (attrs = self.attributes)['$[]']("basebackend"), self.doctype], (current_backend = $a[0]), (current_basebackend = $a[1]), (current_doctype = $a[2]), $a;
          if ($truthy(current_doctype)) {
            
            attrs.$delete("" + "doctype-" + (current_doctype));
            if ($truthy(current_backend)) {
              
              attrs.$delete("" + "backend-" + (current_backend) + "-doctype-" + (current_doctype));
              
              $writer = ["" + "backend-" + (current_backend) + "-doctype-" + (new_doctype), ""];
              $send(attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;};
            if ($truthy(current_basebackend)) {
              
              attrs.$delete("" + "basebackend-" + (current_basebackend) + "-doctype-" + (current_doctype));
              
              $writer = ["" + "basebackend-" + (current_basebackend) + "-doctype-" + (new_doctype), ""];
              $send(attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;};
          } else {
            
            if ($truthy(current_backend)) {
              
              $writer = ["" + "backend-" + (current_backend) + "-doctype-" + (new_doctype), ""];
              $send(attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
            if ($truthy(current_basebackend)) {
              
              $writer = ["" + "basebackend-" + (current_basebackend) + "-doctype-" + (new_doctype), ""];
              $send(attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
          };
          
          $writer = ["" + "doctype-" + (new_doctype), ""];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          return (self.doctype = (($writer = ["doctype", new_doctype]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        } else {
          return nil
        }
      }, $Document_update_doctype_attributes$72.$$arity = 1), nil) && 'update_doctype_attributes';
    })($nesting[0], $$($nesting, 'AbstractBlock'), $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/inline"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $hash2 = Opal.hash2, $send = Opal.send, $truthy = Opal.truthy;

  Opal.add_stubs(['$attr_accessor', '$attr_reader', '$[]', '$convert', '$converter', '$attr', '$==', '$apply_reftext_subs', '$reftext']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'Inline');

      var $nesting = [self].concat($parent_nesting), $Inline_initialize$1, $Inline_block$ques$2, $Inline_inline$ques$3, $Inline_convert$4, $Inline_alt$5, $Inline_reftext$ques$6, $Inline_reftext$7, $Inline_xreftext$8;

      self.$$prototype.text = self.$$prototype.type = nil;
      
      self.$attr_accessor("text");
      self.$attr_reader("type");
      self.$attr_accessor("target");
      
      Opal.def(self, '$initialize', $Inline_initialize$1 = function $$initialize(parent, context, text, opts) {
        var $iter = $Inline_initialize$1.$$p, $yield = $iter || nil, self = this;

        if ($iter) $Inline_initialize$1.$$p = null;
        
        
        if (text == null) {
          text = nil;
        };
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        $send(self, Opal.find_super_dispatcher(self, 'initialize', $Inline_initialize$1, false), [parent, context, opts], null);
        self.node_name = "" + "inline_" + (context);
        self.text = text;
        self.id = opts['$[]']("id");
        self.type = opts['$[]']("type");
        return (self.target = opts['$[]']("target"));
      }, $Inline_initialize$1.$$arity = -3);
      
      Opal.def(self, '$block?', $Inline_block$ques$2 = function() {
        var self = this;

        return false
      }, $Inline_block$ques$2.$$arity = 0);
      
      Opal.def(self, '$inline?', $Inline_inline$ques$3 = function() {
        var self = this;

        return true
      }, $Inline_inline$ques$3.$$arity = 0);
      
      Opal.def(self, '$convert', $Inline_convert$4 = function $$convert() {
        var self = this;

        return self.$converter().$convert(self)
      }, $Inline_convert$4.$$arity = 0);
      Opal.alias(self, "render", "convert");
      
      Opal.def(self, '$alt', $Inline_alt$5 = function $$alt() {
        var $a, self = this;

        return ($truthy($a = self.$attr("alt")) ? $a : "")
      }, $Inline_alt$5.$$arity = 0);
      
      Opal.def(self, '$reftext?', $Inline_reftext$ques$6 = function() {
        var $a, $b, self = this;

        return ($truthy($a = self.text) ? ($truthy($b = self.type['$==']("ref")) ? $b : self.type['$==']("bibref")) : $a)
      }, $Inline_reftext$ques$6.$$arity = 0);
      
      Opal.def(self, '$reftext', $Inline_reftext$7 = function $$reftext() {
        var self = this, val = nil;

        if ($truthy((val = self.text))) {
          
          return self.$apply_reftext_subs(val);
        } else {
          return nil
        }
      }, $Inline_reftext$7.$$arity = 0);
      return (Opal.def(self, '$xreftext', $Inline_xreftext$8 = function $$xreftext(xrefstyle) {
        var self = this;

        
        
        if (xrefstyle == null) {
          xrefstyle = nil;
        };
        return self.$reftext();
      }, $Inline_xreftext$8.$$arity = -1), nil) && 'xreftext';
    })($nesting[0], $$($nesting, 'AbstractNode'), $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/list"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $hash2 = Opal.hash2, $send = Opal.send, $truthy = Opal.truthy;

  Opal.add_stubs(['$==', '$next_list', '$callouts', '$class', '$object_id', '$inspect', '$size', '$items', '$attr_accessor', '$level', '$drop', '$nil_or_empty?', '$apply_subs', '$attr_writer', '$empty?', '$===', '$[]', '$outline?', '$!', '$simple?', '$source', '$shift', '$context', '$parent']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    
    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'List');

      var $nesting = [self].concat($parent_nesting), $List_initialize$1, $List_outline$ques$2, $List_convert$3, $List_to_s$4;

      self.$$prototype.context = self.$$prototype.document = self.$$prototype.style = nil;
      
      Opal.alias(self, "items", "blocks");
      Opal.alias(self, "content", "blocks");
      Opal.alias(self, "items?", "blocks?");
      
      Opal.def(self, '$initialize', $List_initialize$1 = function $$initialize(parent, context, opts) {
        var $iter = $List_initialize$1.$$p, $yield = $iter || nil, self = this, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) $List_initialize$1.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        return $send(self, Opal.find_super_dispatcher(self, 'initialize', $List_initialize$1, false), $zuper, $iter);
      }, $List_initialize$1.$$arity = -3);
      
      Opal.def(self, '$outline?', $List_outline$ques$2 = function() {
        var $a, self = this;

        return ($truthy($a = self.context['$==']("ulist")) ? $a : self.context['$==']("olist"))
      }, $List_outline$ques$2.$$arity = 0);
      
      Opal.def(self, '$convert', $List_convert$3 = function $$convert() {
        var $iter = $List_convert$3.$$p, $yield = $iter || nil, self = this, result = nil, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) $List_convert$3.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        if (self.context['$==']("colist")) {
          
          result = $send(self, Opal.find_super_dispatcher(self, 'convert', $List_convert$3, false), $zuper, $iter);
          self.document.$callouts().$next_list();
          return result;
        } else {
          return $send(self, Opal.find_super_dispatcher(self, 'convert', $List_convert$3, false), $zuper, $iter)
        }
      }, $List_convert$3.$$arity = 0);
      Opal.alias(self, "render", "convert");
      return (Opal.def(self, '$to_s', $List_to_s$4 = function $$to_s() {
        var self = this;

        return "" + "#<" + (self.$class()) + "@" + (self.$object_id()) + " {context: " + (self.context.$inspect()) + ", style: " + (self.style.$inspect()) + ", items: " + (self.$items().$size()) + "}>"
      }, $List_to_s$4.$$arity = 0), nil) && 'to_s';
    })($nesting[0], $$($nesting, 'AbstractBlock'), $nesting);
    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'ListItem');

      var $nesting = [self].concat($parent_nesting), $ListItem_initialize$5, $ListItem_text$ques$6, $ListItem_text$7, $ListItem_simple$ques$8, $ListItem_compound$ques$9, $ListItem_fold_first$10, $ListItem_to_s$11;

      self.$$prototype.text = self.$$prototype.subs = self.$$prototype.blocks = nil;
      
      Opal.alias(self, "list", "parent");
      self.$attr_accessor("marker");
      
      Opal.def(self, '$initialize', $ListItem_initialize$5 = function $$initialize(parent, text) {
        var $iter = $ListItem_initialize$5.$$p, $yield = $iter || nil, self = this;

        if ($iter) $ListItem_initialize$5.$$p = null;
        
        
        if (text == null) {
          text = nil;
        };
        $send(self, Opal.find_super_dispatcher(self, 'initialize', $ListItem_initialize$5, false), [parent, "list_item"], null);
        self.text = text;
        self.level = parent.$level();
        return (self.subs = $$($nesting, 'NORMAL_SUBS').$drop(0));
      }, $ListItem_initialize$5.$$arity = -2);
      
      Opal.def(self, '$text?', $ListItem_text$ques$6 = function() {
        var self = this;

        if ($truthy(self.text['$nil_or_empty?']())) {
          return false
        } else {
          return true
        }
      }, $ListItem_text$ques$6.$$arity = 0);
      
      Opal.def(self, '$text', $ListItem_text$7 = function $$text() {
        var $a, self = this;

        return ($truthy($a = self.text) ? self.$apply_subs(self.text, self.subs) : $a)
      }, $ListItem_text$7.$$arity = 0);
      self.$attr_writer("text");
      
      Opal.def(self, '$simple?', $ListItem_simple$ques$8 = function() {
        var $a, $b, $c, self = this, blk = nil;

        return ($truthy($a = self.blocks['$empty?']()) ? $a : ($truthy($b = (($c = self.blocks.$size()['$=='](1)) ? $$($nesting, 'List')['$===']((blk = self.blocks['$[]'](0))) : self.blocks.$size()['$=='](1))) ? blk['$outline?']() : $b))
      }, $ListItem_simple$ques$8.$$arity = 0);
      
      Opal.def(self, '$compound?', $ListItem_compound$ques$9 = function() {
        var self = this;

        return self['$simple?']()['$!']()
      }, $ListItem_compound$ques$9.$$arity = 0);
      
      Opal.def(self, '$fold_first', $ListItem_fold_first$10 = function $$fold_first() {
        var self = this;

        
        self.text = (function() {if ($truthy(self.text['$nil_or_empty?']())) {
          return self.blocks.$shift().$source()
        } else {
          return "" + (self.text) + ($$($nesting, 'LF')) + (self.blocks.$shift().$source())
        }; return nil; })();
        return nil;
      }, $ListItem_fold_first$10.$$arity = 0);
      return (Opal.def(self, '$to_s', $ListItem_to_s$11 = function $$to_s() {
        var $a, self = this;

        return "" + "#<" + (self.$class()) + "@" + (self.$object_id()) + " {list_context: " + (self.$parent().$context().$inspect()) + ", text: " + (self.text.$inspect()) + ", blocks: " + (($truthy($a = self.blocks) ? $a : []).$size()) + "}>"
      }, $ListItem_to_s$11.$$arity = 0), nil) && 'to_s';
    })($nesting[0], $$($nesting, 'AbstractBlock'), $nesting);
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/parser"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  function $rb_times(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs * rhs : lhs['$*'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $send = Opal.send, $truthy = Opal.truthy, $hash2 = Opal.hash2, $gvars = Opal.gvars;

  Opal.add_stubs(['$include', '$new', '$proc', '$start_with?', '$match?', '$is_delimited_block?', '$private_class_method', '$parse_document_header', '$[]', '$has_more_lines?', '$next_section', '$assign_numeral', '$<<', '$blocks', '$skip_blank_lines', '$parse_block_metadata_lines', '$attributes', '$is_next_line_doctitle?', '$[]=', '$-', '$finalize_header', '$nil_or_empty?', '$title=', '$sourcemap', '$cursor', '$parse_section_title', '$id=', '$include?', '$sub_specialchars', '$sub_attributes', '$source_location=', '$header', '$attribute_locked?', '$id', '$clear', '$delete', '$instance_variable_get', '$parse_header_metadata', '$==', '$!', '$register', '$process_authors', '$update', '$doctype', '$parse_manpage_header', '$=~', '$downcase', '$error', '$logger', '$message_with_context', '$cursor_at_line', '$backend', '$save', '$is_next_line_section?', '$initialize_section', '$join', '$map', '$read_lines_until', '$lstrip', '$split', '$title', '$restore_save', '$discard_save', '$context', '$empty?', '$header?', '$!=', '$attr?', '$attr', '$key?', '$document', '$+', '$level', '$special', '$sectname', '$to_i', '$<', '$>', '$warn', '$next_block', '$blocks?', '$style', '$context=', '$style=', '$parent=', '$size', '$content_model', '$shift', '$unwrap_standalone_preamble', '$source_location', '$merge', '$fetch', '$parse_block_metadata_line', '$extensions', '$block_macros?', '$mark', '$read_line', '$terminator', '$to_s', '$masq', '$to_sym', '$registered_for_block?', '$debug?', '$debug', '$cursor_at_mark', '$strict_verbatim_paragraphs', '$unshift_line', '$markdown_syntax', '$keys', '$chr', '$uniform?', '$length', '$end_with?', '$===', '$parse_attributes', '$attribute_missing', '$tr', '$basename', '$assign_caption', '$registered_for_block_macro?', '$config', '$process_method', '$replace', '$parse_callout_list', '$callouts', '$parse_list', '$parse_description_list', '$underline_style_section_titles', '$is_section_title?', '$peek_line', '$atx_section_title?', '$generate_id', '$level=', '$read_paragraph_lines', '$adjust_indentation!', '$map!', '$slice', '$pop', '$build_block', '$apply_subs', '$chop', '$catalog_inline_anchors', '$rekey', '$index', '$strip', '$parse_table', '$each', '$raise', '$title?', '$update_attributes', '$commit_subs', '$sub?', '$catalog_callouts', '$source', '$remove_sub', '$block_terminates_paragraph', '$to_proc', '$nil?', '$lines', '$parse_blocks', '$parse_list_item', '$items', '$scan', '$gsub', '$count', '$advance', '$dup', '$match', '$callout_ids', '$next_list', '$catalog_inline_anchor', '$marker=', '$catalog_inline_biblio_anchor', '$set_option', '$text=', '$resolve_ordered_list_marker', '$read_lines_for_list_item', '$skip_line_comments', '$unshift_lines', '$fold_first', '$text?', '$is_sibling_list_item?', '$concat', '$find', '$casecmp', '$sectname=', '$special=', '$numbered=', '$numbered', '$lineno', '$peek_lines', '$setext_section_title?', '$abs', '$cursor_at_prev_line', '$process_attribute_entries', '$next_line_empty?', '$apply_header_subs', '$rstrip', '$each_with_index', '$compact', '$to_h', '$squeeze', '$to_a', '$parse_style_attribute', '$process_attribute_entry', '$skip_comment_lines', '$store_attribute', '$sanitize_attribute_name', '$set_attribute', '$save_to', '$delete_attribute', '$ord', '$int_to_roman', '$resolve_list_marker', '$parse_colspecs', '$create_columns', '$has_header_option=', '$format', '$starts_with_delimiter?', '$close_open_cell', '$parse_cellspec', '$delimiter', '$match_delimiter', '$pre_match', '$post_match', '$buffer_has_unclosed_quotes?', '$skip_past_delimiter', '$buffer', '$buffer=', '$skip_past_escaped_delimiter', '$keep_cell_open', '$push_cellspec', '$close_cell', '$cell_open?', '$columns', '$assign_column_widths', '$partition_header_footer', '$upto', '$partition', '$shorthand_property_syntax', '$each_char', '$yield_buffered_attribute', '$any?', '$*', '$each_byte', '$%']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'Parser');

      var $nesting = [self].concat($parent_nesting), $Parser$1, $Parser$2, $Parser$3, $Parser_parse$4, $Parser_parse_document_header$5, $Parser_parse_manpage_header$6, $Parser_next_section$9, $Parser_next_block$10, $Parser_read_paragraph_lines$14, $Parser_is_delimited_block$ques$15, $Parser_build_block$16, $Parser_parse_blocks$17, $Parser_parse_list$18, $Parser_catalog_callouts$19, $Parser_catalog_inline_anchor$21, $Parser_catalog_inline_anchors$22, $Parser_catalog_inline_biblio_anchor$24, $Parser_parse_description_list$25, $Parser_parse_callout_list$26, $Parser_parse_list_item$27, $Parser_read_lines_for_list_item$28, $Parser_initialize_section$34, $Parser_is_next_line_section$ques$35, $Parser_is_next_line_doctitle$ques$36, $Parser_is_section_title$ques$37, $Parser_atx_section_title$ques$38, $Parser_setext_section_title$ques$39, $Parser_parse_section_title$40, $Parser_parse_header_metadata$41, $Parser_process_authors$46, $Parser_parse_block_metadata_lines$51, $Parser_parse_block_metadata_line$52, $Parser_process_attribute_entries$53, $Parser_process_attribute_entry$54, $Parser_store_attribute$55, $Parser_resolve_list_marker$56, $Parser_resolve_ordered_list_marker$57, $Parser_is_sibling_list_item$ques$59, $Parser_parse_table$60, $Parser_parse_colspecs$61, $Parser_parse_cellspec$65, $Parser_parse_style_attribute$66, $Parser_yield_buffered_attribute$69, $Parser_adjust_indentation$excl$70, $Parser_uniform$ques$79, $Parser_sanitize_attribute_name$80;

      
      self.$include($$($nesting, 'Logging'));
      Opal.const_set($nesting[0], 'BlockMatchData', $$($nesting, 'Struct').$new("context", "masq", "tip", "terminator"));
      Opal.const_set($nesting[0], 'TAB', "\t");
      Opal.const_set($nesting[0], 'TabIndentRx', /^\t+/);
      Opal.const_set($nesting[0], 'StartOfBlockProc', $send(self, 'proc', [], ($Parser$1 = function(l){var self = $Parser$1.$$s || this, $a, $b;

      
        
        if (l == null) {
          l = nil;
        };
        return ($truthy($a = ($truthy($b = l['$start_with?']("[")) ? $$($nesting, 'BlockAttributeLineRx')['$match?'](l) : $b)) ? $a : self['$is_delimited_block?'](l));}, $Parser$1.$$s = self, $Parser$1.$$arity = 1, $Parser$1)));
      Opal.const_set($nesting[0], 'StartOfListProc', $send(self, 'proc', [], ($Parser$2 = function(l){var self = $Parser$2.$$s || this;

      
        
        if (l == null) {
          l = nil;
        };
        return $$($nesting, 'AnyListRx')['$match?'](l);}, $Parser$2.$$s = self, $Parser$2.$$arity = 1, $Parser$2)));
      Opal.const_set($nesting[0], 'StartOfBlockOrListProc', $send(self, 'proc', [], ($Parser$3 = function(l){var self = $Parser$3.$$s || this, $a, $b, $c;

      
        
        if (l == null) {
          l = nil;
        };
        return ($truthy($a = ($truthy($b = self['$is_delimited_block?'](l)) ? $b : ($truthy($c = l['$start_with?']("[")) ? $$($nesting, 'BlockAttributeLineRx')['$match?'](l) : $c))) ? $a : $$($nesting, 'AnyListRx')['$match?'](l));}, $Parser$3.$$s = self, $Parser$3.$$arity = 1, $Parser$3)));
      Opal.const_set($nesting[0], 'NoOp', nil);
      Opal.const_set($nesting[0], 'AuthorKeys', ["author", "authorinitials", "firstname", "middlename", "lastname", "email"]);
      Opal.const_set($nesting[0], 'TableCellHorzAlignments', $hash2(["<", ">", "^"], {"<": "left", ">": "right", "^": "center"}));
      Opal.const_set($nesting[0], 'TableCellVertAlignments', $hash2(["<", ">", "^"], {"<": "top", ">": "bottom", "^": "middle"}));
      Opal.const_set($nesting[0], 'TableCellStyles', $hash2(["d", "s", "e", "m", "h", "l", "a"], {"d": "none", "s": "strong", "e": "emphasis", "m": "monospaced", "h": "header", "l": "literal", "a": "asciidoc"}));
      self.$private_class_method("new");
      Opal.defs(self, '$parse', $Parser_parse$4 = function $$parse(reader, document, options) {
        var $a, $b, $c, self = this, block_attributes = nil, header_only = nil, new_section = nil;

        
        
        if (options == null) {
          options = $hash2([], {});
        };
        block_attributes = self.$parse_document_header(reader, document, (header_only = options['$[]']("header_only")));
        if ($truthy(header_only)) {
        } else {
          while ($truthy(reader['$has_more_lines?']())) {
            
            $c = self.$next_section(reader, document, block_attributes), $b = Opal.to_ary($c), (new_section = ($b[0] == null ? nil : $b[0])), (block_attributes = ($b[1] == null ? nil : $b[1])), $c;
            if ($truthy(new_section)) {
              
              document.$assign_numeral(new_section);
              document.$blocks()['$<<'](new_section);};
          }
        };
        return document;
      }, $Parser_parse$4.$$arity = -3);
      Opal.defs(self, '$parse_document_header', $Parser_parse_document_header$5 = function $$parse_document_header(reader, document, header_only) {
        var $a, $b, self = this, block_attrs = nil, doc_attrs = nil, implicit_doctitle = nil, $writer = nil, val = nil, doctitle_attr_val = nil, source_location = nil, _ = nil, l0_section_title = nil, atx = nil, separator = nil, doc_id = nil, role = nil, reftext = nil, modified_attrs = nil, author = nil, author_metadata = nil;

        
        
        if (header_only == null) {
          header_only = false;
        };
        block_attrs = (function() {if ($truthy(reader.$skip_blank_lines())) {
          
          return self.$parse_block_metadata_lines(reader, document);
        } else {
          return $hash2([], {})
        }; return nil; })();
        doc_attrs = document.$attributes();
        if ($truthy(($truthy($a = (implicit_doctitle = self['$is_next_line_doctitle?'](reader, block_attrs, doc_attrs['$[]']("leveloffset")))) ? block_attrs['$[]']("title") : $a))) {
          
          
          $writer = ["authorcount", 0];
          $send(doc_attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          return document.$finalize_header(block_attrs, false);};
        if ($truthy((val = doc_attrs['$[]']("doctitle"))['$nil_or_empty?']())) {
        } else {
          
          $writer = [(doctitle_attr_val = val)];
          $send(document, 'title=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];
        };
        if ($truthy(implicit_doctitle)) {
          
          if ($truthy(document.$sourcemap())) {
            source_location = reader.$cursor()};
          $b = self.$parse_section_title(reader, document), $a = Opal.to_ary($b), document['$id='](($a[0] == null ? nil : $a[0])), (_ = ($a[1] == null ? nil : $a[1])), (l0_section_title = ($a[2] == null ? nil : $a[2])), (_ = ($a[3] == null ? nil : $a[3])), (atx = ($a[4] == null ? nil : $a[4])), $b;
          if ($truthy(doctitle_attr_val)) {
            l0_section_title = nil
          } else {
            
            
            $writer = [l0_section_title];
            $send(document, 'title=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            if ($truthy((($writer = ["doctitle", (doctitle_attr_val = document.$sub_specialchars(l0_section_title))]), $send(doc_attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])['$include?']($$($nesting, 'ATTR_REF_HEAD')))) {
              
              $writer = ["doctitle", (doctitle_attr_val = document.$sub_attributes(doctitle_attr_val, $hash2(["attribute_missing"], {"attribute_missing": "skip"})))];
              $send(doc_attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
          };
          if ($truthy(source_location)) {
            
            $writer = [source_location];
            $send(document.$header(), 'source_location=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          if ($truthy(($truthy($a = atx) ? $a : document['$attribute_locked?']("compat-mode")))) {
          } else {
            
            $writer = ["compat-mode", ""];
            $send(doc_attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          };
          if ($truthy((separator = block_attrs['$[]']("separator")))) {
            if ($truthy(document['$attribute_locked?']("title-separator"))) {
            } else {
              
              $writer = ["title-separator", separator];
              $send(doc_attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            }};
          if ($truthy((doc_id = block_attrs['$[]']("id")))) {
            
            $writer = [doc_id];
            $send(document, 'id=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          } else {
            doc_id = document.$id()
          };
          if ($truthy((role = block_attrs['$[]']("role")))) {
            
            $writer = ["role", role];
            $send(doc_attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          if ($truthy((reftext = block_attrs['$[]']("reftext")))) {
            
            $writer = ["reftext", reftext];
            $send(doc_attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          block_attrs.$clear();
          (modified_attrs = document.$instance_variable_get("@attributes_modified")).$delete("doctitle");
          self.$parse_header_metadata(reader, document, nil);
          if ($truthy(modified_attrs['$include?']("doctitle"))) {
            if ($truthy(($truthy($a = (val = doc_attrs['$[]']("doctitle"))['$nil_or_empty?']()) ? $a : val['$=='](doctitle_attr_val)))) {
              
              $writer = ["doctitle", doctitle_attr_val];
              $send(doc_attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            } else {
              
              $writer = [val];
              $send(document, 'title=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            }
          } else if ($truthy(l0_section_title['$!']())) {
            modified_attrs['$<<']("doctitle")};
          if ($truthy(doc_id)) {
            document.$register("refs", [doc_id, document])};
        } else if ($truthy((author = doc_attrs['$[]']("author")))) {
          
          author_metadata = self.$process_authors(author, true, false);
          if ($truthy(doc_attrs['$[]']("authorinitials"))) {
            author_metadata.$delete("authorinitials")};
          doc_attrs.$update(author_metadata);
        } else if ($truthy((author = doc_attrs['$[]']("authors")))) {
          
          author_metadata = self.$process_authors(author, true);
          doc_attrs.$update(author_metadata);
        } else {
          
          $writer = ["authorcount", 0];
          $send(doc_attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];
        };
        if (document.$doctype()['$==']("manpage")) {
          self.$parse_manpage_header(reader, document, block_attrs, header_only)};
        return document.$finalize_header(block_attrs);
      }, $Parser_parse_document_header$5.$$arity = -3);
      Opal.defs(self, '$parse_manpage_header', $Parser_parse_manpage_header$6 = function $$parse_manpage_header(reader, document, block_attributes, header_only) {
        var $a, $b, $$7, $$8, self = this, doc_attrs = nil, $writer = nil, manvolnum = nil, mantitle = nil, manname = nil, name_section_level = nil, name_section = nil, name_section_buffer = nil, mannames = nil, manpurpose = nil, error_msg = nil;

        
        
        if (header_only == null) {
          header_only = false;
        };
        if ($truthy($$($nesting, 'ManpageTitleVolnumRx')['$=~']((doc_attrs = document.$attributes())['$[]']("doctitle")))) {
          
          
          $writer = ["manvolnum", (manvolnum = (($a = $gvars['~']) === nil ? nil : $a['$[]'](2)))];
          $send(doc_attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["mantitle", (function() {if ($truthy((mantitle = (($a = $gvars['~']) === nil ? nil : $a['$[]'](1)))['$include?']($$($nesting, 'ATTR_REF_HEAD')))) {
            
            return document.$sub_attributes(mantitle);
          } else {
            return mantitle
          }; return nil; })().$downcase()];
          $send(doc_attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
        } else {
          
          self.$logger().$error(self.$message_with_context("non-conforming manpage title", $hash2(["source_location"], {"source_location": reader.$cursor_at_line(1)})));
          
          $writer = ["mantitle", ($truthy($a = ($truthy($b = doc_attrs['$[]']("doctitle")) ? $b : doc_attrs['$[]']("docname"))) ? $a : "command")];
          $send(doc_attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["manvolnum", (manvolnum = "1")];
          $send(doc_attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
        };
        if ($truthy(($truthy($a = (manname = doc_attrs['$[]']("manname"))) ? doc_attrs['$[]']("manpurpose") : $a))) {
          
          ($truthy($a = doc_attrs['$[]']("manname-title")) ? $a : (($writer = ["manname-title", "Name"]), $send(doc_attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
          
          $writer = ["mannames", [manname]];
          $send(doc_attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          if (document.$backend()['$==']("manpage")) {
            
            
            $writer = ["docname", manname];
            $send(doc_attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            
            $writer = ["outfilesuffix", "" + "." + (manvolnum)];
            $send(doc_attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;};
        } else if ($truthy(header_only)) {
        } else {
          
          reader.$skip_blank_lines();
          reader.$save();
          block_attributes.$update(self.$parse_block_metadata_lines(reader, document));
          if ($truthy((name_section_level = self['$is_next_line_section?'](reader, $hash2([], {}))))) {
            if (name_section_level['$=='](1)) {
              
              name_section = self.$initialize_section(reader, document, $hash2([], {}));
              name_section_buffer = $send(reader.$read_lines_until($hash2(["break_on_blank_lines", "skip_line_comments"], {"break_on_blank_lines": true, "skip_line_comments": true})), 'map', [], ($$7 = function(l){var self = $$7.$$s || this;

              
                
                if (l == null) {
                  l = nil;
                };
                return l.$lstrip();}, $$7.$$s = self, $$7.$$arity = 1, $$7)).$join(" ");
              if ($truthy($$($nesting, 'ManpageNamePurposeRx')['$=~'](name_section_buffer))) {
                
                if ($truthy((manname = (($a = $gvars['~']) === nil ? nil : $a['$[]'](1)))['$include?']($$($nesting, 'ATTR_REF_HEAD')))) {
                  manname = document.$sub_attributes(manname)};
                if ($truthy(manname['$include?'](","))) {
                  manname = (mannames = $send(manname.$split(","), 'map', [], ($$8 = function(n){var self = $$8.$$s || this;

                  
                    
                    if (n == null) {
                      n = nil;
                    };
                    return n.$lstrip();}, $$8.$$s = self, $$8.$$arity = 1, $$8)))['$[]'](0)
                } else {
                  mannames = [manname]
                };
                if ($truthy((manpurpose = (($a = $gvars['~']) === nil ? nil : $a['$[]'](2)))['$include?']($$($nesting, 'ATTR_REF_HEAD')))) {
                  manpurpose = document.$sub_attributes(manpurpose)};
                ($truthy($a = doc_attrs['$[]']("manname-title")) ? $a : (($writer = ["manname-title", name_section.$title()]), $send(doc_attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
                if ($truthy(name_section.$id())) {
                  
                  $writer = ["manname-id", name_section.$id()];
                  $send(doc_attrs, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];};
                
                $writer = ["manname", manname];
                $send(doc_attrs, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                
                $writer = ["mannames", mannames];
                $send(doc_attrs, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                
                $writer = ["manpurpose", manpurpose];
                $send(doc_attrs, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                if (document.$backend()['$==']("manpage")) {
                  
                  
                  $writer = ["docname", manname];
                  $send(doc_attrs, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];;
                  
                  $writer = ["outfilesuffix", "" + "." + (manvolnum)];
                  $send(doc_attrs, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];;};
              } else {
                error_msg = "non-conforming name section body"
              };
            } else {
              error_msg = "name section must be at level 1"
            }
          } else {
            error_msg = "name section expected"
          };
          if ($truthy(error_msg)) {
            
            reader.$restore_save();
            self.$logger().$error(self.$message_with_context(error_msg, $hash2(["source_location"], {"source_location": reader.$cursor()})));
            
            $writer = ["manname", (manname = ($truthy($a = doc_attrs['$[]']("docname")) ? $a : "command"))];
            $send(doc_attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            
            $writer = ["mannames", [manname]];
            $send(doc_attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            if (document.$backend()['$==']("manpage")) {
              
              
              $writer = ["docname", manname];
              $send(doc_attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              
              $writer = ["outfilesuffix", "" + "." + (manvolnum)];
              $send(doc_attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;};
          } else {
            reader.$discard_save()
          };
        };
        return nil;
      }, $Parser_parse_manpage_header$6.$$arity = -4);
      Opal.defs(self, '$next_section', $Parser_next_section$9 = function $$next_section(reader, parent, attributes) {
        var $a, $b, $c, $d, self = this, preamble = nil, intro = nil, part = nil, has_header = nil, book = nil, document = nil, $writer = nil, section = nil, current_level = nil, expected_next_level = nil, expected_next_level_alt = nil, title = nil, sectname = nil, next_level = nil, expected_condition = nil, new_section = nil, block_cursor = nil, new_block = nil, first_block = nil, child_block = nil;

        
        
        if (attributes == null) {
          attributes = $hash2([], {});
        };
        preamble = (intro = (part = false));
        if ($truthy(($truthy($a = (($b = parent.$context()['$==']("document")) ? parent.$blocks()['$empty?']() : parent.$context()['$==']("document"))) ? ($truthy($b = ($truthy($c = (has_header = parent['$header?']())) ? $c : attributes.$delete("invalid-header"))) ? $b : self['$is_next_line_section?'](reader, attributes)['$!']()) : $a))) {
          
          book = (document = parent).$doctype()['$==']("book");
          if ($truthy(($truthy($a = has_header) ? $a : ($truthy($b = book) ? attributes['$[]'](1)['$!=']("abstract") : $b)))) {
            
            preamble = (intro = $$($nesting, 'Block').$new(parent, "preamble", $hash2(["content_model"], {"content_model": "compound"})));
            if ($truthy(($truthy($a = book) ? parent['$attr?']("preface-title") : $a))) {
              
              $writer = [parent.$attr("preface-title")];
              $send(preamble, 'title=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
            parent.$blocks()['$<<'](preamble);};
          section = parent;
          current_level = 0;
          if ($truthy(parent.$attributes()['$key?']("fragment"))) {
            expected_next_level = -1
          } else if ($truthy(book)) {
            $a = [1, 0], (expected_next_level = $a[0]), (expected_next_level_alt = $a[1]), $a
          } else {
            expected_next_level = 1
          };
        } else {
          
          book = (document = parent.$document()).$doctype()['$==']("book");
          section = self.$initialize_section(reader, parent, attributes);
          attributes = (function() {if ($truthy((title = attributes['$[]']("title")))) {
            return $hash2(["title"], {"title": title})
          } else {
            return $hash2([], {})
          }; return nil; })();
          expected_next_level = $rb_plus((current_level = section.$level()), 1);
          if (current_level['$=='](0)) {
            part = book
          } else if ($truthy((($a = current_level['$=='](1)) ? section.$special() : current_level['$=='](1)))) {
            if ($truthy(($truthy($a = ($truthy($b = (sectname = section.$sectname())['$==']("appendix")) ? $b : sectname['$==']("preface"))) ? $a : sectname['$==']("abstract")))) {
            } else {
              expected_next_level = nil
            }};
        };
        reader.$skip_blank_lines();
        while ($truthy(reader['$has_more_lines?']())) {
          
          self.$parse_block_metadata_lines(reader, document, attributes);
          if ($truthy((next_level = self['$is_next_line_section?'](reader, attributes)))) {
            
            if ($truthy(document['$attr?']("leveloffset"))) {
              
              next_level = $rb_plus(next_level, document.$attr("leveloffset").$to_i());
              if ($truthy($rb_lt(next_level, 0))) {
                next_level = 0};};
            if ($truthy($rb_gt(next_level, current_level))) {
              
              if ($truthy(expected_next_level)) {
                if ($truthy(($truthy($b = ($truthy($c = next_level['$=='](expected_next_level)) ? $c : ($truthy($d = expected_next_level_alt) ? next_level['$=='](expected_next_level_alt) : $d))) ? $b : $rb_lt(expected_next_level, 0)))) {
                } else {
                  
                  expected_condition = (function() {if ($truthy(expected_next_level_alt)) {
                    return "" + "expected levels " + (expected_next_level_alt) + " or " + (expected_next_level)
                  } else {
                    return "" + "expected level " + (expected_next_level)
                  }; return nil; })();
                  self.$logger().$warn(self.$message_with_context("" + "section title out of sequence: " + (expected_condition) + ", got level " + (next_level), $hash2(["source_location"], {"source_location": reader.$cursor()})));
                }
              } else {
                self.$logger().$error(self.$message_with_context("" + (sectname) + " sections do not support nested sections", $hash2(["source_location"], {"source_location": reader.$cursor()})))
              };
              $c = self.$next_section(reader, section, attributes), $b = Opal.to_ary($c), (new_section = ($b[0] == null ? nil : $b[0])), (attributes = ($b[1] == null ? nil : $b[1])), $c;
              section.$assign_numeral(new_section);
              section.$blocks()['$<<'](new_section);
            } else if ($truthy((($b = next_level['$=='](0)) ? section['$=='](document) : next_level['$=='](0)))) {
              
              if ($truthy(book)) {
              } else {
                self.$logger().$error(self.$message_with_context("level 0 sections can only be used when doctype is book", $hash2(["source_location"], {"source_location": reader.$cursor()})))
              };
              $c = self.$next_section(reader, section, attributes), $b = Opal.to_ary($c), (new_section = ($b[0] == null ? nil : $b[0])), (attributes = ($b[1] == null ? nil : $b[1])), $c;
              section.$assign_numeral(new_section);
              section.$blocks()['$<<'](new_section);
            } else {
              break;
            };
          } else {
            
            block_cursor = reader.$cursor();
            if ($truthy((new_block = self.$next_block(reader, ($truthy($b = intro) ? $b : section), attributes, $hash2(["parse_metadata"], {"parse_metadata": false}))))) {
              
              if ($truthy(part)) {
                if ($truthy(section['$blocks?']()['$!']())) {
                  if ($truthy(new_block.$style()['$!=']("partintro"))) {
                    if (new_block.$context()['$==']("paragraph")) {
                      
                      
                      $writer = ["open"];
                      $send(new_block, 'context=', Opal.to_a($writer));
                      $writer[$rb_minus($writer["length"], 1)];;
                      
                      $writer = ["partintro"];
                      $send(new_block, 'style=', Opal.to_a($writer));
                      $writer[$rb_minus($writer["length"], 1)];;
                    } else {
                      
                      
                      $writer = [(intro = $$($nesting, 'Block').$new(section, "open", $hash2(["content_model"], {"content_model": "compound"})))];
                      $send(new_block, 'parent=', Opal.to_a($writer));
                      $writer[$rb_minus($writer["length"], 1)];;
                      
                      $writer = ["partintro"];
                      $send(intro, 'style=', Opal.to_a($writer));
                      $writer[$rb_minus($writer["length"], 1)];;
                      section.$blocks()['$<<'](intro);
                    }}
                } else if (section.$blocks().$size()['$=='](1)) {
                  
                  first_block = section.$blocks()['$[]'](0);
                  if ($truthy(($truthy($b = intro['$!']()) ? first_block.$content_model()['$==']("compound") : $b))) {
                    self.$logger().$error(self.$message_with_context("illegal block content outside of partintro block", $hash2(["source_location"], {"source_location": block_cursor})))
                  } else if ($truthy(first_block.$content_model()['$!=']("compound"))) {
                    
                    
                    $writer = [(intro = $$($nesting, 'Block').$new(section, "open", $hash2(["content_model"], {"content_model": "compound"})))];
                    $send(new_block, 'parent=', Opal.to_a($writer));
                    $writer[$rb_minus($writer["length"], 1)];;
                    
                    $writer = ["partintro"];
                    $send(intro, 'style=', Opal.to_a($writer));
                    $writer[$rb_minus($writer["length"], 1)];;
                    section.$blocks().$shift();
                    if (first_block.$style()['$==']("partintro")) {
                      
                      
                      $writer = ["paragraph"];
                      $send(first_block, 'context=', Opal.to_a($writer));
                      $writer[$rb_minus($writer["length"], 1)];;
                      
                      $writer = [nil];
                      $send(first_block, 'style=', Opal.to_a($writer));
                      $writer[$rb_minus($writer["length"], 1)];;};
                    intro['$<<'](first_block);
                    section.$blocks()['$<<'](intro);};}};
              ($truthy($b = intro) ? $b : section).$blocks()['$<<'](new_block);
              attributes.$clear();};
          };
          if ($truthy($b = reader.$skip_blank_lines())) {
            $b
          } else {
            break;
          };
        };
        if ($truthy(part)) {
          if ($truthy(($truthy($a = section['$blocks?']()) ? section.$blocks()['$[]'](-1).$context()['$==']("section") : $a))) {
          } else {
            self.$logger().$error(self.$message_with_context("invalid part, must have at least one section (e.g., chapter, appendix, etc.)", $hash2(["source_location"], {"source_location": reader.$cursor()})))
          }
        } else if ($truthy(preamble)) {
          if ($truthy(preamble['$blocks?']())) {
            if ($truthy(($truthy($a = ($truthy($b = book) ? $b : document.$blocks()['$[]'](1))) ? $a : $$($nesting, 'Compliance').$unwrap_standalone_preamble()['$!']()))) {
              if ($truthy(document.$sourcemap())) {
                
                $writer = [preamble.$blocks()['$[]'](0).$source_location()];
                $send(preamble, 'source_location=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];}
            } else {
              
              document.$blocks().$shift();
              while ($truthy((child_block = preamble.$blocks().$shift()))) {
                document['$<<'](child_block)
              };
            }
          } else {
            document.$blocks().$shift()
          }};
        return [(function() {if (section['$=='](parent)) {
          return nil
        } else {
          return section
        }; return nil; })(), attributes.$merge()];
      }, $Parser_next_section$9.$$arity = -3);
      Opal.defs(self, '$next_block', $Parser_next_block$10 = function $$next_block(reader, parent, attributes, options) {try {

        var $a, $b, $c, $d, $$11, $$12, $$13, self = this, skipped = nil, text_only = nil, document = nil, extensions = nil, block_extensions = nil, block_macro_extensions = nil, this_line = nil, doc_attrs = nil, style = nil, block = nil, block_context = nil, cloaked_context = nil, terminator = nil, delimited_block = nil, $writer = nil, indented = nil, md_syntax = nil, ch0 = nil, layout_break_chars = nil, ll = nil, blk_ctx = nil, target = nil, blk_attrs = nil, $case = nil, posattrs = nil, expanded_target = nil, scaledwidth = nil, block_title = nil, extension = nil, report_unknown_block_macro = nil, content = nil, ext_config = nil, default_attrs = nil, float_id = nil, float_reftext = nil, float_level = nil, lines = nil, content_adjacent = nil, admonition_name = nil, credit_line = nil, attribution = nil, citetitle = nil, language = nil, comma_idx = nil, block_cursor = nil, block_reader = nil, content_model = nil, positional_attrs = nil, block_id = nil;
        if ($gvars["~"] == null) $gvars["~"] = nil;

        
        
        if (attributes == null) {
          attributes = $hash2([], {});
        };
        
        if (options == null) {
          options = $hash2([], {});
        };
        if ($truthy((skipped = reader.$skip_blank_lines()))) {
        } else {
          return nil
        };
        if ($truthy(($truthy($a = (text_only = options['$[]']("text_only"))) ? $rb_gt(skipped, 0) : $a))) {
          
          options.$delete("text_only");
          text_only = nil;};
        document = parent.$document();
        if ($truthy(options.$fetch("parse_metadata", true))) {
          while ($truthy(self.$parse_block_metadata_line(reader, document, attributes, options))) {
            
            reader.$shift();
            ($truthy($b = reader.$skip_blank_lines()) ? $b : Opal.ret(nil));
          }};
        if ($truthy((extensions = document.$extensions()))) {
          $a = [extensions['$blocks?'](), extensions['$block_macros?']()], (block_extensions = $a[0]), (block_macro_extensions = $a[1]), $a};
        reader.$mark();
        $a = [reader.$read_line(), document.$attributes(), attributes['$[]'](1)], (this_line = $a[0]), (doc_attrs = $a[1]), (style = $a[2]), $a;
        block = (block_context = (cloaked_context = (terminator = nil)));
        if ($truthy((delimited_block = self['$is_delimited_block?'](this_line, true)))) {
          
          block_context = (cloaked_context = delimited_block.$context());
          terminator = delimited_block.$terminator();
          if ($truthy(style)) {
            if (style['$=='](block_context.$to_s())) {
            } else if ($truthy(delimited_block.$masq()['$include?'](style))) {
              block_context = style.$to_sym()
            } else if ($truthy(($truthy($a = delimited_block.$masq()['$include?']("admonition")) ? $$($nesting, 'ADMONITION_STYLES')['$include?'](style) : $a))) {
              block_context = "admonition"
            } else if ($truthy(($truthy($a = block_extensions) ? extensions['$registered_for_block?'](style, block_context) : $a))) {
              block_context = style.$to_sym()
            } else {
              
              if ($truthy(self.$logger()['$debug?']())) {
                self.$logger().$debug(self.$message_with_context("" + "unknown style for " + (block_context) + " block: " + (style), $hash2(["source_location"], {"source_location": reader.$cursor_at_mark()})))};
              style = block_context.$to_s();
            }
          } else {
            style = (($writer = ["style", block_context.$to_s()]), $send(attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])
          };};
        if ($truthy(delimited_block)) {
        } else {
          while ($truthy(true)) {
            
            if ($truthy(($truthy($b = ($truthy($c = style) ? $$($nesting, 'Compliance').$strict_verbatim_paragraphs() : $c)) ? $$($nesting, 'VERBATIM_STYLES')['$include?'](style) : $b))) {
              
              block_context = style.$to_sym();
              reader.$unshift_line(this_line);
              break;;};
            if ($truthy(text_only)) {
              indented = this_line['$start_with?'](" ", $$($nesting, 'TAB'))
            } else {
              
              md_syntax = $$($nesting, 'Compliance').$markdown_syntax();
              if ($truthy(this_line['$start_with?'](" "))) {
                
                $b = [true, " "], (indented = $b[0]), (ch0 = $b[1]), $b;
                if ($truthy(($truthy($b = ($truthy($c = md_syntax) ? $send(this_line.$lstrip(), 'start_with?', Opal.to_a($$($nesting, 'MARKDOWN_THEMATIC_BREAK_CHARS').$keys())) : $c)) ? $$($nesting, 'MarkdownThematicBreakRx')['$match?'](this_line) : $b))) {
                  
                  block = $$($nesting, 'Block').$new(parent, "thematic_break", $hash2(["content_model"], {"content_model": "empty"}));
                  break;;};
              } else if ($truthy(this_line['$start_with?']($$($nesting, 'TAB')))) {
                $b = [true, $$($nesting, 'TAB')], (indented = $b[0]), (ch0 = $b[1]), $b
              } else {
                
                $b = [false, this_line.$chr()], (indented = $b[0]), (ch0 = $b[1]), $b;
                layout_break_chars = (function() {if ($truthy(md_syntax)) {
                  return $$($nesting, 'HYBRID_LAYOUT_BREAK_CHARS')
                } else {
                  return $$($nesting, 'LAYOUT_BREAK_CHARS')
                }; return nil; })();
                if ($truthy(($truthy($b = layout_break_chars['$key?'](ch0)) ? (function() {if ($truthy(md_syntax)) {
                  
                  return $$($nesting, 'ExtLayoutBreakRx')['$match?'](this_line);
                } else {
                  return ($truthy($c = self['$uniform?'](this_line, ch0, (ll = this_line.$length()))) ? $rb_gt(ll, 2) : $c)
                }; return nil; })() : $b))) {
                  
                  block = $$($nesting, 'Block').$new(parent, layout_break_chars['$[]'](ch0), $hash2(["content_model"], {"content_model": "empty"}));
                  break;;
                } else if ($truthy(($truthy($b = this_line['$end_with?']("]")) ? this_line['$include?']("::") : $b))) {
                  if ($truthy(($truthy($b = ($truthy($c = ch0['$==']("i")) ? $c : this_line['$start_with?']("video:", "audio:"))) ? $$($nesting, 'BlockMediaMacroRx')['$=~'](this_line) : $b))) {
                    
                    $b = [(($c = $gvars['~']) === nil ? nil : $c['$[]'](1)).$to_sym(), (($c = $gvars['~']) === nil ? nil : $c['$[]'](2)), (($c = $gvars['~']) === nil ? nil : $c['$[]'](3))], (blk_ctx = $b[0]), (target = $b[1]), (blk_attrs = $b[2]), $b;
                    block = $$($nesting, 'Block').$new(parent, blk_ctx, $hash2(["content_model"], {"content_model": "empty"}));
                    if ($truthy(blk_attrs)) {
                      
                      $case = blk_ctx;
                      if ("video"['$===']($case)) {posattrs = ["poster", "width", "height"]}
                      else if ("audio"['$===']($case)) {posattrs = []}
                      else {posattrs = ["alt", "width", "height"]};
                      block.$parse_attributes(blk_attrs, posattrs, $hash2(["sub_input", "into"], {"sub_input": true, "into": attributes}));};
                    if ($truthy(attributes['$key?']("style"))) {
                      attributes.$delete("style")};
                    if ($truthy(target['$include?']($$($nesting, 'ATTR_REF_HEAD')))) {
                      if ($truthy(($truthy($b = ($truthy($c = (expanded_target = block.$sub_attributes(target))['$empty?']()) ? ($truthy($d = doc_attrs['$[]']("attribute-missing")) ? $d : $$($nesting, 'Compliance').$attribute_missing())['$==']("drop-line") : $c)) ? block.$sub_attributes($rb_plus(target, " "), $hash2(["attribute_missing", "drop_line_severity"], {"attribute_missing": "drop-line", "drop_line_severity": "ignore"}))['$empty?']() : $b))) {
                        
                        attributes.$clear();
                        return nil;
                      } else {
                        target = expanded_target
                      }};
                    if (blk_ctx['$==']("image")) {
                      
                      document.$register("images", target);
                      
                      $writer = ["imagesdir", doc_attrs['$[]']("imagesdir")];
                      $send(attributes, '[]=', Opal.to_a($writer));
                      $writer[$rb_minus($writer["length"], 1)];;
                      ($truthy($b = attributes['$[]']("alt")) ? $b : (($writer = ["alt", ($truthy($c = style) ? $c : (($writer = ["default-alt", $$($nesting, 'Helpers').$basename(target, true).$tr("_-", " ")]), $send(attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))]), $send(attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
                      if ($truthy((scaledwidth = attributes.$delete("scaledwidth"))['$nil_or_empty?']())) {
                      } else {
                        
                        $writer = ["scaledwidth", (function() {if ($truthy($$($nesting, 'TrailingDigitsRx')['$match?'](scaledwidth))) {
                          return "" + (scaledwidth) + "%"
                        } else {
                          return scaledwidth
                        }; return nil; })()];
                        $send(attributes, '[]=', Opal.to_a($writer));
                        $writer[$rb_minus($writer["length"], 1)];
                      };
                      if ($truthy(attributes['$[]']("title"))) {
                        
                        
                        $writer = [(block_title = attributes.$delete("title"))];
                        $send(block, 'title=', Opal.to_a($writer));
                        $writer[$rb_minus($writer["length"], 1)];;
                        block.$assign_caption(attributes.$delete("caption"), "figure");};};
                    
                    $writer = ["target", target];
                    $send(attributes, '[]=', Opal.to_a($writer));
                    $writer[$rb_minus($writer["length"], 1)];;
                    break;;
                  } else if ($truthy(($truthy($b = (($c = ch0['$==']("t")) ? this_line['$start_with?']("toc:") : ch0['$==']("t"))) ? $$($nesting, 'BlockTocMacroRx')['$=~'](this_line) : $b))) {
                    
                    block = $$($nesting, 'Block').$new(parent, "toc", $hash2(["content_model"], {"content_model": "empty"}));
                    if ($truthy((($b = $gvars['~']) === nil ? nil : $b['$[]'](1)))) {
                      block.$parse_attributes((($b = $gvars['~']) === nil ? nil : $b['$[]'](1)), [], $hash2(["into"], {"into": attributes}))};
                    break;;
                  } else if ($truthy((function() {if ($truthy(block_macro_extensions)) {
                    
                    return ($truthy($b = ($truthy($c = $$($nesting, 'CustomBlockMacroRx')['$=~'](this_line)) ? (extension = extensions['$registered_for_block_macro?']((($d = $gvars['~']) === nil ? nil : $d['$[]'](1)))) : $c)) ? $b : (report_unknown_block_macro = self.$logger()['$debug?']()));
                  } else {
                    
                    return ($truthy($b = self.$logger()['$debug?']()) ? (report_unknown_block_macro = $$($nesting, 'CustomBlockMacroRx')['$=~'](this_line)) : $b);
                  }; return nil; })())) {
                    if ($truthy(report_unknown_block_macro)) {
                      self.$logger().$debug(self.$message_with_context("" + "unknown name for block macro: " + ((($b = $gvars['~']) === nil ? nil : $b['$[]'](1))), $hash2(["source_location"], {"source_location": reader.$cursor_at_mark()})))
                    } else {
                      
                      content = (($b = $gvars['~']) === nil ? nil : $b['$[]'](3));
                      if ($truthy((target = (($b = $gvars['~']) === nil ? nil : $b['$[]'](2)))['$include?']($$($nesting, 'ATTR_REF_HEAD')))) {
                        if ($truthy(($truthy($b = ($truthy($c = (expanded_target = parent.$sub_attributes(target))['$empty?']()) ? ($truthy($d = doc_attrs['$[]']("attribute-missing")) ? $d : $$($nesting, 'Compliance').$attribute_missing())['$==']("drop-line") : $c)) ? parent.$sub_attributes($rb_plus(target, " "), $hash2(["attribute_missing", "drop_line_severity"], {"attribute_missing": "drop-line", "drop_line_severity": "ignore"}))['$empty?']() : $b))) {
                          
                          attributes.$clear();
                          return nil;
                        } else {
                          target = expanded_target
                        }};
                      if ((ext_config = extension.$config())['$[]']("content_model")['$==']("attributes")) {
                        if ($truthy(content)) {
                          document.$parse_attributes(content, ($truthy($b = ($truthy($c = ext_config['$[]']("positional_attrs")) ? $c : ext_config['$[]']("pos_attrs"))) ? $b : []), $hash2(["sub_input", "into"], {"sub_input": true, "into": attributes}))}
                      } else {
                        
                        $writer = ["text", ($truthy($b = content) ? $b : "")];
                        $send(attributes, '[]=', Opal.to_a($writer));
                        $writer[$rb_minus($writer["length"], 1)];
                      };
                      if ($truthy((default_attrs = ext_config['$[]']("default_attrs")))) {
                        $send(attributes, 'update', [default_attrs], ($$11 = function(_, old_v){var self = $$11.$$s || this;

                        
                          
                          if (_ == null) {
                            _ = nil;
                          };
                          
                          if (old_v == null) {
                            old_v = nil;
                          };
                          return old_v;}, $$11.$$s = self, $$11.$$arity = 2, $$11))};
                      if ($truthy(($truthy($b = (block = extension.$process_method()['$[]'](parent, target, attributes))) ? block['$!='](parent) : $b))) {
                        
                        attributes.$replace(block.$attributes());
                        break;;
                      } else {
                        
                        attributes.$clear();
                        return nil;
                      };
                    }}};
              };
            };
            if ($truthy(($truthy($b = ($truthy($c = indented['$!']()) ? (ch0 = ($truthy($d = ch0) ? $d : this_line.$chr()))['$==']("<") : $c)) ? $$($nesting, 'CalloutListRx')['$=~'](this_line) : $b))) {
              
              reader.$unshift_line(this_line);
              block = self.$parse_callout_list(reader, $gvars["~"], parent, document.$callouts());
              
              $writer = ["style", "arabic"];
              $send(attributes, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              break;;
            } else if ($truthy($$($nesting, 'UnorderedListRx')['$match?'](this_line))) {
              
              reader.$unshift_line(this_line);
              if ($truthy(($truthy($b = ($truthy($c = style['$!']()) ? $$($nesting, 'Section')['$==='](parent) : $c)) ? parent.$sectname()['$==']("bibliography") : $b))) {
                
                $writer = ["style", (style = "bibliography")];
                $send(attributes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];};
              block = self.$parse_list(reader, "ulist", parent, style);
              break;;
            } else if ($truthy($$($nesting, 'OrderedListRx')['$match?'](this_line))) {
              
              reader.$unshift_line(this_line);
              block = self.$parse_list(reader, "olist", parent, style);
              if ($truthy(block.$style())) {
                
                $writer = ["style", block.$style()];
                $send(attributes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];};
              break;;
            } else if ($truthy(($truthy($b = ($truthy($c = this_line['$include?']("::")) ? $c : this_line['$include?'](";;"))) ? $$($nesting, 'DescriptionListRx')['$=~'](this_line) : $b))) {
              
              reader.$unshift_line(this_line);
              block = self.$parse_description_list(reader, $gvars["~"], parent);
              break;;
            } else if ($truthy(($truthy($b = ($truthy($c = style['$==']("float")) ? $c : style['$==']("discrete"))) ? (function() {if ($truthy($$($nesting, 'Compliance').$underline_style_section_titles())) {
              
              return self['$is_section_title?'](this_line, reader.$peek_line());
            } else {
              return ($truthy($c = indented['$!']()) ? self['$atx_section_title?'](this_line) : $c)
            }; return nil; })() : $b))) {
              
              reader.$unshift_line(this_line);
              $c = self.$parse_section_title(reader, document, attributes['$[]']("id")), $b = Opal.to_ary($c), (float_id = ($b[0] == null ? nil : $b[0])), (float_reftext = ($b[1] == null ? nil : $b[1])), (block_title = ($b[2] == null ? nil : $b[2])), (float_level = ($b[3] == null ? nil : $b[3])), $c;
              if ($truthy(float_reftext)) {
                
                $writer = ["reftext", float_reftext];
                $send(attributes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];};
              block = $$($nesting, 'Block').$new(parent, "floating_title", $hash2(["content_model"], {"content_model": "empty"}));
              
              $writer = [block_title];
              $send(block, 'title=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              attributes.$delete("title");
              
              $writer = [($truthy($b = float_id) ? $b : (function() {if ($truthy(doc_attrs['$key?']("sectids"))) {
                
                return $$($nesting, 'Section').$generate_id(block.$title(), document);
              } else {
                return nil
              }; return nil; })())];
              $send(block, 'id=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              
              $writer = [float_level];
              $send(block, 'level=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              break;;
            } else if ($truthy(($truthy($b = style) ? style['$!=']("normal") : $b))) {
              if ($truthy($$($nesting, 'PARAGRAPH_STYLES')['$include?'](style))) {
                
                block_context = style.$to_sym();
                cloaked_context = "paragraph";
                reader.$unshift_line(this_line);
                break;;
              } else if ($truthy($$($nesting, 'ADMONITION_STYLES')['$include?'](style))) {
                
                block_context = "admonition";
                cloaked_context = "paragraph";
                reader.$unshift_line(this_line);
                break;;
              } else if ($truthy(($truthy($b = block_extensions) ? extensions['$registered_for_block?'](style, "paragraph") : $b))) {
                
                block_context = style.$to_sym();
                cloaked_context = "paragraph";
                reader.$unshift_line(this_line);
                break;;
              } else {
                
                if ($truthy(self.$logger()['$debug?']())) {
                  self.$logger().$debug(self.$message_with_context("" + "unknown style for paragraph: " + (style), $hash2(["source_location"], {"source_location": reader.$cursor_at_mark()})))};
                style = nil;
              }};
            reader.$unshift_line(this_line);
            if ($truthy(($truthy($b = indented) ? style['$!']() : $b))) {
              
              lines = self.$read_paragraph_lines(reader, (content_adjacent = (function() {if (skipped['$=='](0)) {
                return options['$[]']("list_type")
              } else {
                return nil
              }; return nil; })()), $hash2(["skip_line_comments"], {"skip_line_comments": text_only}));
              self['$adjust_indentation!'](lines);
              if ($truthy(($truthy($b = text_only) ? $b : content_adjacent['$==']("dlist")))) {
                block = $$($nesting, 'Block').$new(parent, "paragraph", $hash2(["content_model", "source", "attributes"], {"content_model": "simple", "source": lines, "attributes": attributes}))
              } else {
                block = $$($nesting, 'Block').$new(parent, "literal", $hash2(["content_model", "source", "attributes"], {"content_model": "verbatim", "source": lines, "attributes": attributes}))
              };
            } else {
              
              lines = self.$read_paragraph_lines(reader, (($b = skipped['$=='](0)) ? options['$[]']("list_type") : skipped['$=='](0)), $hash2(["skip_line_comments"], {"skip_line_comments": true}));
              if ($truthy(text_only)) {
                
                if ($truthy(($truthy($b = indented) ? style['$==']("normal") : $b))) {
                  self['$adjust_indentation!'](lines)};
                block = $$($nesting, 'Block').$new(parent, "paragraph", $hash2(["content_model", "source", "attributes"], {"content_model": "simple", "source": lines, "attributes": attributes}));
              } else if ($truthy(($truthy($b = ($truthy($c = $$($nesting, 'ADMONITION_STYLE_HEADS')['$include?'](ch0)) ? this_line['$include?'](":") : $c)) ? $$($nesting, 'AdmonitionParagraphRx')['$=~'](this_line) : $b))) {
                
                
                $writer = [0, (($b = $gvars['~']) === nil ? nil : $b.$post_match())];
                $send(lines, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                
                $writer = ["name", (admonition_name = (($writer = ["style", (($b = $gvars['~']) === nil ? nil : $b['$[]'](1))]), $send(attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]).$downcase())];
                $send(attributes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                
                $writer = ["textlabel", ($truthy($b = attributes.$delete("caption")) ? $b : doc_attrs['$[]']("" + (admonition_name) + "-caption"))];
                $send(attributes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                block = $$($nesting, 'Block').$new(parent, "admonition", $hash2(["content_model", "source", "attributes"], {"content_model": "simple", "source": lines, "attributes": attributes}));
              } else if ($truthy(($truthy($b = ($truthy($c = md_syntax) ? ch0['$=='](">") : $c)) ? this_line['$start_with?']("> ") : $b))) {
                
                $send(lines, 'map!', [], ($$12 = function(line){var self = $$12.$$s || this;

                
                  
                  if (line == null) {
                    line = nil;
                  };
                  if (line['$=='](">")) {
                    
                    return line.$slice(1, line.$length());
                  } else {
                    
                    if ($truthy(line['$start_with?']("> "))) {
                      
                      return line.$slice(2, line.$length());
                    } else {
                      return line
                    };
                  };}, $$12.$$s = self, $$12.$$arity = 1, $$12));
                if ($truthy(lines['$[]'](-1)['$start_with?']("-- "))) {
                  
                  credit_line = (credit_line = lines.$pop()).$slice(3, credit_line.$length());
                  if ($truthy(lines['$empty?']())) {
                  } else {
                    while ($truthy(lines['$[]'](-1)['$empty?']())) {
                      lines.$pop()
                    }
                  };};
                
                $writer = ["style", "quote"];
                $send(attributes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                block = self.$build_block("quote", "compound", false, parent, $$($nesting, 'Reader').$new(lines), attributes);
                if ($truthy(credit_line)) {
                  
                  $c = block.$apply_subs(credit_line).$split(", ", 2), $b = Opal.to_ary($c), (attribution = ($b[0] == null ? nil : $b[0])), (citetitle = ($b[1] == null ? nil : $b[1])), $c;
                  if ($truthy(attribution)) {
                    
                    $writer = ["attribution", attribution];
                    $send(attributes, '[]=', Opal.to_a($writer));
                    $writer[$rb_minus($writer["length"], 1)];};
                  if ($truthy(citetitle)) {
                    
                    $writer = ["citetitle", citetitle];
                    $send(attributes, '[]=', Opal.to_a($writer));
                    $writer[$rb_minus($writer["length"], 1)];};};
              } else if ($truthy(($truthy($b = ($truthy($c = (($d = ch0['$==']("\"")) ? $rb_gt(lines.$size(), 1) : ch0['$==']("\""))) ? lines['$[]'](-1)['$start_with?']("-- ") : $c)) ? lines['$[]'](-2)['$end_with?']("\"") : $b))) {
                
                
                $writer = [0, this_line.$slice(1, this_line.$length())];
                $send(lines, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                credit_line = (credit_line = lines.$pop()).$slice(3, credit_line.$length());
                while ($truthy(lines['$[]'](-1)['$empty?']())) {
                  lines.$pop()
                };
                lines['$<<'](lines.$pop().$chop());
                
                $writer = ["style", "quote"];
                $send(attributes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                block = $$($nesting, 'Block').$new(parent, "quote", $hash2(["content_model", "source", "attributes"], {"content_model": "simple", "source": lines, "attributes": attributes}));
                $c = block.$apply_subs(credit_line).$split(", ", 2), $b = Opal.to_ary($c), (attribution = ($b[0] == null ? nil : $b[0])), (citetitle = ($b[1] == null ? nil : $b[1])), $c;
                if ($truthy(attribution)) {
                  
                  $writer = ["attribution", attribution];
                  $send(attributes, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];};
                if ($truthy(citetitle)) {
                  
                  $writer = ["citetitle", citetitle];
                  $send(attributes, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];};
              } else {
                
                if ($truthy(($truthy($b = indented) ? style['$==']("normal") : $b))) {
                  self['$adjust_indentation!'](lines)};
                block = $$($nesting, 'Block').$new(parent, "paragraph", $hash2(["content_model", "source", "attributes"], {"content_model": "simple", "source": lines, "attributes": attributes}));
              };
              self.$catalog_inline_anchors(lines.$join($$($nesting, 'LF')), block, document, reader);
            };
            break;;
          }
        };
        if ($truthy(block)) {
        } else {
          $case = block_context;
          if ("listing"['$===']($case) || "source"['$===']($case)) {
          if ($truthy(($truthy($a = block_context['$==']("source")) ? $a : ($truthy($b = attributes['$[]'](1)['$!']()) ? (language = ($truthy($c = attributes['$[]'](2)) ? $c : doc_attrs['$[]']("source-language"))) : $b)))) {
            
            if ($truthy(language)) {
              
              
              $writer = ["style", "source"];
              $send(attributes, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              
              $writer = ["language", language];
              $send(attributes, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              $$($nesting, 'AttributeList').$rekey(attributes, [nil, nil, "linenums"]);
            } else {
              
              $$($nesting, 'AttributeList').$rekey(attributes, [nil, "language", "linenums"]);
              if ($truthy(attributes['$key?']("language"))) {
              } else if ($truthy(doc_attrs['$key?']("source-language"))) {
                
                $writer = ["language", doc_attrs['$[]']("source-language")];
                $send(attributes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];};
            };
            if ($truthy(attributes['$key?']("linenums"))) {
            } else if ($truthy(($truthy($a = attributes['$[]']("linenums-option")) ? $a : doc_attrs['$[]']("source-linenums-option")))) {
              
              $writer = ["linenums", ""];
              $send(attributes, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
            if ($truthy(attributes['$key?']("indent"))) {
            } else if ($truthy(doc_attrs['$key?']("source-indent"))) {
              
              $writer = ["indent", doc_attrs['$[]']("source-indent")];
              $send(attributes, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};};
          block = self.$build_block("listing", "verbatim", terminator, parent, reader, attributes);}
          else if ("fenced_code"['$===']($case)) {
          
          $writer = ["style", "source"];
          $send(attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          if ($truthy($rb_gt((ll = this_line.$length()), 3))) {
            if ($truthy((comma_idx = (language = this_line.$slice(3, ll)).$index(",")))) {
              if ($truthy($rb_gt(comma_idx, 0))) {
                
                language = language.$slice(0, comma_idx).$strip();
                if ($truthy($rb_lt(comma_idx, $rb_minus(ll, 4)))) {
                  
                  $writer = ["linenums", ""];
                  $send(attributes, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];};
              } else if ($truthy($rb_gt(ll, 4))) {
                
                $writer = ["linenums", ""];
                $send(attributes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];}
            } else {
              language = language.$lstrip()
            }};
          if ($truthy(language['$nil_or_empty?']())) {
            if ($truthy(doc_attrs['$key?']("source-language"))) {
              
              $writer = ["language", doc_attrs['$[]']("source-language")];
              $send(attributes, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];}
          } else {
            
            $writer = ["language", language];
            $send(attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          };
          if ($truthy(attributes['$key?']("linenums"))) {
          } else if ($truthy(($truthy($a = attributes['$[]']("linenums-option")) ? $a : doc_attrs['$[]']("source-linenums-option")))) {
            
            $writer = ["linenums", ""];
            $send(attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          if ($truthy(attributes['$key?']("indent"))) {
          } else if ($truthy(doc_attrs['$key?']("source-indent"))) {
            
            $writer = ["indent", doc_attrs['$[]']("source-indent")];
            $send(attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          terminator = terminator.$slice(0, 3);
          block = self.$build_block("listing", "verbatim", terminator, parent, reader, attributes);}
          else if ("table"['$===']($case)) {
          block_cursor = reader.$cursor();
          block_reader = $$($nesting, 'Reader').$new(reader.$read_lines_until($hash2(["terminator", "skip_line_comments", "context", "cursor"], {"terminator": terminator, "skip_line_comments": true, "context": "table", "cursor": "at_mark"})), block_cursor);
          if ($truthy(terminator['$start_with?']("|", "!"))) {
          } else {
            ($truthy($a = attributes['$[]']("format")) ? $a : (($writer = ["format", (function() {if ($truthy(terminator['$start_with?'](","))) {
              return "csv"
            } else {
              return "dsv"
            }; return nil; })()]), $send(attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))
          };
          block = self.$parse_table(block_reader, parent, attributes);}
          else if ("sidebar"['$===']($case)) {block = self.$build_block(block_context, "compound", terminator, parent, reader, attributes)}
          else if ("admonition"['$===']($case)) {
          
          $writer = ["name", (admonition_name = style.$downcase())];
          $send(attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["textlabel", ($truthy($a = attributes.$delete("caption")) ? $a : doc_attrs['$[]']("" + (admonition_name) + "-caption"))];
          $send(attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          block = self.$build_block(block_context, "compound", terminator, parent, reader, attributes);}
          else if ("open"['$===']($case) || "abstract"['$===']($case) || "partintro"['$===']($case)) {block = self.$build_block("open", "compound", terminator, parent, reader, attributes)}
          else if ("literal"['$===']($case)) {block = self.$build_block(block_context, "verbatim", terminator, parent, reader, attributes)}
          else if ("example"['$===']($case)) {
          if ($truthy(attributes['$[]']("collapsible-option"))) {
            
            $writer = ["caption", ""];
            $send(attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          block = self.$build_block(block_context, "compound", terminator, parent, reader, attributes);}
          else if ("quote"['$===']($case) || "verse"['$===']($case)) {
          $$($nesting, 'AttributeList').$rekey(attributes, [nil, "attribution", "citetitle"]);
          block = self.$build_block(block_context, (function() {if (block_context['$==']("verse")) {
            return "verbatim"
          } else {
            return "compound"
          }; return nil; })(), terminator, parent, reader, attributes);}
          else if ("stem"['$===']($case) || "latexmath"['$===']($case) || "asciimath"['$===']($case)) {
          if (block_context['$==']("stem")) {
            
            $writer = ["style", $$($nesting, 'STEM_TYPE_ALIASES')['$[]'](($truthy($a = attributes['$[]'](2)) ? $a : doc_attrs['$[]']("stem")))];
            $send(attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          block = self.$build_block("stem", "raw", terminator, parent, reader, attributes);}
          else if ("pass"['$===']($case)) {block = self.$build_block(block_context, "raw", terminator, parent, reader, attributes)}
          else if ("comment"['$===']($case)) {
          self.$build_block(block_context, "skip", terminator, parent, reader, attributes);
          attributes.$clear();
          return nil;}
          else {if ($truthy(($truthy($a = block_extensions) ? (extension = extensions['$registered_for_block?'](block_context, cloaked_context)) : $a))) {
            
            if ((content_model = (ext_config = extension.$config())['$[]']("content_model"))['$==']("skip")) {
            } else {
              
              if ($truthy((positional_attrs = ($truthy($a = ext_config['$[]']("positional_attrs")) ? $a : ext_config['$[]']("pos_attrs")))['$nil_or_empty?']())) {
              } else {
                $$($nesting, 'AttributeList').$rekey(attributes, $rb_plus([nil], positional_attrs))
              };
              if ($truthy((default_attrs = ext_config['$[]']("default_attrs")))) {
                $send(default_attrs, 'each', [], ($$13 = function(k, v){var self = $$13.$$s || this, $e;

                
                  
                  if (k == null) {
                    k = nil;
                  };
                  
                  if (v == null) {
                    v = nil;
                  };
                  return ($truthy($e = attributes['$[]'](k)) ? $e : (($writer = [k, v]), $send(attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));}, $$13.$$s = self, $$13.$$arity = 2, $$13))};
              
              $writer = ["cloaked-context", cloaked_context];
              $send(attributes, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
            };
            if ($truthy((block = self.$build_block(block_context, content_model, terminator, parent, reader, attributes, $hash2(["extension"], {"extension": extension}))))) {
            } else {
              
              attributes.$clear();
              return nil;
            };
          } else {
            self.$raise("" + "Unsupported block type " + (block_context) + " at " + (reader.$cursor()))
          }}
        };
        if ($truthy(document.$sourcemap())) {
          
          $writer = [reader.$cursor_at_mark()];
          $send(block, 'source_location=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        if ($truthy(attributes['$[]']("title"))) {
          
          
          $writer = [(block_title = attributes.$delete("title"))];
          $send(block, 'title=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          if ($truthy($$($nesting, 'CAPTION_ATTRIBUTE_NAMES')['$[]'](block.$context()))) {
            block.$assign_caption(attributes.$delete("caption"))};};
        
        $writer = [attributes['$[]']("style")];
        $send(block, 'style=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        if ($truthy((block_id = ($truthy($a = block.$id()) ? $a : (($writer = [attributes['$[]']("id")]), $send(block, 'id=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))))) {
          
          if ($truthy((function() {if ($truthy(block_title)) {
            
            return block_title['$include?']($$($nesting, 'ATTR_REF_HEAD'));
          } else {
            return block['$title?']()
          }; return nil; })())) {
            block.$title()};
          if ($truthy(document.$register("refs", [block_id, block]))) {
          } else {
            self.$logger().$warn(self.$message_with_context("" + "id assigned to block already in use: " + (block_id), $hash2(["source_location"], {"source_location": reader.$cursor_at_mark()})))
          };};
        if ($truthy(attributes['$empty?']())) {
        } else {
          block.$update_attributes(attributes)
        };
        block.$commit_subs();
        if ($truthy(block['$sub?']("callouts"))) {
          if ($truthy(self.$catalog_callouts(block.$source(), document))) {
          } else {
            block.$remove_sub("callouts")
          }};
        return block;
        } catch ($returner) { if ($returner === Opal.returner) { return $returner.$v } throw $returner; }
      }, $Parser_next_block$10.$$arity = -3);
      Opal.defs(self, '$read_paragraph_lines', $Parser_read_paragraph_lines$14 = function $$read_paragraph_lines(reader, break_at_list, opts) {
        var self = this, $writer = nil, break_condition = nil;

        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        
        $writer = ["break_on_blank_lines", true];
        $send(opts, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["break_on_list_continuation", true];
        $send(opts, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["preserve_last_line", true];
        $send(opts, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        break_condition = (function() {if ($truthy(break_at_list)) {
          
          if ($truthy($$($nesting, 'Compliance').$block_terminates_paragraph())) {
            return $$($nesting, 'StartOfBlockOrListProc')
          } else {
            return $$($nesting, 'StartOfListProc')
          };
        } else {
          
          if ($truthy($$($nesting, 'Compliance').$block_terminates_paragraph())) {
            return $$($nesting, 'StartOfBlockProc')
          } else {
            return $$($nesting, 'NoOp')
          };
        }; return nil; })();
        return $send(reader, 'read_lines_until', [opts], break_condition.$to_proc());
      }, $Parser_read_paragraph_lines$14.$$arity = -3);
      Opal.defs(self, '$is_delimited_block?', $Parser_is_delimited_block$ques$15 = function(line, return_match_data) {
        var $a, $b, self = this, line_len = nil, tip = nil, tip_len = nil, context = nil, masq = nil;

        
        
        if (return_match_data == null) {
          return_match_data = nil;
        };
        if ($truthy(($truthy($a = $rb_gt((line_len = line.$length()), 1)) ? $$($nesting, 'DELIMITED_BLOCK_HEADS')['$[]'](line.$slice(0, 2)) : $a))) {
        } else {
          return nil
        };
        if (line_len['$=='](2)) {
          
          tip = line;
          tip_len = 2;
        } else {
          
          if ($truthy($rb_lt(line_len, 5))) {
            
            tip = line;
            tip_len = line_len;
          } else {
            tip = line.$slice(0, (tip_len = 4))
          };
          if ($truthy(($truthy($a = $$($nesting, 'Compliance').$markdown_syntax()) ? tip['$start_with?']("`") : $a))) {
            if (tip_len['$=='](4)) {
              
              if ($truthy(($truthy($a = tip['$==']("````")) ? $a : (tip = tip.$chop())['$!=']("```")))) {
                return nil};
              line = tip;
              line_len = (tip_len = 3);
            } else if ($truthy(tip['$!=']("```"))) {
              return nil}
          } else if (tip_len['$=='](3)) {
            return nil};
        };
        $b = $$($nesting, 'DELIMITED_BLOCKS')['$[]'](tip), $a = Opal.to_ary($b), (context = ($a[0] == null ? nil : $a[0])), (masq = ($a[1] == null ? nil : $a[1])), $b;
        if ($truthy(($truthy($a = context) ? ($truthy($b = line_len['$=='](tip_len)) ? $b : self['$uniform?'](line.$slice(1, line_len), $$($nesting, 'DELIMITED_BLOCK_TAILS')['$[]'](tip), $rb_minus(line_len, 1))) : $a))) {
          if ($truthy(return_match_data)) {
            
            return $$($nesting, 'BlockMatchData').$new(context, masq, tip, line);
          } else {
            return true
          }
        } else {
          return nil
        };
      }, $Parser_is_delimited_block$ques$15.$$arity = -2);
      Opal.defs(self, '$build_block', $Parser_build_block$16 = function $$build_block(block_context, content_model, terminator, parent, reader, attributes, options) {
        var $a, $b, self = this, $case = nil, skip_processing = nil, parse_as_content_model = nil, lines = nil, block_reader = nil, block_cursor = nil, tab_size = nil, indent = nil, extension = nil, block = nil;

        
        
        if (options == null) {
          options = $hash2([], {});
        };
        $case = content_model;
        if ("skip"['$===']($case)) {$a = [true, "simple"], (skip_processing = $a[0]), (parse_as_content_model = $a[1]), $a}
        else if ("raw"['$===']($case)) {$a = [false, "simple"], (skip_processing = $a[0]), (parse_as_content_model = $a[1]), $a}
        else {$a = [false, content_model], (skip_processing = $a[0]), (parse_as_content_model = $a[1]), $a};
        if ($truthy(terminator['$nil?']())) {
          
          if (parse_as_content_model['$==']("verbatim")) {
            lines = reader.$read_lines_until($hash2(["break_on_blank_lines", "break_on_list_continuation"], {"break_on_blank_lines": true, "break_on_list_continuation": true}))
          } else {
            
            if (content_model['$==']("compound")) {
              content_model = "simple"};
            lines = self.$read_paragraph_lines(reader, false, $hash2(["skip_line_comments", "skip_processing"], {"skip_line_comments": true, "skip_processing": skip_processing}));
          };
          block_reader = nil;
        } else if ($truthy(parse_as_content_model['$!=']("compound"))) {
          
          lines = reader.$read_lines_until($hash2(["terminator", "skip_processing", "context", "cursor"], {"terminator": terminator, "skip_processing": skip_processing, "context": block_context, "cursor": "at_mark"}));
          block_reader = nil;
        } else if (terminator['$=='](false)) {
          
          lines = nil;
          block_reader = reader;
        } else {
          
          lines = nil;
          block_cursor = reader.$cursor();
          block_reader = $$($nesting, 'Reader').$new(reader.$read_lines_until($hash2(["terminator", "skip_processing", "context", "cursor"], {"terminator": terminator, "skip_processing": skip_processing, "context": block_context, "cursor": "at_mark"})), block_cursor);
        };
        $case = content_model;
        if ("verbatim"['$===']($case)) {
        tab_size = ($truthy($a = attributes['$[]']("tabsize")) ? $a : parent.$document().$attributes()['$[]']("tabsize")).$to_i();
        if ($truthy((indent = attributes['$[]']("indent")))) {
          self['$adjust_indentation!'](lines, indent.$to_i(), tab_size)
        } else if ($truthy($rb_gt(tab_size, 0))) {
          self['$adjust_indentation!'](lines, -1, tab_size)};}
        else if ("skip"['$===']($case)) {return nil};
        if ($truthy((extension = options['$[]']("extension")))) {
          
          attributes.$delete("style");
          if ($truthy(($truthy($a = (block = extension.$process_method()['$[]'](parent, ($truthy($b = block_reader) ? $b : $$($nesting, 'Reader').$new(lines)), attributes.$merge()))) ? block['$!='](parent) : $a))) {
            
            attributes.$replace(block.$attributes());
            if ($truthy(($truthy($a = (($b = block.$content_model()['$==']("compound")) ? $$($nesting, 'Block')['$==='](block) : block.$content_model()['$==']("compound"))) ? (lines = block.$lines())['$empty?']()['$!']() : $a))) {
              
              content_model = "compound";
              block_reader = $$($nesting, 'Reader').$new(lines);};
          } else {
            return nil
          };
        } else {
          block = $$($nesting, 'Block').$new(parent, block_context, $hash2(["content_model", "source", "attributes"], {"content_model": content_model, "source": lines, "attributes": attributes}))
        };
        if (content_model['$==']("compound")) {
          self.$parse_blocks(block_reader, block)};
        return block;
      }, $Parser_build_block$16.$$arity = -7);
      Opal.defs(self, '$parse_blocks', $Parser_parse_blocks$17 = function $$parse_blocks(reader, parent, attributes) {
        var $a, $b, $c, self = this, block = nil;

        
        
        if (attributes == null) {
          attributes = nil;
        };
        if ($truthy(attributes)) {
          while ($truthy(($truthy($b = ($truthy($c = (block = self.$next_block(reader, parent, attributes.$merge()))) ? parent.$blocks()['$<<'](block) : $c)) ? $b : reader['$has_more_lines?']()))) {
            
          }
        } else {
          while ($truthy(($truthy($b = ($truthy($c = (block = self.$next_block(reader, parent))) ? parent.$blocks()['$<<'](block) : $c)) ? $b : reader['$has_more_lines?']()))) {
            
          }
        };
        return nil;
      }, $Parser_parse_blocks$17.$$arity = -3);
      Opal.defs(self, '$parse_list', $Parser_parse_list$18 = function $$parse_list(reader, list_type, parent, style) {
        var $a, $b, self = this, list_block = nil, list_rx = nil, list_item = nil;
        if ($gvars["~"] == null) $gvars["~"] = nil;

        
        list_block = $$($nesting, 'List').$new(parent, list_type);
        list_rx = $$($nesting, 'ListRxMap')['$[]'](list_type);
        while ($truthy(($truthy($b = reader['$has_more_lines?']()) ? list_rx['$=~'](reader.$peek_line()) : $b))) {
          
          if ($truthy((list_item = self.$parse_list_item(reader, list_block, $gvars["~"], (($b = $gvars['~']) === nil ? nil : $b['$[]'](1)), style)))) {
            list_block.$items()['$<<'](list_item)};
          if ($truthy($b = reader.$skip_blank_lines())) {
            $b
          } else {
            break;
          };
        };
        return list_block;
      }, $Parser_parse_list$18.$$arity = 4);
      Opal.defs(self, '$catalog_callouts', $Parser_catalog_callouts$19 = function $$catalog_callouts(text, document) {
        var $$20, self = this, found = nil, autonum = nil;

        
        found = false;
        autonum = 0;
        if ($truthy(text['$include?']("<"))) {
          $send(text, 'scan', [$$($nesting, 'CalloutScanRx')], ($$20 = function(){var self = $$20.$$s || this, $a;

          
            if ($truthy((($a = $gvars['~']) === nil ? nil : $a['$[]'](0))['$start_with?']("\\"))) {
            } else {
              document.$callouts().$register((function() {if ((($a = $gvars['~']) === nil ? nil : $a['$[]'](2))['$=='](".")) {
                return (autonum = $rb_plus(autonum, 1)).$to_s()
              } else {
                return (($a = $gvars['~']) === nil ? nil : $a['$[]'](2))
              }; return nil; })())
            };
            return (found = true);}, $$20.$$s = self, $$20.$$arity = 0, $$20))};
        return found;
      }, $Parser_catalog_callouts$19.$$arity = 2);
      Opal.defs(self, '$catalog_inline_anchor', $Parser_catalog_inline_anchor$21 = function $$catalog_inline_anchor(id, reftext, node, location, doc) {
        var $a, self = this;

        
        
        if (doc == null) {
          doc = node.$document();
        };
        if ($truthy(($truthy($a = reftext) ? reftext['$include?']($$($nesting, 'ATTR_REF_HEAD')) : $a))) {
          reftext = doc.$sub_attributes(reftext)};
        if ($truthy(doc.$register("refs", [id, $$($nesting, 'Inline').$new(node, "anchor", reftext, $hash2(["type", "id"], {"type": "ref", "id": id}))]))) {
        } else {
          
          if ($truthy($$($nesting, 'Reader')['$==='](location))) {
            location = location.$cursor()};
          self.$logger().$warn(self.$message_with_context("" + "id assigned to anchor already in use: " + (id), $hash2(["source_location"], {"source_location": location})));
        };
        return nil;
      }, $Parser_catalog_inline_anchor$21.$$arity = -5);
      Opal.defs(self, '$catalog_inline_anchors', $Parser_catalog_inline_anchors$22 = function $$catalog_inline_anchors(text, block, document, reader) {
        var $a, $$23, self = this;

        
        if ($truthy(($truthy($a = text['$include?']("[[")) ? $a : text['$include?']("or:")))) {
          $send(text, 'scan', [$$($nesting, 'InlineAnchorScanRx')], ($$23 = function(){var self = $$23.$$s || this, $b, $c, $d, id = nil, reftext = nil, location = nil, offset = nil;

          
            if ($truthy((id = (($b = $gvars['~']) === nil ? nil : $b['$[]'](1))))) {
              if ($truthy(($truthy($b = ($truthy($c = (reftext = (($d = $gvars['~']) === nil ? nil : $d['$[]'](2)))) ? reftext['$include?']($$($nesting, 'ATTR_REF_HEAD')) : $c)) ? (reftext = document.$sub_attributes(reftext))['$empty?']() : $b))) {
                return nil;}
            } else {
              
              id = (($b = $gvars['~']) === nil ? nil : $b['$[]'](3));
              if ($truthy((reftext = (($b = $gvars['~']) === nil ? nil : $b['$[]'](4))))) {
                if ($truthy(reftext['$include?']("]"))) {
                  
                  reftext = reftext.$gsub("\\]", "]");
                  if ($truthy(reftext['$include?']($$($nesting, 'ATTR_REF_HEAD')))) {
                    reftext = document.$sub_attributes(reftext)};
                } else if ($truthy(($truthy($b = reftext['$include?']($$($nesting, 'ATTR_REF_HEAD'))) ? (reftext = document.$sub_attributes(reftext))['$empty?']() : $b))) {
                  return nil;}};
            };
            if ($truthy(document.$register("refs", [id, $$($nesting, 'Inline').$new(block, "anchor", reftext, $hash2(["type", "id"], {"type": "ref", "id": id}))]))) {
              return nil
            } else {
              
              location = reader.$cursor_at_mark();
              if ($truthy($rb_gt((offset = $rb_plus((($b = $gvars['~']) === nil ? nil : $b.$pre_match()).$count($$($nesting, 'LF')), (function() {if ($truthy((($b = $gvars['~']) === nil ? nil : $b['$[]'](0))['$start_with?']($$($nesting, 'LF')))) {
                return 1
              } else {
                return 0
              }; return nil; })())), 0))) {
                (location = location.$dup()).$advance(offset)};
              return self.$logger().$warn(self.$message_with_context("" + "id assigned to anchor already in use: " + (id), $hash2(["source_location"], {"source_location": location})));
            };}, $$23.$$s = self, $$23.$$arity = 0, $$23))};
        return nil;
      }, $Parser_catalog_inline_anchors$22.$$arity = 4);
      Opal.defs(self, '$catalog_inline_biblio_anchor', $Parser_catalog_inline_biblio_anchor$24 = function $$catalog_inline_biblio_anchor(id, reftext, node, reader) {
        var $a, self = this;

        
        if ($truthy(node.$document().$register("refs", [id, $$($nesting, 'Inline').$new(node, "anchor", ($truthy($a = reftext) ? "" + "[" + (reftext) + "]" : $a), $hash2(["type", "id"], {"type": "bibref", "id": id}))]))) {
        } else {
          self.$logger().$warn(self.$message_with_context("" + "id assigned to bibliography anchor already in use: " + (id), $hash2(["source_location"], {"source_location": reader.$cursor()})))
        };
        return nil;
      }, $Parser_catalog_inline_biblio_anchor$24.$$arity = 4);
      Opal.defs(self, '$parse_description_list', $Parser_parse_description_list$25 = function $$parse_description_list(reader, match, parent) {
        var $a, $b, self = this, list_block = nil, sibling_pattern = nil, current_pair = nil, next_pair = nil, $writer = nil;
        if ($gvars["~"] == null) $gvars["~"] = nil;

        
        list_block = $$($nesting, 'List').$new(parent, "dlist");
        sibling_pattern = $$($nesting, 'DescriptionListSiblingRx')['$[]'](match['$[]'](2));
        list_block.$items()['$<<']((current_pair = self.$parse_list_item(reader, list_block, match, sibling_pattern)));
        while ($truthy(($truthy($b = reader['$has_more_lines?']()) ? sibling_pattern['$=~'](reader.$peek_line()) : $b))) {
          
          next_pair = self.$parse_list_item(reader, list_block, $gvars["~"], sibling_pattern);
          if ($truthy(current_pair['$[]'](1))) {
            list_block.$items()['$<<']((current_pair = next_pair))
          } else {
            
            current_pair['$[]'](0)['$<<'](next_pair['$[]'](0)['$[]'](0));
            
            $writer = [1, next_pair['$[]'](1)];
            $send(current_pair, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
          };
        };
        return list_block;
      }, $Parser_parse_description_list$25.$$arity = 3);
      Opal.defs(self, '$parse_callout_list', $Parser_parse_callout_list$26 = function $$parse_callout_list(reader, match, parent, callouts) {
        var $a, $b, $c, self = this, list_block = nil, next_index = nil, autonum = nil, num = nil, list_item = nil, coids = nil, $writer = nil;

        
        list_block = $$($nesting, 'List').$new(parent, "colist");
        next_index = 1;
        autonum = 0;
        while ($truthy(($truthy($b = match) ? $b : ($truthy($c = (match = $$($nesting, 'CalloutListRx').$match(reader.$peek_line()))) ? reader.$mark() : $c)))) {
          
          if ((num = match['$[]'](1))['$=='](".")) {
            num = (autonum = $rb_plus(autonum, 1)).$to_s()};
          if (num['$=='](next_index.$to_s())) {
          } else {
            self.$logger().$warn(self.$message_with_context("" + "callout list item index: expected " + (next_index) + ", got " + (num), $hash2(["source_location"], {"source_location": reader.$cursor_at_mark()})))
          };
          if ($truthy((list_item = self.$parse_list_item(reader, list_block, match, "<1>")))) {
            
            list_block.$items()['$<<'](list_item);
            if ($truthy((coids = callouts.$callout_ids(list_block.$items().$size()))['$empty?']())) {
              self.$logger().$warn(self.$message_with_context("" + "no callout found for <" + (list_block.$items().$size()) + ">", $hash2(["source_location"], {"source_location": reader.$cursor_at_mark()})))
            } else {
              
              $writer = ["coids", coids];
              $send(list_item.$attributes(), '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            };};
          next_index = $rb_plus(next_index, 1);
          match = nil;
        };
        callouts.$next_list();
        return list_block;
      }, $Parser_parse_callout_list$26.$$arity = 4);
      Opal.defs(self, '$parse_list_item', $Parser_parse_list_item$27 = function $$parse_list_item(reader, list_block, match, sibling_trait, style) {
        var $a, $b, self = this, list_type = nil, dlist = nil, list_term = nil, term_text = nil, item_text = nil, has_text = nil, list_item = nil, $writer = nil, sourcemap_assignment_deferred = nil, $case = nil, ordinal = nil, implicit_style = nil, block_cursor = nil, list_item_reader = nil, comment_lines = nil, subsequent_line = nil, content_adjacent = nil, block = nil, first_block = nil;

        
        
        if (style == null) {
          style = nil;
        };
        if ((list_type = list_block.$context())['$==']("dlist")) {
          
          dlist = true;
          list_term = $$($nesting, 'ListItem').$new(list_block, (term_text = match['$[]'](1)));
          if ($truthy(($truthy($a = term_text['$start_with?']("[[")) ? $$($nesting, 'LeadingInlineAnchorRx')['$=~'](term_text) : $a))) {
            self.$catalog_inline_anchor((($a = $gvars['~']) === nil ? nil : $a['$[]'](1)), ($truthy($a = (($b = $gvars['~']) === nil ? nil : $b['$[]'](2))) ? $a : (($b = $gvars['~']) === nil ? nil : $b.$post_match()).$lstrip()), list_term, reader)};
          if ($truthy((item_text = match['$[]'](3)))) {
            has_text = true};
          list_item = $$($nesting, 'ListItem').$new(list_block, item_text);
          if ($truthy(list_block.$document().$sourcemap())) {
            
            
            $writer = [reader.$cursor()];
            $send(list_term, 'source_location=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            if ($truthy(has_text)) {
              
              $writer = [list_term.$source_location()];
              $send(list_item, 'source_location=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            } else {
              sourcemap_assignment_deferred = true
            };};
        } else {
          
          has_text = true;
          list_item = $$($nesting, 'ListItem').$new(list_block, (item_text = match['$[]'](2)));
          if ($truthy(list_block.$document().$sourcemap())) {
            
            $writer = [reader.$cursor()];
            $send(list_item, 'source_location=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          $case = list_type;
          if ("ulist"['$===']($case)) {
          
          $writer = [sibling_trait];
          $send(list_item, 'marker=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          if ($truthy(item_text['$start_with?']("["))) {
            if ($truthy(($truthy($a = style) ? style['$==']("bibliography") : $a))) {
              if ($truthy($$($nesting, 'InlineBiblioAnchorRx')['$=~'](item_text))) {
                self.$catalog_inline_biblio_anchor((($a = $gvars['~']) === nil ? nil : $a['$[]'](1)), (($a = $gvars['~']) === nil ? nil : $a['$[]'](2)), list_item, reader)}
            } else if ($truthy(item_text['$start_with?']("[["))) {
              if ($truthy($$($nesting, 'LeadingInlineAnchorRx')['$=~'](item_text))) {
                self.$catalog_inline_anchor((($a = $gvars['~']) === nil ? nil : $a['$[]'](1)), (($a = $gvars['~']) === nil ? nil : $a['$[]'](2)), list_item, reader)}
            } else if ($truthy(item_text['$start_with?']("[ ] ", "[x] ", "[*] "))) {
              
              list_block.$set_option("checklist");
              
              $writer = ["checkbox", ""];
              $send(list_item.$attributes(), '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              if ($truthy(item_text['$start_with?']("[ "))) {
              } else {
                
                $writer = ["checked", ""];
                $send(list_item.$attributes(), '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];
              };
              
              $writer = [item_text.$slice(4, item_text.$length())];
              $send(list_item, 'text=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;}};}
          else if ("olist"['$===']($case)) {
          $b = self.$resolve_ordered_list_marker(sibling_trait, (ordinal = list_block.$items().$size()), true, reader), $a = Opal.to_ary($b), (sibling_trait = ($a[0] == null ? nil : $a[0])), (implicit_style = ($a[1] == null ? nil : $a[1])), $b;
          
          $writer = [sibling_trait];
          $send(list_item, 'marker=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          if ($truthy((($a = ordinal['$=='](0)) ? style['$!']() : ordinal['$=='](0)))) {
            
            $writer = [($truthy($a = implicit_style) ? $a : ($truthy($b = $$($nesting, 'ORDERED_LIST_STYLES')['$[]']($rb_minus(sibling_trait.$length(), 1))) ? $b : "arabic").$to_s())];
            $send(list_block, 'style=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          if ($truthy(($truthy($a = item_text['$start_with?']("[[")) ? $$($nesting, 'LeadingInlineAnchorRx')['$=~'](item_text) : $a))) {
            self.$catalog_inline_anchor((($a = $gvars['~']) === nil ? nil : $a['$[]'](1)), (($a = $gvars['~']) === nil ? nil : $a['$[]'](2)), list_item, reader)};}
          else {
          
          $writer = [sibling_trait];
          $send(list_item, 'marker=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          if ($truthy(($truthy($a = item_text['$start_with?']("[[")) ? $$($nesting, 'LeadingInlineAnchorRx')['$=~'](item_text) : $a))) {
            self.$catalog_inline_anchor((($a = $gvars['~']) === nil ? nil : $a['$[]'](1)), (($a = $gvars['~']) === nil ? nil : $a['$[]'](2)), list_item, reader)};};
        };
        reader.$shift();
        block_cursor = reader.$cursor();
        list_item_reader = $$($nesting, 'Reader').$new(self.$read_lines_for_list_item(reader, list_type, sibling_trait, has_text), block_cursor);
        if ($truthy(list_item_reader['$has_more_lines?']())) {
          
          if ($truthy(sourcemap_assignment_deferred)) {
            
            $writer = [block_cursor];
            $send(list_item, 'source_location=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          comment_lines = list_item_reader.$skip_line_comments();
          if ($truthy((subsequent_line = list_item_reader.$peek_line()))) {
            
            if ($truthy(comment_lines['$empty?']())) {
            } else {
              list_item_reader.$unshift_lines(comment_lines)
            };
            if ($truthy(subsequent_line['$empty?']())) {
            } else {
              
              content_adjacent = true;
              if ($truthy(dlist)) {
              } else {
                has_text = nil
              };
            };};
          if ($truthy((block = self.$next_block(list_item_reader, list_item, $hash2([], {}), $hash2(["text_only", "list_type"], {"text_only": (function() {if ($truthy(has_text)) {
            return nil
          } else {
            return true
          }; return nil; })(), "list_type": list_type}))))) {
            list_item.$blocks()['$<<'](block)};
          while ($truthy(list_item_reader['$has_more_lines?']())) {
            if ($truthy((block = self.$next_block(list_item_reader, list_item, $hash2([], {}), $hash2(["list_type"], {"list_type": list_type}))))) {
              list_item.$blocks()['$<<'](block)}
          };
          if ($truthy(($truthy($a = ($truthy($b = content_adjacent) ? (first_block = list_item.$blocks()['$[]'](0)) : $b)) ? first_block.$context()['$==']("paragraph") : $a))) {
            list_item.$fold_first()};};
        if ($truthy(dlist)) {
          return [[list_term], (function() {if ($truthy(($truthy($a = list_item['$text?']()) ? $a : list_item['$blocks?']()))) {
            return list_item
          } else {
            return nil
          }; return nil; })()]
        } else {
          return list_item
        };
      }, $Parser_parse_list_item$27.$$arity = -5);
      Opal.defs(self, '$read_lines_for_list_item', $Parser_read_lines_for_list_item$28 = function $$read_lines_for_list_item(reader, list_type, sibling_trait, has_text) {
        var $a, $b, $c, $$29, $$30, $$31, $$32, $$33, self = this, buffer = nil, continuation = nil, within_nested_list = nil, detached_continuation = nil, dlist = nil, this_line = nil, prev_line = nil, $writer = nil, match = nil, nested_list_type = nil, last_line = nil;

        
        
        if (sibling_trait == null) {
          sibling_trait = nil;
        };
        
        if (has_text == null) {
          has_text = true;
        };
        buffer = [];
        continuation = "inactive";
        within_nested_list = false;
        detached_continuation = nil;
        dlist = list_type['$==']("dlist");
        while ($truthy(reader['$has_more_lines?']())) {
          
          this_line = reader.$read_line();
          if ($truthy(self['$is_sibling_list_item?'](this_line, list_type, sibling_trait))) {
            break;};
          prev_line = (function() {if ($truthy(buffer['$empty?']())) {
            return nil
          } else {
            return buffer['$[]'](-1)
          }; return nil; })();
          if (prev_line['$==']($$($nesting, 'LIST_CONTINUATION'))) {
            
            if (continuation['$==']("inactive")) {
              
              continuation = "active";
              has_text = true;
              if ($truthy(within_nested_list)) {
              } else {
                
                $writer = [-1, ""];
                $send(buffer, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];
              };};
            if (this_line['$==']($$($nesting, 'LIST_CONTINUATION'))) {
              
              if ($truthy(continuation['$!=']("frozen"))) {
                
                continuation = "frozen";
                buffer['$<<'](this_line);};
              this_line = nil;
              continue;;};};
          if ($truthy((match = self['$is_delimited_block?'](this_line, true)))) {
            if (continuation['$==']("active")) {
              
              buffer['$<<'](this_line);
              buffer.$concat(reader.$read_lines_until($hash2(["terminator", "read_last_line", "context"], {"terminator": match.$terminator(), "read_last_line": true, "context": nil})));
              continuation = "inactive";
            } else {
              break;
            }
          } else if ($truthy(($truthy($b = ($truthy($c = dlist) ? continuation['$!=']("active") : $c)) ? $$($nesting, 'BlockAttributeLineRx')['$match?'](this_line) : $b))) {
            break;
          } else if ($truthy((($b = continuation['$==']("active")) ? this_line['$empty?']()['$!']() : continuation['$==']("active")))) {
            if ($truthy($$($nesting, 'LiteralParagraphRx')['$match?'](this_line))) {
              
              reader.$unshift_line(this_line);
              if ($truthy(dlist)) {
                buffer.$concat($send(reader, 'read_lines_until', [$hash2(["preserve_last_line", "break_on_blank_lines", "break_on_list_continuation"], {"preserve_last_line": true, "break_on_blank_lines": true, "break_on_list_continuation": true})], ($$29 = function(line){var self = $$29.$$s || this;

                
                  
                  if (line == null) {
                    line = nil;
                  };
                  return self['$is_sibling_list_item?'](line, list_type, sibling_trait);}, $$29.$$s = self, $$29.$$arity = 1, $$29)))
              } else {
                buffer.$concat(reader.$read_lines_until($hash2(["preserve_last_line", "break_on_blank_lines", "break_on_list_continuation"], {"preserve_last_line": true, "break_on_blank_lines": true, "break_on_list_continuation": true})))
              };
              continuation = "inactive";
            } else if ($truthy(($truthy($b = ($truthy($c = $$($nesting, 'BlockTitleRx')['$match?'](this_line)) ? $c : $$($nesting, 'BlockAttributeLineRx')['$match?'](this_line))) ? $b : $$($nesting, 'AttributeEntryRx')['$match?'](this_line)))) {
              buffer['$<<'](this_line)
            } else {
              
              if ($truthy((nested_list_type = $send((function() {if ($truthy(within_nested_list)) {
                return ["dlist"]
              } else {
                return $$($nesting, 'NESTABLE_LIST_CONTEXTS')
              }; return nil; })(), 'find', [], ($$30 = function(ctx){var self = $$30.$$s || this;

              
                
                if (ctx == null) {
                  ctx = nil;
                };
                return $$($nesting, 'ListRxMap')['$[]'](ctx)['$match?'](this_line);}, $$30.$$s = self, $$30.$$arity = 1, $$30))))) {
                
                within_nested_list = true;
                if ($truthy((($b = nested_list_type['$==']("dlist")) ? (($c = $gvars['~']) === nil ? nil : $c['$[]'](3))['$nil_or_empty?']() : nested_list_type['$==']("dlist")))) {
                  has_text = false};};
              buffer['$<<'](this_line);
              continuation = "inactive";
            }
          } else if ($truthy(($truthy($b = prev_line) ? prev_line['$empty?']() : $b))) {
            
            if ($truthy(this_line['$empty?']())) {
              
              if ($truthy((this_line = ($truthy($b = reader.$skip_blank_lines()) ? reader.$read_line() : $b)))) {
              } else {
                break;
              };
              if ($truthy(self['$is_sibling_list_item?'](this_line, list_type, sibling_trait))) {
                break;};};
            if (this_line['$==']($$($nesting, 'LIST_CONTINUATION'))) {
              
              detached_continuation = buffer.$size();
              buffer['$<<'](this_line);
            } else if ($truthy(has_text)) {
              if ($truthy(self['$is_sibling_list_item?'](this_line, list_type, sibling_trait))) {
                break;
              } else if ($truthy((nested_list_type = $send($$($nesting, 'NESTABLE_LIST_CONTEXTS'), 'find', [], ($$31 = function(ctx){var self = $$31.$$s || this;

              
                
                if (ctx == null) {
                  ctx = nil;
                };
                return $$($nesting, 'ListRxMap')['$[]'](ctx)['$=~'](this_line);}, $$31.$$s = self, $$31.$$arity = 1, $$31))))) {
                
                buffer['$<<'](this_line);
                within_nested_list = true;
                if ($truthy((($b = nested_list_type['$==']("dlist")) ? (($c = $gvars['~']) === nil ? nil : $c['$[]'](3))['$nil_or_empty?']() : nested_list_type['$==']("dlist")))) {
                  has_text = false};
              } else if ($truthy($$($nesting, 'LiteralParagraphRx')['$match?'](this_line))) {
                
                reader.$unshift_line(this_line);
                if ($truthy(dlist)) {
                  buffer.$concat($send(reader, 'read_lines_until', [$hash2(["preserve_last_line", "break_on_blank_lines", "break_on_list_continuation"], {"preserve_last_line": true, "break_on_blank_lines": true, "break_on_list_continuation": true})], ($$32 = function(line){var self = $$32.$$s || this;

                  
                    
                    if (line == null) {
                      line = nil;
                    };
                    return self['$is_sibling_list_item?'](line, list_type, sibling_trait);}, $$32.$$s = self, $$32.$$arity = 1, $$32)))
                } else {
                  buffer.$concat(reader.$read_lines_until($hash2(["preserve_last_line", "break_on_blank_lines", "break_on_list_continuation"], {"preserve_last_line": true, "break_on_blank_lines": true, "break_on_list_continuation": true})))
                };
              } else {
                break;
              }
            } else {
              
              if ($truthy(within_nested_list)) {
              } else {
                buffer.$pop()
              };
              buffer['$<<'](this_line);
              has_text = true;
            };
          } else {
            
            if ($truthy(this_line['$empty?']())) {
            } else {
              has_text = true
            };
            if ($truthy((nested_list_type = $send((function() {if ($truthy(within_nested_list)) {
              return ["dlist"]
            } else {
              return $$($nesting, 'NESTABLE_LIST_CONTEXTS')
            }; return nil; })(), 'find', [], ($$33 = function(ctx){var self = $$33.$$s || this;

            
              
              if (ctx == null) {
                ctx = nil;
              };
              return $$($nesting, 'ListRxMap')['$[]'](ctx)['$=~'](this_line);}, $$33.$$s = self, $$33.$$arity = 1, $$33))))) {
              
              within_nested_list = true;
              if ($truthy((($b = nested_list_type['$==']("dlist")) ? (($c = $gvars['~']) === nil ? nil : $c['$[]'](3))['$nil_or_empty?']() : nested_list_type['$==']("dlist")))) {
                has_text = false};};
            buffer['$<<'](this_line);
          };
          this_line = nil;
        };
        if ($truthy(this_line)) {
          reader.$unshift_line(this_line)};
        if ($truthy(detached_continuation)) {
          
          $writer = [detached_continuation, ""];
          $send(buffer, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        while (!($truthy(buffer['$empty?']()))) {
          if ($truthy((last_line = buffer['$[]'](-1))['$empty?']())) {
            buffer.$pop()
          } else {
            
            if (last_line['$==']($$($nesting, 'LIST_CONTINUATION'))) {
              buffer.$pop()};
            break;;
          }
        };
        return buffer;
      }, $Parser_read_lines_for_list_item$28.$$arity = -3);
      Opal.defs(self, '$initialize_section', $Parser_initialize_section$34 = function $$initialize_section(reader, parent, attributes) {
        var $a, $b, self = this, document = nil, book = nil, doctype = nil, source_location = nil, sect_style = nil, sect_id = nil, sect_reftext = nil, sect_title = nil, sect_level = nil, sect_atx = nil, sect_name = nil, sect_special = nil, sect_numbered = nil, $writer = nil, section = nil, id = nil, generated_id = nil;

        
        
        if (attributes == null) {
          attributes = $hash2([], {});
        };
        document = parent.$document();
        book = (doctype = document.$doctype())['$==']("book");
        if ($truthy(document.$sourcemap())) {
          source_location = reader.$cursor()};
        sect_style = attributes['$[]'](1);
        $b = self.$parse_section_title(reader, document, attributes['$[]']("id")), $a = Opal.to_ary($b), (sect_id = ($a[0] == null ? nil : $a[0])), (sect_reftext = ($a[1] == null ? nil : $a[1])), (sect_title = ($a[2] == null ? nil : $a[2])), (sect_level = ($a[3] == null ? nil : $a[3])), (sect_atx = ($a[4] == null ? nil : $a[4])), $b;
        if ($truthy(sect_style)) {
          if ($truthy(($truthy($a = book) ? sect_style['$==']("abstract") : $a))) {
            $a = ["chapter", 1], (sect_name = $a[0]), (sect_level = $a[1]), $a
          } else if ($truthy(($truthy($a = sect_style['$start_with?']("sect")) ? $$($nesting, 'SectionLevelStyleRx')['$match?'](sect_style) : $a))) {
            sect_name = "section"
          } else {
            
            $a = [sect_style, true], (sect_name = $a[0]), (sect_special = $a[1]), $a;
            if (sect_level['$=='](0)) {
              sect_level = 1};
            sect_numbered = sect_name['$==']("appendix");
          }
        } else if ($truthy(book)) {
          sect_name = (function() {if (sect_level['$=='](0)) {
            return "part"
          } else {
            
            if ($truthy($rb_gt(sect_level, 1))) {
              return "section"
            } else {
              return "chapter"
            };
          }; return nil; })()
        } else if ($truthy((($a = doctype['$==']("manpage")) ? sect_title.$casecmp("synopsis")['$=='](0) : doctype['$==']("manpage")))) {
          $a = ["synopsis", true], (sect_name = $a[0]), (sect_special = $a[1]), $a
        } else {
          sect_name = "section"
        };
        if ($truthy(sect_reftext)) {
          
          $writer = ["reftext", sect_reftext];
          $send(attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        section = $$($nesting, 'Section').$new(parent, sect_level);
        $a = [sect_id, sect_title, sect_name, source_location], section['$id=']($a[0]), section['$title=']($a[1]), section['$sectname=']($a[2]), section['$source_location=']($a[3]), $a;
        if ($truthy(sect_special)) {
          
          
          $writer = [true];
          $send(section, 'special=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          if ($truthy(sect_numbered)) {
            
            $writer = [true];
            $send(section, 'numbered=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          } else if (document.$attributes()['$[]']("sectnums")['$==']("all")) {
            
            $writer = [(function() {if ($truthy(($truthy($a = book) ? sect_level['$=='](1) : $a))) {
              return "chapter"
            } else {
              return true
            }; return nil; })()];
            $send(section, 'numbered=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
        } else if ($truthy(($truthy($a = document.$attributes()['$[]']("sectnums")) ? $rb_gt(sect_level, 0) : $a))) {
          
          $writer = [(function() {if ($truthy(section.$special())) {
            return ($truthy($a = parent.$numbered()) ? true : $a)
          } else {
            return true
          }; return nil; })()];
          $send(section, 'numbered=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];
        } else if ($truthy(($truthy($a = ($truthy($b = book) ? sect_level['$=='](0) : $b)) ? document.$attributes()['$[]']("partnums") : $a))) {
          
          $writer = [true];
          $send(section, 'numbered=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        if ($truthy((id = ($truthy($a = section.$id()) ? $a : (($writer = [(function() {if ($truthy(document.$attributes()['$key?']("sectids"))) {
          
          return (generated_id = $$($nesting, 'Section').$generate_id(section.$title(), document));
        } else {
          return nil
        }; return nil; })()]), $send(section, 'id=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))))) {
          
          if ($truthy(($truthy($a = generated_id) ? $a : sect_title['$include?']($$($nesting, 'ATTR_REF_HEAD'))['$!']()))) {
          } else {
            section.$title()
          };
          if ($truthy(document.$register("refs", [id, section]))) {
          } else {
            self.$logger().$warn(self.$message_with_context("" + "id assigned to section already in use: " + (id), $hash2(["source_location"], {"source_location": reader.$cursor_at_line($rb_minus(reader.$lineno(), (function() {if ($truthy(sect_atx)) {
              return 1
            } else {
              return 2
            }; return nil; })()))})))
          };};
        section.$update_attributes(attributes);
        reader.$skip_blank_lines();
        return section;
      }, $Parser_initialize_section$34.$$arity = -3);
      Opal.defs(self, '$is_next_line_section?', $Parser_is_next_line_section$ques$35 = function(reader, attributes) {
        var $a, $b, self = this, style = nil, next_lines = nil;

        
        if ($truthy(($truthy($a = (style = attributes['$[]'](1))) ? ($truthy($b = style['$==']("discrete")) ? $b : style['$==']("float")) : $a))) {
          return nil};
        if ($truthy($$($nesting, 'Compliance').$underline_style_section_titles())) {
          
          next_lines = reader.$peek_lines(2, ($truthy($a = style) ? style['$==']("comment") : $a));
          return self['$is_section_title?'](($truthy($a = next_lines['$[]'](0)) ? $a : ""), next_lines['$[]'](1));
        } else {
          return self['$atx_section_title?'](($truthy($a = reader.$peek_line()) ? $a : ""))
        };
      }, $Parser_is_next_line_section$ques$35.$$arity = 2);
      Opal.defs(self, '$is_next_line_doctitle?', $Parser_is_next_line_doctitle$ques$36 = function(reader, attributes, leveloffset) {
        var $a, self = this, sect_level = nil;

        if ($truthy(leveloffset)) {
          return ($truthy($a = (sect_level = self['$is_next_line_section?'](reader, attributes))) ? $rb_plus(sect_level, leveloffset.$to_i())['$=='](0) : $a)
        } else {
          return self['$is_next_line_section?'](reader, attributes)['$=='](0)
        }
      }, $Parser_is_next_line_doctitle$ques$36.$$arity = 3);
      Opal.defs(self, '$is_section_title?', $Parser_is_section_title$ques$37 = function(line1, line2) {
        var $a, self = this;

        
        
        if (line2 == null) {
          line2 = nil;
        };
        return ($truthy($a = self['$atx_section_title?'](line1)) ? $a : (function() {if ($truthy(line2['$nil_or_empty?']())) {
          return nil
        } else {
          return self['$setext_section_title?'](line1, line2)
        }; return nil; })());
      }, $Parser_is_section_title$ques$37.$$arity = -2);
      Opal.defs(self, '$atx_section_title?', $Parser_atx_section_title$ques$38 = function(line) {
        var $a, self = this;

        if ($truthy((function() {if ($truthy($$($nesting, 'Compliance').$markdown_syntax())) {
          
          return ($truthy($a = line['$start_with?']("=", "#")) ? $$($nesting, 'ExtAtxSectionTitleRx')['$=~'](line) : $a);
        } else {
          
          return ($truthy($a = line['$start_with?']("=")) ? $$($nesting, 'AtxSectionTitleRx')['$=~'](line) : $a);
        }; return nil; })())) {
          return $rb_minus((($a = $gvars['~']) === nil ? nil : $a['$[]'](1)).$length(), 1)
        } else {
          return nil
        }
      }, $Parser_atx_section_title$ques$38.$$arity = 1);
      Opal.defs(self, '$setext_section_title?', $Parser_setext_section_title$ques$39 = function(line1, line2) {
        var $a, $b, $c, self = this, level = nil, line2_ch0 = nil, line2_len = nil;

        if ($truthy(($truthy($a = ($truthy($b = ($truthy($c = (level = $$($nesting, 'SETEXT_SECTION_LEVELS')['$[]']((line2_ch0 = line2.$chr())))) ? self['$uniform?'](line2, line2_ch0, (line2_len = line2.$length())) : $c)) ? $$($nesting, 'SetextSectionTitleRx')['$match?'](line1) : $b)) ? $rb_lt($rb_minus(line1.$length(), line2_len).$abs(), 2) : $a))) {
          return level
        } else {
          return nil
        }
      }, $Parser_setext_section_title$ques$39.$$arity = 2);
      Opal.defs(self, '$parse_section_title', $Parser_parse_section_title$40 = function $$parse_section_title(reader, document, sect_id) {
        var $a, $b, $c, $d, $e, self = this, sect_reftext = nil, line1 = nil, sect_level = nil, sect_title = nil, atx = nil, line2 = nil, line2_ch0 = nil, line2_len = nil;

        
        
        if (sect_id == null) {
          sect_id = nil;
        };
        sect_reftext = nil;
        line1 = reader.$read_line();
        if ($truthy((function() {if ($truthy($$($nesting, 'Compliance').$markdown_syntax())) {
          
          return ($truthy($a = line1['$start_with?']("=", "#")) ? $$($nesting, 'ExtAtxSectionTitleRx')['$=~'](line1) : $a);
        } else {
          
          return ($truthy($a = line1['$start_with?']("=")) ? $$($nesting, 'AtxSectionTitleRx')['$=~'](line1) : $a);
        }; return nil; })())) {
          
          $a = [$rb_minus((($b = $gvars['~']) === nil ? nil : $b['$[]'](1)).$length(), 1), (($b = $gvars['~']) === nil ? nil : $b['$[]'](2)), true], (sect_level = $a[0]), (sect_title = $a[1]), (atx = $a[2]), $a;
          if ($truthy(sect_id)) {
          } else if ($truthy(($truthy($a = ($truthy($b = sect_title['$end_with?']("]]")) ? $$($nesting, 'InlineSectionAnchorRx')['$=~'](sect_title) : $b)) ? (($b = $gvars['~']) === nil ? nil : $b['$[]'](1))['$!']() : $a))) {
            $a = [sect_title.$slice(0, $rb_minus(sect_title.$length(), (($b = $gvars['~']) === nil ? nil : $b['$[]'](0)).$length())), (($b = $gvars['~']) === nil ? nil : $b['$[]'](2)), (($b = $gvars['~']) === nil ? nil : $b['$[]'](3))], (sect_title = $a[0]), (sect_id = $a[1]), (sect_reftext = $a[2]), $a};
        } else if ($truthy(($truthy($a = ($truthy($b = ($truthy($c = ($truthy($d = ($truthy($e = $$($nesting, 'Compliance').$underline_style_section_titles()) ? (line2 = reader.$peek_line(true)) : $e)) ? (sect_level = $$($nesting, 'SETEXT_SECTION_LEVELS')['$[]']((line2_ch0 = line2.$chr()))) : $d)) ? self['$uniform?'](line2, line2_ch0, (line2_len = line2.$length())) : $c)) ? (sect_title = ($truthy($c = $$($nesting, 'SetextSectionTitleRx')['$=~'](line1)) ? (($d = $gvars['~']) === nil ? nil : $d['$[]'](1)) : $c)) : $b)) ? $rb_lt($rb_minus(line1.$length(), line2_len).$abs(), 2) : $a))) {
          
          atx = false;
          if ($truthy(sect_id)) {
          } else if ($truthy(($truthy($a = ($truthy($b = sect_title['$end_with?']("]]")) ? $$($nesting, 'InlineSectionAnchorRx')['$=~'](sect_title) : $b)) ? (($b = $gvars['~']) === nil ? nil : $b['$[]'](1))['$!']() : $a))) {
            $a = [sect_title.$slice(0, $rb_minus(sect_title.$length(), (($b = $gvars['~']) === nil ? nil : $b['$[]'](0)).$length())), (($b = $gvars['~']) === nil ? nil : $b['$[]'](2)), (($b = $gvars['~']) === nil ? nil : $b['$[]'](3))], (sect_title = $a[0]), (sect_id = $a[1]), (sect_reftext = $a[2]), $a};
          reader.$shift();
        } else {
          self.$raise("" + "Unrecognized section at " + (reader.$cursor_at_prev_line()))
        };
        if ($truthy(document['$attr?']("leveloffset"))) {
          
          sect_level = $rb_plus(sect_level, document.$attr("leveloffset").$to_i());
          if ($truthy($rb_lt(sect_level, 0))) {
            sect_level = 0};};
        return [sect_id, sect_reftext, sect_title, sect_level, atx];
      }, $Parser_parse_section_title$40.$$arity = -3);
      Opal.defs(self, '$parse_header_metadata', $Parser_parse_header_metadata$41 = function $$parse_header_metadata(reader, document, retrieve) {
        var $a, $$42, $$43, $$44, self = this, doc_attrs = nil, authorcount = nil, implicit_author_metadata = nil, $writer = nil, implicit_author = nil, implicit_authorinitials = nil, implicit_authors = nil, rev_line = nil, match = nil, rev_metadata = nil, component = nil, author_line = nil, author_metadata = nil, authors = nil, author_idx = nil, author_key = nil, explicit = nil, sparse = nil, author_override = nil;

        
        
        if (document == null) {
          document = nil;
        };
        
        if (retrieve == null) {
          retrieve = true;
        };
        doc_attrs = ($truthy($a = document) ? document.$attributes() : $a);
        self.$process_attribute_entries(reader, document);
        if ($truthy(($truthy($a = reader['$has_more_lines?']()) ? reader['$next_line_empty?']()['$!']() : $a))) {
          
          authorcount = (implicit_author_metadata = self.$process_authors(reader.$read_line())).$delete("authorcount");
          if ($truthy(($truthy($a = document) ? $rb_gt((($writer = ["authorcount", authorcount]), $send(doc_attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]), 0) : $a))) {
            
            $send(implicit_author_metadata, 'each', [], ($$42 = function(key, val){var self = $$42.$$s || this;

            
              
              if (key == null) {
                key = nil;
              };
              
              if (val == null) {
                val = nil;
              };
              if ($truthy(doc_attrs['$key?'](key))) {
                return nil
              } else {
                
                $writer = [key, document.$apply_header_subs(val)];
                $send(doc_attrs, '[]=', Opal.to_a($writer));
                return $writer[$rb_minus($writer["length"], 1)];
              };}, $$42.$$s = self, $$42.$$arity = 2, $$42));
            implicit_author = doc_attrs['$[]']("author");
            implicit_authorinitials = doc_attrs['$[]']("authorinitials");
            implicit_authors = doc_attrs['$[]']("authors");};
          
          $writer = ["authorcount", authorcount];
          $send(implicit_author_metadata, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          self.$process_attribute_entries(reader, document);
          if ($truthy(($truthy($a = reader['$has_more_lines?']()) ? reader['$next_line_empty?']()['$!']() : $a))) {
            
            rev_line = reader.$read_line();
            if ($truthy((match = $$($nesting, 'RevisionInfoLineRx').$match(rev_line)))) {
              
              rev_metadata = $hash2([], {});
              if ($truthy(match['$[]'](1))) {
                
                $writer = ["revnumber", match['$[]'](1).$rstrip()];
                $send(rev_metadata, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];};
              if ($truthy((component = match['$[]'](2).$strip())['$empty?']())) {
              } else if ($truthy(($truthy($a = match['$[]'](1)['$!']()) ? component['$start_with?']("v") : $a))) {
                
                $writer = ["revnumber", component.$slice(1, component.$length())];
                $send(rev_metadata, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];
              } else {
                
                $writer = ["revdate", component];
                $send(rev_metadata, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];
              };
              if ($truthy(match['$[]'](3))) {
                
                $writer = ["revremark", match['$[]'](3).$rstrip()];
                $send(rev_metadata, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];};
              if ($truthy(($truthy($a = document) ? rev_metadata['$empty?']()['$!']() : $a))) {
                $send(rev_metadata, 'each', [], ($$43 = function(key, val){var self = $$43.$$s || this;

                
                  
                  if (key == null) {
                    key = nil;
                  };
                  
                  if (val == null) {
                    val = nil;
                  };
                  if ($truthy(doc_attrs['$key?'](key))) {
                    return nil
                  } else {
                    
                    $writer = [key, document.$apply_header_subs(val)];
                    $send(doc_attrs, '[]=', Opal.to_a($writer));
                    return $writer[$rb_minus($writer["length"], 1)];
                  };}, $$43.$$s = self, $$43.$$arity = 2, $$43))};
            } else {
              reader.$unshift_line(rev_line)
            };};
          self.$process_attribute_entries(reader, document);
          reader.$skip_blank_lines();
        } else {
          implicit_author_metadata = $hash2([], {})
        };
        if ($truthy(document)) {
          
          if ($truthy(($truthy($a = doc_attrs['$key?']("author")) ? (author_line = doc_attrs['$[]']("author"))['$!='](implicit_author) : $a))) {
            
            author_metadata = self.$process_authors(author_line, true, false);
            if ($truthy(doc_attrs['$[]']("authorinitials")['$!='](implicit_authorinitials))) {
              author_metadata.$delete("authorinitials")};
          } else if ($truthy(($truthy($a = doc_attrs['$key?']("authors")) ? (author_line = doc_attrs['$[]']("authors"))['$!='](implicit_authors) : $a))) {
            author_metadata = self.$process_authors(author_line, true)
          } else {
            
            $a = [[], 1, "author_1", false, false], (authors = $a[0]), (author_idx = $a[1]), (author_key = $a[2]), (explicit = $a[3]), (sparse = $a[4]), $a;
            while ($truthy(doc_attrs['$key?'](author_key))) {
              
              if ((author_override = doc_attrs['$[]'](author_key))['$=='](implicit_author_metadata['$[]'](author_key))) {
                
                authors['$<<'](nil);
                sparse = true;
              } else {
                
                authors['$<<'](author_override);
                explicit = true;
              };
              author_key = "" + "author_" + ((author_idx = $rb_plus(author_idx, 1)));
            };
            if ($truthy(explicit)) {
              
              if ($truthy(sparse)) {
                $send(authors, 'each_with_index', [], ($$44 = function(author, idx){var self = $$44.$$s || this, $$45, name_idx = nil;

                
                  
                  if (author == null) {
                    author = nil;
                  };
                  
                  if (idx == null) {
                    idx = nil;
                  };
                  if ($truthy(author)) {
                    return nil;};
                  
                  $writer = [idx, $send([implicit_author_metadata['$[]']("" + "firstname_" + ((name_idx = $rb_plus(idx, 1)))), implicit_author_metadata['$[]']("" + "middlename_" + (name_idx)), implicit_author_metadata['$[]']("" + "lastname_" + (name_idx))].$compact(), 'map', [], ($$45 = function(it){var self = $$45.$$s || this;

                  
                    
                    if (it == null) {
                      it = nil;
                    };
                    return it.$tr(" ", "_");}, $$45.$$s = self, $$45.$$arity = 1, $$45)).$join(" ")];
                  $send(authors, '[]=', Opal.to_a($writer));
                  return $writer[$rb_minus($writer["length"], 1)];;}, $$44.$$s = self, $$44.$$arity = 2, $$44))};
              author_metadata = self.$process_authors(authors, true, false);
            } else {
              author_metadata = $hash2(["authorcount"], {"authorcount": 0})
            };
          };
          if (author_metadata['$[]']("authorcount")['$=='](0)) {
            if ($truthy(authorcount)) {
              author_metadata = nil
            } else {
              
              $writer = ["authorcount", 0];
              $send(doc_attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            }
          } else {
            
            doc_attrs.$update(author_metadata);
            if ($truthy(($truthy($a = doc_attrs['$key?']("email")['$!']()) ? doc_attrs['$key?']("email_1") : $a))) {
              
              $writer = ["email", doc_attrs['$[]']("email_1")];
              $send(doc_attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
          };};
        if ($truthy(retrieve)) {
          return implicit_author_metadata.$merge(rev_metadata.$to_h(), author_metadata.$to_h())
        } else {
          return nil
        };
      }, $Parser_parse_header_metadata$41.$$arity = -2);
      Opal.defs(self, '$process_authors', $Parser_process_authors$46 = function $$process_authors(author_line, names_only, multiple) {
        var $a, $$47, self = this, author_metadata = nil, author_idx = nil, $writer = nil;

        
        
        if (names_only == null) {
          names_only = false;
        };
        
        if (multiple == null) {
          multiple = true;
        };
        author_metadata = $hash2([], {});
        author_idx = 0;
        $send((function() {if ($truthy(($truthy($a = multiple) ? author_line['$include?'](";") : $a))) {
          
          return author_line.$split($$($nesting, 'AuthorDelimiterRx'));
        } else {
          return [].concat(Opal.to_a(author_line))
        }; return nil; })(), 'each', [], ($$47 = function(author_entry){var self = $$47.$$s || this, $$48, $$49, $b, $$50, key_map = nil, $writer = nil, segments = nil, match = nil, author = nil, fname = nil, mname = nil, lname = nil;

        
          
          if (author_entry == null) {
            author_entry = nil;
          };
          if ($truthy(author_entry['$empty?']())) {
            return nil;};
          key_map = $hash2([], {});
          if ((author_idx = $rb_plus(author_idx, 1))['$=='](1)) {
            $send($$($nesting, 'AuthorKeys'), 'each', [], ($$48 = function(key){var self = $$48.$$s || this, $writer = nil;

            
              
              if (key == null) {
                key = nil;
              };
              $writer = [key.$to_sym(), key];
              $send(key_map, '[]=', Opal.to_a($writer));
              return $writer[$rb_minus($writer["length"], 1)];}, $$48.$$s = self, $$48.$$arity = 1, $$48))
          } else {
            $send($$($nesting, 'AuthorKeys'), 'each', [], ($$49 = function(key){var self = $$49.$$s || this, $writer = nil;

            
              
              if (key == null) {
                key = nil;
              };
              $writer = [key.$to_sym(), "" + (key) + "_" + (author_idx)];
              $send(key_map, '[]=', Opal.to_a($writer));
              return $writer[$rb_minus($writer["length"], 1)];}, $$49.$$s = self, $$49.$$arity = 1, $$49))
          };
          if ($truthy(names_only)) {
            
            if ($truthy(author_entry['$include?']("<"))) {
              
              
              $writer = [key_map['$[]']("author"), author_entry.$tr("_", " ")];
              $send(author_metadata, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              author_entry = author_entry.$gsub($$($nesting, 'XmlSanitizeRx'), "");};
            if ((segments = author_entry.$split(nil, 3)).$size()['$=='](3)) {
              segments['$<<'](segments.$pop().$squeeze(" "))};
          } else if ($truthy((match = $$($nesting, 'AuthorInfoLineRx').$match(author_entry)))) {
            (segments = match.$to_a()).$shift()};
          if ($truthy(segments)) {
            
            author = (($writer = [key_map['$[]']("firstname"), (fname = segments['$[]'](0).$tr("_", " "))]), $send(author_metadata, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]);
            
            $writer = [key_map['$[]']("authorinitials"), fname.$chr()];
            $send(author_metadata, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            if ($truthy(segments['$[]'](1))) {
              if ($truthy(segments['$[]'](2))) {
                
                
                $writer = [key_map['$[]']("middlename"), (mname = segments['$[]'](1).$tr("_", " "))];
                $send(author_metadata, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                
                $writer = [key_map['$[]']("lastname"), (lname = segments['$[]'](2).$tr("_", " "))];
                $send(author_metadata, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                author = $rb_plus($rb_plus($rb_plus($rb_plus(fname, " "), mname), " "), lname);
                
                $writer = [key_map['$[]']("authorinitials"), "" + (fname.$chr()) + (mname.$chr()) + (lname.$chr())];
                $send(author_metadata, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
              } else {
                
                
                $writer = [key_map['$[]']("lastname"), (lname = segments['$[]'](1).$tr("_", " "))];
                $send(author_metadata, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                author = $rb_plus($rb_plus(fname, " "), lname);
                
                $writer = [key_map['$[]']("authorinitials"), "" + (fname.$chr()) + (lname.$chr())];
                $send(author_metadata, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
              }};
            ($truthy($b = author_metadata['$[]'](key_map['$[]']("author"))) ? $b : (($writer = [key_map['$[]']("author"), author]), $send(author_metadata, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
            if ($truthy(($truthy($b = names_only) ? $b : segments['$[]'](3)['$!']()))) {
            } else {
              
              $writer = [key_map['$[]']("email"), segments['$[]'](3)];
              $send(author_metadata, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            };
          } else {
            
            
            $writer = [key_map['$[]']("author"), (($writer = [key_map['$[]']("firstname"), (fname = author_entry.$squeeze(" ").$strip())]), $send(author_metadata, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])];
            $send(author_metadata, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            
            $writer = [key_map['$[]']("authorinitials"), fname.$chr()];
            $send(author_metadata, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
          };
          if (author_idx['$=='](1)) {
            
            $writer = ["authors", author_metadata['$[]'](key_map['$[]']("author"))];
            $send(author_metadata, '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];
          } else {
            
            if (author_idx['$=='](2)) {
              $send($$($nesting, 'AuthorKeys'), 'each', [], ($$50 = function(key){var self = $$50.$$s || this;

              
                
                if (key == null) {
                  key = nil;
                };
                if ($truthy(author_metadata['$key?'](key))) {
                  
                  $writer = ["" + (key) + "_1", author_metadata['$[]'](key)];
                  $send(author_metadata, '[]=', Opal.to_a($writer));
                  return $writer[$rb_minus($writer["length"], 1)];
                } else {
                  return nil
                };}, $$50.$$s = self, $$50.$$arity = 1, $$50))};
            
            $writer = ["authors", "" + (author_metadata['$[]']("authors")) + ", " + (author_metadata['$[]'](key_map['$[]']("author")))];
            $send(author_metadata, '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];;
          };}, $$47.$$s = self, $$47.$$arity = 1, $$47));
        
        $writer = ["authorcount", author_idx];
        $send(author_metadata, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        return author_metadata;
      }, $Parser_process_authors$46.$$arity = -2);
      Opal.defs(self, '$parse_block_metadata_lines', $Parser_parse_block_metadata_lines$51 = function $$parse_block_metadata_lines(reader, document, attributes, options) {
        var $a, $b, self = this;

        
        
        if (attributes == null) {
          attributes = $hash2([], {});
        };
        
        if (options == null) {
          options = $hash2([], {});
        };
        while ($truthy(self.$parse_block_metadata_line(reader, document, attributes, options))) {
          
          reader.$shift();
          if ($truthy($b = reader.$skip_blank_lines())) {
            $b
          } else {
            break;
          };
        };
        return attributes;
      }, $Parser_parse_block_metadata_lines$51.$$arity = -3);
      Opal.defs(self, '$parse_block_metadata_line', $Parser_parse_block_metadata_line$52 = function $$parse_block_metadata_line(reader, document, attributes, options) {
        var $a, $b, self = this, next_line = nil, normal = nil, $writer = nil, reftext = nil, current_style = nil, ll = nil;
        if ($gvars["~"] == null) $gvars["~"] = nil;

        
        
        if (options == null) {
          options = $hash2([], {});
        };
        if ($truthy(($truthy($a = (next_line = reader.$peek_line())) ? (function() {if ($truthy(options['$[]']("text_only"))) {
          
          return next_line['$start_with?']("[", "/");
        } else {
          
          return (normal = next_line['$start_with?']("[", ".", "/", ":"));
        }; return nil; })() : $a))) {
          if ($truthy(next_line['$start_with?']("["))) {
            if ($truthy(next_line['$start_with?']("[["))) {
              if ($truthy(($truthy($a = next_line['$end_with?']("]]")) ? $$($nesting, 'BlockAnchorRx')['$=~'](next_line) : $a))) {
                
                
                $writer = ["id", (($a = $gvars['~']) === nil ? nil : $a['$[]'](1))];
                $send(attributes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                if ($truthy((reftext = (($a = $gvars['~']) === nil ? nil : $a['$[]'](2))))) {
                  
                  $writer = ["reftext", (function() {if ($truthy(reftext['$include?']($$($nesting, 'ATTR_REF_HEAD')))) {
                    
                    return document.$sub_attributes(reftext);
                  } else {
                    return reftext
                  }; return nil; })()];
                  $send(attributes, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];};
                return true;}
            } else if ($truthy(($truthy($a = next_line['$end_with?']("]")) ? $$($nesting, 'BlockAttributeListRx')['$=~'](next_line) : $a))) {
              
              current_style = attributes['$[]'](1);
              if ($truthy(document.$parse_attributes((($a = $gvars['~']) === nil ? nil : $a['$[]'](1)), [], $hash2(["sub_input", "sub_result", "into"], {"sub_input": true, "sub_result": true, "into": attributes}))['$[]'](1))) {
                
                $writer = [1, ($truthy($a = self.$parse_style_attribute(attributes, reader)) ? $a : current_style)];
                $send(attributes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];};
              return true;}
          } else if ($truthy(($truthy($a = normal) ? next_line['$start_with?'](".") : $a))) {
            if ($truthy($$($nesting, 'BlockTitleRx')['$=~'](next_line))) {
              
              
              $writer = ["title", (($a = $gvars['~']) === nil ? nil : $a['$[]'](1))];
              $send(attributes, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              return true;}
          } else if ($truthy(($truthy($a = normal['$!']()) ? $a : next_line['$start_with?']("/")))) {
            if ($truthy(next_line['$start_with?']("//"))) {
              if (next_line['$==']("//")) {
                return true
              } else if ($truthy(($truthy($a = normal) ? self['$uniform?'](next_line, "/", (ll = next_line.$length())) : $a))) {
                if (ll['$=='](3)) {
                } else {
                  
                  reader.$read_lines_until($hash2(["terminator", "skip_first_line", "preserve_last_line", "skip_processing", "context"], {"terminator": next_line, "skip_first_line": true, "preserve_last_line": true, "skip_processing": true, "context": "comment"}));
                  return true;
                }
              } else if ($truthy(next_line['$start_with?']("///"))) {
              } else {
                return true
              }}
          } else if ($truthy(($truthy($a = ($truthy($b = normal) ? next_line['$start_with?'](":") : $b)) ? $$($nesting, 'AttributeEntryRx')['$=~'](next_line) : $a))) {
            
            self.$process_attribute_entry(reader, document, attributes, $gvars["~"]);
            return true;}};
        return nil;
      }, $Parser_parse_block_metadata_line$52.$$arity = -4);
      Opal.defs(self, '$process_attribute_entries', $Parser_process_attribute_entries$53 = function $$process_attribute_entries(reader, document, attributes) {
        var $a, self = this;

        
        
        if (attributes == null) {
          attributes = nil;
        };
        reader.$skip_comment_lines();
        while ($truthy(self.$process_attribute_entry(reader, document, attributes))) {
          
          reader.$shift();
          reader.$skip_comment_lines();
        };
      }, $Parser_process_attribute_entries$53.$$arity = -3);
      Opal.defs(self, '$process_attribute_entry', $Parser_process_attribute_entry$54 = function $$process_attribute_entry(reader, document, attributes, match) {
        var $a, $b, $c, self = this, value = nil, con = nil, next_line = nil, keep_open = nil;

        
        
        if (attributes == null) {
          attributes = nil;
        };
        
        if (match == null) {
          match = nil;
        };
        if ($truthy(($truthy($a = match) ? $a : (match = (function() {if ($truthy(reader['$has_more_lines?']())) {
          
          return $$($nesting, 'AttributeEntryRx').$match(reader.$peek_line());
        } else {
          return nil
        }; return nil; })())))) {
          
          if ($truthy((value = match['$[]'](2))['$nil_or_empty?']())) {
            value = ""
          } else if ($truthy(value['$end_with?']($$($nesting, 'LINE_CONTINUATION'), $$($nesting, 'LINE_CONTINUATION_LEGACY')))) {
            
            $a = [value.$slice($rb_minus(value.$length(), 2), 2), value.$slice(0, $rb_minus(value.$length(), 2)).$rstrip()], (con = $a[0]), (value = $a[1]), $a;
            while ($truthy(($truthy($b = reader.$advance()) ? (next_line = ($truthy($c = reader.$peek_line()) ? $c : ""))['$empty?']()['$!']() : $b))) {
              
              next_line = next_line.$lstrip();
              if ($truthy((keep_open = next_line['$end_with?'](con)))) {
                next_line = next_line.$slice(0, $rb_minus(next_line.$length(), 2)).$rstrip()};
              value = "" + (value) + ((function() {if ($truthy(value['$end_with?']($$($nesting, 'HARD_LINE_BREAK')))) {
                return $$($nesting, 'LF')
              } else {
                return " "
              }; return nil; })()) + (next_line);
              if ($truthy(keep_open)) {
              } else {
                break;
              };
            };};
          self.$store_attribute(match['$[]'](1), value, document, attributes);
          return true;
        } else {
          return nil
        };
      }, $Parser_process_attribute_entry$54.$$arity = -3);
      Opal.defs(self, '$store_attribute', $Parser_store_attribute$55 = function $$store_attribute(name, value, doc, attrs) {
        var $a, self = this, resolved_value = nil;

        
        
        if (doc == null) {
          doc = nil;
        };
        
        if (attrs == null) {
          attrs = nil;
        };
        if ($truthy(name['$end_with?']("!"))) {
          
          name = name.$chop();
          value = nil;
        } else if ($truthy(name['$start_with?']("!"))) {
          
          name = name.$slice(1, name.$length());
          value = nil;};
        if ((name = self.$sanitize_attribute_name(name))['$==']("numbered")) {
          name = "sectnums"
        } else if (name['$==']("hardbreaks")) {
          name = "hardbreaks-option"
        } else if (name['$==']("showtitle")) {
          self.$store_attribute("notitle", (function() {if ($truthy(value)) {
            return nil
          } else {
            return ""
          }; return nil; })(), doc, attrs)};
        if ($truthy(doc)) {
          if ($truthy(value)) {
            
            if (name['$==']("leveloffset")) {
              if ($truthy(value['$start_with?']("+"))) {
                value = $rb_plus(doc.$attr("leveloffset", 0).$to_i(), value.$slice(1, value.$length()).$to_i()).$to_s()
              } else if ($truthy(value['$start_with?']("-"))) {
                value = $rb_minus(doc.$attr("leveloffset", 0).$to_i(), value.$slice(1, value.$length()).$to_i()).$to_s()}};
            if ($truthy((resolved_value = doc.$set_attribute(name, value)))) {
              
              value = resolved_value;
              if ($truthy(attrs)) {
                $$$($$($nesting, 'Document'), 'AttributeEntry').$new(name, value).$save_to(attrs)};};
          } else if ($truthy(($truthy($a = doc.$delete_attribute(name)) ? attrs : $a))) {
            $$$($$($nesting, 'Document'), 'AttributeEntry').$new(name, value).$save_to(attrs)}
        } else if ($truthy(attrs)) {
          $$$($$($nesting, 'Document'), 'AttributeEntry').$new(name, value).$save_to(attrs)};
        return [name, value];
      }, $Parser_store_attribute$55.$$arity = -3);
      Opal.defs(self, '$resolve_list_marker', $Parser_resolve_list_marker$56 = function $$resolve_list_marker(list_type, marker, ordinal, validate, reader) {
        var self = this, $case = nil;

        
        
        if (ordinal == null) {
          ordinal = 0;
        };
        
        if (validate == null) {
          validate = false;
        };
        
        if (reader == null) {
          reader = nil;
        };
        return (function() {$case = list_type;
        if ("ulist"['$===']($case)) {return marker}
        else if ("olist"['$===']($case)) {return self.$resolve_ordered_list_marker(marker, ordinal, validate, reader)['$[]'](0)}
        else {return "<1>"}})();
      }, $Parser_resolve_list_marker$56.$$arity = -3);
      Opal.defs(self, '$resolve_ordered_list_marker', $Parser_resolve_ordered_list_marker$57 = function $$resolve_ordered_list_marker(marker, ordinal, validate, reader) {
        var $$58, $a, self = this, $case = nil, style = nil, expected = nil, actual = nil;

        
        
        if (ordinal == null) {
          ordinal = 0;
        };
        
        if (validate == null) {
          validate = false;
        };
        
        if (reader == null) {
          reader = nil;
        };
        if ($truthy(marker['$start_with?']("."))) {
          return [marker]};
        $case = (style = $send($$($nesting, 'ORDERED_LIST_STYLES'), 'find', [], ($$58 = function(s){var self = $$58.$$s || this;

        
          
          if (s == null) {
            s = nil;
          };
          return $$($nesting, 'OrderedListMarkerRxMap')['$[]'](s)['$match?'](marker);}, $$58.$$s = self, $$58.$$arity = 1, $$58)));
        if ("arabic"['$===']($case)) {
        if ($truthy(validate)) {
          
          expected = $rb_plus(ordinal, 1);
          actual = marker.$to_i();};
        marker = "1.";}
        else if ("loweralpha"['$===']($case)) {
        if ($truthy(validate)) {
          
          expected = $rb_plus("a"['$[]'](0).$ord(), ordinal).$chr();
          actual = marker.$chop();};
        marker = "a.";}
        else if ("upperalpha"['$===']($case)) {
        if ($truthy(validate)) {
          
          expected = $rb_plus("A"['$[]'](0).$ord(), ordinal).$chr();
          actual = marker.$chop();};
        marker = "A.";}
        else if ("lowerroman"['$===']($case)) {
        if ($truthy(validate)) {
          
          expected = $$($nesting, 'Helpers').$int_to_roman($rb_plus(ordinal, 1)).$downcase();
          actual = marker.$chop();};
        marker = "i)";}
        else if ("upperroman"['$===']($case)) {
        if ($truthy(validate)) {
          
          expected = $$($nesting, 'Helpers').$int_to_roman($rb_plus(ordinal, 1));
          actual = marker.$chop();};
        marker = "I)";};
        if ($truthy(($truthy($a = validate) ? expected['$!='](actual) : $a))) {
          self.$logger().$warn(self.$message_with_context("" + "list item index: expected " + (expected) + ", got " + (actual), $hash2(["source_location"], {"source_location": reader.$cursor()})))};
        return [marker, style];
      }, $Parser_resolve_ordered_list_marker$57.$$arity = -2);
      Opal.defs(self, '$is_sibling_list_item?', $Parser_is_sibling_list_item$ques$59 = function(line, list_type, sibling_trait) {
        var $a, $b, self = this;

        if ($truthy($$$('::', 'Regexp')['$==='](sibling_trait))) {
          return sibling_trait['$match?'](line)
        } else {
          return ($truthy($a = $$($nesting, 'ListRxMap')['$[]'](list_type)['$=~'](line)) ? sibling_trait['$=='](self.$resolve_list_marker(list_type, (($b = $gvars['~']) === nil ? nil : $b['$[]'](1)))) : $a)
        }
      }, $Parser_is_sibling_list_item$ques$59.$$arity = 3);
      Opal.defs(self, '$parse_table', $Parser_parse_table$60 = function $$parse_table(table_reader, parent, attributes) {
        var $a, $b, $c, $d, self = this, table = nil, colspecs = nil, explicit_colspecs = nil, skipped = nil, $writer = nil, implicit_header = nil, parser_ctx = nil, format = nil, loop_idx = nil, implicit_header_boundary = nil, line = nil, beyond_first = nil, next_cellspec = nil, m = nil, pre_match = nil, post_match = nil, $case = nil, cell_text = nil, $logical_op_recvr_tmp_2 = nil;

        
        table = $$($nesting, 'Table').$new(parent, attributes);
        if ($truthy(($truthy($a = attributes['$key?']("cols")) ? (colspecs = self.$parse_colspecs(attributes['$[]']("cols")))['$empty?']()['$!']() : $a))) {
          
          table.$create_columns(colspecs);
          explicit_colspecs = true;};
        skipped = ($truthy($a = table_reader.$skip_blank_lines()) ? $a : 0);
        if ($truthy(attributes['$[]']("header-option"))) {
          
          $writer = [true];
          $send(table, 'has_header_option=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];
        } else if ($truthy((($a = skipped['$=='](0)) ? attributes['$[]']("noheader-option")['$!']() : skipped['$=='](0)))) {
          
          
          $writer = ["implicit"];
          $send(table, 'has_header_option=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          implicit_header = true;};
        parser_ctx = $$$($$($nesting, 'Table'), 'ParserContext').$new(table_reader, table, attributes);
        $a = [parser_ctx.$format(), -1, nil], (format = $a[0]), (loop_idx = $a[1]), (implicit_header_boundary = $a[2]), $a;
        $a = false; while ($a || $truthy((line = table_reader.$read_line()))) {$a = false;
          
          if ($truthy(($truthy($b = (beyond_first = $rb_gt((loop_idx = $rb_plus(loop_idx, 1)), 0))) ? line['$empty?']() : $b))) {
            
            line = nil;
            if ($truthy(implicit_header_boundary)) {
              implicit_header_boundary = $rb_plus(implicit_header_boundary, 1)};
          } else if (format['$==']("psv")) {
            if ($truthy(parser_ctx['$starts_with_delimiter?'](line))) {
              
              line = line.$slice(1, line.$length());
              parser_ctx.$close_open_cell();
              if ($truthy(implicit_header_boundary)) {
                implicit_header_boundary = nil};
            } else {
              
              $c = self.$parse_cellspec(line, "start", parser_ctx.$delimiter()), $b = Opal.to_ary($c), (next_cellspec = ($b[0] == null ? nil : $b[0])), (line = ($b[1] == null ? nil : $b[1])), $c;
              if ($truthy(next_cellspec)) {
                
                parser_ctx.$close_open_cell(next_cellspec);
                if ($truthy(implicit_header_boundary)) {
                  implicit_header_boundary = nil};
              } else if ($truthy(($truthy($b = implicit_header_boundary) ? implicit_header_boundary['$=='](loop_idx) : $b))) {
                
                $writer = [(implicit_header = (implicit_header_boundary = nil))];
                $send(table, 'has_header_option=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];};
            }};
          if ($truthy(beyond_first)) {
          } else {
            
            table_reader.$mark();
            if ($truthy(implicit_header)) {
              if ($truthy(($truthy($b = table_reader['$has_more_lines?']()) ? table_reader.$peek_line()['$empty?']() : $b))) {
                implicit_header_boundary = 1
              } else {
                
                $writer = [(implicit_header = nil)];
                $send(table, 'has_header_option=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];
              }};
          };
          $b = false; while ($b || $truthy(true)) {$b = false;
            if ($truthy(($truthy($c = line) ? (m = parser_ctx.$match_delimiter(line)) : $c))) {
              
              $c = [m.$pre_match(), m.$post_match()], (pre_match = $c[0]), (post_match = $c[1]), $c;
              $case = format;
              if ("csv"['$===']($case)) {
              if ($truthy(parser_ctx['$buffer_has_unclosed_quotes?'](pre_match))) {
                
                parser_ctx.$skip_past_delimiter(pre_match);
                if ($truthy((line = post_match)['$empty?']())) {
                  break;};
                $b = true; continue;;};
              
              $writer = ["" + (parser_ctx.$buffer()) + (pre_match)];
              $send(parser_ctx, 'buffer=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;}
              else if ("dsv"['$===']($case)) {
              if ($truthy(pre_match['$end_with?']("\\"))) {
                
                parser_ctx.$skip_past_escaped_delimiter(pre_match);
                if ($truthy((line = post_match)['$empty?']())) {
                  
                  
                  $writer = ["" + (parser_ctx.$buffer()) + ($$($nesting, 'LF'))];
                  $send(parser_ctx, 'buffer=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];;
                  parser_ctx.$keep_cell_open();
                  break;;};
                $b = true; continue;;};
              
              $writer = ["" + (parser_ctx.$buffer()) + (pre_match)];
              $send(parser_ctx, 'buffer=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;}
              else {
              if ($truthy(pre_match['$end_with?']("\\"))) {
                
                parser_ctx.$skip_past_escaped_delimiter(pre_match);
                if ($truthy((line = post_match)['$empty?']())) {
                  
                  
                  $writer = ["" + (parser_ctx.$buffer()) + ($$($nesting, 'LF'))];
                  $send(parser_ctx, 'buffer=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];;
                  parser_ctx.$keep_cell_open();
                  break;;};
                $b = true; continue;;};
              $d = self.$parse_cellspec(pre_match), $c = Opal.to_ary($d), (next_cellspec = ($c[0] == null ? nil : $c[0])), (cell_text = ($c[1] == null ? nil : $c[1])), $d;
              parser_ctx.$push_cellspec(next_cellspec);
              
              $writer = ["" + (parser_ctx.$buffer()) + (cell_text)];
              $send(parser_ctx, 'buffer=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;};
              if ($truthy((line = post_match)['$empty?']())) {
                line = nil};
              parser_ctx.$close_cell();
            } else {
              
              
              $writer = ["" + (parser_ctx.$buffer()) + (line) + ($$($nesting, 'LF'))];
              $send(parser_ctx, 'buffer=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              $case = format;
              if ("csv"['$===']($case)) {if ($truthy(parser_ctx['$buffer_has_unclosed_quotes?']())) {
                
                if ($truthy(($truthy($c = implicit_header_boundary) ? loop_idx['$=='](0) : $c))) {
                  
                  $writer = [(implicit_header = (implicit_header_boundary = nil))];
                  $send(table, 'has_header_option=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];};
                parser_ctx.$keep_cell_open();
              } else {
                parser_ctx.$close_cell(true)
              }}
              else if ("dsv"['$===']($case)) {parser_ctx.$close_cell(true)}
              else {parser_ctx.$keep_cell_open()};
              break;;
            }
          };
          if ($truthy(parser_ctx['$cell_open?']())) {
            if ($truthy(table_reader['$has_more_lines?']())) {
            } else {
              parser_ctx.$close_cell(true)
            }
          } else {
            if ($truthy($b = table_reader.$skip_blank_lines())) {
              $b
            } else {
              break;
            }
          };
        };
        if ($truthy(($truthy($a = (($logical_op_recvr_tmp_2 = table.$attributes()), ($truthy($b = $logical_op_recvr_tmp_2['$[]']("colcount")) ? $b : (($writer = ["colcount", table.$columns().$size()]), $send($logical_op_recvr_tmp_2, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])))['$=='](0)) ? $a : explicit_colspecs))) {
        } else {
          table.$assign_column_widths()
        };
        if ($truthy(implicit_header)) {
          
          $writer = [true];
          $send(table, 'has_header_option=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        table.$partition_header_footer(attributes);
        return table;
      }, $Parser_parse_table$60.$$arity = 3);
      Opal.defs(self, '$parse_colspecs', $Parser_parse_colspecs$61 = function $$parse_colspecs(records) {
        var $$62, $$63, self = this, specs = nil;

        
        if ($truthy(records['$include?'](" "))) {
          records = records.$delete(" ")};
        if (records['$=='](records.$to_i().$to_s())) {
          return $send($$$('::', 'Array'), 'new', [records.$to_i()], ($$62 = function(){var self = $$62.$$s || this;

          return $hash2(["width"], {"width": 1})}, $$62.$$s = self, $$62.$$arity = 0, $$62))};
        specs = [];
        $send((function() {if ($truthy(records['$include?'](","))) {
          
          return records.$split(",", -1);
        } else {
          
          return records.$split(";", -1);
        }; return nil; })(), 'each', [], ($$63 = function(record){var self = $$63.$$s || this, $a, $b, $$64, m = nil, spec = nil, colspec = nil, rowspec = nil, $writer = nil, width = nil;

        
          
          if (record == null) {
            record = nil;
          };
          if ($truthy(record['$empty?']())) {
            return specs['$<<']($hash2(["width"], {"width": 1}))
          } else if ($truthy((m = $$($nesting, 'ColumnSpecRx').$match(record)))) {
            
            spec = $hash2([], {});
            if ($truthy(m['$[]'](2))) {
              
              $b = m['$[]'](2).$split("."), $a = Opal.to_ary($b), (colspec = ($a[0] == null ? nil : $a[0])), (rowspec = ($a[1] == null ? nil : $a[1])), $b;
              if ($truthy(($truthy($a = colspec['$nil_or_empty?']()['$!']()) ? $$($nesting, 'TableCellHorzAlignments')['$key?'](colspec) : $a))) {
                
                $writer = ["halign", $$($nesting, 'TableCellHorzAlignments')['$[]'](colspec)];
                $send(spec, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];};
              if ($truthy(($truthy($a = rowspec['$nil_or_empty?']()['$!']()) ? $$($nesting, 'TableCellVertAlignments')['$key?'](rowspec) : $a))) {
                
                $writer = ["valign", $$($nesting, 'TableCellVertAlignments')['$[]'](rowspec)];
                $send(spec, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];};};
            if ($truthy((width = m['$[]'](3)))) {
              
              $writer = ["width", (function() {if (width['$==']("~")) {
                return -1
              } else {
                return width.$to_i()
              }; return nil; })()];
              $send(spec, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            } else {
              
              $writer = ["width", 1];
              $send(spec, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            };
            if ($truthy(($truthy($a = m['$[]'](4)) ? $$($nesting, 'TableCellStyles')['$key?'](m['$[]'](4)) : $a))) {
              
              $writer = ["style", $$($nesting, 'TableCellStyles')['$[]'](m['$[]'](4))];
              $send(spec, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
            if ($truthy(m['$[]'](1))) {
              return $send((1), 'upto', [m['$[]'](1).$to_i()], ($$64 = function(){var self = $$64.$$s || this;

              return specs['$<<'](spec.$merge())}, $$64.$$s = self, $$64.$$arity = 0, $$64))
            } else {
              return specs['$<<'](spec)
            };
          } else {
            return nil
          };}, $$63.$$s = self, $$63.$$arity = 1, $$63));
        return specs;
      }, $Parser_parse_colspecs$61.$$arity = 1);
      Opal.defs(self, '$parse_cellspec', $Parser_parse_cellspec$65 = function $$parse_cellspec(line, pos, delimiter) {
        var $a, $b, self = this, m = nil, rest = nil, spec_part = nil, _ = nil, spec = nil, colspec = nil, rowspec = nil, $case = nil, $writer = nil;

        
        
        if (pos == null) {
          pos = "end";
        };
        
        if (delimiter == null) {
          delimiter = nil;
        };
        $a = [nil, ""], (m = $a[0]), (rest = $a[1]), $a;
        if (pos['$==']("start")) {
          if ($truthy(line['$include?'](delimiter))) {
            
            $b = line.$partition(delimiter), $a = Opal.to_ary($b), (spec_part = ($a[0] == null ? nil : $a[0])), (_ = ($a[1] == null ? nil : $a[1])), (rest = ($a[2] == null ? nil : $a[2])), $b;
            if ($truthy((m = $$($nesting, 'CellSpecStartRx').$match(spec_part)))) {
              if ($truthy(m['$[]'](0)['$empty?']())) {
                return [$hash2([], {}), rest]}
            } else {
              return [nil, line]
            };
          } else {
            return [nil, line]
          }
        } else if ($truthy((m = $$($nesting, 'CellSpecEndRx').$match(line)))) {
          
          if ($truthy(m['$[]'](0).$lstrip()['$empty?']())) {
            return [$hash2([], {}), line.$rstrip()]};
          rest = m.$pre_match();
        } else {
          return [$hash2([], {}), line]
        };
        spec = $hash2([], {});
        if ($truthy(m['$[]'](1))) {
          
          $b = m['$[]'](1).$split("."), $a = Opal.to_ary($b), (colspec = ($a[0] == null ? nil : $a[0])), (rowspec = ($a[1] == null ? nil : $a[1])), $b;
          colspec = (function() {if ($truthy(colspec['$nil_or_empty?']())) {
            return 1
          } else {
            return colspec.$to_i()
          }; return nil; })();
          rowspec = (function() {if ($truthy(rowspec['$nil_or_empty?']())) {
            return 1
          } else {
            return rowspec.$to_i()
          }; return nil; })();
          $case = m['$[]'](2);
          if ("+"['$===']($case)) {
          if (colspec['$=='](1)) {
          } else {
            
            $writer = ["colspan", colspec];
            $send(spec, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          };
          if (rowspec['$=='](1)) {
          } else {
            
            $writer = ["rowspan", rowspec];
            $send(spec, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          };}
          else if ("*"['$===']($case)) {if (colspec['$=='](1)) {
          } else {
            
            $writer = ["repeatcol", colspec];
            $send(spec, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          }};};
        if ($truthy(m['$[]'](3))) {
          
          $b = m['$[]'](3).$split("."), $a = Opal.to_ary($b), (colspec = ($a[0] == null ? nil : $a[0])), (rowspec = ($a[1] == null ? nil : $a[1])), $b;
          if ($truthy(($truthy($a = colspec['$nil_or_empty?']()['$!']()) ? $$($nesting, 'TableCellHorzAlignments')['$key?'](colspec) : $a))) {
            
            $writer = ["halign", $$($nesting, 'TableCellHorzAlignments')['$[]'](colspec)];
            $send(spec, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          if ($truthy(($truthy($a = rowspec['$nil_or_empty?']()['$!']()) ? $$($nesting, 'TableCellVertAlignments')['$key?'](rowspec) : $a))) {
            
            $writer = ["valign", $$($nesting, 'TableCellVertAlignments')['$[]'](rowspec)];
            $send(spec, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};};
        if ($truthy(($truthy($a = m['$[]'](4)) ? $$($nesting, 'TableCellStyles')['$key?'](m['$[]'](4)) : $a))) {
          
          $writer = ["style", $$($nesting, 'TableCellStyles')['$[]'](m['$[]'](4))];
          $send(spec, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        return [spec, rest];
      }, $Parser_parse_cellspec$65.$$arity = -2);
      Opal.defs(self, '$parse_style_attribute', $Parser_parse_style_attribute$66 = function $$parse_style_attribute(attributes, reader) {
        var $a, $b, $$67, $$68, self = this, raw_style = nil, name = nil, accum = nil, parsed_attrs = nil, parsed_style = nil, $writer = nil, existing_role = nil;

        
        
        if (reader == null) {
          reader = nil;
        };
        if ($truthy(($truthy($a = ($truthy($b = (raw_style = attributes['$[]'](1))) ? raw_style['$include?'](" ")['$!']() : $b)) ? $$($nesting, 'Compliance').$shorthand_property_syntax() : $a))) {
          
          name = nil;
          accum = "";
          parsed_attrs = $hash2([], {});
          $send(raw_style, 'each_char', [], ($$67 = function(c){var self = $$67.$$s || this, $case = nil;

          
            
            if (c == null) {
              c = nil;
            };
            return (function() {$case = c;
            if ("."['$===']($case)) {
            self.$yield_buffered_attribute(parsed_attrs, name, accum, reader);
            accum = "";
            return (name = "role");}
            else if ("#"['$===']($case)) {
            self.$yield_buffered_attribute(parsed_attrs, name, accum, reader);
            accum = "";
            return (name = "id");}
            else if ("%"['$===']($case)) {
            self.$yield_buffered_attribute(parsed_attrs, name, accum, reader);
            accum = "";
            return (name = "option");}
            else {return (accum = $rb_plus(accum, c))}})();}, $$67.$$s = self, $$67.$$arity = 1, $$67));
          if ($truthy(name)) {
            
            self.$yield_buffered_attribute(parsed_attrs, name, accum, reader);
            if ($truthy((parsed_style = parsed_attrs['$[]']("style")))) {
              
              $writer = ["style", parsed_style];
              $send(attributes, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
            if ($truthy(parsed_attrs['$key?']("id"))) {
              
              $writer = ["id", parsed_attrs['$[]']("id")];
              $send(attributes, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
            if ($truthy(parsed_attrs['$key?']("role"))) {
              
              $writer = ["role", (function() {if ($truthy((existing_role = attributes['$[]']("role"))['$nil_or_empty?']())) {
                
                return parsed_attrs['$[]']("role").$join(" ");
              } else {
                return "" + (existing_role) + " " + (parsed_attrs['$[]']("role").$join(" "))
              }; return nil; })()];
              $send(attributes, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
            if ($truthy(parsed_attrs['$key?']("option"))) {
              $send(parsed_attrs['$[]']("option"), 'each', [], ($$68 = function(opt){var self = $$68.$$s || this;

              
                
                if (opt == null) {
                  opt = nil;
                };
                $writer = ["" + (opt) + "-option", ""];
                $send(attributes, '[]=', Opal.to_a($writer));
                return $writer[$rb_minus($writer["length"], 1)];}, $$68.$$s = self, $$68.$$arity = 1, $$68))};
            return parsed_style;
          } else {
            
            $writer = ["style", raw_style];
            $send(attributes, '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];
          };
        } else {
          
          $writer = ["style", raw_style];
          $send(attributes, '[]=', Opal.to_a($writer));
          return $writer[$rb_minus($writer["length"], 1)];
        };
      }, $Parser_parse_style_attribute$66.$$arity = -2);
      Opal.defs(self, '$yield_buffered_attribute', $Parser_yield_buffered_attribute$69 = function $$yield_buffered_attribute(attrs, name, value, reader) {
        var $a, self = this, $writer = nil;

        
        if ($truthy(name)) {
          if ($truthy(value['$empty?']())) {
            if ($truthy(reader)) {
              self.$logger().$warn(self.$message_with_context("" + "invalid empty " + (name) + " detected in style attribute", $hash2(["source_location"], {"source_location": reader.$cursor_at_prev_line()})))
            } else {
              self.$logger().$warn("" + "invalid empty " + (name) + " detected in style attribute")
            }
          } else if (name['$==']("id")) {
            
            if ($truthy(attrs['$key?']("id"))) {
              if ($truthy(reader)) {
                self.$logger().$warn(self.$message_with_context("multiple ids detected in style attribute", $hash2(["source_location"], {"source_location": reader.$cursor_at_prev_line()})))
              } else {
                self.$logger().$warn("multiple ids detected in style attribute")
              }};
            
            $writer = [name, value];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
          } else {
            ($truthy($a = attrs['$[]'](name)) ? $a : (($writer = [name, []]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))['$<<'](value)
          }
        } else if ($truthy(value['$empty?']())) {
        } else {
          
          $writer = ["style", value];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];
        };
        return nil;
      }, $Parser_yield_buffered_attribute$69.$$arity = 4);
      Opal.defs(self, '$adjust_indentation!', $Parser_adjust_indentation$excl$70 = function(lines, indent_size, tab_size) {
        var $a, $$71, $$72, $$75, $$76, $$77, $$78, self = this, full_tab_space = nil, block_indent = nil, new_block_indent = nil;

        
        
        if (indent_size == null) {
          indent_size = 0;
        };
        
        if (tab_size == null) {
          tab_size = 0;
        };
        if ($truthy(lines['$empty?']())) {
          return nil};
        if ($truthy(($truthy($a = $rb_gt(tab_size, 0)) ? $send(lines, 'any?', [], ($$71 = function(line){var self = $$71.$$s || this;

        
          
          if (line == null) {
            line = nil;
          };
          return line['$include?']($$($nesting, 'TAB'));}, $$71.$$s = self, $$71.$$arity = 1, $$71)) : $a))) {
          
          full_tab_space = $rb_times(" ", tab_size);
          (function(){var $brk = Opal.new_brk(); try {return $send(lines, 'map!', [], ($$72 = function(line){var self = $$72.$$s || this, $b, $$73, $$74, tab_idx = nil, leading_tabs = nil, spaces_added = nil, idx = nil, result = nil;

          
            
            if (line == null) {
              line = nil;
            };
            if ($truthy(($truthy($b = line['$empty?']()) ? $b : (tab_idx = line.$index($$($nesting, 'TAB')))['$nil?']()))) {
              return line
            } else {
              
              if (tab_idx['$=='](0)) {
                
                leading_tabs = 0;
                (function(){var $brk = Opal.new_brk(); try {return $send(line, 'each_byte', [], ($$73 = function(b){var self = $$73.$$s || this;

                
                  
                  if (b == null) {
                    b = nil;
                  };
                  if (b['$=='](9)) {
                  } else {
                    
                    Opal.brk(nil, $brk)
                  };
                  return (leading_tabs = $rb_plus(leading_tabs, 1));}, $$73.$$s = self, $$73.$$brk = $brk, $$73.$$arity = 1, $$73))
                } catch (err) { if (err === $brk) { return err.$v } else { throw err } }})();
                line = "" + ($rb_times(full_tab_space, leading_tabs)) + (line.$slice(leading_tabs, line.$length()));
                if ($truthy(line['$include?']($$($nesting, 'TAB')))) {
                } else {
                  return line;
                };};
              spaces_added = 0;
              idx = 0;
              result = "";
              $send(line, 'each_char', [], ($$74 = function(c){var self = $$74.$$s || this, offset = nil, spaces = nil;

              
                
                if (c == null) {
                  c = nil;
                };
                if (c['$==']($$($nesting, 'TAB'))) {
                  if ((offset = $rb_plus(idx, spaces_added))['$%'](tab_size)['$=='](0)) {
                    
                    spaces_added = $rb_plus(spaces_added, $rb_minus(tab_size, 1));
                    result = $rb_plus(result, full_tab_space);
                  } else {
                    
                    if ((spaces = $rb_minus(tab_size, offset['$%'](tab_size)))['$=='](1)) {
                    } else {
                      spaces_added = $rb_plus(spaces_added, $rb_minus(spaces, 1))
                    };
                    result = $rb_plus(result, $rb_times(" ", spaces));
                  }
                } else {
                  result = $rb_plus(result, c)
                };
                return (idx = $rb_plus(idx, 1));}, $$74.$$s = self, $$74.$$arity = 1, $$74));
              return result;
            };}, $$72.$$s = self, $$72.$$brk = $brk, $$72.$$arity = 1, $$72))
          } catch (err) { if (err === $brk) { return err.$v } else { throw err } }})();};
        if ($truthy($rb_lt(indent_size, 0))) {
          return nil};
        block_indent = nil;
        (function(){var $brk = Opal.new_brk(); try {return $send(lines, 'each', [], ($$75 = function(line){var self = $$75.$$s || this, $b, line_indent = nil;

        
          
          if (line == null) {
            line = nil;
          };
          if ($truthy(line['$empty?']())) {
            return nil;};
          if ((line_indent = $rb_minus(line.$length(), line.$lstrip().$length()))['$=='](0)) {
            
            block_indent = nil;
            
            Opal.brk(nil, $brk);};
          if ($truthy(($truthy($b = block_indent) ? $rb_lt(block_indent, line_indent) : $b))) {
            return nil
          } else {
            return (block_indent = line_indent)
          };}, $$75.$$s = self, $$75.$$brk = $brk, $$75.$$arity = 1, $$75))
        } catch (err) { if (err === $brk) { return err.$v } else { throw err } }})();
        if (indent_size['$=='](0)) {
          if ($truthy(block_indent)) {
            $send(lines, 'map!', [], ($$76 = function(line){var self = $$76.$$s || this;

            
              
              if (line == null) {
                line = nil;
              };
              if ($truthy(line['$empty?']())) {
                return line
              } else {
                
                return line.$slice(block_indent, line.$length());
              };}, $$76.$$s = self, $$76.$$arity = 1, $$76))}
        } else {
          
          new_block_indent = $rb_times(" ", indent_size);
          if ($truthy(block_indent)) {
            $send(lines, 'map!', [], ($$77 = function(line){var self = $$77.$$s || this;

            
              
              if (line == null) {
                line = nil;
              };
              if ($truthy(line['$empty?']())) {
                return line
              } else {
                return $rb_plus(new_block_indent, line.$slice(block_indent, line.$length()))
              };}, $$77.$$s = self, $$77.$$arity = 1, $$77))
          } else {
            $send(lines, 'map!', [], ($$78 = function(line){var self = $$78.$$s || this;

            
              
              if (line == null) {
                line = nil;
              };
              if ($truthy(line['$empty?']())) {
                return line
              } else {
                return $rb_plus(new_block_indent, line)
              };}, $$78.$$s = self, $$78.$$arity = 1, $$78))
          };
        };
        return nil;
      }, $Parser_adjust_indentation$excl$70.$$arity = -2);
      Opal.defs(self, '$uniform?', $Parser_uniform$ques$79 = function(str, chr, len) {
        var self = this;

        return str.$count(chr)['$=='](len)
      }, $Parser_uniform$ques$79.$$arity = 3);
      return (Opal.defs(self, '$sanitize_attribute_name', $Parser_sanitize_attribute_name$80 = function $$sanitize_attribute_name(name) {
        var self = this;

        return name.$gsub($$($nesting, 'InvalidAttributeNameCharsRx'), "").$downcase()
      }, $Parser_sanitize_attribute_name$80.$$arity = 1), nil) && 'sanitize_attribute_name';
    })($nesting[0], null, $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/path_resolver"] = function(Opal) {
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $truthy = Opal.truthy, $hash2 = Opal.hash2, $send = Opal.send, $gvars = Opal.gvars;

  Opal.add_stubs(['$include', '$attr_accessor', '$root?', '$posixify', '$expand_path', '$pwd', '$start_with?', '$==', '$match?', '$absolute_path?', '$+', '$length', '$descends_from?', '$slice', '$to_s', '$relative_path_from', '$new', '$include?', '$tr', '$partition_path', '$each', '$pop', '$<<', '$join_path', '$[]', '$web_root?', '$unc?', '$index', '$split', '$delete', '$[]=', '$-', '$join', '$raise', '$!', '$fetch', '$warn', '$logger', '$empty?', '$nil_or_empty?', '$chomp', '$!=', '$>', '$size', '$extract_uri_prefix', '$end_with?', '$gsub', '$private', '$=~']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'PathResolver');

      var $nesting = [self].concat($parent_nesting), $PathResolver_initialize$1, $PathResolver_absolute_path$ques$2, $a, $PathResolver_root$ques$3, $PathResolver_unc$ques$4, $PathResolver_web_root$ques$5, $PathResolver_descends_from$ques$6, $PathResolver_relative_path$7, $PathResolver_posixify$8, $PathResolver_expand_path$9, $PathResolver_partition_path$11, $PathResolver_join_path$12, $PathResolver_system_path$13, $PathResolver_web_path$16, $PathResolver_extract_uri_prefix$18;

      self.$$prototype.file_separator = self.$$prototype._partition_path_web = self.$$prototype._partition_path_sys = self.$$prototype.working_dir = nil;
      
      self.$include($$($nesting, 'Logging'));
      Opal.const_set($nesting[0], 'DOT', ".");
      Opal.const_set($nesting[0], 'DOT_DOT', "..");
      Opal.const_set($nesting[0], 'DOT_SLASH', "./");
      Opal.const_set($nesting[0], 'SLASH', "/");
      Opal.const_set($nesting[0], 'BACKSLASH', "\\");
      Opal.const_set($nesting[0], 'DOUBLE_SLASH', "//");
      Opal.const_set($nesting[0], 'WindowsRootRx', /^(?:[a-zA-Z]:)?[\\\/]/);
      self.$attr_accessor("file_separator");
      self.$attr_accessor("working_dir");
      
      Opal.def(self, '$initialize', $PathResolver_initialize$1 = function $$initialize(file_separator, working_dir) {
        var $a, $b, self = this;

        
        
        if (file_separator == null) {
          file_separator = nil;
        };
        
        if (working_dir == null) {
          working_dir = nil;
        };
        self.file_separator = ($truthy($a = ($truthy($b = file_separator) ? $b : $$$($$$('::', 'File'), 'ALT_SEPARATOR'))) ? $a : $$$($$$('::', 'File'), 'SEPARATOR'));
        self.working_dir = (function() {if ($truthy(working_dir)) {
          
          if ($truthy(self['$root?'](working_dir))) {
            
            return self.$posixify(working_dir);
          } else {
            
            return $$$('::', 'File').$expand_path(working_dir);
          };
        } else {
          return $$$('::', 'Dir').$pwd()
        }; return nil; })();
        self._partition_path_sys = $hash2([], {});
        return (self._partition_path_web = $hash2([], {}));
      }, $PathResolver_initialize$1.$$arity = -1);
      
      Opal.def(self, '$absolute_path?', $PathResolver_absolute_path$ques$2 = function(path) {
        var $a, $b, self = this;

        return ($truthy($a = path['$start_with?']($$($nesting, 'SLASH'))) ? $a : (($b = self.file_separator['$==']($$($nesting, 'BACKSLASH'))) ? $$($nesting, 'WindowsRootRx')['$match?'](path) : self.file_separator['$==']($$($nesting, 'BACKSLASH'))))
      }, $PathResolver_absolute_path$ques$2.$$arity = 1);
      if ($truthy((($a = $$($nesting, 'RUBY_ENGINE')['$==']("opal")) ? $$$('::', 'JAVASCRIPT_IO_MODULE')['$==']("xmlhttprequest") : $$($nesting, 'RUBY_ENGINE')['$==']("opal")))) {
        
        Opal.def(self, '$root?', $PathResolver_root$ques$3 = function(path) {
          var $a, self = this;

          return ($truthy($a = self['$absolute_path?'](path)) ? $a : path['$start_with?']("file://", "http://", "https://"))
        }, $PathResolver_root$ques$3.$$arity = 1)
      } else {
        Opal.alias(self, "root?", "absolute_path?")
      };
      
      Opal.def(self, '$unc?', $PathResolver_unc$ques$4 = function(path) {
        var self = this;

        return path['$start_with?']($$($nesting, 'DOUBLE_SLASH'))
      }, $PathResolver_unc$ques$4.$$arity = 1);
      
      Opal.def(self, '$web_root?', $PathResolver_web_root$ques$5 = function(path) {
        var self = this;

        return path['$start_with?']($$($nesting, 'SLASH'))
      }, $PathResolver_web_root$ques$5.$$arity = 1);
      
      Opal.def(self, '$descends_from?', $PathResolver_descends_from$ques$6 = function(path, base) {
        var $a, self = this;

        if (base['$=='](path)) {
          return 0
        } else if (base['$==']($$($nesting, 'SLASH'))) {
          return ($truthy($a = path['$start_with?']($$($nesting, 'SLASH'))) ? 1 : $a)
        } else {
          return ($truthy($a = path['$start_with?']($rb_plus(base, $$($nesting, 'SLASH')))) ? $rb_plus(base.$length(), 1) : $a)
        }
      }, $PathResolver_descends_from$ques$6.$$arity = 2);
      
      Opal.def(self, '$relative_path', $PathResolver_relative_path$7 = function $$relative_path(path, base) {
        var self = this, offset = nil;

        if ($truthy(self['$root?'](path))) {
          if ($truthy((offset = self['$descends_from?'](path, base)))) {
            return path.$slice(offset, path.$length())
          } else {
            
            try {
              return $$($nesting, 'Pathname').$new(path).$relative_path_from($$($nesting, 'Pathname').$new(base)).$to_s()
            } catch ($err) {
              if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
                try {
                  return path
                } finally { Opal.pop_exception() }
              } else { throw $err; }
            };
          }
        } else {
          return path
        }
      }, $PathResolver_relative_path$7.$$arity = 2);
      
      Opal.def(self, '$posixify', $PathResolver_posixify$8 = function $$posixify(path) {
        var $a, self = this;

        if ($truthy(path)) {
          if ($truthy((($a = self.file_separator['$==']($$($nesting, 'BACKSLASH'))) ? path['$include?']($$($nesting, 'BACKSLASH')) : self.file_separator['$==']($$($nesting, 'BACKSLASH'))))) {
            
            return path.$tr($$($nesting, 'BACKSLASH'), $$($nesting, 'SLASH'));
          } else {
            return path
          }
        } else {
          return ""
        }
      }, $PathResolver_posixify$8.$$arity = 1);
      Opal.alias(self, "posixfy", "posixify");
      
      Opal.def(self, '$expand_path', $PathResolver_expand_path$9 = function $$expand_path(path) {
        var $a, $b, $$10, self = this, path_segments = nil, path_root = nil, resolved_segments = nil;

        
        $b = self.$partition_path(path), $a = Opal.to_ary($b), (path_segments = ($a[0] == null ? nil : $a[0])), (path_root = ($a[1] == null ? nil : $a[1])), $b;
        if ($truthy(path['$include?']($$($nesting, 'DOT_DOT')))) {
          
          resolved_segments = [];
          $send(path_segments, 'each', [], ($$10 = function(segment){var self = $$10.$$s || this;

          
            
            if (segment == null) {
              segment = nil;
            };
            if (segment['$==']($$($nesting, 'DOT_DOT'))) {
              return resolved_segments.$pop()
            } else {
              return resolved_segments['$<<'](segment)
            };}, $$10.$$s = self, $$10.$$arity = 1, $$10));
          return self.$join_path(resolved_segments, path_root);
        } else {
          return self.$join_path(path_segments, path_root)
        };
      }, $PathResolver_expand_path$9.$$arity = 1);
      
      Opal.def(self, '$partition_path', $PathResolver_partition_path$11 = function $$partition_path(path, web) {
        var self = this, result = nil, cache = nil, posix_path = nil, root = nil, path_segments = nil, $writer = nil;

        
        
        if (web == null) {
          web = nil;
        };
        if ($truthy((result = (cache = (function() {if ($truthy(web)) {
          return self._partition_path_web
        } else {
          return self._partition_path_sys
        }; return nil; })())['$[]'](path)))) {
          return result};
        posix_path = self.$posixify(path);
        if ($truthy(web)) {
          if ($truthy(self['$web_root?'](posix_path))) {
            root = $$($nesting, 'SLASH')
          } else if ($truthy(posix_path['$start_with?']($$($nesting, 'DOT_SLASH')))) {
            root = $$($nesting, 'DOT_SLASH')}
        } else if ($truthy(self['$root?'](posix_path))) {
          if ($truthy(self['$unc?'](posix_path))) {
            root = $$($nesting, 'DOUBLE_SLASH')
          } else if ($truthy(posix_path['$start_with?']($$($nesting, 'SLASH')))) {
            root = $$($nesting, 'SLASH')
          } else {
            root = posix_path.$slice(0, $rb_plus(posix_path.$index($$($nesting, 'SLASH')), 1))
          }
        } else if ($truthy(posix_path['$start_with?']($$($nesting, 'DOT_SLASH')))) {
          root = $$($nesting, 'DOT_SLASH')};
        path_segments = (function() {if ($truthy(root)) {
          
          return posix_path.$slice(root.$length(), posix_path.$length());
        } else {
          return posix_path
        }; return nil; })().$split($$($nesting, 'SLASH'));
        path_segments.$delete($$($nesting, 'DOT'));
        
        $writer = [path, [path_segments, root]];
        $send(cache, '[]=', Opal.to_a($writer));
        return $writer[$rb_minus($writer["length"], 1)];;
      }, $PathResolver_partition_path$11.$$arity = -2);
      
      Opal.def(self, '$join_path', $PathResolver_join_path$12 = function $$join_path(segments, root) {
        var self = this;

        
        
        if (root == null) {
          root = nil;
        };
        if ($truthy(root)) {
          return "" + (root) + (segments.$join($$($nesting, 'SLASH')))
        } else {
          
          return segments.$join($$($nesting, 'SLASH'));
        };
      }, $PathResolver_join_path$12.$$arity = -2);
      
      Opal.def(self, '$system_path', $PathResolver_system_path$13 = function $$system_path(target, start, jail, opts) {
        var $a, $b, $$14, $$15, self = this, target_path = nil, target_segments = nil, jail_segments = nil, jail_root = nil, recheck = nil, start_segments = nil, start_root = nil, resolved_segments = nil, unresolved_segments = nil, warned = nil;

        
        
        if (start == null) {
          start = nil;
        };
        
        if (jail == null) {
          jail = nil;
        };
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        if ($truthy(jail)) {
          
          if ($truthy(self['$root?'](jail))) {
          } else {
            self.$raise($$$('::', 'SecurityError'), "" + "Jail is not an absolute path: " + (jail))
          };
          jail = self.$posixify(jail);};
        if ($truthy(target)) {
          if ($truthy(self['$root?'](target))) {
            
            target_path = self.$expand_path(target);
            if ($truthy(($truthy($a = jail) ? self['$descends_from?'](target_path, jail)['$!']() : $a))) {
              if ($truthy(opts.$fetch("recover", true))) {
                
                self.$logger().$warn("" + (($truthy($a = opts['$[]']("target_name")) ? $a : "path")) + " is outside of jail; recovering automatically");
                $b = self.$partition_path(target_path), $a = Opal.to_ary($b), (target_segments = ($a[0] == null ? nil : $a[0])), $b;
                $b = self.$partition_path(jail), $a = Opal.to_ary($b), (jail_segments = ($a[0] == null ? nil : $a[0])), (jail_root = ($a[1] == null ? nil : $a[1])), $b;
                return self.$join_path($rb_plus(jail_segments, target_segments), jail_root);
              } else {
                self.$raise($$$('::', 'SecurityError'), "" + (($truthy($a = opts['$[]']("target_name")) ? $a : "path")) + " " + (target) + " is outside of jail: " + (jail) + " (disallowed in safe mode)")
              }};
            return target_path;
          } else {
            $b = self.$partition_path(target), $a = Opal.to_ary($b), (target_segments = ($a[0] == null ? nil : $a[0])), $b
          }
        } else {
          target_segments = []
        };
        if ($truthy(target_segments['$empty?']())) {
          if ($truthy(start['$nil_or_empty?']())) {
            return ($truthy($a = jail) ? $a : self.working_dir)
          } else if ($truthy(self['$root?'](start))) {
            if ($truthy(jail)) {
              start = self.$posixify(start)
            } else {
              return self.$expand_path(start)
            }
          } else {
            
            $b = self.$partition_path(start), $a = Opal.to_ary($b), (target_segments = ($a[0] == null ? nil : $a[0])), $b;
            start = ($truthy($a = jail) ? $a : self.working_dir);
          }
        } else if ($truthy(start['$nil_or_empty?']())) {
          start = ($truthy($a = jail) ? $a : self.working_dir)
        } else if ($truthy(self['$root?'](start))) {
          if ($truthy(jail)) {
            start = self.$posixify(start)}
        } else {
          start = "" + (($truthy($a = jail) ? $a : self.working_dir).$chomp("/")) + "/" + (start)
        };
        if ($truthy(($truthy($a = ($truthy($b = jail) ? (recheck = self['$descends_from?'](start, jail)['$!']()) : $b)) ? self.file_separator['$==']($$($nesting, 'BACKSLASH')) : $a))) {
          
          $b = self.$partition_path(start), $a = Opal.to_ary($b), (start_segments = ($a[0] == null ? nil : $a[0])), (start_root = ($a[1] == null ? nil : $a[1])), $b;
          $b = self.$partition_path(jail), $a = Opal.to_ary($b), (jail_segments = ($a[0] == null ? nil : $a[0])), (jail_root = ($a[1] == null ? nil : $a[1])), $b;
          if ($truthy(start_root['$!='](jail_root))) {
            if ($truthy(opts.$fetch("recover", true))) {
              
              self.$logger().$warn("" + "start path for " + (($truthy($a = opts['$[]']("target_name")) ? $a : "path")) + " is outside of jail root; recovering automatically");
              start_segments = jail_segments;
              recheck = false;
            } else {
              self.$raise($$$('::', 'SecurityError'), "" + "start path for " + (($truthy($a = opts['$[]']("target_name")) ? $a : "path")) + " " + (start) + " refers to location outside jail root: " + (jail) + " (disallowed in safe mode)")
            }};
        } else {
          $b = self.$partition_path(start), $a = Opal.to_ary($b), (start_segments = ($a[0] == null ? nil : $a[0])), (jail_root = ($a[1] == null ? nil : $a[1])), $b
        };
        if ($truthy((resolved_segments = $rb_plus(start_segments, target_segments))['$include?']($$($nesting, 'DOT_DOT')))) {
          
          $a = [resolved_segments, []], (unresolved_segments = $a[0]), (resolved_segments = $a[1]), $a;
          if ($truthy(jail)) {
            
            if ($truthy(jail_segments)) {
            } else {
              $b = self.$partition_path(jail), $a = Opal.to_ary($b), (jail_segments = ($a[0] == null ? nil : $a[0])), $b
            };
            warned = false;
            $send(unresolved_segments, 'each', [], ($$14 = function(segment){var self = $$14.$$s || this, $c;

            
              
              if (segment == null) {
                segment = nil;
              };
              if (segment['$==']($$($nesting, 'DOT_DOT'))) {
                if ($truthy($rb_gt(resolved_segments.$size(), jail_segments.$size()))) {
                  return resolved_segments.$pop()
                } else if ($truthy(opts.$fetch("recover", true))) {
                  if ($truthy(warned)) {
                    return nil
                  } else {
                    
                    self.$logger().$warn("" + (($truthy($c = opts['$[]']("target_name")) ? $c : "path")) + " has illegal reference to ancestor of jail; recovering automatically");
                    return (warned = true);
                  }
                } else {
                  return self.$raise($$$('::', 'SecurityError'), "" + (($truthy($c = opts['$[]']("target_name")) ? $c : "path")) + " " + (target) + " refers to location outside jail: " + (jail) + " (disallowed in safe mode)")
                }
              } else {
                return resolved_segments['$<<'](segment)
              };}, $$14.$$s = self, $$14.$$arity = 1, $$14));
          } else {
            $send(unresolved_segments, 'each', [], ($$15 = function(segment){var self = $$15.$$s || this;

            
              
              if (segment == null) {
                segment = nil;
              };
              if (segment['$==']($$($nesting, 'DOT_DOT'))) {
                return resolved_segments.$pop()
              } else {
                return resolved_segments['$<<'](segment)
              };}, $$15.$$s = self, $$15.$$arity = 1, $$15))
          };};
        if ($truthy(recheck)) {
          
          target_path = self.$join_path(resolved_segments, jail_root);
          if ($truthy(self['$descends_from?'](target_path, jail))) {
            return target_path
          } else if ($truthy(opts.$fetch("recover", true))) {
            
            self.$logger().$warn("" + (($truthy($a = opts['$[]']("target_name")) ? $a : "path")) + " is outside of jail; recovering automatically");
            if ($truthy(jail_segments)) {
            } else {
              $b = self.$partition_path(jail), $a = Opal.to_ary($b), (jail_segments = ($a[0] == null ? nil : $a[0])), $b
            };
            return self.$join_path($rb_plus(jail_segments, target_segments), jail_root);
          } else {
            return self.$raise($$$('::', 'SecurityError'), "" + (($truthy($a = opts['$[]']("target_name")) ? $a : "path")) + " " + (target) + " is outside of jail: " + (jail) + " (disallowed in safe mode)")
          };
        } else {
          return self.$join_path(resolved_segments, jail_root)
        };
      }, $PathResolver_system_path$13.$$arity = -2);
      
      Opal.def(self, '$web_path', $PathResolver_web_path$16 = function $$web_path(target, start) {
        var $a, $b, $$17, self = this, uri_prefix = nil, target_segments = nil, target_root = nil, resolved_segments = nil, resolved_path = nil;

        
        
        if (start == null) {
          start = nil;
        };
        target = self.$posixify(target);
        start = self.$posixify(start);
        if ($truthy(($truthy($a = start['$nil_or_empty?']()) ? $a : self['$web_root?'](target)))) {
        } else {
          $b = self.$extract_uri_prefix("" + (start) + ((function() {if ($truthy(start['$end_with?']($$($nesting, 'SLASH')))) {
            return ""
          } else {
            return $$($nesting, 'SLASH')
          }; return nil; })()) + (target)), $a = Opal.to_ary($b), (target = ($a[0] == null ? nil : $a[0])), (uri_prefix = ($a[1] == null ? nil : $a[1])), $b
        };
        $b = self.$partition_path(target, true), $a = Opal.to_ary($b), (target_segments = ($a[0] == null ? nil : $a[0])), (target_root = ($a[1] == null ? nil : $a[1])), $b;
        resolved_segments = [];
        $send(target_segments, 'each', [], ($$17 = function(segment){var self = $$17.$$s || this, $c;

        
          
          if (segment == null) {
            segment = nil;
          };
          if (segment['$==']($$($nesting, 'DOT_DOT'))) {
            if ($truthy(resolved_segments['$empty?']())) {
              if ($truthy(($truthy($c = target_root) ? target_root['$!=']($$($nesting, 'DOT_SLASH')) : $c))) {
                return nil
              } else {
                return resolved_segments['$<<'](segment)
              }
            } else if (resolved_segments['$[]'](-1)['$==']($$($nesting, 'DOT_DOT'))) {
              return resolved_segments['$<<'](segment)
            } else {
              return resolved_segments.$pop()
            }
          } else {
            return resolved_segments['$<<'](segment)
          };}, $$17.$$s = self, $$17.$$arity = 1, $$17));
        if ($truthy((resolved_path = self.$join_path(resolved_segments, target_root))['$include?'](" "))) {
          resolved_path = resolved_path.$gsub(" ", "%20")};
        if ($truthy(uri_prefix)) {
          return "" + (uri_prefix) + (resolved_path)
        } else {
          return resolved_path
        };
      }, $PathResolver_web_path$16.$$arity = -2);
      self.$private();
      return (Opal.def(self, '$extract_uri_prefix', $PathResolver_extract_uri_prefix$18 = function $$extract_uri_prefix(str) {
        var $a, self = this;

        if ($truthy(($truthy($a = str['$include?'](":")) ? $$($nesting, 'UriSniffRx')['$=~'](str) : $a))) {
          return [str.$slice((($a = $gvars['~']) === nil ? nil : $a['$[]'](0)).$length(), str.$length()), (($a = $gvars['~']) === nil ? nil : $a['$[]'](0))]
        } else {
          return str
        }
      }, $PathResolver_extract_uri_prefix$18.$$arity = 1), nil) && 'extract_uri_prefix';
    })($nesting[0], null, $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/reader"] = function(Opal) {
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_times(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs * rhs : lhs['$*'](rhs);
  }
  function $rb_ge(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs >= rhs : lhs['$>='](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $hash2 = Opal.hash2, $truthy = Opal.truthy, $send = Opal.send, $gvars = Opal.gvars, $hash = Opal.hash;

  Opal.add_stubs(['$include', '$attr_reader', '$+', '$attr_accessor', '$!', '$===', '$split', '$file', '$dir', '$dirname', '$path', '$basename', '$lineno', '$reverse', '$prepare_lines', '$empty?', '$nil_or_empty?', '$peek_line', '$>', '$slice', '$[]', '$length', '$process_line', '$times', '$shift', '$read_line', '$<<', '$-', '$unshift_all', '$has_more_lines?', '$join', '$read_lines', '$unshift', '$start_with?', '$==', '$*', '$read_lines_until', '$size', '$clear', '$cursor', '$[]=', '$!=', '$fetch', '$cursor_at_mark', '$warn', '$logger', '$message_with_context', '$pop', '$push', '$respond_to?', '$reverse_each', '$new', '$tap', '$each', '$instance_variables', '$instance_variable_get', '$drop', '$instance_variable_set', '$class', '$object_id', '$inspect', '$private', '$prepare_source_array', '$prepare_source_string', '$chomp', '$valid_encoding?', '$to_s', '$raise', '$to_i', '$attributes', '$catalog', '$pop_include', '$parse', '$path=', '$dup', '$end_with?', '$keys', '$rindex', '$rootname', '$key?', '$attr', '$reverse!', '$>=', '$nil?', '$extensions?', '$include_processors?', '$extensions', '$include_processors', '$map', '$skip_front_matter!', '$adjust_indentation!', '$include?', '$=~', '$preprocess_conditional_directive', '$preprocess_include_directive', '$downcase', '$error', '$none?', '$any?', '$all?', '$strip', '$send', '$resolve_expr_val', '$replace_next_line', '$rstrip', '$sub_attributes', '$attribute_missing', '$info', '$parse_attributes', '$find', '$handles?', '$instance', '$process_method', '$safe', '$resolve_include_path', '$method', '$split_delimited_value', '$partition', '$<', '$to_a', '$uniq', '$sort', '$call', '$each_line', '$infinite?', '$push_include', '$delete', '$first', '$values', '$value?', '$create_include_cursor', '$delete_at', '$keep_if', '$read', '$uriish?', '$attr?', '$require_library', '$normalize_system_path', '$file?', '$relative_path', '$path_resolver', '$base_dir', '$to_f']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    
    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'Reader');

      var $nesting = [self].concat($parent_nesting), $Reader_initialize$4, $Reader_has_more_lines$ques$5, $Reader_empty$ques$6, $Reader_next_line_empty$ques$7, $Reader_peek_line$8, $Reader_peek_lines$9, $Reader_read_line$11, $Reader_read_lines$12, $Reader_read$13, $Reader_advance$14, $Reader_unshift_line$15, $Reader_unshift_lines$16, $Reader_replace_next_line$17, $Reader_skip_blank_lines$18, $Reader_skip_comment_lines$19, $Reader_skip_line_comments$20, $Reader_terminate$21, $Reader_read_lines_until$22, $Reader_shift$23, $Reader_unshift$24, $Reader_unshift_all$25, $Reader_unshift_all$27, $Reader_cursor$28, $Reader_cursor_at_line$29, $Reader_cursor_at_mark$30, $Reader_cursor_before_mark$31, $Reader_cursor_at_prev_line$32, $Reader_mark$33, $Reader_line_info$34, $Reader_lines$35, $Reader_string$36, $Reader_source$37, $Reader_save$38, $Reader_restore_save$41, $Reader_discard_save$43, $Reader_to_s$44, $Reader_prepare_lines$45, $Reader_process_line$46;

      self.$$prototype.file = self.$$prototype.lines = self.$$prototype.look_ahead = self.$$prototype.unescape_next_line = self.$$prototype.lineno = self.$$prototype.process_lines = self.$$prototype.dir = self.$$prototype.path = self.$$prototype.mark = self.$$prototype.source_lines = self.$$prototype.saved = nil;
      
      self.$include($$($nesting, 'Logging'));
      (function($base, $super, $parent_nesting) {
        var self = $klass($base, $super, 'Cursor');

        var $nesting = [self].concat($parent_nesting), $Cursor_initialize$1, $Cursor_advance$2, $Cursor_line_info$3;

        self.$$prototype.lineno = self.$$prototype.path = nil;
        
        self.$attr_reader("file", "dir", "path", "lineno");
        
        Opal.def(self, '$initialize', $Cursor_initialize$1 = function $$initialize(file, dir, path, lineno) {
          var $a, self = this;

          
          
          if (dir == null) {
            dir = nil;
          };
          
          if (path == null) {
            path = nil;
          };
          
          if (lineno == null) {
            lineno = 1;
          };
          return $a = [file, dir, path, lineno], (self.file = $a[0]), (self.dir = $a[1]), (self.path = $a[2]), (self.lineno = $a[3]), $a;
        }, $Cursor_initialize$1.$$arity = -2);
        
        Opal.def(self, '$advance', $Cursor_advance$2 = function $$advance(num) {
          var self = this;

          return (self.lineno = $rb_plus(self.lineno, num))
        }, $Cursor_advance$2.$$arity = 1);
        
        Opal.def(self, '$line_info', $Cursor_line_info$3 = function $$line_info() {
          var self = this;

          return "" + (self.path) + ": line " + (self.lineno)
        }, $Cursor_line_info$3.$$arity = 0);
        return Opal.alias(self, "to_s", "line_info");
      })($nesting[0], null, $nesting);
      self.$attr_reader("file");
      self.$attr_reader("dir");
      self.$attr_reader("path");
      self.$attr_reader("lineno");
      self.$attr_reader("source_lines");
      self.$attr_accessor("process_lines");
      self.$attr_accessor("unterminated");
      
      Opal.def(self, '$initialize', $Reader_initialize$4 = function $$initialize(data, cursor, opts) {
        var $a, $b, self = this;

        
        
        if (data == null) {
          data = nil;
        };
        
        if (cursor == null) {
          cursor = nil;
        };
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        if ($truthy(cursor['$!']())) {
          
          self.file = nil;
          self.dir = ".";
          self.path = "<stdin>";
          self.lineno = 1;
        } else if ($truthy($$$('::', 'String')['$==='](cursor))) {
          
          self.file = cursor;
          $b = $$$('::', 'File').$split(self.file), $a = Opal.to_ary($b), (self.dir = ($a[0] == null ? nil : $a[0])), (self.path = ($a[1] == null ? nil : $a[1])), $b;
          self.lineno = 1;
        } else {
          
          if ($truthy((self.file = cursor.$file()))) {
            
            self.dir = ($truthy($a = cursor.$dir()) ? $a : $$$('::', 'File').$dirname(self.file));
            self.path = ($truthy($a = cursor.$path()) ? $a : $$$('::', 'File').$basename(self.file));
          } else {
            
            self.dir = ($truthy($a = cursor.$dir()) ? $a : ".");
            self.path = ($truthy($a = cursor.$path()) ? $a : "<stdin>");
          };
          self.lineno = ($truthy($a = cursor.$lineno()) ? $a : 1);
        };
        self.lines = (self.source_lines = self.$prepare_lines(data, opts)).$reverse();
        self.mark = nil;
        self.look_ahead = 0;
        self.process_lines = true;
        self.unescape_next_line = false;
        self.unterminated = nil;
        return (self.saved = nil);
      }, $Reader_initialize$4.$$arity = -1);
      
      Opal.def(self, '$has_more_lines?', $Reader_has_more_lines$ques$5 = function() {
        var self = this;

        if ($truthy(self.lines['$empty?']())) {
          
          self.look_ahead = 0;
          return false;
        } else {
          return true
        }
      }, $Reader_has_more_lines$ques$5.$$arity = 0);
      
      Opal.def(self, '$empty?', $Reader_empty$ques$6 = function() {
        var self = this;

        if ($truthy(self.lines['$empty?']())) {
          
          self.look_ahead = 0;
          return true;
        } else {
          return false
        }
      }, $Reader_empty$ques$6.$$arity = 0);
      Opal.alias(self, "eof?", "empty?");
      
      Opal.def(self, '$next_line_empty?', $Reader_next_line_empty$ques$7 = function() {
        var self = this;

        return self.$peek_line()['$nil_or_empty?']()
      }, $Reader_next_line_empty$ques$7.$$arity = 0);
      
      Opal.def(self, '$peek_line', $Reader_peek_line$8 = function $$peek_line(direct) {
        var $a, self = this, line = nil;

        
        
        if (direct == null) {
          direct = false;
        };
        if ($truthy(($truthy($a = direct) ? $a : $rb_gt(self.look_ahead, 0)))) {
          if ($truthy(self.unescape_next_line)) {
            
            return (line = self.lines['$[]'](-1)).$slice(1, line.$length());
          } else {
            return self.lines['$[]'](-1)
          }
        } else if ($truthy(self.lines['$empty?']())) {
          
          self.look_ahead = 0;
          return nil;
        } else {
          return ($truthy($a = self.$process_line(self.lines['$[]'](-1))) ? $a : self.$peek_line())
        };
      }, $Reader_peek_line$8.$$arity = -1);
      
      Opal.def(self, '$peek_lines', $Reader_peek_lines$9 = function $$peek_lines(num, direct) {
        var $a, $$10, self = this, old_look_ahead = nil, result = nil;

        
        
        if (num == null) {
          num = nil;
        };
        
        if (direct == null) {
          direct = false;
        };
        old_look_ahead = self.look_ahead;
        result = [];
        (function(){var $brk = Opal.new_brk(); try {return $send(($truthy($a = num) ? $a : $$($nesting, 'MAX_INT')), 'times', [], ($$10 = function(){var self = $$10.$$s || this, line = nil;
          if (self.lineno == null) self.lineno = nil;

        if ($truthy((line = (function() {if ($truthy(direct)) {
            return self.$shift()
          } else {
            return self.$read_line()
          }; return nil; })()))) {
            return result['$<<'](line)
          } else {
            
            if ($truthy(direct)) {
              self.lineno = $rb_minus(self.lineno, 1)};
            
            Opal.brk(nil, $brk);
          }}, $$10.$$s = self, $$10.$$brk = $brk, $$10.$$arity = 0, $$10))
        } catch (err) { if (err === $brk) { return err.$v } else { throw err } }})();
        if ($truthy(result['$empty?']())) {
        } else {
          
          self.$unshift_all(result);
          if ($truthy(direct)) {
            self.look_ahead = old_look_ahead};
        };
        return result;
      }, $Reader_peek_lines$9.$$arity = -1);
      
      Opal.def(self, '$read_line', $Reader_read_line$11 = function $$read_line() {
        var $a, self = this;

        if ($truthy(($truthy($a = $rb_gt(self.look_ahead, 0)) ? $a : self['$has_more_lines?']()))) {
          return self.$shift()
        } else {
          return nil
        }
      }, $Reader_read_line$11.$$arity = 0);
      
      Opal.def(self, '$read_lines', $Reader_read_lines$12 = function $$read_lines() {
        var $a, self = this, lines = nil;

        
        lines = [];
        while ($truthy(self['$has_more_lines?']())) {
          lines['$<<'](self.$shift())
        };
        return lines;
      }, $Reader_read_lines$12.$$arity = 0);
      Opal.alias(self, "readlines", "read_lines");
      
      Opal.def(self, '$read', $Reader_read$13 = function $$read() {
        var self = this;

        return self.$read_lines().$join($$($nesting, 'LF'))
      }, $Reader_read$13.$$arity = 0);
      
      Opal.def(self, '$advance', $Reader_advance$14 = function $$advance() {
        var self = this;

        if ($truthy(self.$shift())) {
          return true
        } else {
          return false
        }
      }, $Reader_advance$14.$$arity = 0);
      
      Opal.def(self, '$unshift_line', $Reader_unshift_line$15 = function $$unshift_line(line_to_restore) {
        var self = this;

        
        self.$unshift(line_to_restore);
        return nil;
      }, $Reader_unshift_line$15.$$arity = 1);
      Opal.alias(self, "restore_line", "unshift_line");
      
      Opal.def(self, '$unshift_lines', $Reader_unshift_lines$16 = function $$unshift_lines(lines_to_restore) {
        var self = this;

        return self.$unshift_all(lines_to_restore)
      }, $Reader_unshift_lines$16.$$arity = 1);
      Opal.alias(self, "restore_lines", "unshift_lines");
      
      Opal.def(self, '$replace_next_line', $Reader_replace_next_line$17 = function $$replace_next_line(replacement) {
        var self = this;

        
        self.$shift();
        self.$unshift(replacement);
        return true;
      }, $Reader_replace_next_line$17.$$arity = 1);
      Opal.alias(self, "replace_line", "replace_next_line");
      
      Opal.def(self, '$skip_blank_lines', $Reader_skip_blank_lines$18 = function $$skip_blank_lines() {
        var $a, self = this, num_skipped = nil, next_line = nil;

        
        if ($truthy(self['$empty?']())) {
          return nil};
        num_skipped = 0;
        while ($truthy((next_line = self.$peek_line()))) {
          if ($truthy(next_line['$empty?']())) {
            
            self.$shift();
            num_skipped = $rb_plus(num_skipped, 1);
          } else {
            return num_skipped
          }
        };
      }, $Reader_skip_blank_lines$18.$$arity = 0);
      
      Opal.def(self, '$skip_comment_lines', $Reader_skip_comment_lines$19 = function $$skip_comment_lines() {
        var $a, $b, self = this, next_line = nil, ll = nil;

        
        if ($truthy(self['$empty?']())) {
          return nil};
        while ($truthy(($truthy($b = (next_line = self.$peek_line())) ? next_line['$empty?']()['$!']() : $b))) {
          if ($truthy(next_line['$start_with?']("//"))) {
            if ($truthy(next_line['$start_with?']("///"))) {
              if ($truthy(($truthy($b = $rb_gt((ll = next_line.$length()), 3)) ? next_line['$==']($rb_times("/", ll)) : $b))) {
                self.$read_lines_until($hash2(["terminator", "skip_first_line", "read_last_line", "skip_processing", "context"], {"terminator": next_line, "skip_first_line": true, "read_last_line": true, "skip_processing": true, "context": "comment"}))
              } else {
                break;
              }
            } else {
              self.$shift()
            }
          } else {
            break;
          }
        };
        return nil;
      }, $Reader_skip_comment_lines$19.$$arity = 0);
      
      Opal.def(self, '$skip_line_comments', $Reader_skip_line_comments$20 = function $$skip_line_comments() {
        var $a, $b, self = this, comment_lines = nil, next_line = nil;

        
        if ($truthy(self['$empty?']())) {
          return []};
        comment_lines = [];
        while ($truthy(($truthy($b = (next_line = self.$peek_line())) ? next_line['$empty?']()['$!']() : $b))) {
          if ($truthy(next_line['$start_with?']("//"))) {
            comment_lines['$<<'](self.$shift())
          } else {
            break;
          }
        };
        return comment_lines;
      }, $Reader_skip_line_comments$20.$$arity = 0);
      
      Opal.def(self, '$terminate', $Reader_terminate$21 = function $$terminate() {
        var self = this;

        
        self.lineno = $rb_plus(self.lineno, self.lines.$size());
        self.lines.$clear();
        self.look_ahead = 0;
        return nil;
      }, $Reader_terminate$21.$$arity = 0);
      
      Opal.def(self, '$read_lines_until', $Reader_read_lines_until$22 = function $$read_lines_until(options) {
        var $a, $b, $c, $d, $e, $f, $iter = $Reader_read_lines_until$22.$$p, $yield = $iter || nil, self = this, result = nil, restore_process_lines = nil, terminator = nil, start_cursor = nil, break_on_blank_lines = nil, break_on_list_continuation = nil, skip_comments = nil, line_read = nil, line_restored = nil, line = nil, $writer = nil, context = nil;

        if ($iter) $Reader_read_lines_until$22.$$p = null;
        
        
        if (options == null) {
          options = $hash2([], {});
        };
        result = [];
        if ($truthy(($truthy($a = self.process_lines) ? options['$[]']("skip_processing") : $a))) {
          
          self.process_lines = false;
          restore_process_lines = true;};
        if ($truthy((terminator = options['$[]']("terminator")))) {
          
          start_cursor = ($truthy($a = options['$[]']("cursor")) ? $a : self.$cursor());
          break_on_blank_lines = false;
          break_on_list_continuation = false;
        } else {
          
          break_on_blank_lines = options['$[]']("break_on_blank_lines");
          break_on_list_continuation = options['$[]']("break_on_list_continuation");
        };
        skip_comments = options['$[]']("skip_line_comments");
        line_read = (line_restored = nil);
        if ($truthy(options['$[]']("skip_first_line"))) {
          self.$shift()};
        while ($truthy((line = self.$read_line()))) {
          
          if ($truthy((function() {if ($truthy(terminator)) {
            return line['$=='](terminator)
          } else {
            
            return ($truthy($b = ($truthy($c = ($truthy($d = break_on_blank_lines) ? line['$empty?']() : $d)) ? $c : ($truthy($d = ($truthy($e = ($truthy($f = break_on_list_continuation) ? line_read : $f)) ? line['$==']($$($nesting, 'LIST_CONTINUATION')) : $e)) ? (($writer = ["preserve_last_line", true]), $send(options, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]) : $d))) ? $b : (($c = ($yield !== nil)) ? Opal.yield1($yield, line) : ($yield !== nil)));
          }; return nil; })())) {
            
            if ($truthy(options['$[]']("read_last_line"))) {
              result['$<<'](line)};
            if ($truthy(options['$[]']("preserve_last_line"))) {
              
              self.$unshift(line);
              line_restored = true;};
            break;;};
          if ($truthy(($truthy($b = ($truthy($c = skip_comments) ? line['$start_with?']("//") : $c)) ? line['$start_with?']("///")['$!']() : $b))) {
          } else {
            
            result['$<<'](line);
            line_read = true;
          };
        };
        if ($truthy(restore_process_lines)) {
          
          self.process_lines = true;
          if ($truthy(($truthy($a = line_restored) ? terminator['$!']() : $a))) {
            self.look_ahead = $rb_minus(self.look_ahead, 1)};};
        if ($truthy(($truthy($a = ($truthy($b = terminator) ? terminator['$!='](line) : $b)) ? (context = options.$fetch("context", terminator)) : $a))) {
          
          if (start_cursor['$==']("at_mark")) {
            start_cursor = self.$cursor_at_mark()};
          self.$logger().$warn(self.$message_with_context("" + "unterminated " + (context) + " block", $hash2(["source_location"], {"source_location": start_cursor})));
          self.unterminated = true;};
        return result;
      }, $Reader_read_lines_until$22.$$arity = -1);
      
      Opal.def(self, '$shift', $Reader_shift$23 = function $$shift() {
        var self = this;

        
        self.lineno = $rb_plus(self.lineno, 1);
        if (self.look_ahead['$=='](0)) {
        } else {
          self.look_ahead = $rb_minus(self.look_ahead, 1)
        };
        return self.lines.$pop();
      }, $Reader_shift$23.$$arity = 0);
      
      Opal.def(self, '$unshift', $Reader_unshift$24 = function $$unshift(line) {
        var self = this;

        
        self.lineno = $rb_minus(self.lineno, 1);
        self.look_ahead = $rb_plus(self.look_ahead, 1);
        self.lines.$push(line);
        return nil;
      }, $Reader_unshift$24.$$arity = 1);
      if ($$$('::', 'RUBY_ENGINE')['$==']("jruby")) {
        
        Opal.def(self, '$unshift_all', $Reader_unshift_all$25 = function $$unshift_all(lines_to_restore) {
          var $$26, self = this;

          
          self.lineno = $rb_minus(self.lineno, lines_to_restore.$size());
          self.look_ahead = $rb_plus(self.look_ahead, lines_to_restore.$size());
          if ($truthy(lines_to_restore['$respond_to?']("reverse"))) {
            $send(self.lines, 'push', Opal.to_a(lines_to_restore.$reverse()))
          } else {
            $send(lines_to_restore, 'reverse_each', [], ($$26 = function(it){var self = $$26.$$s || this;
              if (self.lines == null) self.lines = nil;

            
              
              if (it == null) {
                it = nil;
              };
              return self.lines.$push(it);}, $$26.$$s = self, $$26.$$arity = 1, $$26))
          };
          return nil;
        }, $Reader_unshift_all$25.$$arity = 1)
      } else {
        
        Opal.def(self, '$unshift_all', $Reader_unshift_all$27 = function $$unshift_all(lines_to_restore) {
          var self = this;

          
          self.lineno = $rb_minus(self.lineno, lines_to_restore.$size());
          self.look_ahead = $rb_plus(self.look_ahead, lines_to_restore.$size());
          $send(self.lines, 'push', Opal.to_a(lines_to_restore.$reverse()));
          return nil;
        }, $Reader_unshift_all$27.$$arity = 1)
      };
      
      Opal.def(self, '$cursor', $Reader_cursor$28 = function $$cursor() {
        var self = this;

        return $$($nesting, 'Cursor').$new(self.file, self.dir, self.path, self.lineno)
      }, $Reader_cursor$28.$$arity = 0);
      
      Opal.def(self, '$cursor_at_line', $Reader_cursor_at_line$29 = function $$cursor_at_line(lineno) {
        var self = this;

        return $$($nesting, 'Cursor').$new(self.file, self.dir, self.path, lineno)
      }, $Reader_cursor_at_line$29.$$arity = 1);
      
      Opal.def(self, '$cursor_at_mark', $Reader_cursor_at_mark$30 = function $$cursor_at_mark() {
        var self = this;

        if ($truthy(self.mark)) {
          return $send($$($nesting, 'Cursor'), 'new', Opal.to_a(self.mark))
        } else {
          return self.$cursor()
        }
      }, $Reader_cursor_at_mark$30.$$arity = 0);
      
      Opal.def(self, '$cursor_before_mark', $Reader_cursor_before_mark$31 = function $$cursor_before_mark() {
        var $a, $b, self = this, m_file = nil, m_dir = nil, m_path = nil, m_lineno = nil;

        if ($truthy(self.mark)) {
          
          $b = self.mark, $a = Opal.to_ary($b), (m_file = ($a[0] == null ? nil : $a[0])), (m_dir = ($a[1] == null ? nil : $a[1])), (m_path = ($a[2] == null ? nil : $a[2])), (m_lineno = ($a[3] == null ? nil : $a[3])), $b;
          return $$($nesting, 'Cursor').$new(m_file, m_dir, m_path, $rb_minus(m_lineno, 1));
        } else {
          return $$($nesting, 'Cursor').$new(self.file, self.dir, self.path, $rb_minus(self.lineno, 1))
        }
      }, $Reader_cursor_before_mark$31.$$arity = 0);
      
      Opal.def(self, '$cursor_at_prev_line', $Reader_cursor_at_prev_line$32 = function $$cursor_at_prev_line() {
        var self = this;

        return $$($nesting, 'Cursor').$new(self.file, self.dir, self.path, $rb_minus(self.lineno, 1))
      }, $Reader_cursor_at_prev_line$32.$$arity = 0);
      
      Opal.def(self, '$mark', $Reader_mark$33 = function $$mark() {
        var self = this;

        return (self.mark = [self.file, self.dir, self.path, self.lineno])
      }, $Reader_mark$33.$$arity = 0);
      
      Opal.def(self, '$line_info', $Reader_line_info$34 = function $$line_info() {
        var self = this;

        return "" + (self.path) + ": line " + (self.lineno)
      }, $Reader_line_info$34.$$arity = 0);
      
      Opal.def(self, '$lines', $Reader_lines$35 = function $$lines() {
        var self = this;

        return self.lines.$reverse()
      }, $Reader_lines$35.$$arity = 0);
      
      Opal.def(self, '$string', $Reader_string$36 = function $$string() {
        var self = this;

        return self.lines.$reverse().$join($$($nesting, 'LF'))
      }, $Reader_string$36.$$arity = 0);
      
      Opal.def(self, '$source', $Reader_source$37 = function $$source() {
        var self = this;

        return self.source_lines.$join($$($nesting, 'LF'))
      }, $Reader_source$37.$$arity = 0);
      
      Opal.def(self, '$save', $Reader_save$38 = function $$save() {
        var $$39, self = this;

        
        self.saved = $send($hash2([], {}), 'tap', [], ($$39 = function(accum){var self = $$39.$$s || this, $$40;

        
          
          if (accum == null) {
            accum = nil;
          };
          return $send(self.$instance_variables(), 'each', [], ($$40 = function(name){var self = $$40.$$s || this, $a, $writer = nil, val = nil;

          
            
            if (name == null) {
              name = nil;
            };
            if ($truthy(($truthy($a = name['$==']("@saved")) ? $a : name['$==']("@source_lines")))) {
              return nil
            } else {
              
              $writer = [name, (function() {if ($truthy($$$('::', 'Array')['$===']((val = self.$instance_variable_get(name))))) {
                
                return val.$drop(0);
              } else {
                return val
              }; return nil; })()];
              $send(accum, '[]=', Opal.to_a($writer));
              return $writer[$rb_minus($writer["length"], 1)];
            };}, $$40.$$s = self, $$40.$$arity = 1, $$40));}, $$39.$$s = self, $$39.$$arity = 1, $$39));
        return nil;
      }, $Reader_save$38.$$arity = 0);
      
      Opal.def(self, '$restore_save', $Reader_restore_save$41 = function $$restore_save() {
        var $$42, self = this;

        if ($truthy(self.saved)) {
          
          $send(self.saved, 'each', [], ($$42 = function(name, val){var self = $$42.$$s || this;

          
            
            if (name == null) {
              name = nil;
            };
            
            if (val == null) {
              val = nil;
            };
            return self.$instance_variable_set(name, val);}, $$42.$$s = self, $$42.$$arity = 2, $$42));
          return (self.saved = nil);
        } else {
          return nil
        }
      }, $Reader_restore_save$41.$$arity = 0);
      
      Opal.def(self, '$discard_save', $Reader_discard_save$43 = function $$discard_save() {
        var self = this;

        return (self.saved = nil)
      }, $Reader_discard_save$43.$$arity = 0);
      
      Opal.def(self, '$to_s', $Reader_to_s$44 = function $$to_s() {
        var self = this;

        return "" + "#<" + (self.$class()) + "@" + (self.$object_id()) + " {path: " + (self.path.$inspect()) + ", line: " + (self.lineno) + "}>"
      }, $Reader_to_s$44.$$arity = 0);
      self.$private();
      
      Opal.def(self, '$prepare_lines', $Reader_prepare_lines$45 = function $$prepare_lines(data, opts) {
        var self = this, normalize = nil;

        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        try {
          if ($truthy((normalize = opts['$[]']("normalize")))) {
            if ($truthy($$$('::', 'Array')['$==='](data))) {
              
              return $$($nesting, 'Helpers').$prepare_source_array(data, normalize['$!=']("chomp"));
            } else {
              
              return $$($nesting, 'Helpers').$prepare_source_string(data, normalize['$!=']("chomp"));
            }
          } else if ($truthy($$$('::', 'Array')['$==='](data))) {
            return data.$drop(0)
          } else if ($truthy(data)) {
            return data.$chomp().$split($$($nesting, 'LF'), -1)
          } else {
            return []
          }
        } catch ($err) {
          if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
            try {
              if ($truthy((function() {if ($truthy($$$('::', 'Array')['$==='](data))) {
                return data.$join()
              } else {
                return data.$to_s()
              }; return nil; })()['$valid_encoding?']())) {
                return self.$raise()
              } else {
                return self.$raise($$$('::', 'ArgumentError'), "source is either binary or contains invalid Unicode data")
              }
            } finally { Opal.pop_exception() }
          } else { throw $err; }
        };
      }, $Reader_prepare_lines$45.$$arity = -2);
      return (Opal.def(self, '$process_line', $Reader_process_line$46 = function $$process_line(line) {
        var self = this;

        
        if ($truthy(self.process_lines)) {
          self.look_ahead = $rb_plus(self.look_ahead, 1)};
        return line;
      }, $Reader_process_line$46.$$arity = 1), nil) && 'process_line';
    })($nesting[0], null, $nesting);
    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'PreprocessorReader');

      var $nesting = [self].concat($parent_nesting), $PreprocessorReader_initialize$47, $PreprocessorReader_has_more_lines$ques$48, $PreprocessorReader_empty$ques$49, $PreprocessorReader_peek_line$50, $PreprocessorReader_push_include$51, $PreprocessorReader_include_depth$52, $PreprocessorReader_exceeds_max_depth$ques$53, $PreprocessorReader_shift$54, $PreprocessorReader_include_processors$ques$55, $PreprocessorReader_create_include_cursor$56, $PreprocessorReader_to_s$57, $PreprocessorReader_prepare_lines$59, $PreprocessorReader_process_line$60, $PreprocessorReader_preprocess_conditional_directive$61, $PreprocessorReader_preprocess_include_directive$66, $PreprocessorReader_resolve_include_path$80, $PreprocessorReader_pop_include$82, $PreprocessorReader_split_delimited_value$83, $PreprocessorReader_skip_front_matter$excl$84, $PreprocessorReader_resolve_expr_val$85;

      self.$$prototype.include_stack = self.$$prototype.lines = self.$$prototype.file = self.$$prototype.dir = self.$$prototype.path = self.$$prototype.lineno = self.$$prototype.maxdepth = self.$$prototype.process_lines = self.$$prototype.includes = self.$$prototype.document = self.$$prototype.unescape_next_line = self.$$prototype.include_processor_extensions = self.$$prototype.look_ahead = self.$$prototype.skipping = self.$$prototype.conditional_stack = nil;
      
      self.$attr_reader("include_stack");
      
      Opal.def(self, '$initialize', $PreprocessorReader_initialize$47 = function $$initialize(document, data, cursor, opts) {
        var $a, $iter = $PreprocessorReader_initialize$47.$$p, $yield = $iter || nil, self = this, default_include_depth = nil;

        if ($iter) $PreprocessorReader_initialize$47.$$p = null;
        
        
        if (data == null) {
          data = nil;
        };
        
        if (cursor == null) {
          cursor = nil;
        };
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        self.document = document;
        $send(self, Opal.find_super_dispatcher(self, 'initialize', $PreprocessorReader_initialize$47, false), [data, cursor, opts], null);
        if ($truthy($rb_gt((default_include_depth = ($truthy($a = document.$attributes()['$[]']("max-include-depth")) ? $a : 64).$to_i()), 0))) {
          self.maxdepth = $hash2(["abs", "curr", "rel"], {"abs": default_include_depth, "curr": default_include_depth, "rel": default_include_depth})
        } else {
          self.maxdepth = nil
        };
        self.include_stack = [];
        self.includes = document.$catalog()['$[]']("includes");
        self.skipping = false;
        self.conditional_stack = [];
        return (self.include_processor_extensions = nil);
      }, $PreprocessorReader_initialize$47.$$arity = -2);
      
      Opal.def(self, '$has_more_lines?', $PreprocessorReader_has_more_lines$ques$48 = function() {
        var self = this;

        if ($truthy(self.$peek_line())) {
          return true
        } else {
          return false
        }
      }, $PreprocessorReader_has_more_lines$ques$48.$$arity = 0);
      
      Opal.def(self, '$empty?', $PreprocessorReader_empty$ques$49 = function() {
        var self = this;

        if ($truthy(self.$peek_line())) {
          return false
        } else {
          return true
        }
      }, $PreprocessorReader_empty$ques$49.$$arity = 0);
      Opal.alias(self, "eof?", "empty?");
      
      Opal.def(self, '$peek_line', $PreprocessorReader_peek_line$50 = function $$peek_line(direct) {
        var $iter = $PreprocessorReader_peek_line$50.$$p, $yield = $iter || nil, self = this, line = nil, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) $PreprocessorReader_peek_line$50.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        
        
        if (direct == null) {
          direct = false;
        };
        if ($truthy((line = $send(self, Opal.find_super_dispatcher(self, 'peek_line', $PreprocessorReader_peek_line$50, false), $zuper, $iter)))) {
          return line
        } else if ($truthy(self.include_stack['$empty?']())) {
          return nil
        } else {
          
          self.$pop_include();
          return self.$peek_line(direct);
        };
      }, $PreprocessorReader_peek_line$50.$$arity = -1);
      
      Opal.def(self, '$push_include', $PreprocessorReader_push_include$51 = function $$push_include(data, file, path, lineno, attributes) {
        var $a, self = this, $writer = nil, dir = nil, rel_maxdepth = nil, curr_maxdepth = nil, abs_maxdepth = nil, leveloffset = nil;

        
        
        if (file == null) {
          file = nil;
        };
        
        if (path == null) {
          path = nil;
        };
        
        if (lineno == null) {
          lineno = 1;
        };
        
        if (attributes == null) {
          attributes = $hash2([], {});
        };
        self.include_stack['$<<']([self.lines, self.file, self.dir, self.path, self.lineno, self.maxdepth, self.process_lines]);
        if ($truthy((self.file = file))) {
          
          if ($truthy($$$('::', 'String')['$==='](file))) {
            self.dir = $$$('::', 'File').$dirname(file)
          } else if ($truthy($$($nesting, 'RUBY_ENGINE_OPAL'))) {
            self.dir = $$$('::', 'URI').$parse($$$('::', 'File').$dirname((file = file.$to_s())))
          } else {
            
            
            $writer = [(function() {if ((dir = $$$('::', 'File').$dirname(file.$path()))['$==']("/")) {
              return ""
            } else {
              return dir
            }; return nil; })()];
            $send((self.dir = file.$dup()), 'path=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            file = file.$to_s();
          };
          self.path = (path = ($truthy($a = path) ? $a : $$$('::', 'File').$basename(file)));
          if ($truthy((self.process_lines = $send(file, 'end_with?', Opal.to_a($$($nesting, 'ASCIIDOC_EXTENSIONS').$keys()))))) {
            
            $writer = [path.$slice(0, path.$rindex(".")), (function() {if ($truthy(attributes['$[]']("partial-option"))) {
              return nil
            } else {
              return true
            }; return nil; })()];
            $send(self.includes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
        } else {
          
          self.dir = ".";
          self.process_lines = true;
          if ($truthy((self.path = path))) {
            
            $writer = [$$($nesting, 'Helpers').$rootname(path), (function() {if ($truthy(attributes['$[]']("partial-option"))) {
              return nil
            } else {
              return true
            }; return nil; })()];
            $send(self.includes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          } else {
            self.path = "<stdin>"
          };
        };
        self.lineno = lineno;
        if ($truthy(($truthy($a = self.maxdepth) ? attributes['$key?']("depth") : $a))) {
          if ($truthy($rb_gt((rel_maxdepth = attributes['$[]']("depth").$to_i()), 0))) {
            
            if ($truthy($rb_gt((curr_maxdepth = $rb_plus(self.include_stack.$size(), rel_maxdepth)), (abs_maxdepth = self.maxdepth['$[]']("abs"))))) {
              curr_maxdepth = (rel_maxdepth = abs_maxdepth)};
            self.maxdepth = $hash2(["abs", "curr", "rel"], {"abs": abs_maxdepth, "curr": curr_maxdepth, "rel": rel_maxdepth});
          } else {
            self.maxdepth = $hash2(["abs", "curr", "rel"], {"abs": self.maxdepth['$[]']("abs"), "curr": self.include_stack.$size(), "rel": 0})
          }};
        if ($truthy((self.lines = self.$prepare_lines(data, $hash2(["normalize", "condense", "indent"], {"normalize": ($truthy($a = self.process_lines) ? $a : "chomp"), "condense": false, "indent": attributes['$[]']("indent")})))['$empty?']())) {
          self.$pop_include()
        } else {
          
          if ($truthy(attributes['$key?']("leveloffset"))) {
            
            self.lines = $rb_plus($rb_plus([(function() {if ($truthy((leveloffset = self.document.$attr("leveloffset")))) {
              return "" + ":leveloffset: " + (leveloffset)
            } else {
              return ":leveloffset!:"
            }; return nil; })(), ""], self.lines.$reverse()), ["", "" + ":leveloffset: " + (attributes['$[]']("leveloffset"))]);
            self.lineno = $rb_minus(self.lineno, 2);
          } else {
            self.lines['$reverse!']()
          };
          self.look_ahead = 0;
        };
        return self;
      }, $PreprocessorReader_push_include$51.$$arity = -2);
      
      Opal.def(self, '$include_depth', $PreprocessorReader_include_depth$52 = function $$include_depth() {
        var self = this;

        return self.include_stack.$size()
      }, $PreprocessorReader_include_depth$52.$$arity = 0);
      
      Opal.def(self, '$exceeds_max_depth?', $PreprocessorReader_exceeds_max_depth$ques$53 = function() {
        var $a, $b, self = this;

        return ($truthy($a = ($truthy($b = self.maxdepth) ? $rb_ge(self.include_stack.$size(), self.maxdepth['$[]']("curr")) : $b)) ? self.maxdepth['$[]']("rel") : $a)
      }, $PreprocessorReader_exceeds_max_depth$ques$53.$$arity = 0);
      Opal.alias(self, "exceeded_max_depth?", "exceeds_max_depth?");
      
      Opal.def(self, '$shift', $PreprocessorReader_shift$54 = function $$shift() {
        var $iter = $PreprocessorReader_shift$54.$$p, $yield = $iter || nil, self = this, line = nil, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) $PreprocessorReader_shift$54.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        if ($truthy(self.unescape_next_line)) {
          
          self.unescape_next_line = false;
          return (line = $send(self, Opal.find_super_dispatcher(self, 'shift', $PreprocessorReader_shift$54, false), $zuper, $iter)).$slice(1, line.$length());
        } else {
          return $send(self, Opal.find_super_dispatcher(self, 'shift', $PreprocessorReader_shift$54, false), $zuper, $iter)
        }
      }, $PreprocessorReader_shift$54.$$arity = 0);
      
      Opal.def(self, '$include_processors?', $PreprocessorReader_include_processors$ques$55 = function() {
        var $a, self = this;

        if ($truthy(self.include_processor_extensions['$nil?']())) {
          if ($truthy(($truthy($a = self.document['$extensions?']()) ? self.document.$extensions()['$include_processors?']() : $a))) {
            return (self.include_processor_extensions = self.document.$extensions().$include_processors())['$!']()['$!']()
          } else {
            return (self.include_processor_extensions = false)
          }
        } else {
          return self.include_processor_extensions['$!='](false)
        }
      }, $PreprocessorReader_include_processors$ques$55.$$arity = 0);
      
      Opal.def(self, '$create_include_cursor', $PreprocessorReader_create_include_cursor$56 = function $$create_include_cursor(file, path, lineno) {
        var self = this, dir = nil;

        
        if ($truthy($$$('::', 'String')['$==='](file))) {
          dir = $$$('::', 'File').$dirname(file)
        } else if ($truthy($$($nesting, 'RUBY_ENGINE_OPAL'))) {
          dir = $$$('::', 'File').$dirname((file = file.$to_s()))
        } else {
          
          dir = (function() {if ((dir = $$$('::', 'File').$dirname(file.$path()))['$==']("")) {
            return "/"
          } else {
            return dir
          }; return nil; })();
          file = file.$to_s();
        };
        return $$($nesting, 'Cursor').$new(file, dir, path, lineno);
      }, $PreprocessorReader_create_include_cursor$56.$$arity = 3);
      
      Opal.def(self, '$to_s', $PreprocessorReader_to_s$57 = function $$to_s() {
        var $$58, self = this;

        return "" + "#<" + (self.$class()) + "@" + (self.$object_id()) + " {path: " + (self.path.$inspect()) + ", line: " + (self.lineno) + ", include depth: " + (self.include_stack.$size()) + ", include stack: [" + ($send(self.include_stack, 'map', [], ($$58 = function(inc){var self = $$58.$$s || this;

        
          
          if (inc == null) {
            inc = nil;
          };
          return inc.$to_s();}, $$58.$$s = self, $$58.$$arity = 1, $$58)).$join(", ")) + "]}>"
      }, $PreprocessorReader_to_s$57.$$arity = 0);
      self.$private();
      
      Opal.def(self, '$prepare_lines', $PreprocessorReader_prepare_lines$59 = function $$prepare_lines(data, opts) {
        var $a, $b, $iter = $PreprocessorReader_prepare_lines$59.$$p, $yield = $iter || nil, self = this, result = nil, front_matter = nil, $writer = nil, last = nil, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) $PreprocessorReader_prepare_lines$59.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        result = $send(self, Opal.find_super_dispatcher(self, 'prepare_lines', $PreprocessorReader_prepare_lines$59, false), $zuper, $iter);
        if ($truthy(($truthy($a = ($truthy($b = self.document) ? self.document.$attributes()['$[]']("skip-front-matter") : $b)) ? (front_matter = self['$skip_front_matter!'](result)) : $a))) {
          
          $writer = ["front-matter", front_matter.$join($$($nesting, 'LF'))];
          $send(self.document.$attributes(), '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        if ($truthy(opts.$fetch("condense", true))) {
          while ($truthy(($truthy($b = (last = result['$[]'](-1))) ? last['$empty?']() : $b))) {
            result.$pop()
          }};
        if ($truthy(opts['$[]']("indent"))) {
          $$($nesting, 'Parser')['$adjust_indentation!'](result, opts['$[]']("indent").$to_i(), self.document.$attr("tabsize").$to_i())};
        return result;
      }, $PreprocessorReader_prepare_lines$59.$$arity = -2);
      
      Opal.def(self, '$process_line', $PreprocessorReader_process_line$60 = function $$process_line(line) {
        var $a, $b, self = this;

        
        if ($truthy(self.process_lines)) {
        } else {
          return line
        };
        if ($truthy(line['$empty?']())) {
          
          self.look_ahead = $rb_plus(self.look_ahead, 1);
          return line;};
        if ($truthy(($truthy($a = ($truthy($b = line['$end_with?']("]")) ? line['$start_with?']("[")['$!']() : $b)) ? line['$include?']("::") : $a))) {
          if ($truthy(($truthy($a = line['$include?']("if")) ? $$($nesting, 'ConditionalDirectiveRx')['$=~'](line) : $a))) {
            if ((($a = $gvars['~']) === nil ? nil : $a['$[]'](1))['$==']("\\")) {
              
              self.unescape_next_line = true;
              self.look_ahead = $rb_plus(self.look_ahead, 1);
              return line.$slice(1, line.$length());
            } else if ($truthy(self.$preprocess_conditional_directive((($a = $gvars['~']) === nil ? nil : $a['$[]'](2)), (($a = $gvars['~']) === nil ? nil : $a['$[]'](3)), (($a = $gvars['~']) === nil ? nil : $a['$[]'](4)), (($a = $gvars['~']) === nil ? nil : $a['$[]'](5))))) {
              
              self.$shift();
              return nil;
            } else {
              
              self.look_ahead = $rb_plus(self.look_ahead, 1);
              return line;
            }
          } else if ($truthy(self.skipping)) {
            
            self.$shift();
            return nil;
          } else if ($truthy(($truthy($a = line['$start_with?']("inc", "\\inc")) ? $$($nesting, 'IncludeDirectiveRx')['$=~'](line) : $a))) {
            if ((($a = $gvars['~']) === nil ? nil : $a['$[]'](1))['$==']("\\")) {
              
              self.unescape_next_line = true;
              self.look_ahead = $rb_plus(self.look_ahead, 1);
              return line.$slice(1, line.$length());
            } else if ($truthy(self.$preprocess_include_directive((($a = $gvars['~']) === nil ? nil : $a['$[]'](2)), (($a = $gvars['~']) === nil ? nil : $a['$[]'](3))))) {
              return nil
            } else {
              
              self.look_ahead = $rb_plus(self.look_ahead, 1);
              return line;
            }
          } else {
            
            self.look_ahead = $rb_plus(self.look_ahead, 1);
            return line;
          }
        } else if ($truthy(self.skipping)) {
          
          self.$shift();
          return nil;
        } else {
          
          self.look_ahead = $rb_plus(self.look_ahead, 1);
          return line;
        };
      }, $PreprocessorReader_process_line$60.$$arity = 1);
      
      Opal.def(self, '$preprocess_conditional_directive', $PreprocessorReader_preprocess_conditional_directive$61 = function $$preprocess_conditional_directive(keyword, target, delimiter, text) {
        var $a, $$62, $$63, $$64, $$65, self = this, no_target = nil, pair = nil, skip = nil, $case = nil, lhs = nil, op = nil, rhs = nil;

        
        if ($truthy((no_target = target['$empty?']()))) {
        } else {
          target = target.$downcase()
        };
        if (keyword['$==']("endif")) {
          
          if ($truthy(text)) {
            self.$logger().$error(self.$message_with_context("" + "malformed preprocessor directive - text not permitted: endif::" + (target) + "[" + (text) + "]", $hash2(["source_location"], {"source_location": self.$cursor()})))
          } else if ($truthy(self.conditional_stack['$empty?']())) {
            self.$logger().$error(self.$message_with_context("" + "unmatched preprocessor directive: endif::" + (target) + "[]", $hash2(["source_location"], {"source_location": self.$cursor()})))
          } else if ($truthy(($truthy($a = no_target) ? $a : target['$==']((pair = self.conditional_stack['$[]'](-1))['$[]']("target"))))) {
            
            self.conditional_stack.$pop();
            self.skipping = (function() {if ($truthy(self.conditional_stack['$empty?']())) {
              return false
            } else {
              return self.conditional_stack['$[]'](-1)['$[]']("skipping")
            }; return nil; })();
          } else {
            self.$logger().$error(self.$message_with_context("" + "mismatched preprocessor directive: endif::" + (target) + "[], expected endif::" + (pair['$[]']("target")) + "[]", $hash2(["source_location"], {"source_location": self.$cursor()})))
          };
          return true;
        } else if ($truthy(self.skipping)) {
          skip = false
        } else {
          $case = keyword;
          if ("ifdef"['$===']($case)) {
          if ($truthy(no_target)) {
            
            self.$logger().$error(self.$message_with_context("" + "malformed preprocessor directive - missing target: ifdef::[" + (text) + "]", $hash2(["source_location"], {"source_location": self.$cursor()})));
            return true;};
          $case = delimiter;
          if (","['$===']($case)) {skip = $send(target.$split(",", -1), 'none?', [], ($$62 = function(name){var self = $$62.$$s || this;
            if (self.document == null) self.document = nil;

          
            
            if (name == null) {
              name = nil;
            };
            return self.document.$attributes()['$key?'](name);}, $$62.$$s = self, $$62.$$arity = 1, $$62))}
          else if ("+"['$===']($case)) {skip = $send(target.$split("+", -1), 'any?', [], ($$63 = function(name){var self = $$63.$$s || this;
            if (self.document == null) self.document = nil;

          
            
            if (name == null) {
              name = nil;
            };
            return self.document.$attributes()['$key?'](name)['$!']();}, $$63.$$s = self, $$63.$$arity = 1, $$63))}
          else {skip = self.document.$attributes()['$key?'](target)['$!']()};}
          else if ("ifndef"['$===']($case)) {
          if ($truthy(no_target)) {
            
            self.$logger().$error(self.$message_with_context("" + "malformed preprocessor directive - missing target: ifndef::[" + (text) + "]", $hash2(["source_location"], {"source_location": self.$cursor()})));
            return true;};
          $case = delimiter;
          if (","['$===']($case)) {skip = $send(target.$split(",", -1), 'any?', [], ($$64 = function(name){var self = $$64.$$s || this;
            if (self.document == null) self.document = nil;

          
            
            if (name == null) {
              name = nil;
            };
            return self.document.$attributes()['$key?'](name);}, $$64.$$s = self, $$64.$$arity = 1, $$64))}
          else if ("+"['$===']($case)) {skip = $send(target.$split("+", -1), 'all?', [], ($$65 = function(name){var self = $$65.$$s || this;
            if (self.document == null) self.document = nil;

          
            
            if (name == null) {
              name = nil;
            };
            return self.document.$attributes()['$key?'](name);}, $$65.$$s = self, $$65.$$arity = 1, $$65))}
          else {skip = self.document.$attributes()['$key?'](target)};}
          else if ("ifeval"['$===']($case)) {if ($truthy(no_target)) {
            if ($truthy(($truthy($a = text) ? $$($nesting, 'EvalExpressionRx')['$=~'](text.$strip()) : $a))) {
              
              lhs = (($a = $gvars['~']) === nil ? nil : $a['$[]'](1));
              op = (($a = $gvars['~']) === nil ? nil : $a['$[]'](2));
              rhs = (($a = $gvars['~']) === nil ? nil : $a['$[]'](3));
              skip = (function() { try {
                if ($truthy(self.$resolve_expr_val(lhs).$send(op, self.$resolve_expr_val(rhs)))) {
                  return false
                } else {
                  return true
                }
              } catch ($err) {
                if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
                  try {
                    return true
                  } finally { Opal.pop_exception() }
                } else { throw $err; }
              }})();
            } else {
              
              self.$logger().$error(self.$message_with_context("" + "malformed preprocessor directive - " + ((function() {if ($truthy(text)) {
                return "invalid expression"
              } else {
                return "missing expression"
              }; return nil; })()) + ": ifeval::[" + (text) + "]", $hash2(["source_location"], {"source_location": self.$cursor()})));
              return true;
            }
          } else {
            
            self.$logger().$error(self.$message_with_context("" + "malformed preprocessor directive - target not permitted: ifeval::" + (target) + "[" + (text) + "]", $hash2(["source_location"], {"source_location": self.$cursor()})));
            return true;
          }}
        };
        if ($truthy(($truthy($a = keyword['$==']("ifeval")) ? $a : text['$!']()))) {
          
          if ($truthy(skip)) {
            self.skipping = true};
          self.conditional_stack['$<<']($hash2(["target", "skip", "skipping"], {"target": target, "skip": skip, "skipping": self.skipping}));
        } else if ($truthy(($truthy($a = self.skipping) ? $a : skip))) {
        } else {
          
          self.$replace_next_line(text.$rstrip());
          self.$unshift("");
          if ($truthy(text['$start_with?']("include::"))) {
            self.look_ahead = $rb_minus(self.look_ahead, 1)};
        };
        return true;
      }, $PreprocessorReader_preprocess_conditional_directive$61.$$arity = 4);
      
      Opal.def(self, '$preprocess_include_directive', $PreprocessorReader_preprocess_include_directive$66 = function $$preprocess_include_directive(target, attrlist) {
        var $a, $b, $$67, $$68, $$69, $$70, $$71, $$72, $$74, $$77, $$78, $$79, self = this, doc = nil, expanded_target = nil, attr_missing = nil, ext = nil, parsed_attrs = nil, inc_path = nil, target_type = nil, relpath = nil, $case = nil, reader = nil, read_mode = nil, enc = nil, $writer = nil, read_mode_params = nil, inc_linenos = nil, inc_tags = nil, tag = nil, inc_lines = nil, inc_offset = nil, inc_lineno = nil, tag_stack = nil, tags_selected = nil, active_tag = nil, select = nil, base_select = nil, wildcard = nil, missing_tags = nil, inc_content = nil;

        
        doc = self.document;
        if ($truthy(($truthy($a = (expanded_target = target)['$include?']($$($nesting, 'ATTR_REF_HEAD'))) ? (expanded_target = doc.$sub_attributes(target, $hash2(["attribute_missing"], {"attribute_missing": (function() {if ((attr_missing = ($truthy($b = doc.$attributes()['$[]']("attribute-missing")) ? $b : $$($nesting, 'Compliance').$attribute_missing()))['$==']("warn")) {
          return "drop-line"
        } else {
          return attr_missing
        }; return nil; })()})))['$empty?']() : $a))) {
          if ($truthy((($a = attr_missing['$==']("drop-line")) ? doc.$sub_attributes($rb_plus(target, " "), $hash2(["attribute_missing", "drop_line_severity"], {"attribute_missing": "drop-line", "drop_line_severity": "ignore"}))['$empty?']() : attr_missing['$==']("drop-line")))) {
            
            $send(self.$logger(), 'info', [], ($$67 = function(){var self = $$67.$$s || this;

            return self.$message_with_context("" + "include dropped due to missing attribute: include::" + (target) + "[" + (attrlist) + "]", $hash2(["source_location"], {"source_location": self.$cursor()}))}, $$67.$$s = self, $$67.$$arity = 0, $$67));
            self.$shift();
            return true;
          } else if ($truthy(doc.$parse_attributes(attrlist, [], $hash2(["sub_input"], {"sub_input": true}))['$[]']("optional-option"))) {
            
            $send(self.$logger(), 'info', [], ($$68 = function(){var self = $$68.$$s || this, $c;

            return self.$message_with_context("" + "optional include dropped " + ((function() {if ($truthy((($c = attr_missing['$==']("warn")) ? doc.$sub_attributes($rb_plus(target, " "), $hash2(["attribute_missing", "drop_line_severity"], {"attribute_missing": "drop-line", "drop_line_severity": "ignore"}))['$empty?']() : attr_missing['$==']("warn")))) {
                return "due to missing attribute"
              } else {
                return "because resolved target is blank"
              }; return nil; })()) + ": include::" + (target) + "[" + (attrlist) + "]", $hash2(["source_location"], {"source_location": self.$cursor()}))}, $$68.$$s = self, $$68.$$arity = 0, $$68));
            self.$shift();
            return true;
          } else {
            
            self.$logger().$warn(self.$message_with_context("" + "include dropped " + ((function() {if ($truthy((($a = attr_missing['$==']("warn")) ? doc.$sub_attributes($rb_plus(target, " "), $hash2(["attribute_missing", "drop_line_severity"], {"attribute_missing": "drop-line", "drop_line_severity": "ignore"}))['$empty?']() : attr_missing['$==']("warn")))) {
              return "due to missing attribute"
            } else {
              return "because resolved target is blank"
            }; return nil; })()) + ": include::" + (target) + "[" + (attrlist) + "]", $hash2(["source_location"], {"source_location": self.$cursor()})));
            return self.$replace_next_line("" + "Unresolved directive in " + (self.path) + " - include::" + (target) + "[" + (attrlist) + "]");
          }
        } else if ($truthy(($truthy($a = self['$include_processors?']()) ? (ext = $send(self.include_processor_extensions, 'find', [], ($$69 = function(candidate){var self = $$69.$$s || this;

        
          
          if (candidate == null) {
            candidate = nil;
          };
          return candidate.$instance()['$handles?'](expanded_target);}, $$69.$$s = self, $$69.$$arity = 1, $$69))) : $a))) {
          
          self.$shift();
          ext.$process_method()['$[]'](doc, self, expanded_target, doc.$parse_attributes(attrlist, [], $hash2(["sub_input"], {"sub_input": true})));
          return true;
        } else if ($truthy($rb_ge(doc.$safe(), $$$($$($nesting, 'SafeMode'), 'SECURE')))) {
          return self.$replace_next_line("" + "link:" + (expanded_target) + "[]")
        } else if ($truthy(self.maxdepth)) {
          
          if ($truthy($rb_ge(self.include_stack.$size(), self.maxdepth['$[]']("curr")))) {
            
            self.$logger().$error(self.$message_with_context("" + "maximum include depth of " + (self.maxdepth['$[]']("rel")) + " exceeded", $hash2(["source_location"], {"source_location": self.$cursor()})));
            return nil;};
          parsed_attrs = doc.$parse_attributes(attrlist, [], $hash2(["sub_input"], {"sub_input": true}));
          $b = self.$resolve_include_path(expanded_target, attrlist, parsed_attrs), $a = Opal.to_ary($b), (inc_path = ($a[0] == null ? nil : $a[0])), (target_type = ($a[1] == null ? nil : $a[1])), (relpath = ($a[2] == null ? nil : $a[2])), $b;
          $case = target_type;
          if ("file"['$===']($case)) {
          reader = $$$('::', 'File').$method("open");
          read_mode = $$($nesting, 'FILE_READ_MODE');}
          else if ("uri"['$===']($case)) {
          reader = $$$('::', 'OpenURI').$method("open_uri");
          read_mode = $$($nesting, 'URI_READ_MODE');}
          else {return inc_path};
          if ($truthy($$($nesting, 'RUBY_ENGINE_OPAL'))) {
          } else if ($truthy(($truthy($a = (enc = parsed_attrs['$[]']("encoding"))) ? (function() { try {
            return $$$('::', 'Encoding').$find(enc)
          } catch ($err) {
            if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
              try {
                return nil
              } finally { Opal.pop_exception() }
            } else { throw $err; }
          }})() : $a))) {
            
            
            $writer = [1, enc];
            $send((read_mode_params = read_mode.$split(":")), '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            read_mode = read_mode_params.$join(":");};
          inc_linenos = (inc_tags = nil);
          if ($truthy(attrlist)) {
            if ($truthy(parsed_attrs['$key?']("lines"))) {
              
              inc_linenos = [];
              $send(self.$split_delimited_value(parsed_attrs['$[]']("lines")), 'each', [], ($$70 = function(linedef){var self = $$70.$$s || this, $c, $d, from = nil, _ = nil, to = nil;

              
                
                if (linedef == null) {
                  linedef = nil;
                };
                if ($truthy(linedef['$include?'](".."))) {
                  
                  $d = linedef.$partition(".."), $c = Opal.to_ary($d), (from = ($c[0] == null ? nil : $c[0])), (_ = ($c[1] == null ? nil : $c[1])), (to = ($c[2] == null ? nil : $c[2])), $d;
                  return (inc_linenos = $rb_plus(inc_linenos, (function() {if ($truthy(($truthy($c = to['$empty?']()) ? $c : $rb_lt((to = to.$to_i()), 0)))) {
                    return [from.$to_i(), $$$($$$('::', 'Float'), 'INFINITY')]
                  } else {
                    return Opal.Range.$new(from.$to_i(), to, false).$to_a()
                  }; return nil; })()));
                } else {
                  return inc_linenos['$<<'](linedef.$to_i())
                };}, $$70.$$s = self, $$70.$$arity = 1, $$70));
              inc_linenos = (function() {if ($truthy(inc_linenos['$empty?']())) {
                return nil
              } else {
                return inc_linenos.$sort().$uniq()
              }; return nil; })();
            } else if ($truthy(parsed_attrs['$key?']("tag"))) {
              if ($truthy(($truthy($a = (tag = parsed_attrs['$[]']("tag"))['$empty?']()) ? $a : tag['$==']("!")))) {
              } else {
                inc_tags = (function() {if ($truthy(tag['$start_with?']("!"))) {
                  return $hash(tag.$slice(1, tag.$length()), false)
                } else {
                  return $hash(tag, true)
                }; return nil; })()
              }
            } else if ($truthy(parsed_attrs['$key?']("tags"))) {
              
              inc_tags = $hash2([], {});
              $send(self.$split_delimited_value(parsed_attrs['$[]']("tags")), 'each', [], ($$71 = function(tagdef){var self = $$71.$$s || this, $c;

              
                
                if (tagdef == null) {
                  tagdef = nil;
                };
                if ($truthy(($truthy($c = tagdef['$empty?']()) ? $c : tagdef['$==']("!")))) {
                  return nil
                } else if ($truthy(tagdef['$start_with?']("!"))) {
                  
                  $writer = [tagdef.$slice(1, tagdef.$length()), false];
                  $send(inc_tags, '[]=', Opal.to_a($writer));
                  return $writer[$rb_minus($writer["length"], 1)];
                } else {
                  
                  $writer = [tagdef, true];
                  $send(inc_tags, '[]=', Opal.to_a($writer));
                  return $writer[$rb_minus($writer["length"], 1)];
                };}, $$71.$$s = self, $$71.$$arity = 1, $$71));
              if ($truthy(inc_tags['$empty?']())) {
                inc_tags = nil};}};
          if ($truthy(inc_linenos)) {
            
            $a = [[], nil, 0], (inc_lines = $a[0]), (inc_offset = $a[1]), (inc_lineno = $a[2]), $a;
            
            try {
              (function(){var $brk = Opal.new_brk(); try {return $send(reader, 'call', [inc_path, read_mode], ($$72 = function(f){var self = $$72.$$s || this, $$73, select_remaining = nil;

              
                
                if (f == null) {
                  f = nil;
                };
                select_remaining = nil;
                return (function(){var $brk = Opal.new_brk(); try {return $send(f, 'each_line', [], ($$73 = function(l){var self = $$73.$$s || this, $c, $d, select = nil;

                
                  
                  if (l == null) {
                    l = nil;
                  };
                  inc_lineno = $rb_plus(inc_lineno, 1);
                  if ($truthy(($truthy($c = select_remaining) ? $c : ($truthy($d = $$$('::', 'Float')['$===']((select = inc_linenos['$[]'](0)))) ? (select_remaining = select['$infinite?']()) : $d)))) {
                    
                    inc_offset = ($truthy($c = inc_offset) ? $c : inc_lineno);
                    return inc_lines['$<<'](l);
                  } else {
                    
                    if (select['$=='](inc_lineno)) {
                      
                      inc_offset = ($truthy($c = inc_offset) ? $c : inc_lineno);
                      inc_lines['$<<'](l);
                      inc_linenos.$shift();};
                    if ($truthy(inc_linenos['$empty?']())) {
                      
                      Opal.brk(nil, $brk)
                    } else {
                      return nil
                    };
                  };}, $$73.$$s = self, $$73.$$brk = $brk, $$73.$$arity = 1, $$73))
                } catch (err) { if (err === $brk) { return err.$v } else { throw err } }})();}, $$72.$$s = self, $$72.$$brk = $brk, $$72.$$arity = 1, $$72))
              } catch (err) { if (err === $brk) { return err.$v } else { throw err } }})()
            } catch ($err) {
              if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
                try {
                  
                  self.$logger().$error(self.$message_with_context("" + "include " + (target_type) + " not readable: " + (inc_path), $hash2(["source_location"], {"source_location": self.$cursor()})));
                  return self.$replace_next_line("" + "Unresolved directive in " + (self.path) + " - include::" + (expanded_target) + "[" + (attrlist) + "]");
                } finally { Opal.pop_exception() }
              } else { throw $err; }
            };;
            self.$shift();
            if ($truthy(inc_offset)) {
              
              
              $writer = ["partial-option", ""];
              $send(parsed_attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              self.$push_include(inc_lines, inc_path, relpath, inc_offset, parsed_attrs);};
          } else if ($truthy(inc_tags)) {
            
            $a = [[], nil, 0, [], $$$('::', 'Set').$new(), nil], (inc_lines = $a[0]), (inc_offset = $a[1]), (inc_lineno = $a[2]), (tag_stack = $a[3]), (tags_selected = $a[4]), (active_tag = $a[5]), $a;
            if ($truthy(inc_tags['$key?']("**"))) {
              
              select = (base_select = inc_tags.$delete("**"));
              if ($truthy(inc_tags['$key?']("*"))) {
                wildcard = inc_tags.$delete("*")
              } else if ($truthy(($truthy($a = select['$!']()) ? inc_tags.$values().$first()['$=='](false) : $a))) {
                wildcard = true};
            } else if ($truthy(inc_tags['$key?']("*"))) {
              if (inc_tags.$keys().$first()['$==']("*")) {
                select = (base_select = (wildcard = inc_tags.$delete("*"))['$!']())
              } else {
                
                select = (base_select = false);
                wildcard = inc_tags.$delete("*");
              }
            } else {
              select = (base_select = inc_tags['$value?'](true)['$!']())
            };
            
            try {
              $send(reader, 'call', [inc_path, read_mode], ($$74 = function(f){var self = $$74.$$s || this, $c, $$75, dbl_co = nil, dbl_sb = nil;

              
                
                if (f == null) {
                  f = nil;
                };
                $c = ["::", "[]"], (dbl_co = $c[0]), (dbl_sb = $c[1]), $c;
                return $send(f, 'each_line', [], ($$75 = function(l){var self = $$75.$$s || this, $d, $e, $$76, this_tag = nil, include_cursor = nil, idx = nil;

                
                  
                  if (l == null) {
                    l = nil;
                  };
                  inc_lineno = $rb_plus(inc_lineno, 1);
                  if ($truthy(($truthy($d = ($truthy($e = l['$include?'](dbl_co)) ? l['$include?'](dbl_sb) : $e)) ? $$($nesting, 'TagDirectiveRx')['$=~'](l) : $d))) {
                    
                    this_tag = (($d = $gvars['~']) === nil ? nil : $d['$[]'](2));
                    if ($truthy((($d = $gvars['~']) === nil ? nil : $d['$[]'](1)))) {
                      if (this_tag['$=='](active_tag)) {
                        
                        tag_stack.$pop();
                        return $e = (function() {if ($truthy(tag_stack['$empty?']())) {
                          return [nil, base_select]
                        } else {
                          return tag_stack['$[]'](-1)
                        }; return nil; })(), $d = Opal.to_ary($e), (active_tag = ($d[0] == null ? nil : $d[0])), (select = ($d[1] == null ? nil : $d[1])), $e;
                      } else if ($truthy(inc_tags['$key?'](this_tag))) {
                        
                        include_cursor = self.$create_include_cursor(inc_path, expanded_target, inc_lineno);
                        if ($truthy((idx = $send(tag_stack, 'rindex', [], ($$76 = function(key){var self = $$76.$$s || this;

                        
                          
                          if (key == null) {
                            key = nil;
                          };
                          return key['$=='](this_tag);}, $$76.$$s = self, $$76.$$arity = 1, $$76.$$has_trailing_comma_in_args = true, $$76))))) {
                          
                          if (idx['$=='](0)) {
                            tag_stack.$shift()
                          } else {
                            
                            tag_stack.$delete_at(idx);
                          };
                          return self.$logger().$warn(self.$message_with_context("" + "mismatched end tag (expected '" + (active_tag) + "' but found '" + (this_tag) + "') at line " + (inc_lineno) + " of include " + (target_type) + ": " + (inc_path), $hash2(["source_location", "include_location"], {"source_location": self.$cursor(), "include_location": include_cursor})));
                        } else {
                          return self.$logger().$warn(self.$message_with_context("" + "unexpected end tag '" + (this_tag) + "' at line " + (inc_lineno) + " of include " + (target_type) + ": " + (inc_path), $hash2(["source_location", "include_location"], {"source_location": self.$cursor(), "include_location": include_cursor})))
                        };
                      } else {
                        return nil
                      }
                    } else if ($truthy(inc_tags['$key?'](this_tag))) {
                      
                      if ($truthy((select = inc_tags['$[]'](this_tag)))) {
                        tags_selected['$<<'](this_tag)};
                      return tag_stack['$<<']([(active_tag = this_tag), select, inc_lineno]);
                    } else if ($truthy(wildcard['$nil?']()['$!']())) {
                      
                      select = (function() {if ($truthy(($truthy($d = active_tag) ? select['$!']() : $d))) {
                        return false
                      } else {
                        return wildcard
                      }; return nil; })();
                      return tag_stack['$<<']([(active_tag = this_tag), select, inc_lineno]);
                    } else {
                      return nil
                    };
                  } else if ($truthy(select)) {
                    
                    inc_offset = ($truthy($d = inc_offset) ? $d : inc_lineno);
                    return inc_lines['$<<'](l);
                  } else {
                    return nil
                  };}, $$75.$$s = self, $$75.$$arity = 1, $$75));}, $$74.$$s = self, $$74.$$arity = 1, $$74))
            } catch ($err) {
              if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
                try {
                  
                  self.$logger().$error(self.$message_with_context("" + "include " + (target_type) + " not readable: " + (inc_path), $hash2(["source_location"], {"source_location": self.$cursor()})));
                  return self.$replace_next_line("" + "Unresolved directive in " + (self.path) + " - include::" + (expanded_target) + "[" + (attrlist) + "]");
                } finally { Opal.pop_exception() }
              } else { throw $err; }
            };;
            if ($truthy(tag_stack['$empty?']())) {
            } else {
              $send(tag_stack, 'each', [], ($$77 = function(tag_name, _, tag_lineno){var self = $$77.$$s || this;

              
                
                if (tag_name == null) {
                  tag_name = nil;
                };
                
                if (_ == null) {
                  _ = nil;
                };
                
                if (tag_lineno == null) {
                  tag_lineno = nil;
                };
                return self.$logger().$warn(self.$message_with_context("" + "detected unclosed tag '" + (tag_name) + "' starting at line " + (tag_lineno) + " of include " + (target_type) + ": " + (inc_path), $hash2(["source_location", "include_location"], {"source_location": self.$cursor(), "include_location": self.$create_include_cursor(inc_path, expanded_target, tag_lineno)})));}, $$77.$$s = self, $$77.$$arity = 3, $$77))
            };
            if ($truthy((missing_tags = $rb_minus($send(inc_tags, 'keep_if', [], ($$78 = function(_, v){var self = $$78.$$s || this;

            
              
              if (_ == null) {
                _ = nil;
              };
              
              if (v == null) {
                v = nil;
              };
              return v;}, $$78.$$s = self, $$78.$$arity = 2, $$78)).$keys(), tags_selected.$to_a()))['$empty?']())) {
            } else {
              self.$logger().$warn(self.$message_with_context("" + "tag" + ((function() {if ($truthy($rb_gt(missing_tags.$size(), 1))) {
                return "s"
              } else {
                return ""
              }; return nil; })()) + " '" + (missing_tags.$join(", ")) + "' not found in include " + (target_type) + ": " + (inc_path), $hash2(["source_location"], {"source_location": self.$cursor()})))
            };
            self.$shift();
            if ($truthy(inc_offset)) {
              
              if ($truthy(($truthy($a = ($truthy($b = base_select) ? wildcard['$!='](false) : $b)) ? inc_tags['$empty?']() : $a))) {
              } else {
                
                $writer = ["partial-option", ""];
                $send(parsed_attrs, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];
              };
              self.$push_include(inc_lines, inc_path, relpath, inc_offset, parsed_attrs);};
          } else {
            
            try {
              
              inc_content = $send(reader, 'call', [inc_path, read_mode], ($$79 = function(f){var self = $$79.$$s || this;

              
                
                if (f == null) {
                  f = nil;
                };
                return f.$read();}, $$79.$$s = self, $$79.$$arity = 1, $$79));
              self.$shift();
              self.$push_include(inc_content, inc_path, relpath, 1, parsed_attrs);
            } catch ($err) {
              if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
                try {
                  
                  self.$logger().$error(self.$message_with_context("" + "include " + (target_type) + " not readable: " + (inc_path), $hash2(["source_location"], {"source_location": self.$cursor()})));
                  return self.$replace_next_line("" + "Unresolved directive in " + (self.path) + " - include::" + (expanded_target) + "[" + (attrlist) + "]");
                } finally { Opal.pop_exception() }
              } else { throw $err; }
            };
          };
          return true;
        } else {
          return nil
        };
      }, $PreprocessorReader_preprocess_include_directive$66.$$arity = 2);
      
      Opal.def(self, '$resolve_include_path', $PreprocessorReader_resolve_include_path$80 = function $$resolve_include_path(target, attrlist, attributes) {
        var $a, $b, $$81, self = this, doc = nil, inc_path = nil, relpath = nil;

        
        doc = self.document;
        if ($truthy(($truthy($a = $$($nesting, 'Helpers')['$uriish?'](target)) ? $a : (function() {if ($truthy($$$('::', 'String')['$==='](self.dir))) {
          return nil
        } else {
          
          return (target = "" + (self.dir) + "/" + (target));
        }; return nil; })()))) {
          
          if ($truthy(doc['$attr?']("allow-uri-read"))) {
          } else {
            return self.$replace_next_line("" + "link:" + (target) + "[" + (attrlist) + "]")
          };
          if ($truthy(doc['$attr?']("cache-uri"))) {
            if ($truthy((($b = $$$('::', 'OpenURI', 'skip_raise')) && ($a = $$$($b, 'Cache', 'skip_raise')) ? 'constant' : nil))) {
            } else {
              $$($nesting, 'Helpers').$require_library("open-uri/cached", "open-uri-cached")
            }
          } else if ($truthy($$($nesting, 'RUBY_ENGINE_OPAL')['$!']())) {
            $$$('::', 'OpenURI')};
          return [$$$('::', 'URI').$parse(target), "uri", target];
        } else {
          
          inc_path = doc.$normalize_system_path(target, self.dir, nil, $hash2(["target_name"], {"target_name": "include file"}));
          if ($truthy($$$('::', 'File')['$file?'](inc_path))) {
          } else if ($truthy(attributes['$[]']("optional-option"))) {
            
            $send(self.$logger(), 'info', [], ($$81 = function(){var self = $$81.$$s || this;

            return self.$message_with_context("" + "optional include dropped because include file not found: " + (inc_path), $hash2(["source_location"], {"source_location": self.$cursor()}))}, $$81.$$s = self, $$81.$$arity = 0, $$81));
            self.$shift();
            return true;
          } else {
            
            self.$logger().$error(self.$message_with_context("" + "include file not found: " + (inc_path), $hash2(["source_location"], {"source_location": self.$cursor()})));
            return self.$replace_next_line("" + "Unresolved directive in " + (self.path) + " - include::" + (target) + "[" + (attrlist) + "]");
          };
          relpath = doc.$path_resolver().$relative_path(inc_path, doc.$base_dir());
          return [inc_path, "file", relpath];
        };
      }, $PreprocessorReader_resolve_include_path$80.$$arity = 3);
      
      Opal.def(self, '$pop_include', $PreprocessorReader_pop_include$82 = function $$pop_include() {
        var $a, $b, self = this;

        if ($truthy(self.include_stack['$empty?']())) {
          return nil
        } else {
          
          $b = self.include_stack.$pop(), $a = Opal.to_ary($b), (self.lines = ($a[0] == null ? nil : $a[0])), (self.file = ($a[1] == null ? nil : $a[1])), (self.dir = ($a[2] == null ? nil : $a[2])), (self.path = ($a[3] == null ? nil : $a[3])), (self.lineno = ($a[4] == null ? nil : $a[4])), (self.maxdepth = ($a[5] == null ? nil : $a[5])), (self.process_lines = ($a[6] == null ? nil : $a[6])), $b;
          self.look_ahead = 0;
          return nil;
        }
      }, $PreprocessorReader_pop_include$82.$$arity = 0);
      
      Opal.def(self, '$split_delimited_value', $PreprocessorReader_split_delimited_value$83 = function $$split_delimited_value(val) {
        var self = this;

        if ($truthy(val['$include?'](","))) {
          
          return val.$split(",");
        } else {
          
          return val.$split(";");
        }
      }, $PreprocessorReader_split_delimited_value$83.$$arity = 1);
      
      Opal.def(self, '$skip_front_matter!', $PreprocessorReader_skip_front_matter$excl$84 = function(data, increment_linenos) {
        var $a, $b, self = this, front_matter = nil, original_data = nil;

        
        
        if (increment_linenos == null) {
          increment_linenos = true;
        };
        front_matter = nil;
        if (data['$[]'](0)['$==']("---")) {
          
          original_data = data.$drop(0);
          data.$shift();
          front_matter = [];
          if ($truthy(increment_linenos)) {
            self.lineno = $rb_plus(self.lineno, 1)};
          while ($truthy(($truthy($b = data['$empty?']()['$!']()) ? data['$[]'](0)['$!=']("---") : $b))) {
            
            front_matter['$<<'](data.$shift());
            if ($truthy(increment_linenos)) {
              self.lineno = $rb_plus(self.lineno, 1)};
          };
          if ($truthy(data['$empty?']())) {
            
            $send(data, 'unshift', Opal.to_a(original_data));
            if ($truthy(increment_linenos)) {
              self.lineno = 0};
            front_matter = nil;
          } else {
            
            data.$shift();
            if ($truthy(increment_linenos)) {
              self.lineno = $rb_plus(self.lineno, 1)};
          };};
        return front_matter;
      }, $PreprocessorReader_skip_front_matter$excl$84.$$arity = -2);
      return (Opal.def(self, '$resolve_expr_val', $PreprocessorReader_resolve_expr_val$85 = function $$resolve_expr_val(val) {
        var $a, $b, self = this, quoted = nil;

        
        if ($truthy(($truthy($a = ($truthy($b = val['$start_with?']("\"")) ? val['$end_with?']("\"") : $b)) ? $a : ($truthy($b = val['$start_with?']("'")) ? val['$end_with?']("'") : $b)))) {
          
          quoted = true;
          val = val.$slice(1, $rb_minus(val.$length(), 1));
        } else {
          quoted = false
        };
        if ($truthy(val['$include?']($$($nesting, 'ATTR_REF_HEAD')))) {
          val = self.document.$sub_attributes(val, $hash2(["attribute_missing"], {"attribute_missing": "drop"}))};
        if ($truthy(quoted)) {
          return val
        } else if ($truthy(val['$empty?']())) {
          return nil
        } else if (val['$==']("true")) {
          return true
        } else if (val['$==']("false")) {
          return false
        } else if ($truthy(val.$rstrip()['$empty?']())) {
          return " "
        } else if ($truthy(val['$include?']("."))) {
          return val.$to_f()
        } else {
          return val.$to_i()
        };
      }, $PreprocessorReader_resolve_expr_val$85.$$arity = 1), nil) && 'resolve_expr_val';
    })($nesting[0], $$($nesting, 'Reader'), $nesting);
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/section"] = function(Opal) {
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $hash2 = Opal.hash2, $send = Opal.send, $truthy = Opal.truthy;

  Opal.add_stubs(['$attr_accessor', '$attr_reader', '$===', '$+', '$level', '$special', '$generate_id', '$title', '$>', '$==', '$sectnum', '$reftext', '$!', '$empty?', '$sub_placeholder', '$sub_quotes', '$compat_mode', '$[]', '$attributes', '$context', '$assign_numeral', '$class', '$object_id', '$inspect', '$size', '$length', '$chr', '$[]=', '$-', '$gsub', '$downcase', '$delete', '$tr_s', '$end_with?', '$chop', '$start_with?', '$slice', '$key?', '$catalog', '$unique_id_start_index']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'Section');

      var $nesting = [self].concat($parent_nesting), $Section_initialize$1, $Section_generate_id$2, $Section_sections$ques$3, $Section_sectnum$4, $Section_xreftext$5, $Section_$lt$lt$6, $Section_to_s$7, $Section_generate_id$8;

      self.$$prototype.document = self.$$prototype.next_section_index = self.$$prototype.level = self.$$prototype.parent = self.$$prototype.numeral = self.$$prototype.numbered = self.$$prototype.sectname = self.$$prototype.title = self.$$prototype.blocks = nil;
      
      self.$attr_accessor("index");
      self.$attr_accessor("sectname");
      self.$attr_accessor("special");
      self.$attr_accessor("numbered");
      self.$attr_reader("caption");
      
      Opal.def(self, '$initialize', $Section_initialize$1 = function $$initialize(parent, level, numbered, opts) {
        var $a, $b, $iter = $Section_initialize$1.$$p, $yield = $iter || nil, self = this;

        if ($iter) $Section_initialize$1.$$p = null;
        
        
        if (parent == null) {
          parent = nil;
        };
        
        if (level == null) {
          level = nil;
        };
        
        if (numbered == null) {
          numbered = false;
        };
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        $send(self, Opal.find_super_dispatcher(self, 'initialize', $Section_initialize$1, false), [parent, "section", opts], null);
        if ($truthy($$($nesting, 'Section')['$==='](parent))) {
          $a = [($truthy($b = level) ? $b : $rb_plus(parent.$level(), 1)), parent.$special()], (self.level = $a[0]), (self.special = $a[1]), $a
        } else {
          $a = [($truthy($b = level) ? $b : 1), false], (self.level = $a[0]), (self.special = $a[1]), $a
        };
        self.numbered = numbered;
        return (self.index = 0);
      }, $Section_initialize$1.$$arity = -1);
      Opal.alias(self, "name", "title");
      
      Opal.def(self, '$generate_id', $Section_generate_id$2 = function $$generate_id() {
        var self = this;

        return $$($nesting, 'Section').$generate_id(self.$title(), self.document)
      }, $Section_generate_id$2.$$arity = 0);
      
      Opal.def(self, '$sections?', $Section_sections$ques$3 = function() {
        var self = this;

        return $rb_gt(self.next_section_index, 0)
      }, $Section_sections$ques$3.$$arity = 0);
      
      Opal.def(self, '$sectnum', $Section_sectnum$4 = function $$sectnum(delimiter, append) {
        var $a, self = this;

        
        
        if (delimiter == null) {
          delimiter = ".";
        };
        
        if (append == null) {
          append = nil;
        };
        append = ($truthy($a = append) ? $a : (function() {if (append['$=='](false)) {
          return ""
        } else {
          return delimiter
        }; return nil; })());
        if ($truthy(($truthy($a = $rb_gt(self.level, 1)) ? $$($nesting, 'Section')['$==='](self.parent) : $a))) {
          return "" + (self.parent.$sectnum(delimiter, delimiter)) + (self.numeral) + (append)
        } else {
          return "" + (self.numeral) + (append)
        };
      }, $Section_sectnum$4.$$arity = -1);
      
      Opal.def(self, '$xreftext', $Section_xreftext$5 = function $$xreftext(xrefstyle) {
        var $a, self = this, val = nil, $case = nil, type = nil, quoted_title = nil, signifier = nil;

        
        
        if (xrefstyle == null) {
          xrefstyle = nil;
        };
        if ($truthy(($truthy($a = (val = self.$reftext())) ? val['$empty?']()['$!']() : $a))) {
          return val
        } else if ($truthy(xrefstyle)) {
          if ($truthy(self.numbered)) {
            return (function() {$case = xrefstyle;
            if ("full"['$===']($case)) {
            if ($truthy(($truthy($a = (type = self.sectname)['$==']("chapter")) ? $a : type['$==']("appendix")))) {
              quoted_title = self.$sub_placeholder(self.$sub_quotes("_%s_"), self.$title())
            } else {
              quoted_title = self.$sub_placeholder(self.$sub_quotes((function() {if ($truthy(self.document.$compat_mode())) {
                return "``%s''"
              } else {
                return "\"`%s`\""
              }; return nil; })()), self.$title())
            };
            if ($truthy((signifier = self.document.$attributes()['$[]']("" + (type) + "-refsig")))) {
              return "" + (signifier) + " " + (self.$sectnum(".", ",")) + " " + (quoted_title)
            } else {
              return "" + (self.$sectnum(".", ",")) + " " + (quoted_title)
            };}
            else if ("short"['$===']($case)) {if ($truthy((signifier = self.document.$attributes()['$[]']("" + (self.sectname) + "-refsig")))) {
              return "" + (signifier) + " " + (self.$sectnum(".", ""))
            } else {
              return self.$sectnum(".", "")
            }}
            else {if ($truthy(($truthy($a = (type = self.sectname)['$==']("chapter")) ? $a : type['$==']("appendix")))) {
              
              return self.$sub_placeholder(self.$sub_quotes("_%s_"), self.$title());
            } else {
              return self.$title()
            }}})()
          } else if ($truthy(($truthy($a = (type = self.sectname)['$==']("chapter")) ? $a : type['$==']("appendix")))) {
            
            return self.$sub_placeholder(self.$sub_quotes("_%s_"), self.$title());
          } else {
            return self.$title()
          }
        } else {
          return self.$title()
        };
      }, $Section_xreftext$5.$$arity = -1);
      
      Opal.def(self, '$<<', $Section_$lt$lt$6 = function(block) {
        var $iter = $Section_$lt$lt$6.$$p, $yield = $iter || nil, self = this, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) $Section_$lt$lt$6.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        
        if (block.$context()['$==']("section")) {
          self.$assign_numeral(block)};
        return $send(self, Opal.find_super_dispatcher(self, '<<', $Section_$lt$lt$6, false), $zuper, $iter);
      }, $Section_$lt$lt$6.$$arity = 1);
      
      Opal.def(self, '$to_s', $Section_to_s$7 = function $$to_s() {
        var $iter = $Section_to_s$7.$$p, $yield = $iter || nil, self = this, formal_title = nil, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) $Section_to_s$7.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        if ($truthy(self.title)) {
          
          formal_title = (function() {if ($truthy(self.numbered)) {
            return "" + (self.$sectnum()) + " " + (self.title)
          } else {
            return self.title
          }; return nil; })();
          return "" + "#<" + (self.$class()) + "@" + (self.$object_id()) + " {level: " + (self.level) + ", title: " + (formal_title.$inspect()) + ", blocks: " + (self.blocks.$size()) + "}>";
        } else {
          return $send(self, Opal.find_super_dispatcher(self, 'to_s', $Section_to_s$7, false), $zuper, $iter)
        }
      }, $Section_to_s$7.$$arity = 0);
      return (Opal.defs(self, '$generate_id', $Section_generate_id$8 = function $$generate_id(title, document) {
        var $a, $b, self = this, attrs = nil, pre = nil, sep = nil, no_sep = nil, $writer = nil, sep_sub = nil, gen_id = nil, ids = nil, cnt = nil, candidate_id = nil;

        
        attrs = document.$attributes();
        pre = ($truthy($a = attrs['$[]']("idprefix")) ? $a : "_");
        if ($truthy((sep = attrs['$[]']("idseparator")))) {
          if ($truthy(($truthy($a = sep.$length()['$=='](1)) ? $a : ($truthy($b = (no_sep = sep['$empty?']())['$!']()) ? (sep = (($writer = ["idseparator", sep.$chr()]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])) : $b)))) {
            sep_sub = (function() {if ($truthy(($truthy($a = sep['$==']("-")) ? $a : sep['$=='](".")))) {
              return " .-"
            } else {
              return "" + " " + (sep) + ".-"
            }; return nil; })()}
        } else {
          $a = ["_", " _.-"], (sep = $a[0]), (sep_sub = $a[1]), $a
        };
        gen_id = "" + (pre) + (title.$downcase().$gsub($$($nesting, 'InvalidSectionIdCharsRx'), ""));
        if ($truthy(no_sep)) {
          gen_id = gen_id.$delete(" ")
        } else {
          
          gen_id = gen_id.$tr_s(sep_sub, sep);
          if ($truthy(gen_id['$end_with?'](sep))) {
            gen_id = gen_id.$chop()};
          if ($truthy(($truthy($a = pre['$empty?']()) ? gen_id['$start_with?'](sep) : $a))) {
            gen_id = gen_id.$slice(1, gen_id.$length())};
        };
        if ($truthy(document.$catalog()['$[]']("refs")['$key?'](gen_id))) {
          
          ids = document.$catalog()['$[]']("refs");
          cnt = $$($nesting, 'Compliance').$unique_id_start_index();
          while ($truthy(ids['$[]']((candidate_id = "" + (gen_id) + (sep) + (cnt))))) {
            cnt = $rb_plus(cnt, 1)
          };
          return candidate_id;
        } else {
          return gen_id
        };
      }, $Section_generate_id$8.$$arity = 2), nil) && 'generate_id';
    })($nesting[0], $$($nesting, 'AbstractBlock'), $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/stylesheets"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $truthy = Opal.truthy, $hash2 = Opal.hash2;

  Opal.add_stubs(['$join', '$new', '$rstrip', '$read', '$primary_stylesheet_data', '$write', '$primary_stylesheet_name', '$stylesheet_basename', '$for', '$read_stylesheet', '$coderay_stylesheet_data', '$coderay_stylesheet_name', '$pygments_stylesheet_data', '$pygments_stylesheet_name']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'Stylesheets');

      var $nesting = [self].concat($parent_nesting), $Stylesheets_instance$1, $Stylesheets_primary_stylesheet_name$2, $Stylesheets_primary_stylesheet_data$3, $Stylesheets_embed_primary_stylesheet$4, $Stylesheets_write_primary_stylesheet$5, $Stylesheets_coderay_stylesheet_name$6, $Stylesheets_coderay_stylesheet_data$7, $Stylesheets_embed_coderay_stylesheet$8, $Stylesheets_write_coderay_stylesheet$9, $Stylesheets_pygments_stylesheet_name$10, $Stylesheets_pygments_stylesheet_data$11, $Stylesheets_embed_pygments_stylesheet$12, $Stylesheets_write_pygments_stylesheet$13;

      self.$$prototype.primary_stylesheet_data = nil;
      
      Opal.const_set($nesting[0], 'DEFAULT_STYLESHEET_NAME', "asciidoctor.css");
      Opal.const_set($nesting[0], 'STYLESHEETS_DIR', $$$('::', 'File').$join($$($nesting, 'DATA_DIR'), "stylesheets"));
      self.__instance__ = self.$new();
      Opal.defs(self, '$instance', $Stylesheets_instance$1 = function $$instance() {
        var self = this;
        if (self.__instance__ == null) self.__instance__ = nil;

        return self.__instance__
      }, $Stylesheets_instance$1.$$arity = 0);
      
      Opal.def(self, '$primary_stylesheet_name', $Stylesheets_primary_stylesheet_name$2 = function $$primary_stylesheet_name() {
        var self = this;

        return $$($nesting, 'DEFAULT_STYLESHEET_NAME')
      }, $Stylesheets_primary_stylesheet_name$2.$$arity = 0);
      
      Opal.def(self, '$primary_stylesheet_data', $Stylesheets_primary_stylesheet_data$3 = function $$primary_stylesheet_data() {
        var $a, self = this;

        return (self.primary_stylesheet_data = ($truthy($a = self.primary_stylesheet_data) ? $a : $$$('::', 'File').$read($$$('::', 'File').$join($$($nesting, 'STYLESHEETS_DIR'), "asciidoctor-default.css"), $hash2(["mode"], {"mode": $$($nesting, 'FILE_READ_MODE')})).$rstrip()))
      }, $Stylesheets_primary_stylesheet_data$3.$$arity = 0);
      
      Opal.def(self, '$embed_primary_stylesheet', $Stylesheets_embed_primary_stylesheet$4 = function $$embed_primary_stylesheet() {
        var self = this;

        return "" + "<style>\n" + (self.$primary_stylesheet_data()) + "\n" + "</style>"
      }, $Stylesheets_embed_primary_stylesheet$4.$$arity = 0);
      
      Opal.def(self, '$write_primary_stylesheet', $Stylesheets_write_primary_stylesheet$5 = function $$write_primary_stylesheet(target_dir) {
        var self = this;

        
        
        if (target_dir == null) {
          target_dir = ".";
        };
        return $$$('::', 'File').$write($$$('::', 'File').$join(target_dir, self.$primary_stylesheet_name()), self.$primary_stylesheet_data(), $hash2(["mode"], {"mode": $$($nesting, 'FILE_WRITE_MODE')}));
      }, $Stylesheets_write_primary_stylesheet$5.$$arity = -1);
      
      Opal.def(self, '$coderay_stylesheet_name', $Stylesheets_coderay_stylesheet_name$6 = function $$coderay_stylesheet_name() {
        var self = this;

        return $$($nesting, 'SyntaxHighlighter').$for("coderay").$stylesheet_basename()
      }, $Stylesheets_coderay_stylesheet_name$6.$$arity = 0);
      
      Opal.def(self, '$coderay_stylesheet_data', $Stylesheets_coderay_stylesheet_data$7 = function $$coderay_stylesheet_data() {
        var self = this;

        return $$($nesting, 'SyntaxHighlighter').$for("coderay").$read_stylesheet()
      }, $Stylesheets_coderay_stylesheet_data$7.$$arity = 0);
      
      Opal.def(self, '$embed_coderay_stylesheet', $Stylesheets_embed_coderay_stylesheet$8 = function $$embed_coderay_stylesheet() {
        var self = this;

        return "" + "<style>\n" + (self.$coderay_stylesheet_data()) + "\n" + "</style>"
      }, $Stylesheets_embed_coderay_stylesheet$8.$$arity = 0);
      
      Opal.def(self, '$write_coderay_stylesheet', $Stylesheets_write_coderay_stylesheet$9 = function $$write_coderay_stylesheet(target_dir) {
        var self = this;

        
        
        if (target_dir == null) {
          target_dir = ".";
        };
        return $$$('::', 'File').$write($$$('::', 'File').$join(target_dir, self.$coderay_stylesheet_name()), self.$coderay_stylesheet_data(), $hash2(["mode"], {"mode": $$($nesting, 'FILE_WRITE_MODE')}));
      }, $Stylesheets_write_coderay_stylesheet$9.$$arity = -1);
      
      Opal.def(self, '$pygments_stylesheet_name', $Stylesheets_pygments_stylesheet_name$10 = function $$pygments_stylesheet_name(style) {
        var self = this;

        
        
        if (style == null) {
          style = nil;
        };
        return $$($nesting, 'SyntaxHighlighter').$for("pygments").$stylesheet_basename(style);
      }, $Stylesheets_pygments_stylesheet_name$10.$$arity = -1);
      
      Opal.def(self, '$pygments_stylesheet_data', $Stylesheets_pygments_stylesheet_data$11 = function $$pygments_stylesheet_data(style) {
        var self = this;

        
        
        if (style == null) {
          style = nil;
        };
        return $$($nesting, 'SyntaxHighlighter').$for("pygments").$read_stylesheet(style);
      }, $Stylesheets_pygments_stylesheet_data$11.$$arity = -1);
      
      Opal.def(self, '$embed_pygments_stylesheet', $Stylesheets_embed_pygments_stylesheet$12 = function $$embed_pygments_stylesheet(style) {
        var self = this;

        
        
        if (style == null) {
          style = nil;
        };
        return "" + "<style>\n" + (self.$pygments_stylesheet_data(style)) + "\n" + "</style>";
      }, $Stylesheets_embed_pygments_stylesheet$12.$$arity = -1);
      return (Opal.def(self, '$write_pygments_stylesheet', $Stylesheets_write_pygments_stylesheet$13 = function $$write_pygments_stylesheet(target_dir, style) {
        var self = this;

        
        
        if (target_dir == null) {
          target_dir = ".";
        };
        
        if (style == null) {
          style = nil;
        };
        return $$$('::', 'File').$write($$$('::', 'File').$join(target_dir, self.$pygments_stylesheet_name(style)), self.$pygments_stylesheet_data(style), $hash2(["mode"], {"mode": $$($nesting, 'FILE_WRITE_MODE')}));
      }, $Stylesheets_write_pygments_stylesheet$13.$$arity = -1), nil) && 'write_pygments_stylesheet';
    })($nesting[0], null, $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/table"] = function(Opal) {
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_times(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs * rhs : lhs['$*'](rhs);
  }
  function $rb_divide(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs / rhs : lhs['$/'](rhs);
  }
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $hash2 = Opal.hash2, $send = Opal.send, $truthy = Opal.truthy, $gvars = Opal.gvars;

  Opal.add_stubs(['$attr_accessor', '$attr_reader', '$new', '$[]', '$>', '$to_i', '$<', '$==', '$[]=', '$-', '$attributes', '$truncate', '$*', '$/', '$to_f', '$empty?', '$body', '$each', '$<<', '$size', '$+', '$assign_column_widths', '$warn', '$logger', '$update_attributes', '$assign_width', '$round', '$map', '$shift', '$reinitialize', '$head=', '$nil?', '$unshift', '$pop', '$foot=', '$parent', '$sourcemap', '$dup', '$header_row?', '$table', '$style', '$merge', '$delete', '$===', '$start_with?', '$rstrip', '$slice', '$length', '$advance', '$lstrip', '$strip', '$split', '$include?', '$readlines', '$catalog_inline_anchor', '$=~', '$apply_subs', '$attr_writer', '$convert', '$text', '$!=', '$file', '$lineno', '$include', '$to_set', '$mark', '$key?', '$nested?', '$document', '$error', '$message_with_context', '$cursor_at_prev_line', '$nil_or_empty?', '$escape', '$columns', '$match', '$chop', '$end_with?', '$gsub', '$!', '$push_cellspec', '$cell_open?', '$close_cell', '$take_cellspec', '$squeeze', '$upto', '$times', '$cursor_before_mark', '$rowspan', '$activate_rowspan', '$colspan', '$end_of_row?', '$close_row', '$private', '$rows', '$effective_column_visits']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    
    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'Table');

      var $nesting = [self].concat($parent_nesting), $Table_initialize$4, $Table_header_row$ques$5, $Table_create_columns$6, $Table_assign_column_widths$8, $Table_partition_header_footer$12;

      self.$$prototype.attributes = self.$$prototype.document = self.$$prototype.has_header_option = self.$$prototype.rows = self.$$prototype.columns = nil;
      
      Opal.const_set($nesting[0], 'DEFAULT_PRECISION', 4);
      (function($base, $super, $parent_nesting) {
        var self = $klass($base, $super, 'Rows');

        var $nesting = [self].concat($parent_nesting), $Rows_initialize$1, $Rows_by_section$2, $Rows_to_h$3;

        self.$$prototype.head = self.$$prototype.body = self.$$prototype.foot = nil;
        
        self.$attr_accessor("head", "foot", "body");
        
        Opal.def(self, '$initialize', $Rows_initialize$1 = function $$initialize(head, foot, body) {
          var self = this;

          
          
          if (head == null) {
            head = [];
          };
          
          if (foot == null) {
            foot = [];
          };
          
          if (body == null) {
            body = [];
          };
          self.head = head;
          self.foot = foot;
          return (self.body = body);
        }, $Rows_initialize$1.$$arity = -1);
        Opal.alias(self, "[]", "send");
        
        Opal.def(self, '$by_section', $Rows_by_section$2 = function $$by_section() {
          var self = this;

          return [["head", self.head], ["body", self.body], ["foot", self.foot]]
        }, $Rows_by_section$2.$$arity = 0);
        return (Opal.def(self, '$to_h', $Rows_to_h$3 = function $$to_h() {
          var self = this;

          return $hash2(["head", "body", "foot"], {"head": self.head, "body": self.body, "foot": self.foot})
        }, $Rows_to_h$3.$$arity = 0), nil) && 'to_h';
      })($nesting[0], null, $nesting);
      self.$attr_accessor("columns");
      self.$attr_accessor("rows");
      self.$attr_accessor("has_header_option");
      self.$attr_reader("caption");
      
      Opal.def(self, '$initialize', $Table_initialize$4 = function $$initialize(parent, attributes) {
        var $a, $b, $iter = $Table_initialize$4.$$p, $yield = $iter || nil, self = this, pcwidth = nil, pcwidth_intval = nil, $writer = nil, abswidth_val = nil;

        if ($iter) $Table_initialize$4.$$p = null;
        
        $send(self, Opal.find_super_dispatcher(self, 'initialize', $Table_initialize$4, false), [parent, "table"], null);
        self.rows = $$($nesting, 'Rows').$new();
        self.columns = [];
        self.has_header_option = false;
        if ($truthy((pcwidth = attributes['$[]']("width")))) {
          if ($truthy(($truthy($a = $rb_gt((pcwidth_intval = pcwidth.$to_i()), 100)) ? $a : $rb_lt(pcwidth_intval, 1)))) {
            if ($truthy((($a = pcwidth_intval['$=='](0)) ? ($truthy($b = pcwidth['$==']("0")) ? $b : pcwidth['$==']("0%")) : pcwidth_intval['$=='](0)))) {
            } else {
              pcwidth_intval = 100
            }}
        } else {
          pcwidth_intval = 100
        };
        
        $writer = ["tablepcwidth", pcwidth_intval];
        $send(self.attributes, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        if ($truthy(self.document.$attributes()['$[]']("pagewidth"))) {
          
          $writer = ["tableabswidth", (function() {if ((abswidth_val = $rb_times($rb_divide(pcwidth_intval, 100), self.document.$attributes()['$[]']("pagewidth").$to_f()).$truncate($$($nesting, 'DEFAULT_PRECISION')))['$=='](abswidth_val.$to_i())) {
            return abswidth_val.$to_i()
          } else {
            return abswidth_val
          }; return nil; })()];
          $send(self.attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        if ($truthy(attributes['$[]']("rotate-option"))) {
          
          $writer = ["orientation", "landscape"];
          $send(self.attributes, '[]=', Opal.to_a($writer));
          return $writer[$rb_minus($writer["length"], 1)];
        } else {
          return nil
        };
      }, $Table_initialize$4.$$arity = 2);
      
      Opal.def(self, '$header_row?', $Table_header_row$ques$5 = function() {
        var $a, self = this, val = nil;

        if ($truthy(($truthy($a = (val = self.has_header_option)) ? self.rows.$body()['$empty?']() : $a))) {
          return val
        } else {
          return nil
        }
      }, $Table_header_row$ques$5.$$arity = 0);
      
      Opal.def(self, '$create_columns', $Table_create_columns$6 = function $$create_columns(colspecs) {
        var $$7, $a, self = this, cols = nil, autowidth_cols = nil, width_base = nil, num_cols = nil, $writer = nil;

        
        cols = [];
        autowidth_cols = nil;
        width_base = 0;
        $send(colspecs, 'each', [], ($$7 = function(colspec){var self = $$7.$$s || this, $a, colwidth = nil;

        
          
          if (colspec == null) {
            colspec = nil;
          };
          colwidth = colspec['$[]']("width");
          cols['$<<']($$($nesting, 'Column').$new(self, cols.$size(), colspec));
          if ($truthy($rb_lt(colwidth, 0))) {
            return (autowidth_cols = ($truthy($a = autowidth_cols) ? $a : []))['$<<'](cols['$[]'](-1))
          } else {
            return (width_base = $rb_plus(width_base, colwidth))
          };}, $$7.$$s = self, $$7.$$arity = 1, $$7));
        if ($truthy($rb_gt((num_cols = (self.columns = cols).$size()), 0))) {
          
          
          $writer = ["colcount", num_cols];
          $send(self.attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          if ($truthy(($truthy($a = $rb_gt(width_base, 0)) ? $a : autowidth_cols))) {
          } else {
            width_base = nil
          };
          self.$assign_column_widths(width_base, autowidth_cols);};
        return nil;
      }, $Table_create_columns$6.$$arity = 1);
      
      Opal.def(self, '$assign_column_widths', $Table_assign_column_widths$8 = function $$assign_column_widths(width_base, autowidth_cols) {
        var $$9, $$10, $$11, self = this, precision = nil, total_width = nil, col_pcwidth = nil, autowidth = nil, autowidth_attrs = nil;

        
        
        if (width_base == null) {
          width_base = nil;
        };
        
        if (autowidth_cols == null) {
          autowidth_cols = nil;
        };
        precision = $$($nesting, 'DEFAULT_PRECISION');
        total_width = (col_pcwidth = 0);
        if ($truthy(width_base)) {
          
          if ($truthy(autowidth_cols)) {
            
            if ($truthy($rb_gt(width_base, 100))) {
              
              autowidth = 0;
              self.$logger().$warn("" + "total column width must not exceed 100% when using autowidth columns; got " + (width_base) + "%");
            } else {
              
              autowidth = $rb_divide($rb_minus(100, width_base), autowidth_cols.$size()).$truncate(precision);
              if (autowidth.$to_i()['$=='](autowidth)) {
                autowidth = autowidth.$to_i()};
              width_base = 100;
            };
            autowidth_attrs = $hash2(["width", "autowidth-option"], {"width": autowidth, "autowidth-option": ""});
            $send(autowidth_cols, 'each', [], ($$9 = function(col){var self = $$9.$$s || this;

            
              
              if (col == null) {
                col = nil;
              };
              return col.$update_attributes(autowidth_attrs);}, $$9.$$s = self, $$9.$$arity = 1, $$9));};
          $send(self.columns, 'each', [], ($$10 = function(col){var self = $$10.$$s || this;

          
            
            if (col == null) {
              col = nil;
            };
            return (total_width = $rb_plus(total_width, (col_pcwidth = col.$assign_width(nil, width_base, precision))));}, $$10.$$s = self, $$10.$$arity = 1, $$10));
        } else {
          
          col_pcwidth = $rb_divide(100, self.columns.$size()).$truncate(precision);
          if (col_pcwidth.$to_i()['$=='](col_pcwidth)) {
            col_pcwidth = col_pcwidth.$to_i()};
          $send(self.columns, 'each', [], ($$11 = function(col){var self = $$11.$$s || this;

          
            
            if (col == null) {
              col = nil;
            };
            return (total_width = $rb_plus(total_width, col.$assign_width(col_pcwidth, nil, precision)));}, $$11.$$s = self, $$11.$$arity = 1, $$11));
        };
        if (total_width['$=='](100)) {
        } else {
          self.columns['$[]'](-1).$assign_width($rb_plus($rb_minus(100, total_width), col_pcwidth).$round(precision), nil, precision)
        };
        return nil;
      }, $Table_assign_column_widths$8.$$arity = -1);
      return (Opal.def(self, '$partition_header_footer', $Table_partition_header_footer$12 = function $$partition_header_footer(attrs) {
        var $$13, $$14, $a, self = this, num_body_rows = nil, $writer = nil, body = nil;

        
        num_body_rows = (($writer = ["rowcount", (body = self.rows.$body()).$size()]), $send(self.attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]);
        if ($truthy($rb_gt(num_body_rows, 0))) {
          if ($truthy(self.has_header_option)) {
            
            
            $writer = [[$send(body.$shift(), 'map', [], ($$13 = function(cell){var self = $$13.$$s || this;

            
              
              if (cell == null) {
                cell = nil;
              };
              return cell.$reinitialize(true);}, $$13.$$s = self, $$13.$$arity = 1, $$13))]];
            $send(self.rows, 'head=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            num_body_rows = $rb_minus(num_body_rows, 1);
          } else if ($truthy(self.has_header_option['$nil?']())) {
            
            self.has_header_option = false;
            body.$unshift($send(body.$shift(), 'map', [], ($$14 = function(cell){var self = $$14.$$s || this;

            
              
              if (cell == null) {
                cell = nil;
              };
              return cell.$reinitialize(false);}, $$14.$$s = self, $$14.$$arity = 1, $$14)));}};
        if ($truthy(($truthy($a = $rb_gt(num_body_rows, 0)) ? attrs['$[]']("footer-option") : $a))) {
          
          $writer = [[body.$pop()]];
          $send(self.rows, 'foot=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        return nil;
      }, $Table_partition_header_footer$12.$$arity = 1), nil) && 'partition_header_footer';
    })($nesting[0], $$($nesting, 'AbstractBlock'), $nesting);
    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'Column');

      var $nesting = [self].concat($parent_nesting), $Column_initialize$15, $Column_assign_width$16, $Column_block$ques$17, $Column_inline$ques$18;

      self.$$prototype.attributes = nil;
      
      self.$attr_accessor("style");
      
      Opal.def(self, '$initialize', $Column_initialize$15 = function $$initialize(table, index, attributes) {
        var $a, $iter = $Column_initialize$15.$$p, $yield = $iter || nil, self = this, $writer = nil;

        if ($iter) $Column_initialize$15.$$p = null;
        
        
        if (attributes == null) {
          attributes = $hash2([], {});
        };
        $send(self, Opal.find_super_dispatcher(self, 'initialize', $Column_initialize$15, false), [table, "table_column"], null);
        self.style = attributes['$[]']("style");
        
        $writer = ["colnumber", $rb_plus(index, 1)];
        $send(attributes, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        ($truthy($a = attributes['$[]']("width")) ? $a : (($writer = ["width", 1]), $send(attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        ($truthy($a = attributes['$[]']("halign")) ? $a : (($writer = ["halign", "left"]), $send(attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        ($truthy($a = attributes['$[]']("valign")) ? $a : (($writer = ["valign", "top"]), $send(attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        return self.$update_attributes(attributes);
      }, $Column_initialize$15.$$arity = -3);
      Opal.alias(self, "table", "parent");
      
      Opal.def(self, '$assign_width', $Column_assign_width$16 = function $$assign_width(col_pcwidth, width_base, precision) {
        var self = this, $writer = nil, col_abswidth = nil;

        
        if ($truthy(width_base)) {
          
          col_pcwidth = $rb_divide($rb_times(self.attributes['$[]']("width").$to_f(), 100), width_base).$truncate(precision);
          if (col_pcwidth.$to_i()['$=='](col_pcwidth)) {
            col_pcwidth = col_pcwidth.$to_i()};};
        if ($truthy(self.$parent().$attributes()['$[]']("tableabswidth"))) {
          
          $writer = ["colabswidth", (function() {if ((col_abswidth = $rb_times($rb_divide(col_pcwidth, 100), self.$parent().$attributes()['$[]']("tableabswidth")).$truncate(precision))['$=='](col_abswidth.$to_i())) {
            return col_abswidth.$to_i()
          } else {
            return col_abswidth
          }; return nil; })()];
          $send(self.attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        
        $writer = ["colpcwidth", col_pcwidth];
        $send(self.attributes, '[]=', Opal.to_a($writer));
        return $writer[$rb_minus($writer["length"], 1)];;
      }, $Column_assign_width$16.$$arity = 3);
      
      Opal.def(self, '$block?', $Column_block$ques$17 = function() {
        var self = this;

        return false
      }, $Column_block$ques$17.$$arity = 0);
      return (Opal.def(self, '$inline?', $Column_inline$ques$18 = function() {
        var self = this;

        return false
      }, $Column_inline$ques$18.$$arity = 0), nil) && 'inline?';
    })($$($nesting, 'Table'), $$($nesting, 'AbstractNode'), $nesting);
    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'Cell');

      var $nesting = [self].concat($parent_nesting), $Cell_initialize$19, $Cell_reinitialize$20, $Cell_catalog_inline_anchor$21, $Cell_text$22, $Cell_content$23, $Cell_lines$25, $Cell_source$26, $Cell_file$27, $Cell_lineno$28, $Cell_to_s$29;

      self.$$prototype.document = self.$$prototype.reinitialize_args = self.$$prototype.attributes = self.$$prototype.cursor = self.$$prototype.text = self.$$prototype.subs = self.$$prototype.style = self.$$prototype.inner_document = self.$$prototype.source_location = self.$$prototype.colspan = self.$$prototype.rowspan = nil;
      
      Opal.const_set($nesting[0], 'DOUBLE_LF', $rb_times($$($nesting, 'LF'), 2));
      self.$attr_accessor("colspan");
      self.$attr_accessor("rowspan");
      Opal.alias(self, "column", "parent");
      self.$attr_reader("inner_document");
      
      Opal.def(self, '$initialize', $Cell_initialize$19 = function $$initialize(column, cell_text, attributes, opts) {
        var $a, $b, $c, $iter = $Cell_initialize$19.$$p, $yield = $iter || nil, self = this, in_header_row = nil, cell_style = nil, $case = nil, asciidoc = nil, inner_document_cursor = nil, lines_advanced = nil, literal = nil, normal_psv = nil, parent_doctitle = nil, inner_document_lines = nil, unprocessed_line1 = nil, preprocessed_lines = nil, $writer = nil;

        if ($iter) $Cell_initialize$19.$$p = null;
        
        
        if (attributes == null) {
          attributes = $hash2([], {});
        };
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        $send(self, Opal.find_super_dispatcher(self, 'initialize', $Cell_initialize$19, false), [column, "table_cell"], null);
        self.cursor = (self.reinitialize_args = nil);
        if ($truthy(self.document.$sourcemap())) {
          self.source_location = opts['$[]']("cursor").$dup()};
        if ($truthy(column)) {
          
          if ($truthy((in_header_row = column.$table()['$header_row?']()))) {
            if ($truthy((($a = in_header_row['$==']("implicit")) ? (cell_style = ($truthy($b = column.$style()) ? $b : ($truthy($c = attributes) ? attributes['$[]']("style") : $c))) : in_header_row['$==']("implicit")))) {
              
              if ($truthy(($truthy($a = cell_style['$==']("asciidoc")) ? $a : cell_style['$==']("literal")))) {
                self.reinitialize_args = [column, cell_text, ($truthy($a = attributes) ? attributes.$merge() : $a), opts]};
              cell_style = nil;}
          } else {
            cell_style = column.$style()
          };
          self.$update_attributes(column.$attributes());};
        if ($truthy(attributes)) {
          
          if ($truthy(attributes['$empty?']())) {
            self.colspan = (self.rowspan = nil)
          } else {
            
            $a = [attributes.$delete("colspan"), attributes.$delete("rowspan")], (self.colspan = $a[0]), (self.rowspan = $a[1]), $a;
            if ($truthy(in_header_row)) {
            } else {
              cell_style = ($truthy($a = attributes['$[]']("style")) ? $a : cell_style)
            };
            self.$update_attributes(attributes);
          };
          $case = cell_style;
          if ("asciidoc"['$===']($case)) {
          asciidoc = true;
          inner_document_cursor = opts['$[]']("cursor");
          if ($truthy((cell_text = cell_text.$rstrip())['$start_with?']($$($nesting, 'LF')))) {
            
            lines_advanced = 1;
            while ($truthy((cell_text = cell_text.$slice(1, cell_text.$length()))['$start_with?']($$($nesting, 'LF')))) {
              lines_advanced = $rb_plus(lines_advanced, 1)
            };
            inner_document_cursor.$advance(lines_advanced);
          } else {
            cell_text = cell_text.$lstrip()
          };}
          else if ("literal"['$===']($case)) {
          literal = true;
          cell_text = cell_text.$rstrip();
          while ($truthy(cell_text['$start_with?']($$($nesting, 'LF')))) {
            cell_text = cell_text.$slice(1, cell_text.$length())
          };}
          else {
          normal_psv = true;
          cell_text = (function() {if ($truthy(cell_text)) {
            return cell_text.$strip()
          } else {
            return ""
          }; return nil; })();};
        } else {
          
          self.colspan = (self.rowspan = nil);
          if (cell_style['$==']("asciidoc")) {
            
            asciidoc = true;
            inner_document_cursor = opts['$[]']("cursor");};
        };
        if ($truthy(asciidoc)) {
          
          parent_doctitle = self.document.$attributes().$delete("doctitle");
          inner_document_lines = cell_text.$split($$($nesting, 'LF'), -1);
          if ($truthy(inner_document_lines['$empty?']())) {
          } else if ($truthy((unprocessed_line1 = inner_document_lines['$[]'](0))['$include?']("::"))) {
            
            preprocessed_lines = $$($nesting, 'PreprocessorReader').$new(self.document, [unprocessed_line1]).$readlines();
            if ($truthy((($a = unprocessed_line1['$=='](preprocessed_lines['$[]'](0))) ? $rb_lt(preprocessed_lines.$size(), 2) : unprocessed_line1['$=='](preprocessed_lines['$[]'](0))))) {
            } else {
              
              inner_document_lines.$shift();
              if ($truthy(preprocessed_lines['$empty?']())) {
              } else {
                $send(inner_document_lines, 'unshift', Opal.to_a(preprocessed_lines))
              };
            };};
          self.inner_document = $$($nesting, 'Document').$new(inner_document_lines, $hash2(["standalone", "parent", "cursor"], {"standalone": false, "parent": self.document, "cursor": inner_document_cursor}));
          if ($truthy(parent_doctitle['$nil?']())) {
          } else {
            
            $writer = ["doctitle", parent_doctitle];
            $send(self.document.$attributes(), '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          };
          self.subs = nil;
        } else if ($truthy(literal)) {
          
          self.content_model = "verbatim";
          self.subs = $$($nesting, 'BASIC_SUBS');
        } else {
          
          if ($truthy(normal_psv)) {
            if ($truthy(in_header_row)) {
              self.cursor = opts['$[]']("cursor")
            } else {
              self.$catalog_inline_anchor(cell_text, opts['$[]']("cursor"))
            }};
          self.content_model = "simple";
          self.subs = $$($nesting, 'NORMAL_SUBS');
        };
        self.text = cell_text;
        return (self.style = cell_style);
      }, $Cell_initialize$19.$$arity = -3);
      
      Opal.def(self, '$reinitialize', $Cell_reinitialize$20 = function $$reinitialize(has_header) {
        var self = this;

        
        if ($truthy(has_header)) {
          self.reinitialize_args = nil
        } else if ($truthy(self.reinitialize_args)) {
          return $send($$$($$($nesting, 'Table'), 'Cell'), 'new', Opal.to_a(self.reinitialize_args))
        } else {
          self.style = self.attributes['$[]']("style")
        };
        if ($truthy(self.cursor)) {
          self.$catalog_inline_anchor()};
        return self;
      }, $Cell_reinitialize$20.$$arity = 1);
      
      Opal.def(self, '$catalog_inline_anchor', $Cell_catalog_inline_anchor$21 = function $$catalog_inline_anchor(cell_text, cursor) {
        var $a, self = this;

        
        
        if (cell_text == null) {
          cell_text = self.text;
        };
        
        if (cursor == null) {
          cursor = nil;
        };
        if ($truthy(cursor)) {
        } else {
          $a = [self.cursor, nil], (cursor = $a[0]), (self.cursor = $a[1]), $a
        };
        if ($truthy(($truthy($a = cell_text['$start_with?']("[[")) ? $$($nesting, 'LeadingInlineAnchorRx')['$=~'](cell_text) : $a))) {
          return $$($nesting, 'Parser').$catalog_inline_anchor((($a = $gvars['~']) === nil ? nil : $a['$[]'](1)), (($a = $gvars['~']) === nil ? nil : $a['$[]'](2)), self, cursor, self.document)
        } else {
          return nil
        };
      }, $Cell_catalog_inline_anchor$21.$$arity = -1);
      
      Opal.def(self, '$text', $Cell_text$22 = function $$text() {
        var self = this;

        return self.$apply_subs(self.text, self.subs)
      }, $Cell_text$22.$$arity = 0);
      self.$attr_writer("text");
      
      Opal.def(self, '$content', $Cell_content$23 = function $$content() {
        var $$24, $a, self = this, cell_style = nil, subbed_text = nil;

        if ((cell_style = self.style)['$==']("asciidoc")) {
          return self.inner_document.$convert()
        } else if ($truthy(self.text['$include?']($$($nesting, 'DOUBLE_LF')))) {
          return $send(self.$text().$split($$($nesting, 'BlankLineRx')), 'map', [], ($$24 = function(para){var self = $$24.$$s || this, $a;

          
            
            if (para == null) {
              para = nil;
            };
            if ($truthy(($truthy($a = cell_style) ? cell_style['$!=']("header") : $a))) {
              return $$($nesting, 'Inline').$new(self.$parent(), "quoted", para, $hash2(["type"], {"type": cell_style})).$convert()
            } else {
              return para
            };}, $$24.$$s = self, $$24.$$arity = 1, $$24))
        } else if ($truthy((subbed_text = self.$text())['$empty?']())) {
          return []
        } else if ($truthy(($truthy($a = cell_style) ? cell_style['$!=']("header") : $a))) {
          return [$$($nesting, 'Inline').$new(self.$parent(), "quoted", subbed_text, $hash2(["type"], {"type": cell_style})).$convert()]
        } else {
          return [subbed_text]
        }
      }, $Cell_content$23.$$arity = 0);
      
      Opal.def(self, '$lines', $Cell_lines$25 = function $$lines() {
        var self = this;

        return self.text.$split($$($nesting, 'LF'))
      }, $Cell_lines$25.$$arity = 0);
      
      Opal.def(self, '$source', $Cell_source$26 = function $$source() {
        var self = this;

        return self.text
      }, $Cell_source$26.$$arity = 0);
      
      Opal.def(self, '$file', $Cell_file$27 = function $$file() {
        var $a, self = this;

        return ($truthy($a = self.source_location) ? self.source_location.$file() : $a)
      }, $Cell_file$27.$$arity = 0);
      
      Opal.def(self, '$lineno', $Cell_lineno$28 = function $$lineno() {
        var $a, self = this;

        return ($truthy($a = self.source_location) ? self.source_location.$lineno() : $a)
      }, $Cell_lineno$28.$$arity = 0);
      return (Opal.def(self, '$to_s', $Cell_to_s$29 = function $$to_s() {
        var $a, $iter = $Cell_to_s$29.$$p, $yield = $iter || nil, self = this, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) $Cell_to_s$29.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        return "" + ($send(self, Opal.find_super_dispatcher(self, 'to_s', $Cell_to_s$29, false), $zuper, $iter)) + " - [text: " + (self.text) + ", colspan: " + (($truthy($a = self.colspan) ? $a : 1)) + ", rowspan: " + (($truthy($a = self.rowspan) ? $a : 1)) + ", attributes: " + (self.attributes) + "]"
      }, $Cell_to_s$29.$$arity = 0), nil) && 'to_s';
    })($$($nesting, 'Table'), $$($nesting, 'AbstractBlock'), $nesting);
    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'ParserContext');

      var $nesting = [self].concat($parent_nesting), $ParserContext_initialize$30, $ParserContext_starts_with_delimiter$ques$31, $ParserContext_match_delimiter$32, $ParserContext_skip_past_delimiter$33, $ParserContext_skip_past_escaped_delimiter$34, $ParserContext_buffer_has_unclosed_quotes$ques$35, $ParserContext_take_cellspec$36, $ParserContext_push_cellspec$37, $ParserContext_keep_cell_open$38, $ParserContext_mark_cell_closed$39, $ParserContext_cell_open$ques$40, $ParserContext_cell_closed$ques$41, $ParserContext_close_open_cell$42, $ParserContext_close_cell$43, $ParserContext_close_row$46, $ParserContext_activate_rowspan$47, $ParserContext_end_of_row$ques$49, $ParserContext_effective_column_visits$50, $ParserContext_advance$51;

      self.$$prototype.delimiter = self.$$prototype.delimiter_rx = self.$$prototype.buffer = self.$$prototype.cellspecs = self.$$prototype.cell_open = self.$$prototype.format = self.$$prototype.start_cursor_data = self.$$prototype.reader = self.$$prototype.table = self.$$prototype.current_row = self.$$prototype.colcount = self.$$prototype.column_visits = self.$$prototype.active_rowspans = self.$$prototype.linenum = nil;
      
      self.$include($$($nesting, 'Logging'));
      Opal.const_set($nesting[0], 'FORMATS', ["psv", "csv", "dsv", "tsv"].$to_set());
      Opal.const_set($nesting[0], 'DELIMITERS', $hash2(["psv", "csv", "dsv", "tsv", "!sv"], {"psv": ["|", /\|/], "csv": [",", /,/], "dsv": [":", /:/], "tsv": ["\t", /\t/], "!sv": ["!", /!/]}));
      self.$attr_accessor("table");
      self.$attr_accessor("format");
      self.$attr_reader("colcount");
      self.$attr_accessor("buffer");
      self.$attr_reader("delimiter");
      self.$attr_reader("delimiter_re");
      
      Opal.def(self, '$initialize', $ParserContext_initialize$30 = function $$initialize(reader, table, attributes) {
        var $a, $b, self = this, xsv = nil, sep = nil;

        
        
        if (attributes == null) {
          attributes = $hash2([], {});
        };
        self.start_cursor_data = (self.reader = reader).$mark();
        self.table = table;
        if ($truthy(attributes['$key?']("format"))) {
          if ($truthy($$($nesting, 'FORMATS')['$include?']((xsv = attributes['$[]']("format"))))) {
            if (xsv['$==']("tsv")) {
              self.format = "csv"
            } else if ($truthy((($a = (self.format = xsv)['$==']("psv")) ? table.$document()['$nested?']() : (self.format = xsv)['$==']("psv")))) {
              xsv = "!sv"}
          } else {
            
            self.$logger().$error(self.$message_with_context("" + "illegal table format: " + (xsv), $hash2(["source_location"], {"source_location": reader.$cursor_at_prev_line()})));
            $a = ["psv", (function() {if ($truthy(table.$document()['$nested?']())) {
              return "!sv"
            } else {
              return "psv"
            }; return nil; })()], (self.format = $a[0]), (xsv = $a[1]), $a;
          }
        } else {
          $a = ["psv", (function() {if ($truthy(table.$document()['$nested?']())) {
            return "!sv"
          } else {
            return "psv"
          }; return nil; })()], (self.format = $a[0]), (xsv = $a[1]), $a
        };
        if ($truthy(attributes['$key?']("separator"))) {
          if ($truthy((sep = attributes['$[]']("separator"))['$nil_or_empty?']())) {
            $b = $$($nesting, 'DELIMITERS')['$[]'](xsv), $a = Opal.to_ary($b), (self.delimiter = ($a[0] == null ? nil : $a[0])), (self.delimiter_rx = ($a[1] == null ? nil : $a[1])), $b
          } else if (sep['$==']("\\t")) {
            $b = $$($nesting, 'DELIMITERS')['$[]']("tsv"), $a = Opal.to_ary($b), (self.delimiter = ($a[0] == null ? nil : $a[0])), (self.delimiter_rx = ($a[1] == null ? nil : $a[1])), $b
          } else {
            $a = [sep, new RegExp($$$('::', 'Regexp').$escape(sep))], (self.delimiter = $a[0]), (self.delimiter_rx = $a[1]), $a
          }
        } else {
          $b = $$($nesting, 'DELIMITERS')['$[]'](xsv), $a = Opal.to_ary($b), (self.delimiter = ($a[0] == null ? nil : $a[0])), (self.delimiter_rx = ($a[1] == null ? nil : $a[1])), $b
        };
        self.colcount = (function() {if ($truthy(table.$columns()['$empty?']())) {
          return -1
        } else {
          return table.$columns().$size()
        }; return nil; })();
        self.buffer = "";
        self.cellspecs = [];
        self.cell_open = false;
        self.active_rowspans = [0];
        self.column_visits = 0;
        self.current_row = [];
        return (self.linenum = -1);
      }, $ParserContext_initialize$30.$$arity = -3);
      
      Opal.def(self, '$starts_with_delimiter?', $ParserContext_starts_with_delimiter$ques$31 = function(line) {
        var self = this;

        return line['$start_with?'](self.delimiter)
      }, $ParserContext_starts_with_delimiter$ques$31.$$arity = 1);
      
      Opal.def(self, '$match_delimiter', $ParserContext_match_delimiter$32 = function $$match_delimiter(line) {
        var self = this;

        return self.delimiter_rx.$match(line)
      }, $ParserContext_match_delimiter$32.$$arity = 1);
      
      Opal.def(self, '$skip_past_delimiter', $ParserContext_skip_past_delimiter$33 = function $$skip_past_delimiter(pre) {
        var self = this;

        
        self.buffer = "" + (self.buffer) + (pre) + (self.delimiter);
        return nil;
      }, $ParserContext_skip_past_delimiter$33.$$arity = 1);
      
      Opal.def(self, '$skip_past_escaped_delimiter', $ParserContext_skip_past_escaped_delimiter$34 = function $$skip_past_escaped_delimiter(pre) {
        var self = this;

        
        self.buffer = "" + (self.buffer) + (pre.$chop()) + (self.delimiter);
        return nil;
      }, $ParserContext_skip_past_escaped_delimiter$34.$$arity = 1);
      
      Opal.def(self, '$buffer_has_unclosed_quotes?', $ParserContext_buffer_has_unclosed_quotes$ques$35 = function(append, q) {
        var $a, $b, self = this, record = nil, qq = nil, trailing_quote = nil;

        
        
        if (append == null) {
          append = nil;
        };
        
        if (q == null) {
          q = "\"";
        };
        if ((record = (function() {if ($truthy(append)) {
          return $rb_plus(self.buffer, append).$strip()
        } else {
          return self.buffer.$strip()
        }; return nil; })())['$=='](q)) {
          return true
        } else if ($truthy(record['$start_with?'](q))) {
          
          qq = $rb_plus(q, q);
          if ($truthy(($truthy($a = ($truthy($b = (trailing_quote = record['$end_with?'](q))) ? record['$end_with?'](qq) : $b)) ? $a : record['$start_with?'](qq)))) {
            return ($truthy($a = (record = record.$gsub(qq, ""))['$start_with?'](q)) ? record['$end_with?'](q)['$!']() : $a)
          } else {
            return trailing_quote['$!']()
          };
        } else {
          return false
        };
      }, $ParserContext_buffer_has_unclosed_quotes$ques$35.$$arity = -1);
      
      Opal.def(self, '$take_cellspec', $ParserContext_take_cellspec$36 = function $$take_cellspec() {
        var self = this;

        return self.cellspecs.$shift()
      }, $ParserContext_take_cellspec$36.$$arity = 0);
      
      Opal.def(self, '$push_cellspec', $ParserContext_push_cellspec$37 = function $$push_cellspec(cellspec) {
        var $a, self = this;

        
        
        if (cellspec == null) {
          cellspec = $hash2([], {});
        };
        self.cellspecs['$<<'](($truthy($a = cellspec) ? $a : $hash2([], {})));
        return nil;
      }, $ParserContext_push_cellspec$37.$$arity = -1);
      
      Opal.def(self, '$keep_cell_open', $ParserContext_keep_cell_open$38 = function $$keep_cell_open() {
        var self = this;

        
        self.cell_open = true;
        return nil;
      }, $ParserContext_keep_cell_open$38.$$arity = 0);
      
      Opal.def(self, '$mark_cell_closed', $ParserContext_mark_cell_closed$39 = function $$mark_cell_closed() {
        var self = this;

        
        self.cell_open = false;
        return nil;
      }, $ParserContext_mark_cell_closed$39.$$arity = 0);
      
      Opal.def(self, '$cell_open?', $ParserContext_cell_open$ques$40 = function() {
        var self = this;

        return self.cell_open
      }, $ParserContext_cell_open$ques$40.$$arity = 0);
      
      Opal.def(self, '$cell_closed?', $ParserContext_cell_closed$ques$41 = function() {
        var self = this;

        return self.cell_open['$!']()
      }, $ParserContext_cell_closed$ques$41.$$arity = 0);
      
      Opal.def(self, '$close_open_cell', $ParserContext_close_open_cell$42 = function $$close_open_cell(next_cellspec) {
        var self = this;

        
        
        if (next_cellspec == null) {
          next_cellspec = $hash2([], {});
        };
        self.$push_cellspec(next_cellspec);
        if ($truthy(self['$cell_open?']())) {
          self.$close_cell(true)};
        self.$advance();
        return nil;
      }, $ParserContext_close_open_cell$42.$$arity = -1);
      
      Opal.def(self, '$close_cell', $ParserContext_close_cell$43 = function $$close_cell(eol) {try {

        var $a, $b, $$44, self = this, cell_text = nil, cellspec = nil, repeat = nil, q = nil;

        
        
        if (eol == null) {
          eol = false;
        };
        if (self.format['$==']("psv")) {
          
          cell_text = self.buffer;
          self.buffer = "";
          if ($truthy((cellspec = self.$take_cellspec()))) {
            repeat = ($truthy($a = cellspec.$delete("repeatcol")) ? $a : 1)
          } else {
            
            self.$logger().$error(self.$message_with_context("table missing leading separator; recovering automatically", $hash2(["source_location"], {"source_location": $send($$$($$($nesting, 'Reader'), 'Cursor'), 'new', Opal.to_a(self.start_cursor_data))})));
            cellspec = $hash2([], {});
            repeat = 1;
          };
        } else {
          
          cell_text = self.buffer.$strip();
          self.buffer = "";
          cellspec = nil;
          repeat = 1;
          if ($truthy(($truthy($a = (($b = self.format['$==']("csv")) ? cell_text['$empty?']()['$!']() : self.format['$==']("csv"))) ? cell_text['$include?']((q = "\"")) : $a))) {
            if ($truthy(($truthy($a = cell_text['$start_with?'](q)) ? cell_text['$end_with?'](q) : $a))) {
              if ($truthy((cell_text = cell_text.$slice(1, $rb_minus(cell_text.$length(), 2))))) {
                cell_text = cell_text.$strip().$squeeze(q)
              } else {
                
                self.$logger().$error(self.$message_with_context("unclosed quote in CSV data; setting cell to empty", $hash2(["source_location"], {"source_location": self.reader.$cursor_at_prev_line()})));
                cell_text = "";
              }
            } else {
              cell_text = cell_text.$squeeze(q)
            }};
        };
        $send((1), 'upto', [repeat], ($$44 = function(i){var self = $$44.$$s || this, $c, $d, $$45, $e, column = nil, extra_cols = nil, offset = nil, cell = nil;
          if (self.colcount == null) self.colcount = nil;
          if (self.table == null) self.table = nil;
          if (self.current_row == null) self.current_row = nil;
          if (self.reader == null) self.reader = nil;
          if (self.column_visits == null) self.column_visits = nil;
          if (self.linenum == null) self.linenum = nil;

        
          
          if (i == null) {
            i = nil;
          };
          if (self.colcount['$=='](-1)) {
            
            self.table.$columns()['$<<']((column = $$$($$($nesting, 'Table'), 'Column').$new(self.table, $rb_minus($rb_plus(self.table.$columns().$size(), i), 1))));
            if ($truthy(($truthy($c = ($truthy($d = cellspec) ? cellspec['$key?']("colspan") : $d)) ? $rb_gt((extra_cols = $rb_minus(cellspec['$[]']("colspan").$to_i(), 1)), 0) : $c))) {
              
              offset = self.table.$columns().$size();
              $send(extra_cols, 'times', [], ($$45 = function(j){var self = $$45.$$s || this;
                if (self.table == null) self.table = nil;

              
                
                if (j == null) {
                  j = nil;
                };
                return self.table.$columns()['$<<']($$$($$($nesting, 'Table'), 'Column').$new(self.table, $rb_plus(offset, j)));}, $$45.$$s = self, $$45.$$arity = 1, $$45));};
          } else if ($truthy((column = self.table.$columns()['$[]'](self.current_row.$size())))) {
          } else {
            
            self.$logger().$error(self.$message_with_context("dropping cell because it exceeds specified number of columns", $hash2(["source_location"], {"source_location": self.reader.$cursor_before_mark()})));
            Opal.ret(nil);
          };
          cell = $$$($$($nesting, 'Table'), 'Cell').$new(column, cell_text, cellspec, $hash2(["cursor"], {"cursor": self.reader.$cursor_before_mark()}));
          self.reader.$mark();
          if ($truthy(($truthy($c = cell.$rowspan()['$!']()) ? $c : cell.$rowspan()['$=='](1)))) {
          } else {
            self.$activate_rowspan(cell.$rowspan(), ($truthy($c = cell.$colspan()) ? $c : 1))
          };
          self.column_visits = $rb_plus(self.column_visits, ($truthy($c = cell.$colspan()) ? $c : 1));
          self.current_row['$<<'](cell);
          if ($truthy(($truthy($c = self['$end_of_row?']()) ? ($truthy($d = ($truthy($e = self.colcount['$!='](-1)) ? $e : $rb_gt(self.linenum, 0))) ? $d : ($truthy($e = eol) ? i['$=='](repeat) : $e)) : $c))) {
            return self.$close_row()
          } else {
            return nil
          };}, $$44.$$s = self, $$44.$$arity = 1, $$44));
        self.cell_open = false;
        return nil;
        } catch ($returner) { if ($returner === Opal.returner) { return $returner.$v } throw $returner; }
      }, $ParserContext_close_cell$43.$$arity = -1);
      self.$private();
      
      Opal.def(self, '$close_row', $ParserContext_close_row$46 = function $$close_row() {
        var $a, self = this, $writer = nil;

        
        self.table.$rows().$body()['$<<'](self.current_row);
        if (self.colcount['$=='](-1)) {
          self.colcount = self.column_visits};
        self.column_visits = 0;
        self.current_row = [];
        self.active_rowspans.$shift();
        ($truthy($a = self.active_rowspans['$[]'](0)) ? $a : (($writer = [0, 0]), $send(self.active_rowspans, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        return nil;
      }, $ParserContext_close_row$46.$$arity = 0);
      
      Opal.def(self, '$activate_rowspan', $ParserContext_activate_rowspan$47 = function $$activate_rowspan(rowspan, colspan) {
        var $$48, self = this;

        
        $send((1), 'upto', [$rb_minus(rowspan, 1)], ($$48 = function(i){var self = $$48.$$s || this, $a, $writer = nil;
          if (self.active_rowspans == null) self.active_rowspans = nil;

        
          
          if (i == null) {
            i = nil;
          };
          $writer = [i, $rb_plus(($truthy($a = self.active_rowspans['$[]'](i)) ? $a : 0), colspan)];
          $send(self.active_rowspans, '[]=', Opal.to_a($writer));
          return $writer[$rb_minus($writer["length"], 1)];}, $$48.$$s = self, $$48.$$arity = 1, $$48));
        return nil;
      }, $ParserContext_activate_rowspan$47.$$arity = 2);
      
      Opal.def(self, '$end_of_row?', $ParserContext_end_of_row$ques$49 = function() {
        var $a, self = this;

        return ($truthy($a = self.colcount['$=='](-1)) ? $a : self.$effective_column_visits()['$=='](self.colcount))
      }, $ParserContext_end_of_row$ques$49.$$arity = 0);
      
      Opal.def(self, '$effective_column_visits', $ParserContext_effective_column_visits$50 = function $$effective_column_visits() {
        var self = this;

        return $rb_plus(self.column_visits, self.active_rowspans['$[]'](0))
      }, $ParserContext_effective_column_visits$50.$$arity = 0);
      return (Opal.def(self, '$advance', $ParserContext_advance$51 = function $$advance() {
        var self = this;

        return (self.linenum = $rb_plus(self.linenum, 1))
      }, $ParserContext_advance$51.$$arity = 0), nil) && 'advance';
    })($$($nesting, 'Table'), null, $nesting);
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/writer"] = function(Opal) {
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $truthy = Opal.truthy, $hash2 = Opal.hash2;

  Opal.add_stubs(['$respond_to?', '$write', '$+', '$chomp', '$include']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    
    (function($base, $parent_nesting) {
      var self = $module($base, 'Writer');

      var $nesting = [self].concat($parent_nesting), $Writer_write$1;

      
      Opal.def(self, '$write', $Writer_write$1 = function $$write(output, target) {
        var self = this;

        
        if ($truthy(target['$respond_to?']("write"))) {
          target.$write($rb_plus(output.$chomp(), $$($nesting, 'LF')))
        } else {
          $$$('::', 'File').$write(target, output, $hash2(["mode"], {"mode": $$($nesting, 'FILE_WRITE_MODE')}))
        };
        return nil;
      }, $Writer_write$1.$$arity = 2)
    })($nesting[0], $nesting);
    (function($base, $parent_nesting) {
      var self = $module($base, 'VoidWriter');

      var $nesting = [self].concat($parent_nesting), $VoidWriter_write$2;

      
      self.$include($$($nesting, 'Writer'));
      
      Opal.def(self, '$write', $VoidWriter_write$2 = function $$write(output, target) {
        var self = this;

        return nil
      }, $VoidWriter_write$2.$$arity = 2);
    })($nesting[0], $nesting);
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/load"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $hash2 = Opal.hash2, $truthy = Opal.truthy, $send = Opal.send;

  Opal.add_stubs(['$merge', '$[]', '$start', '$key?', '$!=', '$logger', '$new', '$logger=', '$-', '$!', '$===', '$dup', '$tap', '$each', '$partition', '$[]=', '$split', '$gsub', '$+', '$respond_to?', '$keys', '$raise', '$join', '$ancestors', '$class', '$==', '$at', '$to_i', '$mtime', '$absolute_path', '$path', '$dirname', '$basename', '$extname', '$read', '$rewind', '$drop', '$record', '$parse', '$exception', '$message', '$set_backtrace', '$backtrace', '$stack_trace', '$stack_trace=', '$open', '$load']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function(self, $parent_nesting) {
      var $nesting = [self].concat($parent_nesting), $load$1, $load_file$8;

      
      
      Opal.def(self, '$load', $load$1 = function $$load(input, options) {
        var $a, $b, $c, $d, $$2, $$4, $$6, self = this, timings = nil, logger = nil, $writer = nil, attrs = nil, input_path = nil, source = nil, doc = nil, e = nil, context = nil, wrapped_e = nil;

        
        
        if (options == null) {
          options = $hash2([], {});
        };
        try {
          
          options = options.$merge();
          if ($truthy((timings = options['$[]']("timings")))) {
            timings.$start("read")};
          if ($truthy(($truthy($a = options['$key?']("logger")) ? (logger = options['$[]']("logger"))['$!=']($$($nesting, 'LoggerManager').$logger()) : $a))) {
            
            $writer = [($truthy($a = logger) ? $a : $$($nesting, 'NullLogger').$new())];
            $send($$($nesting, 'LoggerManager'), 'logger=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          if ($truthy((attrs = options['$[]']("attributes"))['$!']())) {
            attrs = $hash2([], {})
          } else if ($truthy($$$('::', 'Hash')['$==='](attrs))) {
            attrs = attrs.$merge()
          } else if ($truthy(($truthy($a = (($d = $$$('::', 'Java', 'skip_raise')) && ($c = $$$($d, 'JavaUtil', 'skip_raise')) && ($b = $$$($c, 'Map', 'skip_raise')) ? 'constant' : nil)) ? $$$($$$($$$('::', 'Java'), 'JavaUtil'), 'Map')['$==='](attrs) : $a))) {
            attrs = attrs.$dup()
          } else if ($truthy($$$('::', 'Array')['$==='](attrs))) {
            attrs = $send($hash2([], {}), 'tap', [], ($$2 = function(accum){var self = $$2.$$s || this, $$3;

            
              
              if (accum == null) {
                accum = nil;
              };
              return $send(attrs, 'each', [], ($$3 = function(entry){var self = $$3.$$s || this, $e, $f, k = nil, _ = nil, v = nil;

              
                
                if (entry == null) {
                  entry = nil;
                };
                $f = entry.$partition("="), $e = Opal.to_ary($f), (k = ($e[0] == null ? nil : $e[0])), (_ = ($e[1] == null ? nil : $e[1])), (v = ($e[2] == null ? nil : $e[2])), $f;
                
                $writer = [k, v];
                $send(accum, '[]=', Opal.to_a($writer));
                return $writer[$rb_minus($writer["length"], 1)];;}, $$3.$$s = self, $$3.$$arity = 1, $$3));}, $$2.$$s = self, $$2.$$arity = 1, $$2))
          } else if ($truthy($$$('::', 'String')['$==='](attrs))) {
            attrs = $send($hash2([], {}), 'tap', [], ($$4 = function(accum){var self = $$4.$$s || this, $$5;

            
              
              if (accum == null) {
                accum = nil;
              };
              return $send(attrs.$gsub($$($nesting, 'SpaceDelimiterRx'), $rb_plus("\\1", $$($nesting, 'NULL'))).$gsub($$($nesting, 'EscapedSpaceRx'), "\\1").$split($$($nesting, 'NULL')), 'each', [], ($$5 = function(entry){var self = $$5.$$s || this, $e, $f, k = nil, _ = nil, v = nil;

              
                
                if (entry == null) {
                  entry = nil;
                };
                $f = entry.$partition("="), $e = Opal.to_ary($f), (k = ($e[0] == null ? nil : $e[0])), (_ = ($e[1] == null ? nil : $e[1])), (v = ($e[2] == null ? nil : $e[2])), $f;
                
                $writer = [k, v];
                $send(accum, '[]=', Opal.to_a($writer));
                return $writer[$rb_minus($writer["length"], 1)];;}, $$5.$$s = self, $$5.$$arity = 1, $$5));}, $$4.$$s = self, $$4.$$arity = 1, $$4))
          } else if ($truthy(($truthy($a = attrs['$respond_to?']("keys")) ? attrs['$respond_to?']("[]") : $a))) {
            attrs = $send($hash2([], {}), 'tap', [], ($$6 = function(accum){var self = $$6.$$s || this, $$7;

            
              
              if (accum == null) {
                accum = nil;
              };
              return $send(attrs.$keys(), 'each', [], ($$7 = function(k){var self = $$7.$$s || this;

              
                
                if (k == null) {
                  k = nil;
                };
                $writer = [k, attrs['$[]'](k)];
                $send(accum, '[]=', Opal.to_a($writer));
                return $writer[$rb_minus($writer["length"], 1)];}, $$7.$$s = self, $$7.$$arity = 1, $$7));}, $$6.$$s = self, $$6.$$arity = 1, $$6))
          } else {
            self.$raise($$$('::', 'ArgumentError'), "" + "illegal type for attributes option: " + (attrs.$class().$ancestors().$join(" < ")))
          };
          if ($truthy($$$('::', 'File')['$==='](input))) {
            
            
            $writer = ["input_mtime", (function() {if ($$($nesting, 'RUBY_ENGINE')['$==']("jruby")) {
              
              return $$$('::', 'Time').$at(input.$mtime().$to_i());
            } else {
              return input.$mtime()
            }; return nil; })()];
            $send(options, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            
            $writer = ["docfile", (input_path = $$$('::', 'File').$absolute_path(input.$path()))];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            
            $writer = ["docdir", $$$('::', 'File').$dirname(input_path)];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            
            $writer = ["docname", $$($nesting, 'Helpers').$basename(input_path, (($writer = ["docfilesuffix", $$($nesting, 'Helpers').$extname(input_path)]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            source = input.$read();
          } else if ($truthy(input['$respond_to?']("read"))) {
            
            try {
              input.$rewind()
            } catch ($err) {
              if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
                try {
                  nil
                } finally { Opal.pop_exception() }
              } else { throw $err; }
            };
            source = input.$read();
          } else if ($truthy($$$('::', 'String')['$==='](input))) {
            source = input
          } else if ($truthy($$$('::', 'Array')['$==='](input))) {
            source = input.$drop(0)
          } else if ($truthy(input)) {
            self.$raise($$$('::', 'ArgumentError'), "" + "unsupported input type: " + (input.$class()))};
          if ($truthy(timings)) {
            
            timings.$record("read");
            timings.$start("parse");};
          
          $writer = ["attributes", attrs];
          $send(options, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          doc = (function() {if (options['$[]']("parse")['$=='](false)) {
            
            return $$($nesting, 'Document').$new(source, options);
          } else {
            return $$($nesting, 'Document').$new(source, options).$parse()
          }; return nil; })();
          if ($truthy(timings)) {
            timings.$record("parse")};
          return doc;
        } catch ($err) {
          if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {e = $err;
            try {
              
              
              try {
                
                context = "" + "asciidoctor: FAILED: " + (($truthy($a = attrs['$[]']("docfile")) ? $a : "<stdin>")) + ": Failed to load AsciiDoc document";
                if ($truthy(e['$respond_to?']("exception"))) {
                  
                  wrapped_e = e.$exception("" + (context) + " - " + (e.$message()));
                  wrapped_e.$set_backtrace(e.$backtrace());
                } else {
                  
                  wrapped_e = e.$class().$new(context, e);
                  
                  $writer = [e.$stack_trace()];
                  $send(wrapped_e, 'stack_trace=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];;
                };
              } catch ($err) {
                if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
                  try {
                    wrapped_e = e
                  } finally { Opal.pop_exception() }
                } else { throw $err; }
              };;
              return self.$raise(wrapped_e);
            } finally { Opal.pop_exception() }
          } else { throw $err; }
        };
      }, $load$1.$$arity = -2);
      return (Opal.def(self, '$load_file', $load_file$8 = function $$load_file(filename, options) {
        var $$9, self = this;

        
        
        if (options == null) {
          options = $hash2([], {});
        };
        return $send($$$('::', 'File'), 'open', [filename, $$($nesting, 'FILE_READ_MODE')], ($$9 = function(file){var self = $$9.$$s || this;

        
          
          if (file == null) {
            file = nil;
          };
          return self.$load(file, options);}, $$9.$$s = self, $$9.$$arity = 1, $$9));
      }, $load_file$8.$$arity = -2), nil) && 'load_file';
    })(Opal.get_singleton_class(self), $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/convert"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_ge(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs >= rhs : lhs['$>='](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $hash2 = Opal.hash2, $truthy = Opal.truthy, $send = Opal.send;

  Opal.add_stubs(['$delete', '$merge', '$===', '$absolute_path', '$path', '$load', '$respond_to?', '$[]=', '$-', '$key?', '$fetch', '$[]', '$dirname', '$expand_path', '$join', '$attributes', '$outfilesuffix', '$==', '$raise', '$pwd', '$>=', '$safe', '$normalize_system_path', '$mkdir_p', '$directory?', '$!', '$convert', '$write', '$<', '$attr?', '$basebackend?', '$attr', '$uriish?', '$include?', '$syntax_highlighter', '$write_stylesheet?', '$write_primary_stylesheet', '$instance', '$to_s', '$!=', '$read_asset', '$file?', '$write_stylesheet', '$open']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function(self, $parent_nesting) {
      var $nesting = [self].concat($parent_nesting), $convert$1, $convert_file$2;

      
      
      Opal.def(self, '$convert', $convert$1 = function $$convert(input, options) {
        var $a, $b, $c, $d, $e, self = this, to_dir = nil, mkdirs = nil, $case = nil, to_file = nil, write_to_target = nil, sibling_path = nil, stream_output = nil, $writer = nil, outdir = nil, doc = nil, outfile = nil, working_dir = nil, jail = nil, output = nil, stylesdir = nil, stylesheet = nil, copy_asciidoctor_stylesheet = nil, copy_user_stylesheet = nil, copy_syntax_hl_stylesheet = nil, syntax_hl = nil, stylesoutdir = nil, stylesheet_src = nil, stylesheet_dest = nil, stylesheet_data = nil, stylesheet_outdir = nil;

        
        
        if (options == null) {
          options = $hash2([], {});
        };
        (options = options.$merge()).$delete("parse");
        to_dir = options.$delete("to_dir");
        mkdirs = options.$delete("mkdirs");
        $case = (to_file = options.$delete("to_file"));
        if (true['$===']($case) || nil['$===']($case)) {
        if ($truthy((write_to_target = to_dir))) {
        } else if ($truthy($$$('::', 'File')['$==='](input))) {
          sibling_path = $$$('::', 'File').$absolute_path(input.$path())};
        to_file = nil;}
        else if (false['$===']($case)) {to_file = nil}
        else if ("/dev/null"['$===']($case)) {return self.$load(input, options)}
        else {if ($truthy((stream_output = to_file['$respond_to?']("write")))) {
        } else {
          
          $writer = ["to_file", (write_to_target = to_file)];
          $send(options, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];
        }};
        if ($truthy(options['$key?']("standalone"))) {
        } else if ($truthy(($truthy($a = sibling_path) ? $a : write_to_target))) {
          
          $writer = ["standalone", options.$fetch("header_footer", true)];
          $send(options, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];
        } else if ($truthy(options['$key?']("header_footer"))) {
          
          $writer = ["standalone", options['$[]']("header_footer")];
          $send(options, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        if ($truthy(sibling_path)) {
          
          $writer = ["to_dir", (outdir = $$$('::', 'File').$dirname(sibling_path))];
          $send(options, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];
        } else if ($truthy(write_to_target)) {
          if ($truthy(to_dir)) {
            if ($truthy(to_file)) {
              
              $writer = ["to_dir", $$$('::', 'File').$dirname($$$('::', 'File').$expand_path(to_file, to_dir))];
              $send(options, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            } else {
              
              $writer = ["to_dir", $$$('::', 'File').$expand_path(to_dir)];
              $send(options, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            }
          } else if ($truthy(to_file)) {
            
            $writer = ["to_dir", $$$('::', 'File').$dirname($$$('::', 'File').$expand_path(to_file))];
            $send(options, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];}};
        doc = self.$load(input, options);
        if ($truthy(sibling_path)) {
          
          outfile = $$$('::', 'File').$join(outdir, "" + (doc.$attributes()['$[]']("docname")) + (doc.$outfilesuffix()));
          if (outfile['$=='](sibling_path)) {
            self.$raise($$$('::', 'IOError'), "" + "input file and output file cannot be the same: " + (outfile))};
        } else if ($truthy(write_to_target)) {
          
          working_dir = (function() {if ($truthy(options['$key?']("base_dir"))) {
            
            return $$$('::', 'File').$expand_path(options['$[]']("base_dir"));
          } else {
            return $$$('::', 'Dir').$pwd()
          }; return nil; })();
          jail = (function() {if ($truthy($rb_ge(doc.$safe(), $$$($$($nesting, 'SafeMode'), 'SAFE')))) {
            return working_dir
          } else {
            return nil
          }; return nil; })();
          if ($truthy(to_dir)) {
            
            outdir = doc.$normalize_system_path(to_dir, working_dir, jail, $hash2(["target_name", "recover"], {"target_name": "to_dir", "recover": false}));
            if ($truthy(to_file)) {
              
              outfile = doc.$normalize_system_path(to_file, outdir, nil, $hash2(["target_name", "recover"], {"target_name": "to_dir", "recover": false}));
              outdir = $$$('::', 'File').$dirname(outfile);
            } else {
              outfile = $$$('::', 'File').$join(outdir, "" + (doc.$attributes()['$[]']("docname")) + (doc.$outfilesuffix()))
            };
          } else if ($truthy(to_file)) {
            
            outfile = doc.$normalize_system_path(to_file, working_dir, jail, $hash2(["target_name", "recover"], {"target_name": "to_dir", "recover": false}));
            outdir = $$$('::', 'File').$dirname(outfile);};
          if ($truthy(($truthy($a = $$$('::', 'File')['$==='](input)) ? outfile['$==']($$$('::', 'File').$absolute_path(input.$path())) : $a))) {
            self.$raise($$$('::', 'IOError'), "" + "input file and output file cannot be the same: " + (outfile))};
          if ($truthy(mkdirs)) {
            $$($nesting, 'Helpers').$mkdir_p(outdir)
          } else if ($truthy($$$('::', 'File')['$directory?'](outdir))) {
          } else {
            self.$raise($$$('::', 'IOError'), "" + "target directory does not exist: " + (to_dir) + " (hint: set :mkdirs option)")
          };
        } else {
          
          outfile = to_file;
          outdir = nil;
        };
        if ($truthy(($truthy($a = outfile) ? stream_output['$!']() : $a))) {
          output = doc.$convert($hash2(["outfile", "outdir"], {"outfile": outfile, "outdir": outdir}))
        } else {
          output = doc.$convert()
        };
        if ($truthy(outfile)) {
          
          doc.$write(output, outfile);
          if ($truthy(($truthy($a = ($truthy($b = ($truthy($c = ($truthy($d = ($truthy($e = stream_output['$!']()) ? $rb_lt(doc.$safe(), $$$($$($nesting, 'SafeMode'), 'SECURE')) : $e)) ? doc['$attr?']("linkcss") : $d)) ? doc['$attr?']("copycss") : $c)) ? doc['$basebackend?']("html") : $b)) ? ($truthy($b = (stylesdir = doc.$attr("stylesdir"))) ? $$($nesting, 'Helpers')['$uriish?'](stylesdir) : $b)['$!']() : $a))) {
            
            if ($truthy((stylesheet = doc.$attr("stylesheet")))) {
              if ($truthy($$($nesting, 'DEFAULT_STYLESHEET_KEYS')['$include?'](stylesheet))) {
                copy_asciidoctor_stylesheet = true
              } else if ($truthy($$($nesting, 'Helpers')['$uriish?'](stylesheet)['$!']())) {
                copy_user_stylesheet = true}};
            copy_syntax_hl_stylesheet = ($truthy($a = (syntax_hl = doc.$syntax_highlighter())) ? syntax_hl['$write_stylesheet?'](doc) : $a);
            if ($truthy(($truthy($a = ($truthy($b = copy_asciidoctor_stylesheet) ? $b : copy_user_stylesheet)) ? $a : copy_syntax_hl_stylesheet))) {
              
              stylesoutdir = doc.$normalize_system_path(stylesdir, outdir, (function() {if ($truthy($rb_ge(doc.$safe(), $$$($$($nesting, 'SafeMode'), 'SAFE')))) {
                return outdir
              } else {
                return nil
              }; return nil; })());
              if ($truthy(mkdirs)) {
                $$($nesting, 'Helpers').$mkdir_p(stylesoutdir)
              } else if ($truthy($$$('::', 'File')['$directory?'](stylesoutdir))) {
              } else {
                self.$raise($$$('::', 'IOError'), "" + "target stylesheet directory does not exist: " + (stylesoutdir) + " (hint: set :mkdirs option)")
              };
              if ($truthy(copy_asciidoctor_stylesheet)) {
                $$($nesting, 'Stylesheets').$instance().$write_primary_stylesheet(stylesoutdir)
              } else if ($truthy(copy_user_stylesheet)) {
                
                if ($truthy(($truthy($a = (stylesheet_src = doc.$attr("copycss"))['$==']("")) ? $a : stylesheet_src['$=='](true)))) {
                  stylesheet_src = doc.$normalize_system_path(stylesheet)
                } else {
                  stylesheet_src = doc.$normalize_system_path(stylesheet_src.$to_s())
                };
                stylesheet_dest = doc.$normalize_system_path(stylesheet, stylesoutdir, (function() {if ($truthy($rb_ge(doc.$safe(), $$$($$($nesting, 'SafeMode'), 'SAFE')))) {
                  return outdir
                } else {
                  return nil
                }; return nil; })());
                if ($truthy(($truthy($a = stylesheet_src['$!='](stylesheet_dest)) ? (stylesheet_data = doc.$read_asset(stylesheet_src, $hash2(["warn_on_failure", "label"], {"warn_on_failure": $$$('::', 'File')['$file?'](stylesheet_dest)['$!'](), "label": "stylesheet"}))) : $a))) {
                  
                  if ($truthy(($truthy($a = (stylesheet_outdir = $$$('::', 'File').$dirname(stylesheet_dest))['$!='](stylesoutdir)) ? $$$('::', 'File')['$directory?'](stylesheet_outdir)['$!']() : $a))) {
                    if ($truthy(mkdirs)) {
                      $$($nesting, 'Helpers').$mkdir_p(stylesheet_outdir)
                    } else {
                      self.$raise($$$('::', 'IOError'), "" + "target stylesheet directory does not exist: " + (stylesheet_outdir) + " (hint: set :mkdirs option)")
                    }};
                  $$$('::', 'File').$write(stylesheet_dest, stylesheet_data, $hash2(["mode"], {"mode": $$($nesting, 'FILE_WRITE_MODE')}));};};
              if ($truthy(copy_syntax_hl_stylesheet)) {
                syntax_hl.$write_stylesheet(doc, stylesoutdir)};};};
          return doc;
        } else {
          return output
        };
      }, $convert$1.$$arity = -2);
      
      Opal.def(self, '$convert_file', $convert_file$2 = function $$convert_file(filename, options) {
        var $$3, self = this;

        
        
        if (options == null) {
          options = $hash2([], {});
        };
        return $send($$$('::', 'File'), 'open', [filename, $$($nesting, 'FILE_READ_MODE')], ($$3 = function(file){var self = $$3.$$s || this;

        
          
          if (file == null) {
            file = nil;
          };
          return self.$convert(file, options);}, $$3.$$s = self, $$3.$$arity = 1, $$3));
      }, $convert_file$2.$$arity = -2);
      Opal.alias(self, "render", "convert");
      return Opal.alias(self, "render_file", "convert_file");
    })(Opal.get_singleton_class(self), $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/syntax_highlighter/highlightjs"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $send = Opal.send, $hash2 = Opal.hash2, $truthy = Opal.truthy;

  Opal.add_stubs(['$register_for', '$merge', '$proc', '$[]=', '$-', '$attr', '$[]', '$==', '$attr?', '$join', '$map', '$split', '$lstrip']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'HighlightJsAdapter');

      var $nesting = [self].concat($parent_nesting), $HighlightJsAdapter_initialize$1, $HighlightJsAdapter_format$2, $HighlightJsAdapter_docinfo$ques$4, $HighlightJsAdapter_docinfo$5;

      
      self.$register_for("highlightjs", "highlight.js");
      
      Opal.def(self, '$initialize', $HighlightJsAdapter_initialize$1 = function $$initialize($a) {
        var $post_args, args, $iter = $HighlightJsAdapter_initialize$1.$$p, $yield = $iter || nil, self = this, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) $HighlightJsAdapter_initialize$1.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        
        
        $post_args = Opal.slice.call(arguments, 0, arguments.length);
        
        args = $post_args;;
        $send(self, Opal.find_super_dispatcher(self, 'initialize', $HighlightJsAdapter_initialize$1, false), $zuper, $iter);
        return (self.name = (self.pre_class = "highlightjs"));
      }, $HighlightJsAdapter_initialize$1.$$arity = -1);
      
      Opal.def(self, '$format', $HighlightJsAdapter_format$2 = function $$format(node, lang, opts) {
        var $$3, $iter = $HighlightJsAdapter_format$2.$$p, $yield = $iter || nil, self = this;

        if ($iter) $HighlightJsAdapter_format$2.$$p = null;
        return $send(self, Opal.find_super_dispatcher(self, 'format', $HighlightJsAdapter_format$2, false), [node, lang, opts.$merge($hash2(["transform"], {"transform": $send(self, 'proc', [], ($$3 = function(_, code){var self = $$3.$$s || this, $a, $writer = nil;

        
          
          if (_ == null) {
            _ = nil;
          };
          
          if (code == null) {
            code = nil;
          };
          $writer = ["class", "" + "language-" + (($truthy($a = lang) ? $a : "none")) + " hljs"];
          $send(code, '[]=', Opal.to_a($writer));
          return $writer[$rb_minus($writer["length"], 1)];}, $$3.$$s = self, $$3.$$arity = 2, $$3))}))], null)
      }, $HighlightJsAdapter_format$2.$$arity = 3);
      
      Opal.def(self, '$docinfo?', $HighlightJsAdapter_docinfo$ques$4 = function(location) {
        var self = this;

        return true
      }, $HighlightJsAdapter_docinfo$ques$4.$$arity = 1);
      return (Opal.def(self, '$docinfo', $HighlightJsAdapter_docinfo$5 = function $$docinfo(location, doc, opts) {
        var $$6, self = this, base_url = nil;

        
        base_url = doc.$attr("highlightjsdir", "" + (opts['$[]']("cdn_base_url")) + "/highlight.js/" + ($$($nesting, 'HIGHLIGHT_JS_VERSION')));
        if (location['$==']("head")) {
          return "" + "<link rel=\"stylesheet\" href=\"" + (base_url) + "/styles/" + (doc.$attr("highlightjs-theme", "github")) + ".min.css\"" + (opts['$[]']("self_closing_tag_slash")) + ">"
        } else {
          return "" + "<script src=\"" + (base_url) + "/highlight.min.js\"></script>\n" + ((function() {if ($truthy(doc['$attr?']("highlightjs-languages"))) {
            return $send(doc.$attr("highlightjs-languages").$split(","), 'map', [], ($$6 = function(lang){var self = $$6.$$s || this;

            
              
              if (lang == null) {
                lang = nil;
              };
              return "" + "<script src=\"" + (base_url) + "/languages/" + (lang.$lstrip()) + ".min.js\"></script>\n";}, $$6.$$s = self, $$6.$$arity = 1, $$6)).$join()
          } else {
            return ""
          }; return nil; })()) + "<script>\n" + "if (!hljs.initHighlighting.called) {\n" + "  hljs.initHighlighting.called = true\n" + "  ;[].slice.call(document.querySelectorAll('pre.highlight > code')).forEach(function (el) { hljs.highlightBlock(el) })\n" + "}\n" + "</script>"
        };
      }, $HighlightJsAdapter_docinfo$5.$$arity = 3), nil) && 'docinfo';
    })($$($nesting, 'SyntaxHighlighter'), $$$($$($nesting, 'SyntaxHighlighter'), 'Base'), $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/syntax_highlighter"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $hash2 = Opal.hash2, $send = Opal.send, $truthy = Opal.truthy, $klass = Opal.klass;

  Opal.add_stubs(['$attr_reader', '$raise', '$class', '$extend', '$private_class_method', '$register', '$map', '$to_s', '$each', '$[]=', '$registry', '$-', '$[]', '$for', '$===', '$new', '$name', '$private', '$include', '$==', '$delete', '$join', '$content']);
  
  (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function($base, $parent_nesting) {
      var self = $module($base, 'SyntaxHighlighter');

      var $nesting = [self].concat($parent_nesting), $SyntaxHighlighter_initialize$1, $SyntaxHighlighter_docinfo$ques$2, $SyntaxHighlighter_docinfo$3, $SyntaxHighlighter_highlight$ques$4, $SyntaxHighlighter_highlight$5, $SyntaxHighlighter_format$6, $SyntaxHighlighter_write_stylesheet$ques$7, $SyntaxHighlighter_write_stylesheet$8, $SyntaxHighlighter_included$9;

      
      self.$attr_reader("name");
      
      Opal.def(self, '$initialize', $SyntaxHighlighter_initialize$1 = function $$initialize(name, backend, opts) {
        var self = this;

        
        
        if (backend == null) {
          backend = "html5";
        };
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        return (self.name = (self.pre_class = name));
      }, $SyntaxHighlighter_initialize$1.$$arity = -2);
      
      Opal.def(self, '$docinfo?', $SyntaxHighlighter_docinfo$ques$2 = function(location) {
        var self = this;

        return nil
      }, $SyntaxHighlighter_docinfo$ques$2.$$arity = 1);
      
      Opal.def(self, '$docinfo', $SyntaxHighlighter_docinfo$3 = function $$docinfo(location, doc, opts) {
        var self = this;

        return self.$raise($$$('::', 'NotImplementedError'), "" + ($$($nesting, 'SyntaxHighlighter')) + " subclass " + (self.$class()) + " must implement the #" + ("docinfo") + " method since #docinfo? returns true")
      }, $SyntaxHighlighter_docinfo$3.$$arity = 3);
      
      Opal.def(self, '$highlight?', $SyntaxHighlighter_highlight$ques$4 = function() {
        var self = this;

        return nil
      }, $SyntaxHighlighter_highlight$ques$4.$$arity = 0);
      
      Opal.def(self, '$highlight', $SyntaxHighlighter_highlight$5 = function $$highlight(node, source, lang, opts) {
        var self = this;

        return self.$raise($$$('::', 'NotImplementedError'), "" + ($$($nesting, 'SyntaxHighlighter')) + " subclass " + (self.$class()) + " must implement the #" + ("highlight") + " method since #highlight? returns true")
      }, $SyntaxHighlighter_highlight$5.$$arity = 4);
      
      Opal.def(self, '$format', $SyntaxHighlighter_format$6 = function $$format(node, lang, opts) {
        var self = this;

        return self.$raise($$$('::', 'NotImplementedError'), "" + ($$($nesting, 'SyntaxHighlighter')) + " subclass " + (self.$class()) + " must implement the #" + ("format") + " method")
      }, $SyntaxHighlighter_format$6.$$arity = 3);
      
      Opal.def(self, '$write_stylesheet?', $SyntaxHighlighter_write_stylesheet$ques$7 = function(doc) {
        var self = this;

        return nil
      }, $SyntaxHighlighter_write_stylesheet$ques$7.$$arity = 1);
      
      Opal.def(self, '$write_stylesheet', $SyntaxHighlighter_write_stylesheet$8 = function $$write_stylesheet(doc, to_dir) {
        var self = this;

        return self.$raise($$$('::', 'NotImplementedError'), "" + ($$($nesting, 'SyntaxHighlighter')) + " subclass " + (self.$class()) + " must implement the #" + ("write_stylesheet") + " method since #write_stylesheet? returns true")
      }, $SyntaxHighlighter_write_stylesheet$8.$$arity = 2);
      Opal.defs(self, '$included', $SyntaxHighlighter_included$9 = function $$included(into) {
        var self = this;

        return into.$extend($$($nesting, 'Config'))
      }, $SyntaxHighlighter_included$9.$$arity = 1);
      self.$private_class_method("included");
      (function($base, $parent_nesting) {
        var self = $module($base, 'Config');

        var $nesting = [self].concat($parent_nesting), $Config_register_for$10;

        
        Opal.def(self, '$register_for', $Config_register_for$10 = function $$register_for($a) {
          var $post_args, names, $$11, self = this;

          
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          names = $post_args;;
          return $send($$($nesting, 'SyntaxHighlighter'), 'register', [self].concat(Opal.to_a($send(names, 'map', [], ($$11 = function(name){var self = $$11.$$s || this;

          
            
            if (name == null) {
              name = nil;
            };
            return name.$to_s();}, $$11.$$s = self, $$11.$$arity = 1, $$11)))));
        }, $Config_register_for$10.$$arity = -1)
      })($nesting[0], $nesting);
      (function($base, $parent_nesting) {
        var self = $module($base, 'Factory');

        var $nesting = [self].concat($parent_nesting), $Factory_register$12, $Factory_for$14, $Factory_create$15, $Factory_registry$16;

        
        
        Opal.def(self, '$register', $Factory_register$12 = function $$register(syntax_highlighter, $a) {
          var $post_args, names, $$13, self = this;

          
          
          $post_args = Opal.slice.call(arguments, 1, arguments.length);
          
          names = $post_args;;
          return $send(names, 'each', [], ($$13 = function(name){var self = $$13.$$s || this, $writer = nil;

          
            
            if (name == null) {
              name = nil;
            };
            $writer = [name, syntax_highlighter];
            $send(self.$registry(), '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];}, $$13.$$s = self, $$13.$$arity = 1, $$13));
        }, $Factory_register$12.$$arity = -2);
        
        Opal.def(self, '$for', $Factory_for$14 = function(name) {
          var self = this;

          return self.$registry()['$[]'](name)
        }, $Factory_for$14.$$arity = 1);
        
        Opal.def(self, '$create', $Factory_create$15 = function $$create(name, backend, opts) {
          var self = this, syntax_hl = nil;

          
          
          if (backend == null) {
            backend = "html5";
          };
          
          if (opts == null) {
            opts = $hash2([], {});
          };
          if ($truthy((syntax_hl = self.$for(name)))) {
            
            if ($truthy($$$('::', 'Class')['$==='](syntax_hl))) {
              syntax_hl = syntax_hl.$new(name, backend, opts)};
            if ($truthy(syntax_hl.$name())) {
            } else {
              self.$raise($$$('::', 'NameError'), "" + (syntax_hl.$class()) + " must specify a value for `name'")
            };
            return syntax_hl;
          } else {
            return nil
          };
        }, $Factory_create$15.$$arity = -2);
        self.$private();
        
        Opal.def(self, '$registry', $Factory_registry$16 = function $$registry() {
          var self = this;

          return self.$raise($$$('::', 'NotImplementedError'), "" + ($$($nesting, 'Factory')) + " subclass " + (self.$class()) + " must implement the #" + ("registry") + " method")
        }, $Factory_registry$16.$$arity = 0);
      })($nesting[0], $nesting);
      (function($base, $super, $parent_nesting) {
        var self = $klass($base, $super, 'CustomFactory');

        var $nesting = [self].concat($parent_nesting), $CustomFactory_initialize$17;

        
        self.$include($$($nesting, 'Factory'));
        
        Opal.def(self, '$initialize', $CustomFactory_initialize$17 = function $$initialize(seed_registry) {
          var $a, self = this;

          
          
          if (seed_registry == null) {
            seed_registry = nil;
          };
          return (self.registry = ($truthy($a = seed_registry) ? $a : $hash2([], {})));
        }, $CustomFactory_initialize$17.$$arity = -1);
        self.$private();
        return self.$attr_reader("registry");
      })($nesting[0], null, $nesting);
      (function($base, $parent_nesting) {
        var self = $module($base, 'DefaultFactory');

        var $nesting = [self].concat($parent_nesting), $DefaultFactory_registry$18;

        
        self.$include($$($nesting, 'Factory'));
        (Opal.class_variable_set($nesting[0], '@@registry', $hash2([], {})));
        self.$private();
        
        Opal.def(self, '$registry', $DefaultFactory_registry$18 = function $$registry() {
          var $a, self = this;

          return (($a = $nesting[0].$$cvars['@@registry']) == null ? nil : $a)
        }, $DefaultFactory_registry$18.$$arity = 0);
        if ($$($nesting, 'RUBY_ENGINE')['$==']("opal")) {
        } else {
          nil
        };
      })($nesting[0], $nesting);
      (function($base, $super, $parent_nesting) {
        var self = $klass($base, $super, 'DefaultFactoryProxy');

        var $nesting = [self].concat($parent_nesting);

        
        self.$include($$($nesting, 'DefaultFactory'));
        if ($$($nesting, 'RUBY_ENGINE')['$==']("opal")) {
          return nil
        } else {
          return nil
        };
      })($nesting[0], $$($nesting, 'CustomFactory'), $nesting);
      (function($base, $super, $parent_nesting) {
        var self = $klass($base, $super, 'Base');

        var $nesting = [self].concat($parent_nesting), $Base_format$19;

        self.$$prototype.pre_class = nil;
        
        self.$include($$($nesting, 'SyntaxHighlighter'));
        return (Opal.def(self, '$format', $Base_format$19 = function $$format(node, lang, opts) {
          var $$20, $$21, self = this, class_attr_val = nil, transform = nil, pre = nil, code = nil, $writer = nil;

          
          class_attr_val = (function() {if ($truthy(opts['$[]']("nowrap"))) {
            return "" + (self.pre_class) + " highlight nowrap"
          } else {
            return "" + (self.pre_class) + " highlight"
          }; return nil; })();
          if ($truthy((transform = opts['$[]']("transform")))) {
            
            transform['$[]']((pre = $hash2(["class"], {"class": class_attr_val})), (code = (function() {if ($truthy(lang)) {
              return $hash2(["data-lang"], {"data-lang": lang})
            } else {
              return $hash2([], {})
            }; return nil; })()));
            if ($truthy((lang = code.$delete("data-lang")))) {
              
              $writer = ["data-lang", lang];
              $send(code, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
            return "" + "<pre" + ($send(pre, 'map', [], ($$20 = function(k, v){var self = $$20.$$s || this;

            
              
              if (k == null) {
                k = nil;
              };
              
              if (v == null) {
                v = nil;
              };
              return "" + " " + (k) + "=\"" + (v) + "\"";}, $$20.$$s = self, $$20.$$arity = 2, $$20)).$join()) + "><code" + ($send(code, 'map', [], ($$21 = function(k, v){var self = $$21.$$s || this;

            
              
              if (k == null) {
                k = nil;
              };
              
              if (v == null) {
                v = nil;
              };
              return "" + " " + (k) + "=\"" + (v) + "\"";}, $$21.$$s = self, $$21.$$arity = 2, $$21)).$join()) + ">" + (node.$content()) + "</code></pre>";
          } else {
            return "" + "<pre class=\"" + (class_attr_val) + "\"><code" + ((function() {if ($truthy(lang)) {
              return "" + " data-lang=\"" + (lang) + "\""
            } else {
              return ""
            }; return nil; })()) + ">" + (node.$content()) + "</code></pre>"
          };
        }, $Base_format$19.$$arity = 3), nil) && 'format';
      })($nesting[0], null, $nesting);
      self.$extend($$($nesting, 'DefaultFactory'));
    })($nesting[0], $nesting)
  })($nesting[0], $nesting);
  self.$require("asciidoctor/syntax_highlighter.rb"+ '/../' + "syntax_highlighter/highlightjs");
  if ($$($nesting, 'RUBY_ENGINE')['$==']("opal")) {
    return nil
  } else {
    return nil
  };
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/timings"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $hash2 = Opal.hash2, $send = Opal.send, $truthy = Opal.truthy, $gvars = Opal.gvars;

  Opal.add_stubs(['$now', '$[]=', '$-', '$delete', '$reduce', '$+', '$[]', '$>', '$time', '$puts', '$sprintf', '$to_f', '$read_parse', '$convert', '$read_parse_convert', '$private', '$const_defined?', '$==', '$clock_gettime']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'Timings');

      var $nesting = [self].concat($parent_nesting), $Timings_initialize$1, $Timings_start$2, $Timings_record$3, $Timings_time$4, $Timings_read$6, $Timings_parse$7, $Timings_read_parse$8, $Timings_convert$9, $Timings_read_parse_convert$10, $Timings_write$11, $Timings_total$12, $Timings_print_report$13, $a, $b, $c, $d, $e, $Timings_now$14, $Timings_now$15;

      self.$$prototype.timers = self.$$prototype.log = nil;
      
      
      Opal.def(self, '$initialize', $Timings_initialize$1 = function $$initialize() {
        var self = this;

        
        self.log = $hash2([], {});
        return (self.timers = $hash2([], {}));
      }, $Timings_initialize$1.$$arity = 0);
      
      Opal.def(self, '$start', $Timings_start$2 = function $$start(key) {
        var self = this, $writer = nil;

        
        $writer = [key, self.$now()];
        $send(self.timers, '[]=', Opal.to_a($writer));
        return $writer[$rb_minus($writer["length"], 1)];
      }, $Timings_start$2.$$arity = 1);
      
      Opal.def(self, '$record', $Timings_record$3 = function $$record(key) {
        var self = this, $writer = nil;

        
        $writer = [key, $rb_minus(self.$now(), self.timers.$delete(key))];
        $send(self.log, '[]=', Opal.to_a($writer));
        return $writer[$rb_minus($writer["length"], 1)];
      }, $Timings_record$3.$$arity = 1);
      
      Opal.def(self, '$time', $Timings_time$4 = function $$time($a) {
        var $post_args, keys, $$5, self = this, time = nil;

        
        
        $post_args = Opal.slice.call(arguments, 0, arguments.length);
        
        keys = $post_args;;
        time = $send(keys, 'reduce', [0], ($$5 = function(sum, key){var self = $$5.$$s || this, $b;
          if (self.log == null) self.log = nil;

        
          
          if (sum == null) {
            sum = nil;
          };
          
          if (key == null) {
            key = nil;
          };
          return $rb_plus(sum, ($truthy($b = self.log['$[]'](key)) ? $b : 0));}, $$5.$$s = self, $$5.$$arity = 2, $$5));
        if ($truthy($rb_gt(time, 0))) {
          return time
        } else {
          return nil
        };
      }, $Timings_time$4.$$arity = -1);
      
      Opal.def(self, '$read', $Timings_read$6 = function $$read() {
        var self = this;

        return self.$time("read")
      }, $Timings_read$6.$$arity = 0);
      
      Opal.def(self, '$parse', $Timings_parse$7 = function $$parse() {
        var self = this;

        return self.$time("parse")
      }, $Timings_parse$7.$$arity = 0);
      
      Opal.def(self, '$read_parse', $Timings_read_parse$8 = function $$read_parse() {
        var self = this;

        return self.$time("read", "parse")
      }, $Timings_read_parse$8.$$arity = 0);
      
      Opal.def(self, '$convert', $Timings_convert$9 = function $$convert() {
        var self = this;

        return self.$time("convert")
      }, $Timings_convert$9.$$arity = 0);
      
      Opal.def(self, '$read_parse_convert', $Timings_read_parse_convert$10 = function $$read_parse_convert() {
        var self = this;

        return self.$time("read", "parse", "convert")
      }, $Timings_read_parse_convert$10.$$arity = 0);
      
      Opal.def(self, '$write', $Timings_write$11 = function $$write() {
        var self = this;

        return self.$time("write")
      }, $Timings_write$11.$$arity = 0);
      
      Opal.def(self, '$total', $Timings_total$12 = function $$total() {
        var self = this;

        return self.$time("read", "parse", "convert", "write")
      }, $Timings_total$12.$$arity = 0);
      
      Opal.def(self, '$print_report', $Timings_print_report$13 = function $$print_report(to, subject) {
        var self = this;
        if ($gvars.stdout == null) $gvars.stdout = nil;

        
        
        if (to == null) {
          to = $gvars.stdout;
        };
        
        if (subject == null) {
          subject = nil;
        };
        if ($truthy(subject)) {
          to.$puts("" + "Input file: " + (subject))};
        to.$puts("" + "  Time to read and parse source: " + (self.$sprintf("%05.5f", self.$read_parse().$to_f())));
        to.$puts("" + "  Time to convert document: " + (self.$sprintf("%05.5f", self.$convert().$to_f())));
        return to.$puts("" + "  Total time (read, parse and convert): " + (self.$sprintf("%05.5f", self.$read_parse_convert().$to_f())));
      }, $Timings_print_report$13.$$arity = -1);
      self.$private();
      if ($truthy(($truthy($a = $$$('::', 'Process')['$const_defined?']("CLOCK_MONOTONIC", false)) ? ((($b = $$$('::', 'Process', 'skip_raise')) && ($c = $b, $c) && ($d = $c) && ((($e = $d.$clock_gettime) && !$e.$$stub) || $d['$respond_to_missing?']('clock_gettime'))) ? 'method' : nil)['$==']("method") : $a))) {
        
        Opal.const_set($nesting[0], 'CLOCK_ID', $$$($$$('::', 'Process'), 'CLOCK_MONOTONIC'));
        return (Opal.def(self, '$now', $Timings_now$14 = function $$now() {
          var self = this;

          return $$$('::', 'Process').$clock_gettime($$($nesting, 'CLOCK_ID'))
        }, $Timings_now$14.$$arity = 0), nil) && 'now';
      } else {
        return (Opal.def(self, '$now', $Timings_now$15 = function $$now() {
          var self = this;

          return $$$('::', 'Time').$now()
        }, $Timings_now$15.$$arity = 0), nil) && 'now'
      };
    })($nesting[0], null, $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/converter/composite"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $hash2 = Opal.hash2, $send = Opal.send, $truthy = Opal.truthy;

  Opal.add_stubs(['$attr_reader', '$each', '$respond_to?', '$composed', '$init_backend_traits', '$backend_traits', '$new', '$find_converter', '$[]=', '$-', '$convert', '$converter_for', '$node_name', '$[]', '$handles?', '$raise']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'CompositeConverter');

      var $nesting = [self].concat($parent_nesting), $CompositeConverter_initialize$1, $CompositeConverter_convert$4, $CompositeConverter_converter_for$5, $CompositeConverter_find_converter$6;

      self.$$prototype.converter_cache = self.$$prototype.converters = nil;
      
      self.$attr_reader("converters");
      
      Opal.def(self, '$initialize', $CompositeConverter_initialize$1 = function $$initialize(backend, $a, $b) {
        var $post_args, $kwargs, converters, backend_traits_source, $$2, $$3, self = this;

        
        
        $post_args = Opal.slice.call(arguments, 1, arguments.length);
        
        $kwargs = Opal.extract_kwargs($post_args);
        
        if ($kwargs == null) {
          $kwargs = $hash2([], {});
        } else if (!$kwargs.$$is_hash) {
          throw Opal.ArgumentError.$new('expected kwargs');
        };
        
        converters = $post_args;;
        
        backend_traits_source = $kwargs.$$smap["backend_traits_source"];
        if (backend_traits_source == null) {
          backend_traits_source = nil
        };
        self.backend = backend;
        $send((self.converters = converters), 'each', [], ($$2 = function(converter){var self = $$2.$$s || this;

        
          
          if (converter == null) {
            converter = nil;
          };
          if ($truthy(converter['$respond_to?']("composed"))) {
            return converter.$composed(self)
          } else {
            return nil
          };}, $$2.$$s = self, $$2.$$arity = 1, $$2));
        if ($truthy(backend_traits_source)) {
          self.$init_backend_traits(backend_traits_source.$backend_traits())};
        return (self.converter_cache = $send($$$('::', 'Hash'), 'new', [], ($$3 = function(hash, key){var self = $$3.$$s || this, $writer = nil;

        
          
          if (hash == null) {
            hash = nil;
          };
          
          if (key == null) {
            key = nil;
          };
          $writer = [key, self.$find_converter(key)];
          $send(hash, '[]=', Opal.to_a($writer));
          return $writer[$rb_minus($writer["length"], 1)];}, $$3.$$s = self, $$3.$$arity = 2, $$3)));
      }, $CompositeConverter_initialize$1.$$arity = -2);
      
      Opal.def(self, '$convert', $CompositeConverter_convert$4 = function $$convert(node, transform, opts) {
        var $a, self = this;

        
        
        if (transform == null) {
          transform = nil;
        };
        
        if (opts == null) {
          opts = nil;
        };
        return self.$converter_for((transform = ($truthy($a = transform) ? $a : node.$node_name()))).$convert(node, transform, opts);
      }, $CompositeConverter_convert$4.$$arity = -2);
      
      Opal.def(self, '$converter_for', $CompositeConverter_converter_for$5 = function $$converter_for(transform) {
        var self = this;

        return self.converter_cache['$[]'](transform)
      }, $CompositeConverter_converter_for$5.$$arity = 1);
      return (Opal.def(self, '$find_converter', $CompositeConverter_find_converter$6 = function $$find_converter(transform) {try {

        var $$7, self = this;

        
        $send(self.converters, 'each', [], ($$7 = function(candidate){var self = $$7.$$s || this;

        
          
          if (candidate == null) {
            candidate = nil;
          };
          if ($truthy(candidate['$handles?'](transform))) {
            Opal.ret(candidate)
          } else {
            return nil
          };}, $$7.$$s = self, $$7.$$arity = 1, $$7));
        return self.$raise("" + "Could not find a converter to handle transform: " + (transform));
        } catch ($returner) { if ($returner === Opal.returner) { return $returner.$v } throw $returner; }
      }, $CompositeConverter_find_converter$6.$$arity = 1), nil) && 'find_converter';
    })($$($nesting, 'Converter'), $$$($$($nesting, 'Converter'), 'Base'), $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/converter/html5"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_le(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs <= rhs : lhs['$<='](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  function $rb_times(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs * rhs : lhs['$*'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $send = Opal.send, $hash2 = Opal.hash2, $truthy = Opal.truthy, $gvars = Opal.gvars;

  Opal.add_stubs(['$register_for', '$default=', '$-', '$==', '$[]', '$init_backend_traits', '$node_name', '$===', '$convert_inline_quoted', '$convert_paragraph', '$convert_inline_anchor', '$convert_section', '$convert_listing', '$convert_literal', '$convert_ulist', '$convert_olist', '$convert_dlist', '$convert_admonition', '$convert_colist', '$convert_embedded', '$convert_example', '$convert_floating_title', '$convert_image', '$convert_inline_break', '$convert_inline_button', '$convert_inline_callout', '$convert_inline_footnote', '$convert_inline_image', '$convert_inline_indexterm', '$convert_inline_kbd', '$convert_inline_menu', '$convert_open', '$convert_page_break', '$convert_preamble', '$convert_quote', '$convert_sidebar', '$convert_stem', '$convert_table', '$convert_thematic_break', '$convert_verse', '$convert_video', '$convert_document', '$convert_toc', '$convert_pass', '$convert_audio', '$empty?', '$attr', '$attr?', '$<<', '$include?', '$sub_replacements', '$gsub', '$extname', '$slice', '$length', '$doctitle', '$normalize_web_path', '$primary_stylesheet_data', '$instance', '$read_contents', '$syntax_highlighter', '$size', '$docinfo', '$id', '$sections?', '$doctype', '$role?', '$role', '$join', '$noheader', '$convert', '$converter', '$generate_manname_section', '$header?', '$notitle', '$title', '$header', '$each', '$authors', '$>', '$name', '$email', '$sub_macros', '$+', '$downcase', '$concat', '$content', '$footnotes?', '$!', '$footnotes', '$index', '$text', '$nofooter', '$docinfo?', '$[]=', '$delete_at', '$inspect', '$!=', '$to_i', '$attributes', '$document', '$sections', '$level', '$caption', '$captioned_title', '$numbered', '$<=', '$<', '$sectname', '$sectnum', '$convert_outline', '$title?', '$icon_uri', '$compact', '$media_uri', '$option?', '$append_boolean_attribute', '$style', '$items', '$blocks?', '$text?', '$chomp', '$safe', '$read_svg_contents', '$alt', '$image_uri', '$encode_attribute_value', '$append_link_constraint_attrs', '$highlight?', '$to_sym', '$format', '$*', '$count', '$start_with?', '$end_with?', '$list_marker_keyword', '$parent', '$warn', '$logger', '$context', '$error', '$new', '$columns', '$to_h', '$rows', '$colspan', '$rowspan', '$unshift', '$shift', '$split', '$pop', '$nil_or_empty?', '$type', '$catalog', '$get_root_document', '$xreftext', '$target', '$reftext', '$chop', '$sub', '$match', '$private', '$upcase', '$nested?', '$parent_document', '$to_s', '$handles?', '$send']);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      var self = $klass($base, $super, 'Html5Converter');

      var $nesting = [self].concat($parent_nesting), $Html5Converter_initialize$1, $Html5Converter_convert$2, $Html5Converter_convert_document$3, $Html5Converter_convert_embedded$6, $Html5Converter_convert_outline$8, $Html5Converter_convert_section$10, $Html5Converter_convert_admonition$11, $Html5Converter_convert_audio$12, $Html5Converter_convert_colist$13, $Html5Converter_convert_dlist$16, $Html5Converter_convert_example$23, $Html5Converter_convert_floating_title$24, $Html5Converter_convert_image$25, $Html5Converter_convert_listing$26, $Html5Converter_convert_literal$27, $Html5Converter_convert_stem$28, $Html5Converter_convert_olist$30, $Html5Converter_convert_open$32, $Html5Converter_convert_page_break$33, $Html5Converter_convert_paragraph$34, $Html5Converter_convert_preamble$35, $Html5Converter_convert_quote$36, $Html5Converter_convert_thematic_break$37, $Html5Converter_convert_sidebar$38, $Html5Converter_convert_table$39, $Html5Converter_convert_toc$44, $Html5Converter_convert_ulist$45, $Html5Converter_convert_verse$47, $Html5Converter_convert_video$48, $Html5Converter_convert_inline_anchor$49, $Html5Converter_convert_inline_break$50, $Html5Converter_convert_inline_button$51, $Html5Converter_convert_inline_callout$52, $Html5Converter_convert_inline_footnote$53, $Html5Converter_convert_inline_image$54, $Html5Converter_convert_inline_indexterm$55, $Html5Converter_convert_inline_kbd$56, $Html5Converter_convert_inline_menu$57, $Html5Converter_convert_inline_quoted$58, $Html5Converter_read_svg_contents$59, $Html5Converter_append_boolean_attribute$61, $Html5Converter_append_link_constraint_attrs$62, $Html5Converter_encode_attribute_value$63, $Html5Converter_generate_manname_section$64, $Html5Converter_get_root_document$65, $Html5Converter_method_missing$66, $Html5Converter_respond_to_missing$ques$67, $writer = nil;

      self.$$prototype.void_element_slash = self.$$prototype.xml_mode = self.$$prototype.refs = self.$$prototype.resolving_xref = nil;
      
      self.$register_for("html5");
      
      $writer = [["", ""]];
      $send(Opal.const_set($nesting[0], 'QUOTE_TAGS', $hash2(["monospaced", "emphasis", "strong", "double", "single", "mark", "superscript", "subscript", "asciimath", "latexmath"], {"monospaced": ["<code>", "</code>", true], "emphasis": ["<em>", "</em>", true], "strong": ["<strong>", "</strong>", true], "double": ["&#8220;", "&#8221;"], "single": ["&#8216;", "&#8217;"], "mark": ["<mark>", "</mark>", true], "superscript": ["<sup>", "</sup>", true], "subscript": ["<sub>", "</sub>", true], "asciimath": ["\\$", "\\$"], "latexmath": ["\\(", "\\)"]})), 'default=', Opal.to_a($writer));
      $writer[$rb_minus($writer["length"], 1)];;
      Opal.const_set($nesting[0], 'DropAnchorRx', /<(?:a\b[^>]*|\/a)>/);
      Opal.const_set($nesting[0], 'StemBreakRx', / *\\\n(?:\\?\n)*|\n\n+/);
      if ($$($nesting, 'RUBY_ENGINE')['$==']("opal")) {
        
        Opal.const_set($nesting[0], 'SvgPreambleRx', new RegExp("" + "^" + ($$($nesting, 'CC_ALL')) + "*?(?=<svg[\\s>])"));
        Opal.const_set($nesting[0], 'SvgStartTagRx', /^<svg(?:\s[^>]*)?>/);
      } else {
        nil
      };
      Opal.const_set($nesting[0], 'DimensionAttributeRx', new RegExp("" + "\\s(?:width|height|style)=([\"'])" + ($$($nesting, 'CC_ANY')) + "*?\\1"));
      
      Opal.def(self, '$initialize', $Html5Converter_initialize$1 = function $$initialize(backend, opts) {
        var self = this, syntax = nil;

        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        self.backend = backend;
        if (opts['$[]']("htmlsyntax")['$==']("xml")) {
          
          syntax = "xml";
          self.xml_mode = true;
          self.void_element_slash = "/";
        } else {
          
          syntax = "html";
          self.xml_mode = nil;
          self.void_element_slash = "";
        };
        return self.$init_backend_traits($hash2(["basebackend", "filetype", "htmlsyntax", "outfilesuffix", "supports_templates"], {"basebackend": "html", "filetype": "html", "htmlsyntax": syntax, "outfilesuffix": ".html", "supports_templates": true}));
      }, $Html5Converter_initialize$1.$$arity = -2);
      
      Opal.def(self, '$convert', $Html5Converter_convert$2 = function $$convert(node, transform, opts) {
        var $iter = $Html5Converter_convert$2.$$p, $yield = $iter || nil, self = this, $case = nil, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) $Html5Converter_convert$2.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        
        
        if (transform == null) {
          transform = node.$node_name();
        };
        
        if (opts == null) {
          opts = nil;
        };
        return (function() {$case = transform;
        if ("inline_quoted"['$===']($case)) {return self.$convert_inline_quoted(node)}
        else if ("paragraph"['$===']($case)) {return self.$convert_paragraph(node)}
        else if ("inline_anchor"['$===']($case)) {return self.$convert_inline_anchor(node)}
        else if ("section"['$===']($case)) {return self.$convert_section(node)}
        else if ("listing"['$===']($case)) {return self.$convert_listing(node)}
        else if ("literal"['$===']($case)) {return self.$convert_literal(node)}
        else if ("ulist"['$===']($case)) {return self.$convert_ulist(node)}
        else if ("olist"['$===']($case)) {return self.$convert_olist(node)}
        else if ("dlist"['$===']($case)) {return self.$convert_dlist(node)}
        else if ("admonition"['$===']($case)) {return self.$convert_admonition(node)}
        else if ("colist"['$===']($case)) {return self.$convert_colist(node)}
        else if ("embedded"['$===']($case)) {return self.$convert_embedded(node)}
        else if ("example"['$===']($case)) {return self.$convert_example(node)}
        else if ("floating_title"['$===']($case)) {return self.$convert_floating_title(node)}
        else if ("image"['$===']($case)) {return self.$convert_image(node)}
        else if ("inline_break"['$===']($case)) {return self.$convert_inline_break(node)}
        else if ("inline_button"['$===']($case)) {return self.$convert_inline_button(node)}
        else if ("inline_callout"['$===']($case)) {return self.$convert_inline_callout(node)}
        else if ("inline_footnote"['$===']($case)) {return self.$convert_inline_footnote(node)}
        else if ("inline_image"['$===']($case)) {return self.$convert_inline_image(node)}
        else if ("inline_indexterm"['$===']($case)) {return self.$convert_inline_indexterm(node)}
        else if ("inline_kbd"['$===']($case)) {return self.$convert_inline_kbd(node)}
        else if ("inline_menu"['$===']($case)) {return self.$convert_inline_menu(node)}
        else if ("open"['$===']($case)) {return self.$convert_open(node)}
        else if ("page_break"['$===']($case)) {return self.$convert_page_break(node)}
        else if ("preamble"['$===']($case)) {return self.$convert_preamble(node)}
        else if ("quote"['$===']($case)) {return self.$convert_quote(node)}
        else if ("sidebar"['$===']($case)) {return self.$convert_sidebar(node)}
        else if ("stem"['$===']($case)) {return self.$convert_stem(node)}
        else if ("table"['$===']($case)) {return self.$convert_table(node)}
        else if ("thematic_break"['$===']($case)) {return self.$convert_thematic_break(node)}
        else if ("verse"['$===']($case)) {return self.$convert_verse(node)}
        else if ("video"['$===']($case)) {return self.$convert_video(node)}
        else if ("document"['$===']($case)) {return self.$convert_document(node)}
        else if ("toc"['$===']($case)) {return self.$convert_toc(node)}
        else if ("pass"['$===']($case)) {return self.$convert_pass(node)}
        else if ("audio"['$===']($case)) {return self.$convert_audio(node)}
        else {return $send(self, Opal.find_super_dispatcher(self, 'convert', $Html5Converter_convert$2, false), $zuper, $iter)}})();
      }, $Html5Converter_convert$2.$$arity = -2);
      
      Opal.def(self, '$convert_document', $Html5Converter_convert_document$3 = function $$convert_document(node) {
        var $a, $b, $c, $$4, $$5, self = this, br = nil, slash = nil, asset_uri_scheme = nil, cdn_base_url = nil, linkcss = nil, max_width_attr = nil, result = nil, lang_attribute = nil, authors = nil, icon_href = nil, icon_type = nil, icon_ext = nil, webfonts = nil, iconfont_stylesheet = nil, syntax_hl = nil, syntax_hl_docinfo_head_idx = nil, docinfo_content = nil, id_attr = nil, sectioned = nil, classes = nil, details = nil, idx = nil, $writer = nil, eqnums_val = nil, eqnums_opt = nil;

        
        br = "" + "<br" + ((slash = self.void_element_slash)) + ">";
        if ($truthy((asset_uri_scheme = node.$attr("asset-uri-scheme", "https"))['$empty?']())) {
        } else {
          asset_uri_scheme = "" + (asset_uri_scheme) + ":"
        };
        cdn_base_url = "" + (asset_uri_scheme) + "//cdnjs.cloudflare.com/ajax/libs";
        linkcss = node['$attr?']("linkcss");
        max_width_attr = (function() {if ($truthy(node['$attr?']("max-width"))) {
          return "" + " style=\"max-width: " + (node.$attr("max-width")) + ";\""
        } else {
          return ""
        }; return nil; })();
        result = ["<!DOCTYPE html>"];
        lang_attribute = (function() {if ($truthy(node['$attr?']("nolang"))) {
          return ""
        } else {
          return "" + " lang=\"" + (node.$attr("lang", "en")) + "\""
        }; return nil; })();
        result['$<<']("" + "<html" + ((function() {if ($truthy(self.xml_mode)) {
          return " xmlns=\"http://www.w3.org/1999/xhtml\""
        } else {
          return ""
        }; return nil; })()) + (lang_attribute) + ">");
        result['$<<']("" + "<head>\n" + "<meta charset=\"" + (node.$attr("encoding", "UTF-8")) + "\"" + (slash) + ">\n" + "<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\"" + (slash) + ">\n" + "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\"" + (slash) + ">\n" + "<meta name=\"generator\" content=\"Asciidoctor " + (node.$attr("asciidoctor-version")) + "\"" + (slash) + ">");
        if ($truthy(node['$attr?']("app-name"))) {
          result['$<<']("" + "<meta name=\"application-name\" content=\"" + (node.$attr("app-name")) + "\"" + (slash) + ">")};
        if ($truthy(node['$attr?']("description"))) {
          result['$<<']("" + "<meta name=\"description\" content=\"" + (node.$attr("description")) + "\"" + (slash) + ">")};
        if ($truthy(node['$attr?']("keywords"))) {
          result['$<<']("" + "<meta name=\"keywords\" content=\"" + (node.$attr("keywords")) + "\"" + (slash) + ">")};
        if ($truthy(node['$attr?']("authors"))) {
          result['$<<']("" + "<meta name=\"author\" content=\"" + ((function() {if ($truthy((authors = node.$sub_replacements(node.$attr("authors")))['$include?']("<"))) {
            
            return authors.$gsub($$($nesting, 'XmlSanitizeRx'), "");
          } else {
            return authors
          }; return nil; })()) + "\"" + (slash) + ">")};
        if ($truthy(node['$attr?']("copyright"))) {
          result['$<<']("" + "<meta name=\"copyright\" content=\"" + (node.$attr("copyright")) + "\"" + (slash) + ">")};
        if ($truthy(node['$attr?']("favicon"))) {
          
          if ($truthy((icon_href = node.$attr("favicon"))['$empty?']())) {
            
            icon_href = "favicon.ico";
            icon_type = "image/x-icon";
          } else if ($truthy((icon_ext = $$($nesting, 'Helpers').$extname(icon_href, nil)))) {
            icon_type = (function() {if (icon_ext['$=='](".ico")) {
              return "image/x-icon"
            } else {
              return "" + "image/" + (icon_ext.$slice(1, icon_ext.$length()))
            }; return nil; })()
          } else {
            icon_type = "image/x-icon"
          };
          result['$<<']("" + "<link rel=\"icon\" type=\"" + (icon_type) + "\" href=\"" + (icon_href) + "\"" + (slash) + ">");};
        result['$<<']("" + "<title>" + (node.$doctitle($hash2(["sanitize", "use_fallback"], {"sanitize": true, "use_fallback": true}))) + "</title>");
        if ($truthy($$($nesting, 'DEFAULT_STYLESHEET_KEYS')['$include?'](node.$attr("stylesheet")))) {
          
          if ($truthy((webfonts = node.$attr("webfonts")))) {
            result['$<<']("" + "<link rel=\"stylesheet\" href=\"" + (asset_uri_scheme) + "//fonts.googleapis.com/css?family=" + ((function() {if ($truthy(webfonts['$empty?']())) {
              return "Open+Sans:300,300italic,400,400italic,600,600italic%7CNoto+Serif:400,400italic,700,700italic%7CDroid+Sans+Mono:400,700"
            } else {
              return webfonts
            }; return nil; })()) + "\"" + (slash) + ">")};
          if ($truthy(linkcss)) {
            result['$<<']("" + "<link rel=\"stylesheet\" href=\"" + (node.$normalize_web_path($$($nesting, 'DEFAULT_STYLESHEET_NAME'), node.$attr("stylesdir", ""), false)) + "\"" + (slash) + ">")
          } else {
            result['$<<']("" + "<style>\n" + ($$($nesting, 'Stylesheets').$instance().$primary_stylesheet_data()) + "\n" + "</style>")
          };
        } else if ($truthy(node['$attr?']("stylesheet"))) {
          if ($truthy(linkcss)) {
            result['$<<']("" + "<link rel=\"stylesheet\" href=\"" + (node.$normalize_web_path(node.$attr("stylesheet"), node.$attr("stylesdir", ""))) + "\"" + (slash) + ">")
          } else {
            result['$<<']("" + "<style>\n" + (node.$read_contents(node.$attr("stylesheet"), $hash2(["start", "warn_on_failure", "label"], {"start": node.$attr("stylesdir"), "warn_on_failure": true, "label": "stylesheet"}))) + "\n" + "</style>")
          }};
        if ($truthy(node['$attr?']("icons", "font"))) {
          if ($truthy(node['$attr?']("iconfont-remote"))) {
            result['$<<']("" + "<link rel=\"stylesheet\" href=\"" + (node.$attr("iconfont-cdn", "" + (cdn_base_url) + "/font-awesome/" + ($$($nesting, 'FONT_AWESOME_VERSION')) + "/css/font-awesome.min.css")) + "\"" + (slash) + ">")
          } else {
            
            iconfont_stylesheet = "" + (node.$attr("iconfont-name", "font-awesome")) + ".css";
            result['$<<']("" + "<link rel=\"stylesheet\" href=\"" + (node.$normalize_web_path(iconfont_stylesheet, node.$attr("stylesdir", ""), false)) + "\"" + (slash) + ">");
          }};
        if ($truthy((syntax_hl = node.$syntax_highlighter()))) {
          result['$<<']((syntax_hl_docinfo_head_idx = result.$size()))};
        if ($truthy((docinfo_content = node.$docinfo())['$empty?']())) {
        } else {
          result['$<<'](docinfo_content)
        };
        result['$<<']("</head>");
        id_attr = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        if ($truthy(($truthy($a = ($truthy($b = ($truthy($c = (sectioned = node['$sections?']())) ? node['$attr?']("toc-class") : $c)) ? node['$attr?']("toc") : $b)) ? node['$attr?']("toc-placement", "auto") : $a))) {
          classes = [node.$doctype(), node.$attr("toc-class"), "" + "toc-" + (node.$attr("toc-position", "header"))]
        } else {
          classes = [node.$doctype()]
        };
        if ($truthy(node['$role?']())) {
          classes['$<<'](node.$role())};
        result['$<<']("" + "<body" + (id_attr) + " class=\"" + (classes.$join(" ")) + "\">");
        if ($truthy((docinfo_content = node.$docinfo("header"))['$empty?']())) {
        } else {
          result['$<<'](docinfo_content)
        };
        if ($truthy(node.$noheader())) {
        } else {
          
          result['$<<']("" + "<div id=\"header\"" + (max_width_attr) + ">");
          if (node.$doctype()['$==']("manpage")) {
            
            result['$<<']("" + "<h1>" + (node.$doctitle()) + " Manual Page</h1>");
            if ($truthy(($truthy($a = ($truthy($b = sectioned) ? node['$attr?']("toc") : $b)) ? node['$attr?']("toc-placement", "auto") : $a))) {
              result['$<<']("" + "<div id=\"toc\" class=\"" + (node.$attr("toc-class", "toc")) + "\">\n" + "<div id=\"toctitle\">" + (node.$attr("toc-title")) + "</div>\n" + (node.$converter().$convert(node, "outline")) + "\n" + "</div>")};
            if ($truthy(node['$attr?']("manpurpose"))) {
              result['$<<'](self.$generate_manname_section(node))};
          } else {
            
            if ($truthy(node['$header?']())) {
              
              if ($truthy(node.$notitle())) {
              } else {
                result['$<<']("" + "<h1>" + (node.$header().$title()) + "</h1>")
              };
              details = [];
              idx = 1;
              $send(node.$authors(), 'each', [], ($$4 = function(author){var self = $$4.$$s || this;

              
                
                if (author == null) {
                  author = nil;
                };
                details['$<<']("" + "<span id=\"author" + ((function() {if ($truthy($rb_gt(idx, 1))) {
                  return idx
                } else {
                  return ""
                }; return nil; })()) + "\" class=\"author\">" + (node.$sub_replacements(author.$name())) + "</span>" + (br));
                if ($truthy(author.$email())) {
                  details['$<<']("" + "<span id=\"email" + ((function() {if ($truthy($rb_gt(idx, 1))) {
                    return idx
                  } else {
                    return ""
                  }; return nil; })()) + "\" class=\"email\">" + (node.$sub_macros(author.$email())) + "</span>" + (br))};
                return (idx = $rb_plus(idx, 1));}, $$4.$$s = self, $$4.$$arity = 1, $$4));
              if ($truthy(node['$attr?']("revnumber"))) {
                details['$<<']("" + "<span id=\"revnumber\">" + (($truthy($a = node.$attr("version-label")) ? $a : "").$downcase()) + " " + (node.$attr("revnumber")) + ((function() {if ($truthy(node['$attr?']("revdate"))) {
                  return ","
                } else {
                  return ""
                }; return nil; })()) + "</span>")};
              if ($truthy(node['$attr?']("revdate"))) {
                details['$<<']("" + "<span id=\"revdate\">" + (node.$attr("revdate")) + "</span>")};
              if ($truthy(node['$attr?']("revremark"))) {
                details['$<<']("" + (br) + "<span id=\"revremark\">" + (node.$attr("revremark")) + "</span>")};
              if ($truthy(details['$empty?']())) {
              } else {
                
                result['$<<']("<div class=\"details\">");
                result.$concat(details);
                result['$<<']("</div>");
              };};
            if ($truthy(($truthy($a = ($truthy($b = sectioned) ? node['$attr?']("toc") : $b)) ? node['$attr?']("toc-placement", "auto") : $a))) {
              result['$<<']("" + "<div id=\"toc\" class=\"" + (node.$attr("toc-class", "toc")) + "\">\n" + "<div id=\"toctitle\">" + (node.$attr("toc-title")) + "</div>\n" + (node.$converter().$convert(node, "outline")) + "\n" + "</div>")};
          };
          result['$<<']("</div>");
        };
        result['$<<']("" + "<div id=\"content\"" + (max_width_attr) + ">\n" + (node.$content()) + "\n" + "</div>");
        if ($truthy(($truthy($a = node['$footnotes?']()) ? node['$attr?']("nofootnotes")['$!']() : $a))) {
          
          result['$<<']("" + "<div id=\"footnotes\"" + (max_width_attr) + ">\n" + "<hr" + (slash) + ">");
          $send(node.$footnotes(), 'each', [], ($$5 = function(footnote){var self = $$5.$$s || this;

          
            
            if (footnote == null) {
              footnote = nil;
            };
            return result['$<<']("" + "<div class=\"footnote\" id=\"_footnotedef_" + (footnote.$index()) + "\">\n" + "<a href=\"#_footnoteref_" + (footnote.$index()) + "\">" + (footnote.$index()) + "</a>. " + (footnote.$text()) + "\n" + "</div>");}, $$5.$$s = self, $$5.$$arity = 1, $$5));
          result['$<<']("</div>");};
        if ($truthy(node.$nofooter())) {
        } else {
          
          result['$<<']("" + "<div id=\"footer\"" + (max_width_attr) + ">");
          result['$<<']("<div id=\"footer-text\">");
          if ($truthy(node['$attr?']("revnumber"))) {
            result['$<<']("" + (node.$attr("version-label")) + " " + (node.$attr("revnumber")) + (br))};
          if ($truthy(($truthy($a = node['$attr?']("last-update-label")) ? node['$attr?']("reproducible")['$!']() : $a))) {
            result['$<<']("" + (node.$attr("last-update-label")) + " " + (node.$attr("docdatetime")))};
          result['$<<']("</div>");
          result['$<<']("</div>");
        };
        if ($truthy(syntax_hl)) {
          
          if ($truthy(syntax_hl['$docinfo?']("head"))) {
            
            $writer = [syntax_hl_docinfo_head_idx, syntax_hl.$docinfo("head", node, $hash2(["cdn_base_url", "linkcss", "self_closing_tag_slash"], {"cdn_base_url": cdn_base_url, "linkcss": linkcss, "self_closing_tag_slash": slash}))];
            $send(result, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          } else {
            result.$delete_at(syntax_hl_docinfo_head_idx)
          };
          if ($truthy(syntax_hl['$docinfo?']("footer"))) {
            result['$<<'](syntax_hl.$docinfo("footer", node, $hash2(["cdn_base_url", "linkcss", "self_closing_tag_slash"], {"cdn_base_url": cdn_base_url, "linkcss": linkcss, "self_closing_tag_slash": slash})))};};
        if ($truthy(node['$attr?']("stem"))) {
          
          eqnums_val = node.$attr("eqnums", "none");
          if ($truthy(eqnums_val['$empty?']())) {
            eqnums_val = "AMS"};
          eqnums_opt = "" + " equationNumbers: { autoNumber: \"" + (eqnums_val) + "\" } ";
          result['$<<']("" + "<script type=\"text/x-mathjax-config\">\n" + "MathJax.Hub.Config({\n" + "  messageStyle: \"none\",\n" + "  tex2jax: {\n" + "    inlineMath: [" + ($$($nesting, 'INLINE_MATH_DELIMITERS')['$[]']("latexmath").$inspect()) + "],\n" + "    displayMath: [" + ($$($nesting, 'BLOCK_MATH_DELIMITERS')['$[]']("latexmath").$inspect()) + "],\n" + "    ignoreClass: \"nostem|nolatexmath\"\n" + "  },\n" + "  asciimath2jax: {\n" + "    delimiters: [" + ($$($nesting, 'BLOCK_MATH_DELIMITERS')['$[]']("asciimath").$inspect()) + "],\n" + "    ignoreClass: \"nostem|noasciimath\"\n" + "  },\n" + "  TeX: {" + (eqnums_opt) + "}\n" + "})\n" + "MathJax.Hub.Register.StartupHook(\"AsciiMath Jax Ready\", function () {\n" + "  MathJax.InputJax.AsciiMath.postfilterHooks.Add(function (data, node) {\n" + "    if ((node = data.script.parentNode) && (node = node.parentNode) && node.classList.contains(\"stemblock\")) {\n" + "      data.math.root.display = \"block\"\n" + "    }\n" + "    return data\n" + "  })\n" + "})\n" + "</script>\n" + "<script src=\"" + (cdn_base_url) + "/mathjax/" + ($$($nesting, 'MATHJAX_VERSION')) + "/MathJax.js?config=TeX-MML-AM_HTMLorMML\"></script>");};
        if ($truthy((docinfo_content = node.$docinfo("footer"))['$empty?']())) {
        } else {
          result['$<<'](docinfo_content)
        };
        result['$<<']("</body>");
        result['$<<']("</html>");
        return result.$join($$($nesting, 'LF'));
      }, $Html5Converter_convert_document$3.$$arity = 1);
      
      Opal.def(self, '$convert_embedded', $Html5Converter_convert_embedded$6 = function $$convert_embedded(node) {
        var $a, $b, $c, $$7, self = this, result = nil, id_attr = nil, toc_p = nil;

        
        result = [];
        if (node.$doctype()['$==']("manpage")) {
          
          if ($truthy(node.$notitle())) {
          } else {
            
            id_attr = (function() {if ($truthy(node.$id())) {
              return "" + " id=\"" + (node.$id()) + "\""
            } else {
              return ""
            }; return nil; })();
            result['$<<']("" + "<h1" + (id_attr) + ">" + (node.$doctitle()) + " Manual Page</h1>");
          };
          if ($truthy(node['$attr?']("manpurpose"))) {
            result['$<<'](self.$generate_manname_section(node))};
        } else if ($truthy(($truthy($a = node['$header?']()) ? node.$notitle()['$!']() : $a))) {
          
          id_attr = (function() {if ($truthy(node.$id())) {
            return "" + " id=\"" + (node.$id()) + "\""
          } else {
            return ""
          }; return nil; })();
          result['$<<']("" + "<h1" + (id_attr) + ">" + (node.$header().$title()) + "</h1>");};
        if ($truthy(($truthy($a = ($truthy($b = ($truthy($c = node['$sections?']()) ? node['$attr?']("toc") : $c)) ? (toc_p = node.$attr("toc-placement"))['$!=']("macro") : $b)) ? toc_p['$!=']("preamble") : $a))) {
          result['$<<']("" + "<div id=\"toc\" class=\"toc\">\n" + "<div id=\"toctitle\">" + (node.$attr("toc-title")) + "</div>\n" + (node.$converter().$convert(node, "outline")) + "\n" + "</div>")};
        result['$<<'](node.$content());
        if ($truthy(($truthy($a = node['$footnotes?']()) ? node['$attr?']("nofootnotes")['$!']() : $a))) {
          
          result['$<<']("" + "<div id=\"footnotes\">\n" + "<hr" + (self.void_element_slash) + ">");
          $send(node.$footnotes(), 'each', [], ($$7 = function(footnote){var self = $$7.$$s || this;

          
            
            if (footnote == null) {
              footnote = nil;
            };
            return result['$<<']("" + "<div class=\"footnote\" id=\"_footnotedef_" + (footnote.$index()) + "\">\n" + "<a href=\"#_footnoteref_" + (footnote.$index()) + "\">" + (footnote.$index()) + "</a>. " + (footnote.$text()) + "\n" + "</div>");}, $$7.$$s = self, $$7.$$arity = 1, $$7));
          result['$<<']("</div>");};
        return result.$join($$($nesting, 'LF'));
      }, $Html5Converter_convert_embedded$6.$$arity = 1);
      
      Opal.def(self, '$convert_outline', $Html5Converter_convert_outline$8 = function $$convert_outline(node, opts) {
        var $a, $b, $$9, self = this, sectnumlevels = nil, toclevels = nil, sections = nil, result = nil;

        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        if ($truthy(node['$sections?']())) {
        } else {
          return nil
        };
        sectnumlevels = ($truthy($a = opts['$[]']("sectnumlevels")) ? $a : ($truthy($b = node.$document().$attributes()['$[]']("sectnumlevels")) ? $b : 3).$to_i());
        toclevels = ($truthy($a = opts['$[]']("toclevels")) ? $a : ($truthy($b = node.$document().$attributes()['$[]']("toclevels")) ? $b : 2).$to_i());
        sections = node.$sections();
        result = ["" + "<ul class=\"sectlevel" + (sections['$[]'](0).$level()) + "\">"];
        $send(sections, 'each', [], ($$9 = function(section){var self = $$9.$$s || this, $c, slevel = nil, stitle = nil, $case = nil, signifier = nil, child_toc_level = nil;

        
          
          if (section == null) {
            section = nil;
          };
          slevel = section.$level();
          if ($truthy(section.$caption())) {
            stitle = section.$captioned_title()
          } else if ($truthy(($truthy($c = section.$numbered()) ? $rb_le(slevel, sectnumlevels) : $c))) {
            if ($truthy(($truthy($c = $rb_lt(slevel, 2)) ? node.$document().$doctype()['$==']("book") : $c))) {
              $case = section.$sectname();
              if ("chapter"['$===']($case)) {stitle = "" + ((function() {if ($truthy((signifier = node.$document().$attributes()['$[]']("chapter-signifier")))) {
                return "" + (signifier) + " "
              } else {
                return ""
              }; return nil; })()) + (section.$sectnum()) + " " + (section.$title())}
              else if ("part"['$===']($case)) {stitle = "" + ((function() {if ($truthy((signifier = node.$document().$attributes()['$[]']("part-signifier")))) {
                return "" + (signifier) + " "
              } else {
                return ""
              }; return nil; })()) + (section.$sectnum(nil, ":")) + " " + (section.$title())}
              else {stitle = "" + (section.$sectnum()) + " " + (section.$title())}
            } else {
              stitle = "" + (section.$sectnum()) + " " + (section.$title())
            }
          } else {
            stitle = section.$title()
          };
          if ($truthy(stitle['$include?']("<a"))) {
            stitle = stitle.$gsub($$($nesting, 'DropAnchorRx'), "")};
          if ($truthy(($truthy($c = $rb_lt(slevel, toclevels)) ? (child_toc_level = self.$convert_outline(section, $hash2(["toclevels", "sectnumlevels"], {"toclevels": toclevels, "sectnumlevels": sectnumlevels}))) : $c))) {
            
            result['$<<']("" + "<li><a href=\"#" + (section.$id()) + "\">" + (stitle) + "</a>");
            result['$<<'](child_toc_level);
            return result['$<<']("</li>");
          } else {
            return result['$<<']("" + "<li><a href=\"#" + (section.$id()) + "\">" + (stitle) + "</a></li>")
          };}, $$9.$$s = self, $$9.$$arity = 1, $$9));
        result['$<<']("</ul>");
        return result.$join($$($nesting, 'LF'));
      }, $Html5Converter_convert_outline$8.$$arity = -2);
      
      Opal.def(self, '$convert_section', $Html5Converter_convert_section$10 = function $$convert_section(node) {
        var $a, $b, self = this, doc_attrs = nil, level = nil, title = nil, $case = nil, signifier = nil, id_attr = nil, id = nil, role = nil;

        
        doc_attrs = node.$document().$attributes();
        level = node.$level();
        if ($truthy(node.$caption())) {
          title = node.$captioned_title()
        } else if ($truthy(($truthy($a = node.$numbered()) ? $rb_le(level, ($truthy($b = doc_attrs['$[]']("sectnumlevels")) ? $b : 3).$to_i()) : $a))) {
          if ($truthy(($truthy($a = $rb_lt(level, 2)) ? node.$document().$doctype()['$==']("book") : $a))) {
            $case = node.$sectname();
            if ("chapter"['$===']($case)) {title = "" + ((function() {if ($truthy((signifier = doc_attrs['$[]']("chapter-signifier")))) {
              return "" + (signifier) + " "
            } else {
              return ""
            }; return nil; })()) + (node.$sectnum()) + " " + (node.$title())}
            else if ("part"['$===']($case)) {title = "" + ((function() {if ($truthy((signifier = doc_attrs['$[]']("part-signifier")))) {
              return "" + (signifier) + " "
            } else {
              return ""
            }; return nil; })()) + (node.$sectnum(nil, ":")) + " " + (node.$title())}
            else {title = "" + (node.$sectnum()) + " " + (node.$title())}
          } else {
            title = "" + (node.$sectnum()) + " " + (node.$title())
          }
        } else {
          title = node.$title()
        };
        if ($truthy(node.$id())) {
          
          id_attr = "" + " id=\"" + ((id = node.$id())) + "\"";
          if ($truthy(doc_attrs['$[]']("sectlinks"))) {
            title = "" + "<a class=\"link\" href=\"#" + (id) + "\">" + (title) + "</a>"};
          if ($truthy(doc_attrs['$[]']("sectanchors"))) {
            if (doc_attrs['$[]']("sectanchors")['$==']("after")) {
              title = "" + (title) + "<a class=\"anchor\" href=\"#" + (id) + "\"></a>"
            } else {
              title = "" + "<a class=\"anchor\" href=\"#" + (id) + "\"></a>" + (title)
            }};
        } else {
          id_attr = ""
        };
        if (level['$=='](0)) {
          return "" + "<h1" + (id_attr) + " class=\"sect0" + ((function() {if ($truthy((role = node.$role()))) {
            return "" + " " + (role)
          } else {
            return ""
          }; return nil; })()) + "\">" + (title) + "</h1>\n" + (node.$content())
        } else {
          return "" + "<div class=\"sect" + (level) + ((function() {if ($truthy((role = node.$role()))) {
            return "" + " " + (role)
          } else {
            return ""
          }; return nil; })()) + "\">\n" + "<h" + ($rb_plus(level, 1)) + (id_attr) + ">" + (title) + "</h" + ($rb_plus(level, 1)) + ">\n" + ((function() {if (level['$=='](1)) {
            return "" + "<div class=\"sectionbody\">\n" + (node.$content()) + "\n" + "</div>"
          } else {
            return node.$content()
          }; return nil; })()) + "\n" + "</div>"
        };
      }, $Html5Converter_convert_section$10.$$arity = 1);
      
      Opal.def(self, '$convert_admonition', $Html5Converter_convert_admonition$11 = function $$convert_admonition(node) {
        var $a, self = this, id_attr = nil, name = nil, title_element = nil, label = nil, role = nil;

        
        id_attr = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        name = node.$attr("name");
        title_element = (function() {if ($truthy(node['$title?']())) {
          return "" + "<div class=\"title\">" + (node.$title()) + "</div>\n"
        } else {
          return ""
        }; return nil; })();
        if ($truthy(node.$document()['$attr?']("icons"))) {
          if ($truthy(($truthy($a = node.$document()['$attr?']("icons", "font")) ? node['$attr?']("icon")['$!']() : $a))) {
            label = "" + "<i class=\"fa icon-" + (name) + "\" title=\"" + (node.$attr("textlabel")) + "\"></i>"
          } else {
            label = "" + "<img src=\"" + (node.$icon_uri(name)) + "\" alt=\"" + (node.$attr("textlabel")) + "\"" + (self.void_element_slash) + ">"
          }
        } else {
          label = "" + "<div class=\"title\">" + (node.$attr("textlabel")) + "</div>"
        };
        return "" + "<div" + (id_attr) + " class=\"admonitionblock " + (name) + ((function() {if ($truthy((role = node.$role()))) {
          return "" + " " + (role)
        } else {
          return ""
        }; return nil; })()) + "\">\n" + "<table>\n" + "<tr>\n" + "<td class=\"icon\">\n" + (label) + "\n" + "</td>\n" + "<td class=\"content\">\n" + (title_element) + (node.$content()) + "\n" + "</td>\n" + "</tr>\n" + "</table>\n" + "</div>";
      }, $Html5Converter_convert_admonition$11.$$arity = 1);
      
      Opal.def(self, '$convert_audio', $Html5Converter_convert_audio$12 = function $$convert_audio(node) {
        var $a, self = this, xml = nil, id_attribute = nil, classes = nil, class_attribute = nil, title_element = nil, start_t = nil, end_t = nil, time_anchor = nil;

        
        xml = self.xml_mode;
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        classes = ["audioblock", node.$role()].$compact();
        class_attribute = "" + " class=\"" + (classes.$join(" ")) + "\"";
        title_element = (function() {if ($truthy(node['$title?']())) {
          return "" + "<div class=\"title\">" + (node.$title()) + "</div>\n"
        } else {
          return ""
        }; return nil; })();
        start_t = node.$attr("start");
        end_t = node.$attr("end");
        time_anchor = (function() {if ($truthy(($truthy($a = start_t) ? $a : end_t))) {
          return "" + "#t=" + (($truthy($a = start_t) ? $a : "")) + ((function() {if ($truthy(end_t)) {
            return "" + "," + (end_t)
          } else {
            return ""
          }; return nil; })())
        } else {
          return ""
        }; return nil; })();
        return "" + "<div" + (id_attribute) + (class_attribute) + ">\n" + (title_element) + "<div class=\"content\">\n" + "<audio src=\"" + (node.$media_uri(node.$attr("target"))) + (time_anchor) + "\"" + ((function() {if ($truthy(node['$option?']("autoplay"))) {
          
          return self.$append_boolean_attribute("autoplay", xml);
        } else {
          return ""
        }; return nil; })()) + ((function() {if ($truthy(node['$option?']("nocontrols"))) {
          return ""
        } else {
          
          return self.$append_boolean_attribute("controls", xml);
        }; return nil; })()) + ((function() {if ($truthy(node['$option?']("loop"))) {
          
          return self.$append_boolean_attribute("loop", xml);
        } else {
          return ""
        }; return nil; })()) + ">\n" + "Your browser does not support the audio tag.\n" + "</audio>\n" + "</div>\n" + "</div>";
      }, $Html5Converter_convert_audio$12.$$arity = 1);
      
      Opal.def(self, '$convert_colist', $Html5Converter_convert_colist$13 = function $$convert_colist(node) {
        var $a, $$14, $$15, self = this, result = nil, id_attribute = nil, classes = nil, class_attribute = nil, font_icons = nil, num = nil;

        
        result = [];
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        classes = ["colist", node.$style(), node.$role()].$compact();
        class_attribute = "" + " class=\"" + (classes.$join(" ")) + "\"";
        result['$<<']("" + "<div" + (id_attribute) + (class_attribute) + ">");
        if ($truthy(node['$title?']())) {
          result['$<<']("" + "<div class=\"title\">" + (node.$title()) + "</div>")};
        if ($truthy(node.$document()['$attr?']("icons"))) {
          
          result['$<<']("<table>");
          $a = [node.$document()['$attr?']("icons", "font"), 0], (font_icons = $a[0]), (num = $a[1]), $a;
          $send(node.$items(), 'each', [], ($$14 = function(item){var self = $$14.$$s || this, num_label = nil;
            if (self.void_element_slash == null) self.void_element_slash = nil;

          
            
            if (item == null) {
              item = nil;
            };
            num = $rb_plus(num, 1);
            if ($truthy(font_icons)) {
              num_label = "" + "<i class=\"conum\" data-value=\"" + (num) + "\"></i><b>" + (num) + "</b>"
            } else {
              num_label = "" + "<img src=\"" + (node.$icon_uri("" + "callouts/" + (num))) + "\" alt=\"" + (num) + "\"" + (self.void_element_slash) + ">"
            };
            return result['$<<']("" + "<tr>\n" + "<td>" + (num_label) + "</td>\n" + "<td>" + (item.$text()) + ((function() {if ($truthy(item['$blocks?']())) {
              return $rb_plus($$($nesting, 'LF'), item.$content())
            } else {
              return ""
            }; return nil; })()) + "</td>\n" + "</tr>");}, $$14.$$s = self, $$14.$$arity = 1, $$14));
          result['$<<']("</table>");
        } else {
          
          result['$<<']("<ol>");
          $send(node.$items(), 'each', [], ($$15 = function(item){var self = $$15.$$s || this;

          
            
            if (item == null) {
              item = nil;
            };
            return result['$<<']("" + "<li>\n" + "<p>" + (item.$text()) + "</p>" + ((function() {if ($truthy(item['$blocks?']())) {
              return $rb_plus($$($nesting, 'LF'), item.$content())
            } else {
              return ""
            }; return nil; })()) + "\n" + "</li>");}, $$15.$$s = self, $$15.$$arity = 1, $$15));
          result['$<<']("</ol>");
        };
        result['$<<']("</div>");
        return result.$join($$($nesting, 'LF'));
      }, $Html5Converter_convert_colist$13.$$arity = 1);
      
      Opal.def(self, '$convert_dlist', $Html5Converter_convert_dlist$16 = function $$convert_dlist(node) {
        var $$17, $a, $$19, $$21, self = this, result = nil, id_attribute = nil, $case = nil, classes = nil, class_attribute = nil, slash = nil, col_style_attribute = nil, dt_style_attribute = nil;

        
        result = [];
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        $case = node.$style();
        if ("qanda"['$===']($case)) {classes = ["qlist", "qanda", node.$role()]}
        else if ("horizontal"['$===']($case)) {classes = ["hdlist", node.$role()]}
        else {classes = ["dlist", node.$style(), node.$role()]};
        class_attribute = "" + " class=\"" + (classes.$compact().$join(" ")) + "\"";
        result['$<<']("" + "<div" + (id_attribute) + (class_attribute) + ">");
        if ($truthy(node['$title?']())) {
          result['$<<']("" + "<div class=\"title\">" + (node.$title()) + "</div>")};
        $case = node.$style();
        if ("qanda"['$===']($case)) {
        result['$<<']("<ol>");
        $send(node.$items(), 'each', [], ($$17 = function(terms, dd){var self = $$17.$$s || this, $$18;

        
          
          if (terms == null) {
            terms = nil;
          };
          
          if (dd == null) {
            dd = nil;
          };
          result['$<<']("<li>");
          $send(terms, 'each', [], ($$18 = function(dt){var self = $$18.$$s || this;

          
            
            if (dt == null) {
              dt = nil;
            };
            return result['$<<']("" + "<p><em>" + (dt.$text()) + "</em></p>");}, $$18.$$s = self, $$18.$$arity = 1, $$18));
          if ($truthy(dd)) {
            
            if ($truthy(dd['$text?']())) {
              result['$<<']("" + "<p>" + (dd.$text()) + "</p>")};
            if ($truthy(dd['$blocks?']())) {
              result['$<<'](dd.$content())};};
          return result['$<<']("</li>");}, $$17.$$s = self, $$17.$$arity = 2, $$17));
        result['$<<']("</ol>");}
        else if ("horizontal"['$===']($case)) {
        slash = self.void_element_slash;
        result['$<<']("<table>");
        if ($truthy(($truthy($a = node['$attr?']("labelwidth")) ? $a : node['$attr?']("itemwidth")))) {
          
          result['$<<']("<colgroup>");
          col_style_attribute = (function() {if ($truthy(node['$attr?']("labelwidth"))) {
            return "" + " style=\"width: " + (node.$attr("labelwidth").$chomp("%")) + "%;\""
          } else {
            return ""
          }; return nil; })();
          result['$<<']("" + "<col" + (col_style_attribute) + (slash) + ">");
          col_style_attribute = (function() {if ($truthy(node['$attr?']("itemwidth"))) {
            return "" + " style=\"width: " + (node.$attr("itemwidth").$chomp("%")) + "%;\""
          } else {
            return ""
          }; return nil; })();
          result['$<<']("" + "<col" + (col_style_attribute) + (slash) + ">");
          result['$<<']("</colgroup>");};
        $send(node.$items(), 'each', [], ($$19 = function(terms, dd){var self = $$19.$$s || this, $$20, first_term = nil;

        
          
          if (terms == null) {
            terms = nil;
          };
          
          if (dd == null) {
            dd = nil;
          };
          result['$<<']("<tr>");
          result['$<<']("" + "<td class=\"hdlist1" + ((function() {if ($truthy(node['$option?']("strong"))) {
            return " strong"
          } else {
            return ""
          }; return nil; })()) + "\">");
          first_term = true;
          $send(terms, 'each', [], ($$20 = function(dt){var self = $$20.$$s || this;

          
            
            if (dt == null) {
              dt = nil;
            };
            if ($truthy(first_term)) {
            } else {
              result['$<<']("" + "<br" + (slash) + ">")
            };
            result['$<<'](dt.$text());
            return (first_term = nil);}, $$20.$$s = self, $$20.$$arity = 1, $$20));
          result['$<<']("</td>");
          result['$<<']("<td class=\"hdlist2\">");
          if ($truthy(dd)) {
            
            if ($truthy(dd['$text?']())) {
              result['$<<']("" + "<p>" + (dd.$text()) + "</p>")};
            if ($truthy(dd['$blocks?']())) {
              result['$<<'](dd.$content())};};
          result['$<<']("</td>");
          return result['$<<']("</tr>");}, $$19.$$s = self, $$19.$$arity = 2, $$19));
        result['$<<']("</table>");}
        else {
        result['$<<']("<dl>");
        dt_style_attribute = (function() {if ($truthy(node.$style())) {
          return ""
        } else {
          return " class=\"hdlist1\""
        }; return nil; })();
        $send(node.$items(), 'each', [], ($$21 = function(terms, dd){var self = $$21.$$s || this, $$22;

        
          
          if (terms == null) {
            terms = nil;
          };
          
          if (dd == null) {
            dd = nil;
          };
          $send(terms, 'each', [], ($$22 = function(dt){var self = $$22.$$s || this;

          
            
            if (dt == null) {
              dt = nil;
            };
            return result['$<<']("" + "<dt" + (dt_style_attribute) + ">" + (dt.$text()) + "</dt>");}, $$22.$$s = self, $$22.$$arity = 1, $$22));
          if ($truthy(dd)) {
          } else {
            return nil;
          };
          result['$<<']("<dd>");
          if ($truthy(dd['$text?']())) {
            result['$<<']("" + "<p>" + (dd.$text()) + "</p>")};
          if ($truthy(dd['$blocks?']())) {
            result['$<<'](dd.$content())};
          return result['$<<']("</dd>");}, $$21.$$s = self, $$21.$$arity = 2, $$21));
        result['$<<']("</dl>");};
        result['$<<']("</div>");
        return result.$join($$($nesting, 'LF'));
      }, $Html5Converter_convert_dlist$16.$$arity = 1);
      
      Opal.def(self, '$convert_example', $Html5Converter_convert_example$23 = function $$convert_example(node) {
        var self = this, id_attribute = nil, class_attribute = nil, summary_element = nil, title_element = nil, role = nil;

        
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        if ($truthy(node['$option?']("collapsible"))) {
          
          class_attribute = (function() {if ($truthy(node.$role())) {
            return "" + " class=\"" + (node.$role()) + "\""
          } else {
            return ""
          }; return nil; })();
          summary_element = (function() {if ($truthy(node['$title?']())) {
            return "" + "<summary class=\"title\">" + (node.$title()) + "</summary>"
          } else {
            return "<summary class=\"title\">Details</summary>"
          }; return nil; })();
          return "" + "<details" + (id_attribute) + (class_attribute) + ((function() {if ($truthy(node['$option?']("open"))) {
            return " open"
          } else {
            return ""
          }; return nil; })()) + ">\n" + (summary_element) + "\n" + "<div class=\"content\">\n" + (node.$content()) + "\n" + "</div>\n" + "</details>";
        } else {
          
          title_element = (function() {if ($truthy(node['$title?']())) {
            return "" + "<div class=\"title\">" + (node.$captioned_title()) + "</div>\n"
          } else {
            return ""
          }; return nil; })();
          return "" + "<div" + (id_attribute) + " class=\"exampleblock" + ((function() {if ($truthy((role = node.$role()))) {
            return "" + " " + (role)
          } else {
            return ""
          }; return nil; })()) + "\">\n" + (title_element) + "<div class=\"content\">\n" + (node.$content()) + "\n" + "</div>\n" + "</div>";
        };
      }, $Html5Converter_convert_example$23.$$arity = 1);
      
      Opal.def(self, '$convert_floating_title', $Html5Converter_convert_floating_title$24 = function $$convert_floating_title(node) {
        var self = this, tag_name = nil, id_attribute = nil, classes = nil;

        
        tag_name = "" + "h" + ($rb_plus(node.$level(), 1));
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        classes = [node.$style(), node.$role()].$compact();
        return "" + "<" + (tag_name) + (id_attribute) + " class=\"" + (classes.$join(" ")) + "\">" + (node.$title()) + "</" + (tag_name) + ">";
      }, $Html5Converter_convert_floating_title$24.$$arity = 1);
      
      Opal.def(self, '$convert_image', $Html5Converter_convert_image$25 = function $$convert_image(node) {
        var $a, $b, self = this, target = nil, width_attr = nil, height_attr = nil, img = nil, fallback = nil, id_attr = nil, classes = nil, class_attr = nil, title_el = nil;

        
        target = node.$attr("target");
        width_attr = (function() {if ($truthy(node['$attr?']("width"))) {
          return "" + " width=\"" + (node.$attr("width")) + "\""
        } else {
          return ""
        }; return nil; })();
        height_attr = (function() {if ($truthy(node['$attr?']("height"))) {
          return "" + " height=\"" + (node.$attr("height")) + "\""
        } else {
          return ""
        }; return nil; })();
        if ($truthy(($truthy($a = ($truthy($b = node['$attr?']("format", "svg")) ? $b : target['$include?'](".svg"))) ? $rb_lt(node.$document().$safe(), $$$($$($nesting, 'SafeMode'), 'SECURE')) : $a))) {
          if ($truthy(node['$option?']("inline"))) {
            img = ($truthy($a = self.$read_svg_contents(node, target)) ? $a : "" + "<span class=\"alt\">" + (node.$alt()) + "</span>")
          } else if ($truthy(node['$option?']("interactive"))) {
            
            fallback = (function() {if ($truthy(node['$attr?']("fallback"))) {
              return "" + "<img src=\"" + (node.$image_uri(node.$attr("fallback"))) + "\" alt=\"" + (self.$encode_attribute_value(node.$alt())) + "\"" + (width_attr) + (height_attr) + (self.void_element_slash) + ">"
            } else {
              return "" + "<span class=\"alt\">" + (node.$alt()) + "</span>"
            }; return nil; })();
            img = "" + "<object type=\"image/svg+xml\" data=\"" + (node.$image_uri(target)) + "\"" + (width_attr) + (height_attr) + ">" + (fallback) + "</object>";
          } else {
            img = "" + "<img src=\"" + (node.$image_uri(target)) + "\" alt=\"" + (self.$encode_attribute_value(node.$alt())) + "\"" + (width_attr) + (height_attr) + (self.void_element_slash) + ">"
          }
        } else {
          img = "" + "<img src=\"" + (node.$image_uri(target)) + "\" alt=\"" + (self.$encode_attribute_value(node.$alt())) + "\"" + (width_attr) + (height_attr) + (self.void_element_slash) + ">"
        };
        if ($truthy(node['$attr?']("link"))) {
          img = "" + "<a class=\"image\" href=\"" + (node.$attr("link")) + "\"" + (self.$append_link_constraint_attrs(node).$join()) + ">" + (img) + "</a>"};
        id_attr = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        classes = ["imageblock"];
        if ($truthy(node['$attr?']("float"))) {
          classes['$<<'](node.$attr("float"))};
        if ($truthy(node['$attr?']("align"))) {
          classes['$<<']("" + "text-" + (node.$attr("align")))};
        if ($truthy(node.$role())) {
          classes['$<<'](node.$role())};
        class_attr = "" + " class=\"" + (classes.$join(" ")) + "\"";
        title_el = (function() {if ($truthy(node['$title?']())) {
          return "" + "\n<div class=\"title\">" + (node.$captioned_title()) + "</div>"
        } else {
          return ""
        }; return nil; })();
        return "" + "<div" + (id_attr) + (class_attr) + ">\n" + "<div class=\"content\">\n" + (img) + "\n" + "</div>" + (title_el) + "\n" + "</div>";
      }, $Html5Converter_convert_image$25.$$arity = 1);
      
      Opal.def(self, '$convert_listing', $Html5Converter_convert_listing$26 = function $$convert_listing(node) {
        var $a, self = this, nowrap = nil, lang = nil, syntax_hl = nil, opts = nil, doc_attrs = nil, $writer = nil, pre_open = nil, pre_close = nil, id_attribute = nil, title_element = nil, role = nil;

        
        nowrap = ($truthy($a = node['$option?']("nowrap")) ? $a : node.$document()['$attr?']("prewrap")['$!']());
        if (node.$style()['$==']("source")) {
          
          lang = node.$attr("language");
          if ($truthy((syntax_hl = node.$document().$syntax_highlighter()))) {
            
            opts = (function() {if ($truthy(syntax_hl['$highlight?']())) {
              return $hash2(["css_mode", "style"], {"css_mode": ($truthy($a = (doc_attrs = node.$document().$attributes())['$[]']("" + (syntax_hl.$name()) + "-css")) ? $a : "class").$to_sym(), "style": doc_attrs['$[]']("" + (syntax_hl.$name()) + "-style")})
            } else {
              return $hash2([], {})
            }; return nil; })();
            
            $writer = ["nowrap", nowrap];
            $send(opts, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
          } else {
            
            pre_open = "" + "<pre class=\"highlight" + ((function() {if ($truthy(nowrap)) {
              return " nowrap"
            } else {
              return ""
            }; return nil; })()) + "\"><code" + ((function() {if ($truthy(lang)) {
              return "" + " class=\"language-" + (lang) + "\" data-lang=\"" + (lang) + "\""
            } else {
              return ""
            }; return nil; })()) + ">";
            pre_close = "</code></pre>";
          };
        } else {
          
          pre_open = "" + "<pre" + ((function() {if ($truthy(nowrap)) {
            return " class=\"nowrap\""
          } else {
            return ""
          }; return nil; })()) + ">";
          pre_close = "</pre>";
        };
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        title_element = (function() {if ($truthy(node['$title?']())) {
          return "" + "<div class=\"title\">" + (node.$captioned_title()) + "</div>\n"
        } else {
          return ""
        }; return nil; })();
        return "" + "<div" + (id_attribute) + " class=\"listingblock" + ((function() {if ($truthy((role = node.$role()))) {
          return "" + " " + (role)
        } else {
          return ""
        }; return nil; })()) + "\">\n" + (title_element) + "<div class=\"content\">\n" + ((function() {if ($truthy(syntax_hl)) {
          
          return syntax_hl.$format(node, lang, opts);
        } else {
          return $rb_plus($rb_plus(pre_open, ($truthy($a = node.$content()) ? $a : "")), pre_close)
        }; return nil; })()) + "\n" + "</div>\n" + "</div>";
      }, $Html5Converter_convert_listing$26.$$arity = 1);
      
      Opal.def(self, '$convert_literal', $Html5Converter_convert_literal$27 = function $$convert_literal(node) {
        var $a, self = this, id_attribute = nil, title_element = nil, nowrap = nil, role = nil;

        
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        title_element = (function() {if ($truthy(node['$title?']())) {
          return "" + "<div class=\"title\">" + (node.$title()) + "</div>\n"
        } else {
          return ""
        }; return nil; })();
        nowrap = ($truthy($a = node.$document()['$attr?']("prewrap")['$!']()) ? $a : node['$option?']("nowrap"));
        return "" + "<div" + (id_attribute) + " class=\"literalblock" + ((function() {if ($truthy((role = node.$role()))) {
          return "" + " " + (role)
        } else {
          return ""
        }; return nil; })()) + "\">\n" + (title_element) + "<div class=\"content\">\n" + "<pre" + ((function() {if ($truthy(nowrap)) {
          return " class=\"nowrap\""
        } else {
          return ""
        }; return nil; })()) + ">" + (node.$content()) + "</pre>\n" + "</div>\n" + "</div>";
      }, $Html5Converter_convert_literal$27.$$arity = 1);
      
      Opal.def(self, '$convert_stem', $Html5Converter_convert_stem$28 = function $$convert_stem(node) {
        var $a, $b, $$29, self = this, id_attribute = nil, title_element = nil, style = nil, open = nil, close = nil, equation = nil, br = nil, role = nil;

        
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        title_element = (function() {if ($truthy(node['$title?']())) {
          return "" + "<div class=\"title\">" + (node.$title()) + "</div>\n"
        } else {
          return ""
        }; return nil; })();
        $b = $$($nesting, 'BLOCK_MATH_DELIMITERS')['$[]']((style = node.$style().$to_sym())), $a = Opal.to_ary($b), (open = ($a[0] == null ? nil : $a[0])), (close = ($a[1] == null ? nil : $a[1])), $b;
        if ($truthy((equation = node.$content()))) {
          
          if ($truthy((($a = style['$==']("asciimath")) ? equation['$include?']($$($nesting, 'LF')) : style['$==']("asciimath")))) {
            
            br = "" + ($$($nesting, 'LF')) + "<br" + (self.void_element_slash) + ">";
            equation = $send(equation, 'gsub', [$$($nesting, 'StemBreakRx')], ($$29 = function(){var self = $$29.$$s || this, $c;

            return "" + (close) + ($rb_times(br, $rb_minus((($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$count($$($nesting, 'LF')), 1))) + ($$($nesting, 'LF')) + (open)}, $$29.$$s = self, $$29.$$arity = 0, $$29));};
          if ($truthy(($truthy($a = equation['$start_with?'](open)) ? equation['$end_with?'](close) : $a))) {
          } else {
            equation = "" + (open) + (equation) + (close)
          };
        } else {
          equation = ""
        };
        return "" + "<div" + (id_attribute) + " class=\"stemblock" + ((function() {if ($truthy((role = node.$role()))) {
          return "" + " " + (role)
        } else {
          return ""
        }; return nil; })()) + "\">\n" + (title_element) + "<div class=\"content\">\n" + (equation) + "\n" + "</div>\n" + "</div>";
      }, $Html5Converter_convert_stem$28.$$arity = 1);
      
      Opal.def(self, '$convert_olist', $Html5Converter_convert_olist$30 = function $$convert_olist(node) {
        var $$31, self = this, result = nil, id_attribute = nil, classes = nil, class_attribute = nil, type_attribute = nil, keyword = nil, start_attribute = nil, reversed_attribute = nil;

        
        result = [];
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        classes = ["olist", node.$style(), node.$role()].$compact();
        class_attribute = "" + " class=\"" + (classes.$join(" ")) + "\"";
        result['$<<']("" + "<div" + (id_attribute) + (class_attribute) + ">");
        if ($truthy(node['$title?']())) {
          result['$<<']("" + "<div class=\"title\">" + (node.$title()) + "</div>")};
        type_attribute = (function() {if ($truthy((keyword = node.$list_marker_keyword()))) {
          return "" + " type=\"" + (keyword) + "\""
        } else {
          return ""
        }; return nil; })();
        start_attribute = (function() {if ($truthy(node['$attr?']("start"))) {
          return "" + " start=\"" + (node.$attr("start")) + "\""
        } else {
          return ""
        }; return nil; })();
        reversed_attribute = (function() {if ($truthy(node['$option?']("reversed"))) {
          
          return self.$append_boolean_attribute("reversed", self.xml_mode);
        } else {
          return ""
        }; return nil; })();
        result['$<<']("" + "<ol class=\"" + (node.$style()) + "\"" + (type_attribute) + (start_attribute) + (reversed_attribute) + ">");
        $send(node.$items(), 'each', [], ($$31 = function(item){var self = $$31.$$s || this;

        
          
          if (item == null) {
            item = nil;
          };
          if ($truthy(item.$id())) {
            result['$<<']("" + "<li id=\"" + (item.$id()) + "\"" + ((function() {if ($truthy(item.$role())) {
              return "" + " class=\"" + (item.$role()) + "\""
            } else {
              return ""
            }; return nil; })()) + ">")
          } else if ($truthy(item.$role())) {
            result['$<<']("" + "<li class=\"" + (item.$role()) + "\">")
          } else {
            result['$<<']("<li>")
          };
          result['$<<']("" + "<p>" + (item.$text()) + "</p>");
          if ($truthy(item['$blocks?']())) {
            result['$<<'](item.$content())};
          return result['$<<']("</li>");}, $$31.$$s = self, $$31.$$arity = 1, $$31));
        result['$<<']("</ol>");
        result['$<<']("</div>");
        return result.$join($$($nesting, 'LF'));
      }, $Html5Converter_convert_olist$30.$$arity = 1);
      
      Opal.def(self, '$convert_open', $Html5Converter_convert_open$32 = function $$convert_open(node) {
        var $a, $b, $c, self = this, style = nil, id_attr = nil, title_el = nil, role = nil;

        if ((style = node.$style())['$==']("abstract")) {
          if ($truthy((($a = node.$parent()['$=='](node.$document())) ? node.$document().$doctype()['$==']("book") : node.$parent()['$=='](node.$document())))) {
            
            self.$logger().$warn("abstract block cannot be used in a document without a title when doctype is book. Excluding block content.");
            return "";
          } else {
            
            id_attr = (function() {if ($truthy(node.$id())) {
              return "" + " id=\"" + (node.$id()) + "\""
            } else {
              return ""
            }; return nil; })();
            title_el = (function() {if ($truthy(node['$title?']())) {
              return "" + "<div class=\"title\">" + (node.$title()) + "</div>\n"
            } else {
              return ""
            }; return nil; })();
            return "" + "<div" + (id_attr) + " class=\"quoteblock abstract" + ((function() {if ($truthy((role = node.$role()))) {
              return "" + " " + (role)
            } else {
              return ""
            }; return nil; })()) + "\">\n" + (title_el) + "<blockquote>\n" + (node.$content()) + "\n" + "</blockquote>\n" + "</div>";
          }
        } else if ($truthy((($a = style['$==']("partintro")) ? ($truthy($b = ($truthy($c = $rb_gt(node.$level(), 0)) ? $c : node.$parent().$context()['$!=']("section"))) ? $b : node.$document().$doctype()['$!=']("book")) : style['$==']("partintro")))) {
          
          self.$logger().$error("partintro block can only be used when doctype is book and must be a child of a book part. Excluding block content.");
          return "";
        } else {
          
          id_attr = (function() {if ($truthy(node.$id())) {
            return "" + " id=\"" + (node.$id()) + "\""
          } else {
            return ""
          }; return nil; })();
          title_el = (function() {if ($truthy(node['$title?']())) {
            return "" + "<div class=\"title\">" + (node.$title()) + "</div>\n"
          } else {
            return ""
          }; return nil; })();
          return "" + "<div" + (id_attr) + " class=\"openblock" + ((function() {if ($truthy(($truthy($a = style) ? style['$!=']("open") : $a))) {
            return "" + " " + (style)
          } else {
            return ""
          }; return nil; })()) + ((function() {if ($truthy((role = node.$role()))) {
            return "" + " " + (role)
          } else {
            return ""
          }; return nil; })()) + "\">\n" + (title_el) + "<div class=\"content\">\n" + (node.$content()) + "\n" + "</div>\n" + "</div>";
        }
      }, $Html5Converter_convert_open$32.$$arity = 1);
      
      Opal.def(self, '$convert_page_break', $Html5Converter_convert_page_break$33 = function $$convert_page_break(node) {
        var self = this;

        return "<div style=\"page-break-after: always;\"></div>"
      }, $Html5Converter_convert_page_break$33.$$arity = 1);
      
      Opal.def(self, '$convert_paragraph', $Html5Converter_convert_paragraph$34 = function $$convert_paragraph(node) {
        var self = this, attributes = nil;

        
        if ($truthy(node.$role())) {
          attributes = "" + ((function() {if ($truthy(node.$id())) {
            return "" + " id=\"" + (node.$id()) + "\""
          } else {
            return ""
          }; return nil; })()) + " class=\"paragraph " + (node.$role()) + "\""
        } else if ($truthy(node.$id())) {
          attributes = "" + " id=\"" + (node.$id()) + "\" class=\"paragraph\""
        } else {
          attributes = " class=\"paragraph\""
        };
        if ($truthy(node['$title?']())) {
          return "" + "<div" + (attributes) + ">\n" + "<div class=\"title\">" + (node.$title()) + "</div>\n" + "<p>" + (node.$content()) + "</p>\n" + "</div>"
        } else {
          return "" + "<div" + (attributes) + ">\n" + "<p>" + (node.$content()) + "</p>\n" + "</div>"
        };
      }, $Html5Converter_convert_paragraph$34.$$arity = 1);
      Opal.alias(self, "convert_pass", "content_only");
      
      Opal.def(self, '$convert_preamble', $Html5Converter_convert_preamble$35 = function $$convert_preamble(node) {
        var $a, $b, self = this, doc = nil, toc = nil;

        
        if ($truthy(($truthy($a = ($truthy($b = (doc = node.$document())['$attr?']("toc-placement", "preamble")) ? doc['$sections?']() : $b)) ? doc['$attr?']("toc") : $a))) {
          toc = "" + "\n" + "<div id=\"toc\" class=\"" + (doc.$attr("toc-class", "toc")) + "\">\n" + "<div id=\"toctitle\">" + (doc.$attr("toc-title")) + "</div>\n" + (doc.$converter().$convert(doc, "outline")) + "\n" + "</div>"
        } else {
          toc = ""
        };
        return "" + "<div id=\"preamble\">\n" + "<div class=\"sectionbody\">\n" + (node.$content()) + "\n" + "</div>" + (toc) + "\n" + "</div>";
      }, $Html5Converter_convert_preamble$35.$$arity = 1);
      
      Opal.def(self, '$convert_quote', $Html5Converter_convert_quote$36 = function $$convert_quote(node) {
        var $a, self = this, id_attribute = nil, classes = nil, class_attribute = nil, title_element = nil, attribution = nil, citetitle = nil, cite_element = nil, attribution_text = nil, attribution_element = nil;

        
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        classes = ["quoteblock", node.$role()].$compact();
        class_attribute = "" + " class=\"" + (classes.$join(" ")) + "\"";
        title_element = (function() {if ($truthy(node['$title?']())) {
          return "" + "\n<div class=\"title\">" + (node.$title()) + "</div>"
        } else {
          return ""
        }; return nil; })();
        attribution = (function() {if ($truthy(node['$attr?']("attribution"))) {
          
          return node.$attr("attribution");
        } else {
          return nil
        }; return nil; })();
        citetitle = (function() {if ($truthy(node['$attr?']("citetitle"))) {
          
          return node.$attr("citetitle");
        } else {
          return nil
        }; return nil; })();
        if ($truthy(($truthy($a = attribution) ? $a : citetitle))) {
          
          cite_element = (function() {if ($truthy(citetitle)) {
            return "" + "<cite>" + (citetitle) + "</cite>"
          } else {
            return ""
          }; return nil; })();
          attribution_text = (function() {if ($truthy(attribution)) {
            return "" + "&#8212; " + (attribution) + ((function() {if ($truthy(citetitle)) {
              return "" + "<br" + (self.void_element_slash) + ">\n"
            } else {
              return ""
            }; return nil; })())
          } else {
            return ""
          }; return nil; })();
          attribution_element = "" + "\n<div class=\"attribution\">\n" + (attribution_text) + (cite_element) + "\n</div>";
        } else {
          attribution_element = ""
        };
        return "" + "<div" + (id_attribute) + (class_attribute) + ">" + (title_element) + "\n" + "<blockquote>\n" + (node.$content()) + "\n" + "</blockquote>" + (attribution_element) + "\n" + "</div>";
      }, $Html5Converter_convert_quote$36.$$arity = 1);
      
      Opal.def(self, '$convert_thematic_break', $Html5Converter_convert_thematic_break$37 = function $$convert_thematic_break(node) {
        var self = this;

        return "" + "<hr" + (self.void_element_slash) + ">"
      }, $Html5Converter_convert_thematic_break$37.$$arity = 1);
      
      Opal.def(self, '$convert_sidebar', $Html5Converter_convert_sidebar$38 = function $$convert_sidebar(node) {
        var self = this, id_attribute = nil, title_element = nil, role = nil;

        
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        title_element = (function() {if ($truthy(node['$title?']())) {
          return "" + "<div class=\"title\">" + (node.$title()) + "</div>\n"
        } else {
          return ""
        }; return nil; })();
        return "" + "<div" + (id_attribute) + " class=\"sidebarblock" + ((function() {if ($truthy((role = node.$role()))) {
          return "" + " " + (role)
        } else {
          return ""
        }; return nil; })()) + "\">\n" + "<div class=\"content\">\n" + (title_element) + (node.$content()) + "\n" + "</div>\n" + "</div>";
      }, $Html5Converter_convert_sidebar$38.$$arity = 1);
      
      Opal.def(self, '$convert_table', $Html5Converter_convert_table$39 = function $$convert_table(node) {
        var $a, $$40, $$41, self = this, result = nil, id_attribute = nil, frame = nil, classes = nil, stripes = nil, style_attribute = nil, autowidth = nil, tablewidth = nil, role = nil, class_attribute = nil, slash = nil;

        
        result = [];
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        if ((frame = node.$attr("frame", "all", "table-frame"))['$==']("topbot")) {
          frame = "ends"};
        classes = ["tableblock", "" + "frame-" + (frame), "" + "grid-" + (node.$attr("grid", "all", "table-grid"))];
        if ($truthy((stripes = node.$attr("stripes", nil, "table-stripes")))) {
          classes['$<<']("" + "stripes-" + (stripes))};
        style_attribute = "";
        if ($truthy(($truthy($a = (autowidth = node['$option?']("autowidth"))) ? node['$attr?']("width")['$!']() : $a))) {
          classes['$<<']("fit-content")
        } else if ((tablewidth = node.$attr("tablepcwidth"))['$=='](100)) {
          classes['$<<']("stretch")
        } else {
          style_attribute = "" + " style=\"width: " + (tablewidth) + "%;\""
        };
        if ($truthy(node['$attr?']("float"))) {
          classes['$<<'](node.$attr("float"))};
        if ($truthy((role = node.$role()))) {
          classes['$<<'](role)};
        class_attribute = "" + " class=\"" + (classes.$join(" ")) + "\"";
        result['$<<']("" + "<table" + (id_attribute) + (class_attribute) + (style_attribute) + ">");
        if ($truthy(node['$title?']())) {
          result['$<<']("" + "<caption class=\"title\">" + (node.$captioned_title()) + "</caption>")};
        if ($truthy($rb_gt(node.$attr("rowcount"), 0))) {
          
          slash = self.void_element_slash;
          result['$<<']("<colgroup>");
          if ($truthy(autowidth)) {
            result = $rb_plus(result, $$($nesting, 'Array').$new(node.$columns().$size(), "" + "<col" + (slash) + ">"))
          } else {
            $send(node.$columns(), 'each', [], ($$40 = function(col){var self = $$40.$$s || this;

            
              
              if (col == null) {
                col = nil;
              };
              return result['$<<']((function() {if ($truthy(col['$option?']("autowidth"))) {
                return "" + "<col" + (slash) + ">"
              } else {
                return "" + "<col style=\"width: " + (col.$attr("colpcwidth")) + "%;\"" + (slash) + ">"
              }; return nil; })());}, $$40.$$s = self, $$40.$$arity = 1, $$40))
          };
          result['$<<']("</colgroup>");
          $send(node.$rows().$to_h(), 'each', [], ($$41 = function(tsec, rows){var self = $$41.$$s || this, $$42;

          
            
            if (tsec == null) {
              tsec = nil;
            };
            
            if (rows == null) {
              rows = nil;
            };
            if ($truthy(rows['$empty?']())) {
              return nil;};
            result['$<<']("" + "<t" + (tsec) + ">");
            $send(rows, 'each', [], ($$42 = function(row){var self = $$42.$$s || this, $$43;

            
              
              if (row == null) {
                row = nil;
              };
              result['$<<']("<tr>");
              $send(row, 'each', [], ($$43 = function(cell){var self = $$43.$$s || this, $b, cell_content = nil, $case = nil, cell_tag_name = nil, cell_class_attribute = nil, cell_colspan_attribute = nil, cell_rowspan_attribute = nil, cell_style_attribute = nil;

              
                
                if (cell == null) {
                  cell = nil;
                };
                if (tsec['$==']("head")) {
                  cell_content = cell.$text()
                } else {
                  $case = cell.$style();
                  if ("asciidoc"['$===']($case)) {cell_content = "" + "<div class=\"content\">" + (cell.$content()) + "</div>"}
                  else if ("literal"['$===']($case)) {cell_content = "" + "<div class=\"literal\"><pre>" + (cell.$text()) + "</pre></div>"}
                  else {cell_content = (function() {if ($truthy((cell_content = cell.$content())['$empty?']())) {
                    return ""
                  } else {
                    return "" + "<p class=\"tableblock\">" + (cell_content.$join("" + "</p>\n" + "<p class=\"tableblock\">")) + "</p>"
                  }; return nil; })()}
                };
                cell_tag_name = (function() {if ($truthy(($truthy($b = tsec['$==']("head")) ? $b : cell.$style()['$==']("header")))) {
                  return "th"
                } else {
                  return "td"
                }; return nil; })();
                cell_class_attribute = "" + " class=\"tableblock halign-" + (cell.$attr("halign")) + " valign-" + (cell.$attr("valign")) + "\"";
                cell_colspan_attribute = (function() {if ($truthy(cell.$colspan())) {
                  return "" + " colspan=\"" + (cell.$colspan()) + "\""
                } else {
                  return ""
                }; return nil; })();
                cell_rowspan_attribute = (function() {if ($truthy(cell.$rowspan())) {
                  return "" + " rowspan=\"" + (cell.$rowspan()) + "\""
                } else {
                  return ""
                }; return nil; })();
                cell_style_attribute = (function() {if ($truthy(node.$document()['$attr?']("cellbgcolor"))) {
                  return "" + " style=\"background-color: " + (node.$document().$attr("cellbgcolor")) + ";\""
                } else {
                  return ""
                }; return nil; })();
                return result['$<<']("" + "<" + (cell_tag_name) + (cell_class_attribute) + (cell_colspan_attribute) + (cell_rowspan_attribute) + (cell_style_attribute) + ">" + (cell_content) + "</" + (cell_tag_name) + ">");}, $$43.$$s = self, $$43.$$arity = 1, $$43));
              return result['$<<']("</tr>");}, $$42.$$s = self, $$42.$$arity = 1, $$42));
            return result['$<<']("" + "</t" + (tsec) + ">");}, $$41.$$s = self, $$41.$$arity = 2, $$41));};
        result['$<<']("</table>");
        return result.$join($$($nesting, 'LF'));
      }, $Html5Converter_convert_table$39.$$arity = 1);
      
      Opal.def(self, '$convert_toc', $Html5Converter_convert_toc$44 = function $$convert_toc(node) {
        var $a, $b, self = this, doc = nil, id_attr = nil, title_id_attr = nil, title = nil, levels = nil, role = nil;

        
        if ($truthy(($truthy($a = ($truthy($b = (doc = node.$document())['$attr?']("toc-placement", "macro")) ? doc['$sections?']() : $b)) ? doc['$attr?']("toc") : $a))) {
        } else {
          return "<!-- toc disabled -->"
        };
        if ($truthy(node.$id())) {
          
          id_attr = "" + " id=\"" + (node.$id()) + "\"";
          title_id_attr = "" + " id=\"" + (node.$id()) + "title\"";
        } else {
          
          id_attr = " id=\"toc\"";
          title_id_attr = " id=\"toctitle\"";
        };
        title = (function() {if ($truthy(node['$title?']())) {
          return node.$title()
        } else {
          
          return doc.$attr("toc-title");
        }; return nil; })();
        levels = (function() {if ($truthy(node['$attr?']("levels"))) {
          return node.$attr("levels").$to_i()
        } else {
          return nil
        }; return nil; })();
        role = (function() {if ($truthy(node['$role?']())) {
          return node.$role()
        } else {
          
          return doc.$attr("toc-class", "toc");
        }; return nil; })();
        return "" + "<div" + (id_attr) + " class=\"" + (role) + "\">\n" + "<div" + (title_id_attr) + " class=\"title\">" + (title) + "</div>\n" + (doc.$converter().$convert(doc, "outline", $hash2(["toclevels"], {"toclevels": levels}))) + "\n" + "</div>";
      }, $Html5Converter_convert_toc$44.$$arity = 1);
      
      Opal.def(self, '$convert_ulist', $Html5Converter_convert_ulist$45 = function $$convert_ulist(node) {
        var $$46, self = this, result = nil, id_attribute = nil, div_classes = nil, marker_checked = nil, marker_unchecked = nil, checklist = nil, ul_class_attribute = nil;

        
        result = [];
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        div_classes = ["ulist", node.$style(), node.$role()].$compact();
        marker_checked = (marker_unchecked = "");
        if ($truthy((checklist = node['$option?']("checklist")))) {
          
          div_classes.$unshift(div_classes.$shift(), "checklist");
          ul_class_attribute = " class=\"checklist\"";
          if ($truthy(node['$option?']("interactive"))) {
            if ($truthy(self.xml_mode)) {
              
              marker_checked = "<input type=\"checkbox\" data-item-complete=\"1\" checked=\"checked\"/> ";
              marker_unchecked = "<input type=\"checkbox\" data-item-complete=\"0\"/> ";
            } else {
              
              marker_checked = "<input type=\"checkbox\" data-item-complete=\"1\" checked> ";
              marker_unchecked = "<input type=\"checkbox\" data-item-complete=\"0\"> ";
            }
          } else if ($truthy(node.$document()['$attr?']("icons", "font"))) {
            
            marker_checked = "<i class=\"fa fa-check-square-o\"></i> ";
            marker_unchecked = "<i class=\"fa fa-square-o\"></i> ";
          } else {
            
            marker_checked = "&#10003; ";
            marker_unchecked = "&#10063; ";
          };
        } else {
          ul_class_attribute = (function() {if ($truthy(node.$style())) {
            return "" + " class=\"" + (node.$style()) + "\""
          } else {
            return ""
          }; return nil; })()
        };
        result['$<<']("" + "<div" + (id_attribute) + " class=\"" + (div_classes.$join(" ")) + "\">");
        if ($truthy(node['$title?']())) {
          result['$<<']("" + "<div class=\"title\">" + (node.$title()) + "</div>")};
        result['$<<']("" + "<ul" + (ul_class_attribute) + ">");
        $send(node.$items(), 'each', [], ($$46 = function(item){var self = $$46.$$s || this, $a;

        
          
          if (item == null) {
            item = nil;
          };
          if ($truthy(item.$id())) {
            result['$<<']("" + "<li id=\"" + (item.$id()) + "\"" + ((function() {if ($truthy(item.$role())) {
              return "" + " class=\"" + (item.$role()) + "\""
            } else {
              return ""
            }; return nil; })()) + ">")
          } else if ($truthy(item.$role())) {
            result['$<<']("" + "<li class=\"" + (item.$role()) + "\">")
          } else {
            result['$<<']("<li>")
          };
          if ($truthy(($truthy($a = checklist) ? item['$attr?']("checkbox") : $a))) {
            result['$<<']("" + "<p>" + ((function() {if ($truthy(item['$attr?']("checked"))) {
              return marker_checked
            } else {
              return marker_unchecked
            }; return nil; })()) + (item.$text()) + "</p>")
          } else {
            result['$<<']("" + "<p>" + (item.$text()) + "</p>")
          };
          if ($truthy(item['$blocks?']())) {
            result['$<<'](item.$content())};
          return result['$<<']("</li>");}, $$46.$$s = self, $$46.$$arity = 1, $$46));
        result['$<<']("</ul>");
        result['$<<']("</div>");
        return result.$join($$($nesting, 'LF'));
      }, $Html5Converter_convert_ulist$45.$$arity = 1);
      
      Opal.def(self, '$convert_verse', $Html5Converter_convert_verse$47 = function $$convert_verse(node) {
        var $a, self = this, id_attribute = nil, classes = nil, class_attribute = nil, title_element = nil, attribution = nil, citetitle = nil, cite_element = nil, attribution_text = nil, attribution_element = nil;

        
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        classes = ["verseblock", node.$role()].$compact();
        class_attribute = "" + " class=\"" + (classes.$join(" ")) + "\"";
        title_element = (function() {if ($truthy(node['$title?']())) {
          return "" + "\n<div class=\"title\">" + (node.$title()) + "</div>"
        } else {
          return ""
        }; return nil; })();
        attribution = (function() {if ($truthy(node['$attr?']("attribution"))) {
          
          return node.$attr("attribution");
        } else {
          return nil
        }; return nil; })();
        citetitle = (function() {if ($truthy(node['$attr?']("citetitle"))) {
          
          return node.$attr("citetitle");
        } else {
          return nil
        }; return nil; })();
        if ($truthy(($truthy($a = attribution) ? $a : citetitle))) {
          
          cite_element = (function() {if ($truthy(citetitle)) {
            return "" + "<cite>" + (citetitle) + "</cite>"
          } else {
            return ""
          }; return nil; })();
          attribution_text = (function() {if ($truthy(attribution)) {
            return "" + "&#8212; " + (attribution) + ((function() {if ($truthy(citetitle)) {
              return "" + "<br" + (self.void_element_slash) + ">\n"
            } else {
              return ""
            }; return nil; })())
          } else {
            return ""
          }; return nil; })();
          attribution_element = "" + "\n<div class=\"attribution\">\n" + (attribution_text) + (cite_element) + "\n</div>";
        } else {
          attribution_element = ""
        };
        return "" + "<div" + (id_attribute) + (class_attribute) + ">" + (title_element) + "\n" + "<pre class=\"content\">" + (node.$content()) + "</pre>" + (attribution_element) + "\n" + "</div>";
      }, $Html5Converter_convert_verse$47.$$arity = 1);
      
      Opal.def(self, '$convert_video', $Html5Converter_convert_video$48 = function $$convert_video(node) {
        var $a, $b, self = this, xml = nil, id_attribute = nil, classes = nil, class_attribute = nil, title_element = nil, width_attribute = nil, height_attribute = nil, $case = nil, asset_uri_scheme = nil, start_anchor = nil, delimiter = nil, target = nil, hash = nil, hash_param = nil, autoplay_param = nil, loop_param = nil, muted_param = nil, rel_param_val = nil, start_param = nil, end_param = nil, has_loop_param = nil, mute_param = nil, controls_param = nil, fs_param = nil, fs_attribute = nil, modest_param = nil, theme_param = nil, hl_param = nil, list = nil, list_param = nil, playlist = nil, poster_attribute = nil, val = nil, preload_attribute = nil, start_t = nil, end_t = nil, time_anchor = nil;

        
        xml = self.xml_mode;
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        classes = ["videoblock"];
        if ($truthy(node['$attr?']("float"))) {
          classes['$<<'](node.$attr("float"))};
        if ($truthy(node['$attr?']("align"))) {
          classes['$<<']("" + "text-" + (node.$attr("align")))};
        if ($truthy(node.$role())) {
          classes['$<<'](node.$role())};
        class_attribute = "" + " class=\"" + (classes.$join(" ")) + "\"";
        title_element = (function() {if ($truthy(node['$title?']())) {
          return "" + "\n<div class=\"title\">" + (node.$title()) + "</div>"
        } else {
          return ""
        }; return nil; })();
        width_attribute = (function() {if ($truthy(node['$attr?']("width"))) {
          return "" + " width=\"" + (node.$attr("width")) + "\""
        } else {
          return ""
        }; return nil; })();
        height_attribute = (function() {if ($truthy(node['$attr?']("height"))) {
          return "" + " height=\"" + (node.$attr("height")) + "\""
        } else {
          return ""
        }; return nil; })();
        return (function() {$case = node.$attr("poster");
        if ("vimeo"['$===']($case)) {
        if ($truthy((asset_uri_scheme = node.$document().$attr("asset-uri-scheme", "https"))['$empty?']())) {
        } else {
          asset_uri_scheme = "" + (asset_uri_scheme) + ":"
        };
        start_anchor = (function() {if ($truthy(node['$attr?']("start"))) {
          return "" + "#at=" + (node.$attr("start"))
        } else {
          return ""
        }; return nil; })();
        delimiter = ["?"];
        $b = node.$attr("target").$split("/", 2), $a = Opal.to_ary($b), (target = ($a[0] == null ? nil : $a[0])), (hash = ($a[1] == null ? nil : $a[1])), $b;
        hash_param = (function() {if ($truthy((hash = ($truthy($a = hash) ? $a : node.$attr("hash"))))) {
          return "" + (($truthy($a = delimiter.$pop()) ? $a : "&amp;")) + "h=" + (hash)
        } else {
          return ""
        }; return nil; })();
        autoplay_param = (function() {if ($truthy(node['$option?']("autoplay"))) {
          return "" + (($truthy($a = delimiter.$pop()) ? $a : "&amp;")) + "autoplay=1"
        } else {
          return ""
        }; return nil; })();
        loop_param = (function() {if ($truthy(node['$option?']("loop"))) {
          return "" + (($truthy($a = delimiter.$pop()) ? $a : "&amp;")) + "loop=1"
        } else {
          return ""
        }; return nil; })();
        muted_param = (function() {if ($truthy(node['$option?']("muted"))) {
          return "" + (($truthy($a = delimiter.$pop()) ? $a : "&amp;")) + "muted=1"
        } else {
          return ""
        }; return nil; })();
        return "" + "<div" + (id_attribute) + (class_attribute) + ">" + (title_element) + "\n" + "<div class=\"content\">\n" + "<iframe" + (width_attribute) + (height_attribute) + " src=\"" + (asset_uri_scheme) + "//player.vimeo.com/video/" + (target) + (hash_param) + (autoplay_param) + (loop_param) + (muted_param) + (start_anchor) + "\" frameborder=\"0\"" + ((function() {if ($truthy(node['$option?']("nofullscreen"))) {
          return ""
        } else {
          
          return self.$append_boolean_attribute("allowfullscreen", xml);
        }; return nil; })()) + "></iframe>\n" + "</div>\n" + "</div>";}
        else if ("youtube"['$===']($case)) {
        if ($truthy((asset_uri_scheme = node.$document().$attr("asset-uri-scheme", "https"))['$empty?']())) {
        } else {
          asset_uri_scheme = "" + (asset_uri_scheme) + ":"
        };
        rel_param_val = (function() {if ($truthy(node['$option?']("related"))) {
          return 1
        } else {
          return 0
        }; return nil; })();
        start_param = (function() {if ($truthy(node['$attr?']("start"))) {
          return "" + "&amp;start=" + (node.$attr("start"))
        } else {
          return ""
        }; return nil; })();
        end_param = (function() {if ($truthy(node['$attr?']("end"))) {
          return "" + "&amp;end=" + (node.$attr("end"))
        } else {
          return ""
        }; return nil; })();
        autoplay_param = (function() {if ($truthy(node['$option?']("autoplay"))) {
          return "&amp;autoplay=1"
        } else {
          return ""
        }; return nil; })();
        loop_param = (function() {if ($truthy((has_loop_param = node['$option?']("loop")))) {
          return "&amp;loop=1"
        } else {
          return ""
        }; return nil; })();
        mute_param = (function() {if ($truthy(node['$option?']("muted"))) {
          return "&amp;mute=1"
        } else {
          return ""
        }; return nil; })();
        controls_param = (function() {if ($truthy(node['$option?']("nocontrols"))) {
          return "&amp;controls=0"
        } else {
          return ""
        }; return nil; })();
        if ($truthy(node['$option?']("nofullscreen"))) {
          
          fs_param = "&amp;fs=0";
          fs_attribute = "";
        } else {
          
          fs_param = "";
          fs_attribute = self.$append_boolean_attribute("allowfullscreen", xml);
        };
        modest_param = (function() {if ($truthy(node['$option?']("modest"))) {
          return "&amp;modestbranding=1"
        } else {
          return ""
        }; return nil; })();
        theme_param = (function() {if ($truthy(node['$attr?']("theme"))) {
          return "" + "&amp;theme=" + (node.$attr("theme"))
        } else {
          return ""
        }; return nil; })();
        hl_param = (function() {if ($truthy(node['$attr?']("lang"))) {
          return "" + "&amp;hl=" + (node.$attr("lang"))
        } else {
          return ""
        }; return nil; })();
        $b = node.$attr("target").$split("/", 2), $a = Opal.to_ary($b), (target = ($a[0] == null ? nil : $a[0])), (list = ($a[1] == null ? nil : $a[1])), $b;
        if ($truthy((list = ($truthy($a = list) ? $a : node.$attr("list"))))) {
          list_param = "" + "&amp;list=" + (list)
        } else {
          
          $b = target.$split(",", 2), $a = Opal.to_ary($b), (target = ($a[0] == null ? nil : $a[0])), (playlist = ($a[1] == null ? nil : $a[1])), $b;
          if ($truthy((playlist = ($truthy($a = playlist) ? $a : node.$attr("playlist"))))) {
            list_param = "" + "&amp;playlist=" + (target) + "," + (playlist)
          } else {
            list_param = (function() {if ($truthy(has_loop_param)) {
              return "" + "&amp;playlist=" + (target)
            } else {
              return ""
            }; return nil; })()
          };
        };
        return "" + "<div" + (id_attribute) + (class_attribute) + ">" + (title_element) + "\n" + "<div class=\"content\">\n" + "<iframe" + (width_attribute) + (height_attribute) + " src=\"" + (asset_uri_scheme) + "//www.youtube.com/embed/" + (target) + "?rel=" + (rel_param_val) + (start_param) + (end_param) + (autoplay_param) + (loop_param) + (mute_param) + (controls_param) + (list_param) + (fs_param) + (modest_param) + (theme_param) + (hl_param) + "\" frameborder=\"0\"" + (fs_attribute) + "></iframe>\n" + "</div>\n" + "</div>";}
        else {
        poster_attribute = (function() {if ($truthy((val = node.$attr("poster"))['$nil_or_empty?']())) {
          return ""
        } else {
          return "" + " poster=\"" + (node.$media_uri(val)) + "\""
        }; return nil; })();
        preload_attribute = (function() {if ($truthy((val = node.$attr("preload"))['$nil_or_empty?']())) {
          return ""
        } else {
          return "" + " preload=\"" + (val) + "\""
        }; return nil; })();
        start_t = node.$attr("start");
        end_t = node.$attr("end");
        time_anchor = (function() {if ($truthy(($truthy($a = start_t) ? $a : end_t))) {
          return "" + "#t=" + (($truthy($a = start_t) ? $a : "")) + ((function() {if ($truthy(end_t)) {
            return "" + "," + (end_t)
          } else {
            return ""
          }; return nil; })())
        } else {
          return ""
        }; return nil; })();
        return "" + "<div" + (id_attribute) + (class_attribute) + ">" + (title_element) + "\n" + "<div class=\"content\">\n" + "<video src=\"" + (node.$media_uri(node.$attr("target"))) + (time_anchor) + "\"" + (width_attribute) + (height_attribute) + (poster_attribute) + ((function() {if ($truthy(node['$option?']("autoplay"))) {
          
          return self.$append_boolean_attribute("autoplay", xml);
        } else {
          return ""
        }; return nil; })()) + ((function() {if ($truthy(node['$option?']("muted"))) {
          
          return self.$append_boolean_attribute("muted", xml);
        } else {
          return ""
        }; return nil; })()) + ((function() {if ($truthy(node['$option?']("nocontrols"))) {
          return ""
        } else {
          
          return self.$append_boolean_attribute("controls", xml);
        }; return nil; })()) + ((function() {if ($truthy(node['$option?']("loop"))) {
          
          return self.$append_boolean_attribute("loop", xml);
        } else {
          return ""
        }; return nil; })()) + (preload_attribute) + ">\n" + "Your browser does not support the video tag.\n" + "</video>\n" + "</div>\n" + "</div>";}})();
      }, $Html5Converter_convert_video$48.$$arity = 1);
      
      Opal.def(self, '$convert_inline_anchor', $Html5Converter_convert_inline_anchor$49 = function $$convert_inline_anchor(node) {
        var $a, $b, self = this, $case = nil, path = nil, attrs = nil, text = nil, ref = nil, refid = nil, top = nil, outer = nil;

        return (function() {$case = node.$type();
        if ("xref"['$===']($case)) {
        if ($truthy((path = node.$attributes()['$[]']("path")))) {
          
          attrs = self.$append_link_constraint_attrs(node, (function() {if ($truthy(node.$role())) {
            return ["" + " class=\"" + (node.$role()) + "\""]
          } else {
            return []
          }; return nil; })()).$join();
          text = ($truthy($a = node.$text()) ? $a : path);
        } else {
          
          attrs = (function() {if ($truthy(node.$role())) {
            return "" + " class=\"" + (node.$role()) + "\""
          } else {
            return ""
          }; return nil; })();
          if ($truthy((text = node.$text()))) {
          } else if ($truthy($$($nesting, 'AbstractNode')['$===']((ref = ($truthy($a = (self.refs = ($truthy($b = self.refs) ? $b : node.$document().$catalog()['$[]']("refs")))['$[]']((refid = node.$attributes()['$[]']("refid")))) ? $a : (function() {if ($truthy(refid['$nil_or_empty?']())) {
            
            return (top = self.$get_root_document(node));
          } else {
            return nil
          }; return nil; })()))))) {
            if ($truthy(($truthy($a = (self.resolving_xref = ($truthy($b = self.resolving_xref) ? $b : (outer = true)))) ? outer : $a))) {
              
              if ($truthy((text = ref.$xreftext(node.$attr("xrefstyle", nil, true))))) {
                if ($truthy(text['$include?']("<a"))) {
                  text = text.$gsub($$($nesting, 'DropAnchorRx'), "")}
              } else {
                text = (function() {if ($truthy(top)) {
                  return "[^top]"
                } else {
                  return "" + "[" + (refid) + "]"
                }; return nil; })()
              };
              self.resolving_xref = nil;
            } else {
              text = (function() {if ($truthy(top)) {
                return "[^top]"
              } else {
                return "" + "[" + (refid) + "]"
              }; return nil; })()
            }
          } else {
            text = "" + "[" + (refid) + "]"
          };
        };
        return "" + "<a href=\"" + (node.$target()) + "\"" + (attrs) + ">" + (text) + "</a>";}
        else if ("ref"['$===']($case)) {return "" + "<a id=\"" + (node.$id()) + "\"></a>"}
        else if ("link"['$===']($case)) {
        attrs = (function() {if ($truthy(node.$id())) {
          return ["" + " id=\"" + (node.$id()) + "\""]
        } else {
          return []
        }; return nil; })();
        if ($truthy(node.$role())) {
          attrs['$<<']("" + " class=\"" + (node.$role()) + "\"")};
        if ($truthy(node['$attr?']("title"))) {
          attrs['$<<']("" + " title=\"" + (node.$attr("title")) + "\"")};
        return "" + "<a href=\"" + (node.$target()) + "\"" + (self.$append_link_constraint_attrs(node, attrs).$join()) + ">" + (node.$text()) + "</a>";}
        else if ("bibref"['$===']($case)) {return "" + "<a id=\"" + (node.$id()) + "\"></a>[" + (($truthy($a = node.$reftext()) ? $a : node.$id())) + "]"}
        else {
        self.$logger().$warn("" + "unknown anchor type: " + (node.$type().$inspect()));
        return nil;}})()
      }, $Html5Converter_convert_inline_anchor$49.$$arity = 1);
      
      Opal.def(self, '$convert_inline_break', $Html5Converter_convert_inline_break$50 = function $$convert_inline_break(node) {
        var self = this;

        return "" + (node.$text()) + "<br" + (self.void_element_slash) + ">"
      }, $Html5Converter_convert_inline_break$50.$$arity = 1);
      
      Opal.def(self, '$convert_inline_button', $Html5Converter_convert_inline_button$51 = function $$convert_inline_button(node) {
        var self = this;

        return "" + "<b class=\"button\">" + (node.$text()) + "</b>"
      }, $Html5Converter_convert_inline_button$51.$$arity = 1);
      
      Opal.def(self, '$convert_inline_callout', $Html5Converter_convert_inline_callout$52 = function $$convert_inline_callout(node) {
        var self = this, src = nil, guard = nil;

        if ($truthy(node.$document()['$attr?']("icons", "font"))) {
          return "" + "<i class=\"conum\" data-value=\"" + (node.$text()) + "\"></i><b>(" + (node.$text()) + ")</b>"
        } else if ($truthy(node.$document()['$attr?']("icons"))) {
          
          src = node.$icon_uri("" + "callouts/" + (node.$text()));
          return "" + "<img src=\"" + (src) + "\" alt=\"" + (node.$text()) + "\"" + (self.void_element_slash) + ">";
        } else if ($truthy($$$('::', 'Array')['$===']((guard = node.$attributes()['$[]']("guard"))))) {
          return "" + "&lt;!--<b class=\"conum\">(" + (node.$text()) + ")</b>--&gt;"
        } else {
          return "" + (guard) + "<b class=\"conum\">(" + (node.$text()) + ")</b>"
        }
      }, $Html5Converter_convert_inline_callout$52.$$arity = 1);
      
      Opal.def(self, '$convert_inline_footnote', $Html5Converter_convert_inline_footnote$53 = function $$convert_inline_footnote(node) {
        var self = this, index = nil, id_attr = nil;

        if ($truthy((index = node.$attr("index")))) {
          if (node.$type()['$==']("xref")) {
            return "" + "<sup class=\"footnoteref\">[<a class=\"footnote\" href=\"#_footnotedef_" + (index) + "\" title=\"View footnote.\">" + (index) + "</a>]</sup>"
          } else {
            
            id_attr = (function() {if ($truthy(node.$id())) {
              return "" + " id=\"_footnote_" + (node.$id()) + "\""
            } else {
              return ""
            }; return nil; })();
            return "" + "<sup class=\"footnote\"" + (id_attr) + ">[<a id=\"_footnoteref_" + (index) + "\" class=\"footnote\" href=\"#_footnotedef_" + (index) + "\" title=\"View footnote.\">" + (index) + "</a>]</sup>";
          }
        } else if (node.$type()['$==']("xref")) {
          return "" + "<sup class=\"footnoteref red\" title=\"Unresolved footnote reference.\">[" + (node.$text()) + "]</sup>"
        } else {
          return nil
        }
      }, $Html5Converter_convert_inline_footnote$53.$$arity = 1);
      
      Opal.def(self, '$convert_inline_image', $Html5Converter_convert_inline_image$54 = function $$convert_inline_image(node) {
        var $a, $b, self = this, target = nil, type = nil, icons = nil, i_class_attr_val = nil, attrs = nil, img = nil, fallback = nil, class_attr_val = nil, role = nil;

        
        target = node.$target();
        if ((type = ($truthy($a = node.$type()) ? $a : "image"))['$==']("icon")) {
          if ((icons = node.$document().$attr("icons"))['$==']("font")) {
            
            i_class_attr_val = "" + "fa fa-" + (target);
            if ($truthy(node['$attr?']("size"))) {
              i_class_attr_val = "" + (i_class_attr_val) + " fa-" + (node.$attr("size"))};
            if ($truthy(node['$attr?']("flip"))) {
              i_class_attr_val = "" + (i_class_attr_val) + " fa-flip-" + (node.$attr("flip"))
            } else if ($truthy(node['$attr?']("rotate"))) {
              i_class_attr_val = "" + (i_class_attr_val) + " fa-rotate-" + (node.$attr("rotate"))};
            attrs = (function() {if ($truthy(node['$attr?']("title"))) {
              return "" + " title=\"" + (node.$attr("title")) + "\""
            } else {
              return ""
            }; return nil; })();
            img = "" + "<i class=\"" + (i_class_attr_val) + "\"" + (attrs) + "></i>";
          } else if ($truthy(icons)) {
            
            attrs = (function() {if ($truthy(node['$attr?']("width"))) {
              return "" + " width=\"" + (node.$attr("width")) + "\""
            } else {
              return ""
            }; return nil; })();
            if ($truthy(node['$attr?']("height"))) {
              attrs = "" + (attrs) + " height=\"" + (node.$attr("height")) + "\""};
            if ($truthy(node['$attr?']("title"))) {
              attrs = "" + (attrs) + " title=\"" + (node.$attr("title")) + "\""};
            img = "" + "<img src=\"" + (node.$icon_uri(target)) + "\" alt=\"" + (self.$encode_attribute_value(node.$alt())) + "\"" + (attrs) + (self.void_element_slash) + ">";
          } else {
            img = "" + "[" + (node.$alt()) + "&#93;"
          }
        } else {
          
          attrs = (function() {if ($truthy(node['$attr?']("width"))) {
            return "" + " width=\"" + (node.$attr("width")) + "\""
          } else {
            return ""
          }; return nil; })();
          if ($truthy(node['$attr?']("height"))) {
            attrs = "" + (attrs) + " height=\"" + (node.$attr("height")) + "\""};
          if ($truthy(node['$attr?']("title"))) {
            attrs = "" + (attrs) + " title=\"" + (node.$attr("title")) + "\""};
          if ($truthy(($truthy($a = ($truthy($b = node['$attr?']("format", "svg")) ? $b : target['$include?'](".svg"))) ? $rb_lt(node.$document().$safe(), $$$($$($nesting, 'SafeMode'), 'SECURE')) : $a))) {
            if ($truthy(node['$option?']("inline"))) {
              img = ($truthy($a = self.$read_svg_contents(node, target)) ? $a : "" + "<span class=\"alt\">" + (node.$alt()) + "</span>")
            } else if ($truthy(node['$option?']("interactive"))) {
              
              fallback = (function() {if ($truthy(node['$attr?']("fallback"))) {
                return "" + "<img src=\"" + (node.$image_uri(node.$attr("fallback"))) + "\" alt=\"" + (self.$encode_attribute_value(node.$alt())) + "\"" + (attrs) + (self.void_element_slash) + ">"
              } else {
                return "" + "<span class=\"alt\">" + (node.$alt()) + "</span>"
              }; return nil; })();
              img = "" + "<object type=\"image/svg+xml\" data=\"" + (node.$image_uri(target)) + "\"" + (attrs) + ">" + (fallback) + "</object>";
            } else {
              img = "" + "<img src=\"" + (node.$image_uri(target)) + "\" alt=\"" + (self.$encode_attribute_value(node.$alt())) + "\"" + (attrs) + (self.void_element_slash) + ">"
            }
          } else {
            img = "" + "<img src=\"" + (node.$image_uri(target)) + "\" alt=\"" + (self.$encode_attribute_value(node.$alt())) + "\"" + (attrs) + (self.void_element_slash) + ">"
          };
        };
        if ($truthy(node['$attr?']("link"))) {
          img = "" + "<a class=\"image\" href=\"" + (node.$attr("link")) + "\"" + (self.$append_link_constraint_attrs(node).$join()) + ">" + (img) + "</a>"};
        class_attr_val = type;
        if ($truthy((role = node.$role()))) {
          class_attr_val = (function() {if ($truthy(node['$attr?']("float"))) {
            return "" + (class_attr_val) + " " + (node.$attr("float")) + " " + (role)
          } else {
            return "" + (class_attr_val) + " " + (role)
          }; return nil; })()
        } else if ($truthy(node['$attr?']("float"))) {
          class_attr_val = "" + (class_attr_val) + " " + (node.$attr("float"))};
        return "" + "<span class=\"" + (class_attr_val) + "\">" + (img) + "</span>";
      }, $Html5Converter_convert_inline_image$54.$$arity = 1);
      
      Opal.def(self, '$convert_inline_indexterm', $Html5Converter_convert_inline_indexterm$55 = function $$convert_inline_indexterm(node) {
        var self = this;

        if (node.$type()['$==']("visible")) {
          return node.$text()
        } else {
          return ""
        }
      }, $Html5Converter_convert_inline_indexterm$55.$$arity = 1);
      
      Opal.def(self, '$convert_inline_kbd', $Html5Converter_convert_inline_kbd$56 = function $$convert_inline_kbd(node) {
        var self = this, keys = nil;

        if ((keys = node.$attr("keys")).$size()['$=='](1)) {
          return "" + "<kbd>" + (keys['$[]'](0)) + "</kbd>"
        } else {
          return "" + "<span class=\"keyseq\"><kbd>" + (keys.$join("</kbd>+<kbd>")) + "</kbd></span>"
        }
      }, $Html5Converter_convert_inline_kbd$56.$$arity = 1);
      
      Opal.def(self, '$convert_inline_menu', $Html5Converter_convert_inline_menu$57 = function $$convert_inline_menu(node) {
        var self = this, caret = nil, submenu_joiner = nil, menu = nil, submenus = nil, menuitem = nil;

        
        caret = (function() {if ($truthy(node.$document()['$attr?']("icons", "font"))) {
          return "&#160;<i class=\"fa fa-angle-right caret\"></i> "
        } else {
          return "&#160;<b class=\"caret\">&#8250;</b> "
        }; return nil; })();
        submenu_joiner = "" + "</b>" + (caret) + "<b class=\"submenu\">";
        menu = node.$attr("menu");
        if ($truthy((submenus = node.$attr("submenus"))['$empty?']())) {
          if ($truthy((menuitem = node.$attr("menuitem")))) {
            return "" + "<span class=\"menuseq\"><b class=\"menu\">" + (menu) + "</b>" + (caret) + "<b class=\"menuitem\">" + (menuitem) + "</b></span>"
          } else {
            return "" + "<b class=\"menuref\">" + (menu) + "</b>"
          }
        } else {
          return "" + "<span class=\"menuseq\"><b class=\"menu\">" + (menu) + "</b>" + (caret) + "<b class=\"submenu\">" + (submenus.$join(submenu_joiner)) + "</b>" + (caret) + "<b class=\"menuitem\">" + (node.$attr("menuitem")) + "</b></span>"
        };
      }, $Html5Converter_convert_inline_menu$57.$$arity = 1);
      
      Opal.def(self, '$convert_inline_quoted', $Html5Converter_convert_inline_quoted$58 = function $$convert_inline_quoted(node) {
        var $a, $b, self = this, open = nil, close = nil, tag = nil, class_attr = nil;

        
        $b = $$($nesting, 'QUOTE_TAGS')['$[]'](node.$type()), $a = Opal.to_ary($b), (open = ($a[0] == null ? nil : $a[0])), (close = ($a[1] == null ? nil : $a[1])), (tag = ($a[2] == null ? nil : $a[2])), $b;
        if ($truthy(node.$id())) {
          
          class_attr = (function() {if ($truthy(node.$role())) {
            return "" + " class=\"" + (node.$role()) + "\""
          } else {
            return ""
          }; return nil; })();
          if ($truthy(tag)) {
            return "" + (open.$chop()) + " id=\"" + (node.$id()) + "\"" + (class_attr) + ">" + (node.$text()) + (close)
          } else {
            return "" + "<span id=\"" + (node.$id()) + "\"" + (class_attr) + ">" + (open) + (node.$text()) + (close) + "</span>"
          };
        } else if ($truthy(node.$role())) {
          if ($truthy(tag)) {
            return "" + (open.$chop()) + " class=\"" + (node.$role()) + "\">" + (node.$text()) + (close)
          } else {
            return "" + "<span class=\"" + (node.$role()) + "\">" + (open) + (node.$text()) + (close) + "</span>"
          }
        } else {
          return "" + (open) + (node.$text()) + (close)
        };
      }, $Html5Converter_convert_inline_quoted$58.$$arity = 1);
      
      Opal.def(self, '$read_svg_contents', $Html5Converter_read_svg_contents$59 = function $$read_svg_contents(node, target) {
        var $$60, self = this, svg = nil, old_start_tag = nil, new_start_tag = nil, start_tag_match = nil;

        
        if ($truthy((svg = node.$read_contents(target, $hash2(["start", "normalize", "label", "warn_if_empty"], {"start": node.$document().$attr("imagesdir"), "normalize": true, "label": "SVG", "warn_if_empty": true}))))) {
          
          if ($truthy(svg['$empty?']())) {
            return nil};
          if ($truthy(svg['$start_with?']("<svg"))) {
          } else {
            svg = svg.$sub($$($nesting, 'SvgPreambleRx'), "")
          };
          old_start_tag = (new_start_tag = (start_tag_match = nil));
          $send(["width", "height"], 'each', [], ($$60 = function(dim){var self = $$60.$$s || this, $a, $b;

          
            
            if (dim == null) {
              dim = nil;
            };
            if ($truthy(node['$attr?'](dim))) {
            } else {
              return nil;
            };
            if ($truthy(new_start_tag)) {
            } else {
              
              if ((start_tag_match = ($truthy($a = start_tag_match) ? $a : ($truthy($b = svg.$match($$($nesting, 'SvgStartTagRx'))) ? $b : "no_match")))['$==']("no_match")) {
                return nil;};
              new_start_tag = (old_start_tag = start_tag_match['$[]'](0)).$gsub($$($nesting, 'DimensionAttributeRx'), "");
            };
            return (new_start_tag = "" + (new_start_tag.$chop()) + " " + (dim) + "=\"" + (node.$attr(dim)) + "\">");}, $$60.$$s = self, $$60.$$arity = 1, $$60));
          if ($truthy(new_start_tag)) {
            svg = "" + (new_start_tag) + (svg['$[]'](Opal.Range.$new(old_start_tag.$length(), -1, false)))};};
        return svg;
      }, $Html5Converter_read_svg_contents$59.$$arity = 2);
      self.$private();
      
      Opal.def(self, '$append_boolean_attribute', $Html5Converter_append_boolean_attribute$61 = function $$append_boolean_attribute(name, xml) {
        var self = this;

        if ($truthy(xml)) {
          return "" + " " + (name) + "=\"" + (name) + "\""
        } else {
          return "" + " " + (name)
        }
      }, $Html5Converter_append_boolean_attribute$61.$$arity = 2);
      
      Opal.def(self, '$append_link_constraint_attrs', $Html5Converter_append_link_constraint_attrs$62 = function $$append_link_constraint_attrs(node, attrs) {
        var $a, self = this, rel = nil, window = nil;

        
        
        if (attrs == null) {
          attrs = [];
        };
        if ($truthy(node['$option?']("nofollow"))) {
          rel = "nofollow"};
        if ($truthy((window = node.$attributes()['$[]']("window")))) {
          
          attrs['$<<']("" + " target=\"" + (window) + "\"");
          if ($truthy(($truthy($a = window['$==']("_blank")) ? $a : node['$option?']("noopener")))) {
            attrs['$<<']((function() {if ($truthy(rel)) {
              return "" + " rel=\"" + (rel) + " noopener\""
            } else {
              return " rel=\"noopener\""
            }; return nil; })())};
        } else if ($truthy(rel)) {
          attrs['$<<']("" + " rel=\"" + (rel) + "\"")};
        return attrs;
      }, $Html5Converter_append_link_constraint_attrs$62.$$arity = -2);
      
      Opal.def(self, '$encode_attribute_value', $Html5Converter_encode_attribute_value$63 = function $$encode_attribute_value(val) {
        var self = this;

        if ($truthy(val['$include?']("\""))) {
          
          return val.$gsub("\"", "&quot;");
        } else {
          return val
        }
      }, $Html5Converter_encode_attribute_value$63.$$arity = 1);
      
      Opal.def(self, '$generate_manname_section', $Html5Converter_generate_manname_section$64 = function $$generate_manname_section(node) {
        var $a, self = this, manname_title = nil, next_section = nil, next_section_title = nil, manname_id_attr = nil, manname_id = nil;

        
        manname_title = node.$attr("manname-title", "Name");
        if ($truthy(($truthy($a = (next_section = node.$sections()['$[]'](0))) ? (next_section_title = next_section.$title())['$=='](next_section_title.$upcase()) : $a))) {
          manname_title = manname_title.$upcase()};
        manname_id_attr = (function() {if ($truthy((manname_id = node.$attr("manname-id")))) {
          return "" + " id=\"" + (manname_id) + "\""
        } else {
          return ""
        }; return nil; })();
        return "" + "<h2" + (manname_id_attr) + ">" + (manname_title) + "</h2>\n" + "<div class=\"sectionbody\">\n" + "<p>" + (node.$attr("mannames").$join(", ")) + " - " + (node.$attr("manpurpose")) + "</p>\n" + "</div>";
      }, $Html5Converter_generate_manname_section$64.$$arity = 1);
      
      Opal.def(self, '$get_root_document', $Html5Converter_get_root_document$65 = function $$get_root_document(node) {
        var $a, self = this;

        
        while ($truthy((node = node.$document())['$nested?']())) {
          node = node.$parent_document()
        };
        return node;
      }, $Html5Converter_get_root_document$65.$$arity = 1);
      
      Opal.def(self, '$method_missing', $Html5Converter_method_missing$66 = function $$method_missing(id, $a) {
        var $post_args, args, $b, $iter = $Html5Converter_method_missing$66.$$p, $yield = $iter || nil, self = this, name = nil, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) $Html5Converter_method_missing$66.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        
        
        $post_args = Opal.slice.call(arguments, 1, arguments.length);
        
        args = $post_args;;
        if ($truthy(($truthy($b = (name = id.$to_s())['$start_with?']("convert_")['$!']()) ? self['$handles?'](name) : $b))) {
          
          return $send(self, 'send', ["" + "convert_" + (name)].concat(Opal.to_a(args)));
        } else {
          return $send(self, Opal.find_super_dispatcher(self, 'method_missing', $Html5Converter_method_missing$66, false), $zuper, $iter)
        };
      }, $Html5Converter_method_missing$66.$$arity = -2);
      return (Opal.def(self, '$respond_to_missing?', $Html5Converter_respond_to_missing$ques$67 = function(id, $a) {
        var $post_args, options, $b, self = this, name = nil;

        
        
        $post_args = Opal.slice.call(arguments, 1, arguments.length);
        
        options = $post_args;;
        return ($truthy($b = (name = id.$to_s())['$start_with?']("convert_")['$!']()) ? self['$handles?'](name) : $b);
      }, $Html5Converter_respond_to_missing$ques$67.$$arity = -2), nil) && 'respond_to_missing?';
    })($$($nesting, 'Converter'), $$$($$($nesting, 'Converter'), 'Base'), $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/extensions"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $truthy = Opal.truthy, $hash2 = Opal.hash2, $send = Opal.send, $hash = Opal.hash;

  Opal.add_stubs(['$==', '$[]=', '$config', '$-', '$const_defined?', '$singleton_class?', '$include', '$const_get', '$extend', '$attr_reader', '$merge', '$class', '$update', '$raise', '$document', '$doctype', '$[]', '$+', '$level', '$delete', '$>', '$casecmp', '$new', '$title=', '$sectname=', '$special=', '$fetch', '$numbered=', '$!', '$key?', '$attr?', '$special', '$numbered', '$generate_id', '$title', '$id=', '$update_attributes', '$tr', '$basename', '$create_block', '$assign_caption', '$===', '$parse_blocks', '$empty?', '$include?', '$sub_attributes', '$parse', '$each', '$define_method', '$unshift', '$shift', '$send', '$size', '$binding', '$receiver', '$define_singleton_method', '$instance_exec', '$to_proc', '$call', '$option', '$flatten', '$respond_to?', '$to_s', '$partition', '$to_i', '$<<', '$compact', '$inspect', '$attr_accessor', '$to_set', '$match?', '$resolve_regexp', '$method', '$register', '$values', '$groups', '$arity', '$activate', '$add_document_processor', '$any?', '$select', '$add_syntax_processor', '$to_sym', '$instance_variable_get', '$kind', '$private', '$join', '$map', '$split', '$capitalize', '$instance_variable_set', '$resolve_args', '$enable_dsl', '$singleton_class', '$process_block_given?', '$source_location', '$freeze', '$resolve_class', '$<', '$update_config', '$as_symbol', '$name', '$name=', '$pop', '$-@', '$next_auto_id', '$generate_name']);
  
  if ($$($nesting, 'RUBY_ENGINE')['$==']("opal")) {
  } else {
    nil
  };
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Asciidoctor');

    var $nesting = [self].concat($parent_nesting);

    (function($base, $parent_nesting) {
      var self = $module($base, 'Extensions');

      var $nesting = [self].concat($parent_nesting);

      
      (function($base, $super, $parent_nesting) {
        var self = $klass($base, $super, 'Processor');

        var $nesting = [self].concat($parent_nesting), $Processor_initialize$4, $Processor_update_config$5, $Processor_process$6, $Processor_create_section$7, $Processor_create_block$8, $Processor_create_list$9, $Processor_create_list_item$10, $Processor_create_image_block$11, $Processor_create_inline$12, $Processor_parse_content$13, $Processor_parse_attributes$14, $Processor$15;

        self.$$prototype.config = nil;
        
        (function(self, $parent_nesting) {
          var $nesting = [self].concat($parent_nesting), $config$1, $option$2, $enable_dsl$3;

          
          
          Opal.def(self, '$config', $config$1 = function $$config() {
            var $a, self = this;
            if (self.config == null) self.config = nil;

            return (self.config = ($truthy($a = self.config) ? $a : $hash2([], {})))
          }, $config$1.$$arity = 0);
          
          Opal.def(self, '$option', $option$2 = function $$option(key, default_value) {
            var self = this, $writer = nil;

            
            $writer = [key, default_value];
            $send(self.$config(), '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];
          }, $option$2.$$arity = 2);
          
          Opal.def(self, '$enable_dsl', $enable_dsl$3 = function $$enable_dsl() {
            var self = this;

            if ($truthy(self['$const_defined?']("DSL"))) {
              if ($truthy(self['$singleton_class?']())) {
                return self.$include(self.$const_get("DSL"))
              } else {
                return self.$extend(self.$const_get("DSL"))
              }
            } else {
              return nil
            }
          }, $enable_dsl$3.$$arity = 0);
          return Opal.alias(self, "use_dsl", "enable_dsl");
        })(Opal.get_singleton_class(self), $nesting);
        self.$attr_reader("config");
        
        Opal.def(self, '$initialize', $Processor_initialize$4 = function $$initialize(config) {
          var self = this;

          
          
          if (config == null) {
            config = $hash2([], {});
          };
          return (self.config = self.$class().$config().$merge(config));
        }, $Processor_initialize$4.$$arity = -1);
        
        Opal.def(self, '$update_config', $Processor_update_config$5 = function $$update_config(config) {
          var self = this;

          return self.config.$update(config)
        }, $Processor_update_config$5.$$arity = 1);
        
        Opal.def(self, '$process', $Processor_process$6 = function $$process($a) {
          var $post_args, args, self = this;

          
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          args = $post_args;;
          return self.$raise($$$('::', 'NotImplementedError'), "" + ($$($nesting, 'Processor')) + " subclass " + (self.$class()) + " must implement the #" + ("process") + " method");
        }, $Processor_process$6.$$arity = -1);
        
        Opal.def(self, '$create_section', $Processor_create_section$7 = function $$create_section(parent, title, attrs, opts) {
          var $a, self = this, doc = nil, book = nil, doctype = nil, level = nil, style = nil, sectname = nil, special = nil, sect = nil, $writer = nil, id = nil;

          
          
          if (opts == null) {
            opts = $hash2([], {});
          };
          doc = parent.$document();
          book = (doctype = doc.$doctype())['$==']("book");
          level = ($truthy($a = opts['$[]']("level")) ? $a : $rb_plus(parent.$level(), 1));
          if ($truthy((style = attrs.$delete("style")))) {
            if ($truthy(($truthy($a = book) ? style['$==']("abstract") : $a))) {
              $a = ["chapter", 1], (sectname = $a[0]), (level = $a[1]), $a
            } else {
              
              $a = [style, true], (sectname = $a[0]), (special = $a[1]), $a;
              if (level['$=='](0)) {
                level = 1};
            }
          } else if ($truthy(book)) {
            sectname = (function() {if (level['$=='](0)) {
              return "part"
            } else {
              
              if ($truthy($rb_gt(level, 1))) {
                return "section"
              } else {
                return "chapter"
              };
            }; return nil; })()
          } else if ($truthy((($a = doctype['$==']("manpage")) ? title.$casecmp("synopsis")['$=='](0) : doctype['$==']("manpage")))) {
            $a = ["synopsis", true], (sectname = $a[0]), (special = $a[1]), $a
          } else {
            sectname = "section"
          };
          sect = $$($nesting, 'Section').$new(parent, level);
          $a = [title, sectname], sect['$title=']($a[0]), sect['$sectname=']($a[1]), $a;
          if ($truthy(special)) {
            
            
            $writer = [true];
            $send(sect, 'special=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            if ($truthy(opts.$fetch("numbered", style['$==']("appendix")))) {
              
              $writer = [true];
              $send(sect, 'numbered=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            } else if ($truthy(($truthy($a = opts['$key?']("numbered")['$!']()) ? doc['$attr?']("sectnums", "all") : $a))) {
              
              $writer = [(function() {if ($truthy(($truthy($a = book) ? level['$=='](1) : $a))) {
                return "chapter"
              } else {
                return true
              }; return nil; })()];
              $send(sect, 'numbered=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
          } else if ($truthy($rb_gt(level, 0))) {
            if ($truthy(opts.$fetch("numbered", doc['$attr?']("sectnums")))) {
              
              $writer = [(function() {if ($truthy(sect.$special())) {
                return ($truthy($a = parent.$numbered()) ? true : $a)
              } else {
                return true
              }; return nil; })()];
              $send(sect, 'numbered=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];}
          } else if ($truthy(opts.$fetch("numbered", ($truthy($a = book) ? doc['$attr?']("partnums") : $a)))) {
            
            $writer = [true];
            $send(sect, 'numbered=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          if ((id = attrs['$[]']("id"))['$=='](false)) {
            attrs.$delete("id")
          } else {
            
            $writer = [(($writer = ["id", ($truthy($a = id) ? $a : (function() {if ($truthy(doc['$attr?']("sectids"))) {
              
              return $$($nesting, 'Section').$generate_id(sect.$title(), doc);
            } else {
              return nil
            }; return nil; })())]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])];
            $send(sect, 'id=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          };
          sect.$update_attributes(attrs);
          return sect;
        }, $Processor_create_section$7.$$arity = -4);
        
        Opal.def(self, '$create_block', $Processor_create_block$8 = function $$create_block(parent, context, source, attrs, opts) {
          var self = this;

          
          
          if (opts == null) {
            opts = $hash2([], {});
          };
          return $$($nesting, 'Block').$new(parent, context, $hash2(["source", "attributes"], {"source": source, "attributes": attrs}).$merge(opts));
        }, $Processor_create_block$8.$$arity = -5);
        
        Opal.def(self, '$create_list', $Processor_create_list$9 = function $$create_list(parent, context, attrs) {
          var self = this, list = nil;

          
          
          if (attrs == null) {
            attrs = nil;
          };
          list = $$($nesting, 'List').$new(parent, context);
          if ($truthy(attrs)) {
            list.$update_attributes(attrs)};
          return list;
        }, $Processor_create_list$9.$$arity = -3);
        
        Opal.def(self, '$create_list_item', $Processor_create_list_item$10 = function $$create_list_item(parent, text) {
          var self = this;

          
          
          if (text == null) {
            text = nil;
          };
          return $$($nesting, 'ListItem').$new(parent, text);
        }, $Processor_create_list_item$10.$$arity = -2);
        
        Opal.def(self, '$create_image_block', $Processor_create_image_block$11 = function $$create_image_block(parent, attrs, opts) {
          var $a, self = this, target = nil, $writer = nil, title = nil, block = nil;

          
          
          if (opts == null) {
            opts = $hash2([], {});
          };
          if ($truthy((target = attrs['$[]']("target")))) {
          } else {
            self.$raise($$$('::', 'ArgumentError'), "Unable to create an image block, target attribute is required")
          };
          ($truthy($a = attrs['$[]']("alt")) ? $a : (($writer = ["alt", (($writer = ["default-alt", $$($nesting, 'Helpers').$basename(target, true).$tr("_-", " ")]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
          title = (function() {if ($truthy(attrs['$key?']("title"))) {
            
            return attrs.$delete("title");
          } else {
            return nil
          }; return nil; })();
          block = self.$create_block(parent, "image", nil, attrs, opts);
          if ($truthy(title)) {
            
            
            $writer = [title];
            $send(block, 'title=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            block.$assign_caption(attrs.$delete("caption"), "figure");};
          return block;
        }, $Processor_create_image_block$11.$$arity = -3);
        
        Opal.def(self, '$create_inline', $Processor_create_inline$12 = function $$create_inline(parent, context, text, opts) {
          var self = this;

          
          
          if (opts == null) {
            opts = $hash2([], {});
          };
          return $$($nesting, 'Inline').$new(parent, context, text, (function() {if (context['$==']("quoted")) {
            
            return $hash2(["type"], {"type": "unquoted"}).$merge(opts);
          } else {
            return opts
          }; return nil; })());
        }, $Processor_create_inline$12.$$arity = -4);
        
        Opal.def(self, '$parse_content', $Processor_parse_content$13 = function $$parse_content(parent, content, attributes) {
          var self = this, reader = nil;

          
          
          if (attributes == null) {
            attributes = nil;
          };
          reader = (function() {if ($truthy($$($nesting, 'Reader')['$==='](content))) {
            return content
          } else {
            
            return $$($nesting, 'Reader').$new(content);
          }; return nil; })();
          $$($nesting, 'Parser').$parse_blocks(reader, parent, attributes);
          return parent;
        }, $Processor_parse_content$13.$$arity = -3);
        
        Opal.def(self, '$parse_attributes', $Processor_parse_attributes$14 = function $$parse_attributes(block, attrlist, opts) {
          var $a, self = this;

          
          
          if (opts == null) {
            opts = $hash2([], {});
          };
          if ($truthy((function() {if ($truthy(attrlist)) {
            return attrlist['$empty?']()
          } else {
            return true
          }; return nil; })())) {
            return $hash2([], {})};
          if ($truthy(($truthy($a = opts['$[]']("sub_attributes")) ? attrlist['$include?']($$($nesting, 'ATTR_REF_HEAD')) : $a))) {
            attrlist = block.$sub_attributes(attrlist)};
          return $$($nesting, 'AttributeList').$new(attrlist).$parse(($truthy($a = opts['$[]']("positional_attributes")) ? $a : []));
        }, $Processor_parse_attributes$14.$$arity = -3);
        return $send([["create_paragraph", "create_block", "paragraph"], ["create_open_block", "create_block", "open"], ["create_example_block", "create_block", "example"], ["create_pass_block", "create_block", "pass"], ["create_listing_block", "create_block", "listing"], ["create_literal_block", "create_block", "literal"], ["create_anchor", "create_inline", "anchor"], ["create_inline_pass", "create_inline", "quoted"]], 'each', [], ($Processor$15 = function(method_name, delegate_method_name, context){var self = $Processor$15.$$s || this, $$16;

        
          
          if (method_name == null) {
            method_name = nil;
          };
          
          if (delegate_method_name == null) {
            delegate_method_name = nil;
          };
          
          if (context == null) {
            context = nil;
          };
          return $send(self, 'define_method', [method_name], ($$16 = function($a){var self = $$16.$$s || this, $post_args, args;

          
            
            $post_args = Opal.slice.call(arguments, 0, arguments.length);
            
            args = $post_args;;
            args.$unshift(args.$shift(), context);
            return $send(self, 'send', [delegate_method_name].concat(Opal.to_a(args)));}, $$16.$$s = self, $$16.$$arity = -1, $$16));}, $Processor$15.$$s = self, $Processor$15.$$arity = 3, $Processor$15));
      })($nesting[0], null, $nesting);
      (function($base, $parent_nesting) {
        var self = $module($base, 'ProcessorDsl');

        var $nesting = [self].concat($parent_nesting), $ProcessorDsl_option$17, $ProcessorDsl_process$18, $ProcessorDsl_process_block_given$ques$20;

        
        
        Opal.def(self, '$option', $ProcessorDsl_option$17 = function $$option(key, value) {
          var self = this, $writer = nil;

          
          $writer = [key, value];
          $send(self.$config(), '[]=', Opal.to_a($writer));
          return $writer[$rb_minus($writer["length"], 1)];
        }, $ProcessorDsl_option$17.$$arity = 2);
        
        Opal.def(self, '$process', $ProcessorDsl_process$18 = function $$process($a) {
          var $iter = $ProcessorDsl_process$18.$$p, block = $iter || nil, $post_args, args, $b, $$19, self = this, context = nil;
          if (self.process_block == null) self.process_block = nil;

          if ($iter) $ProcessorDsl_process$18.$$p = null;
          
          
          if ($iter) $ProcessorDsl_process$18.$$p = null;;
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          args = $post_args;;
          if ((block !== nil)) {
            
            if ($truthy(args['$empty?']())) {
            } else {
              self.$raise($$$('::', 'ArgumentError'), "" + "wrong number of arguments (given " + (args.$size()) + ", expected 0)")
            };
            if ($truthy(($truthy($b = block.$binding()) ? self['$=='](block.$binding().$receiver()) : $b))) {
            } else {
              
              context = self;
              $send(block, 'define_singleton_method', ["call"], ($$19 = function($c){var self = $$19.$$s || this, $post_args, m_args;

              
                
                $post_args = Opal.slice.call(arguments, 0, arguments.length);
                
                m_args = $post_args;;
                return $send(context, 'instance_exec', Opal.to_a(m_args), block.$to_proc());}, $$19.$$s = self, $$19.$$arity = -1, $$19));
            };
            return (self.process_block = block);
          } else if ($truthy((($b = self['process_block'], $b != null && $b !== nil) ? 'instance-variable' : nil))) {
            return $send(self.process_block, 'call', Opal.to_a(args))
          } else {
            return self.$raise($$$('::', 'NotImplementedError'), "" + (self.$class()) + " #" + ("process") + " method called before being registered")
          };
        }, $ProcessorDsl_process$18.$$arity = -1);
        
        Opal.def(self, '$process_block_given?', $ProcessorDsl_process_block_given$ques$20 = function() {
          var $a, self = this;

          return (($a = self['process_block'], $a != null && $a !== nil) ? 'instance-variable' : nil)
        }, $ProcessorDsl_process_block_given$ques$20.$$arity = 0);
      })($nesting[0], $nesting);
      (function($base, $parent_nesting) {
        var self = $module($base, 'DocumentProcessorDsl');

        var $nesting = [self].concat($parent_nesting), $DocumentProcessorDsl_prefer$21;

        
        self.$include($$($nesting, 'ProcessorDsl'));
        
        Opal.def(self, '$prefer', $DocumentProcessorDsl_prefer$21 = function $$prefer() {
          var self = this;

          return self.$option("position", ">>")
        }, $DocumentProcessorDsl_prefer$21.$$arity = 0);
      })($nesting[0], $nesting);
      (function($base, $parent_nesting) {
        var self = $module($base, 'SyntaxProcessorDsl');

        var $nesting = [self].concat($parent_nesting), $SyntaxProcessorDsl_named$22, $SyntaxProcessorDsl_content_model$23, $SyntaxProcessorDsl_positional_attributes$24, $SyntaxProcessorDsl_default_attributes$25, $SyntaxProcessorDsl_resolve_attributes$26;

        
        self.$include($$($nesting, 'ProcessorDsl'));
        
        Opal.def(self, '$named', $SyntaxProcessorDsl_named$22 = function $$named(value) {
          var self = this;

          if ($truthy($$($nesting, 'Processor')['$==='](self))) {
            return (self.name = value)
          } else {
            return self.$option("name", value)
          }
        }, $SyntaxProcessorDsl_named$22.$$arity = 1);
        
        Opal.def(self, '$content_model', $SyntaxProcessorDsl_content_model$23 = function $$content_model(value) {
          var self = this;

          return self.$option("content_model", value)
        }, $SyntaxProcessorDsl_content_model$23.$$arity = 1);
        Opal.alias(self, "parse_content_as", "content_model");
        
        Opal.def(self, '$positional_attributes', $SyntaxProcessorDsl_positional_attributes$24 = function $$positional_attributes($a) {
          var $post_args, value, self = this;

          
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          value = $post_args;;
          return self.$option("positional_attrs", value.$flatten());
        }, $SyntaxProcessorDsl_positional_attributes$24.$$arity = -1);
        Opal.alias(self, "name_positional_attributes", "positional_attributes");
        Opal.alias(self, "positional_attrs", "positional_attributes");
        
        Opal.def(self, '$default_attributes', $SyntaxProcessorDsl_default_attributes$25 = function $$default_attributes(value) {
          var self = this;

          return self.$option("default_attrs", value)
        }, $SyntaxProcessorDsl_default_attributes$25.$$arity = 1);
        Opal.alias(self, "default_attrs", "default_attributes");
        
        Opal.def(self, '$resolve_attributes', $SyntaxProcessorDsl_resolve_attributes$26 = function $$resolve_attributes($a) {
          var $post_args, args, $b, $$27, $$28, self = this, $case = nil, names = nil, defaults = nil;

          
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          args = $post_args;;
          if ($truthy($rb_gt(args.$size(), 1))) {
          } else if ($truthy((args = args.$fetch(0, true))['$respond_to?']("to_sym"))) {
            args = [args]};
          return (function() {$case = args;
          if (true['$===']($case)) {
          self.$option("positional_attrs", []);
          return self.$option("default_attrs", $hash2([], {}));}
          else if ($$$('::', 'Array')['$===']($case)) {
          $b = [[], $hash2([], {})], (names = $b[0]), (defaults = $b[1]), $b;
          $send(args, 'each', [], ($$27 = function(arg){var self = $$27.$$s || this, $c, $d, name = nil, _ = nil, value = nil, idx = nil, $writer = nil;

          
            
            if (arg == null) {
              arg = nil;
            };
            if ($truthy((arg = arg.$to_s())['$include?']("="))) {
              
              $d = arg.$partition("="), $c = Opal.to_ary($d), (name = ($c[0] == null ? nil : $c[0])), (_ = ($c[1] == null ? nil : $c[1])), (value = ($c[2] == null ? nil : $c[2])), $d;
              if ($truthy(name['$include?'](":"))) {
                
                $d = name.$partition(":"), $c = Opal.to_ary($d), (idx = ($c[0] == null ? nil : $c[0])), (_ = ($c[1] == null ? nil : $c[1])), (name = ($c[2] == null ? nil : $c[2])), $d;
                idx = (function() {if (idx['$==']("@")) {
                  return names.$size()
                } else {
                  return idx.$to_i()
                }; return nil; })();
                
                $writer = [idx, name];
                $send(names, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;};
              
              $writer = [name, value];
              $send(defaults, '[]=', Opal.to_a($writer));
              return $writer[$rb_minus($writer["length"], 1)];;
            } else if ($truthy(arg['$include?'](":"))) {
              
              $d = arg.$partition(":"), $c = Opal.to_ary($d), (idx = ($c[0] == null ? nil : $c[0])), (_ = ($c[1] == null ? nil : $c[1])), (name = ($c[2] == null ? nil : $c[2])), $d;
              idx = (function() {if (idx['$==']("@")) {
                return names.$size()
              } else {
                return idx.$to_i()
              }; return nil; })();
              
              $writer = [idx, name];
              $send(names, '[]=', Opal.to_a($writer));
              return $writer[$rb_minus($writer["length"], 1)];;
            } else {
              return names['$<<'](arg)
            };}, $$27.$$s = self, $$27.$$arity = 1, $$27));
          self.$option("positional_attrs", names.$compact());
          return self.$option("default_attrs", defaults);}
          else if ($$$('::', 'Hash')['$===']($case)) {
          $b = [[], $hash2([], {})], (names = $b[0]), (defaults = $b[1]), $b;
          $send(args, 'each', [], ($$28 = function(key, val){var self = $$28.$$s || this, $c, $d, name = nil, idx = nil, _ = nil, $writer = nil;

          
            
            if (key == null) {
              key = nil;
            };
            
            if (val == null) {
              val = nil;
            };
            if ($truthy((name = key.$to_s())['$include?'](":"))) {
              
              $d = name.$partition(":"), $c = Opal.to_ary($d), (idx = ($c[0] == null ? nil : $c[0])), (_ = ($c[1] == null ? nil : $c[1])), (name = ($c[2] == null ? nil : $c[2])), $d;
              idx = (function() {if (idx['$==']("@")) {
                return names.$size()
              } else {
                return idx.$to_i()
              }; return nil; })();
              
              $writer = [idx, name];
              $send(names, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;};
            if ($truthy(val)) {
              
              $writer = [name, val];
              $send(defaults, '[]=', Opal.to_a($writer));
              return $writer[$rb_minus($writer["length"], 1)];
            } else {
              return nil
            };}, $$28.$$s = self, $$28.$$arity = 2, $$28));
          self.$option("positional_attrs", names.$compact());
          return self.$option("default_attrs", defaults);}
          else {return self.$raise($$$('::', 'ArgumentError'), "" + "unsupported attributes specification for macro: " + (args.$inspect()))}})();
        }, $SyntaxProcessorDsl_resolve_attributes$26.$$arity = -1);
        Opal.alias(self, "resolves_attributes", "resolve_attributes");
      })($nesting[0], $nesting);
      (function($base, $super, $parent_nesting) {
        var self = $klass($base, $super, 'Preprocessor');

        var $nesting = [self].concat($parent_nesting), $Preprocessor_process$29;

        return (Opal.def(self, '$process', $Preprocessor_process