"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.verifyAppliedPatches = exports.clearPatchApplicationState = exports.savePatchApplicationState = exports.getPatchApplicationState = exports.STATE_FILE_NAME = void 0;
const fs_1 = require("fs");
const path_1 = require("path");
const json_stable_stringify_1 = __importDefault(require("json-stable-stringify"));
const hash_1 = require("./hash");
const chalk_1 = __importDefault(require("chalk"));
const version = 1;
exports.STATE_FILE_NAME = ".patch-package.json";
function getPatchApplicationState(packageDetails) {
    const fileName = path_1.join(packageDetails.path, exports.STATE_FILE_NAME);
    let state = null;
    try {
        state = JSON.parse(fs_1.readFileSync(fileName, "utf8"));
    }
    catch (e) {
        // noop
    }
    if (!state) {
        return null;
    }
    if (state.version !== version) {
        console.log(`You upgraded patch-package and need to fully reinstall node_modules to continue.`);
        process.exit(1);
    }
    return state;
}
exports.getPatchApplicationState = getPatchApplicationState;
function savePatchApplicationState({ packageDetails, patches, isRebasing, }) {
    const fileName = path_1.join(packageDetails.path, exports.STATE_FILE_NAME);
    const state = {
        patches,
        version,
        isRebasing,
    };
    fs_1.writeFileSync(fileName, json_stable_stringify_1.default(state, { space: 4 }), "utf8");
}
exports.savePatchApplicationState = savePatchApplicationState;
function clearPatchApplicationState(packageDetails) {
    const fileName = path_1.join(packageDetails.path, exports.STATE_FILE_NAME);
    try {
        fs_1.unlinkSync(fileName);
    }
    catch (e) {
        // noop
    }
}
exports.clearPatchApplicationState = clearPatchApplicationState;
function verifyAppliedPatches({ appPath, patchDir, state, }) {
    const patchesDirectory = path_1.join(appPath, patchDir);
    for (const patch of state.patches) {
        if (!patch.didApply) {
            break;
        }
        const fullPatchPath = path_1.join(patchesDirectory, patch.patchFilename);
        if (!fs_1.existsSync(fullPatchPath)) {
            console.log(chalk_1.default.blueBright("Expected patch file"), fullPatchPath, "to exist but it is missing. Try removing and reinstalling node_modules first.");
            process.exit(1);
        }
        if (patch.patchContentHash !== hash_1.hashFile(fullPatchPath)) {
            console.log(chalk_1.default.blueBright("Patch file"), fullPatchPath, "has changed since it was applied. Try removing and reinstalling node_modules first.");
            process.exit(1);
        }
    }
}
exports.verifyAppliedPatches = verifyAppliedPatches;
//# sourceMappingURL=data:application/json;base64,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