"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const apg_lib_1 = require("apg-lib");
function infixAssertion(state, chars, phraseIndex, phraseLength, yard) {
    switch (state) {
        case apg_lib_1.ids.SEM_PRE:
            yard.pre("infixAssertion");
            break;
        case apg_lib_1.ids.SEM_POST:
            const { attributePath, infixAssertionOperator, infixAssertionValue } = yard.post("infixAssertion");
            if (attributePath.length !== 1) {
                throw new Error(`INVARIANT: Expected 1 attributePath, but got ${attributePath.length};`);
            }
            if (infixAssertionOperator.length !== 1) {
                throw new Error(`INVARIANT: Expected 1 infixAssertionOperator, but got ${infixAssertionOperator.length};`);
            }
            if (infixAssertionValue.length !== 1) {
                throw new Error(`INVARIANT: Expected 1 infixAssertionValue, but got ${infixAssertionValue.length};`);
            }
            yard.tracks.infixAssertion.push((data) => {
                return infixAssertionOperator[0](attributePath[0], infixAssertionValue[0], data);
            });
            break;
    }
    return apg_lib_1.ids.SEM_OK;
}
exports.infixAssertion = infixAssertion;
//# sourceMappingURL=infixAssertion.js.map