"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const apg_lib_1 = require("apg-lib");
function not(expression, data) {
    return !expression(data);
}
const map = {
    not
};
function prefixLogicalExpressionOperator(state, chars, phraseIndex, phraseLength, yard) {
    switch (state) {
        case apg_lib_1.ids.SEM_PRE:
            break;
        case apg_lib_1.ids.SEM_POST:
            const op = apg_lib_1.utils
                .charsToString(chars, phraseIndex, phraseLength)
                .toLowerCase();
            const fn = map[op];
            if (!fn) {
                throw new Error(`INVARIANT: No such prefix logical expression operator \`${op}\`.`);
            }
            yard.tracks.prefixLogicalExpressionOperator.push(fn);
            break;
    }
    return apg_lib_1.ids.SEM_OK;
}
exports.prefixLogicalExpressionOperator = prefixLogicalExpressionOperator;
//# sourceMappingURL=prefixLogicalExpressionOperator.js.map